/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry;

import com.google.gson.reflect.TypeToken;
import java.util.HashMap;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBInfoUtils;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceFolder;
import org.jkiss.dbeaver.model.DBPDataSourceProvider;
import org.jkiss.dbeaver.model.DBPInformationProvider;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.access.DBAAuthCredentials;
import org.jkiss.dbeaver.model.access.DBAAuthCredentialsWithComplexProperties;
import org.jkiss.dbeaver.model.app.DBPDataSourceRegistry;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.connection.DBPDriverConfigurationType;
import org.jkiss.dbeaver.model.net.DBWHandlerConfiguration;
import org.jkiss.dbeaver.model.net.DBWUtils;
import org.jkiss.dbeaver.model.preferences.DBPPropertyDescriptor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.secret.DBSSecretValue;
import org.jkiss.dbeaver.registry.DataSourceDescriptor;
import org.jkiss.dbeaver.registry.DataSourceNavigatorSettings;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.properties.PropertySourceEditable;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class DataSourceUtils {
    public static final String PARAM_ID = "id";
    public static final String PARAM_DRIVER = "driver";
    public static final String PARAM_NAME = "name";
    public static final String PARAM_URL = "url";
    public static final String PARAM_HOST = "host";
    public static final String PARAM_PORT = "port";
    public static final String PARAM_SERVER = "server";
    public static final String PARAM_DATABASE = "database";
    public static final String PARAM_USER = "user";
    public static final String PROP_JUMP_SERVER = "jumpServer";
    private static final String PARAM_PASSWORD = "password";
    private static final String PARAM_SAVE_PASSWORD = "savePassword";
    private static final String PARAM_AUTH_MODEL = "auth";
    private static final String PARAM_SHOW_SYSTEM_OBJECTS = "showSystemObjects";
    private static final String PARAM_SHOW_UTILITY_OBJECTS = "showUtilityObjects";
    private static final String PARAM_SHOW_ONLY_ENTITIES = "showOnlyEntities";
    private static final String PARAM_HIDE_FOLDERS = "hideFolders";
    private static final String PARAM_HIDE_SCHEMAS = "hideSchemas";
    private static final String PARAM_MERGE_ENTITIES = "mergeEntities";
    private static final String PARAM_FOLDER = "folder";
    private static final String PARAM_AUTO_COMMIT = "autoCommit";
    private static final String PARAM_CREATE = "create";
    private static final String PARAM_SAVE = "save";
    private static final String PREFIX_HANDLER = "handler.";
    private static final String PREFIX_PROP = "prop.";
    private static final String PREFIX_AUTH_PROP = "authProp.";
    private static final String PREFIX_ADVANCED_PROP = "advProp.";
    private static final Log log = Log.getLog(DataSourceUtils.class);

    public static DBPDataSourceContainer getDataSourceBySpec(@NotNull DBPProject project, @NotNull String connectionSpec, @Nullable GeneralUtils.IParameterHandler parameterHandler, boolean searchByParameters, boolean createNewDataSource) {
        DBPDataSourceRegistry dsRegistry;
        String dsIdOrName;
        Object dsName;
        String dsId;
        DBPDataSourceFolder folder;
        HashMap<String, String> advancedProperties;
        HashMap<String, String> authProperties;
        HashMap<String, Map> handlerProps;
        HashMap<String, String> conProperties;
        Boolean autoCommit;
        boolean isTemporary;
        boolean savePassword;
        boolean mergeEntities;
        boolean hideSchemas;
        boolean hideFolders;
        boolean showOnlyEntities;
        boolean showUtilityObjects;
        boolean showSystemObjects;
        String authModelId;
        String password;
        String user;
        String database;
        String server;
        String port;
        String host;
        String url;
        String driverName;
        block122: {
            String[] conParams;
            block121: {
                driverName = null;
                url = null;
                host = null;
                port = null;
                server = null;
                database = null;
                user = null;
                password = null;
                authModelId = null;
                showSystemObjects = false;
                showUtilityObjects = false;
                showOnlyEntities = false;
                hideFolders = false;
                hideSchemas = false;
                mergeEntities = false;
                savePassword = true;
                isTemporary = true;
                autoCommit = null;
                conProperties = new HashMap<String, String>();
                handlerProps = new HashMap<String, Map>();
                authProperties = new HashMap<String, String>();
                advancedProperties = new HashMap<String, String>();
                folder = null;
                dsId = null;
                dsName = null;
                dsIdOrName = null;
                dsRegistry = project.getDataSourceRegistry();
                conParams = connectionSpec.split("\\|");
                if (conParams.length != 1 || conParams[0].indexOf(61) != -1) break block121;
                dsIdOrName = conParams[0];
                break block122;
            }
            String[] stringArray = conParams;
            int n = conParams.length;
            int n2 = 0;
            while (n2 < n) {
                block123: {
                    String cp = stringArray[n2];
                    int divPos = cp.indexOf(61);
                    if (divPos == -1) break block123;
                    String paramName = cp.substring(0, divPos);
                    String paramValue = cp.substring(divPos + 1);
                    switch (paramName) {
                        case "id": {
                            dsId = paramValue;
                            break;
                        }
                        case "driver": {
                            driverName = paramValue;
                            break;
                        }
                        case "name": {
                            dsName = paramValue;
                            break;
                        }
                        case "url": {
                            url = paramValue;
                            break;
                        }
                        case "host": {
                            host = paramValue;
                            break;
                        }
                        case "port": {
                            port = paramValue;
                            break;
                        }
                        case "server": {
                            server = paramValue;
                            break;
                        }
                        case "database": {
                            database = paramValue;
                            break;
                        }
                        case "user": {
                            user = paramValue;
                            break;
                        }
                        case "password": {
                            password = paramValue;
                            break;
                        }
                        case "auth": {
                            authModelId = paramValue;
                            break;
                        }
                        case "savePassword": {
                            savePassword = CommonUtils.toBoolean((Object)paramValue);
                            break;
                        }
                        case "showSystemObjects": {
                            showSystemObjects = CommonUtils.toBoolean((Object)paramValue);
                            break;
                        }
                        case "showUtilityObjects": {
                            showUtilityObjects = CommonUtils.toBoolean((Object)paramValue);
                            break;
                        }
                        case "showOnlyEntities": {
                            showOnlyEntities = CommonUtils.toBoolean((Object)paramValue);
                            break;
                        }
                        case "hideFolders": {
                            hideFolders = CommonUtils.toBoolean((Object)paramValue);
                            break;
                        }
                        case "hideSchemas": {
                            hideSchemas = CommonUtils.toBoolean((Object)paramValue);
                            break;
                        }
                        case "mergeEntities": {
                            mergeEntities = CommonUtils.toBoolean((Object)paramValue);
                            break;
                        }
                        case "folder": {
                            folder = dsRegistry.getFolder(paramValue);
                            break;
                        }
                        case "autoCommit": {
                            autoCommit = CommonUtils.toBoolean((Object)paramValue);
                            break;
                        }
                        case "create": {
                            createNewDataSource = CommonUtils.toBoolean((Object)paramValue);
                            if (parameterHandler == null) break;
                            parameterHandler.setParameter(paramName, paramValue);
                            break;
                        }
                        case "save": {
                            isTemporary = !CommonUtils.toBoolean((Object)paramValue);
                            break;
                        }
                        default: {
                            boolean handled = false;
                            if (paramName.length() > PREFIX_PROP.length() && paramName.startsWith(PREFIX_PROP)) {
                                paramName = paramName.substring(PREFIX_PROP.length());
                                conProperties.put(paramName, paramValue);
                                handled = true;
                            } else if (paramName.length() > PREFIX_AUTH_PROP.length() && paramName.startsWith(PREFIX_AUTH_PROP)) {
                                paramName = paramName.substring(PREFIX_AUTH_PROP.length());
                                authProperties.put(paramName, paramValue);
                                handled = true;
                            } else if (paramName.length() > PREFIX_HANDLER.length() && paramName.startsWith(PREFIX_HANDLER)) {
                                divPos = (paramName = paramName.substring(PREFIX_HANDLER.length())).indexOf(46);
                                if (divPos == -1) {
                                    log.debug((Object)("Wrong handler parameter: '" + paramName + "'"));
                                    break;
                                }
                                String handlerId = paramName.substring(0, divPos);
                                paramName = paramName.substring(divPos + 1);
                                Map handlerPopMap = handlerProps.computeIfAbsent(handlerId, k -> new HashMap());
                                handlerPopMap.put(paramName, paramValue);
                                handled = true;
                            } else if (paramName.startsWith(PREFIX_ADVANCED_PROP)) {
                                String suffix = paramName.substring(PREFIX_ADVANCED_PROP.length());
                                if (!suffix.isEmpty()) {
                                    advancedProperties.put(suffix, paramValue);
                                    handled = true;
                                }
                            } else if (parameterHandler != null) {
                                handled = parameterHandler.setParameter(paramName, paramValue);
                            }
                            if (handled) break;
                            log.debug((Object)("Unknown connection parameter '" + paramName + "'"));
                        }
                    }
                }
                ++n2;
            }
        }
        DBPDataSourceContainer dataSource = null;
        if (dsId != null) {
            dataSource = dsRegistry.getDataSource(dsId);
        } else if (dsName != null) {
            dataSource = dsRegistry.findDataSourceByName(dsName);
        }
        if (dataSource == null && dsIdOrName != null) {
            dataSource = dsRegistry.getDataSource(dsIdOrName);
            if (dataSource == null) {
                dataSource = dsRegistry.findDataSourceByName(dsIdOrName);
            }
            if (dataSource == null) {
                log.error((Object)("Datasource '" + dsIdOrName + "' not found in project '" + project.getName() + "'"));
                return null;
            }
        }
        if (dataSource != null) {
            DBPConnectionConfiguration connConfig = dataSource.getConnectionConfiguration();
            if (!CommonUtils.isEmpty(database)) {
                connConfig.setDatabaseName(database);
            }
            if (!CommonUtils.isEmpty(user)) {
                connConfig.setUserName(user);
            }
            if (!CommonUtils.isEmpty(password)) {
                connConfig.setUserPassword(password);
            }
            if (!CommonUtils.isEmpty(conProperties)) {
                connConfig.setProperties(conProperties);
            }
            if (!CommonUtils.isEmpty(authProperties)) {
                connConfig.setAuthProperties(authProperties);
            }
            if (!CommonUtils.isEmpty(advancedProperties)) {
                connConfig.setProviderProperties(advancedProperties);
            }
            if (!CommonUtils.isEmpty(authModelId)) {
                connConfig.setAuthModelId(authModelId);
            }
            return dataSource;
        }
        if (searchByParameters) {
            if (url != null) {
                for (DBPDataSourceContainer ds : dsRegistry.getDataSources()) {
                    if (!url.equals(ds.getConnectionConfiguration().getUrl()) || user != null && !user.equals(ds.getConnectionConfiguration().getUserName())) continue;
                    return ds;
                }
            } else {
                for (DBPDataSourceContainer ds : dsRegistry.getDataSources()) {
                    DBPConnectionConfiguration cfg = ds.getConnectionConfiguration();
                    if (server != null && !server.equals(cfg.getServerName()) || host != null && !host.equals(cfg.getHostName()) || port != null && !port.equals(cfg.getHostPort()) || database != null && !database.equals(cfg.getDatabaseName()) || user != null && !user.equals(cfg.getUserName())) continue;
                    boolean matched = true;
                    if (!conProperties.isEmpty()) {
                        for (Map.Entry prop : conProperties.entrySet()) {
                            if (CommonUtils.equalObjects((Object)cfg.getProperty((String)prop.getKey()), prop.getValue())) continue;
                            matched = false;
                            break;
                        }
                        if (!matched) continue;
                    }
                    if (!handlerProps.isEmpty()) {
                        for (Map.Entry handlerProp : handlerProps.entrySet()) {
                            DBWHandlerConfiguration handler = cfg.getHandler((String)handlerProp.getKey());
                            if (handler == null) {
                                matched = false;
                                break;
                            }
                            for (Map.Entry prop : ((Map)handlerProp.getValue()).entrySet()) {
                                if (CommonUtils.equalObjects((Object)handler.getProperty((String)prop.getKey()), prop.getValue())) continue;
                                matched = false;
                                break;
                            }
                            if (!matched) break;
                        }
                        if (!matched) continue;
                    }
                    return ds;
                }
            }
        }
        if (!createNewDataSource) {
            return null;
        }
        if (driverName == null) {
            log.error((Object)"Driver name not specified - can't create new datasource");
            return null;
        }
        DBPDriver driver = DBWorkbench.getPlatform().getDataSourceProviderRegistry().findDriver(driverName);
        if (driver == null) {
            log.error((Object)("Driver '" + driverName + "' not found"));
            return null;
        }
        if (dsName == null) {
            dsName = "Ext: " + driver.getName();
            if (database != null) {
                dsName = (String)dsName + " - " + database;
            } else if (server != null) {
                dsName = (String)dsName + " - " + server;
            }
        }
        DBPConnectionConfiguration connConfig = new DBPConnectionConfiguration();
        connConfig.setUrl(url);
        connConfig.setHostName(host);
        connConfig.setHostPort(port);
        connConfig.setServerName(server);
        connConfig.setDatabaseName(database);
        connConfig.setUserName(user);
        connConfig.setUserPassword(password);
        connConfig.setProperties(conProperties);
        connConfig.setProviderProperties(advancedProperties);
        if (!CommonUtils.isEmpty(authProperties)) {
            connConfig.setAuthProperties(authProperties);
        }
        if (!CommonUtils.isEmpty((String)authModelId)) {
            connConfig.setAuthModelId(authModelId);
        }
        if (autoCommit != null) {
            connConfig.getBootstrap().setDefaultAutoCommit(autoCommit);
        }
        DBPDataSourceContainer newDS = dsRegistry.createDataSource(driver, connConfig);
        newDS.setName((String)dsName);
        newDS.setTemporary(isTemporary);
        if (savePassword) {
            newDS.setSavePassword(true);
        }
        if (folder != null) {
            newDS.setFolder(folder);
        }
        DataSourceNavigatorSettings navSettings = ((DataSourceDescriptor)newDS).getNavigatorSettings();
        navSettings.setShowSystemObjects(showSystemObjects);
        navSettings.setShowUtilityObjects(showUtilityObjects);
        navSettings.setShowOnlyEntities(showOnlyEntities);
        navSettings.setHideSchemas(hideSchemas);
        navSettings.setHideFolders(hideFolders);
        navSettings.setMergeEntities(mergeEntities);
        try {
            dsRegistry.addDataSource(newDS);
        }
        catch (DBException e) {
            log.error((Object)e);
        }
        return newDS;
    }

    @NotNull
    public static String getDataSourceAddressText(DBPDataSourceContainer dataSourceContainer) {
        DBPInformationProvider dbpInformationProvider;
        String objectInformation;
        DBPDataSourceProvider dataSourceProvider;
        if (dataSourceContainer.getDriver().isCustomEndpointInformation() && (dataSourceProvider = dataSourceContainer.getDriver().getDataSourceProvider()) instanceof DBPInformationProvider && !CommonUtils.isEmpty((String)(objectInformation = (dbpInformationProvider = (DBPInformationProvider)dataSourceProvider).getObjectInformation((DBPObject)dataSourceContainer, "targetAddress")))) {
            return objectInformation;
        }
        DBPConnectionConfiguration cfg = dataSourceContainer.getConnectionConfiguration();
        if (cfg.getConfigurationType() == DBPDriverConfigurationType.MANUAL) {
            String hostText = DBWUtils.getTargetTunnelHostName((DBPDataSourceContainer)dataSourceContainer, (DBPConnectionConfiguration)cfg);
            String hostPort = cfg.getHostPort();
            String serverName = cfg.getServerName();
            if (CommonUtils.isNotEmpty((String)hostPort)) {
                return hostText + ":" + hostPort;
            }
            if (CommonUtils.isNotEmpty((String)hostText)) {
                return hostText;
            }
            return CommonUtils.notEmpty((String)serverName);
        }
        return cfg.getUrl();
    }

    public static boolean isFolderHasTemporaryDataSources(DBPDataSourceFolder folder) {
        return folder.getDataSourceRegistry().getDataSources().stream().anyMatch(d -> d.getFolder() == folder && d.isTemporary());
    }

    @NotNull
    public static String getJumpServerSettingsPrefix(int index) {
        return PROP_JUMP_SERVER + index + ".";
    }

    public static String getSubjectFromSecret(DBSSecretValue secret) {
        String subjectId = secret.getSubjectId();
        return subjectId == null ? secret.getDisplayName() : subjectId;
    }

    public static String getUserNameFromSecret(DBSSecretValue secret) {
        Object userName;
        Map secretMap = (Map)DBInfoUtils.SECRET_GSON.fromJson(secret.getValue(), new TypeToken<Map<String, Object>>(){}.getType());
        if (secretMap != null && (userName = secretMap.get(PARAM_USER)) != null) {
            return userName.toString();
        }
        return "......";
    }

    public static void updateCredentialsFromProperties(@NotNull DBRProgressMonitor monitor, @NotNull DBAAuthCredentials credentials, @NotNull Map<String, ?> properties) {
        if (credentials instanceof DBAAuthCredentialsWithComplexProperties) {
            DBAAuthCredentialsWithComplexProperties complexProperties = (DBAAuthCredentialsWithComplexProperties)credentials;
            complexProperties.updateCredentialsFromComplexProperties(properties);
        }
        PropertySourceEditable editable = new PropertySourceEditable((Object)credentials, (Object)credentials);
        editable.collectProperties();
        for (Map.Entry<String, ?> entry : properties.entrySet()) {
            String propId = entry.getKey();
            Object propValue = entry.getValue();
            DBPPropertyDescriptor propDesc = editable.getProperty(propId);
            if (propDesc == null) continue;
            try {
                editable.setPropertyValue(monitor, propId, propValue);
            }
            catch (Exception e) {
                log.error((Object)("Error setting credential property '" + propId + "'"), (Throwable)e);
            }
        }
    }
}

