/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.internal;

import java.util.ArrayList;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.dialect.Dialect;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.Value;
import org.hibernate.metamodel.mapping.EmbeddableMappingType;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.SelectableConsumer;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.metamodel.mapping.SelectableMappings;
import org.hibernate.metamodel.mapping.SelectablePath;
import org.hibernate.metamodel.mapping.internal.SelectableMappingImpl;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.query.sqm.function.SqmFunctionRegistry;
import org.hibernate.type.CompositeType;
import org.hibernate.type.EntityType;
import org.hibernate.type.MappingContext;
import org.hibernate.type.Type;
import org.hibernate.type.spi.TypeConfiguration;

public class SelectableMappingsImpl
implements SelectableMappings {
    private final SelectableMapping[] selectableMappings;

    public SelectableMappingsImpl(SelectableMapping[] selectableMappings) {
        this.selectableMappings = selectableMappings;
    }

    private static void resolveJdbcMappings(List<JdbcMapping> jdbcMappings, MappingContext mapping, Type valueType) {
        Type keyType;
        if (valueType instanceof EntityType) {
            EntityType entityType = (EntityType)valueType;
            v0 = entityType.getIdentifierOrUniqueKeyType(mapping);
        } else {
            v0 = keyType = valueType;
        }
        if (keyType instanceof CompositeType) {
            Type[] subtypes;
            CompositeType compositeType = (CompositeType)keyType;
            for (Type subtype : subtypes = compositeType.getSubtypes()) {
                SelectableMappingsImpl.resolveJdbcMappings(jdbcMappings, mapping, subtype);
            }
        } else {
            jdbcMappings.add((JdbcMapping)((Object)keyType));
        }
    }

    public static SelectableMappings from(String containingTableExpression, Value value, int[] propertyOrder, MappingContext mappingContext, TypeConfiguration typeConfiguration, boolean[] insertable, boolean[] updateable, Dialect dialect, SqmFunctionRegistry sqmFunctionRegistry, RuntimeModelCreationContext creationContext) {
        return SelectableMappingsImpl.from(containingTableExpression, value, propertyOrder, null, mappingContext, typeConfiguration, insertable, updateable, dialect, sqmFunctionRegistry, creationContext);
    }

    public static SelectableMappings from(String containingTableExpression, Value value, int[] propertyOrder, @Nullable SelectablePath parentSelectablePath, MappingContext mappingContext, TypeConfiguration typeConfiguration, boolean[] insertable, boolean[] updateable, Dialect dialect, SqmFunctionRegistry sqmFunctionRegistry, RuntimeModelCreationContext creationContext) {
        ArrayList<JdbcMapping> jdbcMappings = new ArrayList<JdbcMapping>();
        SelectableMappingsImpl.resolveJdbcMappings(jdbcMappings, mappingContext, value.getType());
        List<Selectable> selectables = value.getVirtualSelectables();
        SelectableMapping[] selectableMappings = new SelectableMapping[jdbcMappings.size()];
        for (int i = 0; i < selectables.size(); ++i) {
            selectableMappings[propertyOrder[i]] = SelectableMappingImpl.from(containingTableExpression, selectables.get(i), parentSelectablePath, (JdbcMapping)jdbcMappings.get(propertyOrder[i]), typeConfiguration, i < insertable.length && insertable[i], i < updateable.length && updateable[i], false, dialect, sqmFunctionRegistry, creationContext);
        }
        return new SelectableMappingsImpl(selectableMappings);
    }

    public static SelectableMappings from(EmbeddableMappingType embeddableMappingType) {
        int propertySpan = embeddableMappingType.getNumberOfAttributeMappings();
        ArrayList<SelectableMapping> selectableMappings = CollectionHelper.arrayList(propertySpan);
        embeddableMappingType.forEachAttributeMapping((index, attributeMapping) -> attributeMapping.forEachSelectable((columnIndex, selection) -> selectableMappings.add(selection)));
        return new SelectableMappingsImpl(selectableMappings.toArray(new SelectableMapping[0]));
    }

    @Override
    public SelectableMapping getSelectable(int columnIndex) {
        return this.selectableMappings[columnIndex];
    }

    @Override
    public int getJdbcTypeCount() {
        return this.selectableMappings.length;
    }

    @Override
    public int forEachSelectable(int offset, SelectableConsumer consumer) {
        for (int i = 0; i < this.selectableMappings.length; ++i) {
            consumer.accept(offset + i, this.selectableMappings[i]);
        }
        return this.selectableMappings.length;
    }
}

