/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.backend;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.backend.Fir2IrScopeCache;
import org.jetbrains.kotlin.fir.backend.LeakedDeclarationCaches;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.ir.symbols.IrLocalDelegatedPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueParameterSymbol;
import org.jetbrains.kotlin.ir.symbols.IrVariableSymbol;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0006\u0010\t\u001a\u00020\nJ\u0006\u0010\u0010\u001a\u00020\nJ\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020 J1\u0010!\u001a\u0004\u0018\u0001H\"\"\u0004\b\u0000\u0010\"2\u0019\u0010#\u001a\u0015\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u0001H\"0$\u00a2\u0006\u0002\b%H\u0082\b\u00a2\u0006\u0002\u0010&J\u0016\u0010'\u001a\u00020\n2\u0006\u0010(\u001a\u00020\u00142\u0006\u0010)\u001a\u00020\u0012J\u0016\u0010*\u001a\u00020\n2\u0006\u0010+\u001a\u00020\u00182\u0006\u0010,\u001a\u00020\u0016J\u0016\u0010-\u001a\u00020\n2\u0006\u0010.\u001a\u00020\u001c2\u0006\u0010/\u001a\u00020\u001aJ\u0016\u00100\u001a\u00020\n2\u0006\u00101\u001a\u00020 2\u0006\u00102\u001a\u00020\u001eR\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u00020\u00048FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000f\u00a8\u00063"}, d2={"Lorg/jetbrains/kotlin/fir/backend/Fir2IrLocalCallableStorage;", "", "initialStack", "", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrScopeCache;", "<init>", "(Ljava/util/List;)V", "cacheStack", "", "enterCallable", "", "lastCache", "getLastCache$annotations", "()V", "getLastCache", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrScopeCache;", "leaveCallable", "getParameter", "Lorg/jetbrains/kotlin/ir/symbols/IrValueParameterSymbol;", "parameter", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "getVariable", "Lorg/jetbrains/kotlin/ir/symbols/IrVariableSymbol;", "variable", "Lorg/jetbrains/kotlin/fir/declarations/FirVariable;", "getLocalFunctionSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "localFunction", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "getDelegatedProperty", "Lorg/jetbrains/kotlin/ir/symbols/IrLocalDelegatedPropertySymbol;", "property", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "last", "T", "getter", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "putParameter", "firParameter", "irParameterSymbol", "putVariable", "firVariable", "irVariableSymbol", "putLocalFunction", "firFunction", "irFunctionSymbol", "putDelegatedProperty", "firProperty", "irPropertySymbol", "fir2ir"})
@SourceDebugExtension(value={"SMAP\nFir2IrLocalCallableStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Fir2IrLocalCallableStorage.kt\norg/jetbrains/kotlin/fir/backend/Fir2IrLocalCallableStorage\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,77:1\n55#1,2:78\n58#1:81\n55#1,2:82\n58#1:85\n55#1,2:86\n58#1:89\n1#2:80\n1#2:84\n1#2:88\n1#2:90\n*S KotlinDebug\n*F\n+ 1 Fir2IrLocalCallableStorage.kt\norg/jetbrains/kotlin/fir/backend/Fir2IrLocalCallableStorage\n*L\n43#1:78,2\n43#1:81\n47#1:82,2\n47#1:85\n51#1:86,2\n51#1:89\n43#1:80\n47#1:84\n51#1:88\n*E\n"})
public final class Fir2IrLocalCallableStorage {
    @NotNull
    private final List<Fir2IrScopeCache> cacheStack;

    public Fir2IrLocalCallableStorage(@NotNull List<Fir2IrScopeCache> initialStack) {
        Intrinsics.checkNotNullParameter(initialStack, "initialStack");
        this.cacheStack = new ArrayList();
        this.cacheStack.addAll((Collection<Fir2IrScopeCache>)initialStack);
    }

    public final void enterCallable() {
        ((Collection)this.cacheStack).add(new Fir2IrScopeCache());
    }

    @NotNull
    public final Fir2IrScopeCache getLastCache() {
        return CollectionsKt.last(this.cacheStack);
    }

    @LeakedDeclarationCaches
    public static /* synthetic */ void getLastCache$annotations() {
    }

    public final void leaveCallable() {
        CollectionsKt.last(this.cacheStack).clear();
        this.cacheStack.remove(this.cacheStack.size() - 1);
    }

    @Nullable
    public final IrValueParameterSymbol getParameter(@NotNull FirValueParameter parameter) {
        Intrinsics.checkNotNullParameter(parameter, "parameter");
        for (Fir2IrScopeCache cache2 : CollectionsKt.asReversedMutable(this.cacheStack)) {
            IrValueParameterSymbol local = cache2.getParameter(parameter);
            if (local == null) continue;
            return local;
        }
        return null;
    }

    @Nullable
    public final IrVariableSymbol getVariable(@NotNull FirVariable variable) {
        IrVariableSymbol irVariableSymbol;
        block1: {
            Intrinsics.checkNotNullParameter(variable, "variable");
            Fir2IrLocalCallableStorage this_$iv = this;
            boolean $i$f$last = false;
            Iterator<Fir2IrScopeCache> iterator2 = CollectionsKt.asReversedMutable(this_$iv.cacheStack).iterator();
            while (iterator2.hasNext()) {
                Fir2IrScopeCache cache$iv;
                Fir2IrScopeCache $this$getVariable_u24lambda_u240 = cache$iv = iterator2.next();
                boolean bl = false;
                IrVariableSymbol irVariableSymbol2 = $this$getVariable_u24lambda_u240.getVariable(variable);
                if (irVariableSymbol2 == null) continue;
                IrVariableSymbol it$iv = irVariableSymbol2;
                boolean bl2 = false;
                irVariableSymbol = it$iv;
                break block1;
            }
            irVariableSymbol = null;
        }
        return irVariableSymbol;
    }

    @Nullable
    public final IrSimpleFunctionSymbol getLocalFunctionSymbol(@NotNull FirFunction localFunction) {
        IrSimpleFunctionSymbol irSimpleFunctionSymbol;
        block1: {
            Intrinsics.checkNotNullParameter(localFunction, "localFunction");
            Fir2IrLocalCallableStorage this_$iv = this;
            boolean $i$f$last = false;
            Iterator<Fir2IrScopeCache> iterator2 = CollectionsKt.asReversedMutable(this_$iv.cacheStack).iterator();
            while (iterator2.hasNext()) {
                Fir2IrScopeCache cache$iv;
                Fir2IrScopeCache $this$getLocalFunctionSymbol_u24lambda_u240 = cache$iv = iterator2.next();
                boolean bl = false;
                IrSimpleFunctionSymbol irSimpleFunctionSymbol2 = $this$getLocalFunctionSymbol_u24lambda_u240.getLocalFunction(localFunction);
                if (irSimpleFunctionSymbol2 == null) continue;
                IrSimpleFunctionSymbol it$iv = irSimpleFunctionSymbol2;
                boolean bl2 = false;
                irSimpleFunctionSymbol = it$iv;
                break block1;
            }
            irSimpleFunctionSymbol = null;
        }
        return irSimpleFunctionSymbol;
    }

    @Nullable
    public final IrLocalDelegatedPropertySymbol getDelegatedProperty(@NotNull FirProperty property2) {
        IrLocalDelegatedPropertySymbol irLocalDelegatedPropertySymbol;
        block1: {
            Intrinsics.checkNotNullParameter(property2, "property");
            Fir2IrLocalCallableStorage this_$iv = this;
            boolean $i$f$last = false;
            Iterator<Fir2IrScopeCache> iterator2 = CollectionsKt.asReversedMutable(this_$iv.cacheStack).iterator();
            while (iterator2.hasNext()) {
                Fir2IrScopeCache cache$iv;
                Fir2IrScopeCache $this$getDelegatedProperty_u24lambda_u240 = cache$iv = iterator2.next();
                boolean bl = false;
                IrLocalDelegatedPropertySymbol irLocalDelegatedPropertySymbol2 = $this$getDelegatedProperty_u24lambda_u240.getDelegatedProperty(property2);
                if (irLocalDelegatedPropertySymbol2 == null) continue;
                IrLocalDelegatedPropertySymbol it$iv = irLocalDelegatedPropertySymbol2;
                boolean bl2 = false;
                irLocalDelegatedPropertySymbol = it$iv;
                break block1;
            }
            irLocalDelegatedPropertySymbol = null;
        }
        return irLocalDelegatedPropertySymbol;
    }

    public final void putParameter(@NotNull FirValueParameter firParameter, @NotNull IrValueParameterSymbol irParameterSymbol) {
        Intrinsics.checkNotNullParameter(firParameter, "firParameter");
        Intrinsics.checkNotNullParameter(irParameterSymbol, "irParameterSymbol");
        CollectionsKt.last(this.cacheStack).putParameter(firParameter, irParameterSymbol);
    }

    public final void putVariable(@NotNull FirVariable firVariable, @NotNull IrVariableSymbol irVariableSymbol) {
        Intrinsics.checkNotNullParameter(firVariable, "firVariable");
        Intrinsics.checkNotNullParameter(irVariableSymbol, "irVariableSymbol");
        CollectionsKt.last(this.cacheStack).putVariable(firVariable, irVariableSymbol);
    }

    public final void putLocalFunction(@NotNull FirFunction firFunction, @NotNull IrSimpleFunctionSymbol irFunctionSymbol) {
        Intrinsics.checkNotNullParameter(firFunction, "firFunction");
        Intrinsics.checkNotNullParameter(irFunctionSymbol, "irFunctionSymbol");
        CollectionsKt.last(this.cacheStack).putLocalFunction(firFunction, irFunctionSymbol);
    }

    public final void putDelegatedProperty(@NotNull FirProperty firProperty, @NotNull IrLocalDelegatedPropertySymbol irPropertySymbol) {
        Intrinsics.checkNotNullParameter(firProperty, "firProperty");
        Intrinsics.checkNotNullParameter(irPropertySymbol, "irPropertySymbol");
        CollectionsKt.last(this.cacheStack).putDelegatedProperty(firProperty, irPropertySymbol);
    }
}

