/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.common;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.UniversalConnectionPoolLifeCycleState;
import oracle.ucp.diagnostics.DiagnosticsCollectorImpl;
import oracle.ucp.util.UCPErrorHandler;

class UniversalConnectionPoolLifeCycleStateDelayer {
    static final String CLASS_NAME = UniversalConnectionPoolLifeCycleStateDelayer.class.getName();
    private volatile UniversalConnectionPoolLifeCycleState lifeCycleState = UniversalConnectionPoolLifeCycleState.LIFE_CYCLE_STOPPED;
    private static final long POLLING_INTERVAL = 500L;
    private final Lock waitingLock = new ReentrantLock();
    private final Condition waitingCondition = this.waitingLock.newCondition();

    UniversalConnectionPoolLifeCycleStateDelayer() {
    }

    UniversalConnectionPoolLifeCycleState getLifeCycleStateWaitingIfStartingOrStopping() {
        block8: while (true) {
            switch (this.lifeCycleState) {
                case LIFE_CYCLE_STARTING: 
                case LIFE_CYCLE_STOPPING: {
                    try {
                        this.waitingLock.lock();
                        this.waitingCondition.await(500L, TimeUnit.MILLISECONDS);
                        continue block8;
                    }
                    catch (InterruptedException e) {
                        DiagnosticsCollectorImpl.getCommon().trace(Level.WARNING, CLASS_NAME, "getLifeCycleStateWaitingIfStartingOrStopping", "", null, e, new Object[0]);
                        continue block8;
                    }
                    finally {
                        this.waitingLock.unlock();
                        continue block8;
                    }
                }
            }
            break;
        }
        return this.lifeCycleState;
    }

    UniversalConnectionPoolLifeCycleState getCurrentLifeCycleState() {
        return this.lifeCycleState;
    }

    void setLifeCycleState(UniversalConnectionPoolLifeCycleState lifeCycleState) throws UniversalConnectionPoolException {
        try {
            this.waitingLock.lock();
            if (lifeCycleState == UniversalConnectionPoolLifeCycleState.LIFE_CYCLE_STARTING && !this.lifeCycleState.in(UniversalConnectionPoolLifeCycleState.LIFE_CYCLE_STOPPED, UniversalConnectionPoolLifeCycleState.LIFE_CYCLE_FAILED)) {
                UCPErrorHandler.throwUniversalConnectionPoolException(60);
            }
            if (lifeCycleState == UniversalConnectionPoolLifeCycleState.LIFE_CYCLE_STOPPING && !this.lifeCycleState.in(UniversalConnectionPoolLifeCycleState.LIFE_CYCLE_RUNNING, UniversalConnectionPoolLifeCycleState.LIFE_CYCLE_STARTING, UniversalConnectionPoolLifeCycleState.LIFE_CYCLE_FAILED)) {
                UCPErrorHandler.throwUniversalConnectionPoolException(60);
            }
            this.lifeCycleState = lifeCycleState;
            this.waitingCondition.signalAll();
        }
        finally {
            this.waitingLock.unlock();
        }
    }
}

