/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.knn;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class GraphRefreshStats
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, GraphRefreshStats> {
    @Nullable
    private final Long total;
    @Nullable
    private final Long totalTimeInMillis;
    public static final JsonpDeserializer<GraphRefreshStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GraphRefreshStats::setupGraphRefreshStatsDeserializer);

    private GraphRefreshStats(Builder builder) {
        this.total = builder.total;
        this.totalTimeInMillis = builder.totalTimeInMillis;
    }

    public static GraphRefreshStats of(Function<Builder, ObjectBuilder<GraphRefreshStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Long total() {
        return this.total;
    }

    @Nullable
    public final Long totalTimeInMillis() {
        return this.totalTimeInMillis;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.total != null) {
            generator.writeKey("total");
            generator.write(this.total.longValue());
        }
        if (this.totalTimeInMillis != null) {
            generator.writeKey("total_time_in_millis");
            generator.write(this.totalTimeInMillis.longValue());
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupGraphRefreshStatsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::total, JsonpDeserializer.longDeserializer(), "total");
        op.add(Builder::totalTimeInMillis, JsonpDeserializer.longDeserializer(), "total_time_in_millis");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.total);
        result = 31 * result + Objects.hashCode(this.totalTimeInMillis);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GraphRefreshStats other = (GraphRefreshStats)o;
        return Objects.equals(this.total, other.total) && Objects.equals(this.totalTimeInMillis, other.totalTimeInMillis);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, GraphRefreshStats> {
        @Nullable
        private Long total;
        @Nullable
        private Long totalTimeInMillis;

        public Builder() {
        }

        private Builder(GraphRefreshStats o) {
            this.total = o.total;
            this.totalTimeInMillis = o.totalTimeInMillis;
        }

        private Builder(Builder o) {
            this.total = o.total;
            this.totalTimeInMillis = o.totalTimeInMillis;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder total(@Nullable Long value) {
            this.total = value;
            return this;
        }

        @Nonnull
        public final Builder totalTimeInMillis(@Nullable Long value) {
            this.totalTimeInMillis = value;
            return this;
        }

        @Override
        @Nonnull
        public GraphRefreshStats build() {
            this._checkSingleUse();
            return new GraphRefreshStats(this);
        }
    }
}

