/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.blob.BlobContainerClient;
import com.azure.storage.blob.BlobServiceClientBuilder;
import com.azure.storage.blob.BlobServiceVersion;
import com.azure.storage.blob.implementation.AzureBlobStorageImpl;
import com.azure.storage.blob.implementation.AzureBlobStorageImplBuilder;
import com.azure.storage.blob.implementation.models.EncryptionScope;
import com.azure.storage.blob.implementation.models.FilterBlobSegment;
import com.azure.storage.blob.implementation.models.ServicesFilterBlobsHeaders;
import com.azure.storage.blob.implementation.models.ServicesGetAccountInfoHeaders;
import com.azure.storage.blob.implementation.util.ModelHelper;
import com.azure.storage.blob.models.BlobContainerEncryptionScope;
import com.azure.storage.blob.models.BlobContainerItem;
import com.azure.storage.blob.models.BlobContainerListDetails;
import com.azure.storage.blob.models.BlobCorsRule;
import com.azure.storage.blob.models.BlobServiceProperties;
import com.azure.storage.blob.models.BlobServiceStatistics;
import com.azure.storage.blob.models.BlobStorageException;
import com.azure.storage.blob.models.CpkInfo;
import com.azure.storage.blob.models.KeyInfo;
import com.azure.storage.blob.models.ListBlobContainersIncludeType;
import com.azure.storage.blob.models.ListBlobContainersOptions;
import com.azure.storage.blob.models.PublicAccessType;
import com.azure.storage.blob.models.StorageAccountInfo;
import com.azure.storage.blob.models.TaggedBlobItem;
import com.azure.storage.blob.models.UserDelegationKey;
import com.azure.storage.blob.options.BlobContainerCreateOptions;
import com.azure.storage.blob.options.FindBlobsOptions;
import com.azure.storage.blob.options.UndeleteBlobContainerOptions;
import com.azure.storage.common.implementation.AccountSasImplUtil;
import com.azure.storage.common.implementation.Constants;
import com.azure.storage.common.implementation.SasImplUtils;
import com.azure.storage.common.implementation.StorageImplUtils;
import com.azure.storage.common.sas.AccountSasSignatureValues;
import java.net.URI;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.stream.Collectors;

@ServiceClient(builder=BlobServiceClientBuilder.class)
public final class BlobServiceClient {
    private static final ClientLogger LOGGER = new ClientLogger(BlobServiceClient.class);
    private final AzureBlobStorageImpl azureBlobStorage;
    private final String accountName;
    private final BlobServiceVersion serviceVersion;
    private final CpkInfo customerProvidedKey;
    private final EncryptionScope encryptionScope;
    private final BlobContainerEncryptionScope blobContainerEncryptionScope;
    private final boolean anonymousAccess;

    BlobServiceClient(HttpPipeline pipeline, String url, BlobServiceVersion serviceVersion, String accountName, CpkInfo customerProvidedKey, EncryptionScope encryptionScope, BlobContainerEncryptionScope blobContainerEncryptionScope, boolean anonymousAccess) {
        try {
            URI.create(url);
        }
        catch (IllegalArgumentException ex) {
            throw LOGGER.logExceptionAsError((RuntimeException)ex);
        }
        this.azureBlobStorage = new AzureBlobStorageImplBuilder().pipeline(pipeline).url(url).version(serviceVersion.getVersion()).buildClient();
        this.serviceVersion = serviceVersion;
        this.accountName = accountName;
        this.customerProvidedKey = customerProvidedKey;
        this.encryptionScope = encryptionScope;
        this.blobContainerEncryptionScope = blobContainerEncryptionScope;
        this.anonymousAccess = anonymousAccess;
    }

    public BlobContainerClient getBlobContainerClient(String containerName) {
        if (CoreUtils.isNullOrEmpty((CharSequence)containerName)) {
            containerName = "$root";
        }
        return new BlobContainerClient(this.getHttpPipeline(), this.getAccountUrl(), this.getServiceVersion(), this.getAccountName(), containerName, this.customerProvidedKey, this.encryptionScope, this.blobContainerEncryptionScope);
    }

    public HttpPipeline getHttpPipeline() {
        return this.azureBlobStorage.getHttpPipeline();
    }

    public BlobServiceVersion getServiceVersion() {
        return this.serviceVersion;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BlobContainerClient createBlobContainer(String containerName) {
        return (BlobContainerClient)this.createBlobContainerWithResponse(containerName, null, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BlobContainerClient> createBlobContainerWithResponse(String containerName, Map<String, String> metadata, PublicAccessType accessType, Context context) {
        BlobContainerClient client = this.getBlobContainerClient(containerName);
        return new SimpleResponse(client.createWithResponse(metadata, accessType, null, context), (Object)client);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BlobContainerClient createBlobContainerIfNotExists(String containerName) {
        return (BlobContainerClient)this.createBlobContainerIfNotExistsWithResponse(containerName, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BlobContainerClient> createBlobContainerIfNotExistsWithResponse(String containerName, BlobContainerCreateOptions options, Context context) {
        BlobContainerClient client = this.getBlobContainerClient(containerName);
        return new SimpleResponse(client.createIfNotExistsWithResponse(options, null, context), (Object)client);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteBlobContainer(String containerName) {
        this.deleteBlobContainerWithResponse(containerName, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteBlobContainerWithResponse(String containerName, Context context) {
        return this.getBlobContainerClient(containerName).deleteWithResponse(null, null, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public boolean deleteBlobContainerIfExists(String containerName) {
        return (Boolean)this.deleteBlobContainerIfExistsWithResponse(containerName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Boolean> deleteBlobContainerIfExistsWithResponse(String containerName, Context context) {
        return this.getBlobContainerClient(containerName).deleteIfExistsWithResponse(null, null, context);
    }

    public String getAccountUrl() {
        return this.azureBlobStorage.getUrl();
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BlobContainerItem> listBlobContainers() {
        return this.listBlobContainers(new ListBlobContainersOptions(), null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BlobContainerItem> listBlobContainers(ListBlobContainersOptions options, Duration timeout) {
        this.throwOnAnonymousAccess();
        BiFunction<String, Integer, PagedResponse> pageRetriever = (marker, pageSize) -> {
            ListBlobContainersOptions finalOptions = options != null ? options : new ListBlobContainersOptions();
            Integer finalPageSize = pageSize != null ? pageSize : finalOptions.getMaxResultsPerPage();
            return this.listBlobContainersSegment((String)marker, finalOptions.getDetails(), finalOptions.getPrefix(), finalPageSize, timeout);
        };
        return new PagedIterable(pageSize -> (PagedResponse)pageRetriever.apply((String)null, (Integer)pageSize), pageRetriever);
    }

    private PagedResponse<BlobContainerItem> listBlobContainersSegment(String marker, BlobContainerListDetails details, String prefix, Integer maxResultsPerPage, Duration timeout) {
        List<ListBlobContainersIncludeType> include = ModelHelper.toIncludeTypes(details);
        Callable<PagedResponse> operation = () -> this.azureBlobStorage.getServices().listBlobContainersSegmentSinglePage(prefix, marker, maxResultsPerPage, include, null, null, Context.NONE);
        return (PagedResponse)StorageImplUtils.sendRequest(operation, (Duration)timeout, BlobStorageException.class);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<TaggedBlobItem> findBlobsByTags(String query) {
        return this.findBlobsByTags(new FindBlobsOptions(query), null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<TaggedBlobItem> findBlobsByTags(FindBlobsOptions options, Duration timeout, Context context) {
        this.throwOnAnonymousAccess();
        StorageImplUtils.assertNotNull((String)"options", (Object)options);
        BiFunction<String, Integer, PagedResponse> func = (marker, pageSize) -> {
            FindBlobsOptions finalOptions = pageSize != null ? new FindBlobsOptions(options.getQuery()).setMaxResultsPerPage((Integer)pageSize) : options;
            return this.findBlobsByTagsHelper(finalOptions, (String)marker, timeout, context);
        };
        return new PagedIterable(pageSize -> (PagedResponse)func.apply((String)null, (Integer)pageSize), func);
    }

    private PagedResponse<TaggedBlobItem> findBlobsByTagsHelper(FindBlobsOptions options, String marker, Duration timeout, Context context) {
        Context finalContext = context == null ? Context.NONE : context;
        StorageImplUtils.assertNotNull((String)"options", (Object)options);
        Callable<ResponseBase> operation = () -> this.azureBlobStorage.getServices().filterBlobsWithResponse(null, null, options.getQuery(), marker, options.getMaxResultsPerPage(), null, finalContext);
        ResponseBase response = (ResponseBase)StorageImplUtils.sendRequest(operation, (Duration)timeout, BlobStorageException.class);
        List value = ((FilterBlobSegment)response.getValue()).getBlobs().stream().map(ModelHelper::populateTaggedBlobItem).collect(Collectors.toList());
        return new PagedResponseBase(response.getRequest(), response.getStatusCode(), response.getHeaders(), value, ((FilterBlobSegment)response.getValue()).getNextMarker(), (Object)((ServicesFilterBlobsHeaders)response.getDeserializedHeaders()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BlobServiceProperties getProperties() {
        return (BlobServiceProperties)this.getPropertiesWithResponse(null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BlobServiceProperties> getPropertiesWithResponse(Duration timeout, Context context) {
        Context finalContext = context == null ? Context.NONE : context;
        this.throwOnAnonymousAccess();
        Callable<ResponseBase> operation = () -> this.azureBlobStorage.getServices().getPropertiesWithResponse(null, null, finalContext);
        ResponseBase response = (ResponseBase)StorageImplUtils.sendRequest(operation, (Duration)timeout, BlobStorageException.class);
        return new SimpleResponse((Response)response, (Object)((BlobServiceProperties)response.getValue()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void setProperties(BlobServiceProperties properties) {
        this.setPropertiesWithResponse(properties, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> setPropertiesWithResponse(BlobServiceProperties properties, Duration timeout, Context context) {
        BlobServiceProperties finalProperties;
        this.throwOnAnonymousAccess();
        if (properties != null) {
            finalProperties = new BlobServiceProperties();
            finalProperties.setLogging(properties.getLogging());
            if (finalProperties.getLogging() != null) {
                StorageImplUtils.assertNotNull((String)"Logging Version", (Object)finalProperties.getLogging().getVersion());
                ModelHelper.validateRetentionPolicy(finalProperties.getLogging().getRetentionPolicy(), "Logging Retention Policy");
            }
            finalProperties.setHourMetrics(properties.getHourMetrics());
            if (finalProperties.getHourMetrics() != null) {
                StorageImplUtils.assertNotNull((String)"HourMetrics Version", (Object)finalProperties.getHourMetrics().getVersion());
                ModelHelper.validateRetentionPolicy(finalProperties.getHourMetrics().getRetentionPolicy(), "HourMetrics Retention Policy");
                if (finalProperties.getHourMetrics().isEnabled()) {
                    StorageImplUtils.assertNotNull((String)"HourMetrics IncludeApis", (Object)finalProperties.getHourMetrics().isIncludeApis());
                }
            }
            finalProperties.setMinuteMetrics(properties.getMinuteMetrics());
            if (finalProperties.getMinuteMetrics() != null) {
                StorageImplUtils.assertNotNull((String)"MinuteMetrics Version", (Object)finalProperties.getMinuteMetrics().getVersion());
                ModelHelper.validateRetentionPolicy(finalProperties.getMinuteMetrics().getRetentionPolicy(), "MinuteMetrics Retention Policy");
                if (finalProperties.getMinuteMetrics().isEnabled()) {
                    StorageImplUtils.assertNotNull((String)"MinuteMetrics IncludeApis", (Object)finalProperties.getHourMetrics().isIncludeApis());
                }
            }
            ArrayList<BlobCorsRule> corsRules = new ArrayList<BlobCorsRule>();
            for (BlobCorsRule rule : properties.getCors()) {
                corsRules.add(ModelHelper.validatedCorsRule(rule));
            }
            finalProperties.setCors(corsRules);
            finalProperties.setDefaultServiceVersion(properties.getDefaultServiceVersion());
            finalProperties.setDeleteRetentionPolicy(properties.getDeleteRetentionPolicy());
            ModelHelper.validateRetentionPolicy(finalProperties.getDeleteRetentionPolicy(), "DeleteRetentionPolicy Days");
            finalProperties.setStaticWebsite(properties.getStaticWebsite());
        } else {
            finalProperties = null;
        }
        Context finalContext = context == null ? Context.NONE : context;
        Callable<Response> operation = () -> this.azureBlobStorage.getServices().setPropertiesNoCustomHeadersWithResponse(finalProperties, null, null, finalContext);
        return (Response)StorageImplUtils.sendRequest(operation, (Duration)timeout, BlobStorageException.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public UserDelegationKey getUserDelegationKey(OffsetDateTime start, OffsetDateTime expiry) {
        return (UserDelegationKey)this.getUserDelegationKeyWithResponse(start, expiry, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<UserDelegationKey> getUserDelegationKeyWithResponse(OffsetDateTime start, OffsetDateTime expiry, Duration timeout, Context context) {
        StorageImplUtils.assertNotNull((String)"expiry", (Object)expiry);
        if (start != null && !start.isBefore(expiry)) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("`start` must be null or a datetime before `expiry`."));
        }
        this.throwOnAnonymousAccess();
        Context finalContext = context == null ? Context.NONE : context;
        Callable<ResponseBase> operation = () -> this.azureBlobStorage.getServices().getUserDelegationKeyWithResponse(new KeyInfo().setStart(start == null ? "" : Constants.ISO_8601_UTC_DATE_FORMATTER.format(start)).setExpiry(Constants.ISO_8601_UTC_DATE_FORMATTER.format(expiry)), null, null, finalContext);
        ResponseBase response = (ResponseBase)StorageImplUtils.sendRequest(operation, (Duration)timeout, BlobStorageException.class);
        return new SimpleResponse((Response)response, (Object)((UserDelegationKey)response.getValue()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BlobServiceStatistics getStatistics() {
        return (BlobServiceStatistics)this.getStatisticsWithResponse(null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BlobServiceStatistics> getStatisticsWithResponse(Duration timeout, Context context) {
        this.throwOnAnonymousAccess();
        Context finalContext = context == null ? Context.NONE : context;
        Callable<ResponseBase> operation = () -> this.azureBlobStorage.getServices().getStatisticsWithResponse(null, null, finalContext);
        return (Response)StorageImplUtils.sendRequest(operation, (Duration)timeout, BlobStorageException.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public StorageAccountInfo getAccountInfo() {
        return (StorageAccountInfo)this.getAccountInfoWithResponse(null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<StorageAccountInfo> getAccountInfoWithResponse(Duration timeout, Context context) {
        this.throwOnAnonymousAccess();
        Context finalContext = context == null ? Context.NONE : context;
        Callable<ResponseBase> operation = () -> this.azureBlobStorage.getServices().getAccountInfoWithResponse(null, null, finalContext);
        ResponseBase response = (ResponseBase)StorageImplUtils.sendRequest(operation, (Duration)timeout, BlobStorageException.class);
        ServicesGetAccountInfoHeaders hd = (ServicesGetAccountInfoHeaders)response.getDeserializedHeaders();
        return new SimpleResponse((Response)response, (Object)new StorageAccountInfo(hd.getXMsSkuName(), hd.getXMsAccountKind(), hd.isXMsIsHnsEnabled()));
    }

    public String getAccountName() {
        return this.accountName;
    }

    private void throwOnAnonymousAccess() {
        if (this.anonymousAccess) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("Service client cannot be accessed without credentials"));
        }
    }

    public String generateAccountSas(AccountSasSignatureValues accountSasSignatureValues) {
        return this.generateAccountSas(accountSasSignatureValues, Context.NONE);
    }

    public String generateAccountSas(AccountSasSignatureValues accountSasSignatureValues, Context context) {
        return this.generateAccountSas(accountSasSignatureValues, null, context);
    }

    public String generateAccountSas(AccountSasSignatureValues accountSasSignatureValues, Consumer<String> stringToSignHandler, Context context) {
        this.throwOnAnonymousAccess();
        return new AccountSasImplUtil(accountSasSignatureValues, this.encryptionScope == null ? null : this.encryptionScope.getEncryptionScope()).generateSas(SasImplUtils.extractSharedKeyCredential((HttpPipeline)this.getHttpPipeline()), stringToSignHandler, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BlobContainerClient undeleteBlobContainer(String deletedContainerName, String deletedContainerVersion) {
        return (BlobContainerClient)this.undeleteBlobContainerWithResponse(new UndeleteBlobContainerOptions(deletedContainerName, deletedContainerVersion), null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BlobContainerClient> undeleteBlobContainerWithResponse(UndeleteBlobContainerOptions options, Duration timeout, Context context) {
        StorageImplUtils.assertNotNull((String)"options", (Object)options);
        boolean hasOptionalDestinationContainerName = options.getDestinationContainerName() != null;
        String finalDestinationContainerName = hasOptionalDestinationContainerName ? options.getDestinationContainerName() : options.getDeletedContainerName();
        Context finalContext = context == null ? Context.NONE : context;
        Callable<ResponseBase> operation = () -> this.azureBlobStorage.getContainers().restoreWithResponse(finalDestinationContainerName, null, null, options.getDeletedContainerName(), options.getDeletedContainerVersion(), finalContext);
        ResponseBase response = (ResponseBase)StorageImplUtils.sendRequest(operation, (Duration)timeout, BlobStorageException.class);
        return new SimpleResponse((Response)response, (Object)this.getBlobContainerClient(finalDestinationContainerName));
    }
}

