/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.auth;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.core.common.Strings;
import org.opensearch.rule.attribute_extractor.AttributeExtractor;
import org.opensearch.rule.autotagging.Attribute;
import org.opensearch.security.auth.PrincipalAttribute;
import org.opensearch.threadpool.ThreadPool;

public class PrincipalExtractor
implements AttributeExtractor<String> {
    private final ThreadPool threadPool;

    public PrincipalExtractor(ThreadPool threadPool) {
        this.threadPool = threadPool;
    }

    public Attribute getAttribute() {
        return PrincipalAttribute.PRINCIPAL;
    }

    public Iterable<String> extract() {
        ThreadContext threadContext = this.threadPool.getThreadContext();
        String userStr = (String)threadContext.getTransient("_opendistro_security_user_info");
        UserPrincipalInfo userPrincipalInfo = this.parse(userStr);
        ArrayList<String> principals = new ArrayList<String>();
        if (userPrincipalInfo != null) {
            principals.add(String.join((CharSequence)"|", "username", userPrincipalInfo.getUserName()));
            for (String role : userPrincipalInfo.getRoles()) {
                principals.add(String.join((CharSequence)"|", "role", role));
            }
        }
        return principals;
    }

    private UserPrincipalInfo parse(String userString) {
        if (Strings.isNullOrEmpty((String)userString)) {
            return null;
        }
        String[] strs = userString.split("(?<!\\\\)\\|");
        if (strs.length == 0 || Strings.isNullOrEmpty((String)strs[0])) {
            return null;
        }
        String userName = this.unescapePipe(strs[0].trim());
        ArrayList<String> roles = new ArrayList<String>();
        if (strs.length > 2 && !Strings.isNullOrEmpty((String)strs[2])) {
            roles.addAll(Arrays.stream(strs[2].split(",")).map(this::unescapePipe).toList());
        }
        return new UserPrincipalInfo(userName, roles);
    }

    private String unescapePipe(String input) {
        if (input == null) {
            return "";
        }
        return input.replace("\\|", "|");
    }

    public AttributeExtractor.LogicalOperator getLogicalOperator() {
        return AttributeExtractor.LogicalOperator.OR;
    }

    public static class UserPrincipalInfo {
        private final String userName;
        private final List<String> roles;

        public UserPrincipalInfo(String userName, List<String> roles) {
            this.userName = userName;
            this.roles = List.copyOf(roles);
        }

        public String getUserName() {
            return this.userName;
        }

        public List<String> getRoles() {
            return this.roles;
        }
    }
}

