/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.common.messaging.soap;

import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.resolver.CriteriaSet;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.messaging.MessageException;
import org.opensaml.messaging.context.InOutOperationContext;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.RecursiveTypedParentContextLookup;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.messaging.context.SAMLMetadataContext;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.opensaml.saml.common.messaging.context.SAMLProtocolContext;
import org.opensaml.saml.common.messaging.context.SAMLSelfEntityContext;
import org.opensaml.saml.criterion.EntityRoleCriterion;
import org.opensaml.saml.criterion.ProtocolCriterion;
import org.opensaml.saml.criterion.RoleDescriptorCriterion;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.RoleDescriptor;
import org.opensaml.security.credential.UsageType;
import org.opensaml.security.criteria.UsageCriterion;
import org.opensaml.security.messaging.HttpClientSecurityContext;
import org.opensaml.soap.client.SOAPClientContext;
import org.opensaml.soap.client.security.SOAPClientSecurityContext;

public class SAMLSOAPClientContextBuilder<InboundMessageType extends SAMLObject, OutboundMessageType extends SAMLObject> {
    @Nullable
    private OutboundMessageType outboundMessage;
    @Nullable
    private String protocol;
    @Nullable
    private String selfEntityID;
    @Nullable
    private String peerEntityID;
    @Nullable
    private QName peerEntityRole;
    @Nullable
    private EntityDescriptor peerEntityDescriptor;
    @Nullable
    private RoleDescriptor peerRoleDescriptor;
    @Nullable
    private Function<MessageContext, CriteriaSet> tlsCriteriaSetStrategy;
    @Nullable
    private String pipelineName;
    @Nullable
    private String securityConfigurationProfileId;

    @Nullable
    public OutboundMessageType getOutboundMessage() {
        return this.outboundMessage;
    }

    @Nonnull
    public SAMLSOAPClientContextBuilder<InboundMessageType, OutboundMessageType> setOutboundMessage(OutboundMessageType message) {
        this.outboundMessage = message;
        return this;
    }

    @Nullable
    public String getProtocol() {
        return this.protocol;
    }

    @Nonnull
    public SAMLSOAPClientContextBuilder<InboundMessageType, OutboundMessageType> setProtocol(String uri) {
        this.protocol = uri;
        return this;
    }

    @Nullable
    public String getSelfEntityID() {
        return this.selfEntityID;
    }

    @Nonnull
    public SAMLSOAPClientContextBuilder<InboundMessageType, OutboundMessageType> setSelfEntityID(String entityID) {
        this.selfEntityID = entityID;
        return this;
    }

    @Nullable
    public String getPeerEntityID() {
        if (this.peerEntityID != null) {
            return this.peerEntityID;
        }
        EntityDescriptor ed = this.getPeerEntityDescriptor();
        if (ed != null) {
            return ed.getEntityID();
        }
        return null;
    }

    @Nonnull
    public SAMLSOAPClientContextBuilder<InboundMessageType, OutboundMessageType> setPeerEntityID(String entityID) {
        this.peerEntityID = entityID;
        return this;
    }

    @Nullable
    public QName getPeerEntityRole() {
        if (this.peerEntityRole != null) {
            return this.peerEntityRole;
        }
        RoleDescriptor rd = this.getPeerRoleDescriptor();
        if (rd != null) {
            if (rd.getSchemaType() != null) {
                return rd.getSchemaType();
            }
            return rd.getElementQName();
        }
        return null;
    }

    @Nonnull
    public SAMLSOAPClientContextBuilder<InboundMessageType, OutboundMessageType> setPeerEntityRole(QName role) {
        this.peerEntityRole = role;
        return this;
    }

    @Nullable
    public EntityDescriptor getPeerEntityDescriptor() {
        XMLObject roleParent;
        if (this.peerEntityDescriptor != null) {
            return this.peerEntityDescriptor;
        }
        RoleDescriptor rd = this.getPeerRoleDescriptor();
        if (rd != null && (roleParent = rd.getParent()) instanceof EntityDescriptor) {
            EntityDescriptor ed = (EntityDescriptor)roleParent;
            return ed;
        }
        return null;
    }

    @Nonnull
    public SAMLSOAPClientContextBuilder<InboundMessageType, OutboundMessageType> setPeerEntityDescriptor(EntityDescriptor entityDescriptor) {
        this.peerEntityDescriptor = entityDescriptor;
        return this;
    }

    @Nullable
    public RoleDescriptor getPeerRoleDescriptor() {
        return this.peerRoleDescriptor;
    }

    @Nonnull
    public SAMLSOAPClientContextBuilder<InboundMessageType, OutboundMessageType> setPeerRoleDescriptor(RoleDescriptor roleDescriptor) {
        this.peerRoleDescriptor = roleDescriptor;
        return this;
    }

    @Nullable
    public Function<MessageContext, CriteriaSet> getTLSCriteriaSetStrategy() {
        if (this.tlsCriteriaSetStrategy != null) {
            return this.tlsCriteriaSetStrategy;
        }
        return new DefaultTLSCriteriaSetStrategy();
    }

    @Nonnull
    public SAMLSOAPClientContextBuilder<InboundMessageType, OutboundMessageType> setTLSCriteriaSetStrategy(@Nullable Function<MessageContext, CriteriaSet> strategy) {
        this.tlsCriteriaSetStrategy = strategy;
        return this;
    }

    @Nullable
    public String getPipelineName() {
        return this.pipelineName;
    }

    @Nonnull
    public SAMLSOAPClientContextBuilder<InboundMessageType, OutboundMessageType> setPipelineName(@Nullable String name) {
        this.pipelineName = StringSupport.trimOrNull(name);
        return this;
    }

    @Nullable
    public String getSecurityConfigurationProfileId() {
        return this.securityConfigurationProfileId;
    }

    @Nonnull
    public SAMLSOAPClientContextBuilder<InboundMessageType, OutboundMessageType> setSecurityConfigurationProfileId(@Nullable String profileId) {
        this.securityConfigurationProfileId = StringSupport.trimOrNull(profileId);
        return this;
    }

    @Nonnull
    public InOutOperationContext build() throws MessageException {
        QName peerRoleName;
        String peerID;
        String selfID;
        InOutOperationContext opContext;
        if (this.getOutboundMessage() == null) {
            this.errorMissingData("Outbound message");
        }
        MessageContext outboundContext = new MessageContext();
        outboundContext.setMessage(this.getOutboundMessage());
        Function<MessageContext, CriteriaSet> tlsStrategy = this.getTLSCriteriaSetStrategy();
        if (tlsStrategy != null) {
            outboundContext.ensureSubcontext(HttpClientSecurityContext.class).setTLSCriteriaSetStrategy(tlsStrategy);
        }
        InOutOperationContext parent = opContext = new InOutOperationContext(null, outboundContext);
        if (this.getProtocol() != null) {
            parent.ensureSubcontext(SAMLProtocolContext.class).setProtocol(this.getProtocol());
        }
        if (this.getPipelineName() != null) {
            parent.ensureSubcontext(SOAPClientContext.class).setPipelineName(this.getPipelineName());
        }
        if (this.getSecurityConfigurationProfileId() != null) {
            parent.ensureSubcontext(SOAPClientSecurityContext.class).setSecurityConfigurationProfileId(this.getSecurityConfigurationProfileId());
        }
        if ((selfID = this.getSelfEntityID()) != null) {
            SAMLSelfEntityContext selfContext = parent.ensureSubcontext(SAMLSelfEntityContext.class);
            selfContext.setEntityId(selfID);
        }
        if ((peerID = this.getPeerEntityID()) == null) {
            this.errorMissingData("Peer entityID");
        }
        if ((peerRoleName = this.getPeerEntityRole()) == null) {
            this.errorMissingData("Peer role");
        }
        SAMLPeerEntityContext peerContext = parent.ensureSubcontext(SAMLPeerEntityContext.class);
        peerContext.setEntityId(peerID);
        peerContext.setRole(peerRoleName);
        SAMLMetadataContext metadataContext = peerContext.ensureSubcontext(SAMLMetadataContext.class);
        metadataContext.setEntityDescriptor(this.getPeerEntityDescriptor());
        metadataContext.setRoleDescriptor(this.getPeerRoleDescriptor());
        return opContext;
    }

    private void errorMissingData(@Nonnull String details) throws MessageException {
        throw new MessageException("Required context data was not supplied or derivable: " + details);
    }

    public static class DefaultTLSCriteriaSetStrategy
    implements Function<MessageContext, CriteriaSet> {
        @Override
        @Nullable
        public CriteriaSet apply(@Nullable MessageContext messageContext) {
            SAMLPeerEntityContext peerContext;
            String protocol;
            CriteriaSet criteria = new CriteriaSet();
            criteria.add(new UsageCriterion(UsageType.SIGNING));
            if (messageContext == null) {
                return criteria;
            }
            InOutOperationContext parent = new RecursiveTypedParentContextLookup<MessageContext, InOutOperationContext>(InOutOperationContext.class).apply(messageContext);
            if (parent == null) {
                return criteria;
            }
            SAMLProtocolContext protocolContext = parent.getSubcontext(SAMLProtocolContext.class);
            if (protocolContext != null && protocolContext.getProtocol() != null && (protocol = protocolContext.getProtocol()) != null) {
                criteria.add(new ProtocolCriterion(protocol));
            }
            if ((peerContext = parent.getSubcontext(SAMLPeerEntityContext.class)) != null) {
                RoleDescriptor rd;
                SAMLMetadataContext metadataContext;
                QName role;
                String entityID = peerContext.getEntityId();
                if (entityID != null) {
                    criteria.add(new EntityIdCriterion(entityID));
                }
                if ((role = peerContext.getRole()) != null) {
                    criteria.add(new EntityRoleCriterion(role));
                }
                if ((metadataContext = peerContext.getSubcontext(SAMLMetadataContext.class)) != null && (rd = metadataContext.getRoleDescriptor()) != null) {
                    criteria.add(new RoleDescriptorCriterion(rd));
                }
            }
            return criteria;
        }
    }
}

