/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.executable;

import java.util.Objects;
import schemacrawler.schemacrawler.Identifiers;
import schemacrawler.schemacrawler.InformationSchemaViews;
import schemacrawler.schemacrawler.InformationSchemaViewsBuilder;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaCrawlerOptionsBuilder;
import schemacrawler.tools.executable.BaseCommand;
import schemacrawler.tools.executable.CommandOptions;
import schemacrawler.tools.executable.SchemaCrawlerCommand;
import schemacrawler.tools.options.OutputOptions;
import schemacrawler.tools.options.OutputOptionsBuilder;
import us.fatehi.utility.property.PropertyName;

public abstract class BaseSchemaCrawlerCommand<C extends CommandOptions>
extends BaseCommand<C, Void>
implements SchemaCrawlerCommand<C> {
    protected Identifiers identifiers;
    protected InformationSchemaViews informationSchemaViews;
    protected OutputOptions outputOptions;
    protected SchemaCrawlerOptions schemaCrawlerOptions = SchemaCrawlerOptionsBuilder.newSchemaCrawlerOptions();

    protected BaseSchemaCrawlerCommand(PropertyName command) {
        super(command);
        this.outputOptions = OutputOptionsBuilder.newOutputOptions();
    }

    @Override
    public final Void call() {
        this.execute();
        return null;
    }

    @Override
    public abstract void checkAvailability() throws RuntimeException;

    @Override
    public final void configure(C commandOptions) {
        this.commandOptions = Objects.requireNonNull(commandOptions, "No command options provided");
    }

    @Override
    public final C getCommandOptions() {
        return (C)((CommandOptions)this.commandOptions);
    }

    @Override
    public Identifiers getIdentifiers() {
        return this.identifiers;
    }

    @Override
    public final InformationSchemaViews getInformationSchemaViews() {
        if (this.informationSchemaViews == null) {
            return InformationSchemaViewsBuilder.newInformationSchemaViews();
        }
        return this.informationSchemaViews;
    }

    @Override
    public final OutputOptions getOutputOptions() {
        return this.outputOptions;
    }

    @Override
    public final SchemaCrawlerOptions getSchemaCrawlerOptions() {
        return this.schemaCrawlerOptions;
    }

    @Override
    public void initialize() {
        this.checkOptions();
    }

    @Override
    public void setIdentifiers(Identifiers identifiers) {
        this.identifiers = identifiers;
    }

    @Override
    public final void setInformationSchemaViews(InformationSchemaViews informationSchemaViews) {
        this.informationSchemaViews = informationSchemaViews;
    }

    @Override
    public final void setOutputOptions(OutputOptions outputOptions) {
        this.outputOptions = outputOptions != null ? outputOptions : OutputOptionsBuilder.newOutputOptions();
    }

    @Override
    public final void setSchemaCrawlerOptions(SchemaCrawlerOptions schemaCrawlerOptions) {
        this.schemaCrawlerOptions = schemaCrawlerOptions != null ? schemaCrawlerOptions : SchemaCrawlerOptionsBuilder.newSchemaCrawlerOptions();
    }

    protected void checkCatalog() {
        Objects.requireNonNull(this.catalog, "No database catalog provided");
        if (this.usesConnection()) {
            Objects.requireNonNull(this.connection, "No database connection provided");
        }
    }

    private void checkOptions() {
        Objects.requireNonNull(this.schemaCrawlerOptions, "No SchemaCrawler options provided");
        Objects.requireNonNull((CommandOptions)this.commandOptions, "No command options provided");
        Objects.requireNonNull(this.outputOptions, "No output options provided");
        Objects.requireNonNull(this.identifiers, "No database identifiers provided");
    }
}

