/*@license
 AsyGL: Render Bezier patches and triangles via subdivision with WebGL.
  Copyright 2019-2024: John C. Bowman and Supakorn "Jamie" Rassameemasmuang
  University of Alberta

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation; either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
/*@license for gl-matrix mat3 and mat4 functions:
Copyright (c) 2015, Brandon Jones, Colin MacKenzie IV.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.*/
let vertex="\n#ifdef WEBGL2\n#define IN in\n#define OUT out\n#else\n#define IN attribute\n#define OUT varying\n#endif\n\nIN vec3 position;\n#ifdef WIDTH\nIN float width;\n#endif\n#ifdef NORMAL\nIN vec3 normal;\n#endif\n\nIN float materialIndex;\n\n#ifdef WEBGL2\nflat out int MaterialIndex;\n#ifdef COLOR\nOUT vec4 Color;\n#endif\n\n#else\nOUT vec4 diffuse;\nOUT vec3 specular;\nOUT float roughness,metallic,fresnel0;\nOUT vec4 emissive;\n\nstruct Material {\n  vec4 diffuse,emissive,specular;\n  vec4 parameters;\n};\n\nuniform Material Materials[Nmaterials];\n#endif\n\n#ifdef COLOR\nIN vec4 color;\n#endif\n\nuniform bool orthographic;\nuniform mat3 normMat;\nuniform mat4 viewMat;\nuniform mat4 projViewMat;\n\n#ifdef NORMAL\nOUT vec3 ViewPosition;\nOUT vec3 Normal;\n#endif\n\nvoid main(void)\n{\n  vec4 v=vec4(position,1.0);\n  gl_Position=projViewMat*v;\n\n#ifdef NORMAL\n  ViewPosition=orthographic ? vec3(0.0,0.0,-1.0) : (viewMat*v).xyz;\n  Normal=normalize(normal*normMat);\n#endif\n\n#ifdef WEBGL2\n  MaterialIndex=int(materialIndex);\n#ifdef COLOR\n  Color=color;\n#endif\n#else\n#ifdef NORMAL\n  Material m;\n#ifdef TRANSPARENT\n  m=Materials[int(abs(materialIndex))-1];\n  emissive=m.emissive;\n  if(materialIndex >= 0.0)\n    diffuse=m.diffuse;\n  else {\n    diffuse=color;\n#if nlights == 0\n    emissive += color;\n#endif\n  }\n#else\n  m=Materials[int(materialIndex)];\n  emissive=m.emissive;\n#ifdef COLOR\n  diffuse=color;\n#if nlights == 0\n    emissive += color;\n#endif\n#else\n  diffuse=m.diffuse;\n#endif // COLOR\n#endif // TRANSPARENT\n  specular=m.specular.rgb;\n  vec4 parameters=m.parameters;\n  roughness=1.0-parameters[0];\n  metallic=parameters[1];\n  fresnel0=parameters[2];\n#else\n  emissive=Materials[int(materialIndex)].emissive;\n#endif // NORMAL\n#endif // WEBGL2\n\n#ifdef WIDTH\n  gl_PointSize=width;\n#endif\n}\n",fragment="\n#ifdef WEBGL2\n#define IN in\nout vec4 outValue;\n#define OUTVALUE outValue\n#else\n#define IN varying\n#define OUTVALUE gl_FragColor\n#endif\n\n#ifdef WEBGL2\nflat in int MaterialIndex;\n\nstruct Material {\n  vec4 diffuse,emissive,specular;\n  vec4 parameters;\n};\n\nuniform Material Materials[Nmaterials];\n\nvec4 diffuse;\nvec3 specular;\nfloat roughness,metallic,fresnel0;\nvec4 emissive;\n\n#ifdef COLOR\nin vec4 Color;\n#endif\n\n#else\nIN vec4 diffuse;\nIN vec3 specular;\nIN float roughness,metallic,fresnel0;\nIN vec4 emissive;\n#endif\n\n#ifdef NORMAL\n\nIN vec3 ViewPosition;\nIN vec3 Normal;\n\nvec3 normal;\n\nstruct Light {\n  vec3 direction;\n  vec3 color;\n};\n\nuniform Light Lights[Nlights];\n\n#ifdef USE_IBL\nuniform sampler2D reflBRDFSampler;\nuniform sampler2D diffuseSampler;\nuniform sampler2D reflImgSampler;\n\nconst float pi=acos(-1.0);\nconst float piInv=1.0/pi;\nconst float twopi=2.0*pi;\nconst float twopiInv=1.0/twopi;\n\n// (x,y,z) -> (r,theta,phi);\n// theta -> [0,pi]: colatitude\n// phi -> [-pi,pi]: longitude\nvec3 cart2sphere(vec3 cart)\n{\n  float x=cart.x;\n  float y=cart.z;\n  float z=cart.y;\n\n  float r=length(cart);\n  float theta=r > 0.0 ? acos(z/r) : 0.0;\n  float phi=atan(y,x);\n\n  return vec3(r,theta,phi);\n}\n\nvec2 normalizedAngle(vec3 cartVec)\n{\n  vec3 sphericalVec=cart2sphere(cartVec);\n  sphericalVec.y=sphericalVec.y*piInv;\n  sphericalVec.z=0.75-sphericalVec.z*twopiInv;\n  return sphericalVec.zy;\n}\n\nvec3 IBLColor(vec3 viewDir)\n{\n  vec3 IBLDiffuse=diffuse.rgb*texture(diffuseSampler,normalizedAngle(normal)).rgb;\n  vec3 reflectVec=normalize(reflect(-viewDir,normal));\n  vec2 reflCoord=normalizedAngle(reflectVec);\n  vec3 IBLRefl=textureLod(reflImgSampler,reflCoord,roughness*ROUGHNESS_STEP_COUNT).rgb;\n  vec2 IBLbrdf=texture(reflBRDFSampler,vec2(dot(normal,viewDir),roughness)).rg;\n  float specularMultiplier=fresnel0*IBLbrdf.x+IBLbrdf.y;\n  vec3 dielectric=IBLDiffuse+specularMultiplier*IBLRefl;\n  vec3 metal=diffuse.rgb*IBLRefl;\n  return mix(dielectric,metal,metallic);\n}\n#else\nfloat Roughness2;\nfloat NDF_TRG(vec3 h)\n{\n  float ndoth=max(dot(normal,h),0.0);\n  float alpha2=Roughness2*Roughness2;\n  float denom=ndoth*ndoth*(alpha2-1.0)+1.0;\n  return denom != 0.0 ? alpha2/(denom*denom) : 0.0;\n}\n\nfloat GGX_Geom(vec3 v)\n{\n  float ndotv=max(dot(v,normal),0.0);\n  float ap=1.0+Roughness2;\n  float k=0.125*ap*ap;\n  return ndotv/((ndotv*(1.0-k))+k);\n}\n\nfloat Geom(vec3 v, vec3 l)\n{\n  return GGX_Geom(v)*GGX_Geom(l);\n}\n\nfloat Fresnel(vec3 h, vec3 v, float fresnel0)\n{\n  float a=1.0-max(dot(h,v),0.0);\n  float b=a*a;\n  return fresnel0+(1.0-fresnel0)*b*b*a;\n}\n\n// physical based shading using UE4 model.\nvec3 BRDF(vec3 viewDirection, vec3 lightDirection)\n{\n  vec3 lambertian=diffuse.rgb;\n  vec3 h=normalize(lightDirection+viewDirection);\n\n  float omegain=max(dot(viewDirection,normal),0.0);\n  float omegaln=max(dot(lightDirection,normal),0.0);\n\n  float D=NDF_TRG(h);\n  float G=Geom(viewDirection,lightDirection);\n  float F=Fresnel(h,viewDirection,fresnel0);\n\n  float denom=4.0*omegain*omegaln;\n  float rawReflectance=denom > 0.0 ? (D*G)/denom : 0.0;\n\n  vec3 dielectric=mix(lambertian,rawReflectance*specular,F);\n  vec3 metal=rawReflectance*diffuse.rgb;\n\n  return mix(dielectric,metal,metallic);\n}\n#endif\n\n#endif\n\nvoid main(void)\n{\n#ifdef WEBGL2\n#ifdef NORMAL\n  Material m;\n#ifdef TRANSPARENT\n  m=Materials[abs(MaterialIndex)-1];\n  emissive=m.emissive;\n  if(MaterialIndex >= 0)\n    diffuse=m.diffuse;\n  else {\n    diffuse=Color;\n#if nlights == 0\n    emissive += Color;\n#endif\n  }\n#else\n  m=Materials[MaterialIndex];\n  emissive=m.emissive;\n#ifdef COLOR\n  diffuse=Color;\n#if nlights == 0\n    emissive += Color;\n#endif\n#else\n  diffuse=m.diffuse;\n#endif // COLOR\n#endif // TRANSPARENT\n  specular=m.specular.rgb;\n  vec4 parameters=m.parameters;\n  roughness=1.0-parameters[0];\n  metallic=parameters[1];\n  fresnel0=parameters[2];\n#else\n  emissive=Materials[MaterialIndex].emissive;\n#endif // NORMAL\n#endif // WEBGL2\n\n#if defined(NORMAL) && nlights > 0\n  normal=normalize(Normal);\n  normal=gl_FrontFacing ? normal : -normal;\n  vec3 viewDir=-normalize(ViewPosition);\n\nvec3 color;\n#ifdef USE_IBL\n  color=IBLColor(viewDir);\n#else\n  Roughness2=roughness*roughness;\n  color=emissive.rgb;\n  for(int i=0; i < nlights; ++i) {\n    Light Li=Lights[i];\n    vec3 L=Li.direction;\n    float cosTheta=max(dot(normal,L),0.0);\n    vec3 radiance=cosTheta*Li.color;\n    color += BRDF(viewDir,L)*radiance;\n  }\n#endif\n  OUTVALUE=vec4(color,diffuse.a);\n#else\n  OUTVALUE=emissive;\n#endif\n}\n";!function(t,e){if("object"==typeof exports&&"object"==typeof module)module.exports=e();else if("function"==typeof define&&define.amd)define([],e);else{var i=e();for(var n in i)("object"==typeof exports?exports:t)[n]=i[n]}}("undefined"!=typeof self?self:this,(function(){return function(t){var e={};function i(n){if(e[n])return e[n].exports;var r=e[n]={i:n,l:!1,exports:{}};return t[n].call(r.exports,r,r.exports,i),r.l=!0,r.exports}return i.m=t,i.c=e,i.d=function(t,e,n){i.o(t,e)||Object.defineProperty(t,e,{configurable:!1,enumerable:!0,get:n})},i.n=function(t){var e=t&&t.__esModule?function(){return t.default}:function(){return t};return i.d(e,"a",e),e},i.o=function(t,e){return Object.prototype.hasOwnProperty.call(t,e)},i.p="",i(i.s=1)}([function(t,e,i){"use strict";Object.defineProperty(e,"__esModule",{value:!0}),e.setMatrixArrayType=function(t){e.ARRAY_TYPE=t},e.toRadian=function(t){return t*r},e.equals=function(t,e){return Math.abs(t-e)<=n*Math.max(1,Math.abs(t),Math.abs(e))};var n=e.EPSILON=1e-6;e.ARRAY_TYPE="undefined"!=typeof Float32Array?Float32Array:Array,e.RANDOM=Math.random;var r=Math.PI/180},function(t,e,i){"use strict";Object.defineProperty(e,"__esModule",{value:!0}),e.mat4=e.mat3=void 0;var n=s(i(2)),r=s(i(3));function s(t){if(t&&t.__esModule)return t;var e={};if(null!=t)for(var i in t)Object.prototype.hasOwnProperty.call(t,i)&&(e[i]=t[i]);return e.default=t,e}e.mat3=n,e.mat4=r},function(t,e,i){"use strict";Object.defineProperty(e,"__esModule",{value:!0}),e.create=function(){var t=new n.ARRAY_TYPE(9);return t[0]=1,t[1]=0,t[2]=0,t[3]=0,t[4]=1,t[5]=0,t[6]=0,t[7]=0,t[8]=1,t},e.fromMat4=function(t,e){return t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[4],t[4]=e[5],t[5]=e[6],t[6]=e[8],t[7]=e[9],t[8]=e[10],t},e.invert=function(t,e){var i=e[0],n=e[1],r=e[2],s=e[3],a=e[4],o=e[5],h=e[6],l=e[7],c=e[8],d=c*a-o*l,m=-c*s+o*h,f=l*s-a*h,u=i*d+n*m+r*f;if(!u)return null;return u=1/u,t[0]=d*u,t[1]=(-c*n+r*l)*u,t[2]=(o*n-r*a)*u,t[3]=m*u,t[4]=(c*i-r*h)*u,t[5]=(-o*i+r*s)*u,t[6]=f*u,t[7]=(-l*i+n*h)*u,t[8]=(a*i-n*s)*u,t};var n=function(t){if(t&&t.__esModule)return t;var e={};if(null!=t)for(var i in t)Object.prototype.hasOwnProperty.call(t,i)&&(e[i]=t[i]);return e.default=t,e}(i(0))},function(t,e,i){"use strict";Object.defineProperty(e,"__esModule",{value:!0}),e.create=function(){var t=new n.ARRAY_TYPE(16);return t[0]=1,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=1,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=1,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t},e.identity=function(t){return t[0]=1,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=1,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=1,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t},e.invert=function(t,e){var i=e[0],n=e[1],r=e[2],s=e[3],a=e[4],o=e[5],h=e[6],l=e[7],c=e[8],d=e[9],m=e[10],f=e[11],u=e[12],p=e[13],v=e[14],x=e[15],g=i*o-n*a,w=i*h-r*a,M=i*l-s*a,b=n*h-r*o,T=n*l-s*o,R=r*l-s*h,y=c*p-d*u,A=c*v-m*u,E=c*x-f*u,I=d*v-m*p,L=d*x-f*p,N=m*x-f*v,_=g*N-w*L+M*I+b*E-T*A+R*y;if(!_)return null;return _=1/_,t[0]=(o*N-h*L+l*I)*_,t[1]=(r*L-n*N-s*I)*_,t[2]=(p*R-v*T+x*b)*_,t[3]=(m*T-d*R-f*b)*_,t[4]=(h*E-a*N-l*A)*_,t[5]=(i*N-r*E+s*A)*_,t[6]=(v*M-u*R-x*w)*_,t[7]=(c*R-m*M+f*w)*_,t[8]=(a*L-o*E+l*y)*_,t[9]=(n*E-i*L-s*y)*_,t[10]=(u*T-p*M+x*g)*_,t[11]=(d*M-c*T-f*g)*_,t[12]=(o*A-a*I-h*y)*_,t[13]=(i*I-n*A+r*y)*_,t[14]=(p*w-u*b-v*g)*_,t[15]=(c*b-d*w+m*g)*_,t},e.multiply=r,e.translate=function(t,e,i){var n=i[0],r=i[1],s=i[2],a=void 0,o=void 0,h=void 0,l=void 0,c=void 0,d=void 0,m=void 0,f=void 0,u=void 0,p=void 0,v=void 0,x=void 0;e===t?(t[12]=e[0]*n+e[4]*r+e[8]*s+e[12],t[13]=e[1]*n+e[5]*r+e[9]*s+e[13],t[14]=e[2]*n+e[6]*r+e[10]*s+e[14],t[15]=e[3]*n+e[7]*r+e[11]*s+e[15]):(a=e[0],o=e[1],h=e[2],l=e[3],c=e[4],d=e[5],m=e[6],f=e[7],u=e[8],p=e[9],v=e[10],x=e[11],t[0]=a,t[1]=o,t[2]=h,t[3]=l,t[4]=c,t[5]=d,t[6]=m,t[7]=f,t[8]=u,t[9]=p,t[10]=v,t[11]=x,t[12]=a*n+c*r+u*s+e[12],t[13]=o*n+d*r+p*s+e[13],t[14]=h*n+m*r+v*s+e[14],t[15]=l*n+f*r+x*s+e[15]);return t},e.rotate=function(t,e,i,r){var s,a,o,h,l,c,d,m,f,u,p,v,x,g,w,M,b,T,R,y,A,E,I,L,N=r[0],_=r[1],O=r[2],P=Math.sqrt(N*N+_*_+O*O);if(Math.abs(P)<n.EPSILON)return null;N*=P=1/P,_*=P,O*=P,s=Math.sin(i),a=Math.cos(i),o=1-a,h=e[0],l=e[1],c=e[2],d=e[3],m=e[4],f=e[5],u=e[6],p=e[7],v=e[8],x=e[9],g=e[10],w=e[11],M=N*N*o+a,b=_*N*o+O*s,T=O*N*o-_*s,R=N*_*o-O*s,y=_*_*o+a,A=O*_*o+N*s,E=N*O*o+_*s,I=_*O*o-N*s,L=O*O*o+a,t[0]=h*M+m*b+v*T,t[1]=l*M+f*b+x*T,t[2]=c*M+u*b+g*T,t[3]=d*M+p*b+w*T,t[4]=h*R+m*y+v*A,t[5]=l*R+f*y+x*A,t[6]=c*R+u*y+g*A,t[7]=d*R+p*y+w*A,t[8]=h*E+m*I+v*L,t[9]=l*E+f*I+x*L,t[10]=c*E+u*I+g*L,t[11]=d*E+p*I+w*L,e!==t&&(t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15]);return t},e.fromTranslation=function(t,e){return t[0]=1,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=1,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=1,t[11]=0,t[12]=e[0],t[13]=e[1],t[14]=e[2],t[15]=1,t},e.fromRotation=function(t,e,i){var r,s,a,o=i[0],h=i[1],l=i[2],c=Math.sqrt(o*o+h*h+l*l);if(Math.abs(c)<n.EPSILON)return null;return o*=c=1/c,h*=c,l*=c,r=Math.sin(e),s=Math.cos(e),a=1-s,t[0]=o*o*a+s,t[1]=h*o*a+l*r,t[2]=l*o*a-h*r,t[3]=0,t[4]=o*h*a-l*r,t[5]=h*h*a+s,t[6]=l*h*a+o*r,t[7]=0,t[8]=o*l*a+h*r,t[9]=h*l*a-o*r,t[10]=l*l*a+s,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t},e.frustum=function(t,e,i,n,r,s,a){var o=1/(i-e),h=1/(r-n),l=1/(s-a);return t[0]=2*s*o,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=2*s*h,t[6]=0,t[7]=0,t[8]=(i+e)*o,t[9]=(r+n)*h,t[10]=(a+s)*l,t[11]=-1,t[12]=0,t[13]=0,t[14]=a*s*2*l,t[15]=0,t},e.ortho=function(t,e,i,n,r,s,a){var o=1/(e-i),h=1/(n-r),l=1/(s-a);return t[0]=-2*o,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=-2*h,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=2*l,t[11]=0,t[12]=(e+i)*o,t[13]=(r+n)*h,t[14]=(a+s)*l,t[15]=1,t};var n=function(t){if(t&&t.__esModule)return t;var e={};if(null!=t)for(var i in t)Object.prototype.hasOwnProperty.call(t,i)&&(e[i]=t[i]);return e.default=t,e}(i(0));function r(t,e,i){var n=e[0],r=e[1],s=e[2],a=e[3],o=e[4],h=e[5],l=e[6],c=e[7],d=e[8],m=e[9],f=e[10],u=e[11],p=e[12],v=e[13],x=e[14],g=e[15],w=i[0],M=i[1],b=i[2],T=i[3];return t[0]=w*n+M*o+b*d+T*p,t[1]=w*r+M*h+b*m+T*v,t[2]=w*s+M*l+b*f+T*x,t[3]=w*a+M*c+b*u+T*g,w=i[4],M=i[5],b=i[6],T=i[7],t[4]=w*n+M*o+b*d+T*p,t[5]=w*r+M*h+b*m+T*v,t[6]=w*s+M*l+b*f+T*x,t[7]=w*a+M*c+b*u+T*g,w=i[8],M=i[9],b=i[10],T=i[11],t[8]=w*n+M*o+b*d+T*p,t[9]=w*r+M*h+b*m+T*v,t[10]=w*s+M*l+b*f+T*x,t[11]=w*a+M*c+b*u+T*g,w=i[12],M=i[13],b=i[14],T=i[15],t[12]=w*n+M*o+b*d+T*p,t[13]=w*r+M*h+b*m+T*v,t[14]=w*s+M*l+b*f+T*x,t[15]=w*a+M*c+b*u+T*g,t}}])})),function(){document.asy={canvasWidth:0,canvasHeight:0,absolute:!1,minBound:[0,0,0],maxBound:[0,0,0],orthographic:!1,angleOfView:0,initialZoom:0,viewportShift:[0,0],viewportMargin:[0,0],background:[],zoomFactor:0,zoomPinchFactor:0,zoomPinchCap:0,zoomStep:0,shiftHoldDistance:0,shiftWaitTime:0,vibrateTime:0,ibl:!1,webgl2:!1,imageURL:"",image:"",Transform:[],Centers:[]};let t,e,i,n,r,s,a,o=document.asy,h=[],l=[],c=[],d=0,m=2;const f=Math.acos(-1),u=f/180,p=Math.ceil(1-Math.log2(Number.EPSILON));let v,x,g,w,M,b,T,R=mat4.create(),y=mat4.create(),A=mat4.create(),E=mat4.create(),I=mat3.create(),L=mat3.create(),N=mat4.create(),_=mat4.create(),O={x:0,y:0,z:0},P={x:0,y:0},S={xmin:0,xmax:0,ymin:0,ymax:0,zmin:0,zmax:0},U=!0,V=0,B=!1,D=null,C=null,F=[],z=[],X=[],W=[],G=null,H=null,j=null;function k(){o.embedded||st(),rt(o.ibl)}class Y{constructor(t,e,i,n,r,s){this.diffuse=t,this.emissive=e,this.specular=i,this.shininess=n,this.metallic=r,this.fresnel0=s}setUniform(e,i){let n=n=>t.getUniformLocation(e,"Materials["+i+"]."+n);t.uniform4fv(n("diffuse"),new Float32Array(this.diffuse)),t.uniform4fv(n("emissive"),new Float32Array(this.emissive)),t.uniform4fv(n("specular"),new Float32Array(this.specular)),t.uniform4f(n("parameters"),this.shininess,this.metallic,this.fresnel0,0)}}let $,q,K,Z,Q,J,tt,et,it;class nt{constructor(t,e){this.direction=t,this.color=e}setUniform(e,i){let n=n=>t.getUniformLocation(e,"Lights["+i+"]."+n);t.uniform3fv(n("direction"),new Float32Array(this.direction)),t.uniform3fv(n("color"),new Float32Array(this.color))}}function rt(e=!1){let i=t.getParameter(t.MAX_VERTEX_UNIFORM_VECTORS);r=Math.floor((i-14)/4),m=Math.min(Math.max(m,c.length),r),pixelOpt=["WIDTH"],materialOpt=["NORMAL"],colorOpt=["NORMAL","COLOR"],transparentOpt=["NORMAL","COLOR","TRANSPARENT"],e&&(materialOpt.push("USE_IBL"),transparentOpt.push("USE_IBL")),we=_t(pixelOpt),Me=_t(materialOpt),be=_t(colorOpt),Te=_t(transparentOpt)}function st(){t.deleteProgram(Te),t.deleteProgram(be),t.deleteProgram(Me),t.deleteProgram(we)}function at(){let i=o.webgl2?window.top.document.asygl2[e]:window.top.document.asygl[e];i.gl=t,i.nlights=l.length,i.Nmaterials=m,i.maxMaterials=r,i.pixelShader=we,i.materialShader=Me,i.colorShader=be,i.transparentShader=Te}function ot(t,e){let i;return o.webgl2&&(i=t.getContext("webgl2",{alpha:e}),o.embedded&&!i)?(o.webgl2=!1,o.ibl=!1,lt(!1),null):(i||(o.webgl2=!1,o.ibl=!1,i=t.getContext("webgl",{alpha:e})),i||alert("Could not initialize WebGL"),i)}function ht(){let n=window.top.document;if(asygl=o.webgl2?n.asygl2:n.asygl,asygl[e]&&asygl[e].gl)!function(){let i=o.webgl2?window.top.document.asygl2[e]:window.top.document.asygl[e];t=i.gl,d=i.nlights,m=i.Nmaterials,r=i.maxMaterials,we=i.pixelShader,Me=i.materialShader,be=i.colorShader,Te=i.transparentShader}(),(l.length!=d||Math.min(c.length,r)>m)&&(rt(),at());else{if(rc=ot(i,e),!rc)return;t=rc,rt(),o.webgl2?n.asygl2[e]={}:n.asygl[e]={},at()}}function lt(r=!0){if(o.ibl&&(o.webgl2=!0),e=o.background[3]<1,o.embedded){let t=window.top.document;r&&(n=o.canvas.getContext("2d")),i=o.webgl2?t.offscreen2:t.offscreen,i||(i=t.createElement("canvas"),o.webgl2?t.offscreen2=i:t.offscreen=i),o.webgl2?t.asygl2||(t.asygl2=Array(2)):t.asygl||(t.asygl=Array(2)),ht()}else t=ot(o.canvas,e),rt();$=t.getExtension("OES_element_index_uint"),q=t.TRIANGLES,K=new ft(t.POINTS),Z=new ft(t.LINES),Q=new ft,J=new ft,tt=new ft,et=new ft}function ct(t,e,i,n=[]){let r=o.webgl2?"300 es":"100",s=Array(...n),a=[["nlights",0==V?l.length:0],["Nmaterials",m]],h=[["int","Nlights",Math.max(l.length,1)]];o.webgl2&&s.push("WEBGL2"),o.ibl&&a.push(["ROUGHNESS_STEP_COUNT",8..toFixed(2)]),macros_str=a.map(t=>`#define ${t[0]} ${t[1]}`).join("\n"),define_str=s.map(t=>"#define "+t).join("\n"),const_str=h.map(t=>`const ${t[0]} ${t[1]}=${t[2]};`).join("\n"),ext_str=[].map(t=>`#extension ${t}: enable`).join("\n"),shaderSrc=`#version ${r}\n${ext_str}\n${define_str}\n${const_str}\n${macros_str}\n\n\n#ifdef GL_FRAGMENT_PRECISION_HIGH\nprecision highp float;\n#else\nprecision mediump float;\n#endif\n  \n${e}\n  `;let c=t.createShader(i);return t.shaderSource(c,shaderSrc),t.compileShader(c),t.getShaderParameter(c,t.COMPILE_STATUS)?c:(alert(t.getShaderInfoLog(c)),null)}function dt(e,i,n,r=t.ARRAY_BUFFER){return e.length>0&&(0==i&&(i=t.createBuffer(),n=!0),t.bindBuffer(r,i),n&&t.bufferData(r,e,t.STATIC_DRAW)),i}function mt(e,i,n=e.indices){if(0==e.indices.length)return;let r=i!=we;!function(e,i){let n=i==we;t.useProgram(i),t.enableVertexAttribArray(At),n&&t.enableVertexAttribArray(Nt);let r=!n&&l.length>0;r&&t.enableVertexAttribArray(Et);t.enableVertexAttribArray(It),i.projViewMatUniform=t.getUniformLocation(i,"projViewMat"),i.viewMatUniform=t.getUniformLocation(i,"viewMat"),i.normMatUniform=t.getUniformLocation(i,"normMat"),i.orthographicUniform=t.getUniformLocation(i,"orthographic"),(i==be||i==Te)&&t.enableVertexAttribArray(Lt);if(r)for(let t=0;t<l.length;++t)l[t].setUniform(i,t);for(let t=0;t<e.materials.length;++t)e.materials[t].setUniform(i,t);t.uniformMatrix4fv(i.projViewMatUniform,!1,E),t.uniformMatrix4fv(i.viewMatUniform,!1,A),t.uniformMatrix3fv(i.normMatUniform,!1,I),t.uniform1i(i.orthographicUniform,1,o.orthographic)}(e,i),null!=H&&(t.activeTexture(t.TEXTURE0),t.bindTexture(t.TEXTURE_2D,j),t.uniform1i(t.getUniformLocation(i,"reflBRDFSampler"),0),t.activeTexture(t.TEXTURE1),t.bindTexture(t.TEXTURE_2D,H),t.uniform1i(t.getUniformLocation(i,"diffuseSampler"),1),t.activeTexture(t.TEXTURE2),t.bindTexture(t.TEXTURE_2D,G),t.uniform1i(t.getUniformLocation(i,"reflImgSampler"),2));let s=U||e.partial||!e.rendered;e.verticesBuffer=dt(new Float32Array(e.vertices),e.verticesBuffer,s),t.vertexAttribPointer(At,3,t.FLOAT,!1,r?24:16,0),r?l.length>0&&t.vertexAttribPointer(Et,3,t.FLOAT,!1,24,12):t.vertexAttribPointer(Nt,1,t.FLOAT,!1,16,12),e.materialsBuffer=dt(new Int16Array(e.materialIndices),e.materialsBuffer,s),t.vertexAttribPointer(It,1,t.SHORT,!1,2,0),i!=be&&i!=Te||(e.colorsBuffer=dt(new Float32Array(e.colors),e.colorsBuffer,s),t.vertexAttribPointer(Lt,4,t.FLOAT,!0,0,0)),e.indicesBuffer=dt($?new Uint32Array(n):new Uint16Array(n),e.indicesBuffer,s,t.ELEMENT_ARRAY_BUFFER),e.rendered=!0,t.drawElements(r?V?t.LINES:e.type:t.POINTS,n.length,$?t.UNSIGNED_INT:t.UNSIGNED_SHORT,0)}class ft{constructor(t){this.type=t||q,this.verticesBuffer=0,this.materialsBuffer=0,this.colorsBuffer=0,this.indicesBuffer=0,this.rendered=!1,this.partial=!1,this.clear()}clear(){this.vertices=[],this.materialIndices=[],this.colors=[],this.indices=[],this.nvertices=0,this.materials=[],this.materialTable=[]}vertex(t,e){return this.vertices.push(t[0]),this.vertices.push(t[1]),this.vertices.push(t[2]),this.vertices.push(e[0]),this.vertices.push(e[1]),this.vertices.push(e[2]),this.materialIndices.push(it),this.nvertices++}Vertex(t,e,i=[0,0,0,0]){return this.vertices.push(t[0]),this.vertices.push(t[1]),this.vertices.push(t[2]),this.vertices.push(e[0]),this.vertices.push(e[1]),this.vertices.push(e[2]),this.materialIndices.push(it),this.colors.push(i[0]),this.colors.push(i[1]),this.colors.push(i[2]),this.colors.push(i[3]),this.nvertices++}vertex0(t,e){return this.vertices.push(t[0]),this.vertices.push(t[1]),this.vertices.push(t[2]),this.vertices.push(e),this.materialIndices.push(it),this.nvertices++}iVertex(t,e,i,n,r=[0,0,0,0]){let s=6*t;this.vertices[s]=e[0],this.vertices[s+1]=e[1],this.vertices[s+2]=e[2],this.vertices[s+3]=i[0],this.vertices[s+4]=i[1],this.vertices[s+5]=i[2],this.materialIndices[t]=it;let a=4*t;this.colors[a]=r[0],this.colors[a+1]=r[1],this.colors[a+2]=r[2],this.colors[a+3]=r[3],n&&this.indices.push(t)}append(t){ut(this.vertices,t.vertices),ut(this.materialIndices,t.materialIndices),ut(this.colors,t.colors),function(t,e,i){let n=t.length,r=e.length;t.length+=e.length;for(let s=0;s<r;++s)t[n+s]=e[s]+i}(this.indices,t.indices,this.nvertices),this.nvertices+=t.nvertices}}function ut(t,e){let i=t.length,n=e.length;t.length+=n;for(let r=0;r<n;++r)t[i+r]=e[r]}class pt{constructor(){this.data=new ft,this.Onscreen=!1,this.m=[]}offscreen(t){let e=E,i=t[0],n=i[0],r=i[1],s=i[2],a=1/(e[3]*n+e[7]*r+e[11]*s+e[15]);this.x=this.X=(e[0]*n+e[4]*r+e[8]*s+e[12])*a,this.y=this.Y=(e[1]*n+e[5]*r+e[9]*s+e[13])*a;for(let i=1,n=t.length;i<n;++i){let n=t[i],r=n[0],s=n[1],a=n[2],o=1/(e[3]*r+e[7]*s+e[11]*a+e[15]),h=(e[0]*r+e[4]*s+e[8]*a+e[12])*o,l=(e[1]*r+e[5]*s+e[9]*a+e[13])*o;h<this.x?this.x=h:h>this.X&&(this.X=h),l<this.y?this.y=l:l>this.Y&&(this.Y=l)}return(this.X<-1.01||this.x>1.01||this.Y<-1.01||this.y>1.01)&&(this.Onscreen=!1,!0)}T(t){let e=this.c[0],i=this.c[1],n=this.c[2],r=t[0]-e,s=t[1]-i,a=t[2]-n;return[r*I[0]+s*I[3]+a*I[6]+e,r*I[1]+s*I[4]+a*I[7]+i,r*I[2]+s*I[5]+a*I[8]+n]}Tcorners(t,e){return[this.T(t),this.T([t[0],t[1],e[2]]),this.T([t[0],e[1],t[2]]),this.T([t[0],e[1],e[2]]),this.T([e[0],t[1],t[2]]),this.T([e[0],t[1],e[2]]),this.T([e[0],e[1],t[2]]),this.T(e)]}setMaterial(t,e){null==t.materialTable[this.MaterialIndex]&&(t.materials.length>=m&&(t.partial=!0,e()),t.materialTable[this.MaterialIndex]=t.materials.length,t.materials.push(c[this.MaterialIndex])),it=t.materialTable[this.MaterialIndex]}render(){let t;var e,i;if(this.setMaterialIndex(),0==this.CenterIndex?(e=this.Min,i=this.Max,t=[e,[e[0],e[1],i[2]],[e[0],i[1],e[2]],[e[0],i[1],i[2]],[i[0],e[1],e[2]],[i[0],e[1],i[2]],[i[0],i[1],e[2]],i]):(this.c=o.Centers[this.CenterIndex-1],t=this.Tcorners(this.Min,this.Max)),this.offscreen(t))return this.data.clear(),void this.notRendered();let n,r=this.controlpoints;if(0==this.CenterIndex){if(!U&&this.Onscreen)return void this.append();n=r}else{let t=r.length;n=Array(t);for(let e=0;e<t;++e)n[e]=this.T(r[e])}let s=o.orthographic?1:this.Min[2]/o.maxBound[2],a=.75*Math.hypot(s*(S.xmax-S.xmin),s*(S.ymax-S.ymin))/b;this.res2=a*a,this.Epsilon=.1*a,this.data.clear(),this.notRendered(),this.Onscreen=!0,this.process(n)}}function vt(t,e){let i=t[0],n=t.length;for(let r=1;r<n;++r)i=e(i,t[r]);return i}class xt extends pt{constructor(t,e,i,n,r,s){super(),this.controlpoints=t,this.CenterIndex=e,this.MaterialIndex=i,this.color=n;let a=t.length;if(n){let t=n[0][3]+n[1][3]+n[2][3];this.transparent=16==a||4==a?t+n[3][3]<4:t<3}else this.transparent=c[i].diffuse[3]<1;this.vertex=this.transparent?this.data.Vertex.bind(this.data):this.data.vertex.bind(this.data);let o=this.L2norm2(this.controlpoints),h=Math.sqrt(1e3*Number.EPSILON*o);this.epsilon=o*Number.EPSILON,this.Min=r||this.Bounds(this.controlpoints,Math.min,h),this.Max=s||this.Bounds(this.controlpoints,Math.max,h)}setMaterialIndex(){this.transparent?this.setMaterial(tt,Ne):this.color?this.setMaterial(J,Ie):this.setMaterial(Q,Ee)}cornerbound(t,e){let i=e(t[0],t[3]);return i=e(i,t[12]),e(i,t[15])}controlbound(t,e){let i=e(t[1],t[2]);return i=e(i,t[4]),i=e(i,t[5]),i=e(i,t[6]),i=e(i,t[7]),i=e(i,t[8]),i=e(i,t[9]),i=e(i,t[10]),i=e(i,t[11]),i=e(i,t[13]),e(i,t[14])}bound(t,e,i,n,r){if(i=e(i,this.cornerbound(t,e)),e(-1,1)*(i-this.controlbound(t,e))>=-n||0==r)return i;--r,n*=2;let s=new Ot(t[0],t[1],t[2],t[3]),a=new Ot(t[4],t[5],t[6],t[7]),o=new Ot(t[8],t[9],t[10],t[11]),h=new Ot(t[12],t[13],t[14],t[15]),l=new Ot(t[0],t[4],t[8],t[12]),c=new Ot(s.m0,a.m0,o.m0,h.m0),d=new Ot(s.m3,a.m3,o.m3,h.m3),m=new Ot(s.m5,a.m5,o.m5,h.m5),f=new Ot(s.m4,a.m4,o.m4,h.m4),u=new Ot(s.m2,a.m2,o.m2,h.m2),p=new Ot(t[3],t[7],t[11],t[15]),v=[t[0],s.m0,s.m3,s.m5,l.m0,c.m0,d.m0,m.m0,l.m3,c.m3,d.m3,m.m3,l.m5,c.m5,d.m5,m.m5];i=this.bound(v,e,i,n,r);let x=[l.m5,c.m5,d.m5,m.m5,l.m4,c.m4,d.m4,m.m4,l.m2,c.m2,d.m2,m.m2,t[12],h.m0,h.m3,h.m5];i=this.bound(x,e,i,n,r);let g=[m.m5,f.m5,u.m5,p.m5,m.m4,f.m4,u.m4,p.m4,m.m2,f.m2,u.m2,p.m2,h.m5,h.m4,h.m2,t[15]];i=this.bound(g,e,i,n,r);let w=[s.m5,s.m4,s.m2,t[3],m.m0,f.m0,u.m0,p.m0,m.m3,f.m3,u.m3,p.m3,m.m5,f.m5,u.m5,p.m5];return this.bound(w,e,i,n,r)}cornerboundtri(t,e){let i=e(t[0],t[6]);return e(i,t[9])}controlboundtri(t,e){let i=e(t[1],t[2]);return i=e(i,t[3]),i=e(i,t[4]),i=e(i,t[5]),i=e(i,t[7]),e(i,t[8])}boundtri(t,e,i,n,r){if(i=e(i,this.cornerboundtri(t,e)),e(-1,1)*(i-this.controlboundtri(t,e))>=-n||0==r)return i;--r,n*=2;let s=new St(t),a=[s.l003,s.l102,s.l012,s.l201,s.l111,s.l021,s.l300,s.l210,s.l120,s.l030];i=this.boundtri(a,e,i,n,r);let o=[s.l300,s.r102,s.r012,s.r201,s.r111,s.r021,s.r300,s.r210,s.r120,s.r030];i=this.boundtri(o,e,i,n,r);let h=[s.l030,s.u102,s.u012,s.u201,s.u111,s.u021,s.r030,s.u210,s.u120,s.u030];i=this.boundtri(h,e,i,n,r);let l=[s.r030,s.u201,s.r021,s.u102,s.c111,s.r012,s.l030,s.l120,s.l210,s.l300];return this.boundtri(l,e,i,n,r)}Bounds(t,e,i){let n=Array(3),r=t.length,s=Array(r);for(let a=0;a<3;++a){for(let e=0;e<r;++e)s[e]=t[e][a];n[a]=16==r?this.bound(s,e,s[0],i,p):10==r?this.boundtri(s,e,s[0],i,p):vt(s,e)}return[n[0],n[1],n[2]]}L2norm2(t){let e=t[0],i=0,n=t.length;for(let r=1;r<n;++r)i=Math.max(i,Vt([t[r][0]-e[0],t[r][1]-e[1],t[r][2]-e[2]]));return i}processTriangle(t){let e=t[0],i=t[1],n=t[2],r=Ut(Dt([i[0]-e[0],i[1]-e[1],i[2]-e[2]],[n[0]-e[0],n[1]-e[1],n[2]-e[2]]));if(!this.offscreen([e,i,n])){let t,s,a;this.color?(t=this.data.Vertex(e,r,this.color[0]),s=this.data.Vertex(i,r,this.color[1]),a=this.data.Vertex(n,r,this.color[2])):(t=this.vertex(e,r),s=this.vertex(i,r),a=this.vertex(n,r)),0==V?(this.data.indices.push(t),this.data.indices.push(s),this.data.indices.push(a)):(this.data.indices.push(t),this.data.indices.push(s),this.data.indices.push(s),this.data.indices.push(a),this.data.indices.push(a),this.data.indices.push(t)),this.append()}}processQuad(t){let e=t[0],i=t[1],n=t[2],r=t[3],s=Dt([i[0]-e[0],i[1]-e[1],i[2]-e[2]],[n[0]-i[0],n[1]-i[1],n[2]-i[2]]),a=Dt([n[0]-r[0],n[1]-r[1],n[2]-r[2]],[r[0]-e[0],r[1]-e[1],r[2]-e[2]]),o=Ut([s[0]+a[0],s[1]+a[1],s[2]+a[2]]);if(!this.offscreen([e,i,n,r])){let t,s,a,h;this.color?(t=this.data.Vertex(e,o,this.color[0]),s=this.data.Vertex(i,o,this.color[1]),a=this.data.Vertex(n,o,this.color[2]),h=this.data.Vertex(r,o,this.color[3])):(t=this.vertex(e,o),s=this.vertex(i,o),a=this.vertex(n,o),h=this.vertex(r,o)),0==V?(this.data.indices.push(t),this.data.indices.push(s),this.data.indices.push(a),this.data.indices.push(t),this.data.indices.push(a),this.data.indices.push(h)):(this.data.indices.push(t),this.data.indices.push(s),this.data.indices.push(s),this.data.indices.push(a),this.data.indices.push(a),this.data.indices.push(h),this.data.indices.push(h),this.data.indices.push(t)),this.append()}}curve(t,e,i,n,r){new Mt([t[e],t[i],t[n],t[r]],0,it,this.Min,this.Max).render()}process(t){if(this.transparent&&1!=V&&(it=this.color?-1-it:1+it),10==t.length)return this.process3(t);if(3==t.length)return this.processTriangle(t);if(4==t.length)return this.processQuad(t);if(1==V)return this.curve(t,0,4,8,12),this.curve(t,12,13,14,15),this.curve(t,15,11,7,3),void this.curve(t,3,2,1,0);let e=t[0],i=t[3],n=t[12],r=t[15],s=this.normal(i,t[2],t[1],e,t[4],t[8],n);Vt(s)<this.epsilon&&(s=this.normal(i,t[2],t[1],e,t[13],t[14],r),Vt(s)<this.epsilon&&(s=this.normal(r,t[11],t[7],i,t[4],t[8],n)));let a=this.normal(e,t[4],t[8],n,t[13],t[14],r);Vt(a)<this.epsilon&&(a=this.normal(e,t[4],t[8],n,t[11],t[7],i),Vt(a)<this.epsilon&&(a=this.normal(i,t[2],t[1],e,t[13],t[14],r)));let o=this.normal(n,t[13],t[14],r,t[11],t[7],i);Vt(o)<this.epsilon&&(o=this.normal(n,t[13],t[14],r,t[2],t[1],e),Vt(o)<this.epsilon&&(o=this.normal(e,t[4],t[8],n,t[11],t[7],i)));let h=this.normal(r,t[11],t[7],i,t[2],t[1],e);if(Vt(h)<this.epsilon&&(h=this.normal(r,t[11],t[7],i,t[4],t[8],n),Vt(h)<this.epsilon&&(h=this.normal(n,t[13],t[14],r,t[2],t[1],e))),this.color){let l=this.color[0],c=this.color[1],d=this.color[2],m=this.color[3],f=this.data.Vertex(e,s,l),u=this.data.Vertex(n,a,c),p=this.data.Vertex(r,o,d),v=this.data.Vertex(i,h,m);this.Render(t,f,u,p,v,e,n,r,i,!1,!1,!1,!1,l,c,d,m)}else{let l=this.vertex(e,s),c=this.vertex(n,a),d=this.vertex(r,o),m=this.vertex(i,h);this.Render(t,l,c,d,m,e,n,r,i,!1,!1,!1,!1)}this.data.indices.length>0&&this.append()}append(){this.transparent?tt.append(this.data):this.color?J.append(this.data):Q.append(this.data)}notRendered(){this.transparent?tt.rendered=!1:this.color?J.rendered=!1:Q.rendered=!1}Render(t,e,i,n,r,s,a,o,h,l,c,d,m,f,u,p,v){let x=this.Distance(t);if(x[0]<this.res2&&x[1]<this.res2)this.offscreen([s,a,o])||(0==V?(this.data.indices.push(e),this.data.indices.push(i),this.data.indices.push(n)):(this.data.indices.push(e),this.data.indices.push(i),this.data.indices.push(i),this.data.indices.push(n))),this.offscreen([s,o,h])||(0==V?(this.data.indices.push(e),this.data.indices.push(n),this.data.indices.push(r)):(this.data.indices.push(n),this.data.indices.push(r),this.data.indices.push(r),this.data.indices.push(e)));else{if(this.offscreen(t))return;let g=t[0],w=t[3],M=t[12],b=t[15];if(x[0]<this.res2){let x=new Pt(g,t[1],t[2],w),T=new Pt(t[4],t[5],t[6],t[7]),R=new Pt(t[8],t[9],t[10],t[11]),y=new Pt(M,t[13],t[14],b),A=[g,x.m0,x.m3,x.m5,t[4],T.m0,T.m3,T.m5,t[8],R.m0,R.m3,R.m5,M,y.m0,y.m3,y.m5],E=[x.m5,x.m4,x.m2,w,T.m5,T.m4,T.m2,t[7],R.m5,R.m4,R.m2,t[11],y.m5,y.m4,y.m2,b],I=this.normal(A[12],A[13],A[14],A[15],A[11],A[7],A[3]);Vt(I)<=this.epsilon&&(I=this.normal(A[12],A[13],A[14],A[15],A[2],A[1],A[0]),Vt(I)<=this.epsilon&&(I=this.normal(A[0],A[4],A[8],A[12],A[11],A[7],A[3])));let L=this.normal(E[3],E[2],E[1],E[0],E[4],E[8],E[12]);Vt(L)<=this.epsilon&&(L=this.normal(E[3],E[2],E[1],E[0],E[13],E[14],E[15]),Vt(L)<=this.epsilon&&(L=this.normal(E[15],E[11],E[7],E[3],E[4],E[8],E[12])));let N=this.Epsilon,_=[.5*(a[0]+o[0]),.5*(a[1]+o[1]),.5*(a[2]+o[2])];if(!c)if(c=Wt(M,t[13],t[14],b)<this.res2){let t=Ut(this.differential(E[12],E[8],E[4],E[0]));_=[_[0]-N*t[0],_[1]-N*t[1],_[2]-N*t[2]]}else _=A[15];let O=[.5*(h[0]+s[0]),.5*(h[1]+s[1]),.5*(h[2]+s[2])];if(!m)if(m=Wt(g,t[1],t[2],w)<this.res2){let t=Ut(this.differential(A[3],A[7],A[11],A[15]));O=[O[0]-N*t[0],O[1]-N*t[1],O[2]-N*t[2]]}else O=E[0];if(f){let t=Array(4),x=Array(4);for(let e=0;e<4;++e)t[e]=.5*(u[e]+p[e]),x[e]=.5*(v[e]+f[e]);let g=this.data.Vertex(_,I,t),w=this.data.Vertex(O,L,x);this.Render(A,e,i,g,w,s,a,_,O,l,c,!1,m,f,u,t,x),this.Render(E,w,g,n,r,O,_,o,h,!1,c,d,m,x,t,p,v)}else{let t=this.vertex(_,I),f=this.vertex(O,L);this.Render(A,e,i,t,f,s,a,_,O,l,c,!1,m),this.Render(E,f,t,n,r,O,_,o,h,!1,c,d,m)}return}if(x[1]<this.res2){let x=new Pt(g,t[4],t[8],M),T=new Pt(t[1],t[5],t[9],t[13]),R=new Pt(t[2],t[6],t[10],t[14]),y=new Pt(w,t[7],t[11],b),A=[g,t[1],t[2],w,x.m0,T.m0,R.m0,y.m0,x.m3,T.m3,R.m3,y.m3,x.m5,T.m5,R.m5,y.m5],E=[x.m5,T.m5,R.m5,y.m5,x.m4,T.m4,R.m4,y.m4,x.m2,T.m2,R.m2,y.m2,M,t[13],t[14],b],I=this.normal(A[0],A[4],A[8],A[12],A[13],A[14],A[15]);Vt(I)<=this.epsilon&&(I=this.normal(A[0],A[4],A[8],A[12],A[11],A[7],A[3]),Vt(I)<=this.epsilon&&(I=this.normal(A[3],A[2],A[1],A[0],A[13],A[14],A[15])));let L=this.normal(E[15],E[11],E[7],E[3],E[2],E[1],E[0]);Vt(L)<=this.epsilon&&(L=this.normal(E[15],E[11],E[7],E[3],E[4],E[8],E[12]),Vt(L)<=this.epsilon&&(L=this.normal(E[12],E[13],E[14],E[15],E[2],E[1],E[0])));let N=this.Epsilon,_=[.5*(s[0]+a[0]),.5*(s[1]+a[1]),.5*(s[2]+a[2])];if(!l)if(l=Wt(g,t[4],t[8],M)<this.res2){let t=Ut(this.differential(E[0],E[1],E[2],E[3]));_=[_[0]-N*t[0],_[1]-N*t[1],_[2]-N*t[2]]}else _=A[12];let O=[.5*(o[0]+h[0]),.5*(o[1]+h[1]),.5*(o[2]+h[2])];if(!d)if(d=Wt(b,t[11],t[7],w)<this.res2){let t=Ut(this.differential(A[15],A[14],A[13],A[12]));O=[O[0]-N*t[0],O[1]-N*t[1],O[2]-N*t[2]]}else O=E[3];if(f){let t=Array(4),x=Array(4);for(let e=0;e<4;++e)t[e]=.5*(f[e]+u[e]),x[e]=.5*(p[e]+v[e]);let g=this.data.Vertex(_,I,t),w=this.data.Vertex(O,L,x);this.Render(A,e,g,w,r,s,_,O,h,l,!1,d,m,f,t,x,v),this.Render(E,g,i,n,w,_,a,o,O,l,c,d,!1,t,u,p,x)}else{let t=this.vertex(_,I),f=this.vertex(O,L);this.Render(A,e,t,f,r,s,_,O,h,l,!1,d,m),this.Render(E,t,i,n,f,_,a,o,O,l,c,d,!1)}return}let T=new Pt(g,t[1],t[2],w),R=new Pt(t[4],t[5],t[6],t[7]),y=new Pt(t[8],t[9],t[10],t[11]),A=new Pt(M,t[13],t[14],b),E=new Pt(g,t[4],t[8],M),I=new Pt(T.m0,R.m0,y.m0,A.m0),L=new Pt(T.m3,R.m3,y.m3,A.m3),N=new Pt(T.m5,R.m5,y.m5,A.m5),_=new Pt(T.m4,R.m4,y.m4,A.m4),O=new Pt(T.m2,R.m2,y.m2,A.m2),P=new Pt(w,t[7],t[11],b),S=[g,T.m0,T.m3,T.m5,E.m0,I.m0,L.m0,N.m0,E.m3,I.m3,L.m3,N.m3,E.m5,I.m5,L.m5,N.m5],U=[E.m5,I.m5,L.m5,N.m5,E.m4,I.m4,L.m4,N.m4,E.m2,I.m2,L.m2,N.m2,M,A.m0,A.m3,A.m5],V=[N.m5,_.m5,O.m5,P.m5,N.m4,_.m4,O.m4,P.m4,N.m2,_.m2,O.m2,P.m2,A.m5,A.m4,A.m2,b],B=[T.m5,T.m4,T.m2,w,N.m0,_.m0,O.m0,P.m0,N.m3,_.m3,O.m3,P.m3,N.m5,_.m5,O.m5,P.m5],D=S[15],C=this.normal(S[0],S[4],S[8],S[12],S[13],S[14],S[15]);Vt(C)<this.epsilon&&(C=this.normal(S[0],S[4],S[8],S[12],S[11],S[7],S[3]),Vt(C)<this.epsilon&&(C=this.normal(S[3],S[2],S[1],S[0],S[13],S[14],S[15])));let F=this.normal(U[12],U[13],U[14],U[15],U[11],U[7],U[3]);Vt(F)<this.epsilon&&(F=this.normal(U[12],U[13],U[14],U[15],U[2],U[1],U[0]),Vt(F)<this.epsilon&&(F=this.normal(U[0],U[4],U[8],U[12],U[11],U[7],U[3])));let z=this.normal(V[15],V[11],V[7],V[3],V[2],V[1],V[0]);Vt(z)<this.epsilon&&(z=this.normal(V[15],V[11],V[7],V[3],V[4],V[8],V[12]),Vt(z)<this.epsilon&&(z=this.normal(V[12],V[13],V[14],V[15],V[2],V[1],V[0])));let X=this.normal(B[3],B[2],B[1],B[0],B[4],B[8],B[12]);Vt(X)<this.epsilon&&(X=this.normal(B[3],B[2],B[1],B[0],B[13],B[14],B[15]),Vt(X)<this.epsilon&&(X=this.normal(B[15],B[11],B[7],B[3],B[4],B[8],B[12])));let W=this.normal(V[3],V[2],V[1],D,V[4],V[8],V[12]),G=this.Epsilon,H=[.5*(s[0]+a[0]),.5*(s[1]+a[1]),.5*(s[2]+a[2])];if(!l)if(l=Wt(g,t[4],t[8],M)<this.res2){let t=Ut(this.differential(U[0],U[1],U[2],U[3]));H=[H[0]-G*t[0],H[1]-G*t[1],H[2]-G*t[2]]}else H=S[12];let j=[.5*(a[0]+o[0]),.5*(a[1]+o[1]),.5*(a[2]+o[2])];if(!c)if(c=Wt(M,t[13],t[14],b)<this.res2){let t=Ut(this.differential(V[12],V[8],V[4],V[0]));j=[j[0]-G*t[0],j[1]-G*t[1],j[2]-G*t[2]]}else j=U[15];let k=[.5*(o[0]+h[0]),.5*(o[1]+h[1]),.5*(o[2]+h[2])];if(!d)if(d=Wt(b,t[11],t[7],w)<this.res2){let t=Ut(this.differential(B[15],B[14],B[13],B[12]));k=[k[0]-G*t[0],k[1]-G*t[1],k[2]-G*t[2]]}else k=V[3];let Y=[.5*(h[0]+s[0]),.5*(h[1]+s[1]),.5*(h[2]+s[2])];if(!m)if(m=Wt(g,t[1],t[2],w)<this.res2){let t=Ut(this.differential(S[3],S[7],S[11],S[15]));Y=[Y[0]-G*t[0],Y[1]-G*t[1],Y[2]-G*t[2]]}else Y=B[0];if(f){let t=Array(4),x=Array(4),g=Array(4),w=Array(4),M=Array(4);for(let e=0;e<4;++e)t[e]=.5*(f[e]+u[e]),x[e]=.5*(u[e]+p[e]),g[e]=.5*(p[e]+v[e]),w[e]=.5*(v[e]+f[e]),M[e]=.5*(t[e]+g[e]);let b=this.data.Vertex(H,C,t),T=this.data.Vertex(j,F,x),R=this.data.Vertex(k,z,g),y=this.data.Vertex(Y,X,w),A=this.data.Vertex(D,W,M);this.Render(S,e,b,A,y,s,H,D,Y,l,!1,!1,m,f,t,M,w),this.Render(U,b,i,T,A,H,a,j,D,l,c,!1,!1,t,u,x,M),this.Render(V,A,T,n,R,D,j,o,k,!1,c,d,!1,M,x,p,g),this.Render(B,y,A,R,r,Y,D,k,h,!1,!1,d,m,w,M,g,v)}else{let t=this.vertex(H,C),f=this.vertex(j,F),u=this.vertex(k,z),p=this.vertex(Y,X),v=this.vertex(D,W);this.Render(S,e,t,v,p,s,H,D,Y,l,!1,!1,m),this.Render(U,t,i,f,v,H,a,j,D,l,c,!1,!1),this.Render(V,v,f,n,u,D,j,o,k,!1,c,d,!1),this.Render(B,p,v,u,r,Y,D,k,h,!1,!1,d,m)}}}process3(t){if(1==V)return this.curve(t,0,1,3,6),this.curve(t,6,7,8,9),void this.curve(t,9,5,2,0);let e=t[0],i=t[6],n=t[9],r=this.normal(n,t[5],t[2],e,t[1],t[3],i),s=this.normal(e,t[1],t[3],i,t[7],t[8],n),a=this.normal(i,t[7],t[8],n,t[5],t[2],e);if(this.color){let o=this.color[0],h=this.color[1],l=this.color[2],c=this.data.Vertex(e,r,o),d=this.data.Vertex(i,s,h),m=this.data.Vertex(n,a,l);this.Render3(t,c,d,m,e,i,n,!1,!1,!1,o,h,l)}else{let o=this.vertex(e,r),h=this.vertex(i,s),l=this.vertex(n,a);this.Render3(t,o,h,l,e,i,n,!1,!1,!1)}this.data.indices.length>0&&this.append()}Render3(t,e,i,n,r,s,a,o,h,l,c,d,m){if(this.Distance3(t)<this.res2)this.offscreen([r,s,a])||(0==V?(this.data.indices.push(e),this.data.indices.push(i),this.data.indices.push(n)):(this.data.indices.push(e),this.data.indices.push(i),this.data.indices.push(i),this.data.indices.push(n),this.data.indices.push(n),this.data.indices.push(e)));else{if(this.offscreen(t))return;let f=t[0],u=t[1],p=t[2],v=t[3],x=t[4],g=t[5],w=t[6],M=t[7],b=t[8],T=t[9],R=[.5*(T[0]+g[0]),.5*(T[1]+g[1]),.5*(T[2]+g[2])],y=[.5*(T[0]+b[0]),.5*(T[1]+b[1]),.5*(T[2]+b[2])],A=[.5*(g[0]+p[0]),.5*(g[1]+p[1]),.5*(g[2]+p[2])],E=[.5*(b[0]+x[0]),.5*(b[1]+x[1]),.5*(b[2]+x[2])],I=[.5*(b[0]+M[0]),.5*(b[1]+M[1]),.5*(b[2]+M[2])],L=[.5*(p[0]+x[0]),.5*(p[1]+x[1]),.5*(p[2]+x[2])],N=[.5*(p[0]+f[0]),.5*(p[1]+f[1]),.5*(p[2]+f[2])],_=[.5*(x[0]+v[0]),.5*(x[1]+v[1]),.5*(x[2]+v[2])],O=[.5*(M[0]+w[0]),.5*(M[1]+w[1]),.5*(M[2]+w[2])],P=[.5*(f[0]+u[0]),.5*(f[1]+u[1]),.5*(f[2]+u[2])],S=[.5*(u[0]+v[0]),.5*(u[1]+v[1]),.5*(u[2]+v[2])],U=[.5*(v[0]+w[0]),.5*(v[1]+w[1]),.5*(v[2]+w[2])],V=[.5*(R[0]+A[0]),.5*(R[1]+A[1]),.5*(R[2]+A[2])],B=[.5*(y[0]+I[0]),.5*(y[1]+I[1]),.5*(y[2]+I[2])],D=[.5*(A[0]+N[0]),.5*(A[1]+N[1]),.5*(A[2]+N[2])],C=[.5*E[0]+.25*(x[0]+u[0]),.5*E[1]+.25*(x[1]+u[1]),.5*E[2]+.25*(x[2]+u[2])],F=[.5*(I[0]+O[0]),.5*(I[1]+O[1]),.5*(I[2]+O[2])],z=[.5*L[0]+.25*(x[0]+M[0]),.5*L[1]+.25*(x[1]+M[1]),.5*L[2]+.25*(x[2]+M[2])],X=[.25*(g[0]+x[0])+.5*_[0],.25*(g[1]+x[1])+.5*_[1],.25*(g[2]+x[2])+.5*_[2]],W=[.5*(P[0]+S[0]),.5*(P[1]+S[1]),.5*(P[2]+S[2])],G=[.5*(S[0]+U[0]),.5*(S[1]+U[1]),.5*(S[2]+U[2])],H=[.5*(z[0]+W[0]),.5*(z[1]+W[1]),.5*(z[2]+W[2])],j=[.5*(z[0]+G[0]),.5*(z[1]+G[1]),.5*(z[2]+G[2])],k=[.5*(W[0]+G[0]),.5*(W[1]+G[1]),.5*(W[2]+G[2])],Y=[.5*(X[0]+F[0]),.5*(X[1]+F[1]),.5*(X[2]+F[2])],$=[.5*(B[0]+X[0]),.5*(B[1]+X[1]),.5*(B[2]+X[2])],q=[.5*(B[0]+F[0]),.5*(B[1]+F[1]),.5*(B[2]+F[2])],K=[.5*(V[0]+C[0]),.5*(V[1]+C[1]),.5*(V[2]+C[2])],Z=[.5*(D[0]+C[0]),.5*(D[1]+C[1]),.5*(D[2]+C[2])],Q=[.5*(V[0]+D[0]),.5*(V[1]+D[1]),.5*(V[2]+D[2])],J=[f,P,N,W,[.5*(L[0]+P[0]),.5*(L[1]+P[1]),.5*(L[2]+P[2])],D,k,H,Z,Q],tt=[k,G,j,U,[.5*(_[0]+O[0]),.5*(_[1]+O[1]),.5*(_[2]+O[2])],Y,w,O,F,q],et=[Q,K,V,$,[.5*(R[0]+E[0]),.5*(R[1]+E[1]),.5*(R[2]+E[2])],R,q,B,y,T],it=[q,$,Y,K,[.25*(A[0]+I[0]+S[0]+x[0]),.25*(A[1]+I[1]+S[1]+x[1]),.25*(A[2]+I[2]+S[2]+x[2])],j,Q,Z,H,k],nt=this.normal(k,j,Y,q,$,K,Q),rt=this.normal(q,$,K,Q,Z,H,k),st=this.normal(Q,Z,H,k,j,Y,q),at=this.Epsilon,ot=[.5*(s[0]+a[0]),.5*(s[1]+a[1]),.5*(s[2]+a[2])];if(!o)if(o=Wt(w,M,b,T)<this.res2){let t=Ut(this.sumdifferential(it[0],it[2],it[5],it[9],it[1],it[3],it[6]));ot=[ot[0]-at*t[0],ot[1]-at*t[1],ot[2]-at*t[2]]}else ot=q;let ht=[.5*(a[0]+r[0]),.5*(a[1]+r[1]),.5*(a[2]+r[2])];if(!h)if(h=Wt(f,p,g,T)<this.res2){let t=Ut(this.sumdifferential(it[6],it[3],it[1],it[0],it[7],it[8],it[9]));ht=[ht[0]-at*t[0],ht[1]-at*t[1],ht[2]-at*t[2]]}else ht=Q;let lt=[.5*(r[0]+s[0]),.5*(r[1]+s[1]),.5*(r[2]+s[2])];if(!l)if(l=Wt(f,u,v,w)<this.res2){let t=Ut(this.sumdifferential(it[9],it[8],it[7],it[6],it[5],it[2],it[0]));lt=[lt[0]-at*t[0],lt[1]-at*t[1],lt[2]-at*t[2]]}else lt=k;if(c){let t=Array(4),f=Array(4),u=Array(4);for(let e=0;e<4;++e)t[e]=.5*(d[e]+m[e]),f[e]=.5*(m[e]+c[e]),u[e]=.5*(c[e]+d[e]);let p=this.data.Vertex(ot,nt,t),v=this.data.Vertex(ht,rt,f),x=this.data.Vertex(lt,st,u);this.Render3(J,e,x,v,r,lt,ht,!1,h,l,c,u,f),this.Render3(tt,x,i,p,lt,s,ot,o,!1,l,u,d,t),this.Render3(et,v,p,n,ht,ot,a,o,h,!1,f,t,m),this.Render3(it,p,v,x,ot,ht,lt,!1,!1,!1,t,f,u)}else{let t=this.vertex(ot,nt),c=this.vertex(ht,rt),d=this.vertex(lt,st);this.Render3(J,e,d,c,r,lt,ht,!1,h,l),this.Render3(tt,d,i,t,lt,s,ot,o,!1,l),this.Render3(et,c,t,n,ht,ot,a,o,h,!1),this.Render3(it,t,c,d,ot,ht,lt,!1,!1,!1)}}}Distance(t){let e=t[0],i=t[3],n=t[12],r=t[15],s=Gt(e,n,i,r);s=Math.max(s,Wt(e,t[4],t[8],n)),s=Math.max(s,Wt(t[1],t[5],t[9],t[13])),s=Math.max(s,Wt(i,t[7],t[11],r)),s=Math.max(s,Wt(t[2],t[6],t[10],t[14]));let a=Gt(e,i,n,r);return a=Math.max(a,Wt(e,t[1],t[2],i)),a=Math.max(a,Wt(t[4],t[5],t[6],t[7])),a=Math.max(a,Wt(t[8],t[9],t[10],t[11])),a=Math.max(a,Wt(n,t[13],t[14],r)),[s,a]}Distance3(t){let e=t[0],i=t[4],n=t[6],r=t[9],s=Vt([(e[0]+n[0]+r[0])*(1/3)-i[0],(e[1]+n[1]+r[1])*(1/3)-i[1],(e[2]+n[2]+r[2])*(1/3)-i[2]]);return s=Math.max(s,Wt(e,t[1],t[3],n)),s=Math.max(s,Wt(e,t[2],t[5],r)),Math.max(s,Wt(n,t[7],t[8],r))}differential(t,e,i,n){let r=[3*(e[0]-t[0]),3*(e[1]-t[1]),3*(e[2]-t[2])];return Vt(r)>this.epsilon?r:(r=zt(t,e,i),Vt(r)>this.epsilon?r:Xt(t,e,i,n))}sumdifferential(t,e,i,n,r,s,a){let o=this.differential(t,e,i,n),h=this.differential(t,r,s,a);return[o[0]+h[0],o[1]+h[1],o[2]+h[2]]}normal(t,e,i,n,r,s,a){let o=3*(r[0]-n[0]),h=3*(r[1]-n[1]),l=3*(r[2]-n[2]),c=3*(i[0]-n[0]),d=3*(i[1]-n[1]),m=3*(i[2]-n[2]),f=[h*m-l*d,l*c-o*m,o*d-h*c];if(Vt(f)>this.epsilon)return f;let u=[c,d,m],p=[o,h,l],v=zt(n,i,e),x=zt(n,r,s),g=Dt(x,u),w=Dt(p,v);if(f=[g[0]+w[0],g[1]+w[1],g[2]+w[2]],Vt(f)>this.epsilon)return f;let M=Xt(n,i,e,t),b=Xt(n,r,s,a);g=Dt(p,M),w=Dt(b,u);let T=Dt(x,v);return f=[g[0]+w[0]+T[0],g[1]+w[1]+T[1],g[2]+w[2]+T[2]],Vt(f)>this.epsilon?f:(g=Dt(b,v),w=Dt(x,M),f=[g[0]+w[0],g[1]+w[1],g[2]+w[2]],Vt(f)>this.epsilon?f:Dt(b,M))}}function gt(t){return 0<=t&&t<=1}class wt{constructor(t,e,i){const n=1e3*Number.EPSILON,r=n*n;if(Math.abs(t)<=n*Math.abs(e)+r*Math.abs(i))Math.abs(e)>n*Math.abs(i)?(this.roots=1,this.t1=-i/e):0==i?(this.roots=1,this.t1=0):this.roots=0;else{let r=.5*e/t,s=e*r;if(Math.abs(s)<=n*Math.abs(i)){let e=-i/t;e>=0?(this.roots=2,this.t2=Math.sqrt(e),this.t1=-this.t2):this.roots=0}else{let t=-2*i/s;if(t>-1){this.roots=2;let e=r*function(t){return t/(Math.sqrt(1+t)+1)}(t),i=-e-2*r;i<=e?(this.t1=i,this.t2=e):(this.t1=e,this.t2=i)}else-1==t?(this.roots=1,this.t1=this.t2=-r):this.roots=0}}}}class Mt extends pt{constructor(t,e,i,n,r){if(super(),this.controlpoints=t,this.CenterIndex=e,this.MaterialIndex=i,n&&r)this.Min=n,this.Max=r;else{let t=this.Bounds(this.controlpoints);this.Min=t[0],this.Max=t[1]}}Bounds(t){let e=Array(3),i=Array(3),n=t.length,r=Array(n);for(let h=0;h<3;++h){for(let e=0;e<n;++e)r[e]=t[e][h];let l,c;if(l=c=r[0],4==n){l=Math.min(l,r[3]),c=Math.max(c,r[3]);let t=(s=r[0],a=r[1],o=r[2],[r[3]-s+3*(a-o),2*(s+o)-4*a,a-s]),e=new wt(t[0],t[1],t[2]);if(0!=e.roots&&gt(e.t1)){let t=Ct(r[0],r[1],r[2],r[3],e.t1);l=Math.min(l,t),c=Math.max(c,t)}if(2==e.roots&&gt(e.t2)){let t=Ct(r[0],r[1],r[2],r[3],e.t2);l=Math.min(l,t),c=Math.max(c,t)}}else{let t=r[1];l=Math.min(l,t),c=Math.max(c,t)}e[h]=l,i[h]=c}var s,a,o;return[[e[0],e[1],e[2]],[i[0],i[1],i[2]]]}setMaterialIndex(){this.setMaterial(Z,Ae)}processLine(t){let e=t[0],i=t[1];if(!this.offscreen([e,i])){let t=[0,0,1];this.data.indices.push(this.data.vertex(e,t)),this.data.indices.push(this.data.vertex(i,t)),this.append()}}process(t){if(2==t.length)return this.processLine(t);let e=t[0],i=t[1],n=t[2],r=t[3],s=this.normal(Ft(e,i),zt(e,i,n)),a=this.normal(Ft(n,r),zt(r,n,i)),o=this.data.vertex(e,s),h=this.data.vertex(r,a);this.Render(t,o,h),this.data.indices.length>0&&this.append()}append(){Z.append(this.data)}notRendered(){Z.rendered=!1}Render(t,e,i){let n=t[0],r=t[1],s=t[2],a=t[3];if(Wt(n,r,s,a)<this.res2)this.offscreen([n,a])||(this.data.indices.push(e),this.data.indices.push(i));else{if(this.offscreen(t))return;let o=[.5*(n[0]+r[0]),.5*(n[1]+r[1]),.5*(n[2]+r[2])],h=[.5*(r[0]+s[0]),.5*(r[1]+s[1]),.5*(r[2]+s[2])],l=[.5*(s[0]+a[0]),.5*(s[1]+a[1]),.5*(s[2]+a[2])],c=[.5*(o[0]+h[0]),.5*(o[1]+h[1]),.5*(o[2]+h[2])],d=[.5*(h[0]+l[0]),.5*(h[1]+l[1]),.5*(h[2]+l[2])],m=[.5*(c[0]+d[0]),.5*(c[1]+d[1]),.5*(c[2]+d[2])],f=[n,o,c,m],u=[m,d,l,a],p=this.normal(function(t,e,i,n){return[i[0]+n[0]-t[0]-e[0],i[1]+n[1]-t[1]-e[1],i[2]+n[2]-t[2]-e[2]]}(n,r,s,a),function(t,e,i,n){return[3*t[0]-5*e[0]+i[0]+n[0],3*t[1]-5*e[1]+i[1]+n[1],3*t[2]-5*e[2]+i[2]+n[2]]}(n,r,s,a)),v=this.data.vertex(m,p);this.Render(f,e,v),this.Render(u,v,i)}}normal(t,e){let i=Bt(t,t),n=Bt(t,e);return[i*e[0]-n*t[0],i*e[1]-n*t[1],i*e[2]-n*t[2]]}}class bt extends pt{constructor(t,e,i){super(),this.controlpoint=t,this.width=e,this.CenterIndex=0,this.MaterialIndex=i,this.Min=t,this.Max=t}setMaterialIndex(){this.setMaterial(K,ye)}process(t){this.data.indices.push(this.data.vertex0(this.controlpoint,this.width)),this.append()}append(){K.append(this.data)}notRendered(){K.rendered=!1}}class Tt extends pt{constructor(t,e){super(),this.CenterIndex=t,this.MaterialIndex=e,this.controlpoints=window.Positions,this.Normals=window.Normals,this.Colors=window.Colors,this.Indices=window.Indices,this.transparent=c[this.MaterialIndex].diffuse[3]<1,this.Min=this.Bounds(this.controlpoints,Math.min),this.Max=this.Bounds(this.controlpoints,Math.max)}Bounds(t,e){let i=Array(3),n=t.length,r=Array(n);for(let s=0;s<3;++s){for(let e=0;e<n;++e)r[e]=t[e][s];i[s]=vt(r,e)}return[i[0],i[1],i[2]]}setMaterialIndex(){this.transparent?this.setMaterial(tt,Ne):this.setMaterial(et,Le)}process(t){this.data.vertices=new Array(6*t.length),it=this.Colors.length>0?-1-it:1+it;for(let e=0,i=this.Indices.length;e<i;++e){let i=this.Indices[e],n=i[0],r=t[n[0]],s=t[n[1]],a=t[n[2]],o=!this.offscreen([r,s,a]),h=i.length>1?i[1]:n;if(h&&0!=h.length||(h=n),this.Colors.length>0){let t=i.length>2?i[2]:n;t&&0!=t.length||(t=n);let e=this.Colors[t[0]],l=this.Colors[t[1]],c=this.Colors[t[2]];this.transparent|=e[3]+l[3]+c[3]<3,0==V?(this.data.iVertex(n[0],r,this.Normals[h[0]],o,e),this.data.iVertex(n[1],s,this.Normals[h[1]],o,l),this.data.iVertex(n[2],a,this.Normals[h[2]],o,c)):(this.data.iVertex(n[0],r,this.Normals[h[0]],o,e),this.data.iVertex(n[1],s,this.Normals[h[1]],o,l),this.data.iVertex(n[1],s,this.Normals[h[1]],o,l),this.data.iVertex(n[2],a,this.Normals[h[2]],o,c),this.data.iVertex(n[2],a,this.Normals[h[2]],o,c),this.data.iVertex(n[0],r,this.Normals[h[0]],o,e))}else 0==V?(this.data.iVertex(n[0],r,this.Normals[h[0]],o),this.data.iVertex(n[1],s,this.Normals[h[1]],o),this.data.iVertex(n[2],a,this.Normals[h[2]],o)):(this.data.iVertex(n[0],r,this.Normals[h[0]],o),this.data.iVertex(n[1],s,this.Normals[h[1]],o),this.data.iVertex(n[1],s,this.Normals[h[1]],o),this.data.iVertex(n[2],a,this.Normals[h[2]],o),this.data.iVertex(n[2],a,this.Normals[h[2]],o),this.data.iVertex(n[0],r,this.Normals[h[0]],o))}this.data.nvertices=t.length,this.data.indices.length>0&&this.append()}append(){this.transparent?tt.append(this.data):et.append(this.data)}notRendered(){this.transparent?tt.rendered=!1:et.rendered=!1}}function Rt(){M=-Math.tan(.5*o.angleOfView)*o.maxBound[2],O.x=O.y=0,O.z=.5*(o.minBound[2]+o.maxBound[2]),x=v=o.zoom0,S.zmin=o.minBound[2],S.zmax=o.maxBound[2],P.x=P.y=0,Pe(),U=!0,Oe()}function yt(){mat4.identity(R),Rt(),window.top.asyWebApplication&&window.top.asyWebApplication.setProjection(""),window.parent.asyProjection=!1}let At=0,Et=1,It=2,Lt=3,Nt=4;function _t(e=[]){let i=ct(t,vertex,t.VERTEX_SHADER,e),n=ct(t,fragment,t.FRAGMENT_SHADER,e),r=t.createProgram();return t.attachShader(r,i),t.attachShader(r,n),t.bindAttribLocation(r,At,"position"),t.bindAttribLocation(r,Et,"normal"),t.bindAttribLocation(r,It,"materialIndex"),t.bindAttribLocation(r,Lt,"color"),t.bindAttribLocation(r,Nt,"width"),t.linkProgram(r),t.getProgramParameter(r,t.LINK_STATUS)||alert("Could not initialize shaders"),r}class Ot{constructor(t,e,i,n){this.m0=.5*(t+e);let r=.5*(e+i);this.m2=.5*(i+n),this.m3=.5*(this.m0+r),this.m4=.5*(r+this.m2),this.m5=.5*(this.m3+this.m4)}}class Pt{constructor(t,e,i,n){this.m0=[.5*(t[0]+e[0]),.5*(t[1]+e[1]),.5*(t[2]+e[2])];let r=.5*(e[0]+i[0]),s=.5*(e[1]+i[1]),a=.5*(e[2]+i[2]);this.m2=[.5*(i[0]+n[0]),.5*(i[1]+n[1]),.5*(i[2]+n[2])],this.m3=[.5*(this.m0[0]+r),.5*(this.m0[1]+s),.5*(this.m0[2]+a)],this.m4=[.5*(r+this.m2[0]),.5*(s+this.m2[1]),.5*(a+this.m2[2])],this.m5=[.5*(this.m3[0]+this.m4[0]),.5*(this.m3[1]+this.m4[1]),.5*(this.m3[2]+this.m4[2])]}}class St{constructor(t){this.l003=t[0];let e=t[1],i=t[2],n=t[3],r=t[4],s=t[5];this.r300=t[6];let a=t[7],o=t[8];this.u030=t[9],this.u021=.5*(this.u030+s),this.u120=.5*(this.u030+o);let h=.5*(s+i),l=.5*(o+r),c=.5*(o+a),d=.5*(i+r);this.l012=.5*(i+this.l003);let m=.5*(r+n);this.r210=.5*(a+this.r300),this.l102=.5*(this.l003+e);let f=.5*(e+n);this.r201=.5*(n+this.r300),this.u012=.5*(this.u021+h),this.u210=.5*(this.u120+c),this.l021=.5*(h+this.l012);let u=.5*l+.25*(r+e);this.r120=.5*(c+this.r210);let p=.5*d+.25*(r+a),v=.25*(s+r)+.5*m;this.l201=.5*(this.l102+f),this.r102=.5*(f+this.r201),this.l210=.5*(p+this.l201),this.r012=.5*(p+this.r102),this.l300=.5*(this.l201+this.r102),this.r021=.5*(v+this.r120),this.u201=.5*(this.u210+v),this.r030=.5*(this.u210+this.r120),this.u102=.5*(this.u012+u),this.l120=.5*(this.l021+u),this.l030=.5*(this.u012+this.l021),this.l111=.5*(d+this.l102),this.r111=.5*(m+this.r210),this.u111=.5*(this.u021+l),this.c111=.25*(h+c+f+r)}}function Ut(t){let e=1/(Math.sqrt(t[0]*t[0]+t[1]*t[1]+t[2]*t[2])||1);return[t[0]*e,t[1]*e,t[2]*e]}function Vt(t){return t[0]*t[0]+t[1]*t[1]+t[2]*t[2]}function Bt(t,e){return t[0]*e[0]+t[1]*e[1]+t[2]*e[2]}function Dt(t,e){return[t[1]*e[2]-t[2]*e[1],t[2]*e[0]-t[0]*e[2],t[0]*e[1]-t[1]*e[0]]}function Ct(t,e,i,n,r){let s=1-r,a=s*s;return a*s*t+r*(3*(a*e+r*s*i)+r*r*n)}function Ft(t,e){return[e[0]-t[0],e[1]-t[1],e[2]-t[2]]}function zt(t,e,i){return[3*(t[0]+i[0])-6*e[0],3*(t[1]+i[1])-6*e[1],3*(t[2]+i[2])-6*e[2]]}function Xt(t,e,i,n){return[n[0]-t[0]+3*(e[0]-i[0]),n[1]-t[1]+3*(e[1]-i[1]),n[2]-t[2]+3*(e[2]-i[2])]}function Wt(t,e,i,n){let r=[1/3*(n[0]-t[0]),1/3*(n[1]-t[1]),1/3*(n[2]-t[2])];return Math.max(Vt([e[0]-r[0]-t[0],e[1]-r[1]-t[1],e[2]-r[2]-t[2]]),Vt([n[0]-r[0]-i[0],n[1]-r[1]-i[1],n[2]-r[2]-i[2]]))}function Gt(t,e,i,n){let r=[e[0]-t[0],e[1]-t[1],e[2]-t[2]],s=[n[0]-i[0],n[1]-i[1],n[2]-i[2]];return Math.max(Vt(Dt(r,Ut(s))),Vt(Dt(s,Ut(r))))/9}function Ht(t){return[Math.min(t[0][0],t[1][0],t[2][0],t[3][0],t[4][0],t[5][0],t[6][0],t[7][0]),Math.min(t[0][1],t[1][1],t[2][1],t[3][1],t[4][1],t[5][1],t[6][1],t[7][1]),Math.min(t[0][2],t[1][2],t[2][2],t[3][2],t[4][2],t[5][2],t[6][2],t[7][2])]}function jt(t){return[Math.max(t[0][0],t[1][0],t[2][0],t[3][0],t[4][0],t[5][0],t[6][0],t[7][0]),Math.max(t[0][1],t[1][1],t[2][1],t[3][1],t[4][1],t[5][1],t[6][1],t[7][1]),Math.max(t[0][2],t[1][2],t[2][2],t[3][2],t[4][2],t[5][2],t[6][2],t[7][2])]}function kt(t){he||le(),B=!0,D=t.clientX,C=t.clientY}let Yt,$t,qt=!1;function Kt(t){return Math.hypot(t[0].pageX-t[1].pageX,t[0].pageY-t[1].pageY)}function Zt(t){t.preventDefault(),he||le();let e=t.targetTouches;ve=xe=qt=!1,pe||(1!=e.length||B||($t=(new Date).getTime(),touchId=e[0].identifier,D=e[0].pageX,C=e[0].pageY),2!=e.length||B||(touchId=e[0].identifier,Yt=Kt(e),qt=!0))}function Qt(t){B=!1}function Jt(t,e,i,n,r){if(t==i&&e==n)return;let[s,a]=function(t,e){let i=se(t),n=se(e),r=Bt(i,n);return[r>1?0:r<-1?f:Math.acos(r),Ut(Dt(i,n))]}([t,-e],[i,-n]);mat4.fromRotation(_,2*r*T*s/v,a),mat4.multiply(R,_,R)}function te(t,e,i,n){let r=1/v;P.x+=(i-t)*r*s,P.y-=(n-e)*r*a}function ee(t,e,i,n){o.orthographic?te(t,e,i,n):(O.x+=(i-t)*(S.xmax-S.xmin),O.y-=(n-e)*(S.ymax-S.ymin))}function ie(){var t,e;t=A,e=R,mat4.fromTranslation(_,[O.x,O.y,O.z]),mat4.invert(N,_),mat4.multiply(t,e,N),mat4.multiply(t,_,t),mat4.translate(A,A,[O.x,O.y,0]),mat3.fromMat4(L,A),mat3.invert(I,L),mat4.multiply(E,y,A)}function ne(){let t=Math.sqrt(Number.MAX_VALUE),e=1/t;v<=e&&(v=e),v>=t&&(v=t),(1.5*v<x||v>1.5*x)&&(U=!0,x=v)}function re(t){let e=o.zoomStep*a*t;const i=Math.log(.1*Number.MAX_VALUE)/Math.log(o.zoomFactor);Math.abs(e)<i&&(v*=o.zoomFactor**e,ne())}function se(t){let e=t[0],i=t[1],n=Math.hypot(e,i);return n>1&&(denom=1/n,e*=denom,i*=denom),[e,i,Math.sqrt(Math.max(1-i*i-e*e,0))]}function ae(t,e,i,n){re(e-n)}function oe(t,e,i,n=1){let r;switch(i){case 1:r=Jt;break;case 2:r=te;break;case 3:r=ae;break;case 4:r=ee;break;default:r=(t,e,i,n)=>{}}r((D-s)/s,(C-a)/a,(t-s)/s,(e-a)/a,n),D=t,C=e,Pe(),Oe()}let he=0;function le(){he=1,o.canvas.addEventListener("wheel",fe,!1)}function ce(){let t,e,i;[t,e,i]=function(){let t=Array(3),e=Array(3),i=Array(3),n=O.x,r=O.y,s=.5*(S.zmin+S.zmax);for(let a=0;a<3;++a){let h=0,l=0,c=0,d=4*a;for(let t=0;t<4;++t){let e=4*t,i=R[e],a=R[e+1],m=R[e+2],f=R[e+3],u=o.Transform[d+t];h+=u*(f-n*i-r*a-s*m),c+=u*a,l+=u*(f-n*i-r*a)}t[a]=h,e[a]=c,i[a]=l}return[t,e,i]}();let n=o.orthographic?"  orthographic(":"  perspective(",r="".padStart(n.length),s="currentprojection=\n"+n+"camera=("+t+"),\n"+r+"up=("+e+"),\n"+r+"target=("+i+"),\n"+r+"zoom="+v*o.initialZoom/o.zoom0;return o.orthographic||(s+=",\n"+r+"angle="+2*Math.atan(Math.tan(.5*o.angleOfView)/v)/u),0==g&&0==w||(s+=",\n"+r+"viewportshift=("+g+","+w+")"),o.orthographic||(s+=",\n"+r+"autoadjust=false"),s+=");\n",window.parent.asyProjection=!0,s}function de(t){if(he||le(),o.embedded&&he&&27==t.keyCode)return he=0,void o.canvas.removeEventListener("wheel",fe,!1);let e=[];switch(t.key){case"x":e=[1,0,0];break;case"y":e=[0,1,0];break;case"z":e=[0,0,1];break;case"h":yt();break;case"m":++V,3==V&&(V=0),2!=V&&(o.embedded||st(),rt(o.ibl)),U=!0,Oe();break;case"+":case"=":case">":v*=o.zoomFactor,me();break;case"-":case"_":case"<":v/=o.zoomFactor,me();break;case"c":window.top.asyWebApplication||prompt("Ctrl+c Enter to copy currentprojection to clipboard; then append to asy file:",ce())}e.length>0&&(mat4.rotate(R,R,.1,e),ie(),Oe())}function me(){ne(),Pe(),Oe()}function fe(t){t.preventDefault(),t.deltaY<0?v*=o.zoomFactor:v/=o.zoomFactor,me()}function ue(t){if(!B)return;let e,i=t.clientX,n=t.clientY;e=t.getModifierState("Control")?2:t.getModifierState("Shift")?3:t.getModifierState("Alt")?4:1,oe(i,n,e)}let pe=!1,ve=!1,xe=!1;function ge(t){if(t.preventDefault(),pe)return;let e=t.targetTouches;if(!qt&&1==e.length&&touchId==e[0].identifier){let t=e[0].pageX,i=e[0].pageY,n=t-D,r=i-C,s=n*n+r*r<=o.shiftHoldDistance*o.shiftHoldDistance;if(s&&!ve&&!xe&&(new Date).getTime()-$t>o.shiftWaitTime&&(navigator.vibrate&&window.navigator.vibrate(o.vibrateTime),ve=!0),ve)oe(t,i,2);else if(!s){xe=!0,oe(e[0].pageX,e[0].pageY,1,.5)}}if(qt&&!ve&&2==e.length&&touchId==e[0].identifier){let t=Kt(e),i=t-Yt;pe=!0,i*=o.zoomPinchFactor,i>o.zoomPinchCap&&(i=o.zoomPinchCap),i<-o.zoomPinchCap&&(i=-o.zoomPinchCap),re(i/b),Yt=t,ve=xe=pe=!1,Pe(),Oe()}}let we,Me,be,Te,Re=[];function ye(){mt(K,we),K.clear()}function Ae(){mt(Z,Me),Z.clear()}function Ee(){mt(Q,Me),Q.clear()}function Ie(){mt(J,be),J.clear()}function Le(){mt(et,Te),et.rendered=!1,et.clear()}function Ne(){let e=tt.indices;if(V>0)return mt(tt,Te,e),void tt.clear();if(e.length>0){!function(t){let e=A[2],i=A[6],n=A[10];Re.length=t.length;for(let r=0;r<t.length;++r){let s=6*r;Re[r]=e*t[s]+i*t[s+1]+n*t[s+2]}}(tt.vertices);let i=e.length/3,n=Array(i).fill().map((t,e)=>e);n.sort((function(t,i){let n=3*t;Ia=e[n],Ib=e[n+1],Ic=e[n+2];let r=3*i;return IA=e[r],IB=e[r+1],IC=e[r+2],Re[Ia]+Re[Ib]+Re[Ic]<Re[IA]+Re[IB]+Re[IC]?-1:1}));let r=Array(e.length);for(let t=0;t<i;++t){let i=3*n[t];r[3*t]=e[i],r[3*t+1]=e[i+1],r[3*t+2]=e[i+2]}t.depthMask(!1),mt(tt,Te,r),tt.rendered=!1,t.depthMask(!0)}tt.clear()}function _e(){ye(),Ae(),Ee(),Ie(),Le(),Ne(),requestAnimationFrame(_e)}function Oe(){o.embedded&&(i.width=o.canvasWidth,i.height=o.canvasHeight,Se()),t.clearColor(o.background[0],o.background[1],o.background[2],o.background[3]),t.clear(t.COLOR_BUFFER_BIT|t.DEPTH_BUFFER_BIT);for(const t of h)t.render();_e(),o.embedded&&(n.clearRect(0,0,o.canvasWidth,o.canvasHeight),n.drawImage(i,0,0)),0==V&&(U=!1)}function Pe(){!function(t,e,i,n){let r=t/e;g=(i/t+o.viewportShift[0])*v,w=(n/e+o.viewportShift[1])*v;let s=1/v;if(o.orthographic){let t=o.maxBound[0]-o.minBound[0],e=o.maxBound[1]-o.minBound[1];if(t<e*r){let t=.5*e*r*s,i=2*t*g,n=e*s*w;S.xmin=-t-i,S.xmax=t-i,S.ymin=o.minBound[1]*s-n,S.ymax=o.maxBound[1]*s-n}else{let e=.5*t*s/r,i=t*s*g,n=2*e*w;S.xmin=o.minBound[0]*s-i,S.xmax=o.maxBound[0]*s-i,S.ymin=-e-n,S.ymax=e-n}}else{let t=M*s,e=t*r,i=2*e*g,n=2*t*w;S.xmin=-e-i,S.xmax=e-i,S.ymin=-t-n,S.ymax=t-n}}(o.canvasWidth,o.canvasHeight,P.x,P.y),(o.orthographic?mat4.ortho:mat4.frustum)(y,S.xmin,S.xmax,S.ymin,S.ymax,-S.zmax,-S.zmin),ie(),window.top.asyWebApplication&&window.top.asyWebApplication.setProjection(ce())}function Se(){t.viewportWidth=o.canvasWidth,t.viewportHeight=o.canvasHeight,t.viewport(.5*(o.canvas.width-o.canvasWidth),.5*(o.canvas.height-o.canvasHeight),o.canvasWidth,o.canvasHeight),t.scissor(0,0,o.canvas.width,o.canvas.height)}function Ue(t,e){t>void 0&&(t=void 0),e>void 0&&(e=void 0),P.x*=t/o.canvasWidth,P.y*=e/o.canvasHeight,o.canvasWidth=t,o.canvasHeight=e,o.embedded&&(o.canvas.width=i.width=o.canvasWidth,o.canvas.height=i.height=o.canvasHeight),b=Math.hypot(o.canvasWidth,o.canvasHeight),s=.5*o.canvas.width,a=.5*o.canvas.height,T=1+8*Math.hypot(o.viewportMargin[0],o.viewportMargin[1])/b,Se(),Pe(),U=!0}function Ve(){if(o.zoom0=o.initialZoom,window.top.asyWebApplication&&""==window.top.asyWebApplication.getProjection()&&(window.parent.asyProjection=!1),o.absolute&&!o.embedded)o.canvasWidth=o.canvasWidth0*window.devicePixelRatio,o.canvasHeight=o.canvasHeight0*window.devicePixelRatio;else{let t=o.canvasWidth0/o.canvasHeight0;o.canvasWidth=Math.max(window.innerWidth-10,10),o.canvasHeight=Math.max(window.innerHeight-10,10),!o.orthographic&&!window.parent.asyProjection&&o.canvasWidth<o.canvasHeight*t&&(o.zoom0*=o.canvasWidth/(o.canvasHeight*t))}o.canvas.width=o.canvasWidth,o.canvas.height=o.canvasHeight;window.innerWidth,window.innerHeight;let t=1/o.zoom0;o.viewportShift[0]*=t,o.viewportShift[1]*=t,Ue(o.canvasWidth,o.canvasHeight),Rt()}class Be{constructor(t,e){if(this.center=t,e){let t=e[0],i=e[1];this.ct=Math.cos(t),this.st=Math.sin(t),this.cp=Math.cos(i),this.sp=Math.sin(i)}}T0(t){return[t[0]+this.center[0],t[1]+this.center[1],t[2]+this.center[2]]}T(t){let e=t[0],i=t[1],n=t[2],r=e*this.ct+n*this.st;return[r*this.cp-i*this.sp+this.center[0],r*this.sp+i*this.cp+this.center[1],-e*this.st+n*this.ct+this.center[2]]}}function De(t,e,i){let n=[t(e),t([e[0],e[1],i[2]]),t([e[0],i[1],e[2]]),t([e[0],i[1],i[2]]),t([i[0],e[1],e[2]]),t([i[0],e[1],i[2]]),t([i[0],i[1],e[2]]),t(i)];return[Ht(n),jt(n)]}let Ce=4/3*(Math.sqrt(2)-1);async function Fe(t){return(await fetch(t)).arrayBuffer()}function ze(t){return t.getBytes().filter((t,e)=>e%4!=3)}function Xe(e,i,n=t.RGB16F){let r=e.width(),s=e.height(),a=t.createTexture();return t.activeTexture(t.TEXTURE0+i),t.bindTexture(t.TEXTURE_2D,a),t.pixelStorei(t.UNPACK_ALIGNMENT,1),t.texParameteri(t.TEXTURE_2D,t.TEXTURE_MIN_FILTER,t.LINEAR),t.texParameteri(t.TEXTURE_2D,t.TEXTURE_MAG_FILTER,t.LINEAR),t.texImage2D(t.TEXTURE_2D,0,n,r,s,0,t.RGB,t.FLOAT,ze(e)),a}window.webGLStart=function(){o.canvas=document.getElementById("Asymptote"),o.embedded=window.top.document!=document,lt(),t.enable(t.BLEND),t.blendFunc(t.SRC_ALPHA,t.ONE_MINUS_SRC_ALPHA),t.enable(t.DEPTH_TEST),t.enable(t.SCISSOR_TEST),o.canvas.onmousedown=kt,document.onmouseup=Qt,document.onmousemove=ue,o.canvas.onkeydown=de,o.embedded||le(),o.canvas.addEventListener("touchstart",Zt,!1),o.canvas.addEventListener("touchend",Qt,!1),o.canvas.addEventListener("touchcancel",Qt,!1),o.canvas.addEventListener("touchleave",Qt,!1),o.canvas.addEventListener("touchmove",ge,!1),document.addEventListener("keydown",de,!1),o.canvasWidth0=o.canvasWidth,o.canvasHeight0=o.canvasHeight,mat4.identity(R),0!=window.innerWidth&&0!=window.innerHeight&&Ve(),window.addEventListener("resize",Ve,!1),o.ibl&&async function(){let e=o.imageURL+o.image+"/";function i(t){return new Promise(e=>setTimeout(e,t))}for(;!Module.EXRLoader;)await i(0);promises=[Fe(o.imageURL+"refl.exr").then(t=>{let e=new Module.EXRLoader(t);j=Xe(e,0)}),Fe(e+"diffuse.exr").then(t=>{let e=new Module.EXRLoader(t);H=Xe(e,1)})],refl_promise=[],refl_promise.push(Fe(e+"refl0.exr"));for(let t=1;t<=8;++t)refl_promise.push(Fe(e+"refl"+t+"w.exr"));finished_promise=Promise.all(refl_promise).then(e=>{let i=t.createTexture();t.activeTexture(t.TEXTURE0+2),t.pixelStorei(t.UNPACK_ALIGNMENT,1),t.bindTexture(t.TEXTURE_2D,i),t.texParameteri(t.TEXTURE_2D,t.TEXTURE_MAX_LEVEL,e.length-1),t.texParameteri(t.TEXTURE_2D,t.TEXTURE_MIN_FILTER,t.LINEAR_MIPMAP_LINEAR),t.texParameteri(t.TEXTURE_2D,t.TEXTURE_MAG_FILTER,t.LINEAR),t.texParameterf(t.TEXTURE_2D,t.TEXTURE_MIN_LOD,0),t.texParameterf(t.TEXTURE_2D,t.TEXTURE_MAX_LOD,8);for(let i=0;i<e.length;++i){let n=new Module.EXRLoader(e[i]);t.texImage2D(t.TEXTURE_2D,i,t.RGB16F,n.width(),n.height(),0,t.RGB,t.FLOAT,ze(n))}G=i}),promises.push(finished_promise),await Promise.all(promises)}().then(k).then(Rt),yt()},window.light=function(t,e){l.push(new nt(t,e))},window.material=function(t,e,i,n,r,s){c.push(new Y(t,e,i,n,r,s))},window.patch=function(t,e,i,n){h.push(new xt(t,e,i,n))},window.curve=function(t,e,i){h.push(new Mt(t,e,i))},window.pixel=function(t,e,i){h.push(new bt(t,e,i))},window.triangles=function(t,e){h.push(new Tt(t,e)),window.Positions=F=[],window.Normals=z=[],window.Colors=X=[],window.Indices=W=[]},window.sphere=function(t,e,i,n,r){let s,a,o,l,c,d,m=.524670512339254,f=.595936986722291,u=.954967051233925,p=.0820155480083437,v=.996685028842544,x=.0549670512339254,g=.998880711874577,w=.0405017186586849,M=[[[1,0,0],[1,0,m],[f,0,u],[p,0,v],[1,Ce,0],[1,Ce,m],[f,Ce*f,u],[p,Ce*p,v],[Ce,1,0],[Ce,1,m],[Ce*f,f,u],[Ce*p,p,v],[0,1,0],[0,1,m],[0,f,u],[0,p,v]],[[p,0,v],[p,Ce*p,v],[x,0,g],[Ce*p,p,v],[w,w,1],[.05*Ce,0,1],[0,p,v],[0,x,g],[0,.05*Ce,1],[0,0,1]]],b=new Be(t,r);function T(t){let e=Array(t.length);for(let i=0;i<t.length;++i){let n=t[i];e[i]=c([s*n[0],a*n[1],o*n[2]])}return e}r?(l=1,d=0,c=b.T.bind(b)):(l=-1,d=-e,c=b.T0.bind(b));let R=De(c,[-e,-e,d],[e,e,e]),y=R[0],A=R[1];for(let t=-1;t<=1;t+=2){s=t*e;for(let t=-1;t<=1;t+=2){a=t*e;for(let t=l;t<=1;t+=2){o=t*e;for(let t=0;t<2;++t)h.push(new xt(T(M[t]),i,n,null,y,A))}}}},window.disk=function(t,e,i,n,r){let s=1-2*Ce/3,a=[[1,0,0],[1,-Ce,0],[Ce,-1,0],[0,-1,0],[1,Ce,0],[s,0,0],[0,-s,0],[-Ce,-1,0],[Ce,1,0],[0,s,0],[-s,0,0],[-1,-Ce,0],[0,1,0],[-Ce,1,0],[-1,Ce,0],[-1,0,0]],o=new Be(t,r),l=De(o.T.bind(o),[-e,-e,0],[e,e,0]);h.push(new xt(function(t){let i=Array(t.length);for(let n=0;n<t.length;++n){let r=t[n];i[n]=o.T([e*r[0],e*r[1],0])}return i}(a),i,n,null,l[0],l[1]))},window.cylinder=function(t,e,i,n,r,s,a){let o,l,c=[[1,0,0],[1,0,1/3],[1,0,2/3],[1,0,1],[1,Ce,0],[1,Ce,1/3],[1,Ce,2/3],[1,Ce,1],[Ce,1,0],[Ce,1,1/3],[Ce,1,2/3],[Ce,1,1],[0,1,0],[0,1,1/3],[0,1,2/3],[0,1,1]],d=new Be(t,s);function m(t){let e=Array(t.length);for(let n=0;n<t.length;++n){let r=t[n];e[n]=d.T([o*r[0],l*r[1],i*r[2]])}return e}let f=De(d.T.bind(d),[-e,-e,0],[e,e,i]),u=f[0],p=f[1];for(let t=-1;t<=1;t+=2){o=t*e;for(let t=-1;t<=1;t+=2)l=t*e,h.push(new xt(m(c),n,r,null,u,p))}if(a){let e=d.T([0,0,i]);h.push(new Mt([t,e],n,r,t,e))}},window.tube=function(t,e,i,n,r){let s=function(t,e,i,n,r){class s{constructor(t,e,i){this.p=t,this.r=e,this.t=i,this.s=Dt(i,e)}}let a=Number.EPSILON*Math.max(Vt(t),Vt(e),Vt(i),Vt(n));function o(r){if(1==r){let r=[n[0]-i[0],n[1]-i[1],n[2]-i[2]];return Vt(r)>a?Ut(r):(r=[2*i[0]-e[0]-n[0],2*i[1]-e[1]-n[1],2*i[2]-e[2]-n[2]],Vt(r)>a?Ut(r):[n[0]-t[0]+3*(e[0]-i[0]),n[1]-t[1]+3*(e[1]-i[1]),n[2]-t[2]+3*(e[2]-i[2])])}let s=[n[0]-t[0]+3*(e[0]-i[0]),n[1]-t[1]+3*(e[1]-i[1]),n[2]-t[2]+3*(e[2]-i[2])],o=[2*(t[0]+i[0])-4*e[0],2*(t[1]+i[1])-4*e[1],2*(t[2]+i[2])-4*e[2]],h=[e[0]-t[0],e[1]-t[1],e[2]-t[2]],l=r*r,c=[s[0]*l+o[0]*r+h[0],s[1]*l+o[1]*r+h[1],s[2]*l+o[2]*r+h[2]];return Vt(c)>a?Ut(c):(l=2*r,c=[s[0]*l+o[0],s[1]*l+o[1],s[2]*l+o[2]],Vt(c)>a?Ut(c):Ut(s))}let h=Array(r.length),l=[e[0]-t[0],e[1]-t[1],e[2]-t[2]];Vt(l)<a&&(l=[t[0]-2*e[0]+i[0],t[1]-2*e[1]+i[1],t[2]-2*e[2]+i[2]],Vt(l)<a&&(l=[n[0]-t[0]+3*(e[0]-i[0]),n[1]-t[1]+3*(e[1]-i[1]),n[2]-t[2]+3*(e[2]-i[2])])),l=Ut(l);let c=function(t){let e=Dt(t,[0,1,0]),i=Number.EPSILON*Vt(t);return Vt(e)>i?Ut(e):(e=Dt(t,[0,0,1]),Vt(e)>i?Ut(e):[1,0,0])}(l);h[0]=new s(t,c,l);for(let a=1;a<r.length;++a){let l=h[a-1],c=r[a],d=1-c,m=d*d,f=m*d,u=3*c;m*=u,d*=u*c;let p=c*c*c,v=[f*t[0]+m*e[0]+d*i[0]+p*n[0],f*t[1]+m*e[1]+d*i[1]+p*n[1],f*t[2]+m*e[2]+d*i[2]+p*n[2]],x=[v[0]-l.p[0],v[1]-l.p[1],v[2]-l.p[2]];if(0!=x[0]||0!=x[1]||0!=x[2]){let t=l.r,e=Ut(x),i=l.t,n=Bt(e,i),r=[i[0]-2*n*e[0],i[1]-2*n*e[1],i[2]-2*n*e[2]];i=o(c);let d=2*Bt(e,t),m=[t[0]-d*e[0],t[1]-d*e[1],t[2]-d*e[2]],f=Ut([i[0]-r[0],i[1]-r[1],i[2]-r[2]]),u=2*Bt(f,m);m=[m[0]-u*f[0],m[1]-u*f[1],m[2]-u*f[2]],h[a]=new s(v,Ut(m),Ut(i))}else h[a]=h[a-1]}return h}(t[0],t[1],t[2],t[3],[0,1/3,2/3,1]),a=Ce*e,o=[[e,0],[e,a],[a,e],[0,e]];function l(e,r,a,l){let c=Array(16);for(let i=0;i<4;++i){let n=s[i],h=n.r[0],d=n.s[0],m=h*e+d*r,f=h*a+d*l;h=n.r[1],d=n.s[1];let u=h*e+d*r,p=h*a+d*l;h=n.r[2],d=n.s[2];let v=h*e+d*r,x=h*a+d*l,g=t[i],w=g[0];w1=g[1],w2=g[2];for(let t=0;t<4;++t){let e=o[t],n=e[0],r=e[1];c[4*i+t]=[m*n+f*r+w,u*n+p*r+w1,v*n+x*r+w2]}}h.push(new xt(c,i,n))}l(1,0,0,1),l(0,-1,1,0),l(-1,0,0,-1),l(0,1,-1,0),r&&h.push(new Mt(t,i,n))},window.Positions=F,window.Normals=z,window.Colors=X,window.Indices=W}();
