(self["webpackChunk_JUPYTERLAB_CORE_OUTPUT"] = self["webpackChunk_JUPYTERLAB_CORE_OUTPUT"] || []).push([[4144],{

/***/ 92871:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
// ESM COMPAT FLAG
__webpack_require__.r(__webpack_exports__);

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  DEFAULT_CONTEXT_ITEM_RANK: () => (/* binding */ DEFAULT_CONTEXT_ITEM_RANK),
  "default": () => (/* binding */ lib)
});

// EXTERNAL MODULE: consume shared module (default) @jupyterlab/application@~4.4.5 (singleton) (fallback: ../node_modules/@jupyterlab/application/lib/index.js)
var index_js_ = __webpack_require__(25949);
// EXTERNAL MODULE: consume shared module (default) @jupyterlab/apputils@~4.5.5 (singleton) (fallback: ../node_modules/@jupyterlab/apputils/lib/index.js)
var lib_index_js_ = __webpack_require__(6803);
// EXTERNAL MODULE: consume shared module (default) @jupyterlab/coreutils@~6.4.5 (singleton) (fallback: ../node_modules/@jupyterlab/coreutils/lib/index.js)
var coreutils_lib_index_js_ = __webpack_require__(24474);
// EXTERNAL MODULE: consume shared module (default) @jupyterlab/property-inspector@^4.4.5 (strict) (fallback: ../node_modules/@jupyterlab/property-inspector/lib/index.js)
var property_inspector_lib_index_js_ = __webpack_require__(19972);
// EXTERNAL MODULE: consume shared module (default) @jupyterlab/settingregistry@~4.4.5 (singleton) (fallback: ../node_modules/@jupyterlab/settingregistry/lib/index.js)
var settingregistry_lib_index_js_ = __webpack_require__(51680);
// EXTERNAL MODULE: consume shared module (default) @jupyterlab/statedb@~4.4.5 (singleton) (fallback: ../node_modules/@jupyterlab/statedb/lib/index.js)
var statedb_lib_index_js_ = __webpack_require__(68145);
// EXTERNAL MODULE: consume shared module (default) @jupyterlab/statusbar@~4.4.5 (singleton) (fallback: ../node_modules/@jupyterlab/statusbar/lib/index.js)
var statusbar_lib_index_js_ = __webpack_require__(74878);
// EXTERNAL MODULE: consume shared module (default) @jupyterlab/translation@~4.4.5 (singleton) (fallback: ../node_modules/@jupyterlab/translation/lib/index.js)
var translation_lib_index_js_ = __webpack_require__(38202);
// EXTERNAL MODULE: consume shared module (default) @jupyterlab/ui-components@~4.4.5 (singleton) (fallback: ../node_modules/@jupyterlab/ui-components/lib/index.js)
var ui_components_lib_index_js_ = __webpack_require__(52104);
// EXTERNAL MODULE: consume shared module (default) @lumino/algorithm@~2.0.3 (singleton) (fallback: ../node_modules/@lumino/algorithm/dist/index.es6.js)
var index_es6_js_ = __webpack_require__(56114);
// EXTERNAL MODULE: consume shared module (default) @lumino/coreutils@~2.2.1 (singleton) (fallback: ../node_modules/@lumino/coreutils/dist/index.js)
var dist_index_js_ = __webpack_require__(5406);
// EXTERNAL MODULE: consume shared module (default) @lumino/commands@~2.3.2 (singleton) (fallback: ../node_modules/@lumino/commands/dist/index.es6.js)
var dist_index_es6_js_ = __webpack_require__(35538);
// EXTERNAL MODULE: consume shared module (default) @lumino/disposable@~2.1.4 (singleton) (fallback: ../node_modules/@lumino/disposable/dist/index.es6.js)
var disposable_dist_index_es6_js_ = __webpack_require__(38302);
// EXTERNAL MODULE: consume shared module (default) @lumino/widgets@~2.7.1 (singleton) (fallback: ../node_modules/@lumino/widgets/dist/index.es6.js)
var widgets_dist_index_es6_js_ = __webpack_require__(60920);
// EXTERNAL MODULE: consume shared module (default) react@~18.2.0 (singleton) (fallback: ../node_modules/react/index.js)
var react_index_js_ = __webpack_require__(78156);
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/application-extension/lib/topbar.js
/*
 * Copyright (c) Jupyter Development Team.
 * Distributed under the terms of the Modified BSD License.
 */




const TOPBAR_FACTORY = 'TopBar';
/**
 * A plugin adding a toolbar to the top area.
 */
const topbar = {
    id: '@jupyterlab/application-extension:top-bar',
    description: 'Adds a toolbar to the top area (next to the main menu bar).',
    autoStart: true,
    requires: [settingregistry_lib_index_js_.ISettingRegistry, lib_index_js_.IToolbarWidgetRegistry],
    optional: [translation_lib_index_js_.ITranslator],
    activate: (app, settingRegistry, toolbarRegistry, translator) => {
        const trans = (translator !== null && translator !== void 0 ? translator : translation_lib_index_js_.nullTranslator).load('jupyterlab');
        const toolbar = new ui_components_lib_index_js_.Toolbar();
        toolbar.id = 'jp-top-bar';
        toolbar.node.setAttribute('aria-label', trans.__('Topbar toolbar'));
        // Set toolbar
        (0,lib_index_js_.setToolbar)(toolbar, (0,lib_index_js_.createToolbarFactory)(toolbarRegistry, settingRegistry, TOPBAR_FACTORY, topbar.id, translator !== null && translator !== void 0 ? translator : translation_lib_index_js_.nullTranslator), toolbar);
        app.shell.add(toolbar, 'top', { rank: 900 });
    }
};
//# sourceMappingURL=topbar.js.map
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/application-extension/lib/index.js
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
/**
 * @packageDocumentation
 * @module application-extension
 */
















/**
 * Default context menu item rank
 */
const DEFAULT_CONTEXT_ITEM_RANK = 100;
/**
 * The command IDs used by the application plugin.
 */
var CommandIDs;
(function (CommandIDs) {
    CommandIDs.activateNextTab = 'application:activate-next-tab';
    CommandIDs.activatePreviousTab = 'application:activate-previous-tab';
    CommandIDs.activateNextTabBar = 'application:activate-next-tab-bar';
    CommandIDs.activatePreviousTabBar = 'application:activate-previous-tab-bar';
    CommandIDs.close = 'application:close';
    CommandIDs.closeOtherTabs = 'application:close-other-tabs';
    CommandIDs.closeRightTabs = 'application:close-right-tabs';
    CommandIDs.closeAll = 'application:close-all';
    CommandIDs.setMode = 'application:set-mode';
    CommandIDs.showPropertyPanel = 'property-inspector:show-panel';
    CommandIDs.resetLayout = 'application:reset-layout';
    CommandIDs.toggleContextMenu = 'application:toggle-context-menu';
    CommandIDs.toggleHeader = 'application:toggle-header';
    CommandIDs.toggleMode = 'application:toggle-mode';
    CommandIDs.toggleLeftArea = 'application:toggle-left-area';
    CommandIDs.toggleRightArea = 'application:toggle-right-area';
    CommandIDs.toggleSideTabBar = 'application:toggle-side-tabbar';
    CommandIDs.toggleSidebarWidget = 'application:toggle-sidebar-widget';
    CommandIDs.togglePresentationMode = 'application:toggle-presentation-mode';
    CommandIDs.toggleFullscreenMode = 'application:toggle-fullscreen-mode';
    CommandIDs.tree = 'router:tree';
    CommandIDs.switchSidebar = 'sidebar:switch';
})(CommandIDs || (CommandIDs = {}));
/**
 * A plugin to register the commands for the main application.
 */
const mainCommands = {
    id: '@jupyterlab/application-extension:commands',
    description: 'Adds commands related to the shell.',
    autoStart: true,
    requires: [translation_lib_index_js_.ITranslator],
    optional: [index_js_.ILabShell, lib_index_js_.ICommandPalette],
    activate: (app, translator, labShell, palette) => {
        var _a;
        const { commands, shell } = app;
        const trans = translator.load('jupyterlab');
        const category = trans.__('Main Area');
        // Add Command to override the JLab context menu.
        commands.addCommand(index_js_.JupyterFrontEndContextMenu.contextMenu, {
            label: trans.__('Shift+Right Click for Browser Menu'),
            isEnabled: () => false,
            execute: () => void 0
        });
        // Returns the widget associated with the most recent contextmenu event.
        const contextMenuWidget = () => {
            const test = (node) => !!node.dataset.id;
            const node = app.contextMenuHitTest(test);
            if (!node) {
                // Fall back to active widget if path cannot be obtained from event.
                return shell.currentWidget;
            }
            return ((0,index_es6_js_.find)(shell.widgets('main'), widget => widget.id === node.dataset.id) ||
                shell.currentWidget);
        };
        // Closes an array of widgets.
        const closeWidgets = (widgets) => {
            widgets.forEach(widget => widget.close());
        };
        // Find the tab area for a widget within a specific dock area.
        const findTab = (area, widget) => {
            if (area.type === 'tab-area') {
                return area.widgets.includes(widget) ? area : null;
            }
            if (area.type === 'split-area') {
                for (const child of area.children) {
                    const found = findTab(child, widget);
                    if (found) {
                        return found;
                    }
                }
            }
            return null;
        };
        // Find the tab area for a widget within the main dock area.
        const tabAreaFor = (widget) => {
            var _a;
            const layout = labShell === null || labShell === void 0 ? void 0 : labShell.saveLayout();
            const mainArea = layout === null || layout === void 0 ? void 0 : layout.mainArea;
            if (!mainArea || coreutils_lib_index_js_.PageConfig.getOption('mode') !== 'multiple-document') {
                return null;
            }
            const area = (_a = mainArea.dock) === null || _a === void 0 ? void 0 : _a.main;
            return area ? findTab(area, widget) : null;
        };
        // Returns an array of all widgets to the right of a widget in a tab area.
        const widgetsRightOf = (widget) => {
            const { id } = widget;
            const tabArea = tabAreaFor(widget);
            const widgets = tabArea ? tabArea.widgets || [] : [];
            const index = widgets.findIndex(widget => widget.id === id);
            if (index < 0) {
                return [];
            }
            return widgets.slice(index + 1);
        };
        // Gets and returns the dataId of currently active tab in the specified sidebar (left or right)
        // or an empty string
        const activeSidePanelWidget = (side) => {
            // default active element is luancher (luancher-0)
            let activeTab;
            if (side != 'left' && side != 'right') {
                throw Error(`Unsupported sidebar: ${side}`);
            }
            if (side === 'left') {
                activeTab = document.querySelector('.lm-TabBar-tab.lm-mod-current');
            }
            else {
                const query = document.querySelectorAll('.lm-TabBar-tab.lm-mod-current');
                activeTab = query[query.length - 1];
            }
            const activeTabDataId = activeTab === null || activeTab === void 0 ? void 0 : activeTab.getAttribute('data-id');
            if (activeTabDataId) {
                return activeTabDataId === null || activeTabDataId === void 0 ? void 0 : activeTabDataId.toString();
            }
            else {
                return '';
            }
        };
        // Sets tab focus on the element
        function setTabFocus(focusElement) {
            if (focusElement) {
                focusElement.focus();
            }
        }
        commands.addCommand(CommandIDs.close, {
            label: () => trans.__('Close Tab'),
            isEnabled: () => {
                const widget = contextMenuWidget();
                return !!widget && widget.title.closable;
            },
            execute: () => {
                const widget = contextMenuWidget();
                if (widget) {
                    widget.close();
                }
            }
        });
        commands.addCommand(CommandIDs.closeOtherTabs, {
            label: () => trans.__('Close All Other Tabs'),
            isEnabled: () => {
                // Ensure there are at least two widgets.
                return (0,index_es6_js_.some)(shell.widgets('main'), (_, i) => i === 1);
            },
            execute: () => {
                const widget = contextMenuWidget();
                if (!widget) {
                    return;
                }
                const { id } = widget;
                for (const widget of shell.widgets('main')) {
                    if (widget.id !== id) {
                        widget.close();
                    }
                }
            }
        });
        commands.addCommand(CommandIDs.closeRightTabs, {
            label: () => trans.__('Close Tabs to Right'),
            isEnabled: () => !!contextMenuWidget() &&
                widgetsRightOf(contextMenuWidget()).length > 0,
            execute: () => {
                const widget = contextMenuWidget();
                if (!widget) {
                    return;
                }
                closeWidgets(widgetsRightOf(widget));
            }
        });
        (_a = shell.currentChanged) === null || _a === void 0 ? void 0 : _a.connect(() => {
            [
                CommandIDs.close,
                CommandIDs.closeOtherTabs,
                CommandIDs.closeRightTabs
            ].forEach(cmd => commands.notifyCommandChanged(cmd));
        });
        if (labShell) {
            commands.addCommand(CommandIDs.activateNextTab, {
                label: trans.__('Activate Next Tab'),
                execute: () => {
                    labShell.activateNextTab();
                }
            });
            commands.addCommand(CommandIDs.activatePreviousTab, {
                label: trans.__('Activate Previous Tab'),
                execute: () => {
                    labShell.activatePreviousTab();
                }
            });
            commands.addCommand(CommandIDs.activateNextTabBar, {
                label: trans.__('Activate Next Tab Bar'),
                execute: () => {
                    labShell.activateNextTabBar();
                }
            });
            commands.addCommand(CommandIDs.activatePreviousTabBar, {
                label: trans.__('Activate Previous Tab Bar'),
                execute: () => {
                    labShell.activatePreviousTabBar();
                }
            });
            commands.addCommand(CommandIDs.closeAll, {
                label: trans.__('Close All Tabs'),
                execute: () => {
                    labShell.closeAll();
                }
            });
            commands.addCommand(CommandIDs.toggleHeader, {
                label: trans.__('Show Header'),
                execute: () => {
                    if (labShell.mode === 'single-document') {
                        labShell.toggleTopInSimpleModeVisibility();
                    }
                },
                isToggled: () => labShell.isTopInSimpleModeVisible(),
                isVisible: () => labShell.mode === 'single-document'
            });
            commands.addCommand(CommandIDs.toggleLeftArea, {
                label: trans.__('Show Left Sidebar'),
                execute: () => {
                    if (labShell.leftCollapsed) {
                        labShell.expandLeft();
                    }
                    else {
                        labShell.collapseLeft();
                        if (labShell.currentWidget) {
                            labShell.activateById(labShell.currentWidget.id);
                        }
                    }
                },
                isToggled: () => !labShell.leftCollapsed,
                isEnabled: () => !labShell.isEmpty('left')
            });
            commands.addCommand(CommandIDs.toggleRightArea, {
                label: trans.__('Show Right Sidebar'),
                execute: () => {
                    if (labShell.rightCollapsed) {
                        labShell.expandRight();
                    }
                    else {
                        labShell.collapseRight();
                        if (labShell.currentWidget) {
                            labShell.activateById(labShell.currentWidget.id);
                        }
                    }
                },
                isToggled: () => !labShell.rightCollapsed,
                isEnabled: () => !labShell.isEmpty('right')
            });
            commands.addCommand(CommandIDs.toggleSidebarWidget, {
                label: args => args === undefined ||
                    args.side === undefined ||
                    args.index === undefined
                    ? trans.__('Toggle Sidebar Element')
                    : args.side === 'right'
                        ? trans.__('Toggle Element %1 in Right Sidebar', parseInt(args.index, 10) + 1)
                        : trans.__('Toggle Element %1 in Left Sidebar', parseInt(args.index, 10) + 1),
                execute: args => {
                    const index = parseInt(args.index, 10);
                    if (args.side != 'left' && args.side != 'right') {
                        throw Error(`Unsupported sidebar: ${args.side}`);
                    }
                    const widgets = Array.from(labShell.widgets(args.side));
                    if (index >= widgets.length) {
                        return;
                    }
                    const widgetId = widgets[index].id;
                    const focusElement = document.querySelector("[data-id='" + widgetId + "']");
                    if (activeSidePanelWidget(args.side) === widgetId) {
                        if (args.side == 'left') {
                            labShell.collapseLeft();
                            setTabFocus(focusElement);
                        }
                        if (args.side == 'right') {
                            labShell.collapseRight();
                            setTabFocus(focusElement);
                        }
                    }
                    else {
                        labShell.activateById(widgetId);
                        setTabFocus(focusElement);
                    }
                }
            });
            commands.addCommand(CommandIDs.toggleSideTabBar, {
                label: args => args.side === 'right'
                    ? trans.__('Show Right Activity Bar')
                    : trans.__('Show Left Activity Bar'),
                execute: args => {
                    if (args.side === 'right') {
                        labShell.toggleSideTabBarVisibility('right');
                    }
                    else {
                        labShell.toggleSideTabBarVisibility('left');
                    }
                },
                isToggled: args => args.side === 'right'
                    ? labShell.isSideTabBarVisible('right')
                    : labShell.isSideTabBarVisible('left'),
                isEnabled: args => args.side === 'right'
                    ? !labShell.isEmpty('right')
                    : !labShell.isEmpty('left')
            });
            commands.addCommand(CommandIDs.togglePresentationMode, {
                label: () => trans.__('Presentation Mode'),
                execute: () => {
                    labShell.presentationMode = !labShell.presentationMode;
                },
                isToggled: () => labShell.presentationMode,
                isVisible: () => true
            });
            commands.addCommand(CommandIDs.toggleFullscreenMode, {
                label: trans.__('Fullscreen Mode'),
                execute: () => {
                    if (document.fullscreenElement === null ||
                        document.fullscreenElement === undefined) {
                        document.documentElement.requestFullscreen().catch(reason => {
                            console.error('Failed to enter fullscreen mode.', reason);
                        });
                    }
                    else if (document.fullscreenElement !== null) {
                        document.exitFullscreen().catch(reason => {
                            console.error('Failed to exit fullscreen mode.', reason);
                        });
                    }
                },
                isToggled: () => document.fullscreenElement !== null
            });
            commands.addCommand(CommandIDs.setMode, {
                label: args => args['mode']
                    ? trans.__('Set %1 mode.', args['mode'])
                    : trans.__('Set the layout `mode`.'),
                caption: trans.__('The layout `mode` can be "single-document" or "multiple-document".'),
                isVisible: args => {
                    const mode = args['mode'];
                    return mode === 'single-document' || mode === 'multiple-document';
                },
                execute: args => {
                    const mode = args['mode'];
                    if (mode === 'single-document' || mode === 'multiple-document') {
                        labShell.mode = mode;
                        return;
                    }
                    throw new Error(`Unsupported application shell mode: ${mode}`);
                }
            });
            commands.addCommand(CommandIDs.toggleMode, {
                label: trans.__('Simple Interface'),
                isToggled: () => labShell.mode === 'single-document',
                execute: () => {
                    const args = labShell.mode === 'multiple-document'
                        ? { mode: 'single-document' }
                        : { mode: 'multiple-document' };
                    return commands.execute(CommandIDs.setMode, args);
                }
            });
            commands.addCommand(CommandIDs.resetLayout, {
                label: trans.__('Reset Default Layout'),
                execute: () => {
                    // Turn off presentation mode
                    if (labShell.presentationMode) {
                        commands
                            .execute(CommandIDs.togglePresentationMode)
                            .catch(reason => {
                            console.error('Failed to undo presentation mode.', reason);
                        });
                    }
                    // Turn off fullscreen mode
                    if (document.fullscreenElement !== null ||
                        document.fullscreenElement !== undefined) {
                        commands.execute(CommandIDs.toggleFullscreenMode).catch(reason => {
                            console.error('Failed to exit fullscreen mode.', reason);
                        });
                    }
                    // Display top header
                    if (labShell.mode === 'single-document' &&
                        !labShell.isTopInSimpleModeVisible()) {
                        commands.execute(CommandIDs.toggleHeader).catch(reason => {
                            console.error('Failed to display title header.', reason);
                        });
                    }
                    // Display side tabbar
                    ['left', 'right'].forEach(side => {
                        if (!labShell.isSideTabBarVisible(side) &&
                            !labShell.isEmpty(side)) {
                            commands
                                .execute(CommandIDs.toggleSideTabBar, { side })
                                .catch(reason => {
                                console.error(`Failed to show ${side} activity bar.`, reason);
                            });
                        }
                    });
                    // Some actions are also trigger indirectly
                    // - by listening to this command execution.
                }
            });
        }
        if (palette) {
            [
                CommandIDs.activateNextTab,
                CommandIDs.activatePreviousTab,
                CommandIDs.activateNextTabBar,
                CommandIDs.activatePreviousTabBar,
                CommandIDs.close,
                CommandIDs.closeAll,
                CommandIDs.closeOtherTabs,
                CommandIDs.closeRightTabs,
                CommandIDs.toggleHeader,
                CommandIDs.toggleLeftArea,
                CommandIDs.toggleRightArea,
                CommandIDs.togglePresentationMode,
                CommandIDs.toggleFullscreenMode,
                CommandIDs.toggleMode,
                CommandIDs.resetLayout
            ].forEach(command => palette.addItem({ command, category }));
            ['right', 'left'].forEach(side => {
                palette.addItem({
                    command: CommandIDs.toggleSideTabBar,
                    category,
                    args: { side }
                });
            });
        }
    }
};
/**
 * The main extension.
 */
const main = {
    id: '@jupyterlab/application-extension:main',
    description: 'Initializes the application and provides the URL tree path handler.',
    requires: [
        index_js_.IRouter,
        lib_index_js_.IWindowResolver,
        translation_lib_index_js_.ITranslator,
        index_js_.JupyterFrontEnd.ITreeResolver
    ],
    optional: [index_js_.IConnectionLost],
    provides: index_js_.ITreePathUpdater,
    activate: (app, router, resolver, translator, treeResolver, connectionLost) => {
        const trans = translator.load('jupyterlab');
        if (!(app instanceof index_js_.JupyterLab)) {
            throw new Error(`${main.id} must be activated in JupyterLab.`);
        }
        // These two internal state variables are used to manage the two source
        // of the tree part of the URL being updated: 1) path of the active document,
        // 2) path of the default browser if the active main area widget isn't a document.
        let _docTreePath = '';
        let _defaultBrowserTreePath = '';
        function updateTreePath(treePath) {
            // Wait for tree resolver to finish before updating the path because it use the PageConfig['treePath']
            void treeResolver.paths.then(() => {
                _defaultBrowserTreePath = treePath;
                if (!_docTreePath) {
                    const url = coreutils_lib_index_js_.PageConfig.getUrl({ treePath });
                    const path = coreutils_lib_index_js_.URLExt.parse(url).pathname;
                    router.navigate(path, { skipRouting: true });
                    // Persist the new tree path to PageConfig as it is used elsewhere at runtime.
                    coreutils_lib_index_js_.PageConfig.setOption('treePath', treePath);
                }
            });
        }
        // Requiring the window resolver guarantees that the application extension
        // only loads if there is a viable window name. Otherwise, the application
        // will short-circuit and ask the user to navigate away.
        const workspace = resolver.name;
        console.debug(`Starting application in workspace: "${workspace}"`);
        // If there were errors registering plugins, tell the user.
        if (app.registerPluginErrors.length !== 0) {
            const body = (react_index_js_.createElement("pre", null, app.registerPluginErrors.map(e => e.message).join('\n')));
            void (0,lib_index_js_.showErrorMessage)(trans.__('Error Registering Plugins'), {
                message: body
            });
        }
        // Watch the mode and update the page URL to /lab or /doc to reflect the
        // change.
        app.shell.modeChanged.connect((_, args) => {
            const url = coreutils_lib_index_js_.PageConfig.getUrl({ mode: args });
            const path = coreutils_lib_index_js_.URLExt.parse(url).pathname;
            router.navigate(path, { skipRouting: true });
            // Persist this mode change to PageConfig as it is used elsewhere at runtime.
            coreutils_lib_index_js_.PageConfig.setOption('mode', args);
        });
        // Wait for tree resolver to finish before updating the path because it use the PageConfig['treePath']
        void treeResolver.paths.then(() => {
            // Watch the path of the current widget in the main area and update the page
            // URL to reflect the change.
            app.shell.currentPathChanged.connect((_, args) => {
                const maybeTreePath = args.newValue;
                const treePath = maybeTreePath || _defaultBrowserTreePath;
                const url = coreutils_lib_index_js_.PageConfig.getUrl({ treePath: treePath });
                const path = coreutils_lib_index_js_.URLExt.parse(url).pathname;
                router.navigate(path, { skipRouting: true });
                // Persist the new tree path to PageConfig as it is used elsewhere at runtime.
                coreutils_lib_index_js_.PageConfig.setOption('treePath', treePath);
                _docTreePath = maybeTreePath;
            });
        });
        // If the connection to the server is lost, handle it with the
        // connection lost handler.
        connectionLost = connectionLost || index_js_.ConnectionLost;
        app.serviceManager.connectionFailure.connect((manager, error) => connectionLost(manager, error, translator));
        const builder = app.serviceManager.builder;
        const build = () => {
            return builder
                .build()
                .then(() => {
                return (0,lib_index_js_.showDialog)({
                    title: trans.__('Build Complete'),
                    body: (react_index_js_.createElement("div", null,
                        trans.__('Build successfully completed, reload page?'),
                        react_index_js_.createElement("br", null),
                        trans.__('You will lose any unsaved changes.'))),
                    buttons: [
                        lib_index_js_.Dialog.cancelButton({
                            label: trans.__('Reload Without Saving'),
                            actions: ['reload']
                        }),
                        lib_index_js_.Dialog.okButton({ label: trans.__('Save and Reload') })
                    ],
                    hasClose: true
                });
            })
                .then(({ button: { accept, actions } }) => {
                if (accept) {
                    void app.commands
                        .execute('docmanager:save')
                        .then(() => {
                        router.reload();
                    })
                        .catch(err => {
                        void (0,lib_index_js_.showErrorMessage)(trans.__('Save Failed'), {
                            message: react_index_js_.createElement("pre", null, err.message)
                        });
                    });
                }
                else if (actions.includes('reload')) {
                    router.reload();
                }
            })
                .catch(err => {
                void (0,lib_index_js_.showErrorMessage)(trans.__('Build Failed'), {
                    message: react_index_js_.createElement("pre", null, err.message)
                });
            });
        };
        if (builder.isAvailable && builder.shouldCheck) {
            void builder.getStatus().then(response => {
                if (response.status === 'building') {
                    return build();
                }
                if (response.status !== 'needed') {
                    return;
                }
                const body = (react_index_js_.createElement("div", null,
                    trans.__('JupyterLab build is suggested:'),
                    react_index_js_.createElement("br", null),
                    react_index_js_.createElement("pre", null, response.message)));
                void (0,lib_index_js_.showDialog)({
                    title: trans.__('Build Recommended'),
                    body,
                    buttons: [
                        lib_index_js_.Dialog.cancelButton(),
                        lib_index_js_.Dialog.okButton({ label: trans.__('Build') })
                    ]
                }).then(result => (result.button.accept ? build() : undefined));
            });
        }
        return updateTreePath;
    },
    autoStart: true
};
/**
 * Plugin to build the context menu from the settings.
 */
const contextMenuPlugin = {
    id: '@jupyterlab/application-extension:context-menu',
    description: 'Populates the context menu.',
    autoStart: true,
    requires: [settingregistry_lib_index_js_.ISettingRegistry, translation_lib_index_js_.ITranslator],
    optional: [lib_index_js_.ICommandPalette],
    activate: (app, settingRegistry, translator, palette) => {
        const trans = translator.load('jupyterlab');
        function createMenu(options) {
            const menu = new ui_components_lib_index_js_.RankedMenu({ ...options, commands: app.commands });
            if (options.label) {
                menu.title.label = trans.__(options.label);
            }
            return menu;
        }
        // Load the context menu lately so plugins are loaded.
        app.started
            .then(() => {
            return Private.loadSettingsContextMenu(app.contextMenu, app.commands, settingRegistry, createMenu, translator);
        })
            .then(() => {
            if (palette) {
                palette === null || palette === void 0 ? void 0 : palette.addItem({
                    category: trans.__('Settings'),
                    command: CommandIDs.toggleContextMenu
                });
            }
        })
            .catch(reason => {
            console.error('Failed to load context menu items from settings registry.', reason);
        });
    }
};
/**
 * Check if the application is dirty before closing the browser tab.
 */
const dirty = {
    id: '@jupyterlab/application-extension:dirty',
    description: 'Adds safeguard dialog when closing the browser tab with unsaved modifications.',
    autoStart: true,
    requires: [translation_lib_index_js_.ITranslator],
    activate: (app, translator) => {
        if (!(app instanceof index_js_.JupyterLab)) {
            throw new Error(`${dirty.id} must be activated in JupyterLab.`);
        }
        const trans = translator.load('jupyterlab');
        const message = trans.__('Are you sure you want to exit JupyterLab?\n\nAny unsaved changes will be lost.');
        // The spec for the `beforeunload` event is implemented differently by
        // the different browser vendors. Consequently, the `event.returnValue`
        // attribute needs to set in addition to a return value being returned.
        // For more information, see:
        // https://developer.mozilla.org/en/docs/Web/Events/beforeunload
        window.addEventListener('beforeunload', event => {
            if (app.status.isDirty) {
                return (event.returnValue = message);
            }
        });
    }
};
/**
 * The default layout restorer provider.
 */
const layout = {
    id: '@jupyterlab/application-extension:layout',
    description: 'Provides the shell layout restorer.',
    requires: [statedb_lib_index_js_.IStateDB, index_js_.ILabShell, settingregistry_lib_index_js_.ISettingRegistry],
    optional: [translation_lib_index_js_.ITranslator],
    activate: (app, state, labShell, settingRegistry, translator) => {
        const trans = (translator !== null && translator !== void 0 ? translator : translation_lib_index_js_.nullTranslator).load('jupyterlab');
        const first = app.started;
        const registry = app.commands;
        const mode = coreutils_lib_index_js_.PageConfig.getOption('mode');
        const restorer = new index_js_.LayoutRestorer({
            connector: state,
            first,
            registry,
            mode
        });
        settingRegistry
            .load(shell.id)
            .then(settings => {
            var _a, _b;
            // Add a layer of customization to support app shell mode
            const customizedLayout = settings.composite['layout'];
            // Restore the layout.
            void labShell
                .restoreLayout(mode, restorer, {
                'multiple-document': (_a = customizedLayout.multiple) !== null && _a !== void 0 ? _a : {},
                'single-document': (_b = customizedLayout.single) !== null && _b !== void 0 ? _b : {}
            })
                .then(() => {
                labShell.layoutModified.connect(() => {
                    void restorer.save(labShell.saveLayout());
                });
                settings.changed.connect(onSettingsChanged);
                Private.activateSidebarSwitcher(app, labShell, settings, trans);
            });
        })
            .catch(reason => {
            console.error('Fail to load settings for the layout restorer.');
            console.error(reason);
        });
        return restorer;
        async function onSettingsChanged(settings) {
            if (!dist_index_js_.JSONExt.deepEqual(settings.composite['layout'], {
                single: labShell.userLayout['single-document'],
                multiple: labShell.userLayout['multiple-document']
            })) {
                const result = await (0,lib_index_js_.showDialog)({
                    title: trans.__('Information'),
                    body: trans.__('User layout customization has changed. You may need to reload JupyterLab to see the changes.'),
                    buttons: [
                        lib_index_js_.Dialog.cancelButton(),
                        lib_index_js_.Dialog.okButton({ label: trans.__('Reload') })
                    ]
                });
                if (result.button.accept) {
                    location.reload();
                }
            }
        }
    },
    autoStart: true,
    provides: index_js_.ILayoutRestorer
};
/**
 * The default URL router provider.
 */
const router = {
    id: '@jupyterlab/application-extension:router',
    description: 'Provides the URL router',
    requires: [index_js_.JupyterFrontEnd.IPaths],
    activate: (app, paths) => {
        const { commands } = app;
        const base = paths.urls.base;
        const router = new index_js_.Router({ base, commands });
        void app.started.then(() => {
            // Route the very first request on load.
            void router.route();
            // Route all pop state events.
            window.addEventListener('popstate', () => {
                void router.route();
            });
        });
        return router;
    },
    autoStart: true,
    provides: index_js_.IRouter
};
/**
 * The default tree route resolver plugin.
 */
const tree = {
    id: '@jupyterlab/application-extension:tree-resolver',
    description: 'Provides the tree route resolver',
    autoStart: true,
    requires: [index_js_.IRouter],
    provides: index_js_.JupyterFrontEnd.ITreeResolver,
    activate: (app, router) => {
        const { commands } = app;
        const set = new disposable_dist_index_es6_js_.DisposableSet();
        const delegate = new dist_index_js_.PromiseDelegate();
        const treePattern = new RegExp('/(lab|doc)(/workspaces/[a-zA-Z0-9-_]+)?(/tree/.*)?');
        set.add(commands.addCommand(CommandIDs.tree, {
            execute: async (args) => {
                var _a;
                if (set.isDisposed) {
                    return;
                }
                const query = coreutils_lib_index_js_.URLExt.queryStringToObject((_a = args.search) !== null && _a !== void 0 ? _a : '');
                const browser = query['file-browser-path'] || '';
                // Remove the file browser path from the query string.
                delete query['file-browser-path'];
                // Clean up artifacts immediately upon routing.
                set.dispose();
                delegate.resolve({ browser, file: coreutils_lib_index_js_.PageConfig.getOption('treePath') });
            }
        }));
        set.add(router.register({ command: CommandIDs.tree, pattern: treePattern }));
        // If a route is handled by the router without the tree command being
        // invoked, resolve to `null` and clean up artifacts.
        const listener = () => {
            if (set.isDisposed) {
                return;
            }
            set.dispose();
            delegate.resolve(null);
        };
        router.routed.connect(listener);
        set.add(new disposable_dist_index_es6_js_.DisposableDelegate(() => {
            router.routed.disconnect(listener);
        }));
        return { paths: delegate.promise };
    }
};
/**
 * The default URL not found extension.
 */
const notfound = {
    id: '@jupyterlab/application-extension:notfound',
    description: 'Defines the behavior for not found URL (aka route).',
    requires: [index_js_.JupyterFrontEnd.IPaths, index_js_.IRouter, translation_lib_index_js_.ITranslator],
    activate: (_, paths, router, translator) => {
        const trans = translator.load('jupyterlab');
        const bad = paths.urls.notFound;
        if (!bad) {
            return;
        }
        const base = router.base;
        const message = trans.__('The path: %1 was not found. JupyterLab redirected to: %2', bad, base);
        // Change the URL back to the base application URL.
        router.navigate('');
        void (0,lib_index_js_.showErrorMessage)(trans.__('Path Not Found'), { message });
    },
    autoStart: true
};
/**
 * Change the favicon changing based on the busy status;
 */
const busy = {
    id: '@jupyterlab/application-extension:faviconbusy',
    description: 'Handles the favicon depending on the application status.',
    requires: [index_js_.ILabStatus],
    activate: async (_, status) => {
        status.busySignal.connect((_, isBusy) => {
            const favicon = document.querySelector(`link[rel="icon"]${isBusy ? '.idle.favicon' : '.busy.favicon'}`);
            if (!favicon) {
                return;
            }
            const newFavicon = document.querySelector(`link${isBusy ? '.busy.favicon' : '.idle.favicon'}`);
            if (!newFavicon) {
                return;
            }
            // If we have the two icons with the special classes, then toggle them.
            if (favicon !== newFavicon) {
                favicon.rel = '';
                newFavicon.rel = 'icon';
                // Firefox doesn't seem to recognize just changing rel, so we also
                // reinsert the link into the DOM.
                newFavicon.parentNode.replaceChild(newFavicon, newFavicon);
            }
        });
    },
    autoStart: true
};
/**
 * The default JupyterLab application shell.
 */
const shell = {
    id: '@jupyterlab/application-extension:shell',
    description: 'Provides the JupyterLab shell. It has an extended API compared to `app.shell`.',
    optional: [settingregistry_lib_index_js_.ISettingRegistry],
    activate: (app, settingRegistry) => {
        if (!(app.shell instanceof index_js_.LabShell)) {
            throw new Error(`${shell.id} did not find a LabShell instance.`);
        }
        if (settingRegistry) {
            void settingRegistry.load(shell.id).then(settings => {
                app.shell.updateConfig(settings.composite);
                settings.changed.connect(() => {
                    app.shell.updateConfig(settings.composite);
                });
            });
        }
        return app.shell;
    },
    autoStart: true,
    provides: index_js_.ILabShell
};
/**
 * The default JupyterLab application status provider.
 */
const lib_status = {
    id: '@jupyterlab/application-extension:status',
    description: 'Provides the application status.',
    activate: (app) => {
        if (!(app instanceof index_js_.JupyterLab)) {
            throw new Error(`${lib_status.id} must be activated in JupyterLab.`);
        }
        return app.status;
    },
    autoStart: true,
    provides: index_js_.ILabStatus
};
/**
 * The default JupyterLab application-specific information provider.
 *
 * #### Notes
 * This plugin should only be used by plugins that specifically need to access
 * JupyterLab application information, e.g., listing extensions that have been
 * loaded or deferred within JupyterLab.
 */
const info = {
    id: '@jupyterlab/application-extension:info',
    description: 'Provides the application information.',
    activate: (app) => {
        if (!(app instanceof index_js_.JupyterLab)) {
            throw new Error(`${info.id} must be activated in JupyterLab.`);
        }
        return app.info;
    },
    autoStart: true,
    provides: index_js_.JupyterLab.IInfo
};
/**
 * The default JupyterLab paths dictionary provider.
 */
const paths = {
    id: '@jupyterlab/application-extension:paths',
    description: 'Provides the application paths.',
    activate: (app) => {
        if (!(app instanceof index_js_.JupyterLab)) {
            throw new Error(`${paths.id} must be activated in JupyterLab.`);
        }
        return app.paths;
    },
    autoStart: true,
    provides: index_js_.JupyterFrontEnd.IPaths
};
/**
 * The default property inspector provider.
 */
const propertyInspector = {
    id: '@jupyterlab/application-extension:property-inspector',
    description: 'Provides the property inspector.',
    autoStart: true,
    requires: [index_js_.ILabShell, translation_lib_index_js_.ITranslator],
    optional: [index_js_.ILayoutRestorer],
    provides: property_inspector_lib_index_js_.IPropertyInspectorProvider,
    activate: (app, labshell, translator, restorer) => {
        const trans = translator.load('jupyterlab');
        const widget = new property_inspector_lib_index_js_.SideBarPropertyInspectorProvider({
            shell: labshell,
            translator
        });
        widget.title.icon = ui_components_lib_index_js_.buildIcon;
        widget.title.caption = trans.__('Property Inspector');
        widget.id = 'jp-property-inspector';
        labshell.add(widget, 'right', { rank: 100, type: 'Property Inspector' });
        app.commands.addCommand(CommandIDs.showPropertyPanel, {
            label: trans.__('Property Inspector'),
            execute: () => {
                labshell.activateById(widget.id);
            }
        });
        if (restorer) {
            restorer.add(widget, 'jp-property-inspector');
        }
        return widget;
    }
};
const jupyterLogo = {
    id: '@jupyterlab/application-extension:logo',
    description: 'Sets the application logo.',
    autoStart: true,
    requires: [index_js_.ILabShell],
    activate: (app, shell) => {
        const logo = new widgets_dist_index_es6_js_.Widget();
        ui_components_lib_index_js_.jupyterIcon.element({
            container: logo.node,
            elementPosition: 'center',
            margin: '2px 2px 2px 8px',
            height: 'auto',
            width: '16px'
        });
        logo.id = 'jp-MainLogo';
        shell.add(logo, 'top', { rank: 0 });
    }
};
/**
 * The simple interface mode switch in the status bar.
 */
const modeSwitchPlugin = {
    id: '@jupyterlab/application-extension:mode-switch',
    description: 'Adds the interface mode switch',
    requires: [index_js_.ILabShell, translation_lib_index_js_.ITranslator],
    optional: [statusbar_lib_index_js_.IStatusBar, settingregistry_lib_index_js_.ISettingRegistry],
    activate: (app, labShell, translator, statusBar, settingRegistry) => {
        if (statusBar === null) {
            // Bail early
            return;
        }
        const trans = translator.load('jupyterlab');
        const modeSwitch = new ui_components_lib_index_js_.Switch();
        modeSwitch.id = 'jp-single-document-mode';
        modeSwitch.valueChanged.connect((_, args) => {
            labShell.mode = args.newValue ? 'single-document' : 'multiple-document';
        });
        labShell.modeChanged.connect((_, mode) => {
            modeSwitch.value = mode === 'single-document';
        });
        if (settingRegistry) {
            const loadSettings = settingRegistry.load(shell.id);
            const updateSettings = (settings) => {
                const startMode = settings.get('startMode').composite;
                if (startMode) {
                    labShell.mode =
                        startMode === 'single' ? 'single-document' : 'multiple-document';
                }
            };
            Promise.all([loadSettings, app.restored])
                .then(([settings]) => {
                updateSettings(settings);
            })
                .catch((reason) => {
                console.error(reason.message);
            });
        }
        // Show the current file browser shortcut in its title.
        const updateModeSwitchTitle = () => {
            const binding = app.commands.keyBindings.find(b => b.command === 'application:toggle-mode');
            if (binding) {
                const ks = binding.keys.map(dist_index_es6_js_.CommandRegistry.formatKeystroke).join(', ');
                modeSwitch.caption = trans.__('Simple Interface (%1)', ks);
            }
            else {
                modeSwitch.caption = trans.__('Simple Interface');
            }
        };
        updateModeSwitchTitle();
        app.commands.keyBindingChanged.connect(() => {
            updateModeSwitchTitle();
        });
        modeSwitch.label = trans.__('Simple');
        statusBar.registerStatusItem(modeSwitchPlugin.id, {
            priority: 1,
            item: modeSwitch,
            align: 'left',
            rank: -1
        });
    },
    autoStart: true
};
/**
 * Export the plugins as default.
 */
const plugins = [
    contextMenuPlugin,
    dirty,
    main,
    mainCommands,
    layout,
    router,
    tree,
    notfound,
    busy,
    shell,
    lib_status,
    info,
    modeSwitchPlugin,
    paths,
    propertyInspector,
    jupyterLogo,
    topbar
];
/* harmony default export */ const lib = (plugins);
var Private;
(function (Private) {
    async function displayInformation(trans) {
        const result = await (0,lib_index_js_.showDialog)({
            title: trans.__('Information'),
            body: trans.__('Context menu customization has changed. You will need to reload JupyterLab to see the changes.'),
            buttons: [
                lib_index_js_.Dialog.cancelButton(),
                lib_index_js_.Dialog.okButton({ label: trans.__('Reload') })
            ]
        });
        if (result.button.accept) {
            location.reload();
        }
    }
    async function loadSettingsContextMenu(contextMenu, commands, registry, menuFactory, translator) {
        var _a;
        const trans = translator.load('jupyterlab');
        const pluginId = contextMenuPlugin.id;
        let canonical = null;
        let loaded = {};
        /**
         * Populate the plugin's schema defaults.
         *
         * We keep track of disabled entries in case the plugin is loaded
         * after the menu initialization.
         */
        function populate(schema) {
            var _a, _b;
            loaded = {};
            const pluginDefaults = Object.keys(registry.plugins)
                .map(plugin => {
                var _a, _b;
                const items = (_b = (_a = registry.plugins[plugin].schema['jupyter.lab.menus']) === null || _a === void 0 ? void 0 : _a.context) !== null && _b !== void 0 ? _b : [];
                loaded[plugin] = items;
                return items;
            })
                .concat([(_b = (_a = schema['jupyter.lab.menus']) === null || _a === void 0 ? void 0 : _a.context) !== null && _b !== void 0 ? _b : []])
                .reduceRight((acc, val) => settingregistry_lib_index_js_.SettingRegistry.reconcileItems(acc, val, true), []);
            // Apply default value as last step to take into account overrides.json
            // The standard default being [] as the plugin must use `jupyter.lab.menus.context`
            // to define their default value.
            schema.properties.contextMenu.default = settingregistry_lib_index_js_.SettingRegistry.reconcileItems(pluginDefaults, schema.properties.contextMenu.default, true)
                // flatten one level
                .sort((a, b) => { var _a, _b; return ((_a = a.rank) !== null && _a !== void 0 ? _a : Infinity) - ((_b = b.rank) !== null && _b !== void 0 ? _b : Infinity); });
        }
        // Transform the plugin object to return different schema than the default.
        registry.transform(pluginId, {
            compose: plugin => {
                var _a, _b, _c, _d;
                // Only override the canonical schema the first time.
                if (!canonical) {
                    canonical = dist_index_js_.JSONExt.deepCopy(plugin.schema);
                    populate(canonical);
                }
                const defaults = (_c = (_b = (_a = canonical.properties) === null || _a === void 0 ? void 0 : _a.contextMenu) === null || _b === void 0 ? void 0 : _b.default) !== null && _c !== void 0 ? _c : [];
                const user = {
                    ...plugin.data.user,
                    contextMenu: (_d = plugin.data.user.contextMenu) !== null && _d !== void 0 ? _d : []
                };
                const composite = {
                    ...plugin.data.composite,
                    contextMenu: settingregistry_lib_index_js_.SettingRegistry.reconcileItems(defaults, user.contextMenu, false)
                };
                plugin.data = { composite, user };
                return plugin;
            },
            fetch: plugin => {
                // Only override the canonical schema the first time.
                if (!canonical) {
                    canonical = dist_index_js_.JSONExt.deepCopy(plugin.schema);
                    populate(canonical);
                }
                return {
                    data: plugin.data,
                    id: plugin.id,
                    raw: plugin.raw,
                    schema: canonical,
                    version: plugin.version
                };
            }
        });
        // Repopulate the canonical variable after the setting registry has
        // preloaded all initial plugins.
        const settings = await registry.load(pluginId);
        // Set the suppress flag on document.body if necessary.
        const setDisabled = (settings) => {
            const root = document.body;
            const isDisabled = root.hasAttribute('data-jp-suppress-context-menu');
            const shouldDisable = settings.get('disabled').composite;
            if (isDisabled && !shouldDisable) {
                root.removeAttribute('data-jp-suppress-context-menu');
            }
            else if (shouldDisable && !isDisabled) {
                root.setAttribute('data-jp-suppress-context-menu', 'true');
            }
        };
        const contextItems = (_a = settings.composite.contextMenu) !== null && _a !== void 0 ? _a : [];
        // Create menu item for non-disabled element
        settingregistry_lib_index_js_.SettingRegistry.filterDisabledItems(contextItems).forEach(item => {
            lib_index_js_.MenuFactory.addContextItem({
                // We have to set the default rank because Lumino is sorting the visible items
                rank: DEFAULT_CONTEXT_ITEM_RANK,
                ...item
            }, contextMenu, menuFactory);
        });
        settings.changed.connect(() => {
            var _a;
            // As extension may change the context menu through API,
            // prompt the user to reload if the menu has been updated.
            const newItems = (_a = settings.composite.contextMenu) !== null && _a !== void 0 ? _a : [];
            if (!dist_index_js_.JSONExt.deepEqual(contextItems, newItems)) {
                void displayInformation(trans);
            }
            setDisabled(settings);
        });
        registry.pluginChanged.connect(async (sender, plugin) => {
            var _a, _b, _c, _d;
            if (plugin !== pluginId) {
                // If the plugin changed its menu.
                const oldItems = (_a = loaded[plugin]) !== null && _a !== void 0 ? _a : [];
                const newItems = (_c = (_b = registry.plugins[plugin].schema['jupyter.lab.menus']) === null || _b === void 0 ? void 0 : _b.context) !== null && _c !== void 0 ? _c : [];
                if (!dist_index_js_.JSONExt.deepEqual(oldItems, newItems)) {
                    if (loaded[plugin]) {
                        // The plugin has changed, request the user to reload the UI
                        await displayInformation(trans);
                    }
                    else {
                        // The plugin was not yet loaded when the menu was built => update the menu
                        loaded[plugin] = dist_index_js_.JSONExt.deepCopy(newItems);
                        // Merge potential disabled state
                        const toAdd = (_d = settingregistry_lib_index_js_.SettingRegistry.reconcileItems(newItems, contextItems, false, false)) !== null && _d !== void 0 ? _d : [];
                        settingregistry_lib_index_js_.SettingRegistry.filterDisabledItems(toAdd).forEach(item => {
                            lib_index_js_.MenuFactory.addContextItem({
                                // We have to set the default rank because Lumino is sorting the visible items
                                rank: DEFAULT_CONTEXT_ITEM_RANK,
                                ...item
                            }, contextMenu, menuFactory);
                        });
                    }
                }
            }
        });
        // Handle disabled status.
        setDisabled(settings);
        commands.addCommand(CommandIDs.toggleContextMenu, {
            label: trans.__('Enable Context Menu'),
            isToggleable: true,
            isToggled: () => !settings.get('disabled').composite,
            execute: () => void settings.set('disabled', !settings.get('disabled').composite)
        });
    }
    Private.loadSettingsContextMenu = loadSettingsContextMenu;
    function activateSidebarSwitcher(app, labShell, settings, trans) {
        // Add a command to switch a side panels's side
        app.commands.addCommand(CommandIDs.switchSidebar, {
            label: trans.__('Switch Sidebar Side'),
            execute: () => {
                // First, try to find the correct panel based on the application
                // context menu click. Bail if we don't find a sidebar for the widget.
                const contextNode = app.contextMenuHitTest(node => !!node.dataset.id);
                if (!contextNode) {
                    return;
                }
                const id = contextNode.dataset['id'];
                const leftPanel = document.getElementById('jp-left-stack');
                const node = document.getElementById(id);
                let newLayout = null;
                // Move the panel to the other side.
                if (leftPanel && node && leftPanel.contains(node)) {
                    const widget = (0,index_es6_js_.find)(labShell.widgets('left'), w => w.id === id);
                    if (widget) {
                        newLayout = labShell.move(widget, 'right');
                        labShell.activateById(widget.id);
                    }
                }
                else {
                    const widget = (0,index_es6_js_.find)(labShell.widgets('right'), w => w.id === id);
                    if (widget) {
                        newLayout = labShell.move(widget, 'left');
                        labShell.activateById(widget.id);
                    }
                }
                if (newLayout) {
                    settings
                        .set('layout', {
                        single: newLayout['single-document'],
                        multiple: newLayout['multiple-document']
                    })
                        .catch(reason => {
                        console.error('Failed to save user layout customization.', reason);
                    });
                }
            }
        });
        app.commands.commandExecuted.connect((registry, executed) => {
            if (executed.id === CommandIDs.resetLayout) {
                settings.remove('layout').catch(reason => {
                    console.error('Failed to remove user layout customization.', reason);
                });
            }
        });
    }
    Private.activateSidebarSwitcher = activateSidebarSwitcher;
})(Private || (Private = {}));
//# sourceMappingURL=index.js.map

/***/ }),

/***/ 32723:
/***/ ((__unused_webpack_module, __unused_webpack___webpack_exports__, __webpack_require__) => {

"use strict";

// EXTERNAL MODULE: ../node_modules/@lumino/widgets/style/index.js + 1 modules
var style = __webpack_require__(20959);
// EXTERNAL MODULE: ../node_modules/@jupyterlab/ui-components/style/index.js + 1 modules
var ui_components_style = __webpack_require__(26238);
// EXTERNAL MODULE: ../node_modules/@jupyterlab/statusbar/style/index.js + 1 modules
var statusbar_style = __webpack_require__(25066);
// EXTERNAL MODULE: ../node_modules/@jupyterlab/application/style/index.js + 1 modules
var application_style = __webpack_require__(67663);
// EXTERNAL MODULE: ../node_modules/@jupyterlab/property-inspector/style/index.js + 1 modules
var property_inspector_style = __webpack_require__(62374);
// EXTERNAL MODULE: ../node_modules/@jupyterlab/builder/node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js
var injectStylesIntoStyleTag = __webpack_require__(94830);
var injectStylesIntoStyleTag_default = /*#__PURE__*/__webpack_require__.n(injectStylesIntoStyleTag);
// EXTERNAL MODULE: ../node_modules/@jupyterlab/builder/node_modules/style-loader/dist/runtime/styleDomAPI.js
var styleDomAPI = __webpack_require__(80592);
var styleDomAPI_default = /*#__PURE__*/__webpack_require__.n(styleDomAPI);
// EXTERNAL MODULE: ../node_modules/@jupyterlab/builder/node_modules/style-loader/dist/runtime/insertBySelector.js
var insertBySelector = __webpack_require__(99763);
var insertBySelector_default = /*#__PURE__*/__webpack_require__.n(insertBySelector);
// EXTERNAL MODULE: ../node_modules/@jupyterlab/builder/node_modules/style-loader/dist/runtime/setAttributesWithoutAttributes.js
var setAttributesWithoutAttributes = __webpack_require__(28915);
var setAttributesWithoutAttributes_default = /*#__PURE__*/__webpack_require__.n(setAttributesWithoutAttributes);
// EXTERNAL MODULE: ../node_modules/@jupyterlab/builder/node_modules/style-loader/dist/runtime/insertStyleElement.js
var insertStyleElement = __webpack_require__(80366);
var insertStyleElement_default = /*#__PURE__*/__webpack_require__.n(insertStyleElement);
// EXTERNAL MODULE: ../node_modules/@jupyterlab/builder/node_modules/style-loader/dist/runtime/styleTagTransform.js
var styleTagTransform = __webpack_require__(17352);
var styleTagTransform_default = /*#__PURE__*/__webpack_require__.n(styleTagTransform);
// EXTERNAL MODULE: ../node_modules/@jupyterlab/builder/node_modules/css-loader/dist/cjs.js!../node_modules/@jupyterlab/application-extension/style/base.css
var base = __webpack_require__(6347);
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/application-extension/style/base.css

      
      
      
      
      
      
      
      
      

var options = {};

options.styleTagTransform = (styleTagTransform_default());
options.setAttributes = (setAttributesWithoutAttributes_default());

      options.insert = insertBySelector_default().bind(null, "head");
    
options.domAPI = (styleDomAPI_default());
options.insertStyleElement = (insertStyleElement_default());

var update = injectStylesIntoStyleTag_default()(base/* default */.Z, options);




       /* harmony default export */ const style_base = (base/* default */.Z && base/* default */.Z.locals ? base/* default */.Z.locals : undefined);

;// CONCATENATED MODULE: ../node_modules/@jupyterlab/application-extension/style/index.js
/*-----------------------------------------------------------------------------
| Copyright (c) Jupyter Development Team.
| Distributed under the terms of the Modified BSD License.
|----------------------------------------------------------------------------*/

/* This file was auto-generated by ensurePackage() in @jupyterlab/buildutils */









/***/ }),

/***/ 76853:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
// ESM COMPAT FLAG
__webpack_require__.r(__webpack_exports__);

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  ConnectionLost: () => (/* reexport */ ConnectionLost),
  IConnectionLost: () => (/* reexport */ IConnectionLost),
  ILabShell: () => (/* reexport */ ILabShell),
  ILabStatus: () => (/* reexport */ ILabStatus),
  ILayoutRestorer: () => (/* reexport */ layoutrestorer/* ILayoutRestorer */.L),
  IMimeDocumentTracker: () => (/* reexport */ mimerenderers/* IMimeDocumentTracker */.w2),
  IRouter: () => (/* reexport */ IRouter),
  ITreePathUpdater: () => (/* reexport */ ITreePathUpdater),
  JupyterFrontEnd: () => (/* reexport */ JupyterFrontEnd),
  JupyterFrontEndContextMenu: () => (/* reexport */ JupyterFrontEndContextMenu),
  JupyterLab: () => (/* reexport */ JupyterLab),
  LabShell: () => (/* reexport */ LabShell),
  LabStatus: () => (/* reexport */ lib_status/* LabStatus */.J),
  LayoutRestorer: () => (/* reexport */ layoutrestorer/* LayoutRestorer */.c),
  Router: () => (/* reexport */ Router),
  addSemanticCommand: () => (/* reexport */ addSemanticCommand),
  createRendermimePlugin: () => (/* reexport */ mimerenderers/* createRendermimePlugin */.aX),
  createRendermimePlugins: () => (/* reexport */ mimerenderers/* createRendermimePlugins */.as),
  createSemanticCommand: () => (/* reexport */ createSemanticCommand)
});

// EXTERNAL MODULE: consume shared module (default) @jupyterlab/apputils@~4.5.5 (singleton) (fallback: ../node_modules/@jupyterlab/apputils/lib/index.js)
var index_js_ = __webpack_require__(6803);
// EXTERNAL MODULE: consume shared module (default) @jupyterlab/translation@~4.4.5 (singleton) (fallback: ../node_modules/@jupyterlab/translation/lib/index.js)
var lib_index_js_ = __webpack_require__(38202);
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/application/lib/connectionlost.js
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.


/**
 * A default connection lost handler, which brings up an error dialog.
 */
const ConnectionLost = async function (manager, err, translator) {
    translator = translator || lib_index_js_.nullTranslator;
    const trans = translator.load('jupyterlab');
    const title = trans.__('Server Connection Error');
    const networkMsg = trans.__('A connection to the Jupyter server could not be established.\n' +
        'JupyterLab will continue trying to reconnect.\n' +
        'Check your network connection or Jupyter server configuration.\n');
    if (!Private.displayConnectionLost) {
        return;
    }
    if (Private.serverConnectionLost) {
        // Wait for the pre-existing promise to complete
        await Private.serverConnectionLost;
        return;
    }
    const dialog = (0,index_js_.showDialog)({
        title: title,
        body: networkMsg,
        checkbox: {
            label: trans.__('Do not show this message again in this session.'),
            caption: trans.__('If checked, you will not see a dialog informing you about an issue with server connection in this session.')
        },
        buttons: [index_js_.Dialog.cancelButton({ label: trans.__('Close') })]
    })
        .then(result => {
        if (result.isChecked) {
            Private.displayConnectionLost = false;
        }
        return;
    })
        .catch(error => {
        console.error('An error occurred while showing the dialog: ', error);
    })
        .finally(() => {
        Private.serverConnectionLost = undefined;
    });
    Private.serverConnectionLost = dialog;
};
/**
 * The namespace for module private data.
 */
var Private;
(function (Private) {
    /**
     * Boolean determining if connection lost dialog is displayed.
     */
    Private.displayConnectionLost = true;
})(Private || (Private = {}));
//# sourceMappingURL=connectionlost.js.map
// EXTERNAL MODULE: consume shared module (default) @jupyterlab/docregistry@~4.4.5 (strict) (fallback: ../node_modules/@jupyterlab/docregistry/lib/index.js)
var docregistry_lib_index_js_ = __webpack_require__(1978);
// EXTERNAL MODULE: consume shared module (default) @jupyterlab/services@~7.4.5 (singleton) (fallback: ../node_modules/@jupyterlab/services/lib/index.js)
var services_lib_index_js_ = __webpack_require__(19838);
// EXTERNAL MODULE: consume shared module (default) @jupyterlab/ui-components@~4.4.5 (singleton) (fallback: ../node_modules/@jupyterlab/ui-components/lib/index.js)
var ui_components_lib_index_js_ = __webpack_require__(52104);
// EXTERNAL MODULE: consume shared module (default) @lumino/application@~2.4.4 (singleton) (fallback: ../node_modules/@lumino/application/dist/index.es6.js)
var index_es6_js_ = __webpack_require__(68257);
// EXTERNAL MODULE: consume shared module (default) @lumino/coreutils@~2.2.1 (singleton) (fallback: ../node_modules/@lumino/coreutils/dist/index.js)
var dist_index_js_ = __webpack_require__(5406);
// EXTERNAL MODULE: consume shared module (default) @lumino/signaling@~2.1.4 (singleton) (fallback: ../node_modules/@lumino/signaling/dist/index.es6.js)
var dist_index_es6_js_ = __webpack_require__(2536);
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/application/lib/frontend.js
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.







/**
 * The base Jupyter front-end application class.
 *
 * @typeparam `T` - The `shell` type. Defaults to `JupyterFrontEnd.IShell`.
 *
 * @typeparam `U` - The type for supported format names. Defaults to `string`.
 *
 * #### Notes
 * This type is useful as a generic application against which front-end plugins
 * can be authored. It inherits from the Lumino `Application`.
 */
class JupyterFrontEnd extends index_es6_js_.Application {
    /**
     * Construct a new JupyterFrontEnd object.
     */
    constructor(options) {
        super(options);
        this._formatChanged = new dist_index_es6_js_.Signal(this);
        // Class to scope global Jupyter CSS rules
        options.shell.addClass('jp-ThemedContainer');
        // render context menu/submenus with inline svg icon tweaks
        this.contextMenu = new ui_components_lib_index_js_.ContextMenuSvg({
            commands: this.commands,
            renderer: options.contextMenuRenderer,
            groupByTarget: false,
            sortBySelector: false
        });
        // The default restored promise if one does not exist in the options.
        const restored = new Promise(resolve => {
            requestAnimationFrame(() => {
                resolve();
            });
        });
        this.commandLinker =
            options.commandLinker || new index_js_.CommandLinker({ commands: this.commands });
        this.docRegistry = options.docRegistry || new docregistry_lib_index_js_.DocumentRegistry();
        this.restored =
            options.restored ||
                this.started.then(() => restored).catch(() => restored);
        this.serviceManager = options.serviceManager || new services_lib_index_js_.ServiceManager();
    }
    /**
     * The application form factor, e.g., `desktop` or `mobile`.
     */
    get format() {
        return this._format;
    }
    set format(format) {
        if (this._format !== format) {
            this._format = format;
            document.body.dataset['format'] = format;
            this._formatChanged.emit(format);
        }
    }
    /**
     * A signal that emits when the application form factor changes.
     */
    get formatChanged() {
        return this._formatChanged;
    }
    /**
     * Walks up the DOM hierarchy of the target of the active `contextmenu`
     * event, testing each HTMLElement ancestor for a user-supplied function. This can
     * be used to find an HTMLElement on which to operate, given a context menu click.
     *
     * @param fn - a function that takes an `HTMLElement` and returns a
     *   boolean for whether it is the element the requester is seeking.
     *
     * @returns an HTMLElement or undefined, if none is found.
     */
    contextMenuHitTest(fn) {
        if (!this._contextMenuEvent ||
            !(this._contextMenuEvent.target instanceof Node)) {
            return undefined;
        }
        let node = this._contextMenuEvent.target;
        do {
            if (node instanceof HTMLElement && fn(node)) {
                return node;
            }
            node = node.parentNode;
        } while (node && node.parentNode && node !== node.parentNode);
        return undefined;
        // TODO: we should be able to use .composedPath() to simplify this function
        // down to something like the below, but it seems like composedPath is
        // sometimes returning an empty list.
        /*
        if (this._contextMenuEvent) {
          this._contextMenuEvent
            .composedPath()
            .filter(x => x instanceof HTMLElement)
            .find(test);
        }
        return undefined;
        */
    }
    /**
     * A method invoked on a document `'contextmenu'` event.
     */
    evtContextMenu(event) {
        this._contextMenuEvent = event;
        if (event.shiftKey ||
            frontend_Private.suppressContextMenu(event.target)) {
            return;
        }
        const opened = this.contextMenu.open(event);
        if (opened) {
            const items = this.contextMenu.menu.items;
            // If only the context menu information will be shown,
            // with no real commands, close the context menu and
            // allow the native one to open.
            if (items.length === 1 &&
                items[0].command === JupyterFrontEndContextMenu.contextMenu) {
                this.contextMenu.menu.close();
                return;
            }
            // Stop propagation and allow the application context menu to show.
            event.preventDefault();
            event.stopPropagation();
        }
    }
}
/**
 * The namespace for `JupyterFrontEnd` class statics.
 */
(function (JupyterFrontEnd) {
    /**
     * Is JupyterLab in document mode?
     *
     * @param path - Full URL of JupyterLab
     * @param paths - The current IPaths object hydrated from PageConfig.
     */
    function inDocMode(path, paths) {
        const docPattern = new RegExp(`^${paths.urls.doc}`);
        const match = path.match(docPattern);
        if (match) {
            return true;
        }
        else {
            return false;
        }
    }
    JupyterFrontEnd.inDocMode = inDocMode;
    /**
     * The application paths dictionary token.
     */
    JupyterFrontEnd.IPaths = new dist_index_js_.Token('@jupyterlab/application:IPaths', `A service providing information about various
  URLs and server paths for the current application. Use this service if you want to
  assemble URLs to use the JupyterLab REST API.`);
    /**
     * The application tree resolver token.
     *
     * #### Notes
     * Not all Jupyter front-end applications will have a tree resolver
     * implemented on the client-side. This token should not be required as a
     * dependency if it is possible to make it an optional dependency.
     */
    JupyterFrontEnd.ITreeResolver = new dist_index_js_.Token('@jupyterlab/application:ITreeResolver', 'A service to resolve the tree path.');
})(JupyterFrontEnd || (JupyterFrontEnd = {}));
/**
 * A namespace for module-private functionality.
 */
var frontend_Private;
(function (Private) {
    /**
     * Returns whether the element is itself, or a child of, an element with the `jp-suppress-context-menu` data attribute.
     */
    function suppressContextMenu(element) {
        return element.closest('[data-jp-suppress-context-menu]') !== null;
    }
    Private.suppressContextMenu = suppressContextMenu;
})(frontend_Private || (frontend_Private = {}));
/**
 * A namespace for the context menu override.
 */
var JupyterFrontEndContextMenu;
(function (JupyterFrontEndContextMenu) {
    /**
     * An id for a private context-menu-info ersatz command.
     */
    JupyterFrontEndContextMenu.contextMenu = '__internal:context-menu-info';
})(JupyterFrontEndContextMenu || (JupyterFrontEndContextMenu = {}));
//# sourceMappingURL=frontend.js.map
// EXTERNAL MODULE: consume shared module (default) @jupyterlab/coreutils@~6.4.5 (singleton) (fallback: ../node_modules/@jupyterlab/coreutils/lib/index.js)
var coreutils_lib_index_js_ = __webpack_require__(24474);
// EXTERNAL MODULE: ../node_modules/@jupyterlab/application/lib/mimerenderers.js
var mimerenderers = __webpack_require__(75677);
// EXTERNAL MODULE: consume shared module (default) @lumino/algorithm@~2.0.3 (singleton) (fallback: ../node_modules/@lumino/algorithm/dist/index.es6.js)
var algorithm_dist_index_es6_js_ = __webpack_require__(56114);
// EXTERNAL MODULE: consume shared module (default) @lumino/messaging@~2.0.3 (singleton) (fallback: ../node_modules/@lumino/messaging/dist/index.es6.js)
var messaging_dist_index_es6_js_ = __webpack_require__(34993);
// EXTERNAL MODULE: consume shared module (default) @lumino/polling@^2.1.4 (strict) (fallback: ../node_modules/@lumino/polling/dist/index.es6.js)
var polling_dist_index_es6_js_ = __webpack_require__(1492);
// EXTERNAL MODULE: consume shared module (default) @lumino/widgets@~2.7.1 (singleton) (fallback: ../node_modules/@lumino/widgets/dist/index.es6.js)
var widgets_dist_index_es6_js_ = __webpack_require__(60920);
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/application/lib/shell.js
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.









/**
 * The class name added to AppShell instances.
 */
const APPLICATION_SHELL_CLASS = 'jp-LabShell';
/**
 * The class name added to side bar instances.
 */
const SIDEBAR_CLASS = 'jp-SideBar';
/**
 * The class name added to the current widget's title.
 */
const CURRENT_CLASS = 'jp-mod-current';
/**
 * The class name added to the active widget's title.
 */
const ACTIVE_CLASS = 'jp-mod-active';
/**
 * The default rank of items added to a sidebar.
 */
const DEFAULT_RANK = 900;
const ACTIVITY_CLASS = 'jp-Activity';
/**
 * The JupyterLab application shell token.
 */
const ILabShell = new dist_index_js_.Token('@jupyterlab/application:ILabShell', 'A service for interacting with the JupyterLab shell. The top-level ``application`` object also has a reference to the shell, but it has a restricted interface in order to be agnostic to different shell implementations on the application. Use this to get more detailed information about currently active widgets and layout state.');
/**
 * The application shell for JupyterLab.
 */
class LabShell extends widgets_dist_index_es6_js_.Widget {
    /**
     * Construct a new application shell.
     */
    constructor(options) {
        super();
        /**
         * A message hook for child add/remove messages on the main area dock panel.
         */
        this._dockChildHook = (handler, msg) => {
            switch (msg.type) {
                case 'child-added':
                    msg.child.addClass(ACTIVITY_CLASS);
                    this._tracker.add(msg.child);
                    break;
                case 'child-removed':
                    msg.child.removeClass(ACTIVITY_CLASS);
                    this._tracker.remove(msg.child);
                    break;
                default:
                    break;
            }
            return true;
        };
        this._activeChanged = new dist_index_es6_js_.Signal(this);
        this._cachedLayout = null;
        this._currentChanged = new dist_index_es6_js_.Signal(this);
        this._currentPath = '';
        this._currentPathChanged = new dist_index_es6_js_.Signal(this);
        this._modeChanged = new dist_index_es6_js_.Signal(this);
        this._isRestored = false;
        this._layoutModified = new dist_index_es6_js_.Signal(this);
        this._layoutDebouncer = new polling_dist_index_es6_js_.Debouncer(() => {
            this._layoutModified.emit(undefined);
        }, 0);
        this._restored = new dist_index_js_.PromiseDelegate();
        this._tracker = new widgets_dist_index_es6_js_.FocusTracker();
        this._topHandlerHiddenByUser = false;
        this._idTypeMap = new Map();
        this._mainOptionsCache = new Map();
        this._sideOptionsCache = new Map();
        this._delayedWidget = new Array();
        this.addClass(APPLICATION_SHELL_CLASS);
        this.id = 'main';
        if ((options === null || options === void 0 ? void 0 : options.waitForRestore) === false) {
            this._userLayout = { 'multiple-document': {}, 'single-document': {} };
        }
        // Skip Links
        const skipLinkWidget = (this._skipLinkWidget = new shell_Private.SkipLinkWidget(this));
        this._skipLinkWidget.show();
        //  Wrap the skip widget to customize its position and size
        const skipLinkWrapper = new widgets_dist_index_es6_js_.Panel();
        skipLinkWrapper.addClass('jp-skiplink-wrapper');
        skipLinkWrapper.addWidget(skipLinkWidget);
        const headerPanel = (this._headerPanel = new widgets_dist_index_es6_js_.BoxPanel());
        const menuHandler = (this._menuHandler = new shell_Private.PanelHandler());
        menuHandler.panel.node.setAttribute('role', 'navigation');
        const topHandler = (this._topHandler = new shell_Private.PanelHandler());
        topHandler.panel.node.setAttribute('role', 'banner');
        const bottomPanel = (this._bottomPanel = new widgets_dist_index_es6_js_.BoxPanel());
        bottomPanel.node.setAttribute('role', 'contentinfo');
        const hboxPanel = new widgets_dist_index_es6_js_.BoxPanel();
        const vsplitPanel = (this._vsplitPanel =
            new shell_Private.RestorableSplitPanel());
        const dockPanel = (this._dockPanel = new ui_components_lib_index_js_.DockPanelSvg({
            hiddenMode: widgets_dist_index_es6_js_.Widget.HiddenMode.Display
        }));
        messaging_dist_index_es6_js_.MessageLoop.installMessageHook(dockPanel, this._dockChildHook);
        const hsplitPanel = (this._hsplitPanel =
            new shell_Private.RestorableSplitPanel());
        const downPanel = (this._downPanel = new ui_components_lib_index_js_.TabPanelSvg({
            tabsMovable: true
        }));
        const leftHandler = (this._leftHandler = new shell_Private.SideBarHandler());
        const rightHandler = (this._rightHandler = new shell_Private.SideBarHandler());
        const rootLayout = new widgets_dist_index_es6_js_.BoxLayout();
        headerPanel.id = 'jp-header-panel';
        menuHandler.panel.id = 'jp-menu-panel';
        topHandler.panel.id = 'jp-top-panel';
        bottomPanel.id = 'jp-bottom-panel';
        hboxPanel.id = 'jp-main-content-panel';
        vsplitPanel.id = 'jp-main-vsplit-panel';
        dockPanel.id = 'jp-main-dock-panel';
        hsplitPanel.id = 'jp-main-split-panel';
        downPanel.id = 'jp-down-stack';
        leftHandler.sideBar.addClass(SIDEBAR_CLASS);
        leftHandler.sideBar.addClass('jp-mod-left');
        leftHandler.sideBar.node.setAttribute('role', 'complementary');
        leftHandler.stackedPanel.id = 'jp-left-stack';
        rightHandler.sideBar.addClass(SIDEBAR_CLASS);
        rightHandler.sideBar.addClass('jp-mod-right');
        rightHandler.sideBar.node.setAttribute('role', 'complementary');
        rightHandler.stackedPanel.id = 'jp-right-stack';
        dockPanel.node.setAttribute('role', 'main');
        hboxPanel.spacing = 0;
        vsplitPanel.spacing = 1;
        dockPanel.spacing = 5;
        hsplitPanel.spacing = 1;
        headerPanel.direction = 'top-to-bottom';
        vsplitPanel.orientation = 'vertical';
        hboxPanel.direction = 'left-to-right';
        hsplitPanel.orientation = 'horizontal';
        bottomPanel.direction = 'bottom-to-top';
        widgets_dist_index_es6_js_.SplitPanel.setStretch(leftHandler.stackedPanel, 0);
        widgets_dist_index_es6_js_.SplitPanel.setStretch(downPanel, 0);
        widgets_dist_index_es6_js_.SplitPanel.setStretch(dockPanel, 1);
        widgets_dist_index_es6_js_.SplitPanel.setStretch(rightHandler.stackedPanel, 0);
        widgets_dist_index_es6_js_.BoxPanel.setStretch(leftHandler.sideBar, 0);
        widgets_dist_index_es6_js_.BoxPanel.setStretch(hsplitPanel, 1);
        widgets_dist_index_es6_js_.BoxPanel.setStretch(rightHandler.sideBar, 0);
        widgets_dist_index_es6_js_.SplitPanel.setStretch(vsplitPanel, 1);
        hsplitPanel.addWidget(leftHandler.stackedPanel);
        hsplitPanel.addWidget(dockPanel);
        hsplitPanel.addWidget(rightHandler.stackedPanel);
        vsplitPanel.addWidget(hsplitPanel);
        vsplitPanel.addWidget(downPanel);
        hboxPanel.addWidget(leftHandler.sideBar);
        hboxPanel.addWidget(vsplitPanel);
        hboxPanel.addWidget(rightHandler.sideBar);
        rootLayout.direction = 'top-to-bottom';
        rootLayout.spacing = 0; // TODO make this configurable?
        // Use relative sizing to set the width of the side panels.
        // This will still respect the min-size of children widget in the stacked
        // panel. The default sizes will be overwritten during layout restoration.
        vsplitPanel.setRelativeSizes([3, 1]);
        hsplitPanel.setRelativeSizes([1, 2.5, 1]);
        widgets_dist_index_es6_js_.BoxLayout.setStretch(headerPanel, 0);
        widgets_dist_index_es6_js_.BoxLayout.setStretch(menuHandler.panel, 0);
        widgets_dist_index_es6_js_.BoxLayout.setStretch(topHandler.panel, 0);
        widgets_dist_index_es6_js_.BoxLayout.setStretch(hboxPanel, 1);
        widgets_dist_index_es6_js_.BoxLayout.setStretch(bottomPanel, 0);
        rootLayout.addWidget(skipLinkWrapper);
        rootLayout.addWidget(headerPanel);
        rootLayout.addWidget(topHandler.panel);
        rootLayout.addWidget(hboxPanel);
        rootLayout.addWidget(bottomPanel);
        // initially hiding header and bottom panel when no elements inside,
        this._headerPanel.hide();
        this._bottomPanel.hide();
        this._downPanel.hide();
        this.layout = rootLayout;
        // Connect change listeners.
        this._tracker.currentChanged.connect(this._onCurrentChanged, this);
        this._tracker.activeChanged.connect(this._onActiveChanged, this);
        // Connect main layout change listener.
        this._dockPanel.layoutModified.connect(this._onLayoutModified, this);
        // Connect vsplit layout change listener
        this._vsplitPanel.updated.connect(this._onLayoutModified, this);
        // Connect down panel change listeners
        this._downPanel.currentChanged.connect(this._onLayoutModified, this);
        this._downPanel.tabBar.tabMoved.connect(this._onTabPanelChanged, this);
        this._downPanel.stackedPanel.widgetRemoved.connect(this._onTabPanelChanged, this);
        // Catch current changed events on the side handlers.
        this._leftHandler.updated.connect(this._onLayoutModified, this);
        this._rightHandler.updated.connect(this._onLayoutModified, this);
        // Catch update events on the horizontal split panel
        this._hsplitPanel.updated.connect(this._onLayoutModified, this);
        // Setup single-document-mode title bar
        const titleHandler = (this._titleHandler = new shell_Private.TitleHandler(this));
        this.add(titleHandler, 'top', { rank: 100 });
        if (this._dockPanel.mode === 'multiple-document') {
            this._topHandler.addWidget(this._menuHandler.panel, 100);
            titleHandler.hide();
        }
        else {
            rootLayout.insertWidget(3, this._menuHandler.panel);
        }
        this.translator = lib_index_js_.nullTranslator;
        // Wire up signals to update the title panel of the simple interface mode to
        // follow the title of this.currentWidget
        this.currentChanged.connect((sender, args) => {
            let newValue = args.newValue;
            let oldValue = args.oldValue;
            // Stop watching the title of the previously current widget
            if (oldValue) {
                oldValue.title.changed.disconnect(this._updateTitlePanelTitle, this);
                if (oldValue instanceof docregistry_lib_index_js_.DocumentWidget) {
                    oldValue.context.pathChanged.disconnect(this._updateCurrentPath, this);
                }
            }
            // Start watching the title of the new current widget
            if (newValue) {
                newValue.title.changed.connect(this._updateTitlePanelTitle, this);
                this._updateTitlePanelTitle();
                if (newValue instanceof docregistry_lib_index_js_.DocumentWidget) {
                    newValue.context.pathChanged.connect(this._updateCurrentPath, this);
                }
            }
            this._updateCurrentPath();
        });
    }
    /**
     * A signal emitted when main area's active focus changes.
     */
    get activeChanged() {
        return this._activeChanged;
    }
    /**
     * The active widget in the shell's main area.
     */
    get activeWidget() {
        return this._tracker.activeWidget;
    }
    /**
     * Whether the add buttons for each main area tab bar are enabled.
     */
    get addButtonEnabled() {
        return this._dockPanel.addButtonEnabled;
    }
    set addButtonEnabled(value) {
        this._dockPanel.addButtonEnabled = value;
    }
    /**
     * A signal emitted when the add button on a main area tab bar is clicked.
     */
    get addRequested() {
        return this._dockPanel.addRequested;
    }
    /**
     * A signal emitted when main area's current focus changes.
     */
    get currentChanged() {
        return this._currentChanged;
    }
    /**
     * Current document path.
     */
    // FIXME deprecation `undefined` is to ensure backward compatibility in 4.x
    get currentPath() {
        return this._currentPath;
    }
    /**
     * A signal emitted when the path of the current document changes.
     *
     * This also fires when the current document itself changes.
     */
    get currentPathChanged() {
        return this._currentPathChanged;
    }
    /**
     * The current widget in the shell's main area.
     */
    get currentWidget() {
        return this._tracker.currentWidget;
    }
    /**
     * A signal emitted when the main area's layout is modified.
     */
    get layoutModified() {
        return this._layoutModified;
    }
    /**
     * Whether the left area is collapsed.
     */
    get leftCollapsed() {
        return !this._leftHandler.sideBar.currentTitle;
    }
    /**
     * Whether the left area is collapsed.
     */
    get rightCollapsed() {
        return !this._rightHandler.sideBar.currentTitle;
    }
    /**
     * Whether JupyterLab is in presentation mode with the
     * `jp-mod-presentationMode` CSS class.
     */
    get presentationMode() {
        return this.hasClass('jp-mod-presentationMode');
    }
    set presentationMode(value) {
        this.toggleClass('jp-mod-presentationMode', value);
    }
    /**
     * The main dock area's user interface mode.
     */
    get mode() {
        return this._dockPanel.mode;
    }
    set mode(mode) {
        const dock = this._dockPanel;
        if (mode === dock.mode) {
            return;
        }
        const applicationCurrentWidget = this.currentWidget;
        if (mode === 'single-document') {
            // Cache the current multi-document layout before changing the mode.
            this._cachedLayout = dock.saveLayout();
            dock.mode = mode;
            // In case the active widget in the dock panel is *not* the active widget
            // of the application, defer to the application.
            if (this.currentWidget) {
                dock.activateWidget(this.currentWidget);
            }
            // Adjust menu and title
            this.layout.insertWidget(3, this._menuHandler.panel);
            this._titleHandler.show();
            this._updateTitlePanelTitle();
            if (this._topHandlerHiddenByUser) {
                this._topHandler.panel.hide();
            }
        }
        else {
            // Cache a reference to every widget currently in the dock panel before
            // changing its mode.
            const widgets = Array.from(dock.widgets());
            dock.mode = mode;
            // Restore cached layout if possible.
            if (this._cachedLayout) {
                // Remove any disposed widgets in the cached layout and restore.
                shell_Private.normalizeAreaConfig(dock, this._cachedLayout.main);
                dock.restoreLayout(this._cachedLayout);
                this._cachedLayout = null;
            }
            // If layout restoration has been deferred, restore layout now.
            if (this._layoutRestorer.isDeferred) {
                this._layoutRestorer
                    .restoreDeferred()
                    .then(mainArea => {
                    if (mainArea) {
                        const { currentWidget, dock } = mainArea;
                        if (dock) {
                            this._dockPanel.restoreLayout(dock);
                        }
                        if (currentWidget) {
                            this.activateById(currentWidget.id);
                        }
                    }
                })
                    .catch(reason => {
                    console.error('Failed to restore the deferred layout.');
                    console.error(reason);
                });
            }
            // Add any widgets created during single document mode, which have
            // subsequently been removed from the dock panel after the multiple document
            // layout has been restored. If the widget has add options cached for
            // the widget (i.e., if it has been placed with respect to another widget),
            // then take that into account.
            widgets.forEach(widget => {
                if (!widget.parent) {
                    this._addToMainArea(widget, {
                        ...this._mainOptionsCache.get(widget),
                        activate: false
                    });
                }
            });
            this._mainOptionsCache.clear();
            // In case the active widget in the dock panel is *not* the active widget
            // of the application, defer to the application.
            if (applicationCurrentWidget) {
                dock.activateWidget(applicationCurrentWidget);
            }
            // Adjust menu and title
            this.add(this._menuHandler.panel, 'top', { rank: 100 });
            this._titleHandler.hide();
        }
        // Set the mode data attribute on the applications shell node.
        this.node.dataset.shellMode = mode;
        this._downPanel.fit();
        // Emit the mode changed signal
        this._modeChanged.emit(mode);
    }
    /**
     * A signal emitted when the shell/dock panel change modes (single/multiple document).
     */
    get modeChanged() {
        return this._modeChanged;
    }
    /**
     * Promise that resolves when state is first restored, returning layout
     * description.
     */
    get restored() {
        return this._restored.promise;
    }
    get translator() {
        var _a;
        return (_a = this._translator) !== null && _a !== void 0 ? _a : lib_index_js_.nullTranslator;
    }
    set translator(value) {
        if (value !== this._translator) {
            this._translator = value;
            // Set translator for tab bars
            ui_components_lib_index_js_.TabBarSvg.translator = value;
            const trans = value.load('jupyterlab');
            this._menuHandler.panel.node.setAttribute('aria-label', trans.__('main menu'));
            this._leftHandler.sideBar.node.setAttribute('aria-label', trans.__('main sidebar'));
            this._leftHandler.sideBar.contentNode.setAttribute('aria-label', trans.__('main sidebar'));
            this._rightHandler.sideBar.node.setAttribute('aria-label', trans.__('alternate sidebar'));
            this._rightHandler.sideBar.contentNode.setAttribute('aria-label', trans.__('alternate sidebar'));
            this._topHandler.panel.node.setAttribute('aria-label', trans.__('Top Bar'));
            this._bottomPanel.node.setAttribute('aria-label', trans.__('Bottom Panel'));
            this._dockPanel.node.setAttribute('aria-label', trans.__('Main Content'));
        }
    }
    /**
     * User customized shell layout.
     */
    get userLayout() {
        return dist_index_js_.JSONExt.deepCopy(this._userLayout);
    }
    /**
     * Activate a widget in its area.
     */
    activateById(id) {
        if (this._leftHandler.has(id)) {
            this._leftHandler.activate(id);
            return;
        }
        if (this._rightHandler.has(id)) {
            this._rightHandler.activate(id);
            return;
        }
        const tabIndex = this._downPanel.tabBar.titles.findIndex(title => title.owner.id === id);
        if (tabIndex >= 0) {
            this._downPanel.currentIndex = tabIndex;
            return;
        }
        const dock = this._dockPanel;
        const widget = (0,algorithm_dist_index_es6_js_.find)(dock.widgets(), value => value.id === id);
        if (widget) {
            dock.activateWidget(widget);
        }
    }
    /**
     * Activate widget in specified area.
     *
     * ### Notes
     * The alpha version of this method only supports activating the "main" area.
     *
     * @alpha
     * @param area Name of area to activate
     */
    activateArea(area = 'main') {
        switch (area) {
            case 'main':
                {
                    const current = this._currentTabBar();
                    if (!current) {
                        return;
                    }
                    if (current.currentTitle) {
                        current.currentTitle.owner.activate();
                    }
                }
                return;
            case 'left':
            case 'right':
            case 'header':
            case 'top':
            case 'menu':
            case 'bottom':
                console.debug(`Area: ${area} activation not yet implemented`);
                break;
            default:
                throw new Error(`Invalid area: ${area}`);
        }
    }
    /**
     * Activate the next Tab in the active TabBar.
     */
    activateNextTab() {
        const current = this._currentTabBar();
        if (!current) {
            return;
        }
        const ci = current.currentIndex;
        if (ci === -1) {
            return;
        }
        if (ci < current.titles.length - 1) {
            current.currentIndex += 1;
            if (current.currentTitle) {
                current.currentTitle.owner.activate();
            }
            return;
        }
        if (ci === current.titles.length - 1) {
            const nextBar = this._adjacentBar('next');
            if (nextBar) {
                nextBar.currentIndex = 0;
                if (nextBar.currentTitle) {
                    nextBar.currentTitle.owner.activate();
                }
            }
        }
    }
    /**
     * Activate the previous Tab in the active TabBar.
     */
    activatePreviousTab() {
        const current = this._currentTabBar();
        if (!current) {
            return;
        }
        const ci = current.currentIndex;
        if (ci === -1) {
            return;
        }
        if (ci > 0) {
            current.currentIndex -= 1;
            if (current.currentTitle) {
                current.currentTitle.owner.activate();
            }
            return;
        }
        if (ci === 0) {
            const prevBar = this._adjacentBar('previous');
            if (prevBar) {
                const len = prevBar.titles.length;
                prevBar.currentIndex = len - 1;
                if (prevBar.currentTitle) {
                    prevBar.currentTitle.owner.activate();
                }
            }
        }
    }
    /**
     * Activate the next TabBar.
     */
    activateNextTabBar() {
        const nextBar = this._adjacentBar('next');
        if (nextBar) {
            if (nextBar.currentTitle) {
                nextBar.currentTitle.owner.activate();
            }
        }
    }
    /**
     * Activate the next TabBar.
     */
    activatePreviousTabBar() {
        const nextBar = this._adjacentBar('previous');
        if (nextBar) {
            if (nextBar.currentTitle) {
                nextBar.currentTitle.owner.activate();
            }
        }
    }
    /**
     * Add a widget to the JupyterLab shell
     *
     * @param widget Widget
     * @param area Area
     * @param options Options
     */
    add(widget, area = 'main', options) {
        var _a;
        if (!this._userLayout) {
            this._delayedWidget.push({ widget, area, options });
            return;
        }
        let userPosition;
        if ((options === null || options === void 0 ? void 0 : options.type) && this._userLayout[this.mode][options.type]) {
            userPosition = this._userLayout[this.mode][options.type];
            this._idTypeMap.set(widget.id, options.type);
        }
        else {
            userPosition = this._userLayout[this.mode][widget.id];
        }
        if (options === null || options === void 0 ? void 0 : options.type) {
            this._idTypeMap.set(widget.id, options.type);
            widget.disposed.connect(() => {
                this._idTypeMap.delete(widget.id);
            });
        }
        area = (_a = userPosition === null || userPosition === void 0 ? void 0 : userPosition.area) !== null && _a !== void 0 ? _a : area;
        options =
            options || (userPosition === null || userPosition === void 0 ? void 0 : userPosition.options)
                ? {
                    ...options,
                    ...userPosition === null || userPosition === void 0 ? void 0 : userPosition.options
                }
                : undefined;
        switch (area || 'main') {
            case 'bottom':
                return this._addToBottomArea(widget, options);
            case 'down':
                return this._addToDownArea(widget, options);
            case 'header':
                return this._addToHeaderArea(widget, options);
            case 'left':
                return this._addToLeftArea(widget, options);
            case 'main':
                return this._addToMainArea(widget, options);
            case 'menu':
                return this._addToMenuArea(widget, options);
            case 'right':
                return this._addToRightArea(widget, options);
            case 'top':
                return this._addToTopArea(widget, options);
            default:
                throw new Error(`Invalid area: ${area}`);
        }
    }
    /**
     * Move a widget type to a new area.
     *
     * The type is determined from the `widget.id` and fallback to `widget.id`.
     *
     * #### Notes
     * If `mode` is undefined, both mode are updated.
     * The new layout is now persisted.
     *
     * @param widget Widget to move
     * @param area New area
     * @param mode Mode to change
     * @returns The new user layout
     */
    move(widget, area, mode) {
        var _a;
        const type = (_a = this._idTypeMap.get(widget.id)) !== null && _a !== void 0 ? _a : widget.id;
        for (const m of ['single-document', 'multiple-document'].filter(c => !mode || c === mode)) {
            this._userLayout[m][type] = {
                ...this._userLayout[m][type],
                area
            };
        }
        this.add(widget, area);
        return this._userLayout;
    }
    /**
     * Collapse the left area.
     */
    collapseLeft() {
        this._leftHandler.collapse();
        this._onLayoutModified();
    }
    /**
     * Collapse the right area.
     */
    collapseRight() {
        this._rightHandler.collapse();
        this._onLayoutModified();
    }
    /**
     * Dispose the shell.
     */
    dispose() {
        if (this.isDisposed) {
            return;
        }
        this._layoutDebouncer.dispose();
        super.dispose();
    }
    /**
     * Expand the left area.
     *
     * #### Notes
     * This will open the most recently used tab,
     * or the first tab if there is no most recently used.
     */
    expandLeft() {
        this._leftHandler.expand();
        this._onLayoutModified();
    }
    /**
     * Expand the right area.
     *
     * #### Notes
     * This will open the most recently used tab,
     * or the first tab if there is no most recently used.
     */
    expandRight() {
        this._rightHandler.expand();
        this._onLayoutModified();
    }
    /**
     * Close all widgets in the main and down area.
     */
    closeAll() {
        // Make a copy of all the widget in the dock panel (using `Array.from()`)
        // before removing them because removing them while iterating through them
        // modifies the underlying data of the iterator.
        Array.from(this._dockPanel.widgets()).forEach(widget => widget.close());
        this._downPanel.stackedPanel.widgets.forEach(widget => widget.close());
    }
    /**
     * Whether an side tab bar is visible or not.
     *
     * @param side Sidebar of interest
     * @returns Side tab bar visibility
     */
    isSideTabBarVisible(side) {
        switch (side) {
            case 'left':
                return this._leftHandler.isVisible;
            case 'right':
                return this._rightHandler.isVisible;
        }
    }
    /**
     * Whether the top bar in simple mode is visible or not.
     *
     * @returns Top bar visibility
     */
    isTopInSimpleModeVisible() {
        return !this._topHandlerHiddenByUser;
    }
    /**
     * True if the given area is empty.
     */
    isEmpty(area) {
        switch (area) {
            case 'bottom':
                return this._bottomPanel.widgets.length === 0;
            case 'down':
                return this._downPanel.stackedPanel.widgets.length === 0;
            case 'header':
                return this._headerPanel.widgets.length === 0;
            case 'left':
                return this._leftHandler.stackedPanel.widgets.length === 0;
            case 'main':
                return this._dockPanel.isEmpty;
            case 'menu':
                return this._menuHandler.panel.widgets.length === 0;
            case 'right':
                return this._rightHandler.stackedPanel.widgets.length === 0;
            case 'top':
                return this._topHandler.panel.widgets.length === 0;
            default:
                return true;
        }
    }
    /**
     * Restore the layout state and configuration for the application shell.
     *
     * #### Notes
     * This should only be called once.
     */
    async restoreLayout(mode, layoutRestorer, configuration = {}) {
        var _a, _b, _c, _d;
        // Set the configuration and add widgets added before the shell was ready.
        this._userLayout = {
            'single-document': (_a = configuration['single-document']) !== null && _a !== void 0 ? _a : {},
            'multiple-document': (_b = configuration['multiple-document']) !== null && _b !== void 0 ? _b : {}
        };
        this._delayedWidget.forEach(({ widget, area, options }) => {
            this.add(widget, area, options);
        });
        this._delayedWidget.length = 0;
        this._layoutRestorer = layoutRestorer;
        // Get the layout from the restorer
        const layout = await layoutRestorer.fetch();
        // Reset the layout
        const { mainArea, downArea, leftArea, rightArea, topArea, relativeSizes } = layout;
        // Rehydrate the main area.
        if (mainArea) {
            const { currentWidget, dock } = mainArea;
            if (dock && mode === 'multiple-document') {
                this._dockPanel.restoreLayout(dock);
            }
            if (mode) {
                this.mode = mode;
            }
            if (currentWidget) {
                this.activateById(currentWidget.id);
            }
        }
        else {
            // This is needed when loading in an empty workspace in single doc mode
            if (mode) {
                this.mode = mode;
            }
        }
        if ((topArea === null || topArea === void 0 ? void 0 : topArea.simpleVisibility) !== undefined) {
            this._topHandlerHiddenByUser = !topArea.simpleVisibility;
            if (this.mode === 'single-document') {
                this._topHandler.panel.setHidden(this._topHandlerHiddenByUser);
            }
        }
        // Rehydrate the down area
        if (downArea) {
            const { currentWidget, widgets, size } = downArea;
            const widgetIds = (_c = widgets === null || widgets === void 0 ? void 0 : widgets.map(widget => widget.id)) !== null && _c !== void 0 ? _c : [];
            // Remove absent widgets
            this._downPanel.tabBar.titles
                .filter(title => !widgetIds.includes(title.owner.id))
                .map(title => title.owner.close());
            // Add new widgets
            const titleIds = this._downPanel.tabBar.titles.map(title => title.owner.id);
            widgets === null || widgets === void 0 ? void 0 : widgets.filter(widget => !titleIds.includes(widget.id)).map(widget => this._downPanel.addWidget(widget));
            // Reorder tabs
            while (!algorithm_dist_index_es6_js_.ArrayExt.shallowEqual(widgetIds, this._downPanel.tabBar.titles.map(title => title.owner.id))) {
                this._downPanel.tabBar.titles.forEach((title, index) => {
                    const position = widgetIds.findIndex(id => title.owner.id == id);
                    if (position >= 0 && position != index) {
                        this._downPanel.tabBar.insertTab(position, title);
                    }
                });
            }
            if (currentWidget) {
                const index = this._downPanel.stackedPanel.widgets.findIndex(widget => widget.id === currentWidget.id);
                if (index) {
                    this._downPanel.currentIndex = index;
                    (_d = this._downPanel.currentWidget) === null || _d === void 0 ? void 0 : _d.activate();
                }
            }
            if (size && size > 0.0) {
                this._vsplitPanel.setRelativeSizes([1.0 - size, size]);
            }
            else {
                // Close all tabs and hide the panel
                this._downPanel.stackedPanel.widgets.forEach(widget => widget.close());
                this._downPanel.hide();
            }
        }
        // Rehydrate the left area.
        if (leftArea) {
            this._leftHandler.rehydrate(leftArea);
        }
        else {
            if (mode === 'single-document') {
                this.collapseLeft();
            }
        }
        // Rehydrate the right area.
        if (rightArea) {
            this._rightHandler.rehydrate(rightArea);
        }
        else {
            if (mode === 'single-document') {
                this.collapseRight();
            }
        }
        // Restore the relative sizes.
        if (relativeSizes) {
            this._hsplitPanel.setRelativeSizes(relativeSizes);
        }
        if (!this._isRestored) {
            // Make sure all messages in the queue are finished before notifying
            // any extensions that are waiting for the promise that guarantees the
            // application state has been restored.
            messaging_dist_index_es6_js_.MessageLoop.flush();
            this._restored.resolve(layout);
        }
    }
    /**
     * Save the dehydrated state of the application shell.
     */
    saveLayout() {
        // If the application is in single document mode, use the cached layout if
        // available. Otherwise, default to querying the dock panel for layout.
        const layout = {
            mainArea: {
                currentWidget: this._tracker.currentWidget,
                dock: this.mode === 'single-document'
                    ? this._cachedLayout || this._dockPanel.saveLayout()
                    : this._dockPanel.saveLayout()
            },
            downArea: {
                currentWidget: this._downPanel.currentWidget,
                widgets: Array.from(this._downPanel.stackedPanel.widgets),
                size: this._vsplitPanel.relativeSizes()[1]
            },
            leftArea: this._leftHandler.dehydrate(),
            rightArea: this._rightHandler.dehydrate(),
            topArea: { simpleVisibility: !this._topHandlerHiddenByUser },
            relativeSizes: this._hsplitPanel.relativeSizes()
        };
        return layout;
    }
    /**
     * Toggle top header visibility in simple mode
     *
     * Note: Does nothing in multi-document mode
     */
    toggleTopInSimpleModeVisibility() {
        if (this.mode === 'single-document') {
            if (this._topHandler.panel.isVisible) {
                this._topHandlerHiddenByUser = true;
                this._topHandler.panel.hide();
            }
            else {
                this._topHandlerHiddenByUser = false;
                this._topHandler.panel.show();
                this._updateTitlePanelTitle();
            }
            this._onLayoutModified();
        }
    }
    /**
     * Toggle side tab bar visibility
     *
     * @param side Sidebar of interest
     */
    toggleSideTabBarVisibility(side) {
        if (side === 'right') {
            if (this._rightHandler.isVisible) {
                this._rightHandler.hide();
            }
            else {
                this._rightHandler.show();
            }
        }
        else {
            if (this._leftHandler.isVisible) {
                this._leftHandler.hide();
            }
            else {
                this._leftHandler.show();
            }
        }
    }
    /**
     * Update the shell configuration.
     *
     * @param config Shell configuration
     */
    updateConfig(config) {
        if (config.hiddenMode) {
            switch (config.hiddenMode) {
                case 'display':
                    this._dockPanel.hiddenMode = widgets_dist_index_es6_js_.Widget.HiddenMode.Display;
                    break;
                case 'scale':
                    this._dockPanel.hiddenMode = widgets_dist_index_es6_js_.Widget.HiddenMode.Scale;
                    break;
                case 'contentVisibility':
                    this._dockPanel.hiddenMode = widgets_dist_index_es6_js_.Widget.HiddenMode.ContentVisibility;
                    break;
            }
        }
    }
    /**
     * Returns the widgets for an application area.
     */
    widgets(area) {
        switch (area !== null && area !== void 0 ? area : 'main') {
            case 'main':
                return this._dockPanel.widgets();
            case 'left':
                return (0,algorithm_dist_index_es6_js_.map)(this._leftHandler.sideBar.titles, t => t.owner);
            case 'right':
                return (0,algorithm_dist_index_es6_js_.map)(this._rightHandler.sideBar.titles, t => t.owner);
            case 'header':
                return this._headerPanel.children();
            case 'top':
                return this._topHandler.panel.children();
            case 'menu':
                return this._menuHandler.panel.children();
            case 'bottom':
                return this._bottomPanel.children();
            default:
                throw new Error(`Invalid area: ${area}`);
        }
    }
    /**
     * Handle `after-attach` messages for the application shell.
     */
    onAfterAttach(msg) {
        this.node.dataset.shellMode = this.mode;
    }
    /**
     * Update the title panel title based on the title of the current widget.
     */
    _updateTitlePanelTitle() {
        let current = this.currentWidget;
        const inputElement = this._titleHandler.inputElement;
        inputElement.value = current ? current.title.label : '';
        inputElement.title = current ? current.title.caption : '';
    }
    /**
     * The path of the current widget changed, fire the _currentPathChanged signal.
     */
    _updateCurrentPath() {
        let current = this.currentWidget;
        let newValue = '';
        if (current && current instanceof docregistry_lib_index_js_.DocumentWidget) {
            newValue = current.context.path;
        }
        this._currentPathChanged.emit({
            newValue: newValue,
            oldValue: this._currentPath
        });
        this._currentPath = newValue;
    }
    /**
     * Add a widget to the left content area.
     *
     * #### Notes
     * Widgets must have a unique `id` property, which will be used as the DOM id.
     */
    _addToLeftArea(widget, options) {
        if (!widget.id) {
            console.error('Widgets added to app shell must have unique id property.');
            return;
        }
        options = options || this._sideOptionsCache.get(widget) || {};
        this._sideOptionsCache.set(widget, options);
        const rank = 'rank' in options ? options.rank : DEFAULT_RANK;
        this._leftHandler.addWidget(widget, rank);
        this._onLayoutModified();
    }
    /**
     * Add a widget to the main content area.
     *
     * #### Notes
     * Widgets must have a unique `id` property, which will be used as the DOM id.
     * All widgets added to the main area should be disposed after removal
     * (disposal before removal will remove the widget automatically).
     *
     * In the options, `ref` defaults to `null`, `mode` defaults to `'tab-after'`,
     * and `activate` defaults to `true`.
     */
    _addToMainArea(widget, options) {
        if (!widget.id) {
            console.error('Widgets added to app shell must have unique id property.');
            return;
        }
        options = options || {};
        const dock = this._dockPanel;
        const mode = options.mode || 'tab-after';
        let ref = this.currentWidget;
        if (options.ref) {
            ref = (0,algorithm_dist_index_es6_js_.find)(dock.widgets(), value => value.id === options.ref) || null;
        }
        const { title } = widget;
        // Add widget ID to tab so that we can get a handle on the tab's widget
        // (for context menu support)
        title.dataset = { ...title.dataset, id: widget.id };
        if (title.icon instanceof ui_components_lib_index_js_.LabIcon) {
            // bind an appropriate style to the icon
            title.icon = title.icon.bindprops({
                stylesheet: 'mainAreaTab'
            });
        }
        else if (typeof title.icon === 'string' || !title.icon) {
            // add some classes to help with displaying css background imgs
            title.iconClass = (0,ui_components_lib_index_js_.classes)(title.iconClass, 'jp-Icon');
        }
        dock.addWidget(widget, { mode, ref });
        // The dock panel doesn't account for placement information while
        // in single document mode, so upon rehydrating any widgets that were
        // added will not be in the correct place. Cache the placement information
        // here so that we can later rehydrate correctly.
        if (dock.mode === 'single-document') {
            this._mainOptionsCache.set(widget, options);
        }
        if (options.activate !== false) {
            dock.activateWidget(widget);
        }
    }
    /**
     * Add a widget to the right content area.
     *
     * #### Notes
     * Widgets must have a unique `id` property, which will be used as the DOM id.
     */
    _addToRightArea(widget, options) {
        if (!widget.id) {
            console.error('Widgets added to app shell must have unique id property.');
            return;
        }
        options = options || this._sideOptionsCache.get(widget) || {};
        const rank = 'rank' in options ? options.rank : DEFAULT_RANK;
        this._sideOptionsCache.set(widget, options);
        this._rightHandler.addWidget(widget, rank);
        this._onLayoutModified();
    }
    /**
     * Add a widget to the top content area.
     *
     * #### Notes
     * Widgets must have a unique `id` property, which will be used as the DOM id.
     */
    _addToTopArea(widget, options) {
        var _a;
        if (!widget.id) {
            console.error('Widgets added to app shell must have unique id property.');
            return;
        }
        options = options || {};
        const rank = (_a = options.rank) !== null && _a !== void 0 ? _a : DEFAULT_RANK;
        this._topHandler.addWidget(widget, rank);
        this._onLayoutModified();
        if (this._topHandler.panel.isHidden) {
            this._topHandler.panel.show();
        }
    }
    /**
     * Add a widget to the title content area.
     *
     * #### Notes
     * Widgets must have a unique `id` property, which will be used as the DOM id.
     */
    _addToMenuArea(widget, options) {
        var _a;
        if (!widget.id) {
            console.error('Widgets added to app shell must have unique id property.');
            return;
        }
        options = options || {};
        const rank = (_a = options.rank) !== null && _a !== void 0 ? _a : DEFAULT_RANK;
        this._menuHandler.addWidget(widget, rank);
        this._onLayoutModified();
        if (this._menuHandler.panel.isHidden) {
            this._menuHandler.panel.show();
        }
    }
    /**
     * Add a widget to the header content area.
     *
     * #### Notes
     * Widgets must have a unique `id` property, which will be used as the DOM id.
     */
    _addToHeaderArea(widget, options) {
        if (!widget.id) {
            console.error('Widgets added to app shell must have unique id property.');
            return;
        }
        // Temporary: widgets are added to the panel in order of insertion.
        this._headerPanel.addWidget(widget);
        this._onLayoutModified();
        if (this._headerPanel.isHidden) {
            this._headerPanel.show();
        }
    }
    /**
     * Add a widget to the bottom content area.
     *
     * #### Notes
     * Widgets must have a unique `id` property, which will be used as the DOM id.
     */
    _addToBottomArea(widget, options) {
        if (!widget.id) {
            console.error('Widgets added to app shell must have unique id property.');
            return;
        }
        // Temporary: widgets are added to the panel in order of insertion.
        this._bottomPanel.addWidget(widget);
        this._onLayoutModified();
        if (this._bottomPanel.isHidden) {
            this._bottomPanel.show();
        }
    }
    _addToDownArea(widget, options) {
        if (!widget.id) {
            console.error('Widgets added to app shell must have unique id property.');
            return;
        }
        options = options || {};
        const { title } = widget;
        // Add widget ID to tab so that we can get a handle on the tab's widget
        // (for context menu support)
        title.dataset = { ...title.dataset, id: widget.id };
        if (title.icon instanceof ui_components_lib_index_js_.LabIcon) {
            // bind an appropriate style to the icon
            title.icon = title.icon.bindprops({
                stylesheet: 'mainAreaTab'
            });
        }
        else if (typeof title.icon === 'string' || !title.icon) {
            // add some classes to help with displaying css background imgs
            title.iconClass = (0,ui_components_lib_index_js_.classes)(title.iconClass, 'jp-Icon');
        }
        this._downPanel.addWidget(widget);
        this._onLayoutModified();
        if (this._downPanel.isHidden) {
            this._downPanel.show();
        }
    }
    /*
     * Return the tab bar adjacent to the current TabBar or `null`.
     */
    _adjacentBar(direction) {
        const current = this._currentTabBar();
        if (!current) {
            return null;
        }
        const bars = Array.from(this._dockPanel.tabBars());
        const len = bars.length;
        const index = bars.indexOf(current);
        if (direction === 'previous') {
            return index > 0 ? bars[index - 1] : index === 0 ? bars[len - 1] : null;
        }
        // Otherwise, direction is 'next'.
        return index < len - 1
            ? bars[index + 1]
            : index === len - 1
                ? bars[0]
                : null;
    }
    /*
     * Return the TabBar that has the currently active Widget or null.
     */
    _currentTabBar() {
        const current = this._tracker.currentWidget;
        if (!current) {
            return null;
        }
        const title = current.title;
        const bars = this._dockPanel.tabBars();
        return (0,algorithm_dist_index_es6_js_.find)(bars, bar => bar.titles.indexOf(title) > -1) || null;
    }
    /**
     * Handle a change to the dock area active widget.
     */
    _onActiveChanged(sender, args) {
        if (args.newValue) {
            args.newValue.title.className += ` ${ACTIVE_CLASS}`;
        }
        if (args.oldValue) {
            args.oldValue.title.className = args.oldValue.title.className.replace(ACTIVE_CLASS, '');
        }
        this._activeChanged.emit(args);
    }
    /**
     * Handle a change to the dock area current widget.
     */
    _onCurrentChanged(sender, args) {
        if (args.newValue) {
            args.newValue.title.className += ` ${CURRENT_CLASS}`;
        }
        if (args.oldValue) {
            args.oldValue.title.className = args.oldValue.title.className.replace(CURRENT_CLASS, '');
        }
        this._currentChanged.emit(args);
        this._onLayoutModified();
    }
    /**
     * Handle a change on the down panel widgets
     */
    _onTabPanelChanged() {
        if (this._downPanel.stackedPanel.widgets.length === 0) {
            this._downPanel.hide();
        }
        this._onLayoutModified();
    }
    /**
     * Handle a change to the layout.
     */
    _onLayoutModified() {
        void this._layoutDebouncer.invoke();
    }
}
var shell_Private;
(function (Private) {
    /**
     * A less-than comparison function for side bar rank items.
     */
    function itemCmp(first, second) {
        return first.rank - second.rank;
    }
    Private.itemCmp = itemCmp;
    /**
     * Removes widgets that have been disposed from an area config, mutates area.
     */
    function normalizeAreaConfig(parent, area) {
        if (!area) {
            return;
        }
        if (area.type === 'tab-area') {
            area.widgets = area.widgets.filter(widget => !widget.isDisposed && widget.parent === parent);
            return;
        }
        area.children.forEach(child => {
            normalizeAreaConfig(parent, child);
        });
    }
    Private.normalizeAreaConfig = normalizeAreaConfig;
    /**
     * A class which manages a panel and sorts its widgets by rank.
     */
    class PanelHandler {
        constructor() {
            /**
             * A message hook for child add/remove messages on the main area dock panel.
             */
            this._panelChildHook = (handler, msg) => {
                switch (msg.type) {
                    case 'child-added':
                        {
                            const widget = msg.child;
                            // If we already know about this widget, we're done
                            if (this._items.find(v => v.widget === widget)) {
                                break;
                            }
                            // Otherwise, add to the end by default
                            const rank = this._items[this._items.length - 1].rank;
                            this._items.push({ widget, rank });
                        }
                        break;
                    case 'child-removed':
                        {
                            const widget = msg.child;
                            algorithm_dist_index_es6_js_.ArrayExt.removeFirstWhere(this._items, v => v.widget === widget);
                        }
                        break;
                    default:
                        break;
                }
                return true;
            };
            this._items = new Array();
            this._panel = new widgets_dist_index_es6_js_.Panel();
            messaging_dist_index_es6_js_.MessageLoop.installMessageHook(this._panel, this._panelChildHook);
        }
        /**
         * Get the panel managed by the handler.
         */
        get panel() {
            return this._panel;
        }
        /**
         * Add a widget to the panel.
         *
         * If the widget is already added, it will be moved.
         */
        addWidget(widget, rank) {
            widget.parent = null;
            const item = { widget, rank };
            const index = algorithm_dist_index_es6_js_.ArrayExt.upperBound(this._items, item, Private.itemCmp);
            algorithm_dist_index_es6_js_.ArrayExt.insert(this._items, index, item);
            this._panel.insertWidget(index, widget);
        }
    }
    Private.PanelHandler = PanelHandler;
    /**
     * A class which manages a side bar and related stacked panel.
     */
    class SideBarHandler {
        /**
         * Construct a new side bar handler.
         */
        constructor() {
            this._isHiddenByUser = false;
            this._items = new Array();
            this._updated = new dist_index_es6_js_.Signal(this);
            this._sideBar = new widgets_dist_index_es6_js_.TabBar({
                insertBehavior: 'none',
                removeBehavior: 'none',
                allowDeselect: true,
                orientation: 'vertical'
            });
            this._stackedPanel = new widgets_dist_index_es6_js_.StackedPanel();
            this._sideBar.hide();
            this._stackedPanel.hide();
            this._lastCurrent = null;
            this._sideBar.currentChanged.connect(this._onCurrentChanged, this);
            this._sideBar.tabActivateRequested.connect(this._onTabActivateRequested, this);
            this._stackedPanel.widgetRemoved.connect(this._onWidgetRemoved, this);
        }
        /**
         * Whether the side bar is visible
         */
        get isVisible() {
            return this._sideBar.isVisible;
        }
        /**
         * Get the tab bar managed by the handler.
         */
        get sideBar() {
            return this._sideBar;
        }
        /**
         * Get the stacked panel managed by the handler
         */
        get stackedPanel() {
            return this._stackedPanel;
        }
        /**
         * Signal fires when the stack panel or the sidebar changes
         */
        get updated() {
            return this._updated;
        }
        /**
         * Handles a movement to the handles of a widget
         */
        _onHandleMoved() {
            return this._refreshVisibility();
        }
        /**
         * Handles changes to the expansion status of a widget
         */
        _onExpansionToggle(sender, index) {
            return this._refreshVisibility();
        }
        /**
         * Expand the sidebar.
         *
         * #### Notes
         * This will open the most recently used tab, or the first tab
         * if there is no most recently used.
         */
        expand() {
            const previous = this._lastCurrent || (this._items.length > 0 && this._items[0].widget);
            if (previous) {
                this.activate(previous.id);
            }
        }
        /**
         * Activate a widget residing in the side bar by ID.
         *
         * @param id - The widget's unique ID.
         */
        activate(id) {
            const widget = this._findWidgetByID(id);
            if (widget) {
                this._sideBar.currentTitle = widget.title;
                widget.activate();
            }
        }
        /**
         * Test whether the sidebar has the given widget by id.
         */
        has(id) {
            return this._findWidgetByID(id) !== null;
        }
        /**
         * Collapse the sidebar so no items are expanded.
         */
        collapse() {
            this._sideBar.currentTitle = null;
        }
        /**
         * Add a widget and its title to the stacked panel and side bar.
         *
         * If the widget is already added, it will be moved.
         */
        addWidget(widget, rank) {
            var _a, _b, _c, _d;
            widget.parent = null;
            widget.hide();
            const item = { widget, rank };
            const index = this._findInsertIndex(item);
            algorithm_dist_index_es6_js_.ArrayExt.insert(this._items, index, item);
            this._stackedPanel.insertWidget(index, widget);
            const title = this._sideBar.insertTab(index, widget.title);
            // Store the parent id in the title dataset
            // in order to dispatch click events to the right widget.
            title.dataset = { id: widget.id };
            if (title.icon instanceof ui_components_lib_index_js_.LabIcon) {
                // bind an appropriate style to the icon
                title.icon = title.icon.bindprops({
                    stylesheet: 'sideBar'
                });
            }
            else if (typeof title.icon === 'string' && title.icon != '') {
                // add some classes to help with displaying css background imgs
                title.iconClass = (0,ui_components_lib_index_js_.classes)(title.iconClass, 'jp-Icon', 'jp-Icon-20');
            }
            else if (!title.icon && !title.label) {
                // add a fallback icon if there is no title label nor icon
                title.icon = ui_components_lib_index_js_.tabIcon.bindprops({
                    stylesheet: 'sideBar'
                });
            }
            // @ts-expect-error sometimes widget is an Accordion Panel
            (_b = (_a = widget.content) === null || _a === void 0 ? void 0 : _a.expansionToggled) === null || _b === void 0 ? void 0 : _b.connect(this._onExpansionToggle, this);
            // @ts-expect-error sometimes widget is a SidePanel
            (_d = (_c = widget.content) === null || _c === void 0 ? void 0 : _c.handleMoved) === null || _d === void 0 ? void 0 : _d.connect(this._onHandleMoved, this);
            this._refreshVisibility();
        }
        /**
         * Dehydrate the side bar data.
         */
        dehydrate() {
            const collapsed = this._sideBar.currentTitle === null;
            const widgets = Array.from(this._stackedPanel.widgets);
            const currentWidget = widgets[this._sideBar.currentIndex];
            const widgetStates = {};
            this._stackedPanel.widgets.forEach((w) => {
                if (w.id && w.content instanceof widgets_dist_index_es6_js_.SplitPanel) {
                    widgetStates[w.id] = {
                        sizes: w.content.relativeSizes(),
                        expansionStates: w.content.widgets.map(wi => wi.isVisible)
                    };
                }
            });
            return {
                collapsed,
                currentWidget,
                visible: !this._isHiddenByUser,
                widgets,
                widgetStates
            };
        }
        /**
         * Rehydrate the side bar.
         */
        rehydrate(data) {
            if (data.currentWidget) {
                this.activate(data.currentWidget.id);
            }
            if (data.collapsed) {
                this.collapse();
            }
            if (!data.visible) {
                this.hide();
            }
            if (data.widgetStates) {
                this._stackedPanel.widgets.forEach((w) => {
                    var _a;
                    if (w.id && w.content instanceof widgets_dist_index_es6_js_.SplitPanel) {
                        const state = (_a = data.widgetStates[w.id]) !== null && _a !== void 0 ? _a : {};
                        w.content.widgets.forEach((wi, widx) => {
                            var _a;
                            const expansion = ((_a = state.expansionStates) !== null && _a !== void 0 ? _a : [])[widx];
                            if (typeof expansion === 'boolean' &&
                                w.content instanceof widgets_dist_index_es6_js_.AccordionPanel) {
                                expansion ? w.content.expand(widx) : w.content.collapse(widx);
                            }
                        });
                        if (state.sizes) {
                            w.content.setRelativeSizes(state.sizes);
                        }
                    }
                });
            }
        }
        /**
         * Hide the side bar even if it contains widgets
         */
        hide() {
            this._isHiddenByUser = true;
            this._refreshVisibility();
        }
        /**
         * Show the side bar if it contains widgets
         */
        show() {
            this._isHiddenByUser = false;
            this._refreshVisibility();
        }
        /**
         * Find the insertion index for a rank item.
         */
        _findInsertIndex(item) {
            return algorithm_dist_index_es6_js_.ArrayExt.upperBound(this._items, item, Private.itemCmp);
        }
        /**
         * Find the index of the item with the given widget, or `-1`.
         */
        _findWidgetIndex(widget) {
            return algorithm_dist_index_es6_js_.ArrayExt.findFirstIndex(this._items, i => i.widget === widget);
        }
        /**
         * Find the widget which owns the given title, or `null`.
         */
        _findWidgetByTitle(title) {
            const item = (0,algorithm_dist_index_es6_js_.find)(this._items, value => value.widget.title === title);
            return item ? item.widget : null;
        }
        /**
         * Find the widget with the given id, or `null`.
         */
        _findWidgetByID(id) {
            const item = (0,algorithm_dist_index_es6_js_.find)(this._items, value => value.widget.id === id);
            return item ? item.widget : null;
        }
        /**
         * Refresh the visibility of the side bar and stacked panel.
         */
        _refreshVisibility() {
            this._stackedPanel.setHidden(this._sideBar.currentTitle === null);
            this._sideBar.setHidden(this._isHiddenByUser || this._sideBar.titles.length === 0);
            this._updated.emit();
        }
        /**
         * Handle the `currentChanged` signal from the sidebar.
         */
        _onCurrentChanged(sender, args) {
            const oldWidget = args.previousTitle
                ? this._findWidgetByTitle(args.previousTitle)
                : null;
            const newWidget = args.currentTitle
                ? this._findWidgetByTitle(args.currentTitle)
                : null;
            if (oldWidget) {
                oldWidget.hide();
            }
            if (newWidget) {
                newWidget.show();
            }
            this._lastCurrent = newWidget || oldWidget;
            this._refreshVisibility();
        }
        /**
         * Handle a `tabActivateRequest` signal from the sidebar.
         */
        _onTabActivateRequested(sender, args) {
            args.title.owner.activate();
        }
        /*
         * Handle the `widgetRemoved` signal from the stacked panel.
         */
        _onWidgetRemoved(sender, widget) {
            if (widget === this._lastCurrent) {
                this._lastCurrent = null;
            }
            algorithm_dist_index_es6_js_.ArrayExt.removeAt(this._items, this._findWidgetIndex(widget));
            this._sideBar.removeTab(widget.title);
            this._refreshVisibility();
        }
    }
    Private.SideBarHandler = SideBarHandler;
    class SkipLinkWidget extends widgets_dist_index_es6_js_.Widget {
        /**
         * Construct a new skipLink widget.
         */
        constructor(shell) {
            super();
            this.addClass('jp-skiplink');
            this.id = 'jp-skiplink';
            this._shell = shell;
            this._createSkipLink('Skip to main panel', 'main');
        }
        handleEvent(event) {
            var _a, _b;
            switch (event.type) {
                case 'click':
                    if (event.target instanceof HTMLElement) {
                        this._shell.activateArea((_b = (_a = event.target) === null || _a === void 0 ? void 0 : _a.dataset) === null || _b === void 0 ? void 0 : _b.targetarea);
                    }
                    break;
            }
        }
        /**
         * Handle `after-attach` messages for the widget.
         */
        onAfterAttach(msg) {
            super.onAfterAttach(msg);
            this.node.addEventListener('click', this);
        }
        /**
         * A message handler invoked on a `'before-detach'`
         * message
         */
        onBeforeDetach(msg) {
            this.node.removeEventListener('click', this);
            super.onBeforeDetach(msg);
        }
        _createSkipLink(skipLinkText, area) {
            const skipLink = document.createElement('a');
            skipLink.href = '#';
            skipLink.tabIndex = 0;
            skipLink.text = skipLinkText;
            skipLink.className = 'skip-link';
            skipLink.dataset['targetarea'] = area;
            this.node.appendChild(skipLink);
        }
    }
    Private.SkipLinkWidget = SkipLinkWidget;
    class TitleHandler extends widgets_dist_index_es6_js_.Widget {
        /**
         * Construct a new title handler.
         */
        constructor(shell) {
            super();
            this._selected = false;
            const inputElement = document.createElement('input');
            inputElement.type = 'text';
            this.node.appendChild(inputElement);
            this._shell = shell;
            this.id = 'jp-title-panel-title';
        }
        /**
         * Handle `after-attach` messages for the widget.
         */
        onAfterAttach(msg) {
            super.onAfterAttach(msg);
            this.inputElement.addEventListener('keyup', this);
            this.inputElement.addEventListener('click', this);
            this.inputElement.addEventListener('blur', this);
        }
        /**
         * Handle `before-detach` messages for the widget.
         */
        onBeforeDetach(msg) {
            super.onBeforeDetach(msg);
            this.inputElement.removeEventListener('keyup', this);
            this.inputElement.removeEventListener('click', this);
            this.inputElement.removeEventListener('blur', this);
        }
        handleEvent(event) {
            switch (event.type) {
                case 'keyup':
                    void this._evtKeyUp(event);
                    break;
                case 'click':
                    this._evtClick(event);
                    break;
                case 'blur':
                    this._selected = false;
                    break;
            }
        }
        /**
         * Handle `keyup` events on the handler.
         */
        async _evtKeyUp(event) {
            if (event.key == 'Enter') {
                const widget = this._shell.currentWidget;
                if (widget == null) {
                    return;
                }
                const oldName = widget.title.label;
                const inputElement = this.inputElement;
                const newName = inputElement.value;
                inputElement.blur();
                if (newName !== oldName) {
                    widget.title.label = newName;
                }
                else {
                    inputElement.value = oldName;
                }
            }
        }
        /**
         * Handle `click` events on the handler.
         */
        _evtClick(event) {
            // only handle primary button clicks
            if (event.button !== 0 || this._selected) {
                return;
            }
            const inputElement = this.inputElement;
            event.preventDefault();
            event.stopPropagation();
            this._selected = true;
            const selectEnd = inputElement.value.indexOf('.');
            if (selectEnd === -1) {
                inputElement.select();
            }
            else {
                inputElement.setSelectionRange(0, selectEnd);
            }
        }
        /**
         * The input element containing the parent widget's title.
         */
        get inputElement() {
            return this.node.children[0];
        }
    }
    Private.TitleHandler = TitleHandler;
    class RestorableSplitPanel extends widgets_dist_index_es6_js_.SplitPanel {
        /**
         * Construct a new RestorableSplitPanel.
         */
        constructor(options = {}) {
            super(options);
            this._updated = new dist_index_es6_js_.Signal(this);
        }
        /**
         * A signal emitted when the split panel is updated.
         */
        get updated() {
            return this._updated;
        }
        /**
         * Emit 'updated' signal on 'update' requests.
         */
        onUpdateRequest(msg) {
            super.onUpdateRequest(msg);
            this._updated.emit();
        }
    }
    Private.RestorableSplitPanel = RestorableSplitPanel;
})(shell_Private || (shell_Private = {}));
//# sourceMappingURL=shell.js.map
// EXTERNAL MODULE: ../node_modules/@jupyterlab/application/lib/status.js
var lib_status = __webpack_require__(20389);
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/application/lib/lab.js
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.








/**
 * JupyterLab is the main application class. It is instantiated once and shared.
 */
class JupyterLab extends JupyterFrontEnd {
    /**
     * Construct a new JupyterLab object.
     */
    constructor(options = { shell: new LabShell() }) {
        super({
            ...options,
            shell: options.shell || new LabShell(),
            serviceManager: options.serviceManager ||
                new services_lib_index_js_.ServiceManager({
                    standby: () => {
                        return !this._info.isConnected || 'when-hidden';
                    }
                })
        });
        /**
         * The name of the JupyterLab application.
         */
        this.name = coreutils_lib_index_js_.PageConfig.getOption('appName') || 'JupyterLab';
        /**
         * A namespace/prefix plugins may use to denote their provenance.
         */
        this.namespace = coreutils_lib_index_js_.PageConfig.getOption('appNamespace') || this.name;
        /**
         * A list of all errors encountered when registering plugins.
         *
         * @deprecated This is unused and may be removed in a future version.
         */
        this.registerPluginErrors = [];
        /**
         * The application busy and dirty status signals and flags.
         */
        this.status = new lib_status/* LabStatus */.J(this);
        /**
         * The version of the JupyterLab application.
         */
        this.version = coreutils_lib_index_js_.PageConfig.getOption('appVersion') || 'unknown';
        this._allPluginsActivated = new dist_index_js_.PromiseDelegate();
        // Populate application info.
        this._info = new JupyterLab.Info(options);
        this.restored = this.shell.restored
            .then(async () => {
            const activated = [];
            const deferred = this.activateDeferredPlugins().catch(error => {
                console.error('Error when activating deferred plugins\n:', error);
            });
            activated.push(deferred);
            if (this._info.deferred) {
                const customizedDeferred = Promise.all(this._info.deferred.matches.map(pluginID => this.activatePlugin(pluginID))).catch(error => {
                    console.error('Error when activating customized list of deferred plugins:\n', error);
                });
                activated.push(customizedDeferred);
            }
            Promise.all(activated)
                .then(() => {
                this._allPluginsActivated.resolve();
            })
                .catch(() => undefined);
        })
            .catch(() => undefined);
        // Populate application paths override the defaults if necessary.
        const defaultURLs = JupyterLab.defaultPaths.urls;
        const defaultDirs = JupyterLab.defaultPaths.directories;
        const optionURLs = (options.paths && options.paths.urls) || {};
        const optionDirs = (options.paths && options.paths.directories) || {};
        this._paths = {
            urls: Object.keys(defaultURLs).reduce((acc, key) => {
                if (key in optionURLs) {
                    const value = optionURLs[key];
                    acc[key] = value;
                }
                else {
                    acc[key] = defaultURLs[key];
                }
                return acc;
            }, {}),
            directories: Object.keys(JupyterLab.defaultPaths.directories).reduce((acc, key) => {
                if (key in optionDirs) {
                    const value = optionDirs[key];
                    acc[key] = value;
                }
                else {
                    acc[key] = defaultDirs[key];
                }
                return acc;
            }, {})
        };
        if (this._info.devMode) {
            this.shell.addClass('jp-mod-devMode');
        }
        // Add initial model factory.
        this.docRegistry.addModelFactory(new docregistry_lib_index_js_.Base64ModelFactory());
        if (options.mimeExtensions) {
            for (const plugin of (0,mimerenderers/* createRendermimePlugins */.as)(options.mimeExtensions)) {
                this.registerPlugin(plugin);
            }
        }
    }
    /**
     * The JupyterLab application information dictionary.
     */
    get info() {
        return this._info;
    }
    /**
     * The JupyterLab application paths dictionary.
     */
    get paths() {
        return this._paths;
    }
    /**
     * Promise that resolves when all the plugins are activated, including the deferred.
     */
    get allPluginsActivated() {
        return this._allPluginsActivated.promise;
    }
    /**
     * Register plugins from a plugin module.
     *
     * @param mod - The plugin module to register.
     *
     * @deprecated This is unused and may be removed in a future version.
     */
    registerPluginModule(mod) {
        let data = mod.default;
        // Handle commonjs exports.
        if (!mod.hasOwnProperty('__esModule')) {
            data = mod;
        }
        if (!Array.isArray(data)) {
            data = [data];
        }
        data.forEach(item => {
            try {
                this.registerPlugin(item);
            }
            catch (error) {
                this.registerPluginErrors.push(error);
            }
        });
    }
    /**
     * Register the plugins from multiple plugin modules.
     *
     * @param mods - The plugin modules to register.
     *
     * @deprecated This is unused and may be removed in a future version.
     */
    registerPluginModules(mods) {
        mods.forEach(mod => {
            this.registerPluginModule(mod);
        });
    }
    /**
     * Override keydown handling to prevent command shortcuts from preventing user input.
     *
     * This introduces a slight delay to the command invocation, but no delay to user input.
     */
    evtKeydown(keyDownEvent) {
        const permissionToExecute = new dist_index_js_.PromiseDelegate();
        // Hold the execution of any keybinding until we know if this event would cause text insertion
        this.commands.holdKeyBindingExecution(keyDownEvent, permissionToExecute.promise);
        // Process the key immediately to invoke the prevent default handlers as needed
        this.commands.processKeydownEvent(keyDownEvent);
        // If we do not know the target, we cannot check if input would be inserted
        // as there is no target to attach the `beforeinput` event listener; in that
        // case we just permit execution immediately (this may happen for programmatic
        // uses of keydown)
        const target = keyDownEvent.target;
        if (!target) {
            return permissionToExecute.resolve(true);
        }
        let onBeforeInput = null;
        let onBeforeKeyUp = null;
        const disconnectListeners = () => {
            if (onBeforeInput) {
                target.removeEventListener('beforeinput', onBeforeInput);
            }
            if (onBeforeKeyUp) {
                target.removeEventListener('keyup', onBeforeKeyUp);
            }
        };
        // Permit the execution conditionally, depending on whether the event would lead to text insertion
        const causesInputPromise = Promise.race([
            new Promise(resolve => {
                onBeforeInput = (inputEvent) => {
                    switch (inputEvent.inputType) {
                        case 'historyUndo':
                        case 'historyRedo': {
                            if (inputEvent.target instanceof Element &&
                                inputEvent.target.closest('[data-jp-undoer]')) {
                                // Allow to use custom undo/redo bindings on `jpUndoer`s
                                inputEvent.preventDefault();
                                disconnectListeners();
                                return resolve(false);
                            }
                            break;
                        }
                        case 'insertLineBreak': {
                            if (inputEvent.target instanceof Element &&
                                inputEvent.target.closest('.jp-Cell')) {
                                // Allow to override the default action of Shift + Enter on cells as this is used for cell execution
                                inputEvent.preventDefault();
                                disconnectListeners();
                                return resolve(false);
                            }
                            break;
                        }
                    }
                    disconnectListeners();
                    return resolve(true);
                };
                target.addEventListener('beforeinput', onBeforeInput, { once: true });
            }),
            new Promise(resolve => {
                onBeforeKeyUp = (keyUpEvent) => {
                    if (keyUpEvent.code === keyDownEvent.code) {
                        disconnectListeners();
                        return resolve(false);
                    }
                };
                target.addEventListener('keyup', onBeforeKeyUp, { once: true });
            }),
            new Promise(resolve => {
                setTimeout(() => {
                    disconnectListeners();
                    return resolve(false);
                }, lab_Private.INPUT_GUARD_TIMEOUT);
            })
        ]);
        causesInputPromise
            .then(willCauseInput => {
            permissionToExecute.resolve(!willCauseInput);
        })
            .catch(console.warn);
    }
}
/**
 * The namespace for `JupyterLab` class statics.
 */
(function (JupyterLab) {
    /**
     * The application info token.
     */
    JupyterLab.IInfo = new dist_index_js_.Token('@jupyterlab/application:IInfo', 'A service providing metadata about the current application, including disabled extensions and whether dev mode is enabled.');
    /**
     * The information about a JupyterLab application.
     */
    class Info {
        constructor({ connectionStatus, ...options } = {}) {
            var _a, _b, _c, _d, _e, _f, _g;
            this._connectionStatus = connectionStatus !== null && connectionStatus !== void 0 ? connectionStatus : new services_lib_index_js_.ConnectionStatus();
            this._availablePlugins =
                (_a = options.availablePlugins) !== null && _a !== void 0 ? _a : JupyterLab.defaultInfo.availablePlugins;
            this._devMode = (_b = options.devMode) !== null && _b !== void 0 ? _b : JupyterLab.defaultInfo.devMode;
            this._deferred = JSON.parse(JSON.stringify((_c = options.deferred) !== null && _c !== void 0 ? _c : JupyterLab.defaultInfo.deferred));
            this._disabled = JSON.parse(JSON.stringify((_d = options.disabled) !== null && _d !== void 0 ? _d : JupyterLab.defaultInfo.disabled));
            this._filesCached =
                (_e = options.filesCached) !== null && _e !== void 0 ? _e : JupyterLab.defaultInfo.filesCached;
            this._mimeExtensions = JSON.parse(JSON.stringify((_f = options.mimeExtensions) !== null && _f !== void 0 ? _f : JupyterLab.defaultInfo.mimeExtensions));
            this.isConnected =
                (_g = options.isConnected) !== null && _g !== void 0 ? _g : JupyterLab.defaultInfo.isConnected;
        }
        /**
         * The information about available plugins.
         */
        get availablePlugins() {
            return this._availablePlugins;
        }
        /**
         * Whether the application is in dev mode.
         */
        get devMode() {
            return this._devMode;
        }
        /**
         * The collection of deferred extension patterns and matched extensions.
         */
        get deferred() {
            return this._deferred;
        }
        /**
         * The collection of disabled extension patterns and matched extensions.
         */
        get disabled() {
            return this._disabled;
        }
        /**
         * Whether files are cached on the server.
         */
        get filesCached() {
            return this._filesCached;
        }
        /**
         * Every periodic network polling should be paused while this is set
         * to `false`. Extensions should use this value to decide whether to proceed
         * with the polling.
         * The extensions may also set this value to `false` if there is no need to
         * fetch anything from the server backend basing on some conditions
         * (e.g. when an error message dialog is displayed).
         * At the same time, the extensions are responsible for setting this value
         * back to `true`.
         */
        get isConnected() {
            return this._connectionStatus.isConnected;
        }
        set isConnected(v) {
            this._connectionStatus.isConnected = v;
        }
        /**
         * The mime renderer extensions.
         */
        get mimeExtensions() {
            return this._mimeExtensions;
        }
    }
    JupyterLab.Info = Info;
    /**
     * The default JupyterLab application info.
     */
    JupyterLab.defaultInfo = {
        devMode: coreutils_lib_index_js_.PageConfig.getOption('devMode').toLowerCase() === 'true',
        deferred: { patterns: [], matches: [] },
        disabled: { patterns: [], matches: [] },
        mimeExtensions: [],
        availablePlugins: [],
        filesCached: coreutils_lib_index_js_.PageConfig.getOption('cacheFiles').toLowerCase() === 'true',
        isConnected: true
    };
    /**
     * The default JupyterLab application paths.
     */
    JupyterLab.defaultPaths = {
        urls: {
            base: coreutils_lib_index_js_.PageConfig.getOption('baseUrl'),
            notFound: coreutils_lib_index_js_.PageConfig.getOption('notFoundUrl'),
            app: coreutils_lib_index_js_.PageConfig.getOption('appUrl'),
            doc: coreutils_lib_index_js_.PageConfig.getOption('docUrl'),
            static: coreutils_lib_index_js_.PageConfig.getOption('staticUrl'),
            settings: coreutils_lib_index_js_.PageConfig.getOption('settingsUrl'),
            themes: coreutils_lib_index_js_.PageConfig.getOption('themesUrl'),
            translations: coreutils_lib_index_js_.PageConfig.getOption('translationsApiUrl'),
            hubHost: coreutils_lib_index_js_.PageConfig.getOption('hubHost') || undefined,
            hubPrefix: coreutils_lib_index_js_.PageConfig.getOption('hubPrefix') || undefined,
            hubUser: coreutils_lib_index_js_.PageConfig.getOption('hubUser') || undefined,
            hubServerName: coreutils_lib_index_js_.PageConfig.getOption('hubServerName') || undefined
        },
        directories: {
            appSettings: coreutils_lib_index_js_.PageConfig.getOption('appSettingsDir'),
            schemas: coreutils_lib_index_js_.PageConfig.getOption('schemasDir'),
            static: coreutils_lib_index_js_.PageConfig.getOption('staticDir'),
            templates: coreutils_lib_index_js_.PageConfig.getOption('templatesDir'),
            themes: coreutils_lib_index_js_.PageConfig.getOption('themesDir'),
            userSettings: coreutils_lib_index_js_.PageConfig.getOption('userSettingsDir'),
            serverRoot: coreutils_lib_index_js_.PageConfig.getOption('serverRoot'),
            workspaces: coreutils_lib_index_js_.PageConfig.getOption('workspacesDir')
        }
    };
})(JupyterLab || (JupyterLab = {}));
/**
 * A namespace for module-private functionality.
 */
var lab_Private;
(function (Private) {
    /**
     * The delay for invoking a command introduced by user input guard.
     * Decreasing this value may lead to commands incorrectly triggering
     * on user input. Increasing this value will lead to longer delay for
     * command invocation. Note that user input is never delayed.
     *
     * The value represents the number in milliseconds.
     */
    Private.INPUT_GUARD_TIMEOUT = 10;
})(lab_Private || (lab_Private = {}));
//# sourceMappingURL=lab.js.map
// EXTERNAL MODULE: ../node_modules/@jupyterlab/application/lib/layoutrestorer.js
var layoutrestorer = __webpack_require__(67863);
// EXTERNAL MODULE: consume shared module (default) @lumino/disposable@~2.1.4 (singleton) (fallback: ../node_modules/@lumino/disposable/dist/index.es6.js)
var disposable_dist_index_es6_js_ = __webpack_require__(38302);
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/application/lib/router.js
/* -----------------------------------------------------------------------------
| Copyright (c) Jupyter Development Team.
| Distributed under the terms of the Modified BSD License.
|----------------------------------------------------------------------------*/




/**
 * A static class that routes URLs within the application.
 */
class Router {
    /**
     * Create a URL router.
     */
    constructor(options) {
        /**
         * If a matching rule's command resolves with the `stop` token during routing,
         * no further matches will execute.
         */
        this.stop = new dist_index_js_.Token('@jupyterlab/application:Router#stop');
        this._routed = new dist_index_es6_js_.Signal(this);
        this._rules = new Map();
        this.base = options.base;
        this.commands = options.commands;
    }
    /**
     * Returns the parsed current URL of the application.
     */
    get current() {
        var _a, _b;
        const { base } = this;
        const parsed = coreutils_lib_index_js_.URLExt.parse(window.location.href);
        const { search, hash } = parsed;
        const path = (_b = (_a = parsed.pathname) === null || _a === void 0 ? void 0 : _a.replace(base, '/')) !== null && _b !== void 0 ? _b : '';
        const request = path + search + hash;
        return { hash, path, request, search };
    }
    /**
     * A signal emitted when the router routes a route.
     */
    get routed() {
        return this._routed;
    }
    /**
     * Navigate to a new path within the application.
     *
     * @param path - The new path or empty string if redirecting to root.
     *
     * @param options - The navigation options.
     */
    navigate(path, options = {}) {
        const { base } = this;
        const { history } = window;
        const { hard } = options;
        const old = document.location.href;
        const url = path && path.indexOf(base) === 0 ? path : coreutils_lib_index_js_.URLExt.join(base, path);
        if (url === old) {
            return hard ? this.reload() : undefined;
        }
        history.pushState({}, '', url);
        if (hard) {
            return this.reload();
        }
        if (!options.skipRouting) {
            // Because a `route()` call may still be in the stack after having received
            // a `stop` token, wait for the next stack frame before calling `route()`.
            requestAnimationFrame(() => {
                void this.route();
            });
        }
    }
    /**
     * Register to route a path pattern to a command.
     *
     * @param options - The route registration options.
     *
     * @returns A disposable that removes the registered rule from the router.
     */
    register(options) {
        var _a;
        const { command, pattern } = options;
        const rank = (_a = options.rank) !== null && _a !== void 0 ? _a : 100;
        const rules = this._rules;
        rules.set(pattern, { command, rank });
        return new disposable_dist_index_es6_js_.DisposableDelegate(() => {
            rules.delete(pattern);
        });
    }
    /**
     * Cause a hard reload of the document.
     */
    reload() {
        window.location.reload();
    }
    /**
     * Route a specific path to an action.
     *
     * #### Notes
     * If a pattern is matched, its command will be invoked with arguments that
     * match the `IRouter.ILocation` interface.
     */
    route() {
        const { commands, current, stop } = this;
        const { request } = current;
        const routed = this._routed;
        const rules = this._rules;
        const matches = [];
        // Collect all rules that match the URL.
        rules.forEach((rule, pattern) => {
            if (request === null || request === void 0 ? void 0 : request.match(pattern)) {
                matches.push(rule);
            }
        });
        // Order the matching rules by rank and enqueue them.
        const queue = matches.sort((a, b) => b.rank - a.rank);
        const done = new dist_index_js_.PromiseDelegate();
        // Process each enqueued command sequentially and short-circuit if a promise
        // resolves with the `stop` token.
        const next = async () => {
            if (!queue.length) {
                routed.emit(current);
                done.resolve(undefined);
                return;
            }
            const { command } = queue.pop();
            try {
                const request = this.current.request;
                const result = await commands.execute(command, current);
                if (result === stop) {
                    queue.length = 0;
                    console.debug(`Routing ${request} was short-circuited by ${command}`);
                }
            }
            catch (reason) {
                console.warn(`Routing ${request} to ${command} failed`, reason);
            }
            void next();
        };
        void next();
        return done.promise;
    }
}
//# sourceMappingURL=router.js.map
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/application/lib/tokens.js
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.

/**
 * A token for which a plugin can provide to respond to connection failures
 * to the application server.
 */
const IConnectionLost = new dist_index_js_.Token('@jupyterlab/application:IConnectionLost', `A service for invoking the dialog shown
  when JupyterLab has lost its connection to the server. Use this if, for some reason,
  you want to bring up the "connection lost" dialog under new circumstances.`);
/**
 * The application status token.
 */
const ILabStatus = new dist_index_js_.Token('@jupyterlab/application:ILabStatus', `A service for interacting with the application busy/dirty
  status. Use this if you want to set the application "busy" favicon, or to set
  the application "dirty" status, which asks the user for confirmation before leaving the application page.`);
/**
 * The URL Router token.
 */
const IRouter = new dist_index_js_.Token('@jupyterlab/application:IRouter', 'The URL router used by the application. Use this to add custom URL-routing for your extension (e.g., to invoke a command if the user navigates to a sub-path).');
//# sourceMappingURL=tokens.js.map
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/application/lib/treepathupdater.js
/* -----------------------------------------------------------------------------
| Copyright (c) Jupyter Development Team.
| Distributed under the terms of the Modified BSD License.
|----------------------------------------------------------------------------*/

/**
 * The tree path updater token.
 */
const ITreePathUpdater = new dist_index_js_.Token('@jupyterlab/application:ITreePathUpdater', 'A service to update the tree path.');
//# sourceMappingURL=treepathupdater.js.map
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/application/lib/utils.js
/*
 * Copyright (c) Jupyter Development Team.
 * Distributed under the terms of the Modified BSD License.
 */


/**
 * Add a semantic commands to the application and take care
 * of setting up the command changed signal.
 *
 * @param options Semantic command options
 */
function addSemanticCommand(options) {
    const { id, commands, shell, semanticCommands, default: defaultValues, overrides, trans } = options;
    commands.addCommand(id, {
        ...createSemanticCommand({ commands, shell }, semanticCommands, defaultValues !== null && defaultValues !== void 0 ? defaultValues : {}, trans !== null && trans !== void 0 ? trans : lib_index_js_.nullTranslator.load('jupyterlab')),
        ...overrides
    });
    const commandList = Array.isArray(semanticCommands)
        ? semanticCommands
        : [semanticCommands];
    const onCommandChanged = (commands, args) => {
        if (args.id) {
            if (args.id === id && args.type === 'removed') {
                commands.commandChanged.disconnect(onCommandChanged);
            }
            else {
                const commandIds = commandList.reduce((agg, cmd) => agg.concat(cmd.ids), []);
                if (commandIds.includes(args.id)) {
                    switch (args.type) {
                        case 'changed':
                        case 'many-changed':
                            commands.notifyCommandChanged(id);
                            break;
                        case 'removed':
                            for (const cmd of commandList) {
                                cmd.remove(args.id);
                            }
                            break;
                    }
                }
            }
        }
    };
    commands.commandChanged.connect(onCommandChanged);
}
/**
 * Create the command options from the given semantic commands list
 * and the given default values.
 *
 * @param app Jupyter Application
 * @param semanticCommands Single semantic command  or a list of commands
 * @param defaultValues Default values
 * @param trans Translation bundle
 * @returns Command options
 *
 * @deprecated Please use {@link addSemanticCommand}. This function will
 * be removed of the public API in JupyterLab 5.
 */
function createSemanticCommand(app, semanticCommands, defaultValues, trans) {
    const { commands, shell } = app;
    const commandList = Array.isArray(semanticCommands)
        ? semanticCommands
        : [semanticCommands];
    return {
        label: concatenateTexts('label'),
        caption: concatenateTexts('caption'),
        isEnabled: () => {
            var _a;
            const isEnabled = reduceAttribute('isEnabled');
            return ((isEnabled.length > 0 &&
                !isEnabled.some(enabled => enabled === false)) ||
                ((_a = defaultValues.isEnabled) !== null && _a !== void 0 ? _a : false));
        },
        isToggled: () => {
            var _a;
            const isToggled = reduceAttribute('isToggled');
            return (isToggled.some(enabled => enabled === true) ||
                ((_a = defaultValues.isToggled) !== null && _a !== void 0 ? _a : false));
        },
        isVisible: () => {
            var _a;
            const isVisible = reduceAttribute('isVisible');
            return ((isVisible.length > 0 &&
                !isVisible.some(visible => visible === false)) ||
                ((_a = defaultValues.isVisible) !== null && _a !== void 0 ? _a : true));
        },
        execute: async () => {
            const widget = shell.currentWidget;
            const commandIds = commandList.map(cmd => widget !== null ? cmd.getActiveCommandId(widget) : null);
            const toExecute = commandIds.filter(commandId => commandId !== null && commands.isEnabled(commandId));
            let result = null;
            if (toExecute.length > 0) {
                for (const commandId of toExecute) {
                    const args = { [index_js_.SemanticCommand.WIDGET]: widget.id };
                    result = await commands.execute(commandId, args);
                    if (typeof result === 'boolean' && result === false) {
                        // If a command returns a boolean, assume it is the execution success status
                        // So break if it is false.
                        break;
                    }
                }
            }
            else if (defaultValues.execute) {
                result = await commands.execute(defaultValues.execute);
            }
            return result;
        }
    };
    function reduceAttribute(attribute) {
        const widget = shell.currentWidget;
        const commandIds = commandList.map(cmd => widget !== null ? cmd.getActiveCommandId(widget) : null);
        const attributes = commandIds
            .filter(commandId => commandId !== null)
            .map(commandId => commands[attribute](commandId));
        return attributes;
    }
    function concatenateTexts(attribute) {
        return () => {
            var _a;
            const texts = reduceAttribute(attribute).map((text, textIndex) => attribute == 'caption' && textIndex > 0
                ? text.toLocaleLowerCase()
                : text);
            switch (texts.length) {
                case 0:
                    return (_a = defaultValues[attribute]) !== null && _a !== void 0 ? _a : '';
                case 1:
                    return texts[0];
                default: {
                    const hasEllipsis = texts.some(l => /…$/.test(l));
                    const main = texts
                        .slice(undefined, -1)
                        .map(l => l.replace(/…$/, ''))
                        .join(', ');
                    const end = texts.slice(-1)[0].replace(/…$/, '') + (hasEllipsis ? '…' : '');
                    return trans.__('%1 and %2', main, end);
                }
            }
        };
    }
}
//# sourceMappingURL=utils.js.map
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/application/lib/index.js
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
/**
 * @packageDocumentation
 * @module application
 */











//# sourceMappingURL=index.js.map

/***/ }),

/***/ 67863:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   L: () => (/* binding */ ILayoutRestorer),
/* harmony export */   c: () => (/* binding */ LayoutRestorer)
/* harmony export */ });
/* harmony import */ var _lumino_coreutils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(5406);
/* harmony import */ var _lumino_coreutils__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_lumino_coreutils__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _lumino_properties__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(65482);
/* harmony import */ var _lumino_properties__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_lumino_properties__WEBPACK_IMPORTED_MODULE_1__);
/* -----------------------------------------------------------------------------
| Copyright (c) Jupyter Development Team.
| Distributed under the terms of the Modified BSD License.
|----------------------------------------------------------------------------*/


/**
 * The layout restorer token.
 */
const ILayoutRestorer = new _lumino_coreutils__WEBPACK_IMPORTED_MODULE_0__.Token('@jupyterlab/application:ILayoutRestorer', 'A service providing application layout restoration functionality. Use this to have your activities restored across page loads.');
/**
 * The data connector key for restorer data.
 */
const KEY = 'layout-restorer:data';
/**
 * The default implementation of a layout restorer.
 *
 * #### Notes
 * The lifecycle for state restoration is subtle. The sequence of events is:
 *
 * 1. The layout restorer plugin is instantiated and makes a `fetch` call to
 *    the data connector that stores the layout restoration data. The `fetch`
 *    call returns a promise that resolves in step 6, below.
 *
 * 2. Other plugins that care about state restoration require the layout
 *    restorer as a dependency.
 *
 * 3. As each load-time plugin initializes (which happens before the front-end
 *    application has `started`), it instructs the layout restorer whether
 *    the restorer ought to `restore` its widgets by passing in its widget
 *    tracker.
 *    Alternatively, a plugin that does not require its own widget tracker
 *    (because perhaps it only creates a single widget, like a command palette),
 *    can simply `add` its widget along with a persistent unique name to the
 *    layout restorer so that its layout state can be restored when the lab
 *    application restores.
 *
 * 4. After all the load-time plugins have finished initializing, the front-end
 *    application `started` promise will resolve. This is the `first`
 *    promise that the layout restorer waits for. By this point, all of the
 *    plugins that care about restoration will have instructed the layout
 *    restorer to `restore` their widget trackers.
 *
 * 5. The layout restorer will then instruct each plugin's widget tracker
 *    to restore its state and reinstantiate whichever widgets it wants. The
 *    tracker returns a promise to the layout restorer that resolves when it
 *    has completed restoring the tracked widgets it cares about.
 *
 * 6. As each widget tracker finishes restoring the widget instances it cares
 *    about, it resolves the promise that was returned to the layout restorer
 *    (in step 5). After all of the promises that the restorer is awaiting have
 *    settled, the restorer then resolves the outstanding `fetch` promise
 *    (from step 1) and hands off a layout state object to the application
 *    shell's `restoreLayout` method for restoration.
 *
 * 7. Once the application shell has finished restoring the layout, the
 *    JupyterLab application's `restored` promise is resolved.
 *
 * Of particular note are steps 5 and 6: since data restoration of plugins
 * is accomplished by executing commands, the command that is used to restore
 * the data of each plugin must return a promise that only resolves when the
 * widget has been created and added to the plugin's widget tracker.
 */
class LayoutRestorer {
    /**
     * Create a layout restorer.
     */
    constructor(options) {
        this._deferred = new Array();
        this._deferredMainArea = null;
        this._firstDone = false;
        this._promisesDone = false;
        this._promises = [];
        this._restored = new _lumino_coreutils__WEBPACK_IMPORTED_MODULE_0__.PromiseDelegate();
        this._trackers = new Set();
        this._widgets = new Map();
        this._mode = 'multiple-document';
        this._connector = options.connector;
        this._first = options.first;
        this._registry = options.registry;
        if (options.mode) {
            this._mode = options.mode;
        }
        void this._first
            .then(() => {
            this._firstDone = true;
        })
            .then(() => Promise.all(this._promises))
            .then(() => {
            this._promisesDone = true;
            // Release the tracker set.
            this._trackers.clear();
        })
            .then(() => {
            this._restored.resolve(void 0);
        });
    }
    /**
     * Whether full layout restoration is deferred and is currently incomplete.
     *
     * #### Notes
     * This flag is useful for tracking when the application has started in
     * 'single-document' mode and the main area has not yet been restored.
     */
    get isDeferred() {
        return this._deferred.length > 0;
    }
    /**
     * A promise resolved when the layout restorer is ready to receive signals.
     */
    get restored() {
        return this._restored.promise;
    }
    /**
     * Add a widget to be tracked by the layout restorer.
     */
    add(widget, name) {
        Private.nameProperty.set(widget, name);
        this._widgets.set(name, widget);
        widget.disposed.connect(this._onWidgetDisposed, this);
    }
    /**
     * Fetch the layout state for the application.
     *
     * #### Notes
     * Fetching the layout relies on all widget restoration to be complete, so
     * calls to `fetch` are guaranteed to return after restoration is complete.
     */
    async fetch() {
        var _a;
        const blank = {
            fresh: true,
            mainArea: null,
            downArea: null,
            leftArea: null,
            rightArea: null,
            topArea: null,
            relativeSizes: null
        };
        const layout = this._connector.fetch(KEY);
        try {
            const [data] = await Promise.all([layout, this.restored]);
            if (!data) {
                return blank;
            }
            const { main, down, left, right, relativeSizes, top } = data;
            // If any data exists, then this is not a fresh session.
            const fresh = false;
            // Rehydrate main area.
            let mainArea = null;
            if (this._mode === 'multiple-document') {
                mainArea = this._rehydrateMainArea(main);
            }
            else {
                this._deferredMainArea = main;
            }
            // Rehydrate down area.
            const downArea = this._rehydrateDownArea(down);
            // Rehydrate left area.
            const leftArea = this._rehydrateSideArea(left);
            // Rehydrate right area.
            const rightArea = this._rehydrateSideArea(right);
            return {
                fresh,
                mainArea,
                downArea,
                leftArea,
                rightArea,
                relativeSizes: relativeSizes || null,
                topArea: (_a = top) !== null && _a !== void 0 ? _a : null
            };
        }
        catch (error) {
            return blank;
        }
    }
    /**
     * Restore the widgets of a particular widget tracker.
     *
     * @param tracker - The widget tracker whose widgets will be restored.
     *
     * @param options - The restoration options.
     */
    async restore(tracker, options) {
        if (this._firstDone) {
            throw new Error('restore() must be called before `first` has resolved.');
        }
        const { namespace } = tracker;
        if (this._trackers.has(namespace)) {
            throw new Error(`The tracker "${namespace}" is already restored.`);
        }
        const { args, command, name, when } = options;
        // Add the tracker to the private trackers collection.
        this._trackers.add(namespace);
        // Whenever a new widget is added to the tracker, record its name.
        tracker.widgetAdded.connect((_, widget) => {
            const widgetName = name(widget);
            if (widgetName) {
                this.add(widget, `${namespace}:${widgetName}`);
            }
        }, this);
        // Whenever a widget is updated, get its new name.
        tracker.widgetUpdated.connect((_, widget) => {
            const widgetName = name(widget);
            if (widgetName) {
                const name = `${namespace}:${widgetName}`;
                Private.nameProperty.set(widget, name);
                this._widgets.set(name, widget);
            }
        });
        const first = this._first;
        if (this._mode == 'multiple-document') {
            const promise = tracker
                .restore({
                args: args || (() => _lumino_coreutils__WEBPACK_IMPORTED_MODULE_0__.JSONExt.emptyObject),
                command,
                connector: this._connector,
                name,
                registry: this._registry,
                when: when ? [first].concat(when) : first
            })
                .catch(error => {
                console.error(error);
            });
            this._promises.push(promise);
            return promise;
        }
        tracker.defer({
            args: args || (() => _lumino_coreutils__WEBPACK_IMPORTED_MODULE_0__.JSONExt.emptyObject),
            command,
            connector: this._connector,
            name,
            registry: this._registry,
            when: when ? [first].concat(when) : first
        });
        this._deferred.push(tracker);
    }
    /**
     * Restore the application layout if its restoration has been deferred.
     *
     * @returns - the rehydrated main area.
     */
    async restoreDeferred() {
        if (!this.isDeferred) {
            return null;
        }
        // Empty the deferred list and wait for all trackers to restore.
        const wait = Promise.resolve();
        const promises = this._deferred.map(t => wait.then(() => t.restore()));
        this._deferred.length = 0;
        await Promise.all(promises);
        // Rehydrate the main area layout.
        return this._rehydrateMainArea(this._deferredMainArea);
    }
    /**
     * Save the layout state for the application.
     */
    save(layout) {
        var _a;
        // If there are promises that are unresolved, bail.
        if (!this._promisesDone) {
            const warning = 'save() was called prematurely.';
            console.warn(warning);
            return Promise.reject(warning);
        }
        const dehydrated = {};
        // Save the cached main area layout if restoration is deferred.
        dehydrated.main = this.isDeferred
            ? this._deferredMainArea
            : this._dehydrateMainArea(layout.mainArea);
        // Update only the current widget in the db when restoration is deferred.
        // Useful for providing the tab title in doc mode.
        if (this.isDeferred) {
            const currentWidget = (_a = layout.mainArea) === null || _a === void 0 ? void 0 : _a.currentWidget;
            if (currentWidget) {
                const widgetName = Private.nameProperty.get(currentWidget);
                dehydrated.main = {
                    ...dehydrated.main,
                    current: widgetName || undefined
                };
            }
        }
        dehydrated.down = this._dehydrateDownArea(layout.downArea);
        dehydrated.left = this._dehydrateSideArea(layout.leftArea);
        dehydrated.right = this._dehydrateSideArea(layout.rightArea);
        dehydrated.relativeSizes = layout.relativeSizes;
        dehydrated.top = { ...layout.topArea };
        return this._connector.save(KEY, dehydrated);
    }
    /**
     * Dehydrate a main area description into a serializable object.
     */
    _dehydrateMainArea(area) {
        if (!area) {
            return null;
        }
        return Private.serializeMain(area);
    }
    /**
     * Rehydrate a serialized main area description object.
     *
     * #### Notes
     * This function consumes data that can become corrupted, so it uses type
     * coercion to guarantee the dehydrated object is safely processed.
     */
    _rehydrateMainArea(area) {
        if (!area) {
            return null;
        }
        return Private.deserializeMain(area, this._widgets);
    }
    /**
     * Dehydrate a down area description into a serializable object.
     */
    _dehydrateDownArea(area) {
        if (!area) {
            return null;
        }
        const dehydrated = {
            size: area.size
        };
        if (area.currentWidget) {
            const current = Private.nameProperty.get(area.currentWidget);
            if (current) {
                dehydrated.current = current;
            }
        }
        if (area.widgets) {
            dehydrated.widgets = area.widgets
                .map(widget => Private.nameProperty.get(widget))
                .filter(name => !!name);
        }
        return dehydrated;
    }
    /**
     * Rehydrate a serialized side area description object.
     *
     * #### Notes
     * This function consumes data that can become corrupted, so it uses type
     * coercion to guarantee the dehydrated object is safely processed.
     */
    _rehydrateDownArea(area) {
        var _a;
        if (!area) {
            return { currentWidget: null, size: 0.0, widgets: null };
        }
        const internal = this._widgets;
        const currentWidget = area.current && internal.has(`${area.current}`)
            ? internal.get(`${area.current}`)
            : null;
        const widgets = !Array.isArray(area.widgets)
            ? null
            : area.widgets
                .map(name => internal.has(`${name}`) ? internal.get(`${name}`) : null)
                .filter(widget => !!widget);
        return {
            currentWidget: currentWidget,
            size: (_a = area.size) !== null && _a !== void 0 ? _a : 0.0,
            widgets: widgets
        };
    }
    /**
     * Dehydrate a side area description into a serializable object.
     */
    _dehydrateSideArea(area) {
        if (!area) {
            return null;
        }
        const dehydrated = {
            collapsed: area.collapsed,
            visible: area.visible
        };
        if (area.currentWidget) {
            const current = Private.nameProperty.get(area.currentWidget);
            if (current) {
                dehydrated.current = current;
            }
        }
        if (area.widgets) {
            dehydrated.widgets = area.widgets
                .map(widget => Private.nameProperty.get(widget))
                .filter(name => !!name);
        }
        if (area.widgetStates) {
            dehydrated.widgetStates = area.widgetStates;
        }
        return dehydrated;
    }
    /**
     * Rehydrate a serialized side area description object.
     *
     * #### Notes
     * This function consumes data that can become corrupted, so it uses type
     * coercion to guarantee the dehydrated object is safely processed.
     */
    _rehydrateSideArea(area) {
        var _a, _b;
        if (!area) {
            return {
                collapsed: true,
                currentWidget: null,
                visible: true,
                widgets: null,
                widgetStates: {
                    ['null']: {
                        sizes: null,
                        expansionStates: null
                    }
                }
            };
        }
        const internal = this._widgets;
        const collapsed = (_a = area.collapsed) !== null && _a !== void 0 ? _a : false;
        const currentWidget = area.current && internal.has(`${area.current}`)
            ? internal.get(`${area.current}`)
            : null;
        const widgets = !Array.isArray(area.widgets)
            ? null
            : area.widgets
                .map(name => internal.has(`${name}`) ? internal.get(`${name}`) : null)
                .filter(widget => !!widget);
        const widgetStates = area.widgetStates;
        return {
            collapsed,
            currentWidget: currentWidget,
            widgets: widgets,
            visible: (_b = area.visible) !== null && _b !== void 0 ? _b : true,
            widgetStates: widgetStates
        };
    }
    /**
     * Handle a widget disposal.
     */
    _onWidgetDisposed(widget) {
        const name = Private.nameProperty.get(widget);
        this._widgets.delete(name);
    }
}
/*
 * A namespace for private data.
 */
var Private;
(function (Private) {
    /**
     * An attached property for a widget's ID in the serialized restore data.
     */
    Private.nameProperty = new _lumino_properties__WEBPACK_IMPORTED_MODULE_1__.AttachedProperty({
        name: 'name',
        create: owner => ''
    });
    /**
     * Serialize individual areas within the main area.
     */
    function serializeArea(area) {
        if (!area || !area.type) {
            return null;
        }
        if (area.type === 'tab-area') {
            return {
                type: 'tab-area',
                currentIndex: area.currentIndex,
                widgets: area.widgets
                    .map(widget => Private.nameProperty.get(widget))
                    .filter(name => !!name)
            };
        }
        return {
            type: 'split-area',
            orientation: area.orientation,
            sizes: area.sizes,
            children: area.children
                .map(serializeArea)
                .filter(area => !!area)
        };
    }
    /**
     * Return a dehydrated, serializable version of the main dock panel.
     */
    function serializeMain(area) {
        const dehydrated = {
            dock: (area && area.dock && serializeArea(area.dock.main)) || null
        };
        if (area) {
            if (area.currentWidget) {
                const current = Private.nameProperty.get(area.currentWidget);
                if (current) {
                    dehydrated.current = current;
                }
            }
        }
        return dehydrated;
    }
    Private.serializeMain = serializeMain;
    /**
     * Deserialize individual areas within the main area.
     *
     * #### Notes
     * Because this data comes from a potentially unreliable foreign source, it is
     * typed as a `JSONObject`; but the actual expected type is:
     * `ITabArea | ISplitArea`.
     *
     * For fault tolerance, types are manually checked in deserialization.
     */
    function deserializeArea(area, names) {
        if (!area) {
            return null;
        }
        // Because this data is saved to a foreign data source, its type safety is
        // not guaranteed when it is retrieved, so exhaustive checks are necessary.
        const type = area.type || 'unknown';
        if (type === 'unknown' || (type !== 'tab-area' && type !== 'split-area')) {
            console.warn(`Attempted to deserialize unknown type: ${type}`);
            return null;
        }
        if (type === 'tab-area') {
            const { currentIndex, widgets } = area;
            const hydrated = {
                type: 'tab-area',
                currentIndex: currentIndex || 0,
                widgets: (widgets &&
                    widgets
                        .map(widget => names.get(widget))
                        .filter(widget => !!widget)) ||
                    []
            };
            // Make sure the current index is within bounds.
            if (hydrated.currentIndex > hydrated.widgets.length - 1) {
                hydrated.currentIndex = 0;
            }
            return hydrated;
        }
        const { orientation, sizes, children } = area;
        const hydrated = {
            type: 'split-area',
            orientation: orientation,
            sizes: sizes || [],
            children: (children &&
                children
                    .map(child => deserializeArea(child, names))
                    .filter(widget => !!widget)) ||
                []
        };
        return hydrated;
    }
    /**
     * Return the hydrated version of the main dock panel, ready to restore.
     *
     * #### Notes
     * Because this data comes from a potentially unreliable foreign source, it is
     * typed as a `JSONObject`; but the actual expected type is: `IMainArea`.
     *
     * For fault tolerance, types are manually checked in deserialization.
     */
    function deserializeMain(area, names) {
        if (!area) {
            return null;
        }
        const name = area.current || null;
        const dock = area.dock || null;
        return {
            currentWidget: (name && names.has(name) && names.get(name)) || null,
            dock: dock ? { main: deserializeArea(dock, names) } : null
        };
    }
    Private.deserializeMain = deserializeMain;
})(Private || (Private = {}));
//# sourceMappingURL=layoutrestorer.js.map

/***/ }),

/***/ 75677:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   aX: () => (/* binding */ createRendermimePlugin),
/* harmony export */   as: () => (/* binding */ createRendermimePlugins),
/* harmony export */   w2: () => (/* binding */ IMimeDocumentTracker)
/* harmony export */ });
/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6803);
/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _jupyterlab_docregistry__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(1978);
/* harmony import */ var _jupyterlab_docregistry__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_docregistry__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _jupyterlab_rendermime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(81089);
/* harmony import */ var _jupyterlab_rendermime__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_rendermime__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(38202);
/* harmony import */ var _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_translation__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(52104);
/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _lumino_coreutils__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(5406);
/* harmony import */ var _lumino_coreutils__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_lumino_coreutils__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _lumino_properties__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(65482);
/* harmony import */ var _lumino_properties__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_lumino_properties__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _layoutrestorer__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(67863);
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.








/**
 * The mime document tracker token.
 */
const IMimeDocumentTracker = new _lumino_coreutils__WEBPACK_IMPORTED_MODULE_5__.Token('@jupyterlab/application:IMimeDocumentTracker', 'A widget tracker for documents rendered using a mime renderer extension. Use this if you want to list and interact with documents rendered by such extensions.');
/**
 * Create rendermime plugins for rendermime extension modules.
 */
function createRendermimePlugins(extensions) {
    const plugins = [];
    const namespace = 'application-mimedocuments';
    const tracker = new _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.WidgetTracker({ namespace });
    extensions.forEach(mod => {
        let data = mod.default;
        // Handle CommonJS exports.
        if (!mod.hasOwnProperty('__esModule')) {
            data = mod;
        }
        if (!Array.isArray(data)) {
            data = [data];
        }
        data.forEach(item => {
            plugins.push(createRendermimePlugin(tracker, item));
        });
    });
    // Also add a meta-plugin handling state restoration
    // and exposing the mime document widget tracker.
    plugins.push({
        id: '@jupyterlab/application-extension:mimedocument',
        description: 'Provides a mime document widget tracker.',
        optional: [_layoutrestorer__WEBPACK_IMPORTED_MODULE_7__/* .ILayoutRestorer */ .L],
        provides: IMimeDocumentTracker,
        autoStart: true,
        activate: (app, restorer) => {
            if (restorer) {
                void restorer.restore(tracker, {
                    command: 'docmanager:open',
                    args: widget => ({
                        path: widget.context.path,
                        factory: Private.factoryNameProperty.get(widget)
                    }),
                    name: widget => `${widget.context.path}:${Private.factoryNameProperty.get(widget)}`
                });
            }
            return tracker;
        }
    });
    return plugins;
}
/**
 * Create rendermime plugins for rendermime extension modules.
 */
function createRendermimePlugin(tracker, item) {
    return {
        id: item.id,
        description: item.description,
        requires: [_jupyterlab_rendermime__WEBPACK_IMPORTED_MODULE_2__.IRenderMimeRegistry, _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_3__.ITranslator],
        autoStart: true,
        activate: (app, rendermime, translator) => {
            // Add the mime renderer.
            if (item.rank !== undefined) {
                rendermime.addFactory(item.rendererFactory, item.rank);
            }
            else {
                rendermime.addFactory(item.rendererFactory);
            }
            // Handle the widget factory.
            if (!item.documentWidgetFactoryOptions) {
                return;
            }
            const registry = app.docRegistry;
            let options = [];
            if (Array.isArray(item.documentWidgetFactoryOptions)) {
                options = item.documentWidgetFactoryOptions;
            }
            else {
                options = [
                    item.documentWidgetFactoryOptions
                ];
            }
            if (item.fileTypes) {
                item.fileTypes.forEach(ft => {
                    if (ft.icon) {
                        // upconvert the contents of the icon field to a proper LabIcon
                        ft = { ...ft, icon: _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_4__.LabIcon.resolve({ icon: ft.icon }) };
                    }
                    app.docRegistry.addFileType(ft);
                });
            }
            options.forEach(option => {
                const toolbarFactory = option.toolbarFactory
                    ? (w) => option.toolbarFactory(w.content.renderer)
                    : undefined;
                const factory = new _jupyterlab_docregistry__WEBPACK_IMPORTED_MODULE_1__.MimeDocumentFactory({
                    renderTimeout: item.renderTimeout,
                    dataType: item.dataType,
                    rendermime,
                    modelName: option.modelName,
                    name: option.name,
                    primaryFileType: registry.getFileType(option.primaryFileType),
                    fileTypes: option.fileTypes,
                    defaultFor: option.defaultFor,
                    defaultRendered: option.defaultRendered,
                    toolbarFactory,
                    translator,
                    factory: item.rendererFactory
                });
                registry.addWidgetFactory(factory);
                factory.widgetCreated.connect((sender, widget) => {
                    Private.factoryNameProperty.set(widget, factory.name);
                    // Notify the widget tracker if restore data needs to update.
                    widget.context.pathChanged.connect(() => {
                        void tracker.save(widget);
                    });
                    void tracker.add(widget);
                });
            });
        }
    };
}
/**
 * Private namespace for the module.
 */
var Private;
(function (Private) {
    /**
     * An attached property for keeping the factory name
     * that was used to create a mimedocument.
     */
    Private.factoryNameProperty = new _lumino_properties__WEBPACK_IMPORTED_MODULE_6__.AttachedProperty({
        name: 'factoryName',
        create: () => undefined
    });
})(Private || (Private = {}));
//# sourceMappingURL=mimerenderers.js.map

/***/ }),

/***/ 20389:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   J: () => (/* binding */ LabStatus)
/* harmony export */ });
/* harmony import */ var _lumino_disposable__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(38302);
/* harmony import */ var _lumino_disposable__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_lumino_disposable__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _lumino_signaling__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(2536);
/* harmony import */ var _lumino_signaling__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_lumino_signaling__WEBPACK_IMPORTED_MODULE_1__);
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.


/**
 * The application status signals and flags class.
 */
class LabStatus {
    /**
     * Construct a new  status object.
     */
    constructor(app) {
        this._busyCount = 0;
        this._dirtyCount = 0;
        this._busySignal = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_1__.Signal(app);
        this._dirtySignal = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_1__.Signal(app);
    }
    /**
     * Returns a signal for when application changes its busy status.
     */
    get busySignal() {
        return this._busySignal;
    }
    /**
     * Returns a signal for when application changes its dirty status.
     */
    get dirtySignal() {
        return this._dirtySignal;
    }
    /**
     * Whether the application is busy.
     */
    get isBusy() {
        return this._busyCount > 0;
    }
    /**
     * Whether the application is dirty.
     */
    get isDirty() {
        return this._dirtyCount > 0;
    }
    /**
     * Set the application state to dirty.
     *
     * @returns A disposable used to clear the dirty state for the caller.
     */
    setDirty() {
        const oldDirty = this.isDirty;
        this._dirtyCount++;
        if (this.isDirty !== oldDirty) {
            this._dirtySignal.emit(this.isDirty);
        }
        return new _lumino_disposable__WEBPACK_IMPORTED_MODULE_0__.DisposableDelegate(() => {
            const oldDirty = this.isDirty;
            this._dirtyCount = Math.max(0, this._dirtyCount - 1);
            if (this.isDirty !== oldDirty) {
                this._dirtySignal.emit(this.isDirty);
            }
        });
    }
    /**
     * Set the application state to busy.
     *
     * @returns A disposable used to clear the busy state for the caller.
     */
    setBusy() {
        const oldBusy = this.isBusy;
        this._busyCount++;
        if (this.isBusy !== oldBusy) {
            this._busySignal.emit(this.isBusy);
        }
        return new _lumino_disposable__WEBPACK_IMPORTED_MODULE_0__.DisposableDelegate(() => {
            const oldBusy = this.isBusy;
            this._busyCount--;
            if (this.isBusy !== oldBusy) {
                this._busySignal.emit(this.isBusy);
            }
        });
    }
}
//# sourceMappingURL=status.js.map

/***/ }),

/***/ 67663:
/***/ ((__unused_webpack_module, __unused_webpack___webpack_exports__, __webpack_require__) => {

"use strict";

// EXTERNAL MODULE: ../node_modules/@fortawesome/fontawesome-free/css/all.min.css
var all_min = __webpack_require__(94891);
// EXTERNAL MODULE: ../node_modules/@fortawesome/fontawesome-free/css/v4-shims.min.css
var v4_shims_min = __webpack_require__(60609);
// EXTERNAL MODULE: ../node_modules/@lumino/widgets/style/index.js + 1 modules
var style = __webpack_require__(20959);
// EXTERNAL MODULE: ../node_modules/@jupyterlab/ui-components/style/index.js + 1 modules
var ui_components_style = __webpack_require__(26238);
// EXTERNAL MODULE: ../node_modules/@jupyterlab/apputils/style/index.js + 1 modules
var apputils_style = __webpack_require__(57261);
// EXTERNAL MODULE: ../node_modules/@jupyterlab/docregistry/style/index.js + 1 modules
var docregistry_style = __webpack_require__(30507);
// EXTERNAL MODULE: ../node_modules/@jupyterlab/builder/node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js
var injectStylesIntoStyleTag = __webpack_require__(94830);
var injectStylesIntoStyleTag_default = /*#__PURE__*/__webpack_require__.n(injectStylesIntoStyleTag);
// EXTERNAL MODULE: ../node_modules/@jupyterlab/builder/node_modules/style-loader/dist/runtime/styleDomAPI.js
var styleDomAPI = __webpack_require__(80592);
var styleDomAPI_default = /*#__PURE__*/__webpack_require__.n(styleDomAPI);
// EXTERNAL MODULE: ../node_modules/@jupyterlab/builder/node_modules/style-loader/dist/runtime/insertBySelector.js
var insertBySelector = __webpack_require__(99763);
var insertBySelector_default = /*#__PURE__*/__webpack_require__.n(insertBySelector);
// EXTERNAL MODULE: ../node_modules/@jupyterlab/builder/node_modules/style-loader/dist/runtime/setAttributesWithoutAttributes.js
var setAttributesWithoutAttributes = __webpack_require__(28915);
var setAttributesWithoutAttributes_default = /*#__PURE__*/__webpack_require__.n(setAttributesWithoutAttributes);
// EXTERNAL MODULE: ../node_modules/@jupyterlab/builder/node_modules/style-loader/dist/runtime/insertStyleElement.js
var insertStyleElement = __webpack_require__(80366);
var insertStyleElement_default = /*#__PURE__*/__webpack_require__.n(insertStyleElement);
// EXTERNAL MODULE: ../node_modules/@jupyterlab/builder/node_modules/style-loader/dist/runtime/styleTagTransform.js
var styleTagTransform = __webpack_require__(17352);
var styleTagTransform_default = /*#__PURE__*/__webpack_require__.n(styleTagTransform);
// EXTERNAL MODULE: ../node_modules/@jupyterlab/builder/node_modules/css-loader/dist/cjs.js!../node_modules/@jupyterlab/application/style/base.css
var base = __webpack_require__(82119);
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/application/style/base.css

      
      
      
      
      
      
      
      
      

var options = {};

options.styleTagTransform = (styleTagTransform_default());
options.setAttributes = (setAttributesWithoutAttributes_default());

      options.insert = insertBySelector_default().bind(null, "head");
    
options.domAPI = (styleDomAPI_default());
options.insertStyleElement = (insertStyleElement_default());

var update = injectStylesIntoStyleTag_default()(base/* default */.Z, options);




       /* harmony default export */ const style_base = (base/* default */.Z && base/* default */.Z.locals ? base/* default */.Z.locals : undefined);

;// CONCATENATED MODULE: ../node_modules/@jupyterlab/application/style/index.js
/*-----------------------------------------------------------------------------
| Copyright (c) Jupyter Development Team.
| Distributed under the terms of the Modified BSD License.
|----------------------------------------------------------------------------*/

/* This file was auto-generated by ensurePackage() in @jupyterlab/buildutils */










/***/ }),

/***/ 3147:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
// ESM COMPAT FLAG
__webpack_require__.r(__webpack_exports__);

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "default": () => (/* binding */ lib),
  kernelSettings: () => (/* binding */ kernelSettings),
  toggleHeader: () => (/* binding */ toggleHeader)
});

// EXTERNAL MODULE: consume shared module (default) @jupyterlab/application@~4.4.5 (singleton) (fallback: ../node_modules/@jupyterlab/application/lib/index.js)
var index_js_ = __webpack_require__(25949);
// EXTERNAL MODULE: consume shared module (default) @jupyterlab/apputils@~4.5.5 (singleton) (fallback: ../node_modules/@jupyterlab/apputils/lib/index.js)
var lib_index_js_ = __webpack_require__(6803);
// EXTERNAL MODULE: consume shared module (default) @jupyterlab/coreutils@~6.4.5 (singleton) (fallback: ../node_modules/@jupyterlab/coreutils/lib/index.js)
var coreutils_lib_index_js_ = __webpack_require__(24474);
// EXTERNAL MODULE: consume shared module (default) @jupyterlab/settingregistry@~4.4.5 (singleton) (fallback: ../node_modules/@jupyterlab/settingregistry/lib/index.js)
var settingregistry_lib_index_js_ = __webpack_require__(51680);
// EXTERNAL MODULE: consume shared module (default) @jupyterlab/statedb@~4.4.5 (singleton) (fallback: ../node_modules/@jupyterlab/statedb/lib/index.js)
var statedb_lib_index_js_ = __webpack_require__(68145);
// EXTERNAL MODULE: consume shared module (default) @jupyterlab/translation@~4.4.5 (singleton) (fallback: ../node_modules/@jupyterlab/translation/lib/index.js)
var translation_lib_index_js_ = __webpack_require__(38202);
// EXTERNAL MODULE: consume shared module (default) @jupyterlab/ui-components@~4.4.5 (singleton) (fallback: ../node_modules/@jupyterlab/ui-components/lib/index.js)
var ui_components_lib_index_js_ = __webpack_require__(52104);
// EXTERNAL MODULE: consume shared module (default) @lumino/coreutils@~2.2.1 (singleton) (fallback: ../node_modules/@lumino/coreutils/dist/index.js)
var dist_index_js_ = __webpack_require__(5406);
// EXTERNAL MODULE: consume shared module (default) @lumino/disposable@~2.1.4 (singleton) (fallback: ../node_modules/@lumino/disposable/dist/index.es6.js)
var index_es6_js_ = __webpack_require__(38302);
// EXTERNAL MODULE: consume shared module (default) @lumino/polling@^2.1.4 (strict) (fallback: ../node_modules/@lumino/polling/dist/index.es6.js)
var dist_index_es6_js_ = __webpack_require__(1492);
// EXTERNAL MODULE: consume shared module (default) @jupyterlab/services@~7.4.5 (singleton) (fallback: ../node_modules/@jupyterlab/services/lib/index.js)
var services_lib_index_js_ = __webpack_require__(19838);
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/apputils-extension/lib/announcements.js
/*
 * Copyright (c) Jupyter Development Team.
 * Distributed under the terms of the Modified BSD License.
 */





const COMMAND_HELP_OPEN = 'help:open';
const NEWS_API_URL = '/lab/api/news';
const UPDATE_API_URL = '/lab/api/update';
const PRIVACY_URL = 'https://jupyterlab.readthedocs.io/en/stable/privacy_policies.html';
/**
 * Call the announcement API
 *
 * @param endpoint Endpoint to request
 * @param init Initial values for the request
 * @returns The response body interpreted as JSON
 */
async function requestAPI(endpoint, init = {}) {
    // Make request to Jupyter API
    const settings = services_lib_index_js_.ServerConnection.makeSettings();
    const requestUrl = coreutils_lib_index_js_.URLExt.join(settings.baseUrl, endpoint);
    let response;
    try {
        response = await services_lib_index_js_.ServerConnection.makeRequest(requestUrl, init, settings);
    }
    catch (error) {
        throw new services_lib_index_js_.ServerConnection.NetworkError(error);
    }
    const data = await response.json();
    if (!response.ok) {
        throw new services_lib_index_js_.ServerConnection.ResponseError(response, data.message);
    }
    return data;
}
const announcements = {
    id: '@jupyterlab/apputils-extension:announcements',
    description: 'Add the announcement feature. It will fetch news on the internet and check for application updates.',
    autoStart: true,
    optional: [services_lib_index_js_.IConfigSectionManager, settingregistry_lib_index_js_.ISettingRegistry, translation_lib_index_js_.ITranslator],
    activate: (app, configSectionManager, settingRegistry, translator) => {
        var _a, _b;
        const CONFIG_SECTION_NAME = announcements.id.replace(/[^\w]/g, '');
        void Promise.all([
            app.restored,
            (_a = settingRegistry === null || settingRegistry === void 0 ? void 0 : settingRegistry.load('@jupyterlab/apputils-extension:notification')) !== null && _a !== void 0 ? _a : Promise.resolve(null),
            // Use config instead of state to store independently of the workspace
            // if a news has been displayed or not.
            (_b = configSectionManager === null || configSectionManager === void 0 ? void 0 : configSectionManager.create({
                name: CONFIG_SECTION_NAME
            })) !== null && _b !== void 0 ? _b : Promise.resolve(null)
        ]).then(async ([_, settings, config]) => {
            const trans = (translator !== null && translator !== void 0 ? translator : translation_lib_index_js_.nullTranslator).load('jupyterlab');
            // Store dismiss state
            lib_index_js_.Notification.manager.changed.connect((manager, change) => {
                var _a;
                if (change.type !== 'removed') {
                    return;
                }
                const { id, tags } = ((_a = change
                    .notification.options.data) !== null && _a !== void 0 ? _a : {});
                if ((tags !== null && tags !== void 0 ? tags : []).some(tag => ['news', 'update'].includes(tag)) && id) {
                    const update = {};
                    update[id] = { seen: true, dismissed: true };
                    config === null || config === void 0 ? void 0 : config.update(update).catch(reason => {
                        console.error(`Failed to update the announcements config:\n${reason}`);
                    });
                }
            });
            const mustFetchNews = settings === null || settings === void 0 ? void 0 : settings.get('fetchNews').composite;
            if (mustFetchNews === 'none') {
                const notificationId = lib_index_js_.Notification.emit(trans.__('Would you like to get notified about official Jupyter news?'), 'default', {
                    autoClose: false,
                    actions: [
                        {
                            label: trans.__('Open privacy policy'),
                            caption: PRIVACY_URL,
                            callback: event => {
                                event.preventDefault();
                                if (app.commands.hasCommand(COMMAND_HELP_OPEN)) {
                                    void app.commands.execute(COMMAND_HELP_OPEN, {
                                        text: trans.__('Privacy policies'),
                                        url: PRIVACY_URL
                                    });
                                }
                                else {
                                    window.open(PRIVACY_URL, '_blank', 'noreferrer');
                                }
                            },
                            displayType: 'link'
                        },
                        {
                            label: trans.__('Yes'),
                            callback: () => {
                                lib_index_js_.Notification.dismiss(notificationId);
                                config === null || config === void 0 ? void 0 : config.update({}).then(() => fetchNews()).catch(reason => {
                                    console.error(`Failed to get the news:\n${reason}`);
                                });
                                settings === null || settings === void 0 ? void 0 : settings.set('fetchNews', 'true').catch((reason) => {
                                    console.error(`Failed to save setting 'fetchNews':\n${reason}`);
                                });
                            }
                        },
                        {
                            label: trans.__('No'),
                            callback: () => {
                                lib_index_js_.Notification.dismiss(notificationId);
                                settings === null || settings === void 0 ? void 0 : settings.set('fetchNews', 'false').catch((reason) => {
                                    console.error(`Failed to save setting 'fetchNews':\n${reason}`);
                                });
                            }
                        }
                    ]
                });
            }
            else {
                await fetchNews();
            }
            async function fetchNews() {
                var _a, _b, _c, _d;
                if (((_a = settings === null || settings === void 0 ? void 0 : settings.get('fetchNews').composite) !== null && _a !== void 0 ? _a : 'false') === 'true') {
                    try {
                        const response = await requestAPI(NEWS_API_URL);
                        for (const { link, message, type, options } of response.news) {
                            // @ts-expect-error data has no index
                            const id = options.data['id'];
                            // Filter those notifications
                            const state = (_b = config === null || config === void 0 ? void 0 : config.data[id]) !== null && _b !== void 0 ? _b : {
                                seen: false,
                                dismissed: false
                            };
                            if (!state.dismissed) {
                                options.actions = [
                                    {
                                        label: trans.__('Hide'),
                                        caption: trans.__('Never show this notification again.'),
                                        callback: () => {
                                            const update = {};
                                            update[id] = { seen: true, dismissed: true };
                                            config === null || config === void 0 ? void 0 : config.update(update).catch(reason => {
                                                console.error(`Failed to update the announcements config:\n${reason}`);
                                            });
                                        }
                                    }
                                ];
                                if ((link === null || link === void 0 ? void 0 : link.length) === 2) {
                                    options.actions.push({
                                        label: link[0],
                                        caption: link[1],
                                        callback: () => {
                                            window.open(link[1], '_blank', 'noreferrer');
                                        },
                                        displayType: 'link'
                                    });
                                }
                                if (!state.seen) {
                                    options.autoClose = 5000;
                                    const update = {};
                                    update[id] = { seen: true };
                                    config === null || config === void 0 ? void 0 : config.update(update).catch(reason => {
                                        console.error(`Failed to update the announcements config:\n${reason}`);
                                    });
                                }
                                lib_index_js_.Notification.emit(message, type, options);
                            }
                        }
                    }
                    catch (reason) {
                        console.log('Failed to get the announcements.', reason);
                    }
                }
                if ((_c = settings === null || settings === void 0 ? void 0 : settings.get('checkForUpdates').composite) !== null && _c !== void 0 ? _c : true) {
                    const response = await requestAPI(UPDATE_API_URL);
                    if (response.notification) {
                        const { link, message, type, options } = response.notification;
                        // @ts-expect-error data has no index
                        const id = options.data['id'];
                        const state = (_d = config === null || config === void 0 ? void 0 : config.data[id]) !== null && _d !== void 0 ? _d : {
                            seen: false,
                            dismissed: false
                        };
                        if (!state.dismissed) {
                            let notificationId;
                            options.actions = [
                                {
                                    label: trans.__('Ignore all updates'),
                                    caption: trans.__('Do not prompt me if a new JupyterLab version is available.'),
                                    callback: () => {
                                        settings === null || settings === void 0 ? void 0 : settings.set('checkForUpdates', false).then(() => {
                                            lib_index_js_.Notification.dismiss(notificationId);
                                        }).catch((reason) => {
                                            console.error('Failed to set the `checkForUpdates` setting.', reason);
                                        });
                                    }
                                }
                            ];
                            if ((link === null || link === void 0 ? void 0 : link.length) === 2) {
                                options.actions.push({
                                    label: link[0],
                                    caption: link[1],
                                    callback: () => {
                                        window.open(link[1], '_blank', 'noreferrer');
                                    },
                                    // Because the link to the changelog is the primary option,
                                    // display it in an accent color.
                                    displayType: 'accent'
                                });
                            }
                            if (!state.seen) {
                                options.autoClose = 5000;
                                const update = {};
                                update[id] = { seen: true };
                                config === null || config === void 0 ? void 0 : config.update(update).catch(reason => {
                                    console.error(`Failed to update the announcements config:\n${reason}`);
                                });
                            }
                            notificationId = lib_index_js_.Notification.emit(message, type, options);
                        }
                    }
                }
            }
        });
    }
};
//# sourceMappingURL=announcements.js.map
// EXTERNAL MODULE: consume shared module (default) @jupyterlab/mainmenu@~4.4.5 (singleton) (fallback: ../node_modules/@jupyterlab/mainmenu/lib/index.js)
var mainmenu_lib_index_js_ = __webpack_require__(23024);
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/apputils-extension/lib/licensesplugin.js
/*
 * Copyright (c) Jupyter Development Team.
 * Distributed under the terms of the Modified BSD License.
 */






/**
 * The command IDs used by the licenses plugin.
 */
var CommandIDs;
(function (CommandIDs) {
    CommandIDs.licenses = 'apputils:licenses';
    CommandIDs.licenseReport = 'apputils:license-report';
    CommandIDs.refreshLicenses = 'apputils:licenses-refresh';
})(CommandIDs || (CommandIDs = {}));
/**
 * The license client plugin for fetching licenses.
 */
const licensesClient = {
    id: '@jupyterlab/apputils-extension:licenses-client',
    description: 'The licenses client plugin for fetching licenses.',
    autoStart: true,
    provides: lib_index_js_.ILicensesClient,
    activate: (app) => {
        const licensesUrl = coreutils_lib_index_js_.URLExt.join(coreutils_lib_index_js_.PageConfig.getBaseUrl(), coreutils_lib_index_js_.PageConfig.getOption('licensesUrl')) + '/';
        const serverSettings = app.serviceManager.serverSettings;
        return new lib_index_js_.Licenses.LicensesClient({ licensesUrl, serverSettings });
    }
};
/**
 * A plugin to add a licenses reporting tools.
 */
const licensesPlugin = {
    id: '@jupyterlab/apputils-extension:licenses-plugin',
    description: 'Adds licenses reporting tools.',
    requires: [lib_index_js_.ILicensesClient, translation_lib_index_js_.ITranslator],
    optional: [index_js_.ILayoutRestorer, mainmenu_lib_index_js_.IMainMenu, lib_index_js_.ICommandPalette],
    autoStart: true,
    activate: (app, client, translator, restorer, menu, palette) => {
        const { commands, shell } = app;
        const trans = translator.load('jupyterlab');
        const category = trans.__('Help');
        const downloadAsText = trans.__('Download All Licenses as');
        const refreshLicenses = trans.__('Refresh Licenses');
        const licensesNamespace = 'help-licenses';
        const licensesTracker = new lib_index_js_.WidgetTracker({
            namespace: licensesNamespace
        });
        // translation strings
        const licensesText = trans.__('Licenses');
        // an incrementer for license widget ids
        let counter = 0;
        /**
         * Create a MainAreaWidget for a license viewer
         */
        function createLicenseWidget(args) {
            const licensesModel = new lib_index_js_.Licenses.Model({
                ...args,
                client,
                trans
            });
            const content = new lib_index_js_.Licenses({ model: licensesModel });
            content.id = `${licensesNamespace}-${++counter}`;
            content.title.label = licensesText;
            content.title.icon = ui_components_lib_index_js_.copyrightIcon;
            const main = new lib_index_js_.MainAreaWidget({
                content,
                reveal: licensesModel.licensesReady
            });
            main.toolbar.addItem('refresh-licenses', new ui_components_lib_index_js_.CommandToolbarButton({
                id: CommandIDs.refreshLicenses,
                args: { noLabel: 1 },
                commands
            }));
            main.toolbar.addItem('spacer', ui_components_lib_index_js_.Toolbar.createSpacerItem());
            for (const format of Object.keys(lib_index_js_.Licenses.REPORT_FORMATS)) {
                const button = new ui_components_lib_index_js_.CommandToolbarButton({
                    id: CommandIDs.licenseReport,
                    args: { format, noLabel: 1 },
                    commands
                });
                main.toolbar.addItem(`download-${format}`, button);
            }
            return main;
        }
        /**
         * Return a full license report format based on a format name
         */
        function formatOrDefault(format) {
            return (lib_index_js_.Licenses.REPORT_FORMATS[format] ||
                lib_index_js_.Licenses.REPORT_FORMATS[lib_index_js_.Licenses.DEFAULT_FORMAT]);
        }
        // register license-related commands
        commands.addCommand(CommandIDs.licenses, {
            label: licensesText,
            execute: (args) => {
                // bail if no license API is available from the server
                if (!coreutils_lib_index_js_.PageConfig.getOption('licensesUrl')) {
                    console.warn('No license API available from the server');
                    return;
                }
                const licenseMain = createLicenseWidget(args);
                shell.add(licenseMain, 'main', { type: 'Licenses' });
                // add to tracker so it can be restored, and update when choices change
                void licensesTracker.add(licenseMain);
                licenseMain.content.model.trackerDataChanged.connect(() => {
                    void licensesTracker.save(licenseMain);
                });
                return licenseMain;
            }
        });
        commands.addCommand(CommandIDs.refreshLicenses, {
            label: args => (args.noLabel ? '' : refreshLicenses),
            caption: refreshLicenses,
            icon: ui_components_lib_index_js_.refreshIcon,
            execute: async () => {
                var _a;
                return (_a = licensesTracker.currentWidget) === null || _a === void 0 ? void 0 : _a.content.model.initLicenses();
            }
        });
        commands.addCommand(CommandIDs.licenseReport, {
            label: args => {
                if (args.noLabel) {
                    return '';
                }
                const format = formatOrDefault(`${args.format}`);
                return `${downloadAsText} ${format.title}`;
            },
            caption: args => {
                const format = formatOrDefault(`${args.format}`);
                return `${downloadAsText} ${format.title}`;
            },
            icon: args => {
                const format = formatOrDefault(`${args.format}`);
                return format.icon;
            },
            execute: async (args) => {
                var _a;
                const format = formatOrDefault(`${args.format}`);
                return await ((_a = licensesTracker.currentWidget) === null || _a === void 0 ? void 0 : _a.content.model.download({
                    format: format.id
                }));
            }
        });
        // handle optional integrations
        if (palette) {
            palette.addItem({ command: CommandIDs.licenses, category });
        }
        if (menu) {
            const helpMenu = menu.helpMenu;
            helpMenu.addGroup([{ command: CommandIDs.licenses }], 0);
        }
        if (restorer) {
            void restorer.restore(licensesTracker, {
                command: CommandIDs.licenses,
                name: widget => 'licenses',
                args: widget => {
                    const { currentBundleName, currentPackageIndex, packageFilter } = widget.content.model;
                    const args = {
                        currentBundleName,
                        currentPackageIndex,
                        packageFilter
                    };
                    return args;
                }
            });
        }
    }
};
//# sourceMappingURL=licensesplugin.js.map
// EXTERNAL MODULE: consume shared module (default) @jupyterlab/statusbar@~4.4.5 (singleton) (fallback: ../node_modules/@jupyterlab/statusbar/lib/index.js)
var statusbar_lib_index_js_ = __webpack_require__(74878);
// EXTERNAL MODULE: consume shared module (default) @lumino/widgets@~2.7.1 (singleton) (fallback: ../node_modules/@lumino/widgets/dist/index.es6.js)
var widgets_dist_index_es6_js_ = __webpack_require__(60920);
// EXTERNAL MODULE: consume shared module (default) react@~18.2.0 (singleton) (fallback: ../node_modules/react/index.js)
var react_index_js_ = __webpack_require__(78156);
// EXTERNAL MODULE: ../node_modules/react-dom/client.js
var client = __webpack_require__(37634);
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/apputils-extension/lib/notificationplugin.js
/*
 * Copyright (c) Jupyter Development Team.
 * Distributed under the terms of the Modified BSD License.
 */









/**
 * Toast close button class
 */
const TOAST_CLOSE_BUTTON_CLASS = 'jp-Notification-Toast-Close';
/**
 * Toast close button class right margin required due to custom hover effect
 */
const TOAST_CLOSE_BUTTON_MARGIN_CLASS = 'jp-Notification-Toast-Close-Margin';
/**
 * Maximal number of characters displayed in a notification.
 */
const MAX_MESSAGE_LENGTH = 140;
var notificationplugin_CommandIDs;
(function (CommandIDs) {
    /**
     * Dismiss a notification
     */
    CommandIDs.dismiss = 'apputils:dismiss-notification';
    /**
     * Display all notifications
     */
    CommandIDs.display = 'apputils:display-notifications';
    /**
     * Create a notification
     */
    CommandIDs.notify = 'apputils:notify';
    /**
     * Update a notification
     */
    CommandIDs.update = 'apputils:update-notification';
})(notificationplugin_CommandIDs || (notificationplugin_CommandIDs = {}));
/**
 * Half spacing between subitems in a status item.
 */
const HALF_SPACING = 4;
/**
 * Notification center view
 */
function NotificationCenter(props) {
    const { manager, onClose, trans } = props;
    // Markdown parsed notifications
    const [notifications, setNotifications] = react_index_js_.useState([]);
    // Load asynchronously react-toastify icons
    const [icons, setIcons] = react_index_js_.useState(null);
    react_index_js_.useEffect(() => {
        async function onChanged() {
            setNotifications(await Promise.all(manager.notifications.map(async (n) => {
                return Object.freeze({
                    ...n
                });
            })));
        }
        if (notifications.length !== manager.count) {
            void onChanged();
        }
        manager.changed.connect(onChanged);
        return () => {
            manager.changed.disconnect(onChanged);
        };
    }, [manager]);
    react_index_js_.useEffect(() => {
        Private.getIcons()
            .then(toastifyIcons => {
            setIcons(toastifyIcons);
        })
            .catch(r => {
            console.error(`Failed to get react-toastify icons:\n${r}`);
        });
    }, []);
    return (react_index_js_.createElement(ui_components_lib_index_js_.UseSignal, { signal: manager.changed }, () => (react_index_js_.createElement(react_index_js_.Fragment, null,
        react_index_js_.createElement("h2", { className: "jp-Notification-Header jp-Toolbar" },
            react_index_js_.createElement("span", { className: "jp-Toolbar-item" }, manager.count > 0
                ? trans._n('%1 notification', '%1 notifications', manager.count)
                : trans.__('No notifications')),
            react_index_js_.createElement("span", { className: "jp-Toolbar-item jp-Toolbar-spacer" }),
            react_index_js_.createElement(ui_components_lib_index_js_.ToolbarButtonComponent, { noFocusOnClick: false, onClick: () => {
                    manager.dismiss();
                }, icon: ui_components_lib_index_js_.deleteIcon, tooltip: trans.__('Dismiss all notifications'), enabled: manager.count > 0 }),
            react_index_js_.createElement(ui_components_lib_index_js_.ToolbarButtonComponent, { noFocusOnClick: false, onClick: onClose, icon: ui_components_lib_index_js_.closeIcon, tooltip: trans.__('Hide notifications') })),
        react_index_js_.createElement("ol", { className: "jp-Notification-List" }, notifications.map(notification => {
            var _a;
            const { id, message, type, options } = notification;
            const toastType = type === 'in-progress' ? 'default' : type;
            const closeNotification = () => {
                manager.dismiss(id);
            };
            const icon = type === 'default'
                ? null
                : type === 'in-progress'
                    ? (_a = icons === null || icons === void 0 ? void 0 : icons.spinner) !== null && _a !== void 0 ? _a : null
                    : icons && icons[type];
            return (react_index_js_.createElement("li", { className: "jp-Notification-List-Item", key: notification.id, onClick: event => {
                    // Stop propagation to avoid closing the popup on click
                    event.stopPropagation();
                } },
                react_index_js_.createElement("div", { className: `Toastify__toast Toastify__toast-theme--light Toastify__toast--${toastType} jp-Notification-Toast-${toastType}` },
                    react_index_js_.createElement("div", { className: "Toastify__toast-body" },
                        icon && (react_index_js_.createElement("div", { className: "Toastify__toast-icon" }, icon({ theme: 'light', type: toastType }))),
                        react_index_js_.createElement("div", null, Private.createContent(message, closeNotification, options.actions))),
                    react_index_js_.createElement(Private.CloseButton, { close: closeNotification, closeIcon: ui_components_lib_index_js_.deleteIcon.react, title: trans.__('Dismiss notification'), closeIconMargin: true }))));
        }))))));
}
/**
 * Status widget model
 */
class NotificationStatusModel extends ui_components_lib_index_js_.VDomModel {
    constructor(manager) {
        super();
        this.manager = manager;
        this._highlight = false;
        this._listOpened = false;
        this._doNotDisturbMode = false;
        this._count = manager.count;
        this.manager.changed.connect(this.onNotificationChanged, this);
    }
    /**
     * Number of notifications.
     */
    get count() {
        return this._count;
    }
    /**
     * Whether to silence all notifications or not.
     */
    get doNotDisturbMode() {
        return this._doNotDisturbMode;
    }
    set doNotDisturbMode(v) {
        this._doNotDisturbMode = v;
    }
    /**
     * Whether to highlight the status widget or not.
     */
    get highlight() {
        return this._highlight;
    }
    /**
     * Whether the popup is opened or not.
     */
    get listOpened() {
        return this._listOpened;
    }
    set listOpened(v) {
        this._listOpened = v;
        if (this._listOpened || this._highlight) {
            this._highlight = false;
        }
        this.stateChanged.emit();
    }
    onNotificationChanged(_, change) {
        // Set private attribute to trigger only once the signal emission
        this._count = this.manager.count;
        const { autoClose } = change.notification.options;
        const noToast = this.doNotDisturbMode ||
            (typeof autoClose === 'number' && autoClose <= 0);
        // Highlight if
        //   the list is not opened (the style change if list is opened due to clickedItem style in statusbar.)
        //   the change type is not removed
        //   the notification will be hidden
        if (!this._listOpened && change.type !== 'removed' && noToast) {
            this._highlight = true;
        }
        this.stateChanged.emit();
    }
}
/**
 * Status view
 */
function NotificationStatus(props) {
    return (react_index_js_.createElement(statusbar_lib_index_js_.GroupItem, { role: "button", tabIndex: 0, "aria-haspopup": true, spacing: HALF_SPACING, onClick: () => {
            props.onClick();
        }, onKeyDown: (event) => {
            if (event.key === 'Enter' || event.key === ' ') {
                props.onClick();
            }
        }, title: props.count > 0
            ? props.trans._n('%1 notification', '%1 notifications', props.count)
            : props.trans.__('No notifications') },
        react_index_js_.createElement(statusbar_lib_index_js_.TextItem, { className: "jp-Notification-Status-Text", source: `${props.count}` }),
        react_index_js_.createElement(ui_components_lib_index_js_.bellIcon.react, { top: '2px', stylesheet: 'statusBar' })));
}
/**
 * Add notification center and toast
 */
const notificationPlugin = {
    id: '@jupyterlab/apputils-extension:notification',
    description: 'Add the notification center and its status indicator.',
    autoStart: true,
    optional: [statusbar_lib_index_js_.IStatusBar, settingregistry_lib_index_js_.ISettingRegistry, translation_lib_index_js_.ITranslator],
    activate: (app, statusBar, settingRegistry, translator) => {
        Private.translator = translator !== null && translator !== void 0 ? translator : translation_lib_index_js_.nullTranslator;
        const trans = Private.translator.load('jupyterlab');
        const model = new NotificationStatusModel(lib_index_js_.Notification.manager);
        model.doNotDisturbMode = false;
        if (settingRegistry) {
            void Promise.all([
                settingRegistry.load(notificationPlugin.id),
                app.restored
            ]).then(([plugin]) => {
                const updateSettings = () => {
                    model.doNotDisturbMode = plugin.get('doNotDisturbMode')
                        .composite;
                };
                updateSettings();
                plugin.changed.connect(updateSettings);
            });
        }
        app.commands.addCommand(notificationplugin_CommandIDs.notify, {
            label: trans.__('Emit a notification'),
            caption: trans.__('Notification is described by {message: string, type?: string, options?: {autoClose?: number | false, actions: {label: string, commandId: string, args?: ReadOnlyJSONObject, caption?: string, className?: string}[], data?: ReadOnlyJSONValue}}.'),
            execute: args => {
                var _a;
                const { message, type } = args;
                const options = (_a = args.options) !== null && _a !== void 0 ? _a : {};
                return lib_index_js_.Notification.manager.notify(message, type !== null && type !== void 0 ? type : 'default', {
                    ...options,
                    actions: options.actions
                        ? options.actions.map((action) => {
                            return {
                                ...action,
                                callback: () => {
                                    app.commands
                                        .execute(action.commandId, action.args)
                                        .catch(r => {
                                        console.error(`Failed to executed '${action.commandId}':\n${r}`);
                                    });
                                }
                            };
                        })
                        : null
                });
            }
        });
        app.commands.addCommand(notificationplugin_CommandIDs.update, {
            label: trans.__('Update a notification'),
            caption: trans.__('Notification is described by {id: string, message: string, type?: string, options?: {autoClose?: number | false, actions: {label: string, commandId: string, args?: ReadOnlyJSONObject, caption?: string, className?: string}[], data?: ReadOnlyJSONValue}}.'),
            execute: args => {
                const { id, message, type, ...options } = args;
                return lib_index_js_.Notification.manager.update({
                    id,
                    message,
                    type: type !== null && type !== void 0 ? type : 'default',
                    ...options,
                    actions: options.actions
                        ? options.actions.map((action) => {
                            return {
                                ...action,
                                callback: () => {
                                    app.commands
                                        .execute(action.commandId, action.args)
                                        .catch(r => {
                                        console.error(`Failed to executed '${action.commandId}':\n${r}`);
                                    });
                                }
                            };
                        })
                        : null
                });
            }
        });
        app.commands.addCommand(notificationplugin_CommandIDs.dismiss, {
            label: trans.__('Dismiss a notification'),
            execute: args => {
                const { id } = args;
                lib_index_js_.Notification.manager.dismiss(id);
            }
        });
        let popup = null;
        model.listOpened = false;
        const notificationList = lib_index_js_.ReactWidget.create(react_index_js_.createElement(NotificationCenter, { manager: lib_index_js_.Notification.manager, onClose: () => {
                popup === null || popup === void 0 ? void 0 : popup.dispose();
            }, trans: trans }));
        notificationList.addClass('jp-Notification-Center');
        async function onNotification(manager, change) {
            var _a;
            if (model.doNotDisturbMode || (popup !== null && !popup.isDisposed)) {
                return;
            }
            const { message, type, options, id } = change.notification;
            if (typeof options.autoClose === 'number' && options.autoClose <= 0) {
                // If the notification is silent, bail early.
                return;
            }
            switch (change.type) {
                case 'added':
                    await Private.createToast(id, message, type, options);
                    break;
                case 'updated':
                    {
                        const toast = await Private.toast();
                        const actions = options.actions;
                        const autoClose = (_a = options.autoClose) !== null && _a !== void 0 ? _a : (actions && actions.length > 0 ? false : null);
                        if (toast.isActive(id)) {
                            // Update existing toast
                            const closeToast = () => {
                                // Dismiss the displayed toast
                                toast.dismiss(id);
                                // Dismiss the notification from the queue
                                manager.dismiss(id);
                            };
                            toast.update(id, {
                                type: type === 'in-progress' ? null : type,
                                isLoading: type === 'in-progress',
                                autoClose: autoClose,
                                render: Private.createContent(message, closeToast, options.actions)
                            });
                        }
                        else {
                            // Needs to recreate a closed toast
                            await Private.createToast(id, message, type, options);
                        }
                    }
                    break;
                case 'removed':
                    await Private.toast().then(t => {
                        t.dismiss(id);
                    });
                    break;
            }
        }
        lib_index_js_.Notification.manager.changed.connect(onNotification);
        const displayNotifications = () => {
            if (popup) {
                popup.dispose();
                popup = null;
            }
            else {
                popup = (0,statusbar_lib_index_js_.showPopup)({
                    body: notificationList,
                    anchor: notificationStatus,
                    align: 'right',
                    hasDynamicSize: true,
                    startHidden: true
                });
                // Dismiss all toasts when opening the notification center
                Private.toast()
                    .then(t => {
                    t.dismiss();
                })
                    .catch(r => {
                    console.error(`Failed to dismiss all toasts:\n${r}`);
                })
                    .finally(() => {
                    popup === null || popup === void 0 ? void 0 : popup.launch();
                    // Focus on the pop-up
                    notificationList.node.focus();
                    popup === null || popup === void 0 ? void 0 : popup.disposed.connect(() => {
                        model.listOpened = false;
                        popup = null;
                    });
                });
            }
            model.listOpened = popup !== null;
        };
        app.commands.addCommand(notificationplugin_CommandIDs.display, {
            label: trans.__('Show Notifications'),
            execute: displayNotifications
        });
        const notificationStatus = lib_index_js_.ReactWidget.create(react_index_js_.createElement(ui_components_lib_index_js_.UseSignal, { signal: model.stateChanged }, () => {
            if (model.highlight || (popup && !popup.isDisposed)) {
                notificationStatus.addClass('jp-mod-selected');
            }
            else {
                notificationStatus.removeClass('jp-mod-selected');
            }
            return (react_index_js_.createElement(NotificationStatus, { count: model.count, highlight: model.highlight, trans: trans, onClick: displayNotifications }));
        }));
        notificationStatus.addClass('jp-Notification-Status');
        if (statusBar) {
            statusBar.registerStatusItem(notificationPlugin.id, {
                item: notificationStatus,
                align: 'right',
                rank: -1
            });
        }
        else {
            notificationStatus.addClass('jp-ThemedContainer');
            // if the status bar is not available, position the notification
            // status in the bottom right corner of the page
            notificationStatus.node.style.position = 'fixed';
            notificationStatus.node.style.bottom = '0';
            // 10px is the default padding for the status bar
            notificationStatus.node.style.right = '10px';
            widgets_dist_index_es6_js_.Widget.attach(notificationStatus, document.body);
            notificationStatus.show();
        }
    }
};
var Private;
(function (Private) {
    /**
     * Translator object for private namespace
     */
    Private.translator = translation_lib_index_js_.nullTranslator;
    /**
     * Pointer to asynchronously loaded react-toastify
     */
    let toastify = null;
    function CloseButton(props) {
        var _a;
        return (react_index_js_.createElement("button", { className: `jp-Button jp-mod-minimal ${TOAST_CLOSE_BUTTON_CLASS}${props.closeIconMargin ? ` ${TOAST_CLOSE_BUTTON_MARGIN_CLASS}` : ''}`, title: (_a = props.title) !== null && _a !== void 0 ? _a : '', onClick: props.close },
            react_index_js_.createElement(props.closeIcon, { className: "jp-icon-hover", tag: "span" })));
    }
    Private.CloseButton = CloseButton;
    function ToastifyCloseButton(props) {
        const trans = Private.translator.load('jupyterlab');
        return (react_index_js_.createElement(CloseButton, { close: props.closeToast, closeIcon: ui_components_lib_index_js_.closeIcon.react, title: trans.__('Hide notification') }));
    }
    let waitForToastify = null;
    /**
     * Asynchronously load the toast container
     *
     * @returns The toast object
     */
    async function toast() {
        if (waitForToastify === null) {
            waitForToastify = new dist_index_js_.PromiseDelegate();
        }
        else {
            await waitForToastify.promise;
        }
        if (toastify === null) {
            toastify = await __webpack_require__.e(/* import() */ 53).then(__webpack_require__.t.bind(__webpack_require__, 60053, 23));
            const container = document.body.appendChild(document.createElement('div'));
            container.id = 'react-toastify-container';
            container.classList.add('jp-ThemedContainer');
            const root = (0,client/* createRoot */.s)(container);
            root.render(react_index_js_.createElement(toastify.ToastContainer, { draggable: false, closeOnClick: false, hideProgressBar: true, newestOnTop: true, pauseOnFocusLoss: true, pauseOnHover: true, position: "bottom-right", className: "jp-toastContainer", transition: toastify.Slide, closeButton: ToastifyCloseButton }));
            waitForToastify.resolve();
        }
        return toastify.toast;
    }
    Private.toast = toast;
    /**
     * react-toastify icons loader
     */
    async function getIcons() {
        if (toastify === null) {
            await toast();
        }
        return toastify.Icons;
    }
    Private.getIcons = getIcons;
    const displayType2Class = {
        accent: 'jp-mod-accept',
        link: 'jp-mod-link',
        warn: 'jp-mod-warn',
        default: ''
    };
    /**
     * Create a button with customized callback in a toast
     */
    function ToastButton({ action, closeToast }) {
        var _a, _b;
        const clickHandler = (event) => {
            action.callback(event);
            if (!event.defaultPrevented) {
                closeToast();
            }
        };
        const classes = [
            'jp-toast-button',
            displayType2Class[(_a = action.displayType) !== null && _a !== void 0 ? _a : 'default']
        ].join(' ');
        return (react_index_js_.createElement(ui_components_lib_index_js_.Button, { title: (_b = action.caption) !== null && _b !== void 0 ? _b : action.label, className: classes, onClick: clickHandler, small: true }, action.label));
    }
    /**
     * Helper function to construct the notification content
     *
     * @param message Message to print in the notification
     * @param closeHandler Function closing the notification
     * @param actions Toast actions
     */
    function createContent(message, closeHandler, actions) {
        var _a;
        const shortenMessage = message.length > MAX_MESSAGE_LENGTH
            ? message.slice(0, MAX_MESSAGE_LENGTH) + '…'
            : message;
        return (react_index_js_.createElement(react_index_js_.Fragment, null,
            react_index_js_.createElement("div", { className: "jp-toast-message" }, shortenMessage.split('\n').map((part, index) => (react_index_js_.createElement(react_index_js_.Fragment, { key: `part-${index}` },
                index > 0 ? react_index_js_.createElement("br", null) : null,
                part)))),
            ((_a = actions === null || actions === void 0 ? void 0 : actions.length) !== null && _a !== void 0 ? _a : 0) > 0 && (react_index_js_.createElement("div", { className: "jp-toast-buttonBar" },
                react_index_js_.createElement("div", { className: "jp-toast-spacer" }),
                actions.map((action, idx) => {
                    return (react_index_js_.createElement(ToastButton, { key: 'button-' + idx, action: action, closeToast: closeHandler }));
                })))));
    }
    Private.createContent = createContent;
    /**
     * Create a toast notification
     *
     * @param toastId Toast unique id
     * @param message Toast message
     * @param type Toast type
     * @param options Toast options
     * @returns Toast id
     */
    async function createToast(toastId, message, type, options = {}) {
        const { actions, autoClose, data } = options;
        const t = await toast();
        const toastOptions = {
            autoClose: autoClose !== null && autoClose !== void 0 ? autoClose : (actions && actions.length > 0 ? false : undefined),
            data: data,
            className: `jp-Notification-Toast-${type}`,
            toastId,
            type: type === 'in-progress' ? null : type,
            isLoading: type === 'in-progress'
        };
        return t(({ closeToast }) => createContent(message, () => {
            if (closeToast)
                closeToast();
            lib_index_js_.Notification.manager.dismiss(toastId);
        }, actions), toastOptions);
    }
    Private.createToast = createToast;
})(Private || (Private = {}));
//# sourceMappingURL=notificationplugin.js.map
// EXTERNAL MODULE: consume shared module (default) @lumino/algorithm@~2.0.3 (singleton) (fallback: ../node_modules/@lumino/algorithm/dist/index.es6.js)
var algorithm_dist_index_es6_js_ = __webpack_require__(56114);
// EXTERNAL MODULE: consume shared module (default) @lumino/commands@~2.3.2 (singleton) (fallback: ../node_modules/@lumino/commands/dist/index.es6.js)
var commands_dist_index_es6_js_ = __webpack_require__(35538);
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/apputils-extension/lib/palette.js
/* -----------------------------------------------------------------------------
| Copyright (c) Jupyter Development Team.
| Distributed under the terms of the Modified BSD License.
|----------------------------------------------------------------------------*/







/**
 * The command IDs used by the apputils extension.
 */
var palette_CommandIDs;
(function (CommandIDs) {
    CommandIDs.activate = 'apputils:activate-command-palette';
})(palette_CommandIDs || (palette_CommandIDs = {}));
const PALETTE_PLUGIN_ID = '@jupyterlab/apputils-extension:palette';
/**
 * A thin wrapper around the `CommandPalette` class to conform with the
 * JupyterLab interface for the application-wide command palette.
 */
class Palette {
    /**
     * Create a palette instance.
     */
    constructor(palette, translator) {
        this.translator = translator || translation_lib_index_js_.nullTranslator;
        const trans = this.translator.load('jupyterlab');
        this._palette = palette;
        this._palette.title.label = '';
        this._palette.title.caption = trans.__('Command Palette');
    }
    /**
     * The placeholder text of the command palette's search input.
     */
    set placeholder(placeholder) {
        this._palette.inputNode.placeholder = placeholder;
    }
    get placeholder() {
        return this._palette.inputNode.placeholder;
    }
    /**
     * Activate the command palette for user input.
     */
    activate() {
        this._palette.activate();
    }
    /**
     * Add a command item to the command palette.
     *
     * @param options - The options for creating the command item.
     *
     * @returns A disposable that will remove the item from the palette.
     */
    addItem(options) {
        const item = this._palette.addItem(options);
        return new index_es6_js_.DisposableDelegate(() => {
            this._palette.removeItem(item);
        });
    }
}
/**
 * A namespace for `Palette` statics.
 */
(function (Palette) {
    /**
     * Activate the command palette.
     */
    function activate(app, translator, settingRegistry) {
        const { commands, shell } = app;
        const trans = translator.load('jupyterlab');
        const palette = palette_Private.createPalette(app, translator);
        const modalPalette = new lib_index_js_.ModalCommandPalette({ commandPalette: palette });
        let modal = false;
        palette.node.setAttribute('role', 'region');
        palette.node.setAttribute('aria-label', trans.__('Command Palette Section'));
        shell.add(palette, 'left', { rank: 300, type: 'Command Palette' });
        if (settingRegistry) {
            const loadSettings = settingRegistry.load(PALETTE_PLUGIN_ID);
            const updateSettings = (settings) => {
                const newModal = settings.get('modal').composite;
                if (modal && !newModal) {
                    palette.parent = null;
                    modalPalette.detach();
                    shell.add(palette, 'left', { rank: 300, type: 'Command Palette' });
                }
                else if (!modal && newModal) {
                    palette.parent = null;
                    modalPalette.palette = palette;
                    palette.show();
                    modalPalette.attach();
                }
                modal = newModal;
            };
            Promise.all([loadSettings, app.restored])
                .then(([settings]) => {
                updateSettings(settings);
                settings.changed.connect(settings => {
                    updateSettings(settings);
                });
            })
                .catch((reason) => {
                console.error(reason.message);
            });
        }
        // Show the current palette shortcut in its title.
        const updatePaletteTitle = () => {
            const binding = (0,algorithm_dist_index_es6_js_.find)(app.commands.keyBindings, b => b.command === palette_CommandIDs.activate);
            if (binding) {
                const ks = binding.keys.map(commands_dist_index_es6_js_.CommandRegistry.formatKeystroke).join(', ');
                palette.title.caption = trans.__('Commands (%1)', ks);
            }
            else {
                palette.title.caption = trans.__('Commands');
            }
        };
        updatePaletteTitle();
        app.commands.keyBindingChanged.connect(() => {
            updatePaletteTitle();
        });
        commands.addCommand(palette_CommandIDs.activate, {
            execute: () => {
                if (modal) {
                    modalPalette.activate();
                }
                else {
                    shell.activateById(palette.id);
                }
            },
            label: trans.__('Activate Command Palette')
        });
        palette.inputNode.placeholder = trans.__('SEARCH');
        return new Palette(palette, translator);
    }
    Palette.activate = activate;
    /**
     * Restore the command palette.
     */
    function restore(app, restorer, translator) {
        const palette = palette_Private.createPalette(app, translator);
        // Let the application restorer track the command palette for restoration of
        // application state (e.g. setting the command palette as the current side bar
        // widget).
        restorer.add(palette, 'command-palette');
    }
    Palette.restore = restore;
})(Palette || (Palette = {}));
/**
 * The namespace for module private data.
 */
var palette_Private;
(function (Private) {
    /**
     * The private command palette instance.
     */
    let palette;
    /**
     * Create the application-wide command palette.
     */
    function createPalette(app, translator) {
        if (!palette) {
            // use a renderer tweaked to use inline svg icons
            palette = new widgets_dist_index_es6_js_.CommandPalette({
                commands: app.commands,
                renderer: ui_components_lib_index_js_.CommandPaletteSvg.defaultRenderer
            });
            palette.id = 'command-palette';
            palette.title.icon = ui_components_lib_index_js_.paletteIcon;
            const trans = translator.load('jupyterlab');
            palette.title.label = trans.__('Commands');
        }
        return palette;
    }
    Private.createPalette = createPalette;
})(palette_Private || (palette_Private = {}));
//# sourceMappingURL=palette.js.map
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/apputils-extension/lib/settingconnector.js
/*
 * Copyright (c) Jupyter Development Team.
 * Distributed under the terms of the Modified BSD License.
 */



/**
 * A data connector for fetching settings.
 *
 * #### Notes
 * This connector adds a query parameter to the base services setting manager.
 */
class SettingConnector extends statedb_lib_index_js_.DataConnector {
    constructor(connector) {
        super();
        this._throttlers = Object.create(null);
        this._connector = connector;
    }
    /**
     * Fetch settings for a plugin.
     * @param id - The plugin ID
     *
     * #### Notes
     * The REST API requests are throttled at one request per plugin per 100ms.
     */
    fetch(id) {
        const throttlers = this._throttlers;
        if (!(id in throttlers)) {
            throttlers[id] = new dist_index_es6_js_.Throttler(() => this._connector.fetch(id), 100);
        }
        return throttlers[id].invoke();
    }
    async list(query = 'all') {
        const { isDisabled } = coreutils_lib_index_js_.PageConfig.Extension;
        const { ids, values } = await this._connector.list(query === 'ids' ? 'ids' : undefined);
        if (query === 'all') {
            return { ids, values };
        }
        if (query === 'ids') {
            return { ids };
        }
        return {
            ids: ids.filter(id => !isDisabled(id)),
            values: values.filter(({ id }) => !isDisabled(id))
        };
    }
    async save(id, raw) {
        await this._connector.save(id, raw);
    }
}
//# sourceMappingURL=settingconnector.js.map
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/apputils-extension/lib/settingsplugin.js
/* -----------------------------------------------------------------------------
| Copyright (c) Jupyter Development Team.
| Distributed under the terms of the Modified BSD License.
|----------------------------------------------------------------------------*/



/**
 * Provides the settings connector as a separate plugin to allow for alternative
 * implementations that may want to fetch settings from a different source or
 * endpoint.
 */
const settingsConnector = {
    id: '@jupyterlab/apputils-extension:settings-connector',
    description: 'Provides the settings connector.',
    autoStart: true,
    provides: settingregistry_lib_index_js_.ISettingConnector,
    activate: (app) => new SettingConnector(app.serviceManager.settings)
};
/**
 * The default setting registry provider.
 */
const settingsPlugin = {
    id: '@jupyterlab/apputils-extension:settings',
    autoStart: true,
    provides: settingregistry_lib_index_js_.ISettingRegistry,
    optional: [settingregistry_lib_index_js_.ISettingConnector],
    description: 'Provides the setting registry.',
    activate: async (app, settingsConnector) => {
        const { isDisabled } = coreutils_lib_index_js_.PageConfig.Extension;
        const connector = settingsConnector !== null && settingsConnector !== void 0 ? settingsConnector : new SettingConnector(app.serviceManager.settings);
        // On startup, check if a plugin is available in the application.
        // This helps avoid loading plugin files from other lab-based applications
        // that have placed their schemas next to the JupyterLab schemas. Different lab-based
        // applications might not have the same set of plugins loaded on the page.
        // As an example this helps prevent having new toolbar items added by another application
        // appear in JupyterLab as a side-effect when they are defined via the settings system.
        const registry = new settingregistry_lib_index_js_.SettingRegistry({
            connector,
            plugins: (await connector.list('active')).values.filter(value => app.hasPlugin(value.id))
        });
        // If there are plugins that have schemas that are not in the setting
        // registry after the application has restored, try to load them manually
        // because otherwise, its settings will never become available in the
        // setting registry.
        void app.restored.then(async () => {
            const plugins = await connector.list('ids');
            plugins.ids.forEach(async (id) => {
                if (!app.hasPlugin(id) || isDisabled(id) || id in registry.plugins) {
                    return;
                }
                try {
                    await registry.load(id);
                }
                catch (error) {
                    console.warn(`Settings failed to load for (${id})`, error);
                    if (!app.isPluginActivated(id)) {
                        console.warn(`If 'jupyter.lab.transform=true' in the plugin schema, this ` +
                            `may happen if {autoStart: false} in (${id}) or if it is ` +
                            `one of the deferredExtensions in page config.`);
                    }
                }
            });
        });
        return registry;
    }
};
//# sourceMappingURL=settingsplugin.js.map
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/apputils-extension/lib/statusbarplugin.js
/* -----------------------------------------------------------------------------
| Copyright (c) Jupyter Development Team.
| Distributed under the terms of the Modified BSD License.
|----------------------------------------------------------------------------*/





/**
 * A plugin that provides a kernel status item to the status bar.
 */
const kernelStatus = {
    id: '@jupyterlab/apputils-extension:kernel-status',
    description: 'Provides the kernel status indicator model.',
    autoStart: true,
    requires: [statusbar_lib_index_js_.IStatusBar],
    provides: lib_index_js_.IKernelStatusModel,
    optional: [lib_index_js_.ISessionContextDialogs, translation_lib_index_js_.ITranslator, index_js_.ILabShell],
    activate: (app, statusBar, sessionDialogs_, translator_, labShell) => {
        const translator = translator_ !== null && translator_ !== void 0 ? translator_ : translation_lib_index_js_.nullTranslator;
        const sessionDialogs = sessionDialogs_ !== null && sessionDialogs_ !== void 0 ? sessionDialogs_ : new lib_index_js_.SessionContextDialogs({ translator });
        // When the status item is clicked, launch the kernel
        // selection dialog for the current session.
        const changeKernel = async () => {
            if (!item.model.sessionContext) {
                return;
            }
            await sessionDialogs.selectKernel(item.model.sessionContext);
        };
        const changeKernelOnKeyDown = async (event) => {
            if (event.key === 'Enter' ||
                event.key === 'Spacebar' ||
                event.key === ' ') {
                event.preventDefault();
                event.stopPropagation();
                return changeKernel();
            }
        };
        // Create the status item.
        const item = new lib_index_js_.KernelStatus({ onClick: changeKernel, onKeyDown: changeKernelOnKeyDown }, translator);
        const providers = new Set();
        const addSessionProvider = (provider) => {
            providers.add(provider);
            if (app.shell.currentWidget) {
                updateSession(app.shell, {
                    newValue: app.shell.currentWidget,
                    oldValue: null
                });
            }
        };
        function updateSession(shell, changes) {
            var _a;
            const { oldValue, newValue } = changes;
            // Clean up after the old value if it exists,
            // listen for changes to the title of the activity
            if (oldValue) {
                oldValue.title.changed.disconnect(onTitleChanged);
            }
            item.model.sessionContext =
                (_a = [...providers]
                    .map(provider => provider(changes.newValue))
                    .filter(session => session !== null)[0]) !== null && _a !== void 0 ? _a : null;
            if (newValue && item.model.sessionContext) {
                onTitleChanged(newValue.title);
                newValue.title.changed.connect(onTitleChanged);
            }
        }
        // When the title of the active widget changes, update the label
        // of the hover text.
        const onTitleChanged = (title) => {
            item.model.activityName = title.label;
        };
        if (labShell) {
            labShell.currentChanged.connect(updateSession);
        }
        statusBar.registerStatusItem(kernelStatus.id, {
            priority: 1,
            item,
            align: 'left',
            rank: 1,
            isActive: () => item.model.sessionContext !== null
        });
        return { addSessionProvider };
    }
};
/*
 * A plugin providing running terminals and sessions information
 * to the status bar.
 */
const runningSessionsStatus = {
    id: '@jupyterlab/apputils-extension:running-sessions-status',
    description: 'Add the running sessions and terminals status bar item.',
    autoStart: true,
    requires: [statusbar_lib_index_js_.IStatusBar, translation_lib_index_js_.ITranslator],
    optional: [settingregistry_lib_index_js_.ISettingRegistry],
    activate: (app, statusBar, translator, settingRegistry) => {
        const createStatusItem = (options) => {
            const item = new lib_index_js_.RunningSessions({
                onClick: () => app.shell.activateById('jp-running-sessions'),
                onKeyDown: (event) => {
                    if (event.key === 'Enter' ||
                        event.key === 'Spacebar' ||
                        event.key === ' ') {
                        event.preventDefault();
                        event.stopPropagation();
                        app.shell.activateById('jp-running-sessions');
                    }
                },
                serviceManager: app.serviceManager,
                translator,
                ...options
            });
            item.model.sessions = Array.from(app.serviceManager.sessions.running()).length;
            item.model.terminals = Array.from(app.serviceManager.terminals.running()).length;
            return item;
        };
        const registerItem = (options) => {
            const item = createStatusItem(options);
            return statusBar.registerStatusItem(runningSessionsStatus.id, {
                item,
                align: 'left',
                rank: 0
            });
        };
        if (settingRegistry) {
            let disposable;
            const onSettingsUpdated = (kernelSettings, terminalsSettings) => {
                var _a, _b;
                const showTerminalsMap = {
                    'if-any': undefined,
                    never: false,
                    always: true
                };
                const showKernels = (_a = kernelSettings === null || kernelSettings === void 0 ? void 0 : kernelSettings.get('showStatusBarItem').composite) !== null && _a !== void 0 ? _a : true;
                const showTerminals = showTerminalsMap[(_b = terminalsSettings === null || terminalsSettings === void 0 ? void 0 : terminalsSettings.get('showStatusBarItem').composite) !== null && _b !== void 0 ? _b : 'if-any'];
                disposable === null || disposable === void 0 ? void 0 : disposable.dispose();
                if (showKernels || showTerminals !== false) {
                    disposable = registerItem({
                        showKernels,
                        showTerminals
                    });
                }
            };
            const kernelsPluginId = '@jupyterlab/apputils-extension:kernels-settings';
            const terminalPluginId = '@jupyterlab/terminal-extension:plugin';
            void Promise.all([
                // Settings may be missing if the respective plugins are not enabled/included.
                kernelsPluginId in settingRegistry.plugins
                    ? settingRegistry.load(kernelsPluginId).catch(() => undefined)
                    : Promise.resolve(undefined),
                terminalPluginId in settingRegistry.plugins
                    ? settingRegistry.load(terminalPluginId).catch(() => undefined)
                    : Promise.resolve(undefined)
            ]).then(([kernelSettings, terminalSettings]) => {
                onSettingsUpdated(kernelSettings, terminalSettings);
                if (kernelSettings) {
                    kernelSettings.changed.connect(settings => {
                        kernelSettings = settings;
                        onSettingsUpdated(kernelSettings, terminalSettings);
                    });
                }
                if (terminalSettings) {
                    terminalSettings.changed.connect(settings => {
                        terminalSettings = settings;
                        onSettingsUpdated(kernelSettings, terminalSettings);
                    });
                }
            });
        }
        else {
            registerItem({
                showKernels: true
            });
        }
    }
};
//# sourceMappingURL=statusbarplugin.js.map
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/apputils-extension/lib/subshell-settings.js
/* -----------------------------------------------------------------------------
| Copyright (c) Jupyter Development Team.
| Distributed under the terms of the Modified BSD License.
|----------------------------------------------------------------------------*/

/*
 * A plugin loading kernel subshell settings.
 */
const subshellsSettings = {
    id: '@jupyterlab/apputils-extension:subshell-settings',
    description: 'Kernel subshell settings.',
    autoStart: true,
    requires: [],
    optional: [settingregistry_lib_index_js_.ISettingRegistry],
    activate: (app, settingRegistry) => {
        if (settingRegistry) {
            app.started
                .then(async () => {
                const subshellsSettings = await settingRegistry.load('@jupyterlab/apputils-extension:kernels-settings');
                const commsOverSubshells = subshellsSettings.get('commsOverSubshells')
                    .composite;
                app.serviceManager.kernels.commsOverSubshells = commsOverSubshells;
                subshellsSettings.changed.connect(() => {
                    const commsOverSubshells = subshellsSettings.get('commsOverSubshells').composite;
                    app.serviceManager.kernels.commsOverSubshells = commsOverSubshells;
                });
            })
                .catch(reason => {
                console.error('Fail to load settings for the subshells.');
                console.error(reason);
            });
        }
    }
};
//# sourceMappingURL=subshell-settings.js.map
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/apputils-extension/style/scrollbar.raw.css
const scrollbar_raw_namespaceObject = "/*\n * Copyright (c) Jupyter Development Team.\n * Distributed under the terms of the Modified BSD License.\n */\n\n/*\n * Webkit scrollbar styling.\n * Separate file which is dynamically loaded based on user/theme settings.\n */\n\n/* use standard opaque scrollbars for most nodes */\n\n::-webkit-scrollbar,\n::-webkit-scrollbar-corner {\n  background: var(--jp-scrollbar-background-color);\n}\n\n::-webkit-scrollbar-thumb {\n  background: rgb(var(--jp-scrollbar-thumb-color));\n  border: var(--jp-scrollbar-thumb-margin) solid transparent;\n  background-clip: content-box;\n  border-radius: var(--jp-scrollbar-thumb-radius);\n}\n\n::-webkit-scrollbar-track:horizontal {\n  border-left: var(--jp-scrollbar-endpad) solid\n    var(--jp-scrollbar-background-color);\n  border-right: var(--jp-scrollbar-endpad) solid\n    var(--jp-scrollbar-background-color);\n}\n\n::-webkit-scrollbar-track:vertical {\n  border-top: var(--jp-scrollbar-endpad) solid\n    var(--jp-scrollbar-background-color);\n  border-bottom: var(--jp-scrollbar-endpad) solid\n    var(--jp-scrollbar-background-color);\n}\n\n/* for code nodes, use a transparent style of scrollbar */\n\n.CodeMirror-hscrollbar::-webkit-scrollbar,\n.CodeMirror-vscrollbar::-webkit-scrollbar,\n.CodeMirror-hscrollbar::-webkit-scrollbar-corner,\n.CodeMirror-vscrollbar::-webkit-scrollbar-corner {\n  background-color: transparent;\n}\n\n.CodeMirror-hscrollbar::-webkit-scrollbar-thumb,\n.CodeMirror-vscrollbar::-webkit-scrollbar-thumb {\n  background: rgba(var(--jp-scrollbar-thumb-color), 0.5);\n  border: var(--jp-scrollbar-thumb-margin) solid transparent;\n  background-clip: content-box;\n  border-radius: var(--jp-scrollbar-thumb-radius);\n}\n\n.CodeMirror-hscrollbar::-webkit-scrollbar-track:horizontal {\n  border-left: var(--jp-scrollbar-endpad) solid transparent;\n  border-right: var(--jp-scrollbar-endpad) solid transparent;\n}\n\n.CodeMirror-vscrollbar::-webkit-scrollbar-track:vertical {\n  border-top: var(--jp-scrollbar-endpad) solid transparent;\n  border-bottom: var(--jp-scrollbar-endpad) solid transparent;\n}\n";
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/apputils-extension/lib/themesplugins.js
/* -----------------------------------------------------------------------------
| Copyright (c) Jupyter Development Team.
| Distributed under the terms of the Modified BSD License.
|----------------------------------------------------------------------------*/







var themesplugins_CommandIDs;
(function (CommandIDs) {
    CommandIDs.changeTheme = 'apputils:change-theme';
    CommandIDs.changePreferredLightTheme = 'apputils:change-light-theme';
    CommandIDs.changePreferredDarkTheme = 'apputils:change-dark-theme';
    CommandIDs.toggleAdaptiveTheme = 'apputils:adaptive-theme';
    CommandIDs.themeScrollbars = 'apputils:theme-scrollbars';
    CommandIDs.changeFont = 'apputils:change-font';
    CommandIDs.incrFontSize = 'apputils:incr-font-size';
    CommandIDs.decrFontSize = 'apputils:decr-font-size';
})(themesplugins_CommandIDs || (themesplugins_CommandIDs = {}));
function createStyleSheet(text) {
    const style = document.createElement('style');
    style.setAttribute('type', 'text/css');
    style.appendChild(document.createTextNode(text));
    return style;
}
/**
 * The default theme manager provider.
 */
const themesPlugin = {
    id: '@jupyterlab/apputils-extension:themes',
    description: 'Provides the theme manager.',
    requires: [settingregistry_lib_index_js_.ISettingRegistry, index_js_.JupyterFrontEnd.IPaths, translation_lib_index_js_.ITranslator],
    optional: [lib_index_js_.ISplashScreen],
    activate: (app, settings, paths, translator, splash) => {
        const trans = translator.load('jupyterlab');
        const host = app.shell;
        const commands = app.commands;
        const url = coreutils_lib_index_js_.URLExt.join(coreutils_lib_index_js_.PageConfig.getBaseUrl(), paths.urls.themes);
        const key = themesPlugin.id;
        const manager = new lib_index_js_.ThemeManager({
            key,
            host,
            settings,
            splash: splash !== null && splash !== void 0 ? splash : undefined,
            url
        });
        let scrollbarsStyleElement = null;
        // Keep a synchronously set reference to the current theme,
        // since the asynchronous setting of the theme in `changeTheme`
        // can lead to an incorrect toggle on the currently used theme.
        let currentTheme;
        manager.themeChanged.connect((sender, args) => {
            // Set data attributes on the application shell for the current theme.
            currentTheme = args.newValue;
            document.body.dataset.jpThemeLight = String(manager.isLight(currentTheme));
            document.body.dataset.jpThemeName = currentTheme;
            document.body.style.colorScheme = manager.isLight(currentTheme)
                ? 'light'
                : 'dark';
            if (document.body.dataset.jpThemeScrollbars !==
                String(manager.themeScrollbars(currentTheme))) {
                document.body.dataset.jpThemeScrollbars = String(manager.themeScrollbars(currentTheme));
                if (manager.themeScrollbars(currentTheme)) {
                    if (!scrollbarsStyleElement) {
                        scrollbarsStyleElement = createStyleSheet(scrollbar_raw_namespaceObject);
                    }
                    if (!scrollbarsStyleElement.parentElement) {
                        document.body.appendChild(scrollbarsStyleElement);
                    }
                }
                else {
                    if (scrollbarsStyleElement && scrollbarsStyleElement.parentElement) {
                        scrollbarsStyleElement.parentElement.removeChild(scrollbarsStyleElement);
                    }
                }
            }
            commands.notifyCommandChanged(themesplugins_CommandIDs.changeTheme);
        });
        commands.addCommand(themesplugins_CommandIDs.changeTheme, {
            label: args => {
                if (args.theme === undefined) {
                    return trans.__('Switch to the provided `theme`.');
                }
                const theme = args['theme'];
                const displayName = manager.getDisplayName(theme);
                return args['isPalette']
                    ? trans.__('Use Theme: %1', displayName)
                    : displayName;
            },
            isToggled: args => args['theme'] === currentTheme,
            execute: args => {
                const theme = args['theme'];
                if (theme === manager.theme) {
                    return;
                }
                // Disable adaptive theme if users decide to change the theme when adaptive theme is on
                if (manager.isToggledAdaptiveTheme()) {
                    return manager.toggleAdaptiveTheme();
                }
                return manager.setTheme(theme);
            }
        });
        commands.addCommand(themesplugins_CommandIDs.changePreferredLightTheme, {
            label: args => {
                if (args.theme === undefined) {
                    return trans.__('Switch to the provided light `theme`.');
                }
                const theme = args['theme'];
                const displayName = manager.getDisplayName(theme);
                return args['isPalette']
                    ? trans.__('Set Preferred Light Theme: %1', displayName)
                    : displayName;
            },
            isToggled: args => args['theme'] === manager.preferredLightTheme,
            execute: args => {
                const theme = args['theme'];
                if (theme === manager.preferredLightTheme) {
                    return;
                }
                return manager.setPreferredLightTheme(theme);
            }
        });
        commands.addCommand(themesplugins_CommandIDs.changePreferredDarkTheme, {
            label: args => {
                if (args.theme === undefined) {
                    return trans.__('Switch to the provided dark `theme`.');
                }
                const theme = args['theme'];
                const displayName = manager.getDisplayName(theme);
                return args['isPalette']
                    ? trans.__('Set Preferred Dark Theme: %1', displayName)
                    : displayName;
            },
            isToggled: args => args['theme'] === manager.preferredDarkTheme,
            execute: args => {
                const theme = args['theme'];
                if (theme === manager.preferredDarkTheme) {
                    return;
                }
                return manager.setPreferredDarkTheme(theme);
            }
        });
        commands.addCommand(themesplugins_CommandIDs.toggleAdaptiveTheme, {
            // Avoid lengthy option text in menu
            label: args => args['isPalette']
                ? trans.__('Synchronize Styling Theme with System Settings')
                : trans.__('Synchronize with System Settings'),
            isToggled: () => manager.isToggledAdaptiveTheme(),
            execute: () => {
                manager.toggleAdaptiveTheme().catch(console.warn);
            }
        });
        commands.addCommand(themesplugins_CommandIDs.themeScrollbars, {
            label: trans.__('Theme Scrollbars'),
            isToggled: () => manager.isToggledThemeScrollbars(),
            execute: () => manager.toggleThemeScrollbars()
        });
        commands.addCommand(themesplugins_CommandIDs.changeFont, {
            label: args => args['enabled'] ? `${args['font']}` : trans.__('waiting for fonts'),
            isEnabled: args => args['enabled'],
            isToggled: args => manager.getCSS(args['key']) === args['font'],
            execute: args => manager.setCSSOverride(args['key'], args['font'])
        });
        commands.addCommand(themesplugins_CommandIDs.incrFontSize, {
            label: args => {
                switch (args.key) {
                    case 'code-font-size':
                        return trans.__('Increase Code Font Size');
                    case 'content-font-size1':
                        return trans.__('Increase Content Font Size');
                    case 'ui-font-size1':
                        return trans.__('Increase UI Font Size');
                    default:
                        return trans.__('Increase Font Size');
                }
            },
            execute: args => manager.incrFontSize(args['key'])
        });
        commands.addCommand(themesplugins_CommandIDs.decrFontSize, {
            label: args => {
                switch (args.key) {
                    case 'code-font-size':
                        return trans.__('Decrease Code Font Size');
                    case 'content-font-size1':
                        return trans.__('Decrease Content Font Size');
                    case 'ui-font-size1':
                        return trans.__('Decrease UI Font Size');
                    default:
                        return trans.__('Decrease Font Size');
                }
            },
            execute: args => manager.decrFontSize(args['key'])
        });
        return manager;
    },
    autoStart: true,
    provides: lib_index_js_.IThemeManager
};
/**
 * The default theme manager's UI command palette and main menu functionality.
 *
 * #### Notes
 * This plugin loads separately from the theme manager plugin in order to
 * prevent blocking of the theme manager while it waits for the command palette
 * and main menu to become available.
 */
const themesPaletteMenuPlugin = {
    id: '@jupyterlab/apputils-extension:themes-palette-menu',
    description: 'Adds theme commands to the menu and the command palette.',
    requires: [lib_index_js_.IThemeManager, translation_lib_index_js_.ITranslator],
    optional: [lib_index_js_.ICommandPalette, mainmenu_lib_index_js_.IMainMenu],
    activate: (app, manager, translator, palette, mainMenu) => {
        const trans = translator.load('jupyterlab');
        // If we have a main menu, add the theme manager to the settings menu.
        if (mainMenu) {
            void app.restored.then(() => {
                var _a;
                const isPalette = false;
                const themeMenu = (_a = mainMenu.settingsMenu.items.find(item => {
                    var _a;
                    return item.type === 'submenu' &&
                        ((_a = item.submenu) === null || _a === void 0 ? void 0 : _a.id) === 'jp-mainmenu-settings-apputilstheme';
                })) === null || _a === void 0 ? void 0 : _a.submenu;
                // choose a theme
                if (themeMenu) {
                    manager.themes.forEach((theme, index) => {
                        themeMenu.insertItem(index, {
                            command: themesplugins_CommandIDs.changeTheme,
                            args: { isPalette, theme }
                        });
                    });
                }
            });
        }
        // If we have a command palette, add theme switching options to it.
        if (palette) {
            void app.restored.then(() => {
                const category = trans.__('Theme');
                const command = themesplugins_CommandIDs.changeTheme;
                const isPalette = true;
                // choose a theme
                manager.themes.forEach(theme => {
                    palette.addItem({ command, args: { isPalette, theme }, category });
                });
                // choose preferred light theme
                manager.themes.forEach(theme => {
                    palette.addItem({
                        command: themesplugins_CommandIDs.changePreferredLightTheme,
                        args: { isPalette, theme },
                        category
                    });
                });
                // choose preferred dark theme
                manager.themes.forEach(theme => {
                    palette.addItem({
                        command: themesplugins_CommandIDs.changePreferredDarkTheme,
                        args: { isPalette, theme },
                        category
                    });
                });
                // toggle adaptive theme
                palette.addItem({
                    command: themesplugins_CommandIDs.toggleAdaptiveTheme,
                    args: { isPalette },
                    category
                });
                // toggle scrollbar theming
                palette.addItem({ command: themesplugins_CommandIDs.themeScrollbars, category });
                // increase/decrease code font size
                palette.addItem({
                    command: themesplugins_CommandIDs.incrFontSize,
                    args: {
                        key: 'code-font-size'
                    },
                    category
                });
                palette.addItem({
                    command: themesplugins_CommandIDs.decrFontSize,
                    args: {
                        key: 'code-font-size'
                    },
                    category
                });
                // increase/decrease content font size
                palette.addItem({
                    command: themesplugins_CommandIDs.incrFontSize,
                    args: {
                        key: 'content-font-size1'
                    },
                    category
                });
                palette.addItem({
                    command: themesplugins_CommandIDs.decrFontSize,
                    args: {
                        key: 'content-font-size1'
                    },
                    category
                });
                // increase/decrease ui font size
                palette.addItem({
                    command: themesplugins_CommandIDs.incrFontSize,
                    args: {
                        key: 'ui-font-size1'
                    },
                    category
                });
                palette.addItem({
                    command: themesplugins_CommandIDs.decrFontSize,
                    args: {
                        key: 'ui-font-size1'
                    },
                    category
                });
            });
        }
    },
    autoStart: true
};
//# sourceMappingURL=themesplugins.js.map
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/apputils-extension/lib/toolbarregistryplugin.js
/*
 * Copyright (c) Jupyter Development Team.
 * Distributed under the terms of the Modified BSD License.
 */

/**
 * The default toolbar registry.
 */
const toolbarRegistry = {
    id: '@jupyterlab/apputils-extension:toolbar-registry',
    description: 'Provides toolbar items registry.',
    autoStart: true,
    provides: lib_index_js_.IToolbarWidgetRegistry,
    activate: (app) => {
        const registry = new lib_index_js_.ToolbarWidgetRegistry({
            defaultFactory: (0,lib_index_js_.createDefaultFactory)(app.commands)
        });
        return registry;
    }
};
//# sourceMappingURL=toolbarregistryplugin.js.map
// EXTERNAL MODULE: consume shared module (default) @jupyterlab/docregistry@~4.4.5 (strict) (fallback: ../node_modules/@jupyterlab/docregistry/lib/index.js)
var docregistry_lib_index_js_ = __webpack_require__(1978);
// EXTERNAL MODULE: consume shared module (default) @jupyterlab/workspaces@^4.4.5 (strict) (fallback: ../node_modules/@jupyterlab/workspaces/lib/index.js)
var workspaces_lib_index_js_ = __webpack_require__(73238);
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/apputils-extension/lib/workspacesplugin.js
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.







const WORKSPACE_NAME = 'jupyterlab-workspace';
const WORKSPACE_EXT = '.' + WORKSPACE_NAME;
const LAST_SAVE_ID = 'workspace-ui:lastSave';
const ICON_NAME = 'jp-JupyterIcon';
/**
 * The workspace MIME renderer.
 */
const workspacesPlugin = {
    id: '@jupyterlab/apputils-extension:workspaces',
    description: 'Add workspace file type.',
    autoStart: true,
    requires: [statedb_lib_index_js_.IStateDB, translation_lib_index_js_.ITranslator, index_js_.JupyterFrontEnd.IPaths],
    optional: [index_js_.IRouter, workspaces_lib_index_js_.IWorkspaceCommands],
    activate: (app, state, translator, paths, router, workspaceCommands) => {
        // The workspace factory creates dummy widgets to load a new workspace.
        const factory = new workspacesplugin_Private.WorkspaceFactory({
            workspaces: app.serviceManager.workspaces,
            state,
            translator,
            open: async (id) => {
                if (workspaceCommands) {
                    await app.commands.execute(workspaceCommands.open, { workspace: id });
                }
                else {
                    const workspacesBase = coreutils_lib_index_js_.URLExt.join(paths.urls.app, 'workspaces');
                    const url = coreutils_lib_index_js_.URLExt.join(workspacesBase, id);
                    if (!url.startsWith(workspacesBase)) {
                        throw new Error('Can only be used for workspaces');
                    }
                    if (router) {
                        router.navigate(url, { hard: true });
                    }
                    else {
                        document.location.href = url;
                    }
                }
            }
        });
        const trans = translator.load('jupyterlab');
        app.docRegistry.addFileType({
            name: WORKSPACE_NAME,
            contentType: 'file',
            fileFormat: 'text',
            displayName: trans.__('JupyterLab Workspace File'),
            extensions: [WORKSPACE_EXT],
            mimeTypes: ['text/json'],
            iconClass: ICON_NAME
        });
        app.docRegistry.addWidgetFactory(factory);
    }
};
var workspacesplugin_Private;
(function (Private) {
    /**
     * This widget factory is used to handle double click on workspace
     */
    class WorkspaceFactory extends docregistry_lib_index_js_.ABCWidgetFactory {
        /**
         * Construct a widget factory that uploads a workspace and navigates to it.
         *
         * @param options - The instantiation options for a `WorkspaceFactory`.
         */
        constructor(options) {
            const trans = (options.translator || translation_lib_index_js_.nullTranslator).load('jupyterlab');
            super({
                name: 'Workspace loader',
                label: trans.__('Workspace loader'),
                fileTypes: [WORKSPACE_NAME],
                defaultFor: [WORKSPACE_NAME],
                readOnly: true
            });
            this._state = options.state;
            this._workspaces = options.workspaces;
            this._open = options.open;
        }
        /**
         * Loads the workspace into load, and jump to it
         * @param context This is used to query the workspace content
         */
        createNewWidget(context) {
            // Save a file's contents as a workspace and navigate to that workspace.
            void context.ready.then(async () => {
                const file = context.model;
                const workspace = file.toJSON();
                const path = context.path;
                const id = workspace.metadata.id;
                // Save the file contents as a workspace.
                await this._workspaces.save(id, workspace);
                // Save last save location for the save command.
                await this._state.save(LAST_SAVE_ID, path);
                // Navigate to new workspace.
                await this._open(id);
            });
            return dummyWidget(context);
        }
    }
    Private.WorkspaceFactory = WorkspaceFactory;
    /**
     * Returns a dummy widget with disposed content that doesn't render in the UI.
     *
     * @param context - The file context.
     */
    function dummyWidget(context) {
        const widget = new docregistry_lib_index_js_.DocumentWidget({ content: new widgets_dist_index_es6_js_.Widget(), context });
        widget.content.dispose();
        return widget;
    }
})(workspacesplugin_Private || (workspacesplugin_Private = {}));
//# sourceMappingURL=workspacesplugin.js.map
// EXTERNAL MODULE: consume shared module (default) @lumino/domutils@~2.0.3 (singleton) (fallback: ../node_modules/@lumino/domutils/dist/index.es6.js)
var domutils_dist_index_es6_js_ = __webpack_require__(23738);
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/apputils-extension/lib/shortcuts.js
/*
 * Copyright (c) Jupyter Development Team.
 * Distributed under the terms of the Modified BSD License.
 */




/**
 * The class name for each row of ContextShortcutTable
 */
const SHORTCUT_TABLE_ROW_CLASS = 'jp-ContextualShortcut-TableRow';
/**
 * The class name for the last row of ContextShortcutTable
 */
const SHORTCUT_TABLE_LAST_ROW_CLASS = 'jp-ContextualShortcut-TableLastRow';
/**
 * The class name for each item of ContextShortcutTable
 */
const SHORTCUT_TABLE_ITEM_CLASS = 'jp-ContextualShortcut-TableItem';
/**
 * The class name for each button-like symbol representing a key used in a shortcut in the ContextShortcutTable
 */
const SHORTCUT_KEY_CLASS = 'jp-ContextualShortcut-Key';
function displayShortcuts(options) {
    const { commands, trans, activeElement } = options;
    const elt = activeElement !== null && activeElement !== void 0 ? activeElement : document.activeElement;
    /**
     * Find the distance from the target node to the first matching node.
     *
     * Based on Lumino private function commands.Private.targetDistance
     * This traverses the DOM path from `elt` to the root
     * computes the distance from `elt` to the first node which matches
     * the CSS selector. If no match is found, `-1` is returned.
     *
     * It also stops traversal if the `data-lm-suppress-shortcuts` or
     * `data-p-suppress-shortcuts` attributes are found.
     */
    function formatKeys(keys) {
        const topContainer = [];
        keys.forEach((key, index) => {
            const container = [];
            key.split(' ').forEach((ch, chIndex) => {
                container.push(react_index_js_.createElement("span", { className: SHORTCUT_KEY_CLASS, key: `ch-${chIndex}` },
                    react_index_js_.createElement("kbd", null, ch)), react_index_js_.createElement(react_index_js_.Fragment, { key: `fragment-${chIndex}` }, " + "));
            });
            topContainer.push(react_index_js_.createElement("span", { key: `key-${index}` }, container.slice(0, -1)), react_index_js_.createElement(react_index_js_.Fragment, { key: `fragment-${index}` }, " + "));
        });
        return react_index_js_.createElement("span", null, topContainer.slice(0, -1));
    }
    function capitalizeString(str) {
        const capitalizedStr = str.charAt(0).toUpperCase() + str.slice(1);
        return capitalizedStr;
    }
    function formatLabel(b) {
        const label = commands.label(b.command);
        const commandID = b.command.split(':')[1];
        const automaticLabel = commandID.split('-');
        let capitalizedLabel = '';
        for (let i = 0; i < automaticLabel.length; i++) {
            const str = capitalizeString(automaticLabel[i]);
            capitalizedLabel = capitalizedLabel + ' ' + str;
        }
        if (label.length > 0) {
            return label;
        }
        else {
            return capitalizedLabel;
        }
    }
    function matchDistance(selector, elt) {
        let targ = elt;
        for (let dist = 0; targ !== null && targ !== targ.parentElement; targ = targ.parentElement, ++dist) {
            if (targ.hasAttribute('data-lm-suppress-shortcuts')) {
                return -1;
            }
            if (targ.matches(selector)) {
                return dist;
            }
        }
        return -1;
    }
    // Find active keybindings for target element
    const activeBindings = new Map();
    for (let i = 0; i < commands.keyBindings.length; i++) {
        const kb = commands.keyBindings[i];
        let distance = matchDistance(kb.selector, elt);
        if (distance < 0) {
            continue;
        }
        let formatted = commands_dist_index_es6_js_.CommandRegistry.formatKeystroke(kb.keys);
        if (activeBindings.has(formatted)) {
            let oldBinding = activeBindings.get(formatted);
            // if the existing binding takes precedence, ignore this binding by continuing
            if (oldBinding[0] < distance ||
                (oldBinding[0] === distance &&
                    domutils_dist_index_es6_js_.Selector.calculateSpecificity(oldBinding[1].selector) >
                        domutils_dist_index_es6_js_.Selector.calculateSpecificity(kb.selector))) {
                continue;
            }
        }
        activeBindings.set(formatted, [distance, kb]);
    }
    // Group shortcuts by distance
    let maxDistance = -1;
    const groupedBindings = new Map();
    for (let [distance, binding] of activeBindings.values()) {
        maxDistance = Math.max(distance, maxDistance);
        if (!groupedBindings.has(distance)) {
            groupedBindings.set(distance, []);
        }
        groupedBindings.get(distance).push(binding);
    }
    // Display shortcuts by group
    const bindingTable = [];
    for (let d = 0; d <= maxDistance; d++) {
        if (groupedBindings.has(d)) {
            bindingTable.push(groupedBindings.get(d).map(b => (react_index_js_.createElement("tr", { className: SHORTCUT_TABLE_ROW_CLASS, key: `${b.command}-${b.keys.join('-').replace(' ', '_')}` },
                react_index_js_.createElement("td", { className: SHORTCUT_TABLE_ITEM_CLASS }, formatLabel(b)),
                react_index_js_.createElement("td", { className: SHORTCUT_TABLE_ITEM_CLASS }, formatKeys([...b.keys]))))));
            bindingTable.push(react_index_js_.createElement("tr", { className: SHORTCUT_TABLE_LAST_ROW_CLASS, key: `group-${d}-last` }));
        }
    }
    const body = (react_index_js_.createElement("table", null,
        react_index_js_.createElement("tbody", null, bindingTable)));
    return (0,lib_index_js_.showDialog)({
        title: trans.__('Keyboard Shortcuts'),
        body,
        buttons: [
            lib_index_js_.Dialog.cancelButton({
                label: trans.__('Close')
            })
        ]
    });
}
//# sourceMappingURL=shortcuts.js.map
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/apputils-extension/lib/index.js
/* -----------------------------------------------------------------------------
| Copyright (c) Jupyter Development Team.
| Distributed under the terms of the Modified BSD License.
|----------------------------------------------------------------------------*/
/**
 * @packageDocumentation
 * @module apputils-extension
 */





















/**
 * The interval in milliseconds before recover options appear during splash.
 */
const SPLASH_RECOVER_TIMEOUT = 12000;
/**
 * The command IDs used by the apputils plugin.
 */
var lib_CommandIDs;
(function (CommandIDs) {
    CommandIDs.loadState = 'apputils:load-statedb';
    CommandIDs.print = 'apputils:print';
    CommandIDs.reset = 'apputils:reset';
    CommandIDs.resetOnLoad = 'apputils:reset-on-load';
    CommandIDs.runFirstEnabled = 'apputils:run-first-enabled';
    CommandIDs.runAllEnabled = 'apputils:run-all-enabled';
    CommandIDs.toggleHeader = 'apputils:toggle-header';
    CommandIDs.displayShortcuts = 'apputils:display-shortcuts';
})(lib_CommandIDs || (lib_CommandIDs = {}));
/**
 * The default command palette extension.
 */
const palette = {
    id: '@jupyterlab/apputils-extension:palette',
    description: 'Provides the command palette.',
    autoStart: true,
    requires: [translation_lib_index_js_.ITranslator],
    provides: lib_index_js_.ICommandPalette,
    optional: [settingregistry_lib_index_js_.ISettingRegistry],
    activate: (app, translator, settingRegistry) => {
        return Palette.activate(app, translator, settingRegistry);
    }
};
/**
 * The default command palette's restoration extension.
 *
 * #### Notes
 * The command palette's restoration logic is handled separately from the
 * command palette provider extension because the layout restorer dependency
 * causes the command palette to be unavailable to other extensions earlier
 * in the application load cycle.
 */
const paletteRestorer = {
    id: '@jupyterlab/apputils-extension:palette-restorer',
    description: 'Restores the command palette.',
    autoStart: true,
    requires: [index_js_.ILayoutRestorer, translation_lib_index_js_.ITranslator],
    activate: (app, restorer, translator) => {
        Palette.restore(app, restorer, translator);
    }
};
/**
 * The default window name resolver provider.
 */
const resolver = {
    id: '@jupyterlab/apputils-extension:resolver',
    description: 'Provides the window name resolver.',
    autoStart: true,
    provides: lib_index_js_.IWindowResolver,
    requires: [index_js_.JupyterFrontEnd.IPaths, index_js_.IRouter],
    activate: async (app, paths, router) => {
        const { hash, search } = router.current;
        const query = coreutils_lib_index_js_.URLExt.queryStringToObject(search || '');
        const solver = new lib_index_js_.WindowResolver();
        const workspace = coreutils_lib_index_js_.PageConfig.getOption('workspace');
        const treePath = coreutils_lib_index_js_.PageConfig.getOption('treePath');
        const mode = coreutils_lib_index_js_.PageConfig.getOption('mode') === 'multiple-document' ? 'lab' : 'doc';
        // This is used as a key in local storage to refer to workspaces, either the name
        // of the workspace or the string PageConfig.defaultWorkspace. Both lab and doc modes share the same workspace.
        const candidate = workspace ? workspace : coreutils_lib_index_js_.PageConfig.defaultWorkspace;
        const rest = treePath ? coreutils_lib_index_js_.URLExt.join('tree', treePath) : '';
        try {
            await solver.resolve(candidate);
            return solver;
        }
        catch (error) {
            // Window resolution has failed so the URL must change. Return a promise
            // that never resolves to prevent the application from loading plugins
            // that rely on `IWindowResolver`.
            return new Promise(() => {
                const { base } = paths.urls;
                const pool = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789';
                const random = pool[Math.floor(Math.random() * pool.length)];
                let path = coreutils_lib_index_js_.URLExt.join(base, mode, 'workspaces', `auto-${random}`);
                path = rest ? coreutils_lib_index_js_.URLExt.join(path, coreutils_lib_index_js_.URLExt.encodeParts(rest)) : path;
                // Reset the workspace on load.
                query['reset'] = '';
                const url = path + coreutils_lib_index_js_.URLExt.objectToQueryString(query) + (hash || '');
                router.navigate(url, { hard: true });
            });
        }
    }
};
/**
 * The default splash screen provider.
 */
const splash = {
    id: '@jupyterlab/apputils-extension:splash',
    description: 'Provides the splash screen.',
    autoStart: true,
    requires: [translation_lib_index_js_.ITranslator],
    provides: lib_index_js_.ISplashScreen,
    activate: (app, translator) => {
        const trans = translator.load('jupyterlab');
        const { commands, restored } = app;
        // Create splash element and populate it.
        const splash = document.createElement('div');
        const galaxy = document.createElement('div');
        const logo = document.createElement('div');
        splash.id = 'jupyterlab-splash';
        galaxy.id = 'galaxy';
        logo.id = 'main-logo';
        ui_components_lib_index_js_.jupyterFaviconIcon.element({
            container: logo,
            stylesheet: 'splash'
        });
        galaxy.appendChild(logo);
        ['1', '2', '3'].forEach(id => {
            const moon = document.createElement('div');
            const planet = document.createElement('div');
            moon.id = `moon${id}`;
            moon.className = 'moon orbit';
            planet.id = `planet${id}`;
            planet.className = 'planet';
            moon.appendChild(planet);
            galaxy.appendChild(moon);
        });
        splash.appendChild(galaxy);
        // Create debounced recovery dialog function.
        let dialog;
        const recovery = new dist_index_es6_js_.Throttler(async () => {
            if (dialog) {
                return;
            }
            dialog = new lib_index_js_.Dialog({
                title: trans.__('Loading…'),
                body: trans.__(`The loading screen is taking a long time.
Would you like to clear the workspace or keep waiting?`),
                buttons: [
                    lib_index_js_.Dialog.cancelButton({ label: trans.__('Keep Waiting') }),
                    lib_index_js_.Dialog.warnButton({ label: trans.__('Clear Workspace') })
                ]
            });
            try {
                const result = await dialog.launch();
                dialog.dispose();
                dialog = null;
                if (result.button.accept && commands.hasCommand(lib_CommandIDs.reset)) {
                    return commands.execute(lib_CommandIDs.reset);
                }
                // Re-invoke the recovery timer in the next frame.
                requestAnimationFrame(() => {
                    // Because recovery can be stopped, handle invocation rejection.
                    void recovery.invoke().catch(_ => undefined);
                });
            }
            catch (error) {
                /* no-op */
            }
        }, { limit: SPLASH_RECOVER_TIMEOUT, edge: 'trailing' });
        // Return ISplashScreen.
        let splashCount = 0;
        return {
            show: (light = true) => {
                splash.classList.remove('splash-fade');
                splash.classList.toggle('light', light);
                splash.classList.toggle('dark', !light);
                splashCount++;
                document.body.appendChild(splash);
                // Because recovery can be stopped, handle invocation rejection.
                void recovery.invoke().catch(_ => undefined);
                return new index_es6_js_.DisposableDelegate(async () => {
                    await restored;
                    if (--splashCount === 0) {
                        void recovery.stop();
                        if (dialog) {
                            dialog.dispose();
                            dialog = null;
                        }
                        splash.classList.add('splash-fade');
                        window.setTimeout(() => {
                            document.body.removeChild(splash);
                        }, 200);
                    }
                });
            }
        };
    }
};
const print = {
    id: '@jupyterlab/apputils-extension:print',
    description: 'Add the print capability',
    autoStart: true,
    requires: [translation_lib_index_js_.ITranslator],
    activate: (app, translator) => {
        var _a;
        const trans = translator.load('jupyterlab');
        app.commands.addCommand(lib_CommandIDs.print, {
            label: trans.__('Print…'),
            isEnabled: () => {
                const widget = app.shell.currentWidget;
                return lib_index_js_.Printing.getPrintFunction(widget) !== null;
            },
            execute: async () => {
                const widget = app.shell.currentWidget;
                const printFunction = lib_index_js_.Printing.getPrintFunction(widget);
                if (printFunction) {
                    await printFunction();
                }
            }
        });
        (_a = app.shell.currentChanged) === null || _a === void 0 ? void 0 : _a.connect(() => {
            app.commands.notifyCommandChanged(lib_CommandIDs.print);
        });
    }
};
const toggleHeader = {
    id: '@jupyterlab/apputils-extension:toggle-header',
    description: 'Adds a command to display the main area widget content header.',
    autoStart: true,
    requires: [translation_lib_index_js_.ITranslator],
    optional: [lib_index_js_.ICommandPalette],
    activate: (app, translator, palette) => {
        var _a;
        const trans = translator.load('jupyterlab');
        const category = trans.__('Main Area');
        app.commands.addCommand(lib_CommandIDs.toggleHeader, {
            label: trans.__('Show Header Above Content'),
            isEnabled: () => app.shell.currentWidget instanceof lib_index_js_.MainAreaWidget &&
                !app.shell.currentWidget.contentHeader.isDisposed &&
                app.shell.currentWidget.contentHeader.widgets.length > 0,
            isToggled: () => {
                const widget = app.shell.currentWidget;
                return widget instanceof lib_index_js_.MainAreaWidget
                    ? !widget.contentHeader.isHidden
                    : false;
            },
            execute: async () => {
                const widget = app.shell.currentWidget;
                if (widget instanceof lib_index_js_.MainAreaWidget) {
                    widget.contentHeader.setHidden(!widget.contentHeader.isHidden);
                }
            }
        });
        (_a = app.shell.currentChanged) === null || _a === void 0 ? void 0 : _a.connect(() => {
            app.commands.notifyCommandChanged(lib_CommandIDs.toggleHeader);
        });
        if (palette) {
            palette.addItem({ command: lib_CommandIDs.toggleHeader, category });
        }
    }
};
/**
 * Update the browser title based on the workspace and the current
 * active item.
 */
async function updateTabTitle(workspace, db, name) {
    var _a, _b;
    const data = await db.toJSON();
    let current = (_b = (_a = data['layout-restorer:data']) === null || _a === void 0 ? void 0 : _a.main) === null || _b === void 0 ? void 0 : _b.current;
    if (current === undefined ||
        !(current.startsWith('notebook') || current.startsWith('editor'))) {
        document.title = `${coreutils_lib_index_js_.PageConfig.getOption('appName') || 'JupyterLab'}${workspace === 'default' ? '' : ` (${workspace})`}`;
    }
    else {
        // File name from current path
        let currentFile = coreutils_lib_index_js_.PathExt.basename(decodeURIComponent(window.location.href));
        // Truncate to first 12 characters of current document name + ... if length > 15
        currentFile =
            currentFile.length > 15
                ? currentFile.slice(0, 12).concat(`…`)
                : currentFile;
        workspace =
            workspace.length > 15 ? workspace.slice(0, 12).concat(`…`) : workspace;
        // Number of restorable items that are either notebooks or editors
        const count = Object.keys(data).filter(item => item.startsWith('notebook') || item.startsWith('editor')).length;
        document.title = `${currentFile}${count > 1 ? ` (${count})` : ``} - ${workspace === 'default' ? name : workspace}`;
    }
}
/**
 * The default state database for storing application state.
 *
 * #### Notes
 * If this extension is loaded with a window resolver, it will automatically add
 * state management commands, URL support for `clone` and `reset`, and workspace
 * auto-saving. Otherwise, it will return a simple in-memory state database.
 */
const state = {
    id: '@jupyterlab/apputils-extension:state',
    description: 'Provides the application state. It is stored per workspaces.',
    autoStart: true,
    provides: statedb_lib_index_js_.IStateDB,
    requires: [index_js_.JupyterFrontEnd.IPaths, index_js_.IRouter, translation_lib_index_js_.ITranslator],
    optional: [lib_index_js_.IWindowResolver],
    activate: (app, paths, router, translator, resolver) => {
        const trans = translator.load('jupyterlab');
        if (resolver === null) {
            return new statedb_lib_index_js_.StateDB();
        }
        let resolved = false;
        const { commands, name, serviceManager } = app;
        const { workspaces } = serviceManager;
        const workspace = resolver.name;
        const transform = new dist_index_js_.PromiseDelegate();
        const db = new statedb_lib_index_js_.StateDB({ transform: transform.promise });
        const save = new dist_index_es6_js_.Debouncer(async () => {
            const id = workspace;
            const metadata = { id };
            const data = await db.toJSON();
            await workspaces.save(id, { data, metadata });
        });
        // Any time the local state database changes, save the workspace.
        db.changed.connect(() => void save.invoke(), db);
        db.changed.connect(() => updateTabTitle(workspace, db, name));
        commands.addCommand(lib_CommandIDs.loadState, {
            label: trans.__('Load state for the current workspace.'),
            execute: async (args) => {
                // Since the command can be executed an arbitrary number of times, make
                // sure it is safe to call multiple times.
                if (resolved) {
                    return;
                }
                const { hash, path, search } = args;
                const query = coreutils_lib_index_js_.URLExt.queryStringToObject(search || '');
                const clone = typeof query['clone'] === 'string'
                    ? query['clone'] === ''
                        ? coreutils_lib_index_js_.PageConfig.defaultWorkspace
                        : query['clone']
                    : null;
                const source = clone || workspace || null;
                if (source === null) {
                    console.error(`${lib_CommandIDs.loadState} cannot load null workspace.`);
                    return;
                }
                try {
                    const saved = await workspaces.fetch(source);
                    // If this command is called after a reset, the state database
                    // will already be resolved.
                    if (!resolved) {
                        resolved = true;
                        transform.resolve({ type: 'overwrite', contents: saved.data });
                    }
                }
                catch ({ message }) {
                    console.warn(`Fetching workspace "${workspace}" failed.`, message);
                    // If the workspace does not exist, cancel the data transformation
                    // and save a workspace with the current user state data.
                    if (!resolved) {
                        resolved = true;
                        transform.resolve({ type: 'cancel', contents: null });
                    }
                }
                if (source === clone) {
                    // Maintain the query string parameters but remove `clone`.
                    delete query['clone'];
                    const url = path + coreutils_lib_index_js_.URLExt.objectToQueryString(query) + hash;
                    const cloned = save.invoke().then(() => router.stop);
                    // After the state has been cloned, navigate to the URL.
                    void cloned.then(() => {
                        router.navigate(url);
                    });
                    return cloned;
                }
                // After the state database has finished loading, save it.
                await save.invoke();
            }
        });
        commands.addCommand(lib_CommandIDs.reset, {
            label: trans.__('Reset Application State'),
            execute: async ({ reload }) => {
                await db.clear();
                await save.invoke();
                if (reload) {
                    router.reload();
                }
            }
        });
        commands.addCommand(lib_CommandIDs.resetOnLoad, {
            label: trans.__('Reset state when loading for the workspace.'),
            execute: (args) => {
                const { hash, path, search } = args;
                const query = coreutils_lib_index_js_.URLExt.queryStringToObject(search || '');
                const reset = 'reset' in query;
                const clone = 'clone' in query;
                if (!reset) {
                    return;
                }
                // If the state database has already been resolved, resetting is
                // impossible without reloading.
                if (resolved) {
                    return router.reload();
                }
                // Empty the state database.
                resolved = true;
                transform.resolve({ type: 'clear', contents: null });
                // Maintain the query string parameters but remove `reset`.
                delete query['reset'];
                const url = path + coreutils_lib_index_js_.URLExt.objectToQueryString(query) + hash;
                const cleared = db.clear().then(() => save.invoke());
                // After the state has been reset, navigate to the URL.
                if (clone) {
                    void cleared.then(() => {
                        router.navigate(url, { hard: true });
                    });
                }
                else {
                    void cleared.then(() => {
                        router.navigate(url);
                    });
                }
                return cleared;
            }
        });
        router.register({
            command: lib_CommandIDs.loadState,
            pattern: /.?/,
            rank: 30 // High priority: 30:100.
        });
        router.register({
            command: lib_CommandIDs.resetOnLoad,
            pattern: /(\?reset|\&reset)($|&)/,
            rank: 20 // High priority: 20:100.
        });
        return db;
    }
};
/**
 * The default session context dialogs extension.
 */
const sessionDialogs = {
    id: '@jupyterlab/apputils-extension:sessionDialogs',
    description: 'Provides the session context dialogs.',
    provides: lib_index_js_.ISessionContextDialogs,
    optional: [translation_lib_index_js_.ITranslator, settingregistry_lib_index_js_.ISettingRegistry],
    autoStart: true,
    activate: async (app, translator, settingRegistry) => {
        return new lib_index_js_.SessionContextDialogs({
            translator: translator !== null && translator !== void 0 ? translator : translation_lib_index_js_.nullTranslator,
            settingRegistry: settingRegistry !== null && settingRegistry !== void 0 ? settingRegistry : null
        });
    }
};
/**
 * Utility commands
 */
const utilityCommands = {
    id: '@jupyterlab/apputils-extension:utilityCommands',
    description: 'Adds meta commands to run set of other commands.',
    requires: [translation_lib_index_js_.ITranslator],
    optional: [lib_index_js_.ICommandPalette],
    autoStart: true,
    activate: (app, translator, palette) => {
        const trans = translator.load('jupyterlab');
        const { commands } = app;
        commands.addCommand(lib_CommandIDs.runFirstEnabled, {
            label: trans.__('Run First Enabled Command'),
            execute: args => {
                const commands = args.commands;
                const commandArgs = args.args;
                const argList = Array.isArray(args);
                for (let i = 0; i < commands.length; i++) {
                    const cmd = commands[i];
                    const arg = argList ? commandArgs[i] : commandArgs;
                    if (app.commands.isEnabled(cmd, arg)) {
                        return app.commands.execute(cmd, arg);
                    }
                }
            }
        });
        // Add a command for taking lists of commands and command arguments
        // and running all the enabled commands.
        commands.addCommand(lib_CommandIDs.runAllEnabled, {
            label: trans.__('Run All Enabled Commands Passed as Args'),
            execute: async (args) => {
                var _a, _b;
                const commands = (_a = args.commands) !== null && _a !== void 0 ? _a : [];
                const commandArgs = args.args;
                const argList = Array.isArray(args);
                const errorIfNotEnabled = (_b = args.errorIfNotEnabled) !== null && _b !== void 0 ? _b : false;
                for (let i = 0; i < commands.length; i++) {
                    const cmd = commands[i];
                    const arg = argList ? commandArgs[i] : commandArgs;
                    if (app.commands.isEnabled(cmd, arg)) {
                        await app.commands.execute(cmd, arg);
                    }
                    else {
                        if (errorIfNotEnabled) {
                            console.error(`${cmd} is not enabled.`);
                        }
                    }
                }
            },
            isEnabled: args => {
                var _a;
                const commands = (_a = args.commands) !== null && _a !== void 0 ? _a : [];
                const commandArgs = args.args;
                const argList = Array.isArray(args);
                return commands.some((cmd, idx) => app.commands.isEnabled(cmd, argList ? commandArgs[idx] : commandArgs));
            }
        });
        commands.addCommand(lib_CommandIDs.displayShortcuts, {
            label: trans.__('Show Keyboard Shortcuts…'),
            caption: trans.__('Show relevant keyboard shortcuts for the current active widget'),
            execute: args => {
                var _a;
                const currentWidget = app.shell.currentWidget;
                const included = currentWidget === null || currentWidget === void 0 ? void 0 : currentWidget.node.contains(document.activeElement);
                if (!included && currentWidget instanceof lib_index_js_.MainAreaWidget) {
                    const currentNode = (_a = currentWidget.content.node) !== null && _a !== void 0 ? _a : currentWidget === null || currentWidget === void 0 ? void 0 : currentWidget.node;
                    currentNode === null || currentNode === void 0 ? void 0 : currentNode.focus();
                }
                const options = { commands, trans };
                return displayShortcuts(options);
            }
        });
        if (palette) {
            const category = trans.__('Help');
            palette.addItem({ command: lib_CommandIDs.displayShortcuts, category });
        }
    }
};
/**
 * The default HTML sanitizer.
 */
const sanitizer = {
    id: '@jupyterlab/apputils-extension:sanitizer',
    description: 'Provides the HTML sanitizer.',
    autoStart: true,
    provides: lib_index_js_.ISanitizer,
    requires: [settingregistry_lib_index_js_.ISettingRegistry],
    activate: (app, settings) => {
        const sanitizer = new lib_index_js_.Sanitizer();
        const loadSetting = (setting) => {
            const allowedSchemes = setting.get('allowedSchemes')
                .composite;
            const autolink = setting.get('autolink').composite;
            const allowNamedProperties = setting.get('allowNamedProperties')
                .composite;
            if (allowedSchemes) {
                sanitizer.setAllowedSchemes(allowedSchemes);
            }
            sanitizer.setAutolink(autolink);
            sanitizer.setAllowNamedProperties(allowNamedProperties);
        };
        // Wait for the application to be restored and
        // for the settings for this plugin to be loaded
        settings
            .load('@jupyterlab/apputils-extension:sanitizer')
            .then(setting => {
            // Read the settings
            loadSetting(setting);
            // Listen for your plugin setting changes using Signal
            setting.changed.connect(loadSetting);
        })
            .catch(reason => {
            console.error(`Failed to load sanitizer settings:`, reason);
        });
        return sanitizer;
    }
};
/*
 * A plugin owning the kernel settings
 */
const kernelSettings = {
    id: '@jupyterlab/apputils-extension:kernels-settings',
    description: 'Reserves the name for kernel settings.',
    autoStart: true,
    requires: [settingregistry_lib_index_js_.ISettingRegistry],
    activate: (_app, settingRegistry) => {
        void settingRegistry.load(kernelSettings.id);
    }
};
/**
 * Export the plugins as default.
 */
const plugins = [
    kernelSettings,
    announcements,
    kernelStatus,
    licensesClient,
    licensesPlugin,
    notificationPlugin,
    palette,
    paletteRestorer,
    print,
    resolver,
    runningSessionsStatus,
    subshellsSettings,
    sanitizer,
    settingsConnector,
    settingsPlugin,
    state,
    splash,
    sessionDialogs,
    themesPlugin,
    themesPaletteMenuPlugin,
    toggleHeader,
    toolbarRegistry,
    utilityCommands,
    workspacesPlugin
];
/* harmony default export */ const lib = (plugins);
//# sourceMappingURL=index.js.map

/***/ }),

/***/ 82649:
/***/ ((__unused_webpack_module, __unused_webpack___webpack_exports__, __webpack_require__) => {

"use strict";

// EXTERNAL MODULE: ../node_modules/@lumino/widgets/style/index.js + 1 modules
var style = __webpack_require__(20959);
// EXTERNAL MODULE: ../node_modules/@jupyterlab/ui-components/style/index.js + 1 modules
var ui_components_style = __webpack_require__(26238);
// EXTERNAL MODULE: ../node_modules/@jupyterlab/statusbar/style/index.js + 1 modules
var statusbar_style = __webpack_require__(25066);
// EXTERNAL MODULE: ../node_modules/@jupyterlab/apputils/style/index.js + 1 modules
var apputils_style = __webpack_require__(57261);
// EXTERNAL MODULE: ../node_modules/@jupyterlab/docregistry/style/index.js + 1 modules
var docregistry_style = __webpack_require__(30507);
// EXTERNAL MODULE: ../node_modules/@jupyterlab/application/style/index.js + 1 modules
var application_style = __webpack_require__(67663);
// EXTERNAL MODULE: ../node_modules/@jupyterlab/mainmenu/style/index.js
var mainmenu_style = __webpack_require__(70022);
// EXTERNAL MODULE: ../node_modules/@jupyterlab/builder/node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js
var injectStylesIntoStyleTag = __webpack_require__(94830);
var injectStylesIntoStyleTag_default = /*#__PURE__*/__webpack_require__.n(injectStylesIntoStyleTag);
// EXTERNAL MODULE: ../node_modules/@jupyterlab/builder/node_modules/style-loader/dist/runtime/styleDomAPI.js
var styleDomAPI = __webpack_require__(80592);
var styleDomAPI_default = /*#__PURE__*/__webpack_require__.n(styleDomAPI);
// EXTERNAL MODULE: ../node_modules/@jupyterlab/builder/node_modules/style-loader/dist/runtime/insertBySelector.js
var insertBySelector = __webpack_require__(99763);
var insertBySelector_default = /*#__PURE__*/__webpack_require__.n(insertBySelector);
// EXTERNAL MODULE: ../node_modules/@jupyterlab/builder/node_modules/style-loader/dist/runtime/setAttributesWithoutAttributes.js
var setAttributesWithoutAttributes = __webpack_require__(28915);
var setAttributesWithoutAttributes_default = /*#__PURE__*/__webpack_require__.n(setAttributesWithoutAttributes);
// EXTERNAL MODULE: ../node_modules/@jupyterlab/builder/node_modules/style-loader/dist/runtime/insertStyleElement.js
var insertStyleElement = __webpack_require__(80366);
var insertStyleElement_default = /*#__PURE__*/__webpack_require__.n(insertStyleElement);
// EXTERNAL MODULE: ../node_modules/@jupyterlab/builder/node_modules/style-loader/dist/runtime/styleTagTransform.js
var styleTagTransform = __webpack_require__(17352);
var styleTagTransform_default = /*#__PURE__*/__webpack_require__.n(styleTagTransform);
// EXTERNAL MODULE: ../node_modules/@jupyterlab/builder/node_modules/css-loader/dist/cjs.js!../node_modules/@jupyterlab/apputils-extension/style/base.css
var base = __webpack_require__(92606);
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/apputils-extension/style/base.css

      
      
      
      
      
      
      
      
      

var options = {};

options.styleTagTransform = (styleTagTransform_default());
options.setAttributes = (setAttributesWithoutAttributes_default());

      options.insert = insertBySelector_default().bind(null, "head");
    
options.domAPI = (styleDomAPI_default());
options.insertStyleElement = (insertStyleElement_default());

var update = injectStylesIntoStyleTag_default()(base/* default */.Z, options);




       /* harmony default export */ const style_base = (base/* default */.Z && base/* default */.Z.locals ? base/* default */.Z.locals : undefined);

;// CONCATENATED MODULE: ../node_modules/@jupyterlab/apputils-extension/style/index.js
/*-----------------------------------------------------------------------------
| Copyright (c) Jupyter Development Team.
| Distributed under the terms of the Modified BSD License.
|----------------------------------------------------------------------------*/

/* This file was auto-generated by ensurePackage() in @jupyterlab/buildutils */











/***/ }),

/***/ 13296:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
// ESM COMPAT FLAG
__webpack_require__.r(__webpack_exports__);

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  Clipboard: () => (/* reexport */ Clipboard),
  Collapse: () => (/* reexport */ index_js_.Collapser),
  CommandLinker: () => (/* reexport */ CommandLinker),
  CommandToolbarButton: () => (/* reexport */ index_js_.CommandToolbarButton),
  CommandToolbarButtonComponent: () => (/* reexport */ index_js_.CommandToolbarButtonComponent),
  DOMUtils: () => (/* reexport */ DOMUtils),
  Dialog: () => (/* reexport */ Dialog),
  HoverBox: () => (/* reexport */ index_js_.HoverBox),
  ICommandPalette: () => (/* reexport */ ICommandPalette),
  IFrame: () => (/* reexport */ index_js_.IFrame),
  IKernelStatusModel: () => (/* reexport */ IKernelStatusModel),
  ILicensesClient: () => (/* reexport */ ILicensesClient),
  ISanitizer: () => (/* reexport */ ISanitizer),
  ISessionContextDialogs: () => (/* reexport */ ISessionContextDialogs),
  ISplashScreen: () => (/* reexport */ ISplashScreen),
  IThemeManager: () => (/* reexport */ IThemeManager),
  IToolbarWidgetRegistry: () => (/* reexport */ IToolbarWidgetRegistry),
  IWindowResolver: () => (/* reexport */ IWindowResolver),
  InputDialog: () => (/* reexport */ InputDialog),
  KernelStatus: () => (/* reexport */ KernelStatus),
  Licenses: () => (/* reexport */ Licenses),
  MainAreaWidget: () => (/* reexport */ MainAreaWidget),
  MenuFactory: () => (/* reexport */ MenuFactory),
  ModalCommandPalette: () => (/* reexport */ ModalCommandPalette),
  Notification: () => (/* reexport */ Notification),
  NotificationManager: () => (/* reexport */ NotificationManager),
  Printing: () => (/* reexport */ Printing),
  ReactWidget: () => (/* reexport */ index_js_.ReactWidget),
  RunningSessions: () => (/* reexport */ RunningSessions),
  Sanitizer: () => (/* reexport */ Sanitizer),
  SemanticCommand: () => (/* reexport */ SemanticCommand),
  SessionContext: () => (/* reexport */ SessionContext),
  SessionContextDialogs: () => (/* reexport */ SessionContextDialogs),
  Spinner: () => (/* reexport */ index_js_.Spinner),
  Styling: () => (/* reexport */ index_js_.Styling),
  ThemeManager: () => (/* reexport */ ThemeManager),
  Toolbar: () => (/* binding */ Toolbar),
  ToolbarButton: () => (/* reexport */ index_js_.ToolbarButton),
  ToolbarButtonComponent: () => (/* reexport */ index_js_.ToolbarButtonComponent),
  ToolbarWidgetRegistry: () => (/* reexport */ ToolbarWidgetRegistry),
  UseSignal: () => (/* reexport */ index_js_.UseSignal),
  VDomModel: () => (/* reexport */ index_js_.VDomModel),
  VDomRenderer: () => (/* reexport */ index_js_.VDomRenderer),
  WidgetTracker: () => (/* reexport */ WidgetTracker),
  WindowResolver: () => (/* reexport */ WindowResolver),
  addCommandToolbarButtonClass: () => (/* reexport */ index_js_.addCommandToolbarButtonClass),
  addToolbarButtonClass: () => (/* reexport */ index_js_.addToolbarButtonClass),
  createDefaultFactory: () => (/* reexport */ createDefaultFactory),
  createToolbarFactory: () => (/* reexport */ createToolbarFactory),
  setToolbar: () => (/* reexport */ setToolbar),
  showDialog: () => (/* reexport */ showDialog),
  showErrorMessage: () => (/* reexport */ showErrorMessage),
  translateKernelStatuses: () => (/* reexport */ translateKernelStatuses)
});

// EXTERNAL MODULE: consume shared module (default) @jupyterlab/ui-components@~4.4.5 (singleton) (fallback: ../node_modules/@jupyterlab/ui-components/lib/index.js)
var index_js_ = __webpack_require__(52104);
// EXTERNAL MODULE: consume shared module (default) @jupyterlab/translation@~4.4.5 (singleton) (fallback: ../node_modules/@jupyterlab/translation/lib/index.js)
var lib_index_js_ = __webpack_require__(38202);
// EXTERNAL MODULE: consume shared module (default) @lumino/widgets@~2.7.1 (singleton) (fallback: ../node_modules/@lumino/widgets/dist/index.es6.js)
var index_es6_js_ = __webpack_require__(60920);
// EXTERNAL MODULE: consume shared module (default) react@~18.2.0 (singleton) (fallback: ../node_modules/react/index.js)
var react_index_js_ = __webpack_require__(78156);
var react_index_js_default = /*#__PURE__*/__webpack_require__.n(react_index_js_);
// EXTERNAL MODULE: consume shared module (default) @jupyterlab/coreutils@~6.4.5 (singleton) (fallback: ../node_modules/@jupyterlab/coreutils/lib/index.js)
var coreutils_lib_index_js_ = __webpack_require__(24474);
// EXTERNAL MODULE: consume shared module (default) @lumino/algorithm@~2.0.3 (singleton) (fallback: ../node_modules/@lumino/algorithm/dist/index.es6.js)
var dist_index_es6_js_ = __webpack_require__(56114);
// EXTERNAL MODULE: consume shared module (default) @lumino/coreutils@~2.2.1 (singleton) (fallback: ../node_modules/@lumino/coreutils/dist/index.js)
var dist_index_js_ = __webpack_require__(5406);
// EXTERNAL MODULE: consume shared module (default) @lumino/signaling@~2.1.4 (singleton) (fallback: ../node_modules/@lumino/signaling/dist/index.es6.js)
var signaling_dist_index_es6_js_ = __webpack_require__(2536);
// EXTERNAL MODULE: consume shared module (default) @lumino/messaging@~2.0.3 (singleton) (fallback: ../node_modules/@lumino/messaging/dist/index.es6.js)
var messaging_dist_index_es6_js_ = __webpack_require__(34993);
// EXTERNAL MODULE: consume shared module (default) @jupyterlab/statedb@~4.4.5 (singleton) (fallback: ../node_modules/@jupyterlab/statedb/lib/index.js)
var statedb_lib_index_js_ = __webpack_require__(68145);
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/apputils/lib/widgettracker.js
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.



/**
 * A class that keeps track of widget instances on an Application shell.
 *
 * @typeparam T - The type of widget being tracked. Defaults to `Widget`.
 *
 * #### Notes
 * The API surface area of this concrete implementation is substantially larger
 * than the widget tracker interface it implements. The interface is intended
 * for export by JupyterLab plugins that create widgets and have clients who may
 * wish to keep track of newly created widgets. This class, however, can be used
 * internally by plugins to restore state as well.
 */
class WidgetTracker {
    /**
     * Create a new widget tracker.
     *
     * @param options - The instantiation options for a widget tracker.
     */
    constructor(options) {
        this._currentChanged = new signaling_dist_index_es6_js_.Signal(this);
        this._deferred = null;
        this._isDisposed = false;
        this._widgetAdded = new signaling_dist_index_es6_js_.Signal(this);
        this._widgetUpdated = new signaling_dist_index_es6_js_.Signal(this);
        const focus = (this._focusTracker = new index_es6_js_.FocusTracker());
        const pool = (this._pool = new statedb_lib_index_js_.RestorablePool(options));
        this.namespace = options.namespace;
        focus.currentChanged.connect((_, current) => {
            if (current.newValue !== this.currentWidget) {
                pool.current = current.newValue;
            }
        }, this);
        pool.added.connect((_, widget) => {
            this._widgetAdded.emit(widget);
        }, this);
        pool.currentChanged.connect((_, widget) => {
            // If the pool's current reference is `null` but the focus tracker has a
            // current widget, update the pool to match the focus tracker.
            if (widget === null && focus.currentWidget) {
                pool.current = focus.currentWidget;
                return;
            }
            this.onCurrentChanged(widget);
            this._currentChanged.emit(widget);
        }, this);
        pool.updated.connect((_, widget) => {
            this._widgetUpdated.emit(widget);
        }, this);
    }
    /**
     * A signal emitted when the current widget changes.
     */
    get currentChanged() {
        return this._currentChanged;
    }
    /**
     * The current widget is the most recently focused or added widget.
     *
     * #### Notes
     * It is the most recently focused widget, or the most recently added
     * widget if no widget has taken focus.
     */
    get currentWidget() {
        return this._pool.current || null;
    }
    /**
     * A promise resolved when the tracker has been restored.
     */
    get restored() {
        if (this._deferred) {
            return Promise.resolve();
        }
        else {
            return this._pool.restored;
        }
    }
    /**
     * The number of widgets held by the tracker.
     */
    get size() {
        return this._pool.size;
    }
    /**
     * A signal emitted when a widget is added.
     *
     * #### Notes
     * This signal will only fire when a widget is added to the tracker. It will
     * not fire if a widget is injected into the tracker.
     */
    get widgetAdded() {
        return this._widgetAdded;
    }
    /**
     * A signal emitted when a widget is updated.
     */
    get widgetUpdated() {
        return this._widgetUpdated;
    }
    /**
     * Add a new widget to the tracker.
     *
     * @param widget - The widget being added.
     *
     * #### Notes
     * The widget passed into the tracker is added synchronously; its existence in
     * the tracker can be checked with the `has()` method. The promise this method
     * returns resolves after the widget has been added and saved to an underlying
     * restoration connector, if one is available.
     *
     * The newly added widget becomes the current widget unless the focus tracker
     * already had a focused widget.
     */
    async add(widget) {
        this._focusTracker.add(widget);
        await this._pool.add(widget);
        if (!this._focusTracker.activeWidget) {
            this._pool.current = widget;
        }
    }
    /**
     * Test whether the tracker is disposed.
     */
    get isDisposed() {
        return this._isDisposed;
    }
    /**
     * Dispose of the resources held by the tracker.
     */
    dispose() {
        if (this.isDisposed) {
            return;
        }
        this._isDisposed = true;
        this._pool.dispose();
        this._focusTracker.dispose();
        signaling_dist_index_es6_js_.Signal.clearData(this);
    }
    /**
     * Find the first widget in the tracker that satisfies a filter function.
     *
     * @param fn The filter function to call on each widget.
     *
     * #### Notes
     * If no widget is found, the value returned is `undefined`.
     */
    find(fn) {
        return this._pool.find(fn);
    }
    /**
     * Iterate through each widget in the tracker.
     *
     * @param fn - The function to call on each widget.
     */
    forEach(fn) {
        return this._pool.forEach(fn);
    }
    /**
     * Filter the widgets in the tracker based on a predicate.
     *
     * @param fn - The function by which to filter.
     */
    filter(fn) {
        return this._pool.filter(fn);
    }
    /**
     * Inject a foreign widget into the widget tracker.
     *
     * @param widget - The widget to inject into the tracker.
     *
     * #### Notes
     * Injected widgets will not have their state saved by the tracker.
     *
     * The primary use case for widget injection is for a plugin that offers a
     * sub-class of an extant plugin to have its instances share the same commands
     * as the parent plugin (since most relevant commands will use the
     * `currentWidget` of the parent plugin's widget tracker). In this situation,
     * the sub-class plugin may well have its own widget tracker for layout and
     * state restoration in addition to injecting its widgets into the parent
     * plugin's widget tracker.
     */
    inject(widget) {
        return this._pool.inject(widget);
    }
    /**
     * Check if this tracker has the specified widget.
     *
     * @param widget - The widget whose existence is being checked.
     */
    has(widget) {
        return this._pool.has(widget);
    }
    /**
     * Restore the widgets in this tracker's namespace.
     *
     * @param options - The configuration options that describe restoration.
     *
     * @returns A promise that resolves when restoration has completed.
     *
     * #### Notes
     * This function should not typically be invoked by client code.
     * Its primary use case is to be invoked by a restorer.
     */
    async restore(options) {
        const deferred = this._deferred;
        if (deferred) {
            this._deferred = null;
            return this._pool.restore(deferred);
        }
        if (options) {
            return this._pool.restore(options);
        }
        console.warn('No options provided to restore the tracker.');
    }
    /**
     * Save the restore options for this tracker, but do not restore yet.
     *
     * @param options - The configuration options that describe restoration.
     *
     * ### Notes
     * This function is useful when starting the shell in 'single-document' mode,
     * to avoid restoring all useless widgets. It should not ordinarily be called
     * by client code.
     */
    defer(options) {
        this._deferred = options;
    }
    /**
     * Save the restore data for a given widget.
     *
     * @param widget - The widget being saved.
     */
    async save(widget) {
        return this._pool.save(widget);
    }
    /**
     * Handle the current change event.
     *
     * #### Notes
     * The default implementation is a no-op.
     */
    onCurrentChanged(value) {
        /* no-op */
    }
}
//# sourceMappingURL=widgettracker.js.map
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/apputils/lib/dialog.js
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.








/**
 * Create and show a dialog.
 *
 * @param options - The dialog setup options.
 *
 * @returns A promise that resolves with whether the dialog was accepted.
 */
function showDialog(options = {}) {
    const dialog = new Dialog(options);
    return dialog.launch();
}
/**
 * Show an error message dialog.
 *
 * @param title - The title of the dialog box.
 *
 * @param error - the error to show in the dialog body (either a string
 *   or an object with a string `message` property).
 */
function showErrorMessage(title, error, buttons) {
    const trans = Dialog.translator.load('jupyterlab');
    buttons = buttons !== null && buttons !== void 0 ? buttons : [Dialog.cancelButton({ label: trans.__('Close') })];
    console.warn('Showing error:', error);
    // Cache promises to prevent multiple copies of identical dialogs showing
    // to the user.
    const body = typeof error === 'string' ? error : error.message;
    const key = title + '----' + body;
    const promise = Private.errorMessagePromiseCache.get(key);
    if (promise) {
        return promise;
    }
    else {
        const dialogPromise = showDialog({
            title: title,
            body: body,
            buttons: buttons
        }).then(() => {
            Private.errorMessagePromiseCache.delete(key);
        }, error => {
            // TODO: Use .finally() above when supported
            Private.errorMessagePromiseCache.delete(key);
            throw error;
        });
        Private.errorMessagePromiseCache.set(key, dialogPromise);
        return dialogPromise;
    }
}
/**
 * A modal dialog widget.
 */
class Dialog extends index_es6_js_.Widget {
    /**
     * Create a dialog panel instance.
     *
     * @param options - The dialog setup options.
     */
    constructor(options = {}) {
        const dialogNode = document.createElement('dialog');
        dialogNode.ariaModal = 'true';
        super({ node: dialogNode });
        this._hasValidationErrors = false;
        this._ready = new dist_index_js_.PromiseDelegate();
        this._focusNodeSelector = '';
        this.addClass('jp-Dialog');
        this.addClass('jp-ThemedContainer');
        const normalized = Private.handleOptions(options);
        const renderer = normalized.renderer;
        this._host = normalized.host;
        this._defaultButton = normalized.defaultButton;
        this._buttons = normalized.buttons;
        this._hasClose = normalized.hasClose;
        this._buttonNodes = this._buttons.map(b => renderer.createButtonNode(b));
        this._checkboxNode = null;
        this._lastMouseDownInDialog = false;
        if (normalized.checkbox) {
            const { label = '', caption = '', checked = false, className = '' } = normalized.checkbox;
            this._checkboxNode = renderer.createCheckboxNode({
                label,
                caption: caption !== null && caption !== void 0 ? caption : label,
                checked,
                className
            });
        }
        const layout = (this.layout = new index_es6_js_.PanelLayout());
        const content = new index_es6_js_.Panel();
        content.addClass('jp-Dialog-content');
        if (typeof options.body === 'string') {
            content.addClass('jp-Dialog-content-small');
            dialogNode.ariaLabel = [normalized.title, options.body].join(' ');
        }
        layout.addWidget(content);
        this._body = normalized.body;
        const header = renderer.createHeader(normalized.title, () => this.reject(), options);
        const body = renderer.createBody(normalized.body);
        const footer = renderer.createFooter(this._buttonNodes, this._checkboxNode);
        content.addWidget(header);
        content.addWidget(body);
        content.addWidget(footer);
        this._bodyWidget = body;
        this._primary = this._buttonNodes[this._defaultButton];
        this._focusNodeSelector = options.focusNodeSelector;
        // Add new dialogs to the tracker.
        void Dialog.tracker.add(this);
    }
    /**
     * A promise that resolves when the Dialog first rendering is done.
     */
    get ready() {
        return this._ready.promise;
    }
    /**
     * Dispose of the resources used by the dialog.
     */
    dispose() {
        const promise = this._promise;
        if (promise) {
            this._promise = null;
            promise.reject(void 0);
            dist_index_es6_js_.ArrayExt.removeFirstOf(Private.launchQueue, promise.promise);
        }
        super.dispose();
    }
    /**
     * Launch the dialog as a modal window.
     *
     * @returns a promise that resolves with the result of the dialog.
     */
    launch() {
        // Return the existing dialog if already open.
        if (this._promise) {
            return this._promise.promise;
        }
        const promise = (this._promise = new dist_index_js_.PromiseDelegate());
        const promises = Promise.all(Private.launchQueue);
        Private.launchQueue.push(this._promise.promise);
        return promises.then(() => {
            // Do not show Dialog if it was disposed of before it was at the front of the launch queue
            if (!this._promise) {
                return Promise.resolve({
                    button: Dialog.cancelButton(),
                    isChecked: null,
                    value: null
                });
            }
            index_es6_js_.Widget.attach(this, this._host);
            return promise.promise;
        });
    }
    /**
     * Resolve the current dialog.
     *
     * @param index - An optional index to the button to resolve.
     *
     * #### Notes
     * Will default to the defaultIndex.
     * Will resolve the current `show()` with the button value.
     * Will be a no-op if the dialog is not shown.
     */
    resolve(index) {
        if (!this._promise) {
            return;
        }
        if (index === undefined) {
            index = this._defaultButton;
        }
        this._resolve(this._buttons[index]);
    }
    /**
     * Reject the current dialog with a default reject value.
     *
     * #### Notes
     * Will be a no-op if the dialog is not shown.
     */
    reject() {
        if (!this._promise) {
            return;
        }
        this._resolve(Dialog.cancelButton());
    }
    /**
     * Handle the DOM events for the directory listing.
     *
     * @param event - The DOM event sent to the widget.
     *
     * #### Notes
     * This method implements the DOM `EventListener` interface and is
     * called in response to events on the panel's DOM node. It should
     * not be called directly by user code.
     */
    handleEvent(event) {
        switch (event.type) {
            case 'keydown':
                this._evtKeydown(event);
                break;
            case 'mousedown':
                this._evtMouseDown(event);
                break;
            case 'click':
                this._evtClick(event);
                break;
            case 'input':
                this._evtInput(event);
                break;
            case 'focus':
                this._evtFocus(event);
                break;
            case 'contextmenu':
                event.preventDefault();
                event.stopPropagation();
                break;
            default:
                break;
        }
    }
    /**
     *  A message handler invoked on an `'after-attach'` message.
     */
    onAfterAttach(msg) {
        const node = this.node;
        node.addEventListener('keydown', this, true);
        node.addEventListener('contextmenu', this, true);
        node.addEventListener('click', this, true);
        document.addEventListener('mousedown', this, true);
        document.addEventListener('focus', this, true);
        document.addEventListener('input', this, true);
        this._first = Private.findFirstFocusable(this.node);
        this._original = document.activeElement;
        const setFocus = () => {
            var _a;
            if (this._focusNodeSelector) {
                const body = this.node.querySelector('.jp-Dialog-body');
                const el = body === null || body === void 0 ? void 0 : body.querySelector(this._focusNodeSelector);
                if (el) {
                    this._primary = el;
                }
            }
            (_a = this._primary) === null || _a === void 0 ? void 0 : _a.focus();
            this._ready.resolve();
        };
        if (this._bodyWidget instanceof index_js_.ReactWidget &&
            this._bodyWidget.renderPromise !== undefined) {
            this._bodyWidget
                .renderPromise.then(() => {
                setFocus();
            })
                .catch(() => {
                console.error("Error while loading Dialog's body");
            });
        }
        else {
            setFocus();
        }
    }
    /**
     *  A message handler invoked on an `'after-detach'` message.
     */
    onAfterDetach(msg) {
        const node = this.node;
        node.removeEventListener('keydown', this, true);
        node.removeEventListener('contextmenu', this, true);
        node.removeEventListener('click', this, true);
        document.removeEventListener('focus', this, true);
        document.removeEventListener('mousedown', this, true);
        document.removeEventListener('input', this, true);
        this._original.focus();
    }
    /**
     * A message handler invoked on a `'close-request'` message.
     */
    onCloseRequest(msg) {
        if (this._promise) {
            this.reject();
        }
        super.onCloseRequest(msg);
    }
    /**
     * Handle the `'input'` event for dialog's children.
     *
     * @param event - The DOM event sent to the widget
     */
    _evtInput(_event) {
        this._hasValidationErrors = !!this.node.querySelector(':invalid');
        for (let i = 0; i < this._buttons.length; i++) {
            if (this._buttons[i].accept) {
                this._buttonNodes[i].disabled = this._hasValidationErrors;
            }
        }
    }
    /**
     * Handle the `'click'` event for a dialog button.
     *
     * @param event - The DOM event sent to the widget
     */
    _evtClick(event) {
        const content = this.node.getElementsByClassName('jp-Dialog-content')[0];
        if (!content.contains(event.target)) {
            event.stopPropagation();
            event.preventDefault();
            if (this._hasClose && !this._lastMouseDownInDialog) {
                this.reject();
            }
            return;
        }
        for (const buttonNode of this._buttonNodes) {
            if (buttonNode.contains(event.target)) {
                const index = this._buttonNodes.indexOf(buttonNode);
                this.resolve(index);
            }
        }
    }
    /**
     * Handle the `'keydown'` event for the widget.
     *
     * @param event - The DOM event sent to the widget
     */
    _evtKeydown(event) {
        // Check for escape key
        switch (event.keyCode) {
            case 27: // Escape.
                event.stopPropagation();
                event.preventDefault();
                if (this._hasClose) {
                    this.reject();
                }
                break;
            case 37: {
                // Left arrow
                const activeEl = document.activeElement;
                if (activeEl instanceof HTMLButtonElement) {
                    let idx = this._buttonNodes.indexOf(activeEl) - 1;
                    // Handle a left arrows on the first button
                    if (idx < 0) {
                        idx = this._buttonNodes.length - 1;
                    }
                    const node = this._buttonNodes[idx];
                    event.stopPropagation();
                    event.preventDefault();
                    node.focus();
                }
                break;
            }
            case 39: {
                // Right arrow
                const activeEl = document.activeElement;
                if (activeEl instanceof HTMLButtonElement) {
                    let idx = this._buttonNodes.indexOf(activeEl) + 1;
                    // Handle a right arrows on the last button
                    if (idx == this._buttons.length) {
                        idx = 0;
                    }
                    const node = this._buttonNodes[idx];
                    event.stopPropagation();
                    event.preventDefault();
                    node.focus();
                }
                break;
            }
            case 9: {
                // Tab.
                // Handle a tab on the last button.
                const node = this._buttonNodes[this._buttons.length - 1];
                if (document.activeElement === node && !event.shiftKey) {
                    event.stopPropagation();
                    event.preventDefault();
                    this._first.focus();
                }
                break;
            }
            case 13: {
                // Enter.
                event.stopPropagation();
                event.preventDefault();
                const activeEl = document.activeElement;
                if (activeEl instanceof HTMLButtonElement) {
                    const index = this._buttonNodes.indexOf(activeEl);
                    if (index !== -1) {
                        this.resolve(index);
                    }
                }
                else if (!(activeEl instanceof HTMLTextAreaElement)) {
                    const index = this._defaultButton;
                    this.resolve(index);
                }
                break;
            }
            default:
                break;
        }
    }
    /**
     * Handle the `'focus'` event for the widget.
     *
     * @param event - The DOM event sent to the widget
     */
    _evtFocus(event) {
        var _a;
        const target = event.target;
        if (!this.node.contains(target)) {
            event.stopPropagation();
            (_a = this._buttonNodes[this._defaultButton]) === null || _a === void 0 ? void 0 : _a.focus();
        }
    }
    /**
     * Handle the `'mousedown'` event for the widget.
     *
     * @param event - The DOM event sent to the widget
     */
    _evtMouseDown(event) {
        const content = this.node.getElementsByClassName('jp-Dialog-content')[0];
        const target = event.target;
        this._lastMouseDownInDialog = content.contains(target);
    }
    /**
     * Resolve a button item.
     */
    _resolve(button) {
        var _a, _b, _c;
        if (this._hasValidationErrors && button.accept) {
            // Do not allow accepting with validation errors
            return;
        }
        // Prevent loopback.
        const promise = this._promise;
        if (!promise) {
            this.dispose();
            return;
        }
        this._promise = null;
        dist_index_es6_js_.ArrayExt.removeFirstOf(Private.launchQueue, promise.promise);
        const body = this._body;
        let value = null;
        if (button.accept &&
            body instanceof index_es6_js_.Widget &&
            typeof body.getValue === 'function') {
            value = body.getValue();
        }
        this.dispose();
        promise.resolve({
            button,
            isChecked: (_c = (_b = (_a = this._checkboxNode) === null || _a === void 0 ? void 0 : _a.querySelector('input')) === null || _b === void 0 ? void 0 : _b.checked) !== null && _c !== void 0 ? _c : null,
            value
        });
    }
}
/**
 * The namespace for Dialog class statics.
 */
(function (Dialog) {
    /**
     * Translator object.
     */
    Dialog.translator = lib_index_js_.nullTranslator;
    /**
     * Create a button item.
     */
    function createButton(value) {
        value.accept = value.accept !== false;
        const trans = Dialog.translator.load('jupyterlab');
        const defaultLabel = value.accept ? trans.__('Ok') : trans.__('Cancel');
        return {
            ariaLabel: value.ariaLabel || value.label || defaultLabel,
            label: value.label || defaultLabel,
            iconClass: value.iconClass || '',
            iconLabel: value.iconLabel || '',
            caption: value.caption || '',
            className: value.className || '',
            accept: value.accept,
            actions: value.actions || [],
            displayType: value.displayType || 'default'
        };
    }
    Dialog.createButton = createButton;
    /**
     * Create a reject button.
     */
    function cancelButton(options = {}) {
        options.accept = false;
        return createButton(options);
    }
    Dialog.cancelButton = cancelButton;
    /**
     * Create an accept button.
     */
    function okButton(options = {}) {
        options.accept = true;
        return createButton(options);
    }
    Dialog.okButton = okButton;
    /**
     * Create a warn button.
     */
    function warnButton(options = {}) {
        options.displayType = 'warn';
        return createButton(options);
    }
    Dialog.warnButton = warnButton;
    /**
     * Disposes all dialog instances.
     *
     * #### Notes
     * This function should only be used in tests or cases where application state
     * may be discarded.
     */
    function flush() {
        Dialog.tracker.forEach(dialog => {
            dialog.dispose();
        });
    }
    Dialog.flush = flush;
    /**
     * The default implementation of a dialog renderer.
     */
    class Renderer {
        /**
         * Create the header of the dialog.
         *
         * @param title - The title of the dialog.
         *
         * @returns A widget for the dialog header.
         */
        createHeader(title, reject = () => {
            /* empty */
        }, options = {}) {
            let header;
            const handleMouseDown = (event) => {
                // Fire action only when left button is pressed.
                if (event.button === 0) {
                    event.preventDefault();
                    reject();
                }
            };
            const handleKeyDown = (event) => {
                const { key } = event;
                if (key === 'Enter' || key === ' ') {
                    reject();
                }
            };
            if (typeof title === 'string') {
                const trans = Dialog.translator.load('jupyterlab');
                header = index_js_.ReactWidget.create(react_index_js_.createElement(react_index_js_.Fragment, null,
                    title,
                    options.hasClose && (react_index_js_.createElement(index_js_.Button, { className: "jp-Dialog-close-button", onMouseDown: handleMouseDown, onKeyDown: handleKeyDown, title: trans.__('Cancel'), minimal: true },
                        react_index_js_.createElement(index_js_.LabIcon.resolveReact, { icon: index_js_.closeIcon, tag: "span" })))));
            }
            else {
                header = index_js_.ReactWidget.create(title);
            }
            header.addClass('jp-Dialog-header');
            index_js_.Styling.styleNode(header.node);
            return header;
        }
        /**
         * Create the body of the dialog.
         *
         * @param value - The input value for the body.
         *
         * @returns A widget for the body.
         */
        createBody(value) {
            const styleReactWidget = (widget) => {
                if (widget.renderPromise !== undefined) {
                    widget.renderPromise
                        .then(() => {
                        index_js_.Styling.styleNode(widget.node);
                    })
                        .catch(() => {
                        console.error("Error while loading Dialog's body");
                    });
                }
                else {
                    index_js_.Styling.styleNode(widget.node);
                }
            };
            let body;
            if (typeof value === 'string') {
                body = new index_es6_js_.Widget({ node: document.createElement('span') });
                body.node.textContent = value;
            }
            else if (value instanceof index_es6_js_.Widget) {
                body = value;
                if (body instanceof index_js_.ReactWidget) {
                    styleReactWidget(body);
                }
                else {
                    index_js_.Styling.styleNode(body.node);
                }
            }
            else {
                body = index_js_.ReactWidget.create(value);
                // Immediately update the body even though it has not yet attached in
                // order to trigger a render of the DOM nodes from the React element.
                messaging_dist_index_es6_js_.MessageLoop.sendMessage(body, index_es6_js_.Widget.Msg.UpdateRequest);
                styleReactWidget(body);
            }
            body.addClass('jp-Dialog-body');
            return body;
        }
        /**
         * Create the footer of the dialog.
         *
         * @param buttons - The buttons nodes to add to the footer.
         * @param checkbox - The checkbox node to add to the footer.
         *
         * @returns A widget for the footer.
         */
        createFooter(buttons, checkbox) {
            const footer = new index_es6_js_.Widget();
            footer.addClass('jp-Dialog-footer');
            if (checkbox) {
                footer.node.appendChild(checkbox);
                footer.node.insertAdjacentHTML('beforeend', '<div class="jp-Dialog-spacer"></div>');
            }
            const footerButton = document.createElement('div');
            for (const button of buttons) {
                footerButton.appendChild(button);
            }
            footer.node.appendChild(footerButton);
            index_js_.Styling.styleNode(footer.node);
            return footer;
        }
        /**
         * Create a button node for the dialog.
         *
         * @param button - The button data.
         *
         * @returns A node for the button.
         */
        createButtonNode(button) {
            const e = document.createElement('button');
            e.className = this.createItemClass(button);
            e.appendChild(this.renderIcon(button));
            e.appendChild(this.renderLabel(button));
            return e;
        }
        /**
         * Create a checkbox node for the dialog.
         *
         * @param checkbox - The checkbox data.
         *
         * @returns A node for the checkbox.
         */
        createCheckboxNode(checkbox) {
            const e = document.createElement('label');
            e.className = 'jp-Dialog-checkbox';
            if (checkbox.className) {
                e.classList.add(checkbox.className);
            }
            e.title = checkbox.caption;
            e.textContent = checkbox.label;
            const input = document.createElement('input');
            input.type = 'checkbox';
            input.checked = !!checkbox.checked;
            e.insertAdjacentElement('afterbegin', input);
            return e;
        }
        /**
         * Create the class name for the button.
         *
         * @param data - The data to use for the class name.
         *
         * @returns The full class name for the button.
         */
        createItemClass(data) {
            // Setup the initial class name.
            let name = 'jp-Dialog-button';
            // Add the other state classes.
            if (data.accept) {
                name += ' jp-mod-accept';
            }
            else {
                name += ' jp-mod-reject';
            }
            if (data.displayType === 'warn') {
                name += ' jp-mod-warn';
            }
            // Add the extra class.
            const extra = data.className;
            if (extra) {
                name += ` ${extra}`;
            }
            // Return the complete class name.
            return name;
        }
        /**
         * Render an icon element for a dialog item.
         *
         * @param data - The data to use for rendering the icon.
         *
         * @returns An HTML element representing the icon.
         */
        renderIcon(data) {
            const e = document.createElement('div');
            e.className = this.createIconClass(data);
            e.appendChild(document.createTextNode(data.iconLabel));
            return e;
        }
        /**
         * Create the class name for the button icon.
         *
         * @param data - The data to use for the class name.
         *
         * @returns The full class name for the item icon.
         */
        createIconClass(data) {
            const name = 'jp-Dialog-buttonIcon';
            const extra = data.iconClass;
            return extra ? `${name} ${extra}` : name;
        }
        /**
         * Render the label element for a button.
         *
         * @param data - The data to use for rendering the label.
         *
         * @returns An HTML element representing the item label.
         */
        renderLabel(data) {
            const e = document.createElement('div');
            e.className = 'jp-Dialog-buttonLabel';
            e.title = data.caption;
            e.ariaLabel = data.ariaLabel;
            e.appendChild(document.createTextNode(data.label));
            return e;
        }
    }
    Dialog.Renderer = Renderer;
    /**
     * The default renderer instance.
     */
    Dialog.defaultRenderer = new Renderer();
    /**
     * The dialog widget tracker.
     */
    Dialog.tracker = new WidgetTracker({
        namespace: '@jupyterlab/apputils:Dialog'
    });
})(Dialog || (Dialog = {}));
/**
 * The namespace for module private data.
 */
var Private;
(function (Private) {
    /**
     * The queue for launching dialogs.
     */
    Private.launchQueue = [];
    Private.errorMessagePromiseCache = new Map();
    /**
     * Handle the input options for a dialog.
     *
     * @param options - The input options.
     *
     * @returns A new options object with defaults applied.
     */
    function handleOptions(options = {}) {
        var _a, _b, _c, _d, _e, _f, _g, _h, _j;
        const buttons = (_a = options.buttons) !== null && _a !== void 0 ? _a : [
            Dialog.cancelButton(),
            Dialog.okButton()
        ];
        return {
            title: (_b = options.title) !== null && _b !== void 0 ? _b : '',
            body: (_c = options.body) !== null && _c !== void 0 ? _c : '',
            host: (_d = options.host) !== null && _d !== void 0 ? _d : document.body,
            checkbox: (_e = options.checkbox) !== null && _e !== void 0 ? _e : null,
            buttons,
            defaultButton: (_f = options.defaultButton) !== null && _f !== void 0 ? _f : buttons.length - 1,
            renderer: (_g = options.renderer) !== null && _g !== void 0 ? _g : Dialog.defaultRenderer,
            focusNodeSelector: (_h = options.focusNodeSelector) !== null && _h !== void 0 ? _h : '',
            hasClose: (_j = options.hasClose) !== null && _j !== void 0 ? _j : true
        };
    }
    Private.handleOptions = handleOptions;
    /**
     *  Find the first focusable item in the dialog.
     */
    function findFirstFocusable(node) {
        const candidateSelectors = [
            'input',
            'select',
            'a[href]',
            'textarea',
            'button',
            '[tabindex]'
        ].join(',');
        return node.querySelectorAll(candidateSelectors)[0];
    }
    Private.findFirstFocusable = findFirstFocusable;
})(Private || (Private = {}));
//# sourceMappingURL=dialog.js.map
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/apputils/lib/sessioncontext.js
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.








/**
 * The default implementation for a session context object.
 */
class SessionContext {
    /**
     * Construct a new session context.
     */
    constructor(options) {
        var _a, _b, _c, _d;
        this._path = '';
        this._name = '';
        this._type = '';
        this._prevKernelName = '';
        this._isDisposed = false;
        this._disposed = new signaling_dist_index_es6_js_.Signal(this);
        this._session = null;
        this._ready = new dist_index_js_.PromiseDelegate();
        this._initializing = false;
        this._initStarted = new dist_index_js_.PromiseDelegate();
        this._initPromise = new dist_index_js_.PromiseDelegate();
        this._isReady = false;
        this._isTerminating = false;
        this._isRestarting = false;
        this._kernelChanged = new signaling_dist_index_es6_js_.Signal(this);
        this._preferenceChanged = new signaling_dist_index_es6_js_.Signal(this);
        this._sessionChanged = new signaling_dist_index_es6_js_.Signal(this);
        this._statusChanged = new signaling_dist_index_es6_js_.Signal(this);
        this._connectionStatusChanged = new signaling_dist_index_es6_js_.Signal(this);
        this._pendingInput = false;
        this._iopubMessage = new signaling_dist_index_es6_js_.Signal(this);
        this._unhandledMessage = new signaling_dist_index_es6_js_.Signal(this);
        this._propertyChanged = new signaling_dist_index_es6_js_.Signal(this);
        this._dialog = null;
        this._busyDisposable = null;
        this._pendingKernelName = '';
        this._pendingSessionRequest = '';
        this.kernelManager = options.kernelManager;
        this.sessionManager = options.sessionManager;
        this.specsManager = options.specsManager;
        this.translator = options.translator || lib_index_js_.nullTranslator;
        this._trans = this.translator.load('jupyterlab');
        this._path = (_a = options.path) !== null && _a !== void 0 ? _a : dist_index_js_.UUID.uuid4();
        this._type = (_b = options.type) !== null && _b !== void 0 ? _b : '';
        this._name = (_c = options.name) !== null && _c !== void 0 ? _c : '';
        this._setBusy = options.setBusy;
        this._kernelPreference = (_d = options.kernelPreference) !== null && _d !== void 0 ? _d : {};
    }
    /**
     * The current session connection.
     */
    get session() {
        var _a;
        return (_a = this._session) !== null && _a !== void 0 ? _a : null;
    }
    /**
     * The session path.
     *
     * #### Notes
     * Typically `.session.path` should be used. This attribute is useful if
     * there is no current session.
     */
    get path() {
        return this._path;
    }
    /**
     * The session type.
     *
     * #### Notes
     * Typically `.session.type` should be used. This attribute is useful if
     * there is no current session.
     */
    get type() {
        return this._type;
    }
    /**
     * The session name.
     *
     * #### Notes
     * Typically `.session.name` should be used. This attribute is useful if
     * there is no current session.
     */
    get name() {
        return this._name;
    }
    /**
     * A signal emitted when the kernel connection changes, proxied from the session connection.
     */
    get kernelChanged() {
        return this._kernelChanged;
    }
    /**
     * A signal emitted when the session connection changes.
     */
    get sessionChanged() {
        return this._sessionChanged;
    }
    /**
     * A signal emitted when the kernel status changes, proxied from the kernel.
     */
    get statusChanged() {
        return this._statusChanged;
    }
    /**
     * A flag indicating if the session has pending input, proxied from the kernel.
     */
    get pendingInput() {
        return this._pendingInput;
    }
    /**
     * A signal emitted when the kernel status changes, proxied from the kernel.
     */
    get connectionStatusChanged() {
        return this._connectionStatusChanged;
    }
    /**
     * A signal emitted for iopub kernel messages, proxied from the kernel.
     */
    get iopubMessage() {
        return this._iopubMessage;
    }
    /**
     * A signal emitted for an unhandled kernel message, proxied from the kernel.
     */
    get unhandledMessage() {
        return this._unhandledMessage;
    }
    /**
     * A signal emitted when a session property changes, proxied from the current session.
     */
    get propertyChanged() {
        return this._propertyChanged;
    }
    /**
     * The kernel preference of this client session.
     *
     * This is used when selecting a new kernel, and should reflect the sort of
     * kernel the activity prefers.
     */
    get kernelPreference() {
        return this._kernelPreference;
    }
    set kernelPreference(value) {
        if (!dist_index_js_.JSONExt.deepEqual(value, this._kernelPreference)) {
            const oldValue = this._kernelPreference;
            this._kernelPreference = value;
            this._preferenceChanged.emit({
                name: 'kernelPreference',
                oldValue,
                newValue: dist_index_js_.JSONExt.deepCopy(value)
            });
        }
    }
    /**
     * Signal emitted if the kernel preference changes.
     */
    get kernelPreferenceChanged() {
        return this._preferenceChanged;
    }
    /**
     * Whether the context is ready.
     */
    get isReady() {
        return this._isReady;
    }
    /**
     * A promise that is fulfilled when the context is ready.
     */
    get ready() {
        return this._ready.promise;
    }
    /**
     * Whether the context is terminating.
     */
    get isTerminating() {
        return this._isTerminating;
    }
    /**
     * Whether the context is restarting.
     */
    get isRestarting() {
        return this._isRestarting;
    }
    /**
     * Whether the kernel is "No Kernel" or not.
     *
     * #### Notes
     * As the displayed name is translated, this can be used directly.
     */
    get hasNoKernel() {
        return this.kernelDisplayName === this.noKernelName;
    }
    /**
     * The display name of the current kernel, or a sensible alternative.
     *
     * #### Notes
     * This is a convenience function to have a consistent sensible name for the
     * kernel.
     */
    get kernelDisplayName() {
        var _a, _b, _c, _d, _e, _f, _g;
        const kernel = (_a = this.session) === null || _a === void 0 ? void 0 : _a.kernel;
        if (this._pendingKernelName === this.noKernelName) {
            return this.noKernelName;
        }
        if (this._pendingKernelName) {
            return ((_d = (_c = (_b = this.specsManager.specs) === null || _b === void 0 ? void 0 : _b.kernelspecs[this._pendingKernelName]) === null || _c === void 0 ? void 0 : _c.display_name) !== null && _d !== void 0 ? _d : this._pendingKernelName);
        }
        if (!kernel) {
            return this.noKernelName;
        }
        return ((_g = (_f = (_e = this.specsManager.specs) === null || _e === void 0 ? void 0 : _e.kernelspecs[kernel.name]) === null || _f === void 0 ? void 0 : _f.display_name) !== null && _g !== void 0 ? _g : kernel.name);
    }
    /**
     * A sensible status to display
     *
     * #### Notes
     * This combines the status and connection status into a single status for
     * the user.
     */
    get kernelDisplayStatus() {
        var _a, _b;
        const kernel = (_a = this.session) === null || _a === void 0 ? void 0 : _a.kernel;
        if (this._isTerminating) {
            return 'terminating';
        }
        if (this._isRestarting) {
            return 'restarting';
        }
        if (this._pendingKernelName === this.noKernelName) {
            return 'unknown';
        }
        if (!kernel && this._pendingKernelName) {
            return 'initializing';
        }
        if (!kernel &&
            !this.isReady &&
            this.kernelPreference.canStart !== false &&
            this.kernelPreference.shouldStart !== false) {
            return 'initializing';
        }
        return ((_b = ((kernel === null || kernel === void 0 ? void 0 : kernel.connectionStatus) === 'connected'
            ? kernel === null || kernel === void 0 ? void 0 : kernel.status
            : kernel === null || kernel === void 0 ? void 0 : kernel.connectionStatus)) !== null && _b !== void 0 ? _b : 'unknown');
    }
    /**
     * The name of the previously started kernel.
     */
    get prevKernelName() {
        return this._prevKernelName;
    }
    /**
     * Test whether the context is disposed.
     */
    get isDisposed() {
        return this._isDisposed;
    }
    /**
     * A signal emitted when the poll is disposed.
     */
    get disposed() {
        return this._disposed;
    }
    /**
     * Get the constant displayed name for "No Kernel"
     */
    get noKernelName() {
        return this._trans.__('No Kernel');
    }
    /**
     * Dispose of the resources held by the context.
     */
    dispose() {
        if (this._isDisposed) {
            return;
        }
        this._isDisposed = true;
        this._disposed.emit();
        if (this._session) {
            if (this.kernelPreference.shutdownOnDispose) {
                // Fire and forget the session shutdown request
                this.sessionManager.shutdown(this._session.id).catch(reason => {
                    console.error(`Kernel not shut down ${reason}`);
                });
            }
            // Dispose the session connection
            this._session.dispose();
            this._session = null;
        }
        if (this._dialog) {
            this._dialog.dispose();
        }
        if (this._busyDisposable) {
            this._busyDisposable.dispose();
            this._busyDisposable = null;
        }
        signaling_dist_index_es6_js_.Signal.clearData(this);
    }
    /**
     * Starts new Kernel.
     *
     * @returns Whether to ask the user to pick a kernel.
     */
    async startKernel() {
        const preference = this.kernelPreference;
        if (!preference.autoStartDefault && preference.shouldStart === false) {
            return true;
        }
        let options;
        if (preference.id) {
            options = { id: preference.id };
        }
        else {
            const name = sessioncontext_Private.getDefaultKernel({
                specs: this.specsManager.specs,
                sessions: this.sessionManager.running(),
                preference
            });
            if (name) {
                options = { name };
            }
        }
        if (options) {
            try {
                await this._changeKernel(options);
                return false;
            }
            catch (err) {
                /* no-op */
            }
        }
        // Always fall back to selecting a kernel
        return true;
    }
    /**
     * Restart the current Kernel.
     *
     * @returns A promise that resolves when the kernel is restarted.
     */
    async restartKernel() {
        var _a, _b, _c, _d, _e, _f;
        const kernel = ((_a = this.session) === null || _a === void 0 ? void 0 : _a.kernel) || null;
        if (this._isRestarting) {
            return;
        }
        this._isRestarting = true;
        this._isReady = false;
        this._statusChanged.emit('restarting');
        try {
            await ((_c = (_b = this.session) === null || _b === void 0 ? void 0 : _b.kernel) === null || _c === void 0 ? void 0 : _c.restart());
            this._isReady = true;
        }
        catch (e) {
            console.error(e);
        }
        this._isRestarting = false;
        this._statusChanged.emit(((_e = (_d = this.session) === null || _d === void 0 ? void 0 : _d.kernel) === null || _e === void 0 ? void 0 : _e.status) || 'unknown');
        this._kernelChanged.emit({
            name: 'kernel',
            oldValue: kernel,
            newValue: ((_f = this.session) === null || _f === void 0 ? void 0 : _f.kernel) || null
        });
    }
    /**
     * Change the current kernel associated with the session.
     */
    async changeKernel(options = {}) {
        if (this.isDisposed) {
            throw new Error('Disposed');
        }
        // Wait for the initialization method to try
        // and start its kernel first to ensure consistent
        // ordering.
        await this._initStarted.promise;
        return this._changeKernel(options);
    }
    /**
     * Kill the kernel and shutdown the session.
     *
     * @returns A promise that resolves when the session is shut down.
     */
    async shutdown() {
        if (this.isDisposed || !this._initializing) {
            return;
        }
        await this._initStarted.promise;
        this._pendingSessionRequest = '';
        this._pendingKernelName = this.noKernelName;
        return this._shutdownSession();
    }
    /**
     * Initialize the session context
     *
     * @returns A promise that resolves with whether to ask the user to select a kernel.
     *
     * #### Notes
     * If a server session exists on the current path, we will connect to it.
     * If preferences include disabling `canStart` or `shouldStart`, no
     * server session will be started.
     * If a kernel id is given, we attempt to start a session with that id.
     * If a default kernel is available, we connect to it.
     * Otherwise we ask the user to select a kernel.
     */
    async initialize() {
        if (this._initializing) {
            return this._initPromise.promise;
        }
        this._initializing = true;
        const needsSelection = await this._initialize();
        if (!needsSelection) {
            this._isReady = true;
            this._ready.resolve(undefined);
        }
        if (!this._pendingSessionRequest) {
            this._initStarted.resolve(void 0);
        }
        this._initPromise.resolve(needsSelection);
        return needsSelection;
    }
    /**
     * Inner initialize function that doesn't handle promises.
     * This makes it easier to consolidate promise handling logic.
     */
    async _initialize() {
        const manager = this.sessionManager;
        await manager.ready;
        await manager.refreshRunning();
        const model = (0,dist_index_es6_js_.find)(manager.running(), item => {
            return item.path === this._path;
        });
        if (model) {
            try {
                const session = manager.connectTo({ model });
                this._handleNewSession(session);
            }
            catch (err) {
                void this._handleSessionError(err);
                return Promise.reject(err);
            }
        }
        return await this._startIfNecessary();
    }
    /**
     * Shut down the current session.
     */
    async _shutdownSession() {
        var _a;
        const session = this._session;
        // Capture starting values in case an error is raised.
        const isTerminating = this._isTerminating;
        const isReady = this._isReady;
        this._isTerminating = true;
        this._isReady = false;
        this._statusChanged.emit('terminating');
        try {
            await (session === null || session === void 0 ? void 0 : session.shutdown());
            this._isTerminating = false;
            session === null || session === void 0 ? void 0 : session.dispose();
            this._session = null;
            const kernel = (session === null || session === void 0 ? void 0 : session.kernel) || null;
            this._statusChanged.emit('unknown');
            this._kernelChanged.emit({
                name: 'kernel',
                oldValue: kernel,
                newValue: null
            });
            this._sessionChanged.emit({
                name: 'session',
                oldValue: session,
                newValue: null
            });
        }
        catch (err) {
            this._isTerminating = isTerminating;
            this._isReady = isReady;
            const status = (_a = session === null || session === void 0 ? void 0 : session.kernel) === null || _a === void 0 ? void 0 : _a.status;
            if (status === undefined) {
                this._statusChanged.emit('unknown');
            }
            else {
                this._statusChanged.emit(status);
            }
            throw err;
        }
        return;
    }
    /**
     * Start the session if necessary.
     *
     * @returns Whether to ask the user to pick a kernel.
     */
    async _startIfNecessary() {
        var _a;
        const preference = this.kernelPreference;
        if (this.isDisposed ||
            ((_a = this.session) === null || _a === void 0 ? void 0 : _a.kernel) ||
            preference.shouldStart === false ||
            preference.canStart === false) {
            // Not necessary to start a kernel
            return false;
        }
        return this.startKernel();
    }
    /**
     * Change the kernel.
     */
    async _changeKernel(model = {}) {
        if (model.name) {
            this._pendingKernelName = model.name;
        }
        if (!this._session) {
            this._kernelChanged.emit({
                name: 'kernel',
                oldValue: null,
                newValue: null
            });
        }
        // Guarantee that the initialized kernel
        // will be started first.
        if (!this._pendingSessionRequest) {
            this._initStarted.resolve(void 0);
        }
        // If we already have a session, just change the kernel.
        if (this._session && !this._isTerminating) {
            try {
                await this._session.changeKernel(model);
                return this._session.kernel;
            }
            catch (err) {
                void this._handleSessionError(err);
                throw err;
            }
        }
        // Use a UUID for the path to overcome a race condition on the server
        // where it will re-use a session for a given path but only after
        // the kernel finishes starting.
        // We later switch to the real path below.
        // Use the correct directory so the kernel will be started in that directory.
        const dirName = coreutils_lib_index_js_.PathExt.dirname(this._path);
        const requestId = (this._pendingSessionRequest = coreutils_lib_index_js_.PathExt.join(dirName, dist_index_js_.UUID.uuid4()));
        try {
            this._statusChanged.emit('starting');
            const session = await this.sessionManager.startNew({
                path: requestId,
                type: this._type,
                name: this._name,
                kernel: model
            });
            // Handle a preempt.
            if (this._pendingSessionRequest !== session.path) {
                await session.shutdown();
                session.dispose();
                return null;
            }
            // Change to the real path.
            await session.setPath(this._path);
            // Update the name in case it has changed since we launched the session.
            await session.setName(this._name);
            if (this._session && !this._isTerminating) {
                await this._shutdownSession();
            }
            return this._handleNewSession(session);
        }
        catch (err) {
            void this._handleSessionError(err);
            throw err;
        }
    }
    /**
     * Handle a new session object.
     */
    _handleNewSession(session) {
        var _a, _b, _c;
        if (this.isDisposed) {
            throw Error('Disposed');
        }
        if (!this._isReady) {
            this._isReady = true;
            this._ready.resolve(undefined);
        }
        if (this._session) {
            this._session.dispose();
        }
        this._session = session;
        this._pendingKernelName = '';
        if (session) {
            this._prevKernelName = (_b = (_a = session.kernel) === null || _a === void 0 ? void 0 : _a.name) !== null && _b !== void 0 ? _b : '';
            session.disposed.connect(this._onSessionDisposed, this);
            session.propertyChanged.connect(this._onPropertyChanged, this);
            session.kernelChanged.connect(this._onKernelChanged, this);
            session.statusChanged.connect(this._onStatusChanged, this);
            session.connectionStatusChanged.connect(this._onConnectionStatusChanged, this);
            session.pendingInput.connect(this._onPendingInput, this);
            session.iopubMessage.connect(this._onIopubMessage, this);
            session.unhandledMessage.connect(this._onUnhandledMessage, this);
            if (session.path !== this._path) {
                this._onPropertyChanged(session, 'path');
            }
            if (session.name !== this._name) {
                this._onPropertyChanged(session, 'name');
            }
            if (session.type !== this._type) {
                this._onPropertyChanged(session, 'type');
            }
        }
        // Any existing session/kernel connection was disposed above when the session was
        // disposed, so the oldValue should be null.
        this._sessionChanged.emit({
            name: 'session',
            oldValue: null,
            newValue: session
        });
        this._kernelChanged.emit({
            oldValue: null,
            newValue: (session === null || session === void 0 ? void 0 : session.kernel) || null,
            name: 'kernel'
        });
        this._statusChanged.emit(((_c = session === null || session === void 0 ? void 0 : session.kernel) === null || _c === void 0 ? void 0 : _c.status) || 'unknown');
        return (session === null || session === void 0 ? void 0 : session.kernel) || null;
    }
    /**
     * Handle an error in session startup.
     */
    async _handleSessionError(err) {
        this._handleNewSession(null);
        let traceback = '';
        let message = '';
        try {
            traceback = err.traceback;
            message = err.message;
        }
        catch (err) {
            // no-op
        }
        await this._displayKernelError(message, traceback);
    }
    /**
     * Display kernel error
     */
    async _displayKernelError(message, traceback) {
        const body = (react_index_js_.createElement("div", null,
            message && react_index_js_.createElement("pre", null, message),
            traceback && (react_index_js_.createElement("details", { className: "jp-mod-wide" },
                react_index_js_.createElement("pre", null, traceback)))));
        const dialog = (this._dialog = new Dialog({
            title: this._trans.__('Error Starting Kernel'),
            body,
            buttons: [Dialog.okButton()]
        }));
        await dialog.launch();
        this._dialog = null;
    }
    /**
     * Handle a session termination.
     */
    _onSessionDisposed() {
        if (this._session) {
            const oldValue = this._session;
            this._session = null;
            const newValue = this._session;
            this._sessionChanged.emit({ name: 'session', oldValue, newValue });
        }
    }
    /**
     * Handle a change to a session property.
     */
    _onPropertyChanged(sender, property) {
        switch (property) {
            case 'path':
                this._path = sender.path;
                break;
            case 'name':
                this._name = sender.name;
                break;
            case 'type':
                this._type = sender.type;
                break;
            default:
                throw new Error(`unrecognized property ${property}`);
        }
        this._propertyChanged.emit(property);
    }
    /**
     * Handle a change to the kernel.
     */
    _onKernelChanged(sender, args) {
        this._kernelChanged.emit(args);
    }
    /**
     * Handle a change to the session status.
     */
    _onStatusChanged(sender, status) {
        var _a;
        if (status === 'dead') {
            const model = (_a = sender.kernel) === null || _a === void 0 ? void 0 : _a.model;
            if (model === null || model === void 0 ? void 0 : model.reason) {
                const traceback = model.traceback || '';
                void this._displayKernelError(model.reason, traceback);
            }
        }
        // Set that this kernel is busy, if we haven't already
        // If we have already, and now we aren't busy, dispose
        // of the busy disposable.
        if (this._setBusy) {
            if (status === 'busy') {
                if (!this._busyDisposable) {
                    this._busyDisposable = this._setBusy();
                }
            }
            else {
                if (this._busyDisposable) {
                    this._busyDisposable.dispose();
                    this._busyDisposable = null;
                }
            }
        }
        // Proxy the signal
        this._statusChanged.emit(status);
    }
    /**
     * Handle a change to the session status.
     */
    _onConnectionStatusChanged(sender, status) {
        // Proxy the signal
        this._connectionStatusChanged.emit(status);
    }
    /**
     * Handle a change to the pending input.
     */
    _onPendingInput(sender, value) {
        // Set the signal value
        this._pendingInput = value;
    }
    /**
     * Handle an iopub message.
     */
    _onIopubMessage(sender, message) {
        if (message.header.msg_type === 'shutdown_reply') {
            this.session.kernel.removeInputGuard();
        }
        this._iopubMessage.emit(message);
    }
    /**
     * Handle an unhandled message.
     */
    _onUnhandledMessage(sender, message) {
        this._unhandledMessage.emit(message);
    }
}
/**
 * A namespace for `SessionContext` statics.
 */
(function (SessionContext) {
    /**
     * Get the default kernel name given select options.
     */
    function getDefaultKernel(options) {
        const { preference } = options;
        const { shouldStart } = preference;
        if (shouldStart === false) {
            return null;
        }
        return sessioncontext_Private.getDefaultKernel(options);
    }
    SessionContext.getDefaultKernel = getDefaultKernel;
})(SessionContext || (SessionContext = {}));
/**
 * The default implementation of the client session dialog provider.
 */
class SessionContextDialogs {
    constructor(options = {}) {
        var _a;
        this._translator = (_a = options.translator) !== null && _a !== void 0 ? _a : lib_index_js_.nullTranslator;
        this._settingRegistry = options.settingRegistry || null;
    }
    /**
     * Select a kernel for the session.
     */
    async selectKernel(sessionContext) {
        if (sessionContext.isDisposed) {
            return Promise.resolve();
        }
        const translator = this._translator;
        const trans = translator.load('jupyterlab');
        // If there is no existing kernel, offer the option to keep no kernel.
        let label = trans.__('Cancel');
        if (sessionContext.hasNoKernel) {
            label = sessionContext.kernelDisplayName;
        }
        const buttons = [
            Dialog.cancelButton({ label }),
            Dialog.okButton({
                label: trans.__('Select'),
                ariaLabel: trans.__('Select Kernel')
            })
        ];
        const autoStartDefault = sessionContext.kernelPreference.autoStartDefault;
        const hasCheckbox = typeof autoStartDefault === 'boolean';
        const dialog = new Dialog({
            title: trans.__('Select Kernel'),
            body: sessioncontext_Private.createKernelSelector(sessionContext, translator),
            buttons,
            checkbox: hasCheckbox
                ? {
                    label: trans.__('Always start the preferred kernel'),
                    caption: trans.__('Remember my choice and always start the preferred kernel'),
                    checked: autoStartDefault
                }
                : null
        });
        const result = await dialog.launch();
        if (sessionContext.isDisposed || !result.button.accept) {
            return;
        }
        if (hasCheckbox && result.isChecked !== null) {
            sessionContext.kernelPreference = {
                ...sessionContext.kernelPreference,
                autoStartDefault: result.isChecked
            };
        }
        const model = result.value;
        if (model === null && !sessionContext.hasNoKernel) {
            return sessionContext.shutdown();
        }
        if (model) {
            await sessionContext.changeKernel(model);
        }
    }
    /**
     * Restart the session.
     *
     * @returns A promise that resolves with whether the kernel has restarted.
     *
     * #### Notes
     * If there is a running kernel, present a dialog.
     * If there is no kernel, we start a kernel with the last run
     * kernel name and resolves with `true`.
     */
    async restart(sessionContext) {
        var _a, _b, _c, _d, _e;
        const trans = this._translator.load('jupyterlab');
        await sessionContext.initialize();
        if (sessionContext.isDisposed) {
            throw new Error('session already disposed');
        }
        const kernel = (_a = sessionContext.session) === null || _a === void 0 ? void 0 : _a.kernel;
        if (!kernel && sessionContext.prevKernelName) {
            await sessionContext.changeKernel({
                name: sessionContext.prevKernelName
            });
            return true;
        }
        // Bail if there is no previous kernel to start.
        if (!kernel) {
            throw new Error('No kernel to restart');
        }
        // Skip the dialog and restart the kernel
        const kernelPluginId = '@jupyterlab/apputils-extension:sessionDialogs';
        const skipKernelRestartDialog = (_c = (_b = sessionContext.kernelPreference) === null || _b === void 0 ? void 0 : _b.skipKernelRestartDialog) !== null && _c !== void 0 ? _c : false;
        const skipKernelRestartDialogSetting = (_e = (await ((_d = this._settingRegistry) === null || _d === void 0 ? void 0 : _d.get(kernelPluginId, 'skipKernelRestartDialog')))) === null || _e === void 0 ? void 0 : _e.composite;
        if (skipKernelRestartDialogSetting || skipKernelRestartDialog) {
            await sessionContext.restartKernel();
            return true;
        }
        const restartBtn = Dialog.warnButton({
            label: trans.__('Restart'),
            ariaLabel: trans.__('Confirm Kernel Restart')
        });
        const result = await showDialog({
            title: trans.__('Restart Kernel?'),
            body: trans.__('Do you want to restart the kernel of %1? All variables will be lost.', sessionContext.name),
            buttons: [
                Dialog.cancelButton({ ariaLabel: trans.__('Cancel Kernel Restart') }),
                restartBtn
            ],
            checkbox: {
                label: trans.__('Do not ask me again.'),
                caption: trans.__('If checked, the kernel will restart without confirmation prompt in the future; you can change this back in the settings.')
            }
        });
        if (kernel.isDisposed) {
            return false;
        }
        if (result.button.accept) {
            if (typeof result.isChecked === 'boolean' && result.isChecked == true) {
                sessionContext.kernelPreference = {
                    ...sessionContext.kernelPreference,
                    skipKernelRestartDialog: true
                };
            }
            await sessionContext.restartKernel();
            return true;
        }
        return false;
    }
}
(function (SessionContextDialogs) {
    /**
     * Returns available kernel options grouped based on session context.
     *
     * #### Notes
     * If a language preference is set in the given session context, the options
     * returned are grouped with the language preference at the top:
     *
     *  - (Start %1 Kernel, language)
     *    - { all kernelspecs whose language matches in alphabetical order }
     *  - (Use No Kernel)
     *    - `No Kernel`
     *  - (Start Kernel)
     *    - { all other kernelspecs in alphabetical order }
     *  - (Connect to Existing %1 Kernel, language)
     *    - { all running kernels whose language matches in alphabetical order }
     *  - (Connect to Kernel)
     *    - { all other running kernels in alphabetical order }
     *
     * If no language preference is set, these groups and options are returned:
     *
     *  - (Start Kernel)
     *    - { all kernelspecs in alphabetical order }
     *  - (Use No Kernel)
     *    - `No Kernel`
     *  - (Connect to Existing Kernel)
     *    - { all running kernels in alphabetical order  }
     *
     * If the session has a kernel ID and a kernel exists with that id, its
     * corresponding option has `selected` set to `true`. Otherwise if the session
     * context language preference is set, the first kernelspec that matches it is
     * selected.
     */
    function kernelOptions(sessionContext, translator = null) {
        var _a, _b, _c, _d, _e, _f, _g;
        const options = { disabled: false, groups: [] };
        // Create mapping of sessions and kernel ids.
        const kernels = Array.from((_b = (_a = sessionContext.kernelManager) === null || _a === void 0 ? void 0 : _a.running()) !== null && _b !== void 0 ? _b : 
        // If kernel manager is unavailable use kernels from running sessions.
        // TODO: Remove this (next version) when kernel manager is guaranteed.
        Array.from(sessionContext.sessionManager.running())
            .filter(session => !!session.kernel)
            .map(session => session.kernel));
        const sessions = Array.from((_c = sessionContext.sessionManager.running()) !== null && _c !== void 0 ? _c : []).reduce((sessions, session) => {
            var _a;
            if ((_a = session.kernel) === null || _a === void 0 ? void 0 : _a.id)
                sessions[session.kernel.id] = session;
            return sessions;
        }, {});
        const preference = {
            ...sessionContext.kernelPreference,
            id: (_e = (_d = sessionContext.session) === null || _d === void 0 ? void 0 : _d.kernel) === null || _e === void 0 ? void 0 : _e.id
        };
        const currentKernelDisplayName = !sessionContext.hasNoKernel
            ? sessionContext.kernelDisplayName
            : null;
        const specs = {
            default: '',
            kernelspecs: Object.create(null),
            ...sessionContext.specsManager.specs
        };
        // Create mapping of languages and kernel names.
        const sorted = [];
        const languages = Object.create(null);
        for (const name in specs.kernelspecs) {
            sorted.push(specs.kernelspecs[name]);
            languages[name] = specs.kernelspecs[name].language;
        }
        sorted.sort((a, b) => a.display_name.localeCompare(b.display_name));
        translator = translator || lib_index_js_.nullTranslator;
        const trans = translator.load('jupyterlab');
        const language = preference.language ||
            languages[preference.name] ||
            (preference.id ? languages[(_f = sessions[preference.id]) === null || _f === void 0 ? void 0 : _f.name] : '');
        const labels = {
            connectKernel: trans.__('Connect to Existing Kernel'),
            startPreferred: trans.__('Start %1 Kernel', language),
            startOther: trans.__('Start Kernel'),
            connectToPreferred: trans.__('Connect to Existing %1 Kernel', language),
            connectToOther: trans.__('Connect to Other Kernel'),
            noKernel: trans.__('No Kernel'),
            startKernel: trans.__('Start Kernel'),
            useNoKernel: trans.__('Use No Kernel')
        };
        const noKernel = {
            label: labels.useNoKernel,
            options: [
                {
                    text: labels.noKernel,
                    title: labels.noKernel,
                    value: JSON.stringify(null)
                }
            ]
        };
        const optionForKernel = (kernel, displayName, session) => {
            const sessionName = session
                ? session.name || coreutils_lib_index_js_.PathExt.basename(session.path)
                : kernel.name || trans.__('Unknown Kernel');
            return {
                text: `${sessionName} (${kernel.id.split('-')[0]})`,
                title: (session ? `${trans.__('Path: %1', session.path)}\n` : ``) +
                    `${trans.__('Name: %1', sessionName)}\n` +
                    `${trans.__('Kernel Name: %1', displayName !== null && displayName !== void 0 ? displayName : kernel.name)}\n` +
                    `${trans.__('Kernel Id: %1', kernel.id)}`,
                value: JSON.stringify({ id: kernel.id })
            };
        };
        const optionForSpec = (spec) => ({
            text: spec.display_name,
            value: JSON.stringify({ name: spec.name })
        });
        // If a kernel cannot be started, bail.
        if (preference.canStart === false) {
            options.disabled = true;
            options.groups.push(noKernel);
            return options;
        }
        // Create kernel option groups based on whether language preference exists.
        if (language) {
            // Add all kernelspecs, separating out the preferred language first.
            const preferred = {
                label: labels.startPreferred,
                options: []
            };
            const other = {
                label: labels.startOther,
                options: []
            };
            const preferredRunning = {
                label: labels.connectToPreferred,
                options: []
            };
            const otherRunning = {
                label: labels.connectToOther,
                options: []
            };
            for (const spec of sorted) {
                (spec.language === language ? preferred : other).options.push(optionForSpec(spec));
            }
            options.groups.push(preferred);
            options.groups.push(noKernel);
            options.groups.push(other);
            kernels
                .map(kernel => {
                var _a, _b;
                return ({
                    option: optionForKernel(kernel, (_b = (_a = specs.kernelspecs[kernel.name]) === null || _a === void 0 ? void 0 : _a.display_name) !== null && _b !== void 0 ? _b : '', sessions[kernel.id]),
                    language: languages[kernel.name]
                });
            })
                .sort((a, b) => a.option.text.localeCompare(b.option.text))
                .forEach(kernel => (language === kernel.language
                ? preferredRunning
                : otherRunning).options.push(kernel.option));
            if (preferredRunning.options.length)
                options.groups.push(preferredRunning);
            if (otherRunning.options.length)
                options.groups.push(otherRunning);
        }
        else {
            // Add kernelspecs first.
            options.groups.push({
                label: labels.startKernel,
                options: sorted.map(spec => optionForSpec(spec))
            });
            // Next add the no kernel option.
            options.groups.push(noKernel);
            // Add running kernels.
            options.groups.push({
                label: labels.connectKernel,
                options: kernels
                    .map(kernel => {
                    var _a, _b;
                    return optionForKernel(kernel, (_b = (_a = specs.kernelspecs[kernel.name]) === null || _a === void 0 ? void 0 : _a.display_name) !== null && _b !== void 0 ? _b : '', sessions[kernel.id]);
                })
                    .sort((a, b) => a.text.localeCompare(b.text))
            });
        }
        // Set the selected option.
        if (preference.id || currentKernelDisplayName || preference.name) {
            for (const group of options.groups) {
                for (const option of group.options) {
                    const choice = JSON.parse(option.value);
                    if (!choice)
                        continue;
                    if (preference.id) {
                        if (preference.id === choice.id) {
                            option.selected = true;
                            return options;
                        }
                        continue;
                    }
                    if (currentKernelDisplayName) {
                        if (currentKernelDisplayName ===
                            ((_g = specs.kernelspecs[choice.name]) === null || _g === void 0 ? void 0 : _g.display_name)) {
                            option.selected = true;
                            return options;
                        }
                        continue;
                    }
                    if (preference.name) {
                        if (preference.name === choice.name) {
                            option.selected = true;
                            return options;
                        }
                        continue;
                    }
                }
            }
        }
        return options;
    }
    SessionContextDialogs.kernelOptions = kernelOptions;
})(SessionContextDialogs || (SessionContextDialogs = {}));
/**
 * The namespace for module private data.
 */
var sessioncontext_Private;
(function (Private) {
    /**
     * Return a kernel selector widget.
     */
    Private.createKernelSelector = (sessionContext, translator) => new KernelSelector({
        node: createSelectorNode(sessionContext, translator)
    });
    /**
     * A widget that provides a kernel selection.
     */
    class KernelSelector extends index_es6_js_.Widget {
        /**
         * Get the value of the kernel selector widget.
         */
        getValue() {
            const selector = this.node.querySelector('select');
            return JSON.parse(selector.value);
        }
    }
    /**
     * Create an HTML node for a kernel selector widget.
     */
    function createSelectorNode(sessionContext, translator) {
        // Create the dialog body.
        translator = translator || lib_index_js_.nullTranslator;
        const trans = translator.load('jupyterlab');
        const body = document.createElement('div');
        const text = document.createElement('label');
        text.textContent = `${trans.__('Select kernel for:')} "${sessionContext.name}"`;
        body.appendChild(text);
        const select = document.createElement('select');
        const options = SessionContextDialogs.kernelOptions(sessionContext, translator);
        if (options.disabled)
            select.disabled = true;
        for (const group of options.groups) {
            const { label, options } = group;
            const optgroup = document.createElement('optgroup');
            optgroup.label = label;
            for (const { selected, text, title, value } of options) {
                const option = document.createElement('option');
                if (selected)
                    option.selected = true;
                if (title)
                    option.title = title;
                option.text = text;
                option.value = value;
                optgroup.appendChild(option);
            }
            select.appendChild(optgroup);
        }
        body.appendChild(select);
        return body;
    }
    /**
     * Get the default kernel name given select options.
     */
    function getDefaultKernel(options) {
        var _a;
        const { specs, preference } = options;
        const { name, language, canStart, autoStartDefault } = preference;
        if (!specs || canStart === false) {
            return null;
        }
        const defaultName = autoStartDefault ? specs.default : null;
        if (!name && !language) {
            return defaultName;
        }
        // Look for an exact match of a spec name.
        for (const specName in specs.kernelspecs) {
            if (specName === name) {
                return name;
            }
        }
        // Bail if there is no language.
        if (!language) {
            return defaultName;
        }
        // Check for a single kernel matching the language.
        const matches = [];
        for (const specName in specs.kernelspecs) {
            const kernelLanguage = (_a = specs.kernelspecs[specName]) === null || _a === void 0 ? void 0 : _a.language;
            if (language === kernelLanguage) {
                matches.push(specName);
            }
        }
        if (matches.length === 1) {
            const specName = matches[0];
            console.warn('No exact match found for ' +
                specName +
                ', using kernel ' +
                specName +
                ' that matches ' +
                'language=' +
                language);
            return specName;
        }
        // No matches found.
        return defaultName;
    }
    Private.getDefaultKernel = getDefaultKernel;
})(sessioncontext_Private || (sessioncontext_Private = {}));
//# sourceMappingURL=sessioncontext.js.map
// EXTERNAL MODULE: consume shared module (default) @jupyterlab/statusbar@~4.4.5 (singleton) (fallback: ../node_modules/@jupyterlab/statusbar/lib/index.js)
var statusbar_lib_index_js_ = __webpack_require__(74878);
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/apputils/lib/kernelstatuses.js
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.





/**
 * Helper function to translate kernel statuses mapping by using
 * input translator.
 *
 * @param translator - Language translator.
 * @return The translated kernel status mapping.
 */
function translateKernelStatuses(translator) {
    translator = translator || lib_index_js_.nullTranslator;
    const trans = translator.load('jupyterlab');
    const translated = {
        unknown: trans.__('Unknown'),
        starting: trans.__('Starting'),
        idle: trans.__('Idle'),
        busy: trans.__('Busy'),
        terminating: trans.__('Terminating'),
        restarting: trans.__('Restarting'),
        autorestarting: trans.__('Autorestarting'),
        dead: trans.__('Dead'),
        connected: trans.__('Connected'),
        connecting: trans.__('Connecting'),
        disconnected: trans.__('Disconnected'),
        initializing: trans.__('Initializing'),
        '': ''
    };
    return translated;
}
/**
 * A pure functional component for rendering kernel status.
 */
function KernelStatusComponent(props) {
    const translator = props.translator || lib_index_js_.nullTranslator;
    const trans = translator.load('jupyterlab');
    let statusText = '';
    if (props.status) {
        statusText = ` | ${props.status}`;
    }
    return (react_index_js_default().createElement(statusbar_lib_index_js_.TextItem, { role: "button", "aria-haspopup": true, onClick: props.handleClick, onKeyDown: props.handleKeyDown, source: `${props.kernelName}${statusText}`, title: trans.__('Change kernel for %1', props.activityName), tabIndex: 0 }));
}
/**
 * A VDomRenderer widget for displaying the status of a kernel.
 */
class KernelStatus extends index_js_.VDomRenderer {
    /**
     * Construct the kernel status widget.
     */
    constructor(opts, translator) {
        super(new KernelStatus.Model(translator));
        this.translator = translator || lib_index_js_.nullTranslator;
        this._handleClick = opts.onClick;
        this._handleKeyDown = opts.onKeyDown;
        this.addClass('jp-mod-highlighted');
    }
    /**
     * Render the kernel status item.
     */
    render() {
        if (this.model === null) {
            return null;
        }
        else {
            return (react_index_js_default().createElement(KernelStatusComponent, { status: this.model.status, kernelName: this.model.kernelName, activityName: this.model.activityName, handleClick: this._handleClick, handleKeyDown: this._handleKeyDown, translator: this.translator }));
        }
    }
}
/**
 * A namespace for KernelStatus statics.
 */
(function (KernelStatus) {
    /**
     * A VDomModel for the kernel status indicator.
     */
    class Model extends index_js_.VDomModel {
        constructor(translator) {
            super();
            this._activityName = '';
            this._kernelName = '';
            this._kernelStatus = '';
            this._sessionContext = null;
            translator = translator !== null && translator !== void 0 ? translator : lib_index_js_.nullTranslator;
            this._trans = translator.load('jupyterlab');
            this._statusNames = translateKernelStatuses(translator);
        }
        /**
         * The name of the kernel.
         */
        get kernelName() {
            return this._kernelName;
        }
        /**
         * The current status of the kernel.
         */
        get status() {
            return this._kernelStatus
                ? this._statusNames[this._kernelStatus]
                : undefined;
        }
        /**
         * A display name for the activity.
         */
        get activityName() {
            return this._activityName;
        }
        set activityName(val) {
            const oldVal = this._activityName;
            if (oldVal === val) {
                return;
            }
            this._activityName = val;
            this.stateChanged.emit();
        }
        /**
         * The current client session associated with the kernel status indicator.
         */
        get sessionContext() {
            return this._sessionContext;
        }
        set sessionContext(sessionContext) {
            var _a, _b, _c, _d;
            (_a = this._sessionContext) === null || _a === void 0 ? void 0 : _a.statusChanged.disconnect(this._onKernelStatusChanged, this);
            (_b = this._sessionContext) === null || _b === void 0 ? void 0 : _b.connectionStatusChanged.disconnect(this._onKernelStatusChanged, this);
            (_c = this._sessionContext) === null || _c === void 0 ? void 0 : _c.kernelChanged.disconnect(this._onKernelChanged, this);
            const oldState = this._getAllState();
            this._sessionContext = sessionContext;
            this._kernelStatus = sessionContext === null || sessionContext === void 0 ? void 0 : sessionContext.kernelDisplayStatus;
            this._kernelName =
                (_d = sessionContext === null || sessionContext === void 0 ? void 0 : sessionContext.kernelDisplayName) !== null && _d !== void 0 ? _d : this._trans.__('No Kernel');
            sessionContext === null || sessionContext === void 0 ? void 0 : sessionContext.statusChanged.connect(this._onKernelStatusChanged, this);
            sessionContext === null || sessionContext === void 0 ? void 0 : sessionContext.connectionStatusChanged.connect(this._onKernelStatusChanged, this);
            sessionContext === null || sessionContext === void 0 ? void 0 : sessionContext.kernelChanged.connect(this._onKernelChanged, this);
            this._triggerChange(oldState, this._getAllState());
        }
        /**
         * React to changes to the kernel status.
         */
        _onKernelStatusChanged() {
            var _a;
            this._kernelStatus = (_a = this._sessionContext) === null || _a === void 0 ? void 0 : _a.kernelDisplayStatus;
            this.stateChanged.emit(void 0);
        }
        /**
         * React to changes in the kernel.
         */
        _onKernelChanged(_sessionContext, change) {
            var _a;
            const oldState = this._getAllState();
            // sync setting of status and display name
            this._kernelStatus = (_a = this._sessionContext) === null || _a === void 0 ? void 0 : _a.kernelDisplayStatus;
            this._kernelName = _sessionContext.kernelDisplayName;
            this._triggerChange(oldState, this._getAllState());
        }
        _getAllState() {
            return [this._kernelName, this._kernelStatus, this._activityName];
        }
        _triggerChange(oldState, newState) {
            if (dist_index_js_.JSONExt.deepEqual(oldState, newState)) {
                this.stateChanged.emit(void 0);
            }
        }
    }
    KernelStatus.Model = Model;
})(KernelStatus || (KernelStatus = {}));
//# sourceMappingURL=kernelstatuses.js.map
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/apputils/lib/toolbar/widget.js
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.






/**
 * The class name added to toolbar kernel name text.
 */
const TOOLBAR_KERNEL_NAME_CLASS = 'jp-Toolbar-kernelName';
/**
 * The class name added to toolbar kernel status icon.
 */
const TOOLBAR_KERNEL_STATUS_CLASS = 'jp-Toolbar-kernelStatus';
/**
 * The namespace for Toolbar class statics.
 */
var widget_Toolbar;
(function (Toolbar) {
    /**
     * Create an interrupt toolbar item.
     *
     * @deprecated since version v3.2
     * This is dead code now.
     */
    function createInterruptButton(sessionContext, translator) {
        translator = translator || lib_index_js_.nullTranslator;
        const trans = translator.load('jupyterlab');
        return new index_js_.ToolbarButton({
            icon: index_js_.stopIcon,
            onClick: () => {
                var _a, _b;
                void ((_b = (_a = sessionContext.session) === null || _a === void 0 ? void 0 : _a.kernel) === null || _b === void 0 ? void 0 : _b.interrupt());
            },
            tooltip: trans.__('Interrupt the kernel')
        });
    }
    Toolbar.createInterruptButton = createInterruptButton;
    /**
     * Create a restart toolbar item.
     *
     * @deprecated since v3.2
     * This is dead code now.
     */
    function createRestartButton(sessionContext, dialogs, translator) {
        translator = translator !== null && translator !== void 0 ? translator : lib_index_js_.nullTranslator;
        const trans = translator.load('jupyterlab');
        return new index_js_.ToolbarButton({
            icon: index_js_.refreshIcon,
            onClick: () => {
                void (dialogs !== null && dialogs !== void 0 ? dialogs : new SessionContextDialogs({ translator })).restart(sessionContext);
            },
            tooltip: trans.__('Restart the kernel')
        });
    }
    Toolbar.createRestartButton = createRestartButton;
    /**
     * Create a kernel name indicator item.
     *
     * #### Notes
     * It will display the `'display_name`' of the session context. It can
     * handle a change in context or kernel.
     */
    function createKernelNameItem(sessionContext, dialogs, translator) {
        const el = index_js_.ReactWidget.create(react_index_js_.createElement(widget_Private.KernelNameComponent, { sessionContext: sessionContext, dialogs: dialogs !== null && dialogs !== void 0 ? dialogs : new SessionContextDialogs({ translator }), translator: translator }));
        el.addClass('jp-KernelName');
        return el;
    }
    Toolbar.createKernelNameItem = createKernelNameItem;
    /**
     * Create a kernel status indicator item.
     *
     * @deprecated since v3.5
     * The kernel status indicator is now replaced by the execution status indicator.
     *
     * #### Notes
     * It will show a busy status if the kernel status is busy.
     * It will show the current status in the node title.
     * It can handle a change to the context or the kernel.
     */
    function createKernelStatusItem(sessionContext, translator) {
        return new widget_Private.KernelStatus(sessionContext, translator);
    }
    Toolbar.createKernelStatusItem = createKernelStatusItem;
})(widget_Toolbar || (widget_Toolbar = {}));
/**
 * A namespace for private data.
 */
var widget_Private;
(function (Private) {
    /**
     * React component for a kernel name button.
     *
     * This wraps the ToolbarButtonComponent and watches the kernel
     * session for changes.
     */
    function KernelNameComponent(props) {
        const translator = props.translator || lib_index_js_.nullTranslator;
        const trans = translator.load('jupyterlab');
        const callback = () => {
            void props.dialogs.selectKernel(props.sessionContext);
        };
        return (react_index_js_.createElement(index_js_.UseSignal, { signal: props.sessionContext.kernelChanged, initialSender: props.sessionContext }, sessionContext => (react_index_js_.createElement(index_js_.ToolbarButtonComponent, { className: TOOLBAR_KERNEL_NAME_CLASS, onClick: callback, tooltip: trans.__('Switch kernel'), label: sessionContext === null || sessionContext === void 0 ? void 0 : sessionContext.kernelDisplayName }))));
    }
    Private.KernelNameComponent = KernelNameComponent;
    /**
     * A toolbar item that displays kernel status.
     *
     * @deprecated This code is not use any longer and will be removed in JupyterLab 5
     */
    class KernelStatus extends index_es6_js_.Widget {
        /**
         * Construct a new kernel status widget.
         */
        constructor(sessionContext, translator) {
            super();
            this.translator = translator || lib_index_js_.nullTranslator;
            this._trans = this.translator.load('jupyterlab');
            this.addClass(TOOLBAR_KERNEL_STATUS_CLASS);
            this._statusNames = translateKernelStatuses(this.translator);
            this._onStatusChanged(sessionContext);
            sessionContext.statusChanged.connect(this._onStatusChanged, this);
            sessionContext.connectionStatusChanged.connect(this._onStatusChanged, this);
        }
        /**
         * Handle a status on a kernel.
         */
        _onStatusChanged(sessionContext) {
            if (this.isDisposed) {
                return;
            }
            const status = sessionContext.kernelDisplayStatus;
            const circleIconProps = {
                container: this.node,
                title: this._trans.__('Kernel %1', this._statusNames[status] || status),
                stylesheet: 'toolbarButton',
                alignSelf: 'normal',
                height: '24px'
            };
            // set the icon
            index_js_.LabIcon.remove(this.node);
            if (status === 'busy' ||
                status === 'starting' ||
                status === 'terminating' ||
                status === 'restarting' ||
                status === 'initializing') {
                index_js_.circleIcon.element(circleIconProps);
            }
            else if (status === 'connecting' ||
                status === 'disconnected' ||
                status === 'unknown') {
                index_js_.offlineBoltIcon.element(circleIconProps);
            }
            else {
                index_js_.circleEmptyIcon.element(circleIconProps);
            }
        }
    }
    Private.KernelStatus = KernelStatus;
})(widget_Private || (widget_Private = {}));
//# sourceMappingURL=widget.js.map
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/apputils/lib/clipboard.js
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.

/**
 * The clipboard interface.
 */
var Clipboard;
(function (Clipboard) {
    /**
     * Get the application clipboard instance.
     */
    function getInstance() {
        return clipboard_Private.instance;
    }
    Clipboard.getInstance = getInstance;
    /**
     * Set the application clipboard instance.
     */
    function setInstance(value) {
        clipboard_Private.instance = value;
    }
    Clipboard.setInstance = setInstance;
    /**
     * Copy text to the system clipboard.
     *
     * #### Notes
     * This can only be called in response to a user input event.
     */
    function copyToSystem(clipboardData) {
        const node = document.body;
        const handler = (event) => {
            const data = event.clipboardData || window.clipboardData;
            if (typeof clipboardData === 'string') {
                data.setData('text', clipboardData);
            }
            else {
                clipboardData.types().map((mimeType) => {
                    data.setData(mimeType, clipboardData.getData(mimeType));
                });
            }
            event.preventDefault();
            node.removeEventListener('copy', handler);
        };
        node.addEventListener('copy', handler);
        generateEvent(node);
    }
    Clipboard.copyToSystem = copyToSystem;
    /**
     * Generate a clipboard event on a node.
     *
     * @param node - The element on which to generate the event.
     *
     * @param type - The type of event to generate.
     *   `'paste'` events cannot be programmatically generated.
     *
     * #### Notes
     * This can only be called in response to a user input event.
     */
    function generateEvent(node, type = 'copy') {
        // http://stackoverflow.com/a/5210367
        // Identify selected text.
        let sel = window.getSelection();
        // Save the current selection.
        const savedRanges = [];
        for (let i = 0, len = (sel === null || sel === void 0 ? void 0 : sel.rangeCount) || 0; i < len; ++i) {
            savedRanges[i] = sel.getRangeAt(i).cloneRange();
        }
        // Select the node content.
        const range = document.createRange();
        range.selectNodeContents(node);
        if (sel) {
            sel.removeAllRanges();
            sel.addRange(range);
        }
        // Execute the command.
        document.execCommand(type);
        // Restore the previous selection.
        sel = window.getSelection();
        if (sel) {
            sel.removeAllRanges();
            for (let i = 0, len = savedRanges.length; i < len; ++i) {
                sel.addRange(savedRanges[i]);
            }
        }
    }
    Clipboard.generateEvent = generateEvent;
})(Clipboard || (Clipboard = {}));
/**
 * The namespace for module private data.
 */
var clipboard_Private;
(function (Private) {
    /**
     * The application clipboard instance.
     */
    Private.instance = new dist_index_js_.MimeData();
})(clipboard_Private || (clipboard_Private = {}));
//# sourceMappingURL=clipboard.js.map
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/apputils/lib/commandlinker.js
/* -----------------------------------------------------------------------------
| Copyright (c) Jupyter Development Team.
| Distributed under the terms of the Modified BSD License.
|----------------------------------------------------------------------------*/

/**
 * The command data attribute added to nodes that are connected.
 */
const COMMAND_ATTR = 'commandlinker-command';
/**
 * The args data attribute added to nodes that are connected.
 */
const ARGS_ATTR = 'commandlinker-args';
/**
 * A static class that provides helper methods to generate clickable nodes that
 * execute registered commands with pre-populated arguments.
 */
class CommandLinker {
    /**
     * Instantiate a new command linker.
     */
    constructor(options) {
        this._isDisposed = false;
        this._commands = options.commands;
        document.body.addEventListener('click', this);
    }
    /**
     * Test whether the linker is disposed.
     */
    get isDisposed() {
        return this._isDisposed;
    }
    /**
     * Dispose of the resources held by the linker.
     */
    dispose() {
        if (this.isDisposed) {
            return;
        }
        this._isDisposed = true;
        document.body.removeEventListener('click', this);
    }
    /**
     * Connect a command/argument pair to a given node so that when it is clicked,
     * the command will execute.
     *
     * @param node - The node being connected.
     *
     * @param command - The command ID to execute upon click.
     *
     * @param args - The arguments with which to invoke the command.
     *
     * @returns The same node that was passed in, after it has been connected.
     *
     * #### Notes
     * Only `click` events will execute the command on a connected node. So, there
     * are two considerations that are relevant:
     * 1. If a node is connected, the default click action will be prevented.
     * 2. The `HTMLElement` passed in should be clickable.
     */
    connectNode(node, command, args) {
        node.setAttribute(`data-${COMMAND_ATTR}`, command);
        if (args !== void 0) {
            node.setAttribute(`data-${ARGS_ATTR}`, JSON.stringify(args));
        }
        return node;
    }
    /**
     * Disconnect a node that has been connected to execute a command on click.
     *
     * @param node - The node being disconnected.
     *
     * @returns The same node that was passed in, after it has been disconnected.
     *
     * #### Notes
     * This method is safe to call multiple times and is safe to call on nodes
     * that were never connected.
     *
     * This method can be called on rendered virtual DOM nodes that were populated
     * using the `populateVNodeDataset` method in order to disconnect them from
     * executing their command/argument pair.
     */
    disconnectNode(node) {
        node.removeAttribute(`data-${COMMAND_ATTR}`);
        node.removeAttribute(`data-${ARGS_ATTR}`);
        return node;
    }
    /**
     * Handle the DOM events for the command linker helper class.
     *
     * @param event - The DOM event sent to the class.
     *
     * #### Notes
     * This method implements the DOM `EventListener` interface and is
     * called in response to events on the panel's DOM node. It should
     * not be called directly by user code.
     */
    handleEvent(event) {
        switch (event.type) {
            case 'click':
                this._evtClick(event);
                break;
            default:
                return;
        }
    }
    /**
     * Populate the `dataset` attribute within the collection of attributes used
     * to instantiate a virtual DOM node with the values necessary for its
     * rendered DOM node to respond to clicks by executing a command/argument
     * pair.
     *
     * @param command - The command ID to execute upon click.
     *
     * @param args - The arguments with which to invoke the command.
     *
     * @returns A `dataset` collection for use within virtual node attributes.
     *
     * #### Notes
     * The return value can be used on its own as the value for the `dataset`
     * attribute of a virtual element, or it can be added to an existing `dataset`
     * as in the example below.
     *
     * #### Example
     * ```typescript
     * let command = 'some:command-id';
     * let args = { alpha: 'beta' };
     * let anchor = h.a({
     *   className: 'some-class',
     *   dataset: {
     *     foo: '1',
     *     bar: '2',
     *     ../...linker.populateVNodeDataset(command, args)
     *   }
     * }, 'some text');
     * ```
     */
    populateVNodeDataset(command, args) {
        let dataset;
        if (args !== void 0) {
            dataset = { [ARGS_ATTR]: JSON.stringify(args), [COMMAND_ATTR]: command };
        }
        else {
            dataset = { [COMMAND_ATTR]: command };
        }
        return dataset;
    }
    /**
     * The global click handler that deploys commands/argument pairs that are
     * attached to the node being clicked.
     */
    _evtClick(event) {
        let target = event.target;
        while (target && target.parentElement) {
            if (target.hasAttribute(`data-${COMMAND_ATTR}`)) {
                event.preventDefault();
                const command = target.getAttribute(`data-${COMMAND_ATTR}`);
                if (!command) {
                    return;
                }
                const argsValue = target.getAttribute(`data-${ARGS_ATTR}`);
                let args = dist_index_js_.JSONExt.emptyObject;
                if (argsValue) {
                    args = JSON.parse(argsValue);
                }
                void this._commands.execute(command, args);
                return;
            }
            target = target.parentElement;
        }
    }
}
//# sourceMappingURL=commandlinker.js.map
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/apputils/lib/commandpalette.js
/* -----------------------------------------------------------------------------
| Copyright (c) Jupyter Development Team.
| Distributed under the terms of the Modified BSD License.
|----------------------------------------------------------------------------*/


/**
 * Class name identifying the input group with search icon.
 */
const SEARCH_ICON_GROUP_CLASS = 'jp-SearchIconGroup';
/**
 * Wrap the command palette in a modal to make it more usable.
 */
class ModalCommandPalette extends index_es6_js_.Panel {
    constructor(options) {
        super();
        this.addClass('jp-ModalCommandPalette');
        this.addClass('jp-ThemedContainer');
        this.id = 'modal-command-palette';
        this.palette = options.commandPalette;
        this._commandPalette.commands.commandExecuted.connect(() => {
            if (this.isAttached && this.isVisible) {
                this.hideAndReset();
            }
        });
        // required to properly receive blur and focus events;
        // selection of items with mouse may not work without this.
        this.node.tabIndex = 0;
    }
    get palette() {
        return this._commandPalette;
    }
    set palette(value) {
        this._commandPalette = value;
        if (!this.searchIconGroup) {
            this._commandPalette.inputNode.insertAdjacentElement('afterend', this.createSearchIconGroup());
        }
        this.addWidget(value);
        this.hideAndReset();
    }
    attach() {
        index_es6_js_.Widget.attach(this, document.body);
    }
    detach() {
        index_es6_js_.Widget.detach(this);
    }
    /**
     * Hide the modal command palette and reset its search.
     */
    hideAndReset() {
        this.hide();
        this._commandPalette.inputNode.value = '';
        this._commandPalette.refresh();
    }
    /**
     * Handle incoming events.
     */
    handleEvent(event) {
        switch (event.type) {
            case 'keydown':
                this._evtKeydown(event);
                break;
            case 'blur': {
                // if the focus shifted outside of this DOM element, hide and reset.
                if (
                // focus went away from child element
                this.node.contains(event.target) &&
                    // and it did NOT go to another child element but someplace else
                    !this.node.contains(event.relatedTarget)) {
                    event.stopPropagation();
                    this.hideAndReset();
                }
                break;
            }
            case 'contextmenu':
                event.preventDefault();
                event.stopPropagation();
                break;
            default:
                break;
        }
    }
    /**
     * Find the element with search icon group.
     */
    get searchIconGroup() {
        return this._commandPalette.node.getElementsByClassName(SEARCH_ICON_GROUP_CLASS)[0];
    }
    /**
     * Create element with search icon group.
     */
    createSearchIconGroup() {
        const inputGroup = document.createElement('div');
        inputGroup.classList.add(SEARCH_ICON_GROUP_CLASS);
        index_js_.searchIcon.render(inputGroup);
        return inputGroup;
    }
    /**
     *  A message handler invoked on an `'after-attach'` message.
     */
    onAfterAttach(msg) {
        this.node.addEventListener('keydown', this, true);
        this.node.addEventListener('contextmenu', this, true);
    }
    /**
     *  A message handler invoked on an `'after-detach'` message.
     */
    onAfterDetach(msg) {
        this.node.removeEventListener('keydown', this, true);
        this.node.removeEventListener('contextmenu', this, true);
    }
    onBeforeHide(msg) {
        document.removeEventListener('blur', this, true);
    }
    onAfterShow(msg) {
        document.addEventListener('blur', this, true);
    }
    /**
     * A message handler invoked on an `'activate-request'` message.
     */
    onActivateRequest(msg) {
        if (this.isAttached) {
            this.show();
            this._commandPalette.activate();
        }
    }
    /**
     * Handle the `'keydown'` event for the widget.
     */
    _evtKeydown(event) {
        // Check for escape key
        switch (event.keyCode) {
            case 27: // Escape.
                event.stopPropagation();
                event.preventDefault();
                this.hideAndReset();
                break;
            default:
                break;
        }
    }
}
//# sourceMappingURL=commandpalette.js.map
// EXTERNAL MODULE: consume shared module (default) @lumino/domutils@~2.0.3 (singleton) (fallback: ../node_modules/@lumino/domutils/dist/index.es6.js)
var domutils_dist_index_es6_js_ = __webpack_require__(23738);
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/apputils/lib/domutils.js
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.



/**
 * The namespace for DOM utilities.
 */
var DOMUtils;
(function (DOMUtils) {
    /**
     * Get the index of the node at a client position, or `-1`.
     */
    function hitTestNodes(nodes, x, y) {
        return dist_index_es6_js_.ArrayExt.findFirstIndex(nodes, node => {
            return domutils_dist_index_es6_js_.ElementExt.hitTest(node, x, y);
        });
    }
    DOMUtils.hitTestNodes = hitTestNodes;
    /**
     * Find the first element matching a class name.
     * Only use this function when the element existence is guaranteed.
     */
    function findElement(parent, className) {
        return parent.querySelector(`.${className}`);
    }
    DOMUtils.findElement = findElement;
    /**
     * Find the first element matching a class name.
     */
    function findElements(parent, className) {
        return parent.getElementsByClassName(className);
    }
    DOMUtils.findElements = findElements;
    /**
     * Create a DOM id with prefix "id-" to solve bug for UUIDs beginning with numbers.
     */
    function createDomID() {
        return `id-${dist_index_js_.UUID.uuid4()}`;
    }
    DOMUtils.createDomID = createDomID;
    /**
     * Check whether the active element descendant from given parent is editable.
     * When checking active elements it includes elements in the open shadow DOM.
     */
    function hasActiveEditableElement(parent, root = document) {
        const element = root.activeElement;
        return !!(element &&
            parent.contains(element) &&
            (element.matches(':read-write') ||
                (element.shadowRoot &&
                    hasActiveEditableElement(element.shadowRoot, element.shadowRoot))));
    }
    DOMUtils.hasActiveEditableElement = hasActiveEditableElement;
})(DOMUtils || (DOMUtils = {}));
//# sourceMappingURL=domutils.js.map
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/apputils/lib/inputdialog.js
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.


const INPUT_DIALOG_CLASS = 'jp-Input-Dialog';
const INPUT_BOOLEAN_DIALOG_CLASS = 'jp-Input-Boolean-Dialog';
/**
 * Namespace for input dialogs
 */
var InputDialog;
(function (InputDialog) {
    /**
     * Create and show a input dialog for a boolean.
     *
     * @param options - The dialog setup options.
     *
     * @returns A promise that resolves with whether the dialog was accepted
     */
    function getBoolean(options) {
        return showDialog({
            ...options,
            body: new InputBooleanDialog(options),
            buttons: [
                Dialog.cancelButton({ label: options.cancelLabel }),
                Dialog.okButton({ label: options.okLabel })
            ],
            focusNodeSelector: 'input'
        });
    }
    InputDialog.getBoolean = getBoolean;
    /**
     * Create and show a input dialog for a number.
     *
     * @param options - The dialog setup options.
     *
     * @returns A promise that resolves with whether the dialog was accepted
     */
    function getNumber(options) {
        return showDialog({
            ...options,
            body: new InputNumberDialog(options),
            buttons: [
                Dialog.cancelButton({ label: options.cancelLabel }),
                Dialog.okButton({ label: options.okLabel })
            ],
            focusNodeSelector: 'input'
        });
    }
    InputDialog.getNumber = getNumber;
    /**
     * Create and show a input dialog for a choice.
     *
     * @param options - The dialog setup options.
     *
     * @returns A promise that resolves with whether the dialog was accepted
     */
    function getItem(options) {
        return showDialog({
            ...options,
            body: new InputItemsDialog(options),
            buttons: [
                Dialog.cancelButton({ label: options.cancelLabel }),
                Dialog.okButton({ label: options.okLabel })
            ],
            focusNodeSelector: options.editable ? 'input' : 'select'
        });
    }
    InputDialog.getItem = getItem;
    /**
     * Create and show a input dialog for a choice.
     *
     * @param options - The dialog setup options.
     *
     * @returns A promise that resolves with whether the dialog was accepted
     */
    function getMultipleItems(options) {
        return showDialog({
            ...options,
            body: new InputMultipleItemsDialog(options),
            buttons: [
                Dialog.cancelButton({ label: options.cancelLabel }),
                Dialog.okButton({ label: options.okLabel })
            ]
        });
    }
    InputDialog.getMultipleItems = getMultipleItems;
    /**
     * Create and show a input dialog for a text.
     *
     * @param options - The dialog setup options.
     *
     * @returns A promise that resolves with whether the dialog was accepted
     */
    function getText(options) {
        return showDialog({
            ...options,
            body: new InputTextDialog(options),
            buttons: [
                Dialog.cancelButton({ label: options.cancelLabel }),
                Dialog.okButton({ label: options.okLabel })
            ],
            focusNodeSelector: 'input'
        });
    }
    InputDialog.getText = getText;
    /**
     * Create and show a input dialog for a password.
     *
     * @param options - The dialog setup options.
     *
     * @returns A promise that resolves with whether the dialog was accepted
     */
    function getPassword(options) {
        return showDialog({
            ...options,
            body: new InputPasswordDialog(options),
            buttons: [
                Dialog.cancelButton({ label: options.cancelLabel }),
                Dialog.okButton({ label: options.okLabel })
            ],
            focusNodeSelector: 'input'
        });
    }
    InputDialog.getPassword = getPassword;
})(InputDialog || (InputDialog = {}));
/**
 * Base widget for input dialog body
 */
class InputDialogBase extends index_es6_js_.Widget {
    /**
     * InputDialog constructor
     *
     * @param label Input field label
     */
    constructor(options) {
        super();
        this.addClass(INPUT_DIALOG_CLASS);
        this._input = document.createElement('input');
        this._input.classList.add('jp-mod-styled');
        this._input.id = 'jp-dialog-input-id';
        if (options.label !== undefined) {
            const labelElement = document.createElement('label');
            labelElement.textContent = options.label;
            labelElement.htmlFor = this._input.id;
            // Initialize the node
            this.node.appendChild(labelElement);
        }
        const wrapper = document.createElement('div');
        wrapper.className = 'jp-InputDialog-inputWrapper';
        if (options.prefix) {
            const prefix = document.createElement('span');
            prefix.className = 'jp-InputDialog-inputPrefix';
            prefix.textContent = options.prefix;
            // Both US WDS (https://designsystem.digital.gov/components/input-prefix-suffix/)
            // and UK DS (https://design-system.service.gov.uk/components/text-input/) recommend
            // hiding prefixes and suffixes from screen readers.
            prefix.ariaHidden = 'true';
            wrapper.appendChild(prefix);
        }
        wrapper.appendChild(this._input);
        if (options.suffix) {
            const suffix = document.createElement('span');
            suffix.className = 'jp-InputDialog-inputSuffix';
            suffix.textContent = options.suffix;
            suffix.ariaHidden = 'true';
            wrapper.appendChild(suffix);
        }
        this.node.appendChild(wrapper);
    }
}
/**
 * Widget body for input boolean dialog
 */
class InputBooleanDialog extends InputDialogBase {
    /**
     * InputBooleanDialog constructor
     *
     * @param options Constructor options
     */
    constructor(options) {
        super(options);
        this.addClass(INPUT_BOOLEAN_DIALOG_CLASS);
        this._input.type = 'checkbox';
        this._input.checked = options.value ? true : false;
    }
    /**
     * Get the text specified by the user
     */
    getValue() {
        return this._input.checked;
    }
}
/**
 * Widget body for input number dialog
 */
class InputNumberDialog extends InputDialogBase {
    /**
     * InputNumberDialog constructor
     *
     * @param options Constructor options
     */
    constructor(options) {
        super(options);
        this._input.type = 'number';
        this._input.value = options.value ? options.value.toString() : '0';
    }
    /**
     * Get the number specified by the user.
     */
    getValue() {
        if (this._input.value) {
            return Number(this._input.value);
        }
        else {
            return Number.NaN;
        }
    }
}
/**
 * Base widget body for input text/password/email dialog
 */
class InputDialogTextBase extends InputDialogBase {
    /**
     * InputDialogTextBase constructor
     *
     * @param options Constructor options
     */
    constructor(options) {
        super(options);
        this._input.value = options.text ? options.text : '';
        if (options.placeholder) {
            this._input.placeholder = options.placeholder;
        }
        if (options.pattern) {
            this._input.pattern = options.pattern;
        }
        if (options.required) {
            this._input.required = options.required;
        }
    }
    /**
     * Get the text specified by the user
     */
    getValue() {
        return this._input.value;
    }
}
/**
 * Widget body for input text dialog
 */
class InputTextDialog extends InputDialogTextBase {
    /**
     * InputTextDialog constructor
     *
     * @param options Constructor options
     */
    constructor(options) {
        var _a;
        super(options);
        this._input.type = 'text';
        this._initialSelectionRange = Math.min(this._input.value.length, Math.max(0, (_a = options.selectionRange) !== null && _a !== void 0 ? _a : this._input.value.length));
    }
    /**
     *  A message handler invoked on an `'after-attach'` message.
     */
    onAfterAttach(msg) {
        super.onAfterAttach(msg);
        if (this._initialSelectionRange > 0 && this._input.value) {
            this._input.setSelectionRange(0, this._initialSelectionRange);
        }
    }
}
/**
 * Widget body for input password dialog
 */
class InputPasswordDialog extends InputDialogTextBase {
    /**
     * InputPasswordDialog constructor
     *
     * @param options Constructor options
     */
    constructor(options) {
        super(options);
        this._input.type = 'password';
    }
    /**
     *  A message handler invoked on an `'after-attach'` message.
     */
    onAfterAttach(msg) {
        super.onAfterAttach(msg);
        if (this._input.value) {
            this._input.select();
        }
    }
}
/**
 * Widget body for input list dialog
 */
class InputItemsDialog extends InputDialogBase {
    /**
     * InputItemsDialog constructor
     *
     * @param options Constructor options
     */
    constructor(options) {
        super(options);
        this._editable = options.editable || false;
        let current = options.current || 0;
        let defaultIndex;
        if (typeof current === 'number') {
            defaultIndex = Math.max(0, Math.min(current, options.items.length - 1));
            current = '';
        }
        this._list = document.createElement('select');
        options.items.forEach((item, index) => {
            const option = document.createElement('option');
            if (index === defaultIndex) {
                option.selected = true;
                current = item;
            }
            option.value = item;
            option.textContent = item;
            this._list.appendChild(option);
        });
        if (options.editable) {
            /* Use of list and datalist */
            const data = document.createElement('datalist');
            data.id = 'input-dialog-items';
            data.appendChild(this._list);
            this._input.type = 'list';
            this._input.value = current;
            this._input.setAttribute('list', data.id);
            if (options.placeholder) {
                this._input.placeholder = options.placeholder;
            }
            this.node.appendChild(data);
        }
        else {
            /* Use select directly */
            this._input.parentElement.replaceChild(this._list, this._input);
        }
    }
    /**
     * Get the user choice
     */
    getValue() {
        if (this._editable) {
            return this._input.value;
        }
        else {
            return this._list.value;
        }
    }
}
/**
 * Widget body for input list dialog
 */
class InputMultipleItemsDialog extends InputDialogBase {
    /**
     * InputMultipleItemsDialog constructor
     *
     * @param options Constructor options
     */
    constructor(options) {
        super(options);
        let defaults = options.defaults || [];
        this._list = document.createElement('select');
        this._list.setAttribute('multiple', '');
        options.items.forEach(item => {
            const option = document.createElement('option');
            option.value = item;
            option.textContent = item;
            this._list.appendChild(option);
        });
        // use the select
        this._input.remove();
        this.node.appendChild(this._list);
        // select the current ones
        const htmlOptions = this._list.options;
        for (let i = 0; i < htmlOptions.length; i++) {
            const option = htmlOptions[i];
            if (defaults.includes(option.value)) {
                option.selected = true;
            }
            else {
                option.selected = false;
            }
        }
    }
    /**
     * Get the user choices
     */
    getValue() {
        let result = [];
        for (let opt of this._list.options) {
            if (opt.selected && !opt.classList.contains('hidden')) {
                result.push(opt.value || opt.text);
            }
        }
        return result;
    }
}
//# sourceMappingURL=inputdialog.js.map
// EXTERNAL MODULE: consume shared module (default) @jupyterlab/services@~7.4.5 (singleton) (fallback: ../node_modules/@jupyterlab/services/lib/index.js)
var services_lib_index_js_ = __webpack_require__(19838);
// EXTERNAL MODULE: consume shared module (default) @lumino/virtualdom@~2.0.3 (singleton) (fallback: ../node_modules/@lumino/virtualdom/dist/index.es6.js)
var virtualdom_dist_index_es6_js_ = __webpack_require__(67458);
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/apputils/lib/licenses.js
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.







const FILTER_SECTION_TITLE_CLASS = 'jp-Licenses-Filters-title';
/**
 * A license viewer
 */
class Licenses extends index_es6_js_.SplitPanel {
    constructor(options) {
        super();
        this.addClass('jp-Licenses');
        this.model = options.model;
        this.initLeftPanel();
        this.initFilters();
        this.initBundles();
        this.initGrid();
        this.initLicenseText();
        this.setRelativeSizes([1, 2, 3]);
        void this.model.initLicenses().then(() => this._updateBundles());
        this.model.trackerDataChanged.connect(() => {
            this.title.label = this.model.title;
        });
    }
    /**
     * Handle disposing of the widget
     */
    dispose() {
        if (this.isDisposed) {
            return;
        }
        this._bundles.currentChanged.disconnect(this.onBundleSelected, this);
        this.model.dispose();
        super.dispose();
    }
    /**
     * Initialize the left area for filters and bundles
     */
    initLeftPanel() {
        this._leftPanel = new index_es6_js_.Panel();
        this._leftPanel.addClass('jp-Licenses-FormArea');
        this.addWidget(this._leftPanel);
        index_es6_js_.SplitPanel.setStretch(this._leftPanel, 1);
    }
    /**
     * Initialize the filters
     */
    initFilters() {
        this._filters = new Licenses.Filters(this.model);
        index_es6_js_.SplitPanel.setStretch(this._filters, 1);
        this._leftPanel.addWidget(this._filters);
    }
    /**
     * Initialize the listing of available bundles
     */
    initBundles() {
        this._bundles = new index_es6_js_.TabBar({
            orientation: 'vertical',
            renderer: new Licenses.BundleTabRenderer(this.model)
        });
        this._bundles.addClass('jp-Licenses-Bundles');
        index_es6_js_.SplitPanel.setStretch(this._bundles, 1);
        this._leftPanel.addWidget(this._bundles);
        this._bundles.currentChanged.connect(this.onBundleSelected, this);
        this.model.stateChanged.connect(() => this._bundles.update());
    }
    /**
     * Initialize the listing of packages within the current bundle
     */
    initGrid() {
        this._grid = new Licenses.Grid(this.model);
        index_es6_js_.SplitPanel.setStretch(this._grid, 1);
        this.addWidget(this._grid);
    }
    /**
     * Initialize the full text of the current package
     */
    initLicenseText() {
        this._licenseText = new Licenses.FullText(this.model);
        index_es6_js_.SplitPanel.setStretch(this._grid, 1);
        this.addWidget(this._licenseText);
    }
    /**
     * Event handler for updating the model with the current bundle
     */
    onBundleSelected() {
        var _a;
        if ((_a = this._bundles.currentTitle) === null || _a === void 0 ? void 0 : _a.label) {
            this.model.currentBundleName = this._bundles.currentTitle.label;
        }
    }
    /**
     * Update the bundle tabs.
     */
    _updateBundles() {
        this._bundles.clearTabs();
        let i = 0;
        const { currentBundleName } = this.model;
        let currentIndex = 0;
        for (const bundle of this.model.bundleNames) {
            const tab = new index_es6_js_.Widget();
            tab.title.label = bundle;
            if (bundle === currentBundleName) {
                currentIndex = i;
            }
            this._bundles.insertTab(++i, tab.title);
        }
        this._bundles.currentIndex = currentIndex;
    }
}
/** A namespace for license components */
(function (Licenses) {
    /**
     * License report formats understood by the server (once lower-cased)
     */
    Licenses.REPORT_FORMATS = {
        markdown: {
            id: 'markdown',
            title: 'Markdown',
            icon: index_js_.markdownIcon
        },
        csv: {
            id: 'csv',
            title: 'CSV',
            icon: index_js_.spreadsheetIcon
        },
        json: {
            id: 'json',
            title: 'JSON',
            icon: index_js_.jsonIcon
        }
    };
    /**
     * The default format (most human-readable)
     */
    Licenses.DEFAULT_FORMAT = 'markdown';
    /**
     * A class used for fetching licenses from the server.
     */
    class LicensesClient {
        /**
         * Create a new license client.
         */
        constructor(options = {}) {
            var _a;
            this._licensesUrl = options.licensesUrl || '';
            this._serverSettings =
                (_a = options.serverSettings) !== null && _a !== void 0 ? _a : services_lib_index_js_.ServerConnection.makeSettings();
        }
        /**
         * Download the licenses in the requested format.
         */
        async download(options) {
            const url = `${this._licensesUrl}?format=${options.format}&download=1`;
            const element = document.createElement('a');
            element.href = url;
            element.download = '';
            document.body.appendChild(element);
            element.click();
            document.body.removeChild(element);
            URL.revokeObjectURL(url);
            return void 0;
        }
        /**
         * Fetch the license bundles from the server.
         */
        async getBundles() {
            const response = await services_lib_index_js_.ServerConnection.makeRequest(this._licensesUrl, {}, this._serverSettings);
            return response.json();
        }
    }
    Licenses.LicensesClient = LicensesClient;
    /**
     * A model for license data
     */
    class Model extends index_js_.VDomModel {
        constructor(options) {
            super();
            this._selectedPackageChanged = new signaling_dist_index_es6_js_.Signal(this);
            this._trackerDataChanged = new signaling_dist_index_es6_js_.Signal(this);
            this._currentPackageIndex = 0;
            this._licensesReady = new dist_index_js_.PromiseDelegate();
            this._packageFilter = {};
            this._trans = options.trans;
            this._client = options.client;
            if (options.currentBundleName) {
                this._currentBundleName = options.currentBundleName;
            }
            if (options.packageFilter) {
                this._packageFilter = options.packageFilter;
            }
            if (options.currentPackageIndex) {
                this._currentPackageIndex = options.currentPackageIndex;
            }
        }
        /**
         * Handle the initial request for the licenses from the server.
         */
        async initLicenses() {
            try {
                this._serverResponse = await this._client.getBundles();
                this._licensesReady.resolve();
                this.stateChanged.emit(void 0);
            }
            catch (err) {
                this._licensesReady.reject(err);
            }
        }
        /**
         * Download the licenses in the requested format.
         */
        async download(options) {
            return this._client.download(options);
        }
        /**
         * A promise that resolves when the licenses from the server change
         */
        get selectedPackageChanged() {
            return this._selectedPackageChanged;
        }
        /**
         * A promise that resolves when the trackable data changes
         */
        get trackerDataChanged() {
            return this._trackerDataChanged;
        }
        /**
         * The names of the license bundles available
         */
        get bundleNames() {
            var _a;
            return Object.keys(((_a = this._serverResponse) === null || _a === void 0 ? void 0 : _a.bundles) || {});
        }
        /**
         * The current license bundle
         */
        get currentBundleName() {
            if (this._currentBundleName) {
                return this._currentBundleName;
            }
            if (this.bundleNames.length) {
                return this.bundleNames[0];
            }
            return null;
        }
        /**
         * Set the current license bundle, and reset the selected index
         */
        set currentBundleName(currentBundleName) {
            if (this._currentBundleName !== currentBundleName) {
                this._currentBundleName = currentBundleName;
                this.stateChanged.emit(void 0);
                this._trackerDataChanged.emit(void 0);
            }
        }
        /**
         * A promise that resolves when the licenses are available from the server
         */
        get licensesReady() {
            return this._licensesReady.promise;
        }
        /**
         * All the license bundles, keyed by the distributing packages
         */
        get bundles() {
            var _a;
            return ((_a = this._serverResponse) === null || _a === void 0 ? void 0 : _a.bundles) || {};
        }
        /**
         * The index of the currently-selected package within its license bundle
         */
        get currentPackageIndex() {
            return this._currentPackageIndex;
        }
        /**
         * Update the currently-selected package within its license bundle
         */
        set currentPackageIndex(currentPackageIndex) {
            if (this._currentPackageIndex === currentPackageIndex) {
                return;
            }
            this._currentPackageIndex = currentPackageIndex;
            this._selectedPackageChanged.emit(void 0);
            this.stateChanged.emit(void 0);
            this._trackerDataChanged.emit(void 0);
        }
        /**
         * The license data for the currently-selected package
         */
        get currentPackage() {
            var _a;
            if (this.currentBundleName &&
                this.bundles &&
                this._currentPackageIndex != null) {
                return this.getFilteredPackages(((_a = this.bundles[this.currentBundleName]) === null || _a === void 0 ? void 0 : _a.packages) || [])[this._currentPackageIndex];
            }
            return null;
        }
        /**
         * A translation bundle
         */
        get trans() {
            return this._trans;
        }
        get title() {
            return `${this._currentBundleName || ''} ${this._trans.__('Licenses')}`.trim();
        }
        /**
         * The current package filter
         */
        get packageFilter() {
            return this._packageFilter;
        }
        set packageFilter(packageFilter) {
            this._packageFilter = packageFilter;
            this.stateChanged.emit(void 0);
            this._trackerDataChanged.emit(void 0);
        }
        /**
         * Get filtered packages from current bundle where at least one token of each
         * key is present.
         */
        getFilteredPackages(allRows) {
            let rows = [];
            let filters = Object.entries(this._packageFilter)
                .filter(([k, v]) => v && `${v}`.trim().length)
                .map(([k, v]) => [k, `${v}`.toLowerCase().trim().split(' ')]);
            for (const row of allRows) {
                let keyHits = 0;
                for (const [key, bits] of filters) {
                    let bitHits = 0;
                    let rowKeyValue = `${row[key]}`.toLowerCase();
                    for (const bit of bits) {
                        if (rowKeyValue.includes(bit)) {
                            bitHits += 1;
                        }
                    }
                    if (bitHits) {
                        keyHits += 1;
                    }
                }
                if (keyHits === filters.length) {
                    rows.push(row);
                }
            }
            return Object.values(rows);
        }
    }
    Licenses.Model = Model;
    /**
     * A filter form for limiting the packages displayed
     */
    class Filters extends index_js_.VDomRenderer {
        constructor(model) {
            super(model);
            /**
             * Render a filter input
             */
            this.renderFilter = (key) => {
                const value = this.model.packageFilter[key] || '';
                return (react_index_js_.createElement("input", { type: "text", name: key, defaultValue: value, className: "jp-mod-styled", onInput: this.onFilterInput }));
            };
            /**
             * Handle a filter input changing
             */
            this.onFilterInput = (evt) => {
                const input = evt.currentTarget;
                const { name, value } = input;
                this.model.packageFilter = { ...this.model.packageFilter, [name]: value };
            };
            this.addClass('jp-Licenses-Filters');
            this.addClass('jp-RenderedHTMLCommon');
        }
        render() {
            const { trans } = this.model;
            return (react_index_js_.createElement("div", null,
                react_index_js_.createElement("label", null,
                    react_index_js_.createElement("strong", { className: FILTER_SECTION_TITLE_CLASS }, trans.__('Filter Licenses By'))),
                react_index_js_.createElement("ul", null,
                    react_index_js_.createElement("li", null,
                        react_index_js_.createElement("label", null, trans.__('Package')),
                        this.renderFilter('name')),
                    react_index_js_.createElement("li", null,
                        react_index_js_.createElement("label", null, trans.__('Version')),
                        this.renderFilter('versionInfo')),
                    react_index_js_.createElement("li", null,
                        react_index_js_.createElement("label", null, trans.__('License')),
                        this.renderFilter('licenseId'))),
                react_index_js_.createElement("label", null,
                    react_index_js_.createElement("strong", { className: FILTER_SECTION_TITLE_CLASS }, trans.__('Distributions')))));
        }
    }
    Licenses.Filters = Filters;
    /**
     * A fancy bundle renderer with the package count
     */
    class BundleTabRenderer extends index_es6_js_.TabBar.Renderer {
        constructor(model) {
            super();
            this.closeIconSelector = '.lm-TabBar-tabCloseIcon';
            this.model = model;
        }
        /**
         * Render a full bundle
         */
        renderTab(data) {
            let title = data.title.caption;
            let key = this.createTabKey(data);
            let style = this.createTabStyle(data);
            let className = this.createTabClass(data);
            let dataset = this.createTabDataset(data);
            return virtualdom_dist_index_es6_js_.h.li({ key, className, title, style, dataset }, this.renderIcon(data), this.renderLabel(data), this.renderCountBadge(data));
        }
        /**
         * Render the package count
         */
        renderCountBadge(data) {
            const bundle = data.title.label;
            const { bundles } = this.model;
            const packages = this.model.getFilteredPackages((bundles && bundle ? bundles[bundle].packages : []) || []);
            return virtualdom_dist_index_es6_js_.h.label({}, `${packages.length}`);
        }
    }
    Licenses.BundleTabRenderer = BundleTabRenderer;
    /**
     * A grid of licenses
     */
    class Grid extends index_js_.VDomRenderer {
        constructor(model) {
            super(model);
            /**
             * Render a single package's license information
             */
            this.renderRow = (row, index) => {
                const selected = index === this.model.currentPackageIndex;
                const onCheck = () => (this.model.currentPackageIndex = index);
                return (react_index_js_.createElement("tr", { key: row.name, className: selected ? 'jp-mod-selected' : '', onClick: onCheck },
                    react_index_js_.createElement("td", null,
                        react_index_js_.createElement("input", { type: "radio", name: "show-package-license", value: index, onChange: onCheck, checked: selected })),
                    react_index_js_.createElement("th", null, row.name),
                    react_index_js_.createElement("td", null,
                        react_index_js_.createElement("code", null, row.versionInfo)),
                    react_index_js_.createElement("td", null,
                        react_index_js_.createElement("code", null, row.licenseId))));
            };
            this.addClass('jp-Licenses-Grid');
            this.addClass('jp-RenderedHTMLCommon');
        }
        /**
         * Render a grid of package license information
         */
        render() {
            var _a;
            const { bundles, currentBundleName, trans } = this.model;
            const filteredPackages = this.model.getFilteredPackages(bundles && currentBundleName
                ? ((_a = bundles[currentBundleName]) === null || _a === void 0 ? void 0 : _a.packages) || []
                : []);
            if (!filteredPackages.length) {
                return (react_index_js_.createElement("blockquote", null,
                    react_index_js_.createElement("em", null, trans.__('No Packages found'))));
            }
            return (react_index_js_.createElement("form", null,
                react_index_js_.createElement("table", null,
                    react_index_js_.createElement("thead", null,
                        react_index_js_.createElement("tr", null,
                            react_index_js_.createElement("td", null),
                            react_index_js_.createElement("th", null, trans.__('Package')),
                            react_index_js_.createElement("th", null, trans.__('Version')),
                            react_index_js_.createElement("th", null, trans.__('License')))),
                    react_index_js_.createElement("tbody", null, filteredPackages.map(this.renderRow)))));
        }
    }
    Licenses.Grid = Grid;
    /**
     * A package's full license text
     */
    class FullText extends index_js_.VDomRenderer {
        constructor(model) {
            super(model);
            this.addClass('jp-Licenses-Text');
            this.addClass('jp-RenderedHTMLCommon');
            this.addClass('jp-RenderedMarkdown');
        }
        /**
         * Render the license text, or a null state if no package is selected
         */
        render() {
            const { currentPackage, trans } = this.model;
            let head = '';
            let quote = trans.__('No Package selected');
            let code = '';
            if (currentPackage) {
                const { name, versionInfo, licenseId, extractedText } = currentPackage;
                head = `${name} v${versionInfo}`;
                quote = `${trans.__('License')}: ${licenseId || trans.__('No License ID found')}`;
                code = extractedText || trans.__('No License Text found');
            }
            return [
                react_index_js_.createElement("h1", { key: "h1" }, head),
                react_index_js_.createElement("blockquote", { key: "quote" },
                    react_index_js_.createElement("em", null, quote)),
                react_index_js_.createElement("code", { key: "code" }, code)
            ];
        }
    }
    Licenses.FullText = FullText;
})(Licenses || (Licenses = {}));
//# sourceMappingURL=licenses.js.map
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/apputils/lib/printing.js
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.

/**
 * Any object is "printable" if it implements the `IPrintable` interface.
 *
 * To do this it, it must have a method called `Printing.symbol` which returns either a function
 * to print the object or null if it cannot be printed.
 *
 * One way of printing is to use the `printWidget` function, which creates a hidden iframe
 * and copies the DOM nodes from your widget to that iframe and printing just that iframe.
 *
 * Another way to print is to use the `printURL` function, which takes a URL and prints that page.
 */
var Printing;
(function (Printing) {
    /**
     * Symbol to use for a method that returns a function to print an object.
     */
    Printing.symbol = Symbol('printable');
    /**
     * Returns whether an object implements a print method.
     */
    function isPrintable(a) {
        if (typeof a !== 'object' || !a) {
            return false;
        }
        return Printing.symbol in a;
    }
    Printing.isPrintable = isPrintable;
    /**
     * Returns the print function for an object, or null if it does not provide a handler.
     */
    function getPrintFunction(val) {
        if (isPrintable(val)) {
            return val[Printing.symbol]();
        }
        return null;
    }
    Printing.getPrintFunction = getPrintFunction;
    /**
     * Prints a widget by copying it's DOM node
     * to a hidden iframe and printing that iframe.
     */
    function printWidget(widget) {
        return printContent(widget.node);
    }
    Printing.printWidget = printWidget;
    /**
     * Prints a URL by loading it into an iframe.
     *
     * @param url URL to load into an iframe.
     */
    async function printURL(url) {
        const settings = services_lib_index_js_.ServerConnection.makeSettings();
        const text = await (await services_lib_index_js_.ServerConnection.makeRequest(url, {}, settings)).text();
        return printContent(text);
    }
    Printing.printURL = printURL;
    /**
     * Prints a URL or an element in an iframe and then removes the iframe after printing.
     */
    async function printContent(textOrEl) {
        const isText = typeof textOrEl === 'string';
        const iframe = createIFrame();
        const parent = window.document.body;
        parent.appendChild(iframe);
        if (isText) {
            iframe.srcdoc = textOrEl;
            await resolveWhenLoaded(iframe);
        }
        else {
            iframe.src = 'about:blank';
            await resolveWhenLoaded(iframe);
            setIFrameNode(iframe, textOrEl);
        }
        const printed = resolveAfterEvent();
        launchPrint(iframe.contentWindow);
        // Once the print dialog has been dismissed, we regain event handling,
        // and it should be safe to discard the hidden iframe.
        await printed;
        parent.removeChild(iframe);
    }
    /**
     * Creates a new hidden iframe and appends it to the document
     *
     * Modified from
     * https://github.com/joseluisq/printd/blob/eb7948d602583c055ab6dee3ee294b6a421da4b6/src/index.ts#L24
     */
    function createIFrame() {
        const el = window.document.createElement('iframe');
        // We need both allow-modals and allow-same-origin to be able to
        // call print in the iframe.
        // We intentionally do not allow scripts:
        // https://github.com/jupyterlab/jupyterlab/pull/5850#pullrequestreview-230899790
        el.setAttribute('sandbox', 'allow-modals allow-same-origin');
        const css = 'visibility:hidden;width:0;height:0;position:absolute;z-index:-9999;bottom:0;';
        el.setAttribute('style', css);
        el.setAttribute('width', '0');
        el.setAttribute('height', '0');
        return el;
    }
    /**
     * Copies a node from the base document to the iframe.
     */
    function setIFrameNode(iframe, node) {
        iframe.contentDocument.body.appendChild(node.cloneNode(true));
        iframe.contentDocument.close();
    }
    /**
     * Promise that resolves when all resources are loaded in the window.
     */
    function resolveWhenLoaded(iframe) {
        return new Promise(resolve => {
            iframe.onload = () => resolve();
        });
    }
    /**
     * A promise that resolves after the next mousedown, mousemove, or
     * keydown event. We use this as a proxy for determining when the
     * main window has regained control after the print dialog is removed.
     *
     * We can't use the usual window.onafterprint handler because we
     * disallow Javascript execution in the print iframe.
     */
    function resolveAfterEvent() {
        return new Promise(resolve => {
            const onEvent = () => {
                document.removeEventListener('mousemove', onEvent, true);
                document.removeEventListener('mousedown', onEvent, true);
                document.removeEventListener('keydown', onEvent, true);
                resolve();
            };
            document.addEventListener('mousemove', onEvent, true);
            document.addEventListener('mousedown', onEvent, true);
            document.addEventListener('keydown', onEvent, true);
        });
    }
    /**
     * Prints a content window.
     */
    function launchPrint(contentWindow) {
        const result = contentWindow.document.execCommand('print', false);
        // execCommand won't work in firefox so we call the `print` method instead if it fails
        // https://github.com/joseluisq/printd/blob/eb7948d602583c055ab6dee3ee294b6a421da4b6/src/index.ts#L148
        if (!result) {
            contentWindow.print();
        }
    }
})(Printing || (Printing = {}));
//# sourceMappingURL=printing.js.map
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/apputils/lib/mainareawidget.js
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.






/**
 * A flag to indicate that event handlers are caught in the capture phase.
 */
const USE_CAPTURE = true;
/**
 * A widget meant to be contained in the JupyterLab main area.
 *
 * #### Notes
 * Mirrors all of the `title` attributes of the content.
 * This widget is `closable` by default.
 * This widget is automatically disposed when closed.
 * This widget ensures its own focus when activated.
 */
class MainAreaWidget extends index_es6_js_.Widget {
    /**
     * Construct a new main area widget.
     *
     * @param options - The options for initializing the widget.
     */
    constructor(options) {
        super(options);
        this._changeGuard = false;
        this._spinner = new index_js_.Spinner();
        this._isRevealed = false;
        this._evtMouseDown = () => {
            if (!this.node.contains(document.activeElement)) {
                this._focusContent();
            }
        };
        this.addClass('jp-MainAreaWidget');
        // Set contain=strict to avoid many forced layout rendering while adding cells.
        // Don't forget to remove the CSS class when your remove the spinner to allow
        // the content to be rendered.
        // @see https://github.com/jupyterlab/jupyterlab/issues/9381
        this.addClass('jp-MainAreaWidget-ContainStrict');
        this.id = DOMUtils.createDomID();
        const trans = (options.translator || lib_index_js_.nullTranslator).load('jupyterlab');
        const content = (this._content = options.content);
        content.node.setAttribute('role', 'region');
        content.node.setAttribute('aria-label', trans.__('main area content'));
        const toolbar = (this._toolbar =
            options.toolbar || new index_js_.ReactiveToolbar({ noFocusOnClick: true }));
        toolbar.node.setAttribute('role', 'toolbar');
        toolbar.node.setAttribute('aria-label', trans.__('main area toolbar'));
        const contentHeader = (this._contentHeader =
            options.contentHeader ||
                new index_es6_js_.BoxPanel({
                    direction: 'top-to-bottom',
                    spacing: 0
                }));
        const layout = (this.layout = new index_es6_js_.BoxLayout({ spacing: 0 }));
        layout.direction = 'top-to-bottom';
        index_es6_js_.BoxLayout.setStretch(toolbar, 0);
        index_es6_js_.BoxLayout.setStretch(contentHeader, 0);
        index_es6_js_.BoxLayout.setStretch(content, 1);
        layout.addWidget(toolbar);
        layout.addWidget(contentHeader);
        layout.addWidget(content);
        if (!content.id) {
            content.id = DOMUtils.createDomID();
        }
        content.node.tabIndex = -1;
        this._updateTitle();
        content.title.changed.connect(this._updateTitle, this);
        this.title.closable = true;
        this.title.changed.connect(this._updateContentTitle, this);
        if (options.reveal) {
            this.node.appendChild(this._spinner.node);
            this._revealed = options.reveal
                .then(() => {
                if (content.isDisposed) {
                    this.dispose();
                    return;
                }
                content.disposed.connect(() => this.dispose());
                const active = document.activeElement === this._spinner.node;
                this._disposeSpinner();
                this._isRevealed = true;
                if (active) {
                    this._focusContent();
                }
            })
                .catch(e => {
                // Show a revealed promise error.
                const error = new index_es6_js_.Widget();
                error.addClass('jp-MainAreaWidget-error');
                // Show the error to the user.
                const pre = document.createElement('pre');
                pre.textContent = String(e);
                error.node.appendChild(pre);
                index_es6_js_.BoxLayout.setStretch(error, 1);
                this._disposeSpinner();
                content.dispose();
                this._content = null;
                toolbar.dispose();
                this._toolbar = null;
                layout.addWidget(error);
                this._isRevealed = true;
                throw error;
            });
        }
        else {
            // Handle no reveal promise.
            this._spinner.dispose();
            this.removeClass('jp-MainAreaWidget-ContainStrict');
            content.disposed.connect(() => this.dispose());
            this._isRevealed = true;
            this._revealed = Promise.resolve(undefined);
        }
    }
    /**
     * Print method. Deferred to content.
     */
    [Printing.symbol]() {
        if (!this._content) {
            return null;
        }
        return Printing.getPrintFunction(this._content);
    }
    /**
     * The content hosted by the widget.
     */
    get content() {
        return this._content;
    }
    /**
     * The toolbar hosted by the widget.
     */
    get toolbar() {
        return this._toolbar;
    }
    /**
     * A panel for widgets that sit between the toolbar and the content.
     * Imagine a formatting toolbar, notification headers, etc.
     */
    get contentHeader() {
        return this._contentHeader;
    }
    /**
     * Whether the content widget or an error is revealed.
     */
    get isRevealed() {
        return this._isRevealed;
    }
    /**
     * A promise that resolves when the widget is revealed.
     */
    get revealed() {
        return this._revealed;
    }
    /**
     * Handle `'activate-request'` messages.
     */
    onActivateRequest(msg) {
        if (this._isRevealed) {
            this._focusContent();
        }
        else {
            this._spinner.node.focus();
        }
    }
    /**
     * Handle `after-attach` messages for the widget.
     */
    onAfterAttach(msg) {
        super.onAfterAttach(msg);
        // Focus content in capture phase to ensure relevant commands operate on the
        // current main area widget.
        // Add the event listener directly instead of using `handleEvent` in order
        // to save sub-classes from needing to reason about calling it as well.
        this.node.addEventListener('mousedown', this._evtMouseDown, USE_CAPTURE);
    }
    /**
     * Handle `before-detach` messages for the widget.
     */
    onBeforeDetach(msg) {
        this.node.removeEventListener('mousedown', this._evtMouseDown, USE_CAPTURE);
        super.onBeforeDetach(msg);
    }
    /**
     * Handle `'close-request'` messages.
     */
    onCloseRequest(msg) {
        this.dispose();
    }
    /**
     * Handle `'update-request'` messages by forwarding them to the content.
     */
    onUpdateRequest(msg) {
        if (this._content) {
            messaging_dist_index_es6_js_.MessageLoop.sendMessage(this._content, msg);
        }
    }
    _disposeSpinner() {
        this.node.removeChild(this._spinner.node);
        this._spinner.dispose();
        this.removeClass('jp-MainAreaWidget-ContainStrict');
    }
    /**
     * Update the title based on the attributes of the child widget.
     */
    _updateTitle() {
        if (this._changeGuard || !this.content) {
            return;
        }
        this._changeGuard = true;
        const content = this.content;
        this.title.label = content.title.label;
        this.title.mnemonic = content.title.mnemonic;
        this.title.icon = content.title.icon;
        this.title.iconClass = content.title.iconClass;
        this.title.iconLabel = content.title.iconLabel;
        this.title.caption = content.title.caption;
        this.title.className = content.title.className;
        this.title.dataset = content.title.dataset;
        this._changeGuard = false;
    }
    /**
     * Update the content title based on attributes of the main widget.
     */
    _updateContentTitle() {
        if (this._changeGuard || !this.content) {
            return;
        }
        this._changeGuard = true;
        const content = this.content;
        content.title.label = this.title.label;
        content.title.mnemonic = this.title.mnemonic;
        content.title.icon = this.title.icon;
        content.title.iconClass = this.title.iconClass;
        content.title.iconLabel = this.title.iconLabel;
        content.title.caption = this.title.caption;
        content.title.className = this.title.className;
        content.title.dataset = this.title.dataset;
        this._changeGuard = false;
    }
    /**
     * Give focus to the content.
     */
    _focusContent() {
        if (!this.content) {
            return;
        }
        // Focus the content node if we aren't already focused on it or a
        // descendent.
        if (!this.content.node.contains(document.activeElement)) {
            this.content.node.focus();
        }
        // Activate the content asynchronously (which may change the focus).
        this.content.activate();
    }
}
//# sourceMappingURL=mainareawidget.js.map
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/apputils/lib/menufactory.js
/*
 * Copyright (c) Jupyter Development Team.
 * Distributed under the terms of the Modified BSD License.
 */



/**
 * Helper functions to build a menu from the settings
 */
var MenuFactory;
(function (MenuFactory) {
    /**
     * Create menus from their description
     *
     * @param data Menubar description
     * @param menuFactory Factory for empty menu
     */
    function createMenus(data, menuFactory) {
        return data
            .filter(item => !item.disabled)
            .sort((a, b) => { var _a, _b; return ((_a = a.rank) !== null && _a !== void 0 ? _a : Infinity) - ((_b = b.rank) !== null && _b !== void 0 ? _b : Infinity); })
            .map(menuItem => {
            return dataToMenu(menuItem, menuFactory);
        });
    }
    MenuFactory.createMenus = createMenus;
    /**
     * Convert a menu description in a JupyterLabMenu object
     *
     * @param item Menu description
     * @param menuFactory Empty menu factory
     * @returns The menu widget
     */
    function dataToMenu(item, menuFactory) {
        var _a, _b;
        const menu = menuFactory(item);
        menu.id = item.id;
        // Set the label in case the menu factory did not.
        if (!menu.title.label) {
            menu.title.label = (_a = item.label) !== null && _a !== void 0 ? _a : coreutils_lib_index_js_.Text.titleCase(menu.id.trim());
        }
        if (item.icon) {
            menu.title.icon = index_js_.LabIcon.resolve({ icon: item.icon });
        }
        if (item.mnemonic !== undefined) {
            menu.title.mnemonic = item.mnemonic;
        }
        (_b = item.items) === null || _b === void 0 ? void 0 : _b.filter(item => !item.disabled).sort((a, b) => { var _a, _b; return ((_a = a.rank) !== null && _a !== void 0 ? _a : Infinity) - ((_b = b.rank) !== null && _b !== void 0 ? _b : Infinity); }).map(item => {
            addItem(item, menu, menuFactory);
        });
        return menu;
    }
    /**
     * Convert an item description in a context menu item object
     *
     * @param item Context menu item
     * @param menu Context menu to populate
     * @param menuFactory Empty menu factory
     */
    function addContextItem(item, menu, menuFactory) {
        const { submenu, ...newItem } = item;
        // Commands may not have been registered yet; so we don't force it to exist
        menu.addItem({
            ...newItem,
            submenu: submenu ? dataToMenu(submenu, menuFactory) : null
        });
    }
    MenuFactory.addContextItem = addContextItem;
    /**
     * Convert an item description in a menu item object
     *
     * @param item Menu item
     * @param menu Menu to populate
     * @param menuFactory Empty menu factory
     */
    function addItem(item, menu, menuFactory) {
        const { submenu, ...newItem } = item;
        // Commands may not have been registered yet; so we don't force it to exist
        menu.addItem({
            ...newItem,
            submenu: submenu ? dataToMenu(submenu, menuFactory) : null
        });
    }
    /**
     * Update an existing list of menu and returns
     * the new elements.
     *
     * #### Note
     * New elements are added to the current menu list.
     *
     * @param menus Current menus
     * @param data New description to take into account
     * @param menuFactory Empty menu factory
     * @returns Newly created menus
     */
    function updateMenus(menus, data, menuFactory) {
        const newMenus = [];
        data.forEach(item => {
            const menu = menus.find(menu => menu.id === item.id);
            if (menu) {
                mergeMenus(item, menu, menuFactory);
            }
            else {
                if (!item.disabled) {
                    newMenus.push(dataToMenu(item, menuFactory));
                }
            }
        });
        menus.push(...newMenus);
        return newMenus;
    }
    MenuFactory.updateMenus = updateMenus;
    function mergeMenus(item, menu, menuFactory) {
        var _a;
        if (item.disabled) {
            menu.dispose();
        }
        else {
            (_a = item.items) === null || _a === void 0 ? void 0 : _a.forEach(entry => {
                var _a, _b;
                const existingItem = menu === null || menu === void 0 ? void 0 : menu.items.find((i, idx) => {
                    var _a, _b, _c;
                    return i.type === entry.type &&
                        i.command === ((_a = entry.command) !== null && _a !== void 0 ? _a : '') &&
                        ((_b = i.submenu) === null || _b === void 0 ? void 0 : _b.id) === ((_c = entry.submenu) === null || _c === void 0 ? void 0 : _c.id);
                });
                if (existingItem && entry.type !== 'separator') {
                    if (entry.disabled) {
                        menu.removeItem(existingItem);
                    }
                    else {
                        switch ((_a = entry.type) !== null && _a !== void 0 ? _a : 'command') {
                            case 'command':
                                if (entry.command) {
                                    if (!dist_index_js_.JSONExt.deepEqual(existingItem.args, (_b = entry.args) !== null && _b !== void 0 ? _b : {})) {
                                        addItem(entry, menu, menuFactory);
                                    }
                                }
                                break;
                            case 'submenu':
                                if (entry.submenu) {
                                    mergeMenus(entry.submenu, existingItem.submenu, menuFactory);
                                }
                        }
                    }
                }
                else {
                    addItem(entry, menu, menuFactory);
                }
            });
        }
    }
})(MenuFactory || (MenuFactory = {}));
//# sourceMappingURL=menufactory.js.map
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/apputils/lib/notification.js
/*
 * Copyright (c) Jupyter Development Team.
 * Distributed under the terms of the Modified BSD License.
 */


/**
 * Notification manager
 */
class NotificationManager {
    constructor() {
        this._isDisposed = false;
        this._queue = [];
        this._changed = new signaling_dist_index_es6_js_.Signal(this);
    }
    /**
     * Signal emitted whenever a notification changes.
     */
    get changed() {
        return this._changed;
    }
    /**
     * Total number of notifications.
     */
    get count() {
        return this._queue.length;
    }
    /**
     * Whether the manager is disposed or not.
     */
    get isDisposed() {
        return this._isDisposed;
    }
    /**
     * The list of notifications.
     */
    get notifications() {
        return this._queue.slice();
    }
    /**
     * Dismiss one notification (specified by its id) or all if no id provided.
     *
     * @param id Notification id
     */
    dismiss(id) {
        if (typeof id === 'undefined') {
            const q = this._queue.slice();
            this._queue.length = 0;
            for (const notification of q) {
                this._changed.emit({
                    type: 'removed',
                    notification
                });
            }
        }
        else {
            const notificationIndex = this._queue.findIndex(n => n.id === id);
            if (notificationIndex > -1) {
                const notification = this._queue.splice(notificationIndex, 1)[0];
                this._changed.emit({
                    type: 'removed',
                    notification
                });
            }
        }
    }
    /**
     * Dispose the manager.
     */
    dispose() {
        if (this._isDisposed) {
            return;
        }
        this._isDisposed = true;
        signaling_dist_index_es6_js_.Signal.clearData(this);
    }
    /**
     * Test whether a notification exists or not.
     *
     * @param id Notification id
     * @returns Notification status
     */
    has(id) {
        return this._queue.findIndex(n => n.id === id) > -1;
    }
    /**
     * Add a new notification.
     *
     * This will trigger the `changed` signal with an `added` event.
     *
     * @param message Notification message
     * @param type Notification type
     * @param options Notification option
     * @returns Notification unique id
     */
    notify(message, type, options) {
        const now = Date.now();
        const { progress, ...othersOptions } = options;
        const notification = Object.freeze({
            id: dist_index_js_.UUID.uuid4(),
            createdAt: now,
            modifiedAt: now,
            message,
            type,
            options: {
                // By default notification will be silent
                autoClose: 0,
                progress: typeof progress === 'number'
                    ? Math.min(Math.max(0, progress), 1)
                    : progress,
                ...othersOptions
            }
        });
        this._queue.unshift(notification);
        this._changed.emit({
            type: 'added',
            notification
        });
        return notification.id;
    }
    /**
     * Update an existing notification.
     *
     * If the notification does not exists this won't do anything.
     *
     * Once updated the notification will be moved at the begin
     * of the notification stack.
     *
     * @param args Update options
     * @returns Whether the update was successful or not.
     */
    update(args) {
        const { id, message, actions, autoClose, data, progress, type } = args;
        const newProgress = typeof progress === 'number'
            ? Math.min(Math.max(0, progress), 1)
            : progress;
        const notificationIndex = this._queue.findIndex(n => n.id === id);
        if (notificationIndex > -1) {
            const oldNotification = this._queue[notificationIndex];
            // We need to create a new object as notification are frozen; i.e. cannot be edited
            const notification = Object.freeze({
                ...oldNotification,
                message: message !== null && message !== void 0 ? message : oldNotification.message,
                type: type !== null && type !== void 0 ? type : oldNotification.type,
                options: {
                    actions: actions !== null && actions !== void 0 ? actions : oldNotification.options.actions,
                    autoClose: autoClose !== null && autoClose !== void 0 ? autoClose : oldNotification.options.autoClose,
                    data: data !== null && data !== void 0 ? data : oldNotification.options.data,
                    progress: newProgress !== null && newProgress !== void 0 ? newProgress : oldNotification.options.progress
                },
                modifiedAt: Date.now()
            });
            this._queue.splice(notificationIndex, 1);
            this._queue.unshift(notification);
            this._changed.emit({
                type: 'updated',
                notification
            });
            return true;
        }
        return false;
    }
}
/**
 * Notification namespace
 */
var Notification;
(function (Notification) {
    /**
     * The global notification manager.
     */
    Notification.manager = new NotificationManager();
    /**
     * Dismiss one notification (specified by its id) or all if no id provided
     *
     * @param id notification id
     */
    function dismiss(id) {
        Notification.manager.dismiss(id);
    }
    Notification.dismiss = dismiss;
    /**
     * Helper function to emit a notification.
     *
     * #### Notes
     * The message will be truncated if longer than 140 characters.
     *
     * @param message Notification message
     * @param type Notification type
     * @param options Options for the error notification
     * @returns Notification unique id
     */
    function emit(message, type = 'default', options = {}) {
        return Notification.manager.notify(message, type, options);
    }
    Notification.emit = emit;
    /**
     * Helper function to emit an error notification.
     *
     * #### Notes
     * The message will be truncated if longer than 140 characters.
     *
     * @param message Notification message
     * @param options Options for the error notification
     * @returns Notification unique id
     */
    function error(message, options = {}) {
        return Notification.manager.notify(message, 'error', options);
    }
    Notification.error = error;
    /**
     * Helper function to emit an info notification.
     *
     * #### Notes
     * The message will be truncated if longer than 140 characters.
     *
     * @param message Notification message
     * @param options Options for the info notification
     * @returns Notification unique id
     */
    function info(message, options = {}) {
        return Notification.manager.notify(message, 'info', options);
    }
    Notification.info = info;
    /**
     * Helper function to show an in-progress notification.
     *
     * #### Notes
     * The message will be truncated if longer than 140 characters.
     *
     * @param promise Promise to wait for
     * @param options Options for the in-progress notification
     * @returns Notification unique id
     */
    function promise(promise, options) {
        var _a;
        const { pending, error, success } = options;
        const id = Notification.manager.notify(pending.message, 'in-progress', (_a = pending.options) !== null && _a !== void 0 ? _a : {});
        promise
            .then(result => {
            var _a, _b, _c;
            Notification.manager.update({
                id,
                message: success.message(result, (_a = success.options) === null || _a === void 0 ? void 0 : _a.data),
                type: 'success',
                ...success.options,
                data: (_c = (_b = success.options) === null || _b === void 0 ? void 0 : _b.data) !== null && _c !== void 0 ? _c : result
            });
        })
            .catch(reason => {
            var _a, _b, _c;
            Notification.manager.update({
                id,
                message: error.message(reason, (_a = error.options) === null || _a === void 0 ? void 0 : _a.data),
                type: 'error',
                ...error.options,
                data: (_c = (_b = error.options) === null || _b === void 0 ? void 0 : _b.data) !== null && _c !== void 0 ? _c : reason
            });
        });
        return id;
    }
    Notification.promise = promise;
    /**
     * Helper function to emit a success notification.
     *
     * #### Notes
     * The message will be truncated if longer than 140 characters.
     *
     * @param message Notification message
     * @param options Options for the success notification
     * @returns Notification unique id
     */
    function success(message, options = {}) {
        return Notification.manager.notify(message, 'success', options);
    }
    Notification.success = success;
    /**
     * Helper function to update a notification.
     *
     * If the notification does not exists, nothing will happen.
     *
     * Once updated the notification will be moved at the begin
     * of the notification stack.
     *
     * #### Notes
     * The message will be truncated if longer than 140 characters.
     *
     * @param args Update options
     * @returns Whether the update was successful or not.
     */
    function update(args) {
        return Notification.manager.update(args);
    }
    Notification.update = update;
    /**
     * Helper function to emit a warning notification.
     *
     * #### Notes
     * The message will be truncated if longer than 140 characters.
     *
     * @param message Notification message
     * @param options Options for the warning notification
     * @returns Notification unique id
     */
    function warning(message, options = {}) {
        return Notification.manager.notify(message, 'warning', options);
    }
    Notification.warning = warning;
})(Notification || (Notification = {}));
//# sourceMappingURL=notification.js.map
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/apputils/lib/runningSessions.js
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.




/**
 * Half spacing between subitems in a status item, in pixels.
 */
const HALF_SPACING = 4;
/**
 * A pure functional component for rendering kernel and terminal sessions.
 *
 * @param props the props for the component.
 *
 * @returns a tsx component for the running sessions.
 */
function RunningSessionsComponent(props) {
    var _a, _b;
    const showKernels = (_a = props.showKernels) !== null && _a !== void 0 ? _a : true;
    const showTerminals = (_b = props.showTerminals) !== null && _b !== void 0 ? _b : props.terminals > 0;
    return (react_index_js_default().createElement(statusbar_lib_index_js_.GroupItem, { role: "button", tabIndex: 0, spacing: HALF_SPACING, onClick: props.handleClick, onKeyDown: props.handleKeyDown, style: { cursor: 'pointer' } },
        showTerminals ? (react_index_js_default().createElement(statusbar_lib_index_js_.GroupItem, { spacing: HALF_SPACING },
            react_index_js_default().createElement(statusbar_lib_index_js_.TextItem, { source: props.terminals }),
            react_index_js_default().createElement(index_js_.terminalIcon.react, { verticalAlign: "middle", stylesheet: "statusBar" }))) : null,
        showKernels ? (react_index_js_default().createElement(statusbar_lib_index_js_.GroupItem, { spacing: HALF_SPACING },
            react_index_js_default().createElement(statusbar_lib_index_js_.TextItem, { source: props.sessions }),
            react_index_js_default().createElement(index_js_.kernelIcon.react, { verticalAlign: "middle", stylesheet: "statusBar" }))) : null));
}
/**
 * A VDomRenderer for a RunningSessions status item.
 */
class RunningSessions extends index_js_.VDomRenderer {
    /**
     * Create a new RunningSessions widget.
     */
    constructor(opts) {
        super(new RunningSessions.Model());
        this._serviceManager = opts.serviceManager;
        this._handleClick = opts.onClick;
        this._handleKeyDown = opts.onKeyDown;
        this.translator = opts.translator || lib_index_js_.nullTranslator;
        this._showKernels = opts.showKernels;
        this._showTerminals = opts.showTerminals;
        this._trans = this.translator.load('jupyterlab');
        this._serviceManager.sessions.runningChanged.connect(this._onSessionsRunningChanged, this);
        this._serviceManager.terminals.runningChanged.connect(this._onTerminalsRunningChanged, this);
        this.addClass('jp-mod-highlighted');
    }
    /**
     * Render the running sessions widget.
     */
    render() {
        if (!this.model) {
            return null;
        }
        // TODO-TRANS: Should probably be handled differently.
        // This is more localizable friendly: "Terminals: %1 | Kernels: %2"
        // Generate a localized caption for the tooltip
        const caption = this._trans.__('%1 Terminals, %2 Kernel sessions', this.model.terminals, this.model.sessions);
        // Explicitly synchronize the title attribute with the Lumino widget's DOM
        // This ensures the tooltip displays correctly when hovering over the widget
        this.node.title = caption;
        return (react_index_js_default().createElement(RunningSessionsComponent, { sessions: this.model.sessions, terminals: this.model.terminals, handleClick: this._handleClick, handleKeyDown: this._handleKeyDown, showKernels: this._showKernels, showTerminals: this._showTerminals }));
    }
    /**
     * Dispose of the status item.
     */
    dispose() {
        super.dispose();
        this._serviceManager.sessions.runningChanged.disconnect(this._onSessionsRunningChanged, this);
        this._serviceManager.terminals.runningChanged.disconnect(this._onTerminalsRunningChanged, this);
    }
    /**
     * Set the number of kernel sessions when the list changes.
     */
    _onSessionsRunningChanged(manager, sessions) {
        this.model.sessions = sessions.length;
    }
    /**
     * Set the number of terminal sessions when the list changes.
     */
    _onTerminalsRunningChanged(manager, terminals) {
        this.model.terminals = terminals.length;
    }
}
/**
 * A namespace for RunningSessions statics.
 */
(function (RunningSessions) {
    /**
     * A VDomModel for the RunningSessions status item.
     */
    class Model extends index_js_.VDomModel {
        constructor() {
            super(...arguments);
            this._terminals = 0;
            this._sessions = 0;
        }
        /**
         * The number of active kernel sessions.
         */
        get sessions() {
            return this._sessions;
        }
        set sessions(sessions) {
            const oldSessions = this._sessions;
            this._sessions = sessions;
            if (oldSessions !== this._sessions) {
                this.stateChanged.emit(void 0);
            }
        }
        /**
         * The number of active terminal sessions.
         */
        get terminals() {
            return this._terminals;
        }
        set terminals(terminals) {
            const oldTerminals = this._terminals;
            this._terminals = terminals;
            if (oldTerminals !== this._terminals) {
                this.stateChanged.emit(void 0);
            }
        }
    }
    RunningSessions.Model = Model;
})(RunningSessions || (RunningSessions = {}));
//# sourceMappingURL=runningSessions.js.map
// EXTERNAL MODULE: ../node_modules/sanitize-html/index.js
var sanitize_html = __webpack_require__(64926);
var sanitize_html_default = /*#__PURE__*/__webpack_require__.n(sanitize_html);
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/apputils/lib/sanitizer.js
/* eslint-disable camelcase */
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.

/**
 * Helper class that contains regular expressions for inline CSS style validation.
 *
 * Which properties (and values) to allow is largely based on the Google Caja project:
 *   https://github.com/google/caja
 *
 * The regular expressions are largly based on the syntax definition found at
 * https://developer.mozilla.org/en-US/docs/Web/CSS.
 */
class CssProp {
    static reg(r) {
        return new RegExp('^' + r + '$', 'i');
    }
}
/*
 * Numeric base expressions used to help build more complex regular expressions
 */
CssProp.N = {
    integer: `[+-]?[0-9]+`,
    integer_pos: `[+]?[0-9]+`,
    integer_zero_ff: `([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])`,
    number: `[+-]?([0-9]*[.])?[0-9]+(e-?[0-9]*)?`,
    number_pos: `[+]?([0-9]*[.])?[0-9]+(e-?[0-9]*)?`,
    number_zero_hundred: `[+]?(([0-9]|[1-9][0-9])([.][0-9]+)?|100)`,
    number_zero_one: `[+]?(1([.][0]+)?|0?([.][0-9]+)?)`
};
/*
 * Base expressions of common CSS syntax elements
 */
CssProp.B = {
    angle: `(${CssProp.N.number}(deg|rad|grad|turn)|0)`,
    frequency: `${CssProp.N.number}(Hz|kHz)`,
    ident: String.raw `-?([_a-z]|[\xA0-\xFF]|\\[0-9a-f]{1,6}(\r\n|[ \t\r\n\f])?|\\[^\r\n\f0-9a-f])([_a-z0-9-]|[\xA0-\xFF]|\\[0-9a-f]{1,6}(\r\n|[ \t\r\n\f])?|\\[^\r\n\f0-9a-f])*`,
    len_or_perc: `(0|${CssProp.N.number}(px|em|rem|ex|in|cm|mm|pt|pc|%))`,
    length: `(${CssProp.N.number}(px|em|rem|ex|in|cm|mm|pt|pc)|0)`,
    length_pos: `(${CssProp.N.number_pos}(px|em|rem|ex|in|cm|mm|pt|pc)|0)`,
    percentage: `${CssProp.N.number}%`,
    percentage_pos: `${CssProp.N.number_pos}%`,
    percentage_zero_hundred: `${CssProp.N.number_zero_hundred}%`,
    string: String.raw `(\"([^\n\r\f\\"]|\\\n|\r\n|\r|\f|\\[0-9a-f]{1,6}(\r\n|[ \t\r\n\f])?|\\[^\r\n\f0-9a-f])*\")|(\'([^\n\r\f\\']|\\\n|\r\n|\r|\f|\\[0-9a-f]{1,6}(\r\n|[ \t\r\n\f])?|\\[^\r\n\f0-9a-f])*\')`,
    time: `${CssProp.N.number}(s|ms)`,
    url: `url\\(.*?\\)`,
    z_index: `[+-]?[0-9]{1,7}`
};
/*
 * Atomic (i.e. not dependent on other regular expressions) sub RegEx segments
 */
CssProp.A = {
    absolute_size: `xx-small|x-small|small|medium|large|x-large|xx-large`,
    attachment: `scroll|fixed|local`,
    bg_origin: `border-box|padding-box|content-box`,
    border_style: `none|hidden|dotted|dashed|solid|double|groove|ridge|inset|outset`,
    box: `border-box|padding-box|content-box`,
    display_inside: `auto|block|table|flex|grid`,
    display_outside: `block-level|inline-level|none|table-row-group|table-header-group|table-footer-group|table-row|table-cell|table-column-group|table-column|table-caption`,
    ending_shape: `circle|ellipse`,
    generic_family: `serif|sans-serif|cursive|fantasy|monospace`,
    generic_voice: `male|female|child`,
    relative_size: `smaller|larger`,
    repeat_style: `repeat-x|repeat-y|((?:repeat|space|round|no-repeat)(?:\\s*(?:repeat|space|round|no-repeat))?)`,
    side_or_corner: `(left|right)?\\s*(top|bottom)?`,
    single_animation_direction: `normal|reverse|alternate|alternate-reverse`,
    single_animation_fill_mode: `none|forwards|backwards|both`,
    single_animation_play_state: `running|paused`
};
/*
 * Color definition sub expressions
 */
CssProp._COLOR = {
    hex: `\\#(0x)?[0-9a-f]+`,
    name: `aliceblue|antiquewhite|aqua|aquamarine|azure|beige|bisque|black|blanchedalmond|blue|blueviolet|brown|burlywood|cadetblue|chartreuse|chocolate|coral|cornflowerblue|cornsilk|crimson|cyan|darkblue|darkcyan|darkgoldenrod|darkgray|darkgreen|darkkhaki|darkmagenta|darkolivegreen|darkorange|darkorchid|darkred|darksalmon|darkseagreen|darkslateblue|darkslategray|darkturquoise|darkviolet|deeppink|deepskyblue|dimgray|dodgerblue|firebrick|floralwhite|forestgreen|fuchsia|gainsboro|ghostwhite|gold|goldenrod|gray|green|greenyellow|honeydew|hotpink|indianred|indigo|ivory|khaki|lavender|lavenderblush|lawngreen|lemonchiffon|lightblue|lightcoral|lightcyan|lightgoldenrodyellow|lightgreen|lightgrey|lightpink|lightsalmon|lightseagreen|lightskyblue|lightslategray|lightsteelblue|lightyellow|lime|limegreen|linen|magenta|maroon|mediumaquamarine|mediumblue|mediumorchid|mediumpurple|mediumseagreen|mediumslateblue|mediumspringgreen|mediumturquoise|mediumvioletred|midnightblue|mintcream|mistyrose|moccasin|navajowhite|navy|oldlace|olive|olivedrab|orange|orangered|orchid|palegoldenrod|palegreen|paleturquoise|palevioletred|papayawhip|peachpuff|peru|pink|plum|powderblue|purple|red|rosybrown|royalblue|saddlebrown|salmon|sandybrown|seagreen|seashell|sienna|silver|skyblue|slateblue|slategray|snow|springgreen|steelblue|tan|teal|thistle|tomato|turquoise|transparent|violet|wheat|white|whitesmoke|yellow|yellowgreen`,
    rgb: String.raw `rgb\(\s*(\d{1,3})\s*,\s*(\d{1,3})\s*,\s*(\d{1,3})\s*\)`,
    rgba: String.raw `rgba\(\s*(\d{1,3})\s*,\s*(\d{1,3})\s*,\s*(\d{1,3})\s*,\s*(${CssProp.N.integer_zero_ff}|${CssProp.N.number_zero_one}|${CssProp.B.percentage_zero_hundred})\s*\)`
};
/*
 * Compound (i.e. dependent on other (sub) regular expressions) sub RegEx segments
 */
CssProp._C = {
    alpha: `${CssProp.N.integer_zero_ff}|${CssProp.N.number_zero_one}|${CssProp.B.percentage_zero_hundred}`,
    alphavalue: CssProp.N.number_zero_one,
    bg_position: `((${CssProp.B.len_or_perc}|left|center|right|top|bottom)\\s*){1,4}`,
    bg_size: `(${CssProp.B.length_pos}|${CssProp.B.percentage}|auto){1,2}|cover|contain`,
    border_width: `thin|medium|thick|${CssProp.B.length}`,
    bottom: `${CssProp.B.length}|auto`,
    color: `${CssProp._COLOR.hex}|${CssProp._COLOR.rgb}|${CssProp._COLOR.rgba}|${CssProp._COLOR.name}`,
    color_stop_length: `(${CssProp.B.len_or_perc}\\s*){1,2}`,
    linear_color_hint: `${CssProp.B.len_or_perc}`,
    family_name: `${CssProp.B.string}|(${CssProp.B.ident}\\s*)+`,
    image_decl: CssProp.B.url,
    left: `${CssProp.B.length}|auto`,
    loose_quotable_words: `(${CssProp.B.ident})+`,
    margin_width: `${CssProp.B.len_or_perc}|auto`,
    padding_width: `${CssProp.B.length_pos}|${CssProp.B.percentage_pos}`,
    page_url: CssProp.B.url,
    position: `((${CssProp.B.len_or_perc}|left|center|right|top|bottom)\\s*){1,4}`,
    right: `${CssProp.B.length}|auto`,
    shadow: '',
    size: `closest-side|farthest-side|closest-corner|farthest-corner|${CssProp.B.length}|(${CssProp.B.len_or_perc})\\s+(${CssProp.B.len_or_perc})`,
    top: `${CssProp.B.length}|auto`
};
CssProp._C1 = {
    image_list: `image\\(\\s*(${CssProp.B.url})*\\s*(${CssProp.B.url}|${CssProp._C.color})\\s*\\)`,
    linear_color_stop: `(${CssProp._C.color})(\\s*${CssProp._C.color_stop_length})?`,
    shadow: `((${CssProp._C.color})\\s+((${CssProp.B.length})\\s*){2,4}(\s+inset)?)|((inset\\s+)?((${CssProp.B.length})\\s*){2,4}\\s*(${CssProp._C.color})?)`
};
CssProp._C2 = {
    color_stop_list: `((${CssProp._C1.linear_color_stop})(\\s*(${CssProp._C.linear_color_hint}))?\\s*,\\s*)+(${CssProp._C1.linear_color_stop})`,
    shape: `rect\\(\\s*(${CssProp._C.top})\\s*,\\s*(${CssProp._C.right})\\s*,\\s*(${CssProp._C.bottom})\\s*,\\s*(${CssProp._C.left})\\s*\\)`
};
CssProp._C3 = {
    linear_gradient: `linear-gradient\\((((${CssProp.B.angle})|to\\s+(${CssProp.A.side_or_corner}))\\s*,\\s*)?\\s*(${CssProp._C2.color_stop_list})\\s*\\)`,
    radial_gradient: `radial-gradient\\(((((${CssProp.A.ending_shape})|(${CssProp._C.size}))\\s*)*\\s*(at\\s+${CssProp._C.position})?\\s*,\\s*)?\\s*(${CssProp._C2.color_stop_list})\\s*\\)`
};
CssProp._C4 = {
    image: `${CssProp.B.url}|${CssProp._C3.linear_gradient}|${CssProp._C3.radial_gradient}|${CssProp._C1.image_list}`,
    bg_image: `(${CssProp.B.url}|${CssProp._C3.linear_gradient}|${CssProp._C3.radial_gradient}|${CssProp._C1.image_list})|none`
};
CssProp.C = {
    ...CssProp._C,
    ...CssProp._C1,
    ...CssProp._C2,
    ...CssProp._C3,
    ...CssProp._C4
};
/*
 * Property value regular expressions not dependent on other sub expressions
 */
CssProp.AP = {
    border_collapse: `collapse|separate`,
    box: `normal|none|contents`,
    box_sizing: `content-box|padding-box|border-box`,
    caption_side: `top|bottom`,
    clear: `none|left|right|both`,
    direction: `ltr|rtl`,
    empty_cells: `show|hide`,
    float: `left|right|none`,
    font_stretch: `normal|wider|narrower|ultra-condensed|extra-condensed|condensed|semi-condensed|semi-expanded|expanded|extra-expanded|ultra-expanded`,
    font_style: `normal|italic|oblique`,
    font_variant: `normal|small-caps`,
    font_weight: `normal|bold|bolder|lighter|100|200|300|400|500|600|700|800|900`,
    list_style_position: `inside|outside`,
    list_style_type: `disc|circle|square|decimal|decimal-leading-zero|lower-roman|upper-roman|lower-greek|lower-latin|upper-latin|armenian|georgian|lower-alpha|upper-alpha|none`,
    overflow: `visible|hidden|scroll|auto`,
    overflow_wrap: `normal|break-word`,
    overflow_x: `visible|hidden|scroll|auto|no-display|no-content`,
    page_break_after: `auto|always|avoid|left|right`,
    page_break_before: `auto|always|avoid|left|right`,
    page_break_inside: `avoid|auto`,
    position: `static|relative|absolute`,
    resize: `none|both|horizontal|vertical`,
    speak: `normal|none|spell-out`,
    speak_header: `once|always`,
    speak_numeral: `digits|continuous`,
    speak_punctuation: `code|none`,
    table_layout: `auto|fixed`,
    text_align: `left|right|center|justify`,
    text_decoration: `none|((underline|overline|line-through|blink)\\s*)+`,
    text_transform: `capitalize|uppercase|lowercase|none`,
    text_wrap: `normal|unrestricted|none|suppress`,
    unicode_bidi: `normal|embed|bidi-override`,
    visibility: `visible|hidden|collapse`,
    white_space: `normal|pre|nowrap|pre-wrap|pre-line`,
    word_break: `normal|keep-all|break-all`
};
/*
 * Compound propertiy value regular expressions (i.e. dependent on other sub expressions)
 */
CssProp._CP = {
    background_attachment: `${CssProp.A.attachment}(,\\s*${CssProp.A.attachment})*`,
    background_color: CssProp.C.color,
    background_origin: `${CssProp.A.box}(,\\s*${CssProp.A.box})*`,
    background_repeat: `${CssProp.A.repeat_style}(,\\s*${CssProp.A.repeat_style})*`,
    border: `((${CssProp.C.border_width}|${CssProp.A.border_style}|${CssProp.C.color})\\s*){1,3}`,
    border_radius: `((${CssProp.B.len_or_perc})\\s*){1,4}(\\/\\s*((${CssProp.B.len_or_perc})\\s*){1,4})?`,
    border_spacing: `${CssProp.B.length}\\s*(${CssProp.B.length})?`,
    border_top_color: CssProp.C.color,
    border_top_style: CssProp.A.border_style,
    border_width: `((${CssProp.C.border_width})\\s*){1,4}`,
    color: CssProp.C.color,
    cursor: `(${CssProp.B.url}(\\s*,\\s*)?)*(auto|crosshair|default|pointer|move|e-resize|ne-resize|nw-resize|n-resize|se-resize|sw-resize|s-resize|w-resize|text|wait|help|progress|all-scroll|col-resize|hand|no-drop|not-allowed|row-resize|vertical-text)`,
    display: `inline|block|list-item|run-in|inline-list-item|inline-block|table|inline-table|table-cell|table-caption|flex|inline-flex|grid|inline-grid|${CssProp.A.display_inside}|${CssProp.A.display_outside}|inherit|inline-box|inline-stack`,
    display_outside: CssProp.A.display_outside,
    elevation: `${CssProp.B.angle}|below|level|above|higher|lower`,
    font_family: `(${CssProp.C.family_name}|${CssProp.A.generic_family})(,\\s*(${CssProp.C.family_name}|${CssProp.A.generic_family}))*`,
    height: `${CssProp.B.length}|${CssProp.B.percentage}|auto`,
    letter_spacing: `normal|${CssProp.B.length}`,
    list_style_image: `${CssProp.C.image}|none`,
    margin_right: CssProp.C.margin_width,
    max_height: `${CssProp.B.length_pos}|${CssProp.B.percentage_pos}|none|auto`,
    min_height: `${CssProp.B.length_pos}|${CssProp.B.percentage_pos}|auto`,
    opacity: CssProp.C.alphavalue,
    outline_color: `${CssProp.C.color}|invert`,
    outline_width: CssProp.C.border_width,
    padding: `((${CssProp.C.padding_width})\\s*){1,4}`,
    padding_top: CssProp.C.padding_width,
    pitch_range: CssProp.N.number,
    right: `${CssProp.B.length}|${CssProp.B.percentage}|auto`,
    stress: CssProp.N.number,
    text_indent: `${CssProp.B.length}|${CssProp.B.percentage}`,
    text_shadow: `none|${CssProp.C.shadow}(,\\s*(${CssProp.C.shadow}))*`,
    volume: `${CssProp.N.number_pos}|${CssProp.B.percentage_pos}|silent|x-soft|soft|medium|loud|x-loud`,
    word_wrap: CssProp.AP.overflow_wrap,
    zoom: `normal|${CssProp.N.number_pos}|${CssProp.B.percentage_pos}`,
    backface_visibility: CssProp.AP.visibility,
    background_clip: `${CssProp.A.box}(,\\s*(${CssProp.A.box}))*`,
    background_position: `${CssProp.C.bg_position}(,\\s*(${CssProp.C.bg_position}))*`,
    border_bottom_color: CssProp.C.color,
    border_bottom_style: CssProp.A.border_style,
    border_color: `((${CssProp.C.color})\\s*){1,4}`,
    border_left_color: CssProp.C.color,
    border_right_color: CssProp.C.color,
    border_style: `((${CssProp.A.border_style})\\s*){1,4}`,
    border_top_left_radius: `(${CssProp.B.length}|${CssProp.B.percentage})(\\s*(${CssProp.B.length}|${CssProp.B.percentage}))?`,
    border_top_width: CssProp.C.border_width,
    box_shadow: `none|${CssProp.C.shadow}(,\\s*(${CssProp.C.shadow}))*`,
    clip: `${CssProp.C.shape}|auto`,
    display_inside: CssProp.A.display_inside,
    font_size: `${CssProp.A.absolute_size}|${CssProp.A.relative_size}|${CssProp.B.length_pos}|${CssProp.B.percentage_pos}`,
    line_height: `normal|${CssProp.N.number_pos}|${CssProp.B.length_pos}|${CssProp.B.percentage_pos}`,
    margin_left: CssProp.C.margin_width,
    max_width: `${CssProp.B.length_pos}|${CssProp.B.percentage_pos}|none|auto`,
    outline_style: CssProp.A.border_style,
    padding_bottom: CssProp.C.padding_width,
    padding_right: CssProp.C.padding_width,
    perspective: `none|${CssProp.B.length}`,
    richness: CssProp.N.number,
    text_overflow: `((clip|ellipsis|${CssProp.B.string})\\s*){1,2}`,
    top: `${CssProp.B.length}|${CssProp.B.percentage}|auto`,
    width: `${CssProp.B.length_pos}|${CssProp.B.percentage_pos}|auto`,
    z_index: `auto|${CssProp.B.z_index}`,
    // Simplified background
    background: `(((${CssProp.C.bg_position}\\s*(\\/\\s*${CssProp.C.bg_size})?)|(${CssProp.A.repeat_style})|(${CssProp.A.attachment})|(${CssProp.A.bg_origin})|(${CssProp.C.bg_image})|(${CssProp.C.color}))\\s*)+`,
    background_size: `${CssProp.C.bg_size}(,\\s*${CssProp.C.bg_size})*`,
    border_bottom_left_radius: `(${CssProp.B.length}|${CssProp.B.percentage})(\\s*(${CssProp.B.length}|${CssProp.B.percentage}))?`,
    border_bottom_width: CssProp.C.border_width,
    border_left_style: CssProp.A.border_style,
    border_right_style: CssProp.A.border_style,
    border_top: `((${CssProp.C.border_width}|${CssProp.A.border_style}|${CssProp.C.color})\\s*){1,3}`,
    bottom: `${CssProp.B.len_or_perc}|auto`,
    list_style: `((${CssProp.AP.list_style_type}|${CssProp.AP.list_style_position}|${CssProp.C.image}|none})\\s*){1,3}`,
    margin_top: CssProp.C.margin_width,
    outline: `((${CssProp.C.color}|invert|${CssProp.A.border_style}|${CssProp.C.border_width})\\s*){1,3}`,
    overflow_y: CssProp.AP.overflow_x,
    pitch: `${CssProp.B.frequency}|x-low|low|medium|high|x-high`,
    vertical_align: `baseline|sub|super|top|text-top|middle|bottom|text-bottom|${CssProp.B.len_or_perc}`,
    word_spacing: `normal|${CssProp.B.length}`,
    background_image: `${CssProp.C.bg_image}(,\\s*${CssProp.C.bg_image})*`,
    border_bottom_right_radius: `(${CssProp.B.length}|${CssProp.B.percentage})(\\s*(${CssProp.B.length}|${CssProp.B.percentage}))?`,
    border_left_width: CssProp.C.border_width,
    border_right_width: CssProp.C.border_width,
    left: `${CssProp.B.len_or_perc}|auto`,
    margin_bottom: CssProp.C.margin_width,
    pause_after: `${CssProp.B.time}|${CssProp.B.percentage}`,
    speech_rate: `${CssProp.N.number}|x-slow|slow|medium|fast|x-fast|faster|slower`,
    transition_duration: `${CssProp.B.time}(,\\s*${CssProp.B.time})*`,
    border_bottom: `((${CssProp.C.border_width}|${CssProp.A.border_style}|${CssProp.C.color})\\s*){1,3}`,
    border_right: `((${CssProp.C.border_width}|${CssProp.A.border_style}|${CssProp.C.color})\\s*){1,3}`,
    margin: `((${CssProp.C.margin_width})\\s*){1,4}`,
    padding_left: CssProp.C.padding_width,
    border_left: `((${CssProp.C.border_width}|${CssProp.A.border_style}|${CssProp.C.color})\\s*){1,3}`,
    quotes: `(${CssProp.B.string}\\s*${CssProp.B.string})+|none`,
    border_top_right_radius: `(${CssProp.B.length}|${CssProp.B.percentage})(\\s*(${CssProp.B.length}|${CssProp.B.percentage}))?`,
    min_width: `${CssProp.B.length_pos}|${CssProp.B.percentage_pos}|auto`
};
CssProp._CP1 = {
    font: `(((((${CssProp.AP.font_style}|${CssProp.AP.font_variant}|${CssProp.AP.font_weight})\\s*){1,3})?\\s*(${CssProp._CP.font_size})\\s*(\\/\\s*(${CssProp._CP.line_height}))?\\s+(${CssProp._CP.font_family}))|caption|icon|menu|message-box|small-caption|status-bar)`
};
CssProp.CP = { ...CssProp._CP, ...CssProp._CP1 };
// CSS Property value validation regular expressions for use with sanitize-html
CssProp.BORDER_COLLAPSE = CssProp.reg(CssProp.AP.border_collapse);
CssProp.BOX = CssProp.reg(CssProp.AP.box);
CssProp.BOX_SIZING = CssProp.reg(CssProp.AP.box_sizing);
CssProp.CAPTION_SIDE = CssProp.reg(CssProp.AP.caption_side);
CssProp.CLEAR = CssProp.reg(CssProp.AP.clear);
CssProp.DIRECTION = CssProp.reg(CssProp.AP.direction);
CssProp.EMPTY_CELLS = CssProp.reg(CssProp.AP.empty_cells);
CssProp.FLOAT = CssProp.reg(CssProp.AP.float);
CssProp.FONT_STRETCH = CssProp.reg(CssProp.AP.font_stretch);
CssProp.FONT_STYLE = CssProp.reg(CssProp.AP.font_style);
CssProp.FONT_VARIANT = CssProp.reg(CssProp.AP.font_variant);
CssProp.FONT_WEIGHT = CssProp.reg(CssProp.AP.font_weight);
CssProp.LIST_STYLE_POSITION = CssProp.reg(CssProp.AP.list_style_position);
CssProp.LIST_STYLE_TYPE = CssProp.reg(CssProp.AP.list_style_type);
CssProp.OVERFLOW = CssProp.reg(CssProp.AP.overflow);
CssProp.OVERFLOW_WRAP = CssProp.reg(CssProp.AP.overflow_wrap);
CssProp.OVERFLOW_X = CssProp.reg(CssProp.AP.overflow_x);
CssProp.PAGE_BREAK_AFTER = CssProp.reg(CssProp.AP.page_break_after);
CssProp.PAGE_BREAK_BEFORE = CssProp.reg(CssProp.AP.page_break_before);
CssProp.PAGE_BREAK_INSIDE = CssProp.reg(CssProp.AP.page_break_inside);
CssProp.POSITION = CssProp.reg(CssProp.AP.position);
CssProp.RESIZE = CssProp.reg(CssProp.AP.resize);
CssProp.SPEAK = CssProp.reg(CssProp.AP.speak);
CssProp.SPEAK_HEADER = CssProp.reg(CssProp.AP.speak_header);
CssProp.SPEAK_NUMERAL = CssProp.reg(CssProp.AP.speak_numeral);
CssProp.SPEAK_PUNCTUATION = CssProp.reg(CssProp.AP.speak_punctuation);
CssProp.TABLE_LAYOUT = CssProp.reg(CssProp.AP.table_layout);
CssProp.TEXT_ALIGN = CssProp.reg(CssProp.AP.text_align);
CssProp.TEXT_DECORATION = CssProp.reg(CssProp.AP.text_decoration);
CssProp.TEXT_TRANSFORM = CssProp.reg(CssProp.AP.text_transform);
CssProp.TEXT_WRAP = CssProp.reg(CssProp.AP.text_wrap);
CssProp.UNICODE_BIDI = CssProp.reg(CssProp.AP.unicode_bidi);
CssProp.VISIBILITY = CssProp.reg(CssProp.AP.visibility);
CssProp.WHITE_SPACE = CssProp.reg(CssProp.AP.white_space);
CssProp.WORD_BREAK = CssProp.reg(CssProp.AP.word_break);
CssProp.BACKGROUND_ATTACHMENT = CssProp.reg(CssProp.CP.background_attachment);
CssProp.BACKGROUND_COLOR = CssProp.reg(CssProp.CP.background_color);
CssProp.BACKGROUND_ORIGIN = CssProp.reg(CssProp.CP.background_origin);
CssProp.BACKGROUND_REPEAT = CssProp.reg(CssProp.CP.background_repeat);
CssProp.BORDER = CssProp.reg(CssProp.CP.border);
CssProp.BORDER_RADIUS = CssProp.reg(CssProp.CP.border_radius);
CssProp.BORDER_SPACING = CssProp.reg(CssProp.CP.border_spacing);
CssProp.BORDER_TOP_COLOR = CssProp.reg(CssProp.CP.border_top_color);
CssProp.BORDER_TOP_STYLE = CssProp.reg(CssProp.CP.border_top_style);
CssProp.BORDER_WIDTH = CssProp.reg(CssProp.CP.border_width);
CssProp.COLOR = CssProp.reg(CssProp.CP.color);
CssProp.CURSOR = CssProp.reg(CssProp.CP.cursor);
CssProp.DISPLAY = CssProp.reg(CssProp.CP.display);
CssProp.DISPLAY_OUTSIDE = CssProp.reg(CssProp.CP.display_outside);
CssProp.ELEVATION = CssProp.reg(CssProp.CP.elevation);
CssProp.FONT_FAMILY = CssProp.reg(CssProp.CP.font_family);
CssProp.HEIGHT = CssProp.reg(CssProp.CP.height);
CssProp.LETTER_SPACING = CssProp.reg(CssProp.CP.letter_spacing);
CssProp.LIST_STYLE_IMAGE = CssProp.reg(CssProp.CP.list_style_image);
CssProp.MARGIN_RIGHT = CssProp.reg(CssProp.CP.margin_right);
CssProp.MAX_HEIGHT = CssProp.reg(CssProp.CP.max_height);
CssProp.MIN_HEIGHT = CssProp.reg(CssProp.CP.min_height);
CssProp.OPACITY = CssProp.reg(CssProp.CP.opacity);
CssProp.OUTLINE_COLOR = CssProp.reg(CssProp.CP.outline_color);
CssProp.OUTLINE_WIDTH = CssProp.reg(CssProp.CP.outline_width);
CssProp.PADDING = CssProp.reg(CssProp.CP.padding);
CssProp.PADDING_TOP = CssProp.reg(CssProp.CP.padding_top);
CssProp.PITCH_RANGE = CssProp.reg(CssProp.CP.pitch_range);
CssProp.RIGHT = CssProp.reg(CssProp.CP.right);
CssProp.STRESS = CssProp.reg(CssProp.CP.stress);
CssProp.TEXT_INDENT = CssProp.reg(CssProp.CP.text_indent);
CssProp.TEXT_SHADOW = CssProp.reg(CssProp.CP.text_shadow);
CssProp.VOLUME = CssProp.reg(CssProp.CP.volume);
CssProp.WORD_WRAP = CssProp.reg(CssProp.CP.word_wrap);
CssProp.ZOOM = CssProp.reg(CssProp.CP.zoom);
CssProp.BACKFACE_VISIBILITY = CssProp.reg(CssProp.CP.backface_visibility);
CssProp.BACKGROUND_CLIP = CssProp.reg(CssProp.CP.background_clip);
CssProp.BACKGROUND_POSITION = CssProp.reg(CssProp.CP.background_position);
CssProp.BORDER_BOTTOM_COLOR = CssProp.reg(CssProp.CP.border_bottom_color);
CssProp.BORDER_BOTTOM_STYLE = CssProp.reg(CssProp.CP.border_bottom_style);
CssProp.BORDER_COLOR = CssProp.reg(CssProp.CP.border_color);
CssProp.BORDER_LEFT_COLOR = CssProp.reg(CssProp.CP.border_left_color);
CssProp.BORDER_RIGHT_COLOR = CssProp.reg(CssProp.CP.border_right_color);
CssProp.BORDER_STYLE = CssProp.reg(CssProp.CP.border_style);
CssProp.BORDER_TOP_LEFT_RADIUS = CssProp.reg(CssProp.CP.border_top_left_radius);
CssProp.BORDER_TOP_WIDTH = CssProp.reg(CssProp.CP.border_top_width);
CssProp.BOX_SHADOW = CssProp.reg(CssProp.CP.box_shadow);
CssProp.CLIP = CssProp.reg(CssProp.CP.clip);
CssProp.DISPLAY_INSIDE = CssProp.reg(CssProp.CP.display_inside);
CssProp.FONT_SIZE = CssProp.reg(CssProp.CP.font_size);
CssProp.LINE_HEIGHT = CssProp.reg(CssProp.CP.line_height);
CssProp.MARGIN_LEFT = CssProp.reg(CssProp.CP.margin_left);
CssProp.MAX_WIDTH = CssProp.reg(CssProp.CP.max_width);
CssProp.OUTLINE_STYLE = CssProp.reg(CssProp.CP.outline_style);
CssProp.PADDING_BOTTOM = CssProp.reg(CssProp.CP.padding_bottom);
CssProp.PADDING_RIGHT = CssProp.reg(CssProp.CP.padding_right);
CssProp.PERSPECTIVE = CssProp.reg(CssProp.CP.perspective);
CssProp.RICHNESS = CssProp.reg(CssProp.CP.richness);
CssProp.TEXT_OVERFLOW = CssProp.reg(CssProp.CP.text_overflow);
CssProp.TOP = CssProp.reg(CssProp.CP.top);
CssProp.WIDTH = CssProp.reg(CssProp.CP.width);
CssProp.Z_INDEX = CssProp.reg(CssProp.CP.z_index);
CssProp.BACKGROUND = CssProp.reg(CssProp.CP.background);
CssProp.BACKGROUND_SIZE = CssProp.reg(CssProp.CP.background_size);
CssProp.BORDER_BOTTOM_LEFT_RADIUS = CssProp.reg(CssProp.CP.border_bottom_left_radius);
CssProp.BORDER_BOTTOM_WIDTH = CssProp.reg(CssProp.CP.border_bottom_width);
CssProp.BORDER_LEFT_STYLE = CssProp.reg(CssProp.CP.border_left_style);
CssProp.BORDER_RIGHT_STYLE = CssProp.reg(CssProp.CP.border_right_style);
CssProp.BORDER_TOP = CssProp.reg(CssProp.CP.border_top);
CssProp.BOTTOM = CssProp.reg(CssProp.CP.bottom);
CssProp.LIST_STYLE = CssProp.reg(CssProp.CP.list_style);
CssProp.MARGIN_TOP = CssProp.reg(CssProp.CP.margin_top);
CssProp.OUTLINE = CssProp.reg(CssProp.CP.outline);
CssProp.OVERFLOW_Y = CssProp.reg(CssProp.CP.overflow_y);
CssProp.PITCH = CssProp.reg(CssProp.CP.pitch);
CssProp.VERTICAL_ALIGN = CssProp.reg(CssProp.CP.vertical_align);
CssProp.WORD_SPACING = CssProp.reg(CssProp.CP.word_spacing);
CssProp.BACKGROUND_IMAGE = CssProp.reg(CssProp.CP.background_image);
CssProp.BORDER_BOTTOM_RIGHT_RADIUS = CssProp.reg(CssProp.CP.border_bottom_right_radius);
CssProp.BORDER_LEFT_WIDTH = CssProp.reg(CssProp.CP.border_left_width);
CssProp.BORDER_RIGHT_WIDTH = CssProp.reg(CssProp.CP.border_right_width);
CssProp.LEFT = CssProp.reg(CssProp.CP.left);
CssProp.MARGIN_BOTTOM = CssProp.reg(CssProp.CP.margin_bottom);
CssProp.PAUSE_AFTER = CssProp.reg(CssProp.CP.pause_after);
CssProp.SPEECH_RATE = CssProp.reg(CssProp.CP.speech_rate);
CssProp.TRANSITION_DURATION = CssProp.reg(CssProp.CP.transition_duration);
CssProp.BORDER_BOTTOM = CssProp.reg(CssProp.CP.border_bottom);
CssProp.BORDER_RIGHT = CssProp.reg(CssProp.CP.border_right);
CssProp.MARGIN = CssProp.reg(CssProp.CP.margin);
CssProp.PADDING_LEFT = CssProp.reg(CssProp.CP.padding_left);
CssProp.BORDER_LEFT = CssProp.reg(CssProp.CP.border_left);
CssProp.FONT = CssProp.reg(CssProp.CP.font);
CssProp.QUOTES = CssProp.reg(CssProp.CP.quotes);
CssProp.BORDER_TOP_RIGHT_RADIUS = CssProp.reg(CssProp.CP.border_top_right_radius);
CssProp.MIN_WIDTH = CssProp.reg(CssProp.CP.min_width);
/**
 * A class to sanitize HTML strings.
 */
class Sanitizer {
    constructor() {
        this._autolink = true;
        this._allowNamedProperties = false;
        this._generateOptions = () => {
            const schemesToAllow = Array.isArray(this._customAllowedSchemes)
                ? this._customAllowedSchemes
                : [...(sanitize_html_default()).defaults.allowedSchemes];
            return {
                // HTML tags that are allowed to be used. Tags were extracted from Google Caja
                allowedTags: [
                    'a',
                    'abbr',
                    'acronym',
                    'address',
                    'area',
                    'article',
                    'aside',
                    'audio',
                    'b',
                    'bdi',
                    'bdo',
                    'big',
                    'blockquote',
                    'br',
                    'button',
                    'canvas',
                    'caption',
                    'center',
                    'cite',
                    'code',
                    'col',
                    'colgroup',
                    'colspan',
                    'command',
                    'data',
                    'datalist',
                    'dd',
                    'del',
                    'details',
                    'dfn',
                    'dir',
                    'div',
                    'dl',
                    'dt',
                    'em',
                    'fieldset',
                    'figcaption',
                    'figure',
                    'font',
                    'footer',
                    'form',
                    'h1',
                    'h2',
                    'h3',
                    'h4',
                    'h5',
                    'h6',
                    'header',
                    'hgroup',
                    'hr',
                    'i',
                    // 'iframe' is allowed by Google Caja, but disallowed by default by sanitize-html
                    // , 'iframe'
                    'img',
                    'input',
                    'ins',
                    'kbd',
                    'label',
                    'legend',
                    'li',
                    'map',
                    'mark',
                    'menu',
                    'meter',
                    'nav',
                    'nobr',
                    'ol',
                    'optgroup',
                    'option',
                    'output',
                    'p',
                    'pre',
                    'progress',
                    'q',
                    'rowspan',
                    's',
                    'samp',
                    'section',
                    'select',
                    'small',
                    'source',
                    'span',
                    'strike',
                    'strong',
                    'sub',
                    'summary',
                    'sup',
                    'table',
                    'tbody',
                    'td',
                    'textarea',
                    'tfoot',
                    'th',
                    'thead',
                    'time',
                    'tr',
                    'track',
                    'tt',
                    'u',
                    'ul',
                    'var',
                    'video',
                    'wbr'
                ],
                // Attributes that HTML tags are allowed to have, extracted from Google Caja.
                // See https://github.com/jupyterlab/jupyterlab/issues/1812#issuecomment-285848435
                allowedAttributes: {
                    '*': [
                        'class',
                        'dir',
                        'draggable',
                        'hidden',
                        ...(this._allowNamedProperties ? ['id'] : []),
                        'inert',
                        'itemprop',
                        'itemref',
                        'itemscope',
                        'lang',
                        'spellcheck',
                        'style',
                        'title',
                        'translate'
                    ],
                    // 'rel' and 'target' were *not* allowed by Google Caja
                    a: [
                        'accesskey',
                        'coords',
                        'href',
                        'hreflang',
                        ...(this._allowNamedProperties ? ['name'] : []),
                        'rel',
                        'shape',
                        'tabindex',
                        'target',
                        'type'
                    ],
                    area: [
                        'accesskey',
                        'alt',
                        'coords',
                        'href',
                        'nohref',
                        'shape',
                        'tabindex'
                    ],
                    // 'autoplay' was *not* allowed by Google Caja
                    audio: [
                        'autoplay',
                        'controls',
                        'loop',
                        'mediagroup',
                        'muted',
                        'preload',
                        'src'
                    ],
                    bdo: ['dir'],
                    blockquote: ['cite'],
                    br: ['clear'],
                    button: [
                        'accesskey',
                        'data-commandlinker-args',
                        'data-commandlinker-command',
                        'disabled',
                        ...(this._allowNamedProperties ? ['name'] : []),
                        'tabindex',
                        'type',
                        'value'
                    ],
                    canvas: ['height', 'width'],
                    caption: ['align'],
                    col: ['align', 'char', 'charoff', 'span', 'valign', 'width'],
                    colgroup: ['align', 'char', 'charoff', 'span', 'valign', 'width'],
                    command: [
                        'checked',
                        'command',
                        'disabled',
                        'icon',
                        'label',
                        'radiogroup',
                        'type'
                    ],
                    data: ['value'],
                    del: ['cite', 'datetime'],
                    details: ['open'],
                    dir: ['compact'],
                    div: ['align'],
                    dl: ['compact'],
                    fieldset: ['disabled'],
                    font: ['color', 'face', 'size'],
                    form: [
                        'accept',
                        'autocomplete',
                        'enctype',
                        'method',
                        ...(this._allowNamedProperties ? ['name'] : []),
                        'novalidate'
                    ],
                    h1: ['align'],
                    h2: ['align'],
                    h3: ['align'],
                    h4: ['align'],
                    h5: ['align'],
                    h6: ['align'],
                    hr: ['align', 'noshade', 'size', 'width'],
                    iframe: [
                        'align',
                        'frameborder',
                        'height',
                        'marginheight',
                        'marginwidth',
                        'width'
                    ],
                    img: [
                        'align',
                        'alt',
                        'border',
                        'height',
                        'hspace',
                        'ismap',
                        ...(this._allowNamedProperties ? ['name'] : []),
                        'src',
                        'usemap',
                        'vspace',
                        'width'
                    ],
                    input: [
                        'accept',
                        'accesskey',
                        'align',
                        'alt',
                        'autocomplete',
                        'checked',
                        'disabled',
                        'inputmode',
                        'ismap',
                        'list',
                        'max',
                        'maxlength',
                        'min',
                        'multiple',
                        ...(this._allowNamedProperties ? ['name'] : []),
                        'placeholder',
                        'readonly',
                        'required',
                        'size',
                        'src',
                        'step',
                        'tabindex',
                        'type',
                        'usemap',
                        'value'
                    ],
                    ins: ['cite', 'datetime'],
                    label: ['accesskey', 'for'],
                    legend: ['accesskey', 'align'],
                    li: ['type', 'value'],
                    map: this._allowNamedProperties ? ['name'] : [],
                    menu: ['compact', 'label', 'type'],
                    meter: ['high', 'low', 'max', 'min', 'value'],
                    ol: ['compact', 'reversed', 'start', 'type'],
                    optgroup: ['disabled', 'label'],
                    option: ['disabled', 'label', 'selected', 'value'],
                    output: ['for', ...(this._allowNamedProperties ? ['name'] : [])],
                    p: ['align'],
                    pre: ['width'],
                    progress: ['max', 'min', 'value'],
                    q: ['cite'],
                    select: [
                        'autocomplete',
                        'disabled',
                        'multiple',
                        ...(this._allowNamedProperties ? ['name'] : []),
                        'required',
                        'size',
                        'tabindex'
                    ],
                    source: ['type'],
                    table: [
                        'align',
                        'bgcolor',
                        'border',
                        'cellpadding',
                        'cellspacing',
                        'frame',
                        'rules',
                        'summary',
                        'width'
                    ],
                    tbody: ['align', 'char', 'charoff', 'valign'],
                    td: [
                        'abbr',
                        'align',
                        'axis',
                        'bgcolor',
                        'char',
                        'charoff',
                        'colspan',
                        'headers',
                        'height',
                        'nowrap',
                        'rowspan',
                        'scope',
                        'valign',
                        'width'
                    ],
                    textarea: [
                        'accesskey',
                        'autocomplete',
                        'cols',
                        'disabled',
                        'inputmode',
                        ...(this._allowNamedProperties ? ['name'] : []),
                        'placeholder',
                        'readonly',
                        'required',
                        'rows',
                        'tabindex',
                        'wrap'
                    ],
                    tfoot: ['align', 'char', 'charoff', 'valign'],
                    th: [
                        'abbr',
                        'align',
                        'axis',
                        'bgcolor',
                        'char',
                        'charoff',
                        'colspan',
                        'headers',
                        'height',
                        'nowrap',
                        'rowspan',
                        'scope',
                        'valign',
                        'width'
                    ],
                    thead: ['align', 'char', 'charoff', 'valign'],
                    tr: ['align', 'bgcolor', 'char', 'charoff', 'valign'],
                    track: ['default', 'kind', 'label', 'srclang'],
                    ul: ['compact', 'type'],
                    video: [
                        'autoplay',
                        'controls',
                        'height',
                        'loop',
                        'mediagroup',
                        'muted',
                        'poster',
                        'preload',
                        'src',
                        'width'
                    ]
                },
                // Inline CSS styles that HTML tags may have (and their allowed values)
                allowedStyles: {
                    // To simplify the data, all styles are allowed on all tags that allow the style attribute
                    '*': {
                        'backface-visibility': [CssProp.BACKFACE_VISIBILITY],
                        background: [CssProp.BACKGROUND],
                        'background-attachment': [CssProp.BACKGROUND_ATTACHMENT],
                        'background-clip': [CssProp.BACKGROUND_CLIP],
                        'background-color': [CssProp.BACKGROUND_COLOR],
                        'background-image': [CssProp.BACKGROUND_IMAGE],
                        'background-origin': [CssProp.BACKGROUND_ORIGIN],
                        'background-position': [CssProp.BACKGROUND_POSITION],
                        'background-repeat': [CssProp.BACKGROUND_REPEAT],
                        'background-size': [CssProp.BACKGROUND_SIZE],
                        border: [CssProp.BORDER],
                        'border-bottom': [CssProp.BORDER_BOTTOM],
                        'border-bottom-color': [CssProp.BORDER_BOTTOM_COLOR],
                        'border-bottom-left-radius': [CssProp.BORDER_BOTTOM_LEFT_RADIUS],
                        'border-bottom-right-radius': [CssProp.BORDER_BOTTOM_RIGHT_RADIUS],
                        'border-bottom-style': [CssProp.BORDER_BOTTOM_STYLE],
                        'border-bottom-width': [CssProp.BORDER_BOTTOM_WIDTH],
                        'border-collapse': [CssProp.BORDER_COLLAPSE],
                        'border-color': [CssProp.BORDER_COLOR],
                        'border-left': [CssProp.BORDER_LEFT],
                        'border-left-color': [CssProp.BORDER_LEFT_COLOR],
                        'border-left-style': [CssProp.BORDER_LEFT_STYLE],
                        'border-left-width': [CssProp.BORDER_LEFT_WIDTH],
                        'border-radius': [CssProp.BORDER_RADIUS],
                        'border-right': [CssProp.BORDER_RIGHT],
                        'border-right-color': [CssProp.BORDER_RIGHT_COLOR],
                        'border-right-style': [CssProp.BORDER_RIGHT_STYLE],
                        'border-right-width': [CssProp.BORDER_RIGHT_WIDTH],
                        'border-spacing': [CssProp.BORDER_SPACING],
                        'border-style': [CssProp.BORDER_STYLE],
                        'border-top': [CssProp.BORDER_TOP],
                        'border-top-color': [CssProp.BORDER_TOP_COLOR],
                        'border-top-left-radius': [CssProp.BORDER_TOP_LEFT_RADIUS],
                        'border-top-right-radius': [CssProp.BORDER_TOP_RIGHT_RADIUS],
                        'border-top-style': [CssProp.BORDER_TOP_STYLE],
                        'border-top-width': [CssProp.BORDER_TOP_WIDTH],
                        'border-width': [CssProp.BORDER_WIDTH],
                        bottom: [CssProp.BOTTOM],
                        box: [CssProp.BOX],
                        'box-shadow': [CssProp.BOX_SHADOW],
                        'box-sizing': [CssProp.BOX_SIZING],
                        'caption-side': [CssProp.CAPTION_SIDE],
                        clear: [CssProp.CLEAR],
                        clip: [CssProp.CLIP],
                        color: [CssProp.COLOR],
                        cursor: [CssProp.CURSOR],
                        direction: [CssProp.DIRECTION],
                        display: [CssProp.DISPLAY],
                        'display-inside': [CssProp.DISPLAY_INSIDE],
                        'display-outside': [CssProp.DISPLAY_OUTSIDE],
                        elevation: [CssProp.ELEVATION],
                        'empty-cells': [CssProp.EMPTY_CELLS],
                        float: [CssProp.FLOAT],
                        font: [CssProp.FONT],
                        'font-family': [CssProp.FONT_FAMILY],
                        'font-size': [CssProp.FONT_SIZE],
                        'font-stretch': [CssProp.FONT_STRETCH],
                        'font-style': [CssProp.FONT_STYLE],
                        'font-variant': [CssProp.FONT_VARIANT],
                        'font-weight': [CssProp.FONT_WEIGHT],
                        height: [CssProp.HEIGHT],
                        left: [CssProp.LEFT],
                        'letter-spacing': [CssProp.LETTER_SPACING],
                        'line-height': [CssProp.LINE_HEIGHT],
                        'list-style': [CssProp.LIST_STYLE],
                        'list-style-image': [CssProp.LIST_STYLE_IMAGE],
                        'list-style-position': [CssProp.LIST_STYLE_POSITION],
                        'list-style-type': [CssProp.LIST_STYLE_TYPE],
                        margin: [CssProp.MARGIN],
                        'margin-bottom': [CssProp.MARGIN_BOTTOM],
                        'margin-left': [CssProp.MARGIN_LEFT],
                        'margin-right': [CssProp.MARGIN_RIGHT],
                        'margin-top': [CssProp.MARGIN_TOP],
                        'max-height': [CssProp.MAX_HEIGHT],
                        'max-width': [CssProp.MAX_WIDTH],
                        'min-height': [CssProp.MIN_HEIGHT],
                        'min-width': [CssProp.MIN_WIDTH],
                        opacity: [CssProp.OPACITY],
                        outline: [CssProp.OUTLINE],
                        'outline-color': [CssProp.OUTLINE_COLOR],
                        'outline-style': [CssProp.OUTLINE_STYLE],
                        'outline-width': [CssProp.OUTLINE_WIDTH],
                        overflow: [CssProp.OVERFLOW],
                        'overflow-wrap': [CssProp.OVERFLOW_WRAP],
                        'overflow-x': [CssProp.OVERFLOW_X],
                        'overflow-y': [CssProp.OVERFLOW_Y],
                        padding: [CssProp.PADDING],
                        'padding-bottom': [CssProp.PADDING_BOTTOM],
                        'padding-left': [CssProp.PADDING_LEFT],
                        'padding-right': [CssProp.PADDING_RIGHT],
                        'padding-top': [CssProp.PADDING_TOP],
                        'page-break-after': [CssProp.PAGE_BREAK_AFTER],
                        'page-break-before': [CssProp.PAGE_BREAK_BEFORE],
                        'page-break-inside': [CssProp.PAGE_BREAK_INSIDE],
                        'pause-after': [CssProp.PAUSE_AFTER],
                        perspective: [CssProp.PERSPECTIVE],
                        pitch: [CssProp.PITCH],
                        'pitch-range': [CssProp.PITCH_RANGE],
                        position: [CssProp.POSITION],
                        quotes: [CssProp.QUOTES],
                        resize: [CssProp.RESIZE],
                        richness: [CssProp.RICHNESS],
                        right: [CssProp.RIGHT],
                        speak: [CssProp.SPEAK],
                        'speak-header': [CssProp.SPEAK_HEADER],
                        'speak-numeral': [CssProp.SPEAK_NUMERAL],
                        'speak-punctuation': [CssProp.SPEAK_PUNCTUATION],
                        'speech-rate': [CssProp.SPEECH_RATE],
                        stress: [CssProp.STRESS],
                        'table-layout': [CssProp.TABLE_LAYOUT],
                        'text-align': [CssProp.TEXT_ALIGN],
                        'text-decoration': [CssProp.TEXT_DECORATION],
                        'text-indent': [CssProp.TEXT_INDENT],
                        'text-overflow': [CssProp.TEXT_OVERFLOW],
                        'text-shadow': [CssProp.TEXT_SHADOW],
                        'text-transform': [CssProp.TEXT_TRANSFORM],
                        'text-wrap': [CssProp.TEXT_WRAP],
                        top: [CssProp.TOP],
                        'unicode-bidi': [CssProp.UNICODE_BIDI],
                        'vertical-align': [CssProp.VERTICAL_ALIGN],
                        visibility: [CssProp.VISIBILITY],
                        volume: [CssProp.VOLUME],
                        'white-space': [CssProp.WHITE_SPACE],
                        width: [CssProp.WIDTH],
                        'word-break': [CssProp.WORD_BREAK],
                        'word-spacing': [CssProp.WORD_SPACING],
                        'word-wrap': [CssProp.WORD_WRAP],
                        'z-index': [CssProp.Z_INDEX],
                        zoom: [CssProp.ZOOM]
                    }
                },
                transformTags: {
                    // Set the "rel" attribute for <a> tags to "nofollow".
                    a: sanitize_html_default().simpleTransform('a', { rel: 'nofollow' }),
                    // Set the "disabled" attribute for <input> tags.
                    input: sanitize_html_default().simpleTransform('input', { disabled: 'disabled' })
                },
                allowedSchemes: schemesToAllow,
                allowedSchemesByTag: {
                    // Allow 'attachment:' img src (used for markdown cell attachments).
                    img: [...schemesToAllow, 'attachment']
                },
                // Override of the default option, so we can skip 'src' attribute validation.
                // 'src' Attributes are validated to be URIs, which does not allow for embedded (image) data.
                // Since embedded data is no longer deemed to be a threat, validation can be skipped.
                // See https://github.com/jupyterlab/jupyterlab/issues/5183
                allowedSchemesAppliedToAttributes: ['href', 'cite']
            };
        };
        this._options = this._generateOptions();
    }
    /**
     * Sanitize an HTML string.
     *
     * @param dirty - The dirty text.
     *
     * @param options - The optional sanitization options.
     *
     * @returns The sanitized string.
     */
    sanitize(dirty, options) {
        return sanitize_html_default()(dirty, { ...this._options, ...(options || {}) });
    }
    /**
     * @returns Whether to replace URLs by HTML anchors.
     */
    getAutolink() {
        return this._autolink;
    }
    /**
     * Set the allowed schemes
     *
     * @param scheme Allowed schemes.
     * Automatically regenerates sanitizer options to apply the change.
     * Note: the schemes merge into the current config and does not get overwritten.
     */
    setAllowedSchemes(scheme) {
        // Force copy of `scheme`
        this._customAllowedSchemes = [...scheme];
        this._options = this._generateOptions();
    }
    /**
     * Set the URL replacement boolean.
     *
     * @param autolink URL replacement boolean.
     */
    setAutolink(autolink) {
        this._autolink = autolink;
    }
    /**
     * Set the whether to allow `name` and `id` attributes.
     */
    setAllowNamedProperties(allowNamedProperties) {
        this._allowNamedProperties = allowNamedProperties;
        this._options = this._generateOptions();
    }
}
//# sourceMappingURL=sanitizer.js.map
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/apputils/lib/semanticCommand.js
/*
 * Copyright (c) Jupyter Development Team.
 * Distributed under the terms of the Modified BSD License.
 */
/**
 * Semantic group of commands
 */
class SemanticCommand {
    constructor() {
        this._commands = new Array();
    }
    /**
     * The command IDs used by this semantic command.
     */
    get ids() {
        return this._commands.map(c => c.id);
    }
    /**
     * Add a command to the semantic group
     *
     * @param command Command to add
     */
    add(command) {
        if (this._commands.map(c => c.id).includes(command.id)) {
            throw Error(`Command ${command.id} is already defined.`);
        }
        this._commands.push({
            isEnabled: () => true,
            rank: SemanticCommand.DEFAULT_RANK,
            ...command
        });
    }
    /**
     * Get the command id of the enabled command from this group
     * for the given widget.
     *
     * @param widget Widget
     * @returns Command id
     */
    getActiveCommandId(widget) {
        var _a;
        const commands = this._commands
            .filter(c => c.isEnabled(widget))
            .sort((a, b) => {
            const rankDelta = a.rank - b.rank;
            return rankDelta || (a.id < b.id ? -1 : 1);
        });
        const command = (_a = commands[0]) !== null && _a !== void 0 ? _a : { id: null };
        return command.id;
    }
    /**
     * Remove a command ID.
     *
     * @param id Command ID to remove
     */
    remove(id) {
        const index = this._commands.findIndex(c => c.id === id);
        if (index >= 0) {
            this._commands.splice(index, 1);
        }
    }
}
/**
 * Default rank for semantic command
 */
SemanticCommand.DEFAULT_RANK = 500;
/**
 * The `args` key for a semantic command's current widget ID.
 */
SemanticCommand.WIDGET = 'semanticWidget';
//# sourceMappingURL=semanticCommand.js.map
// EXTERNAL MODULE: consume shared module (default) @lumino/disposable@~2.1.4 (singleton) (fallback: ../node_modules/@lumino/disposable/dist/index.es6.js)
var disposable_dist_index_es6_js_ = __webpack_require__(38302);
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/apputils/lib/thememanager.js
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.





/**
 * The number of milliseconds between theme loading attempts.
 */
const REQUEST_INTERVAL = 75;
/**
 * The number of times to attempt to load a theme before giving up.
 */
const REQUEST_THRESHOLD = 20;
/**
 * A class that provides theme management.
 */
class ThemeManager {
    /**
     * Construct a new theme manager.
     */
    constructor(options) {
        this._current = null;
        this._links = [];
        this._overrides = {};
        this._overrideProps = {};
        this._outstanding = null;
        this._pending = 0;
        this._requests = {};
        this._themes = {};
        this._themeChanged = new signaling_dist_index_es6_js_.Signal(this);
        const { host, key, splash, url } = options;
        this.translator = options.translator || lib_index_js_.nullTranslator;
        this._trans = this.translator.load('jupyterlab');
        const registry = options.settings;
        this._base = url;
        this._host = host;
        this._splash = splash || null;
        void registry.load(key).then(settings => {
            this._settings = settings;
            // set up css overrides once we have a pointer to the settings schema
            this._initOverrideProps();
            this._settings.changed.connect(this._loadSettings, this);
            this._loadSettings();
        });
    }
    /**
     * Get the name of the current theme.
     */
    get theme() {
        return this._current;
    }
    /**
     * Get the name of the preferred light theme.
     */
    get preferredLightTheme() {
        return this._settings.composite['preferred-light-theme'];
    }
    /**
     * Get the name of the preferred dark theme.
     */
    get preferredDarkTheme() {
        return this._settings.composite['preferred-dark-theme'];
    }
    /**
     * Get the name of the preferred theme
     * When `adaptive-theme` is disabled, get current theme;
     * Else, depending on the system settings, get preferred light or dark theme.
     */
    get preferredTheme() {
        if (!this.isToggledAdaptiveTheme()) {
            return this.theme;
        }
        if (this.isSystemColorSchemeDark()) {
            return this.preferredDarkTheme;
        }
        return this.preferredLightTheme;
    }
    /**
     * The names of the registered themes.
     */
    get themes() {
        return Object.keys(this._themes);
    }
    /**
     * Get the names of the light themes.
     */
    get lightThemes() {
        return Object.entries(this._themes)
            .filter(([_, theme]) => theme.isLight)
            .map(([name, _]) => name);
    }
    /**
     * Get the names of the dark themes.
     */
    get darkThemes() {
        return Object.entries(this._themes)
            .filter(([_, theme]) => !theme.isLight)
            .map(([name, _]) => name);
    }
    /**
     * A signal fired when the application theme changes.
     */
    get themeChanged() {
        return this._themeChanged;
    }
    /**
     * Test if the system's preferred color scheme is dark
     */
    isSystemColorSchemeDark() {
        return (window.matchMedia &&
            window.matchMedia('(prefers-color-scheme: dark)').matches);
    }
    /**
     * Get the value of a CSS variable from its key.
     *
     * @param key - A Jupyterlab CSS variable, without the leading '--jp-'.
     *
     * @returns value - The current value of the Jupyterlab CSS variable
     */
    getCSS(key) {
        var _a;
        return ((_a = this._overrides[key]) !== null && _a !== void 0 ? _a : getComputedStyle(document.documentElement).getPropertyValue(`--jp-${key}`));
    }
    /**
     * Load a theme CSS file by path.
     *
     * @param path - The path of the file to load.
     */
    loadCSS(path) {
        const base = this._base;
        const href = coreutils_lib_index_js_.URLExt.isLocal(path) ? coreutils_lib_index_js_.URLExt.join(base, path) : path;
        const links = this._links;
        return new Promise((resolve, reject) => {
            const link = document.createElement('link');
            link.setAttribute('rel', 'stylesheet');
            link.setAttribute('type', 'text/css');
            link.setAttribute('href', href);
            link.addEventListener('load', () => {
                resolve(undefined);
            });
            link.addEventListener('error', () => {
                reject(`Stylesheet failed to load: ${href}`);
            });
            document.body.appendChild(link);
            links.push(link);
            // add any css overrides to document
            this.loadCSSOverrides();
        });
    }
    /**
     * Loads all current CSS overrides from settings. If an override has been
     * removed or is invalid, this function unloads it instead.
     */
    loadCSSOverrides() {
        var _a;
        const newOverrides = (_a = this._settings.user['overrides']) !== null && _a !== void 0 ? _a : {};
        // iterate over the union of current and new CSS override keys
        Object.keys({ ...this._overrides, ...newOverrides }).forEach(key => {
            const val = newOverrides[key];
            if (val && this.validateCSS(key, val)) {
                // validation succeeded, set the override
                document.documentElement.style.setProperty(`--jp-${key}`, val);
            }
            else {
                // if key is not present or validation failed, the override will be removed
                delete newOverrides[key];
                document.documentElement.style.removeProperty(`--jp-${key}`);
            }
        });
        // replace the current overrides with the new ones
        this._overrides = newOverrides;
    }
    /**
     * Validate a CSS value w.r.t. a key
     *
     * @param key - A Jupyterlab CSS variable, without the leading '--jp-'.
     *
     * @param val - A candidate CSS value
     */
    validateCSS(key, val) {
        // determine the css property corresponding to the key
        const prop = this._overrideProps[key];
        if (!prop) {
            console.warn('CSS validation failed: could not find property corresponding to key.\n' +
                `key: '${key}', val: '${val}'`);
            return false;
        }
        // use built-in validation once we have the corresponding property
        if (CSS.supports(prop, val)) {
            return true;
        }
        else {
            console.warn('CSS validation failed: invalid value.\n' +
                `key: '${key}', val: '${val}', prop: '${prop}'`);
            return false;
        }
    }
    /**
     * Register a theme with the theme manager.
     *
     * @param theme - The theme to register.
     *
     * @returns A disposable that can be used to unregister the theme.
     */
    register(theme) {
        const { name } = theme;
        const themes = this._themes;
        if (themes[name]) {
            throw new Error(`Theme already registered for ${name}`);
        }
        themes[name] = theme;
        return new disposable_dist_index_es6_js_.DisposableDelegate(() => {
            delete themes[name];
        });
    }
    /**
     * Add a CSS override to the settings.
     */
    setCSSOverride(key, value) {
        return this._settings.set('overrides', {
            ...this._overrides,
            [key]: value
        });
    }
    /**
     * Set the current theme.
     */
    setTheme(name) {
        return this._settings.set('theme', name);
    }
    /**
     * Set the preferred light theme.
     */
    setPreferredLightTheme(name) {
        return this._settings.set('preferred-light-theme', name);
    }
    /**
     * Set the preferred dark theme.
     */
    setPreferredDarkTheme(name) {
        return this._settings.set('preferred-dark-theme', name);
    }
    /**
     * Test whether a given theme is light.
     */
    isLight(name) {
        return this._themes[name].isLight;
    }
    /**
     * Increase a font size w.r.t. its current setting or its value in the
     * current theme.
     *
     * @param key - A Jupyterlab font size CSS variable, without the leading '--jp-'.
     */
    incrFontSize(key) {
        return this._incrFontSize(key, true);
    }
    /**
     * Decrease a font size w.r.t. its current setting or its value in the
     * current theme.
     *
     * @param key - A Jupyterlab font size CSS variable, without the leading '--jp-'.
     */
    decrFontSize(key) {
        return this._incrFontSize(key, false);
    }
    /**
     * Test whether a given theme styles scrollbars,
     * and if the user has scrollbar styling enabled.
     */
    themeScrollbars(name) {
        return (!!this._settings.composite['theme-scrollbars'] &&
            !!this._themes[name].themeScrollbars);
    }
    /**
     * Test if the user has scrollbar styling enabled.
     */
    isToggledThemeScrollbars() {
        return !!this._settings.composite['theme-scrollbars'];
    }
    /**
     * Toggle the `theme-scrollbars` setting.
     */
    toggleThemeScrollbars() {
        return this._settings.set('theme-scrollbars', !this._settings.composite['theme-scrollbars']);
    }
    /**
     * Test if the user enables adaptive theme.
     */
    isToggledAdaptiveTheme() {
        return !!this._settings.composite['adaptive-theme'];
    }
    /**
     * Toggle the `adaptive-theme` setting.
     */
    toggleAdaptiveTheme() {
        return this._settings.set('adaptive-theme', !this._settings.composite['adaptive-theme']);
    }
    /**
     * Get the display name of the theme.
     */
    getDisplayName(name) {
        var _a, _b;
        return (_b = (_a = this._themes[name]) === null || _a === void 0 ? void 0 : _a.displayName) !== null && _b !== void 0 ? _b : name;
    }
    /**
     * Change a font size by a positive or negative increment.
     */
    _incrFontSize(key, add = true) {
        var _a;
        // get the numeric and unit parts of the current font size
        const parts = ((_a = this.getCSS(key)) !== null && _a !== void 0 ? _a : '13px').split(/([a-zA-Z]+)/);
        // determine the increment
        const incr = (add ? 1 : -1) * (parts[1] === 'em' ? 0.1 : 1);
        // increment the font size and set it as an override
        return this.setCSSOverride(key, `${Number(parts[0]) + incr}${parts[1]}`);
    }
    /**
     * Initialize the key -> property dict for the overrides
     */
    _initOverrideProps() {
        const definitions = this._settings.schema.definitions;
        const overidesSchema = definitions.cssOverrides.properties;
        Object.keys(overidesSchema).forEach(key => {
            // override validation is against the CSS property in the description
            // field. Example: for key ui-font-family, .description is font-family
            let description;
            switch (key) {
                case 'code-font-size':
                case 'content-font-size1':
                case 'ui-font-size1':
                    description = 'font-size';
                    break;
                default:
                    description = overidesSchema[key].description;
                    break;
            }
            this._overrideProps[key] = description;
        });
    }
    /**
     * Handle the current settings.
     */
    _loadSettings() {
        const outstanding = this._outstanding;
        const pending = this._pending;
        const requests = this._requests;
        // If another request is pending, cancel it.
        if (pending) {
            window.clearTimeout(pending);
            this._pending = 0;
        }
        const settings = this._settings;
        const themes = this._themes;
        let theme = settings.composite['theme'];
        if (this.isToggledAdaptiveTheme()) {
            if (this.isSystemColorSchemeDark()) {
                theme = this.preferredDarkTheme;
            }
            else {
                theme = this.preferredLightTheme;
            }
        }
        // If another promise is outstanding, wait until it finishes before
        // attempting to load the settings. Because outstanding promises cannot
        // be aborted, the order in which they occur must be enforced.
        if (outstanding) {
            outstanding
                .then(() => {
                this._loadSettings();
            })
                .catch(() => {
                this._loadSettings();
            });
            this._outstanding = null;
            return;
        }
        // Increment the request counter.
        requests[theme] = requests[theme] ? requests[theme] + 1 : 1;
        // If the theme exists, load it right away.
        if (themes[theme]) {
            this._outstanding = this._loadTheme(theme);
            delete requests[theme];
            return;
        }
        // If the request has taken too long, give up.
        if (requests[theme] > REQUEST_THRESHOLD) {
            const fallback = settings.default('theme');
            // Stop tracking the requests for this theme.
            delete requests[theme];
            if (!themes[fallback]) {
                this._onError(this._trans.__('Neither theme %1 nor default %2 loaded.', theme, fallback));
                return;
            }
            console.warn(`Could not load theme ${theme}, using default ${fallback}.`);
            this._outstanding = this._loadTheme(fallback);
            return;
        }
        // If the theme does not yet exist, attempt to wait for it.
        this._pending = window.setTimeout(() => {
            this._loadSettings();
        }, REQUEST_INTERVAL);
    }
    /**
     * Load the theme.
     *
     * #### Notes
     * This method assumes that the `theme` exists.
     */
    _loadTheme(theme) {
        var _a;
        const current = this._current;
        const links = this._links;
        const themes = this._themes;
        const splash = this._splash
            ? this._splash.show(themes[theme].isLight)
            : new disposable_dist_index_es6_js_.DisposableDelegate(() => undefined);
        // Unload any CSS files that have been loaded.
        links.forEach(link => {
            if (link.parentElement) {
                link.parentElement.removeChild(link);
            }
        });
        links.length = 0;
        const themeProps = (_a = this._settings.schema.properties) === null || _a === void 0 ? void 0 : _a.theme;
        if (themeProps) {
            themeProps.enum = Object.keys(themes).map(value => { var _a; return (_a = themes[value].displayName) !== null && _a !== void 0 ? _a : value; });
        }
        // Unload the previously loaded theme.
        const old = current ? themes[current].unload() : Promise.resolve();
        return Promise.all([old, themes[theme].load()])
            .then(() => {
            this._current = theme;
            this._themeChanged.emit({
                name: 'theme',
                oldValue: current,
                newValue: theme
            });
            // Need to force a redraw of the app here to avoid a Chrome rendering
            // bug that can leave the scrollbars in an invalid state
            this._host.hide();
            // If we hide/show the widget too quickly, no redraw will happen.
            // requestAnimationFrame delays until after the next frame render.
            requestAnimationFrame(() => {
                this._host.show();
                thememanager_Private.fitAll(this._host);
                splash.dispose();
            });
        })
            .catch(reason => {
            this._onError(reason);
            splash.dispose();
        });
    }
    /**
     * Handle a theme error.
     */
    _onError(reason) {
        void showDialog({
            title: this._trans.__('Error Loading Theme'),
            body: String(reason),
            buttons: [Dialog.okButton({ label: this._trans.__('OK') })]
        });
    }
}
/**
 * A namespace for module private data.
 */
var thememanager_Private;
(function (Private) {
    /**
     * Fit a widget and all of its children, recursively.
     */
    function fitAll(widget) {
        for (const child of widget.children()) {
            fitAll(child);
        }
        widget.fit();
    }
    Private.fitAll = fitAll;
})(thememanager_Private || (thememanager_Private = {}));
//# sourceMappingURL=thememanager.js.map
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/apputils/lib/tokens.js
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.

/**
 * The command palette token.
 */
const ICommandPalette = new dist_index_js_.Token('@jupyterlab/apputils:ICommandPalette', `A service for the application command palette
  in the left panel. Use this to add commands to the palette.`);
/**
 * The kernel status indicator model.
 */
const IKernelStatusModel = new dist_index_js_.Token('@jupyterlab/apputils:IKernelStatusModel', 'A service to register kernel session provider to the kernel status indicator.');
/**
 * The license client for fetching licenses.
 */
const ILicensesClient = new dist_index_js_.Token('@jupyterlab/apputils:ILicensesClient', 'A service for fetching licenses.');
/**
 * The session context dialogs token.
 */
const ISessionContextDialogs = new dist_index_js_.Token('@jupyterlab/apputils:ISessionContextDialogs', 'A service for handling the session dialogs.');
/**
 * The theme manager token.
 */
const IThemeManager = new dist_index_js_.Token('@jupyterlab/apputils:IThemeManager', 'A service for the theme manager for the application. This is used primarily in theme extensions to register new themes.');
/**
 * The sanitizer token.
 */
const ISanitizer = new dist_index_js_.Token('@jupyterlab/apputils:ISanitizer', 'A service for sanitizing HTML strings.');
/**
 * The main menu token.
 */
const ISplashScreen = new dist_index_js_.Token('@jupyterlab/apputils:ISplashScreen', `A service for the splash screen for the application.
  Use this if you want to show the splash screen for your own purposes.`);
/**
 * The default window resolver token.
 */
const IWindowResolver = new dist_index_js_.Token('@jupyterlab/apputils:IWindowResolver', `A service for a window resolver for the
  application. JupyterLab workspaces are given a name, which are determined using
  the window resolver. Require this if you want to use the name of the current workspace.`);
/**
 * The toolbar registry token.
 */
const IToolbarWidgetRegistry = new dist_index_js_.Token('@jupyterlab/apputils:IToolbarWidgetRegistry', `A registry for toolbar widgets. Require this
  if you want to build the toolbar dynamically from a data definition (stored in settings for example).`);
//# sourceMappingURL=tokens.js.map
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/apputils/lib/toolbar/registry.js
/*
 * Copyright (c) Jupyter Development Team.
 * Distributed under the terms of the Modified BSD License.
 */



/**
 * Concrete implementation of IToolbarWidgetRegistry interface
 */
class ToolbarWidgetRegistry {
    constructor(options) {
        this._widgets = new Map();
        this._factoryAdded = new signaling_dist_index_es6_js_.Signal(this);
        this._defaultFactory = options.defaultFactory;
    }
    /**
     * Default toolbar item factory
     */
    get defaultFactory() {
        return this._defaultFactory;
    }
    set defaultFactory(factory) {
        this._defaultFactory = factory;
    }
    /**
     * A signal emitted when a factory widget has been added.
     */
    get factoryAdded() {
        return this._factoryAdded;
    }
    /**
     * Create a toolbar item widget
     *
     * @param widgetFactory The widget factory name that creates the toolbar
     * @param widget The newly widget containing the toolbar
     * @param toolbarItem The toolbar item definition
     * @returns The widget to be inserted in the toolbar.
     */
    createWidget(widgetFactory, widget, toolbarItem) {
        var _a;
        const factory = (_a = this._widgets.get(widgetFactory)) === null || _a === void 0 ? void 0 : _a.get(toolbarItem.name);
        return factory
            ? factory(widget)
            : this._defaultFactory(widgetFactory, widget, toolbarItem);
    }
    /**
     * Add a new toolbar item factory
     *
     * @param widgetFactory The widget factory name that creates the toolbar
     * @param toolbarItemName The unique toolbar item
     * @param factory The factory function that receives the widget containing the toolbar and returns the toolbar widget.
     * @returns The previously defined factory
     */
    addFactory(widgetFactory, toolbarItemName, factory) {
        let namespace = this._widgets.get(widgetFactory);
        const oldFactory = namespace === null || namespace === void 0 ? void 0 : namespace.get(toolbarItemName);
        if (!namespace) {
            namespace = new Map();
            this._widgets.set(widgetFactory, namespace);
        }
        namespace.set(toolbarItemName, factory);
        this._factoryAdded.emit(toolbarItemName);
        return oldFactory;
    }
    /**
     * Register a new toolbar item factory
     *
     * @param widgetFactory The widget factory name that creates the toolbar
     * @param toolbarItemName The unique toolbar item
     * @param factory The factory function that receives the widget containing the toolbar and returns the toolbar widget.
     * @returns The previously defined factory
     *
     * @deprecated since v4 use `addFactory` instead
     */
    registerFactory(widgetFactory, toolbarItemName, factory) {
        return this.addFactory(widgetFactory, toolbarItemName, factory);
    }
}
/**
 * Create the default toolbar item widget factory
 *
 * @param commands Application commands registry
 * @returns Default factory
 */
function createDefaultFactory(commands) {
    return (widgetFactory, widget, toolbarItem) => {
        var _a, _b;
        switch ((_a = toolbarItem.type) !== null && _a !== void 0 ? _a : 'command') {
            case 'command': {
                const { command: tId, args: tArgs, label: tLabel, caption: tCaption, icon: tIcon } = toolbarItem;
                const id = tId !== null && tId !== void 0 ? tId : '';
                const args = { toolbar: true, ...tArgs };
                const icon = tIcon ? index_js_.LabIcon.resolve({ icon: tIcon }) : undefined;
                const toolbar = widget.toolbar;
                // If there is an icon, undefined label will results in no label
                // otherwise the label will be set using the setting or the command label
                const label = (icon !== null && icon !== void 0 ? icon : commands.icon(id, args)) ? tLabel !== null && tLabel !== void 0 ? tLabel : '' : tLabel;
                return new index_js_.CommandToolbarButton({
                    commands,
                    id,
                    args,
                    icon,
                    label,
                    caption: tCaption,
                    noFocusOnClick: (_b = toolbar === null || toolbar === void 0 ? void 0 : toolbar.noFocusOnClick) !== null && _b !== void 0 ? _b : false
                });
            }
            case 'spacer':
                return index_js_.Toolbar.createSpacerItem();
            default:
                return new index_es6_js_.Widget();
        }
    };
}
//# sourceMappingURL=registry.js.map
// EXTERNAL MODULE: consume shared module (default) @jupyterlab/observables@~5.4.5 (singleton) (fallback: ../node_modules/@jupyterlab/observables/lib/index.js)
var observables_lib_index_js_ = __webpack_require__(18458);
// EXTERNAL MODULE: consume shared module (default) @jupyterlab/settingregistry@~4.4.5 (singleton) (fallback: ../node_modules/@jupyterlab/settingregistry/lib/index.js)
var settingregistry_lib_index_js_ = __webpack_require__(51680);
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/apputils/lib/toolbar/factory.js
/*
 * Copyright (c) Jupyter Development Team.
 * Distributed under the terms of the Modified BSD License.
 */





/**
 * Default toolbar item rank
 *
 * #### Notes
 * This will place item just before the white spacer item in the notebook toolbar.
 */
const DEFAULT_TOOLBAR_ITEM_RANK = 50;
const TOOLBAR_KEY = 'jupyter.lab.toolbars';
/**
 * Display warning when the toolbar definition have been modified.
 *
 * @param trans Translation bundle
 */
async function displayInformation(trans) {
    const result = await showDialog({
        title: trans.__('Information'),
        body: trans.__('Toolbar customization has changed. You will need to reload JupyterLab to see the changes.'),
        buttons: [
            Dialog.cancelButton(),
            Dialog.okButton({ label: trans.__('Reload') })
        ]
    });
    if (result.button.accept) {
        location.reload();
    }
}
/**
 * Set the toolbar definition by accumulating all settings definition.
 *
 * The list will be populated only with the enabled items.
 *
 * @param toolbarItems Observable list to populate
 * @param registry Application settings registry
 * @param factoryName Widget factory name that needs a toolbar
 * @param pluginId Settings plugin id
 * @param translator Translator object
 * @param propertyId Property holding the toolbar definition in the settings; default 'toolbar'
 * @returns List of toolbar items
 */
async function setToolbarItems(toolbarItems, registry, factoryName, pluginId, translator, propertyId = 'toolbar') {
    var _a;
    const trans = translator.load('jupyterlab');
    let canonical = null;
    let loaded = {};
    let listenPlugin = true;
    try {
        /**
         * Populate the plugin's schema defaults.
         *
         * We keep track of disabled entries in case the plugin is loaded
         * after the toolbar initialization.
         */
        function populate(schema) {
            var _a, _b;
            loaded = {};
            const pluginDefaults = Object.keys(registry.plugins)
                // Filter out the current plugin (will be listed when reloading)
                // because we control its addition after the mapping step
                .filter(plugin => plugin !== pluginId)
                .map(plugin => {
                var _a, _b;
                const items = (_b = ((_a = registry.plugins[plugin].schema[TOOLBAR_KEY]) !== null && _a !== void 0 ? _a : {})[factoryName]) !== null && _b !== void 0 ? _b : [];
                loaded[plugin] = items;
                return items;
            })
                .concat([(_b = ((_a = schema[TOOLBAR_KEY]) !== null && _a !== void 0 ? _a : {})[factoryName]) !== null && _b !== void 0 ? _b : []])
                .reduceRight((acc, val) => settingregistry_lib_index_js_.SettingRegistry.reconcileToolbarItems(acc, val, true), []);
            // Apply default value as last step to take into account overrides.json
            // The standard toolbars default is [] as the plugin must use
            // `jupyter.lab.toolbars.<factory>` to define its default value.
            schema.properties[propertyId].default =
                settingregistry_lib_index_js_.SettingRegistry.reconcileToolbarItems(pluginDefaults, schema.properties[propertyId].default, true).sort((a, b) => {
                    var _a, _b;
                    return ((_a = a.rank) !== null && _a !== void 0 ? _a : DEFAULT_TOOLBAR_ITEM_RANK) -
                        ((_b = b.rank) !== null && _b !== void 0 ? _b : DEFAULT_TOOLBAR_ITEM_RANK);
                });
        }
        // Transform the plugin object to return different schema than the default.
        registry.transform(pluginId, {
            compose: plugin => {
                var _a, _b, _c, _d, _e;
                // Only override the canonical schema the first time.
                if (!canonical) {
                    canonical = dist_index_js_.JSONExt.deepCopy(plugin.schema);
                    populate(canonical);
                }
                const defaults = (_c = ((_b = ((_a = canonical.properties) !== null && _a !== void 0 ? _a : {})[propertyId]) !== null && _b !== void 0 ? _b : {}).default) !== null && _c !== void 0 ? _c : [];
                // Initialize the settings
                const user = plugin.data.user;
                const composite = plugin.data.composite;
                // Overrides the value with using the aggregated default for the toolbar property
                user[propertyId] =
                    (_d = plugin.data.user[propertyId]) !== null && _d !== void 0 ? _d : [];
                composite[propertyId] = ((_e = settingregistry_lib_index_js_.SettingRegistry.reconcileToolbarItems(defaults, user[propertyId], false)) !== null && _e !== void 0 ? _e : []).sort((a, b) => {
                    var _a, _b;
                    return ((_a = a.rank) !== null && _a !== void 0 ? _a : DEFAULT_TOOLBAR_ITEM_RANK) -
                        ((_b = b.rank) !== null && _b !== void 0 ? _b : DEFAULT_TOOLBAR_ITEM_RANK);
                });
                plugin.data = { composite, user };
                return plugin;
            },
            fetch: plugin => {
                // Only override the canonical schema the first time.
                if (!canonical) {
                    canonical = dist_index_js_.JSONExt.deepCopy(plugin.schema);
                    populate(canonical);
                }
                return {
                    data: plugin.data,
                    id: plugin.id,
                    raw: plugin.raw,
                    schema: canonical,
                    version: plugin.version
                };
            }
        });
    }
    catch (error) {
        if (error.name === 'TransformError') {
            // Assume the existing transformer is the toolbar builder transformer
            // from another factory set up.
            listenPlugin = false;
        }
        else {
            throw error;
        }
    }
    // Repopulate the canonical variable after the setting registry has
    // preloaded all initial plugins.
    const settings = await registry.load(pluginId);
    // React to customization by the user
    settings.changed.connect(() => {
        var _a;
        const newItems = (_a = settings.composite[propertyId]) !== null && _a !== void 0 ? _a : [];
        transferSettings(newItems);
    });
    const transferSettings = (newItems) => {
        // This is not optimal but safer because a toolbar item with the same
        // name cannot be inserted (it will be a no-op). But that could happen
        // if the settings are changing the items order.
        toolbarItems.clear();
        toolbarItems.pushAll(newItems.filter(item => !item.disabled));
    };
    // Initialize the toolbar
    transferSettings((_a = settings.composite[propertyId]) !== null && _a !== void 0 ? _a : []);
    // React to plugin changes if no other transformer exists, otherwise bail.
    if (!listenPlugin) {
        return;
    }
    registry.pluginChanged.connect(async (sender, plugin) => {
        var _a, _b, _c;
        // Since the plugin storing the toolbar definition is transformed above,
        // if it has changed, it means that a request to reload was triggered.
        // Hence the toolbar definitions from the other plugins have been
        // automatically reset during the transform step.
        if (plugin === pluginId) {
            return;
        }
        // If a plugin changed its toolbar items
        const oldItems = (_a = loaded[plugin]) !== null && _a !== void 0 ? _a : [];
        const newItems = (_c = ((_b = registry.plugins[plugin].schema[TOOLBAR_KEY]) !== null && _b !== void 0 ? _b : {})[factoryName]) !== null && _c !== void 0 ? _c : [];
        if (!dist_index_js_.JSONExt.deepEqual(oldItems, newItems)) {
            if (loaded[plugin]) {
                // The plugin has changed, request the user to reload the UI
                await displayInformation(trans);
            }
            else {
                if (newItems.length > 0) {
                    // Empty the default values to avoid toolbar settings collisions.
                    canonical = null;
                    const schema = registry.plugins[pluginId].schema;
                    schema.properties.toolbar.default = [];
                    // Run again the transformations.
                    await registry.load(pluginId, true);
                }
            }
        }
    });
}
/**
 * Create the toolbar factory for a given container widget based
 * on a data description stored in settings
 *
 * @param toolbarRegistry Toolbar widgets registry
 * @param settingsRegistry Settings registry
 * @param factoryName Toolbar container factory name
 * @param pluginId Settings plugin id
 * @param translator Translator
 * @param propertyId Toolbar definition key in the settings plugin
 * @returns List of toolbar widgets factory
 */
function createToolbarFactory(toolbarRegistry, settingsRegistry, factoryName, pluginId, translator, propertyId = 'toolbar') {
    const items = new observables_lib_index_js_.ObservableList({
        itemCmp: (a, b) => dist_index_js_.JSONExt.deepEqual(a, b)
    });
    // Get toolbar definition from the settings
    setToolbarItems(items, settingsRegistry, factoryName, pluginId, translator, propertyId).catch(reason => {
        console.error(`Failed to load toolbar items for factory ${factoryName} from ${pluginId}`, reason);
    });
    return (widget) => {
        const updateToolbar = (list, change) => {
            switch (change.type) {
                case 'move':
                    toolbar.move(change.oldIndex, change.newIndex);
                    break;
                case 'add':
                    change.newValues.forEach(item => toolbar.push({
                        name: item.name,
                        widget: toolbarRegistry.createWidget(factoryName, widget, item)
                    }));
                    break;
                case 'remove':
                    change.oldValues.forEach(() => toolbar.remove(change.oldIndex));
                    break;
                case 'set':
                    change.newValues.forEach(item => toolbar.set(change.newIndex, {
                        name: item.name,
                        widget: toolbarRegistry.createWidget(factoryName, widget, item)
                    }));
                    break;
            }
        };
        const updateWidget = (registry, itemName) => {
            const itemIndex = Array.from(items).findIndex(item => item.name === itemName);
            if (itemIndex >= 0) {
                toolbar.set(itemIndex, {
                    name: itemName,
                    widget: toolbarRegistry.createWidget(factoryName, widget, items.get(itemIndex))
                });
            }
        };
        const toolbar = new observables_lib_index_js_.ObservableList({
            values: Array.from(items).map(item => {
                return {
                    name: item.name,
                    widget: toolbarRegistry.createWidget(factoryName, widget, item)
                };
            })
        });
        // Re-render the widget if a new factory has been added.
        toolbarRegistry.factoryAdded.connect(updateWidget);
        items.changed.connect(updateToolbar);
        widget.disposed.connect(() => {
            items.changed.disconnect(updateToolbar);
            toolbarRegistry.factoryAdded.disconnect(updateWidget);
        });
        return toolbar;
    };
}
/**
 * Set the toolbar items of a widget from a factory
 *
 * @param widget Widget with the toolbar to set
 * @param factory Toolbar items factory
 * @param toolbar Separated toolbar if widget is a raw widget
 */
function setToolbar(widget, factory, toolbar) {
    var _a;
    // @ts-expect-error Widget has no toolbar
    if (!widget.toolbar && !toolbar) {
        console.log(`Widget ${widget.id} has no 'toolbar' and no explicit toolbar was provided.`);
        return;
    }
    // @ts-expect-error Widget has no toolbar
    const toolbar_ = (_a = widget.toolbar) !== null && _a !== void 0 ? _a : toolbar;
    const items = factory(widget);
    if (Array.isArray(items)) {
        items.forEach(({ name, widget: item }) => {
            toolbar_.addItem(name, item);
        });
    }
    else {
        const updateToolbar = (list, changes) => {
            switch (changes.type) {
                case 'add':
                    changes.newValues.forEach((item, index) => {
                        toolbar_.insertItem(changes.newIndex + index, item.name, item.widget);
                    });
                    break;
                case 'move':
                    changes.oldValues.forEach(item => {
                        item.widget.parent = null;
                    });
                    changes.newValues.forEach((item, index) => {
                        toolbar_.insertItem(changes.newIndex + index, item.name, item.widget);
                    });
                    break;
                case 'remove':
                    changes.oldValues.forEach(item => {
                        item.widget.parent = null;
                    });
                    break;
                case 'set':
                    changes.oldValues.forEach(item => {
                        item.widget.parent = null;
                    });
                    changes.newValues.forEach((item, index) => {
                        const existingIndex = (0,dist_index_es6_js_.findIndex)(toolbar_.names(), name => item.name === name);
                        if (existingIndex >= 0) {
                            Array.from(toolbar_.children())[existingIndex].parent = null;
                        }
                        toolbar_.insertItem(changes.newIndex + index, item.name, item.widget);
                    });
                    break;
            }
        };
        updateToolbar(items, {
            newIndex: 0,
            newValues: Array.from(items),
            oldIndex: 0,
            oldValues: [],
            type: 'add'
        });
        items.changed.connect(updateToolbar);
        widget.disposed.connect(() => {
            items.changed.disconnect(updateToolbar);
        });
    }
}
//# sourceMappingURL=factory.js.map
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/apputils/lib/windowresolver.js
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.

/**
 * A concrete implementation of a window name resolver.
 */
class WindowResolver {
    /**
     * The resolved window name.
     *
     * #### Notes
     * If the `resolve` promise has not resolved, the behavior is undefined.
     */
    get name() {
        return this._name;
    }
    /**
     * Resolve a window name to use as a handle among shared resources.
     *
     * @param candidate - The potential window name being resolved.
     *
     * #### Notes
     * Typically, the name candidate should be a JupyterLab workspace name or
     * an empty string if there is no workspace.
     *
     * If the returned promise rejects, a window name cannot be resolved without
     * user intervention, which typically means navigation to a new URL.
     */
    resolve(candidate) {
        return windowresolver_Private.resolve(candidate).then(name => {
            this._name = name;
        });
    }
}
/*
 * A namespace for private module data.
 */
var windowresolver_Private;
(function (Private) {
    /**
     * The internal prefix for private local storage keys.
     */
    const PREFIX = '@jupyterlab/statedb:StateDB';
    /**
     * The local storage beacon key.
     */
    const BEACON = `${PREFIX}:beacon`;
    /**
     * The timeout (in ms) to wait for beacon responders.
     *
     * #### Notes
     * This value is a whole number between 200 and 500 in order to prevent
     * perfect timeout collisions between multiple simultaneously opening windows
     * that have the same URL. This is an edge case because multiple windows
     * should not ordinarily share the same URL, but it can be contrived.
     */
    const TIMEOUT = Math.floor(200 + Math.random() * 300);
    /**
     * The local storage window key.
     */
    const WINDOW = `${PREFIX}:window`;
    /**
     * Current beacon request
     *
     * #### Notes
     * We keep track of the current request so that we can ignore our own beacon
     * requests. This is to work around a bug in Safari, where Safari sometimes
     * triggers local storage events for changes made by the current tab. See
     * https://github.com/jupyterlab/jupyterlab/issues/6921#issuecomment-540817283
     * for more details.
     */
    let currentBeaconRequest = null;
    /**
     * A potential preferred default window name.
     */
    let candidate = null;
    /**
     * The window name promise.
     */
    const delegate = new dist_index_js_.PromiseDelegate();
    /**
     * The known window names.
     */
    const known = {};
    /**
     * The window name.
     */
    let name = null;
    /**
     * Whether the name resolution has completed.
     */
    let resolved = false;
    /**
     * Start the storage event handler.
     */
    function initialize() {
        // Listen to all storage events for beacons and window names.
        window.addEventListener('storage', (event) => {
            const { key, newValue } = event;
            // All the keys we care about have values.
            if (newValue === null) {
                return;
            }
            // If the beacon was fired, respond with a ping.
            if (key === BEACON &&
                newValue !== currentBeaconRequest &&
                candidate !== null) {
                ping(resolved ? name : candidate);
                return;
            }
            // If the window name is resolved, bail.
            if (resolved || key !== WINDOW) {
                return;
            }
            const reported = newValue.replace(/\-\d+$/, '');
            // Store the reported window name.
            known[reported] = null;
            // If a reported window name and candidate collide, reject the candidate.
            if (!candidate || candidate in known) {
                reject();
            }
        });
    }
    /**
     * Ping peers with payload.
     */
    function ping(payload) {
        if (payload === null) {
            return;
        }
        const { localStorage } = window;
        localStorage.setItem(WINDOW, `${payload}-${new Date().getTime()}`);
    }
    /**
     * Reject the candidate.
     */
    function reject() {
        resolved = true;
        currentBeaconRequest = null;
        delegate.reject(`Window name candidate "${candidate}" already exists`);
    }
    /**
     * Returns a promise that resolves with the window name used for restoration.
     */
    function resolve(potential) {
        if (resolved) {
            return delegate.promise;
        }
        // Set the local candidate.
        candidate = potential;
        if (candidate in known) {
            reject();
            return delegate.promise;
        }
        const { localStorage, setTimeout } = window;
        // Wait until other windows have reported before claiming the candidate.
        setTimeout(() => {
            if (resolved) {
                return;
            }
            // If the window name has not already been resolved, check one last time
            // to confirm it is not a duplicate before resolving.
            if (!candidate || candidate in known) {
                return reject();
            }
            resolved = true;
            currentBeaconRequest = null;
            delegate.resolve((name = candidate));
            ping(name);
        }, TIMEOUT);
        // Fire the beacon to collect other windows' names.
        currentBeaconRequest = `${Math.random()}-${new Date().getTime()}`;
        localStorage.setItem(BEACON, currentBeaconRequest);
        return delegate.promise;
    }
    Private.resolve = resolve;
    // Initialize the storage listener at runtime.
    (() => {
        initialize();
    })();
})(windowresolver_Private || (windowresolver_Private = {}));
//# sourceMappingURL=windowresolver.js.map
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/apputils/lib/index.js
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
/**
 * @packageDocumentation
 * @module apputils
 */


/**
 * @deprecated since v4
 * These widgets are now in @jupyterlab/ui-components
 */






















// Merge Toolbar namespace to preserve API
/**
 * @deprecated since v4
 * This class is in @jupyterlab/ui-components
 */
class Toolbar extends index_js_.Toolbar {
}
(function (Toolbar) {
    Toolbar.createInterruptButton = widget_Toolbar.createInterruptButton;
    Toolbar.createKernelNameItem = widget_Toolbar.createKernelNameItem;
    Toolbar.createKernelStatusItem = widget_Toolbar.createKernelStatusItem;
    Toolbar.createRestartButton = widget_Toolbar.createRestartButton;
    /**
     * @deprecated since v4
     * This helper function is in @jupyterlab/ui-components
     */
    Toolbar.createSpacerItem = index_js_.Toolbar.createSpacerItem;
})(Toolbar || (Toolbar = {}));
//# sourceMappingURL=index.js.map

/***/ }),

/***/ 57261:
/***/ ((__unused_webpack_module, __unused_webpack___webpack_exports__, __webpack_require__) => {

"use strict";

// EXTERNAL MODULE: ../node_modules/@lumino/widgets/style/index.js + 1 modules
var style = __webpack_require__(20959);
// EXTERNAL MODULE: ../node_modules/@jupyterlab/ui-components/style/index.js + 1 modules
var ui_components_style = __webpack_require__(26238);
// EXTERNAL MODULE: ../node_modules/@jupyterlab/statusbar/style/index.js + 1 modules
var statusbar_style = __webpack_require__(25066);
// EXTERNAL MODULE: ../node_modules/@jupyterlab/builder/node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js
var injectStylesIntoStyleTag = __webpack_require__(94830);
var injectStylesIntoStyleTag_default = /*#__PURE__*/__webpack_require__.n(injectStylesIntoStyleTag);
// EXTERNAL MODULE: ../node_modules/@jupyterlab/builder/node_modules/style-loader/dist/runtime/styleDomAPI.js
var styleDomAPI = __webpack_require__(80592);
var styleDomAPI_default = /*#__PURE__*/__webpack_require__.n(styleDomAPI);
// EXTERNAL MODULE: ../node_modules/@jupyterlab/builder/node_modules/style-loader/dist/runtime/insertBySelector.js
var insertBySelector = __webpack_require__(99763);
var insertBySelector_default = /*#__PURE__*/__webpack_require__.n(insertBySelector);
// EXTERNAL MODULE: ../node_modules/@jupyterlab/builder/node_modules/style-loader/dist/runtime/setAttributesWithoutAttributes.js
var setAttributesWithoutAttributes = __webpack_require__(28915);
var setAttributesWithoutAttributes_default = /*#__PURE__*/__webpack_require__.n(setAttributesWithoutAttributes);
// EXTERNAL MODULE: ../node_modules/@jupyterlab/builder/node_modules/style-loader/dist/runtime/insertStyleElement.js
var insertStyleElement = __webpack_require__(80366);
var insertStyleElement_default = /*#__PURE__*/__webpack_require__.n(insertStyleElement);
// EXTERNAL MODULE: ../node_modules/@jupyterlab/builder/node_modules/style-loader/dist/runtime/styleTagTransform.js
var styleTagTransform = __webpack_require__(17352);
var styleTagTransform_default = /*#__PURE__*/__webpack_require__.n(styleTagTransform);
// EXTERNAL MODULE: ../node_modules/@jupyterlab/builder/node_modules/css-loader/dist/cjs.js!../node_modules/@jupyterlab/apputils/style/base.css
var base = __webpack_require__(11997);
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/apputils/style/base.css

      
      
      
      
      
      
      
      
      

var options = {};

options.styleTagTransform = (styleTagTransform_default());
options.setAttributes = (setAttributesWithoutAttributes_default());

      options.insert = insertBySelector_default().bind(null, "head");
    
options.domAPI = (styleDomAPI_default());
options.insertStyleElement = (insertStyleElement_default());

var update = injectStylesIntoStyleTag_default()(base/* default */.Z, options);




       /* harmony default export */ const style_base = (base/* default */.Z && base/* default */.Z.locals ? base/* default */.Z.locals : undefined);

;// CONCATENATED MODULE: ../node_modules/@jupyterlab/apputils/style/index.js
/*-----------------------------------------------------------------------------
| Copyright (c) Jupyter Development Team.
| Distributed under the terms of the Modified BSD License.
|----------------------------------------------------------------------------*/

/* This file was auto-generated by ensurePackage() in @jupyterlab/buildutils */







/***/ }),

/***/ 44042:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
// ESM COMPAT FLAG
__webpack_require__.r(__webpack_exports__);

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  AttachmentsModel: () => (/* reexport */ AttachmentsModel),
  AttachmentsResolver: () => (/* reexport */ AttachmentsResolver)
});

// EXTERNAL MODULE: consume shared module (default) @jupyterlab/observables@~5.4.5 (singleton) (fallback: ../node_modules/@jupyterlab/observables/lib/index.js)
var index_js_ = __webpack_require__(18458);
// EXTERNAL MODULE: consume shared module (default) @jupyterlab/rendermime@~4.4.5 (singleton) (fallback: ../node_modules/@jupyterlab/rendermime/lib/index.js)
var lib_index_js_ = __webpack_require__(81089);
// EXTERNAL MODULE: consume shared module (default) @lumino/signaling@~2.1.4 (singleton) (fallback: ../node_modules/@lumino/signaling/dist/index.es6.js)
var index_es6_js_ = __webpack_require__(2536);
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/attachments/lib/model.js
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.



/**
 * The default implementation of the IAttachmentsModel.
 */
class AttachmentsModel {
    /**
     * Construct a new observable outputs instance.
     */
    constructor(options) {
        var _a;
        this._map = new index_js_.ObservableMap();
        this._isDisposed = false;
        this._stateChanged = new index_es6_js_.Signal(this);
        this._changed = new index_es6_js_.Signal(this);
        this._serialized = null;
        this._changeGuard = false;
        this.contentFactory =
            (_a = options.contentFactory) !== null && _a !== void 0 ? _a : AttachmentsModel.defaultContentFactory;
        if (options.values) {
            for (const key of Object.keys(options.values)) {
                if (options.values[key] !== undefined) {
                    this.set(key, options.values[key]);
                }
            }
        }
        this._map.changed.connect(this._onMapChanged, this);
    }
    /**
     * A signal emitted when the model state changes.
     */
    get stateChanged() {
        return this._stateChanged;
    }
    /**
     * A signal emitted when the model changes.
     */
    get changed() {
        return this._changed;
    }
    /**
     * The keys of the attachments in the model.
     */
    get keys() {
        return this._map.keys();
    }
    /**
     * Get the length of the items in the model.
     */
    get length() {
        return this._map.keys().length;
    }
    /**
     * Test whether the model is disposed.
     */
    get isDisposed() {
        return this._isDisposed;
    }
    /**
     * Dispose of the resources used by the model.
     */
    dispose() {
        if (this.isDisposed) {
            return;
        }
        this._isDisposed = true;
        this._map.dispose();
        index_es6_js_.Signal.clearData(this);
    }
    /**
     * Whether the specified key is set.
     */
    has(key) {
        return this._map.has(key);
    }
    /**
     * Get an item at the specified key.
     */
    get(key) {
        return this._map.get(key);
    }
    /**
     * Set the value at the specified key.
     */
    set(key, value) {
        // Normalize stream data.
        const item = this._createItem({ value });
        this._map.set(key, item);
    }
    /**
     * Remove the attachment whose name is the specified key
     */
    remove(key) {
        this._map.delete(key);
    }
    /**
     * Clear all of the attachments.
     */
    clear() {
        this._map.values().forEach((item) => {
            item.dispose();
        });
        this._map.clear();
    }
    /**
     * Deserialize the model from JSON.
     *
     * #### Notes
     * This will clear any existing data.
     */
    fromJSON(values) {
        this.clear();
        Object.keys(values).forEach(key => {
            if (values[key] !== undefined) {
                this.set(key, values[key]);
            }
        });
    }
    /**
     * Serialize the model to JSON.
     */
    toJSON() {
        const ret = {};
        for (const key of this._map.keys()) {
            ret[key] = this._map.get(key).toJSON();
        }
        return ret;
    }
    /**
     * Create an attachment item and hook up its signals.
     */
    _createItem(options) {
        const factory = this.contentFactory;
        const item = factory.createAttachmentModel(options);
        item.changed.connect(this._onGenericChange, this);
        return item;
    }
    /**
     * Handle a change to the list.
     */
    _onMapChanged(sender, args) {
        if (this._serialized && !this._changeGuard) {
            this._changeGuard = true;
            this._serialized.set(this.toJSON());
            this._changeGuard = false;
        }
        this._changed.emit(args);
        this._stateChanged.emit(void 0);
    }
    /**
     * Handle a change to an item.
     */
    _onGenericChange() {
        this._stateChanged.emit(void 0);
    }
}
/**
 * The namespace for AttachmentsModel class statics.
 */
(function (AttachmentsModel) {
    /**
     * The default implementation of a `IAttachmentsModel.IContentFactory`.
     */
    class ContentFactory {
        /**
         * Create an attachment model.
         */
        createAttachmentModel(options) {
            return new lib_index_js_.AttachmentModel(options);
        }
    }
    AttachmentsModel.ContentFactory = ContentFactory;
    /**
     * The default attachment model factory.
     */
    AttachmentsModel.defaultContentFactory = new ContentFactory();
})(AttachmentsModel || (AttachmentsModel = {}));
/**
 * A resolver for cell attachments 'attachment:filename'.
 *
 * Will resolve to a data: url.
 */
class AttachmentsResolver {
    /**
     * Create an attachments resolver object.
     */
    constructor(options) {
        this._parent = options.parent || null;
        this._model = options.model;
    }
    /**
     * Resolve a relative url to a correct server path.
     */
    async resolveUrl(url) {
        if (this._parent && !url.startsWith('attachment:')) {
            return this._parent.resolveUrl(url);
        }
        return url;
    }
    /**
     * Get the download url of a given absolute server path.
     *
     * #### Notes
     * The returned URL may include a query parameter.
     */
    async getDownloadUrl(path) {
        if (this._parent && !path.startsWith('attachment:')) {
            return this._parent.getDownloadUrl(path);
        }
        // Return a data URL with the data of the url
        const key = path.slice('attachment:'.length);
        const attachment = this._model.get(key);
        if (attachment === undefined) {
            // Resolve with unprocessed path, to show as broken image
            return path;
        }
        const { data } = attachment;
        const mimeType = Object.keys(data)[0];
        // Only support known safe types:
        if (mimeType === undefined ||
            lib_index_js_.imageRendererFactory.mimeTypes.indexOf(mimeType) === -1) {
            throw new Error(`Cannot render unknown image mime type "${mimeType}".`);
        }
        const dataUrl = `data:${mimeType};base64,${data[mimeType]}`;
        return dataUrl;
    }
    /**
     * Whether the URL should be handled by the resolver
     * or not.
     */
    isLocal(url) {
        var _a, _b, _c;
        if (this._parent && !url.startsWith('attachment:')) {
            return (_c = (_b = (_a = this._parent).isLocal) === null || _b === void 0 ? void 0 : _b.call(_a, url)) !== null && _c !== void 0 ? _c : true;
        }
        return true;
    }
}
//# sourceMappingURL=model.js.map
;// CONCATENATED MODULE: ../node_modules/@jupyterlab/attachments/lib/index.js
/* -----------------------------------------------------------------------------
| Copyright (c) Jupyter Development Team.
| Distributed under the terms of the Modified BSD License.
|----------------------------------------------------------------------------*/
/**
 * @packageDocumentation
 * @module attachments
 */

//# sourceMappingURL=index.js.map

/***/ }),

/***/ 6347:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Z: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(82971);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(11368);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
// Imports


var ___CSS_LOADER_EXPORT___ = _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default()));
// Module
___CSS_LOADER_EXPORT___.push([module.id, `/*-----------------------------------------------------------------------------
| Copyright (c) Jupyter Development Team.
|
| Distributed under the terms of the Modified BSD License.
|----------------------------------------------------------------------------*/

#jp-MainLogo {
  width: calc(var(--jp-private-sidebar-tab-width) + var(--jp-border-width));
}

#jp-top-bar {
  --jp-private-toolbar-height: var(--jp-private-menu-panel-height);

  flex: 1 1 auto;
  padding: 0 2px;
  box-shadow: none;
  border: none;
  align-items: center;
}
`, "",{"version":3,"sources":["webpack://./../node_modules/@jupyterlab/application-extension/style/base.css"],"names":[],"mappings":"AAAA;;;;8EAI8E;;AAE9E;EACE,yEAAyE;AAC3E;;AAEA;EACE,gEAAgE;;EAEhE,cAAc;EACd,cAAc;EACd,gBAAgB;EAChB,YAAY;EACZ,mBAAmB;AACrB","sourcesContent":["/*-----------------------------------------------------------------------------\n| Copyright (c) Jupyter Development Team.\n|\n| Distributed under the terms of the Modified BSD License.\n|----------------------------------------------------------------------------*/\n\n#jp-MainLogo {\n  width: calc(var(--jp-private-sidebar-tab-width) + var(--jp-border-width));\n}\n\n#jp-top-bar {\n  --jp-private-toolbar-height: var(--jp-private-menu-panel-height);\n\n  flex: 1 1 auto;\n  padding: 0 2px;\n  box-shadow: none;\n  border: none;\n  align-items: center;\n}\n"],"sourceRoot":""}]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ 82119:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Z: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(82971);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(11368);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _builder_node_modules_css_loader_dist_cjs_js_core_css__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(71852);
/* harmony import */ var _builder_node_modules_css_loader_dist_cjs_js_datagrid_css__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(77893);
/* harmony import */ var _builder_node_modules_css_loader_dist_cjs_js_dockpanel_css__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(19792);
/* harmony import */ var _builder_node_modules_css_loader_dist_cjs_js_menus_css__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(15760);
/* harmony import */ var _builder_node_modules_css_loader_dist_cjs_js_scrollbar_css__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(2452);
/* harmony import */ var _builder_node_modules_css_loader_dist_cjs_js_tabs_css__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(21171);
/* harmony import */ var _builder_node_modules_css_loader_dist_cjs_js_buttons_css__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(40313);
/* harmony import */ var _builder_node_modules_css_loader_dist_cjs_js_sidepanel_css__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(71728);
/* harmony import */ var _builder_node_modules_css_loader_dist_cjs_js_titlepanel_css__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(61059);
/* harmony import */ var _builder_node_modules_css_loader_dist_cjs_js_skiplink_css__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(17285);
// Imports












var ___CSS_LOADER_EXPORT___ = _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default()));
___CSS_LOADER_EXPORT___.i(_builder_node_modules_css_loader_dist_cjs_js_core_css__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z);
___CSS_LOADER_EXPORT___.i(_builder_node_modules_css_loader_dist_cjs_js_datagrid_css__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z);
___CSS_LOADER_EXPORT___.i(_builder_node_modules_css_loader_dist_cjs_js_dockpanel_css__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z);
___CSS_LOADER_EXPORT___.i(_builder_node_modules_css_loader_dist_cjs_js_menus_css__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z);
___CSS_LOADER_EXPORT___.i(_builder_node_modules_css_loader_dist_cjs_js_scrollbar_css__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .Z);
___CSS_LOADER_EXPORT___.i(_builder_node_modules_css_loader_dist_cjs_js_tabs_css__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .Z);
___CSS_LOADER_EXPORT___.i(_builder_node_modules_css_loader_dist_cjs_js_buttons_css__WEBPACK_IMPORTED_MODULE_8__/* ["default"] */ .Z);
___CSS_LOADER_EXPORT___.i(_builder_node_modules_css_loader_dist_cjs_js_sidepanel_css__WEBPACK_IMPORTED_MODULE_9__/* ["default"] */ .Z);
___CSS_LOADER_EXPORT___.i(_builder_node_modules_css_loader_dist_cjs_js_titlepanel_css__WEBPACK_IMPORTED_MODULE_10__/* ["default"] */ .Z);
___CSS_LOADER_EXPORT___.i(_builder_node_modules_css_loader_dist_cjs_js_skiplink_css__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .Z);
// Module
___CSS_LOADER_EXPORT___.push([module.id, `/*-----------------------------------------------------------------------------
| Copyright (c) Jupyter Development Team.
| Distributed under the terms of the Modified BSD License.
|----------------------------------------------------------------------------*/

/* Sibling imports */
`, "",{"version":3,"sources":["webpack://./../node_modules/@jupyterlab/application/style/base.css"],"names":[],"mappings":"AAAA;;;8EAG8E;;AAE9E,oBAAoB","sourcesContent":["/*-----------------------------------------------------------------------------\n| Copyright (c) Jupyter Development Team.\n| Distributed under the terms of the Modified BSD License.\n|----------------------------------------------------------------------------*/\n\n/* Sibling imports */\n@import './core.css';\n@import './datagrid.css';\n@import './dockpanel.css';\n@import './menus.css';\n@import './scrollbar.css';\n@import './tabs.css';\n@import './buttons.css';\n@import './sidepanel.css';\n@import './titlepanel.css';\n@import './skiplink.css';\n"],"sourceRoot":""}]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ 40313:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Z: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(82971);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(11368);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
// Imports


var ___CSS_LOADER_EXPORT___ = _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default()));
// Module
___CSS_LOADER_EXPORT___.push([module.id, `/*
 * Copyright (c) Jupyter Development Team.
 * Distributed under the terms of the Modified BSD License.
 */

/*-----------------------------------------------------------------------------
| Variables
|----------------------------------------------------------------------------*/

:root {
  --jp-flat-button-height: 24px;
  --jp-flat-button-padding: 8px 12px;
}

/*-----------------------------------------------------------------------------
| Copyright (c) Jupyter Development Team.
| Distributed under the terms of the Modified BSD License.
|----------------------------------------------------------------------------*/

.jp-ThemedContainer button {
  border-radius: var(--jp-border-radius);
}

.jp-ThemedContainer button:focus-visible {
  outline: 1px solid var(--jp-accept-color-active, var(--jp-brand-color1));
  outline-offset: -1px;
}

button.jp-mod-styled.jp-mod-accept {
  background: var(--jp-accept-color-normal, var(--md-blue-500, #2196f3));
  border: 0;
  color: white;
}

button.jp-mod-styled.jp-mod-accept:hover {
  background: var(--jp-accept-color-hover, var(--md-blue-600, #1e88e5));
}

button.jp-mod-styled.jp-mod-accept:active {
  background: var(--jp-accept-color-active, var(--md-blue-700, #1976d2));
}

button.jp-mod-styled.jp-mod-accept:focus-visible {
  outline: 1px solid var(--jp-accept-color-active, var(--jp-brand-color1));
}

button.jp-mod-styled.jp-mod-reject {
  background: var(--jp-reject-color-normal, var(--md-grey-500, #9e9e9e));
  border: 0;
  color: white;
}

button.jp-mod-styled.jp-mod-reject:hover {
  background: var(--jp-reject-color-hover, var(--md-grey-600, #757575));
}

button.jp-mod-styled.jp-mod-reject:active {
  background: var(--jp-reject-color-active, var(--md-grey-700, #616161));
}

button.jp-mod-styled.jp-mod-reject:focus-visible {
  outline: 1px solid var(--jp-reject-color-active, var(--md-grey-700, #616161));
}

button.jp-mod-styled.jp-mod-warn {
  background: var(--jp-warn-color-normal, var(--jp-error-color1));
  border: 0;
  color: white;
}

button.jp-mod-styled.jp-mod-warn:hover {
  background: var(--jp-warn-color-hover, var(--md-red-600, #e53935));
}

button.jp-mod-styled.jp-mod-warn:active {
  background: var(--jp-warn-color-active, var(--md-red-700, #d32f2f));
}

button.jp-mod-styled.jp-mod-warn:focus-visible {
  outline: 1px solid var(--jp-warn-color-active, var(--md-red-700, #d32f2f));
}

.jp-Button-flat {
  text-decoration: none;
  padding: var(--jp-flat-button-padding);
  font-weight: 500;
  background-color: transparent;
  height: var(--jp-private-running-shutdown-button-height);
  line-height: var(--jp-private-running-shutdown-button-height);
  transition: background-color 0.1s ease;
  border-radius: 2px;
}

.jp-Button-flat:focus {
  border: none;
  box-shadow: none;
}
`, "",{"version":3,"sources":["webpack://./../node_modules/@jupyterlab/application/style/buttons.css"],"names":[],"mappings":"AAAA;;;EAGE;;AAEF;;8EAE8E;;AAE9E;EACE,6BAA6B;EAC7B,kCAAkC;AACpC;;AAEA;;;8EAG8E;;AAE9E;EACE,sCAAsC;AACxC;;AAEA;EACE,wEAAwE;EACxE,oBAAoB;AACtB;;AAEA;EACE,sEAAsE;EACtE,SAAS;EACT,YAAY;AACd;;AAEA;EACE,qEAAqE;AACvE;;AAEA;EACE,sEAAsE;AACxE;;AAEA;EACE,wEAAwE;AAC1E;;AAEA;EACE,sEAAsE;EACtE,SAAS;EACT,YAAY;AACd;;AAEA;EACE,qEAAqE;AACvE;;AAEA;EACE,sEAAsE;AACxE;;AAEA;EACE,6EAA6E;AAC/E;;AAEA;EACE,+DAA+D;EAC/D,SAAS;EACT,YAAY;AACd;;AAEA;EACE,kEAAkE;AACpE;;AAEA;EACE,mEAAmE;AACrE;;AAEA;EACE,0EAA0E;AAC5E;;AAEA;EACE,qBAAqB;EACrB,sCAAsC;EACtC,gBAAgB;EAChB,6BAA6B;EAC7B,wDAAwD;EACxD,6DAA6D;EAC7D,sCAAsC;EACtC,kBAAkB;AACpB;;AAEA;EACE,YAAY;EACZ,gBAAgB;AAClB","sourcesContent":["/*\n * Copyright (c) Jupyter Development Team.\n * Distributed under the terms of the Modified BSD License.\n */\n\n/*-----------------------------------------------------------------------------\n| Variables\n|----------------------------------------------------------------------------*/\n\n:root {\n  --jp-flat-button-height: 24px;\n  --jp-flat-button-padding: 8px 12px;\n}\n\n/*-----------------------------------------------------------------------------\n| Copyright (c) Jupyter Development Team.\n| Distributed under the terms of the Modified BSD License.\n|----------------------------------------------------------------------------*/\n\n.jp-ThemedContainer button {\n  border-radius: var(--jp-border-radius);\n}\n\n.jp-ThemedContainer button:focus-visible {\n  outline: 1px solid var(--jp-accept-color-active, var(--jp-brand-color1));\n  outline-offset: -1px;\n}\n\nbutton.jp-mod-styled.jp-mod-accept {\n  background: var(--jp-accept-color-normal, var(--md-blue-500, #2196f3));\n  border: 0;\n  color: white;\n}\n\nbutton.jp-mod-styled.jp-mod-accept:hover {\n  background: var(--jp-accept-color-hover, var(--md-blue-600, #1e88e5));\n}\n\nbutton.jp-mod-styled.jp-mod-accept:active {\n  background: var(--jp-accept-color-active, var(--md-blue-700, #1976d2));\n}\n\nbutton.jp-mod-styled.jp-mod-accept:focus-visible {\n  outline: 1px solid var(--jp-accept-color-active, var(--jp-brand-color1));\n}\n\nbutton.jp-mod-styled.jp-mod-reject {\n  background: var(--jp-reject-color-normal, var(--md-grey-500, #9e9e9e));\n  border: 0;\n  color: white;\n}\n\nbutton.jp-mod-styled.jp-mod-reject:hover {\n  background: var(--jp-reject-color-hover, var(--md-grey-600, #757575));\n}\n\nbutton.jp-mod-styled.jp-mod-reject:active {\n  background: var(--jp-reject-color-active, var(--md-grey-700, #616161));\n}\n\nbutton.jp-mod-styled.jp-mod-reject:focus-visible {\n  outline: 1px solid var(--jp-reject-color-active, var(--md-grey-700, #616161));\n}\n\nbutton.jp-mod-styled.jp-mod-warn {\n  background: var(--jp-warn-color-normal, var(--jp-error-color1));\n  border: 0;\n  color: white;\n}\n\nbutton.jp-mod-styled.jp-mod-warn:hover {\n  background: var(--jp-warn-color-hover, var(--md-red-600, #e53935));\n}\n\nbutton.jp-mod-styled.jp-mod-warn:active {\n  background: var(--jp-warn-color-active, var(--md-red-700, #d32f2f));\n}\n\nbutton.jp-mod-styled.jp-mod-warn:focus-visible {\n  outline: 1px solid var(--jp-warn-color-active, var(--md-red-700, #d32f2f));\n}\n\n.jp-Button-flat {\n  text-decoration: none;\n  padding: var(--jp-flat-button-padding);\n  font-weight: 500;\n  background-color: transparent;\n  height: var(--jp-private-running-shutdown-button-height);\n  line-height: var(--jp-private-running-shutdown-button-height);\n  transition: background-color 0.1s ease;\n  border-radius: 2px;\n}\n\n.jp-Button-flat:focus {\n  border: none;\n  box-shadow: none;\n}\n"],"sourceRoot":""}]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ 71852:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Z: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(82971);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(11368);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
// Imports


var ___CSS_LOADER_EXPORT___ = _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default()));
// Module
___CSS_LOADER_EXPORT___.push([module.id, `/*-----------------------------------------------------------------------------
| Copyright (c) Jupyter Development Team.
| Distributed under the terms of the Modified BSD License.
|----------------------------------------------------------------------------*/

:root {
  --jp-private-menu-panel-height: 27px;
}

.lm-Widget.lm-mod-hidden {
  display: none !important;
}

.jp-ThemedContainer {
  font-family: var(--jp-ui-font-family);
  background: var(--jp-layout-color3);
  margin: 0;
  padding: 0;
  overflow: hidden;
}

.jp-LabShell {
  position: absolute;
  top: 0;
  left: 0;
  right: 0;
  bottom: 0;
}

.jp-LabShell.jp-mod-devMode {
  border-top: 4px solid red;
}

#jp-main-dock-panel {
  padding: 5px;
}

#jp-main-dock-panel[data-mode='single-document'] {
  padding: 0;
}

#jp-main-dock-panel[data-mode='single-document'] .jp-MainAreaWidget {
  border: none;
}

#jp-top-panel {
  border-bottom: var(--jp-border-width) solid var(--jp-border-color0);
  background: var(--jp-layout-color1);
  display: flex;
  min-height: var(--jp-private-menubar-height);
  overflow: visible;

  /* relax lumino strict CSS contaiment to allow painting the menu bar item
  over the menu in order to create an illusion of partial border */
  contain: style size !important;
}

#jp-menu-panel {
  min-height: var(--jp-private-menu-panel-height);
  background: var(--jp-layout-color1);
}

#jp-down-stack {
  border-bottom: var(--jp-border-width) solid var(--jp-border-color1);
}

.jp-LabShell[data-shell-mode='single-document'] #jp-top-panel {
  border-bottom: none;
}

.jp-LabShell[data-shell-mode='single-document'] #jp-menu-panel {
  padding-left: calc(
    var(--jp-private-sidebar-tab-width) + var(--jp-border-width)
  );
  border-bottom: var(--jp-border-width) solid var(--jp-border-color0);

  /* Adjust min-height so open menus show up in the right place */
  min-height: calc(
    var(--jp-private-menu-panel-height) + var(--jp-border-width)
  );
}

#jp-bottom-panel {
  background: var(--jp-layout-color1);
  display: flex;
}

#jp-single-document-mode {
  margin: 0 8px;
  display: flex;
  align-items: center;
}
`, "",{"version":3,"sources":["webpack://./../node_modules/@jupyterlab/application/style/core.css"],"names":[],"mappings":"AAAA;;;8EAG8E;;AAE9E;EACE,oCAAoC;AACtC;;AAEA;EACE,wBAAwB;AAC1B;;AAEA;EACE,qCAAqC;EACrC,mCAAmC;EACnC,SAAS;EACT,UAAU;EACV,gBAAgB;AAClB;;AAEA;EACE,kBAAkB;EAClB,MAAM;EACN,OAAO;EACP,QAAQ;EACR,SAAS;AACX;;AAEA;EACE,yBAAyB;AAC3B;;AAEA;EACE,YAAY;AACd;;AAEA;EACE,UAAU;AACZ;;AAEA;EACE,YAAY;AACd;;AAEA;EACE,mEAAmE;EACnE,mCAAmC;EACnC,aAAa;EACb,4CAA4C;EAC5C,iBAAiB;;EAEjB;kEACgE;EAChE,8BAA8B;AAChC;;AAEA;EACE,+CAA+C;EAC/C,mCAAmC;AACrC;;AAEA;EACE,mEAAmE;AACrE;;AAEA;EACE,mBAAmB;AACrB;;AAEA;EACE;;GAEC;EACD,mEAAmE;;EAEnE,+DAA+D;EAC/D;;GAEC;AACH;;AAEA;EACE,mCAAmC;EACnC,aAAa;AACf;;AAEA;EACE,aAAa;EACb,aAAa;EACb,mBAAmB;AACrB","sourcesContent":["/*-----------------------------------------------------------------------------\n| Copyright (c) Jupyter Development Team.\n| Distributed under the terms of the Modified BSD License.\n|----------------------------------------------------------------------------*/\n\n:root {\n  --jp-private-menu-panel-height: 27px;\n}\n\n.lm-Widget.lm-mod-hidden {\n  display: none !important;\n}\n\n.jp-ThemedContainer {\n  font-family: var(--jp-ui-font-family);\n  background: var(--jp-layout-color3);\n  margin: 0;\n  padding: 0;\n  overflow: hidden;\n}\n\n.jp-LabShell {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n}\n\n.jp-LabShell.jp-mod-devMode {\n  border-top: 4px solid red;\n}\n\n#jp-main-dock-panel {\n  padding: 5px;\n}\n\n#jp-main-dock-panel[data-mode='single-document'] {\n  padding: 0;\n}\n\n#jp-main-dock-panel[data-mode='single-document'] .jp-MainAreaWidget {\n  border: none;\n}\n\n#jp-top-panel {\n  border-bottom: var(--jp-border-width) solid var(--jp-border-color0);\n  background: var(--jp-layout-color1);\n  display: flex;\n  min-height: var(--jp-private-menubar-height);\n  overflow: visible;\n\n  /* relax lumino strict CSS contaiment to allow painting the menu bar item\n  over the menu in order to create an illusion of partial border */\n  contain: style size !important;\n}\n\n#jp-menu-panel {\n  min-height: var(--jp-private-menu-panel-height);\n  background: var(--jp-layout-color1);\n}\n\n#jp-down-stack {\n  border-bottom: var(--jp-border-width) solid var(--jp-border-color1);\n}\n\n.jp-LabShell[data-shell-mode='single-document'] #jp-top-panel {\n  border-bottom: none;\n}\n\n.jp-LabShell[data-shell-mode='single-document'] #jp-menu-panel {\n  padding-left: calc(\n    var(--jp-private-sidebar-tab-width) + var(--jp-border-width)\n  );\n  border-bottom: var(--jp-border-width) solid var(--jp-border-color0);\n\n  /* Adjust min-height so open menus show up in the right place */\n  min-height: calc(\n    var(--jp-private-menu-panel-height) + var(--jp-border-width)\n  );\n}\n\n#jp-bottom-panel {\n  background: var(--jp-layout-color1);\n  display: flex;\n}\n\n#jp-single-document-mode {\n  margin: 0 8px;\n  display: flex;\n  align-items: center;\n}\n"],"sourceRoot":""}]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ 77893:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Z: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(82971);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(11368);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
// Imports


var ___CSS_LOADER_EXPORT___ = _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default()));
// Module
___CSS_LOADER_EXPORT___.push([module.id, `/*-----------------------------------------------------------------------------
| Copyright (c) Jupyter Development Team.
| Distributed under the terms of the Modified BSD License.
|----------------------------------------------------------------------------*/

.lm-DataGrid {
  min-width: 64px;
  min-height: 64px;
  border: 1px solid #a0a0a0;
}

.lm-DataGrid-scrollCorner {
  background-color: #f0f0f0;
}

.lm-DataGrid-scrollCorner::after {
  content: '';
  position: absolute;
  top: 0;
  left: 0;
  width: 1px;
  height: 1px;
  background-color: #a0a0a0;
}
`, "",{"version":3,"sources":["webpack://./../node_modules/@jupyterlab/application/style/datagrid.css"],"names":[],"mappings":"AAAA;;;8EAG8E;;AAE9E;EACE,eAAe;EACf,gBAAgB;EAChB,yBAAyB;AAC3B;;AAEA;EACE,yBAAyB;AAC3B;;AAEA;EACE,WAAW;EACX,kBAAkB;EAClB,MAAM;EACN,OAAO;EACP,UAAU;EACV,WAAW;EACX,yBAAyB;AAC3B","sourcesContent":["/*-----------------------------------------------------------------------------\n| Copyright (c) Jupyter Development Team.\n| Distributed under the terms of the Modified BSD License.\n|----------------------------------------------------------------------------*/\n\n.lm-DataGrid {\n  min-width: 64px;\n  min-height: 64px;\n  border: 1px solid #a0a0a0;\n}\n\n.lm-DataGrid-scrollCorner {\n  background-color: #f0f0f0;\n}\n\n.lm-DataGrid-scrollCorner::after {\n  content: '';\n  position: absolute;\n  top: 0;\n  left: 0;\n  width: 1px;\n  height: 1px;\n  background-color: #a0a0a0;\n}\n"],"sourceRoot":""}]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ 19792:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Z: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(82971);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(11368);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
// Imports


var ___CSS_LOADER_EXPORT___ = _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default()));
// Module
___CSS_LOADER_EXPORT___.push([module.id, `/*-----------------------------------------------------------------------------
| Copyright (c) Jupyter Development Team.
| Distributed under the terms of the Modified BSD License.
|----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------
| Variables
|----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------
| DockPanel
|----------------------------------------------------------------------------*/

.lm-DockPanel-widget,
.lm-TabPanel-stackedPanel {
  background: var(--jp-layout-color0);
  border-left: var(--jp-border-width) solid var(--jp-border-color1);
  border-right: var(--jp-border-width) solid var(--jp-border-color1);
  border-bottom: var(--jp-border-width) solid var(--jp-border-color1);
}

.lm-DockPanel-overlay {
  background: rgba(33, 150, 243, 0.1);
  border: var(--jp-border-width) dashed var(--jp-brand-color1);
  transition-property: top, left, right, bottom;
  transition-duration: 150ms;
  transition-timing-function: ease;
}

.lm-DockPanel-overlay.lm-mod-root-top,
.lm-DockPanel-overlay.lm-mod-root-left,
.lm-DockPanel-overlay.lm-mod-root-right,
.lm-DockPanel-overlay.lm-mod-root-bottom,
.lm-DockPanel-overlay.lm-mod-root-center {
  border-width: 2px;
}
`, "",{"version":3,"sources":["webpack://./../node_modules/@jupyterlab/application/style/dockpanel.css"],"names":[],"mappings":"AAAA;;;8EAG8E;;AAE9E;;8EAE8E;;AAE9E;;8EAE8E;;AAE9E;;EAEE,mCAAmC;EACnC,iEAAiE;EACjE,kEAAkE;EAClE,mEAAmE;AACrE;;AAEA;EACE,mCAAmC;EACnC,4DAA4D;EAC5D,6CAA6C;EAC7C,0BAA0B;EAC1B,gCAAgC;AAClC;;AAEA;;;;;EAKE,iBAAiB;AACnB","sourcesContent":["/*-----------------------------------------------------------------------------\n| Copyright (c) Jupyter Development Team.\n| Distributed under the terms of the Modified BSD License.\n|----------------------------------------------------------------------------*/\n\n/*-----------------------------------------------------------------------------\n| Variables\n|----------------------------------------------------------------------------*/\n\n/*-----------------------------------------------------------------------------\n| DockPanel\n|----------------------------------------------------------------------------*/\n\n.lm-DockPanel-widget,\n.lm-TabPanel-stackedPanel {\n  background: var(--jp-layout-color0);\n  border-left: var(--jp-border-width) solid var(--jp-border-color1);\n  border-right: var(--jp-border-width) solid var(--jp-border-color1);\n  border-bottom: var(--jp-border-width) solid var(--jp-border-color1);\n}\n\n.lm-DockPanel-overlay {\n  background: rgba(33, 150, 243, 0.1);\n  border: var(--jp-border-width) dashed var(--jp-brand-color1);\n  transition-property: top, left, right, bottom;\n  transition-duration: 150ms;\n  transition-timing-function: ease;\n}\n\n.lm-DockPanel-overlay.lm-mod-root-top,\n.lm-DockPanel-overlay.lm-mod-root-left,\n.lm-DockPanel-overlay.lm-mod-root-right,\n.lm-DockPanel-overlay.lm-mod-root-bottom,\n.lm-DockPanel-overlay.lm-mod-root-center {\n  border-width: 2px;\n}\n"],"sourceRoot":""}]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ 15760:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Z: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(82971);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(11368);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
// Imports


var ___CSS_LOADER_EXPORT___ = _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default()));
// Module
___CSS_LOADER_EXPORT___.push([module.id, `/*-----------------------------------------------------------------------------
| Copyright (c) Jupyter Development Team.
| Distributed under the terms of the Modified BSD License.
|----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------
| Variables
|----------------------------------------------------------------------------*/

:root {
  --jp-private-menubar-height: 28px;
  --jp-private-menu-item-height: 24px;
}

/*-----------------------------------------------------------------------------
| MenuBar
|----------------------------------------------------------------------------*/

.lm-MenuBar {
  background: var(--jp-layout-color1);
  color: var(--jp-ui-font-color1);
  font-size: var(--jp-ui-font-size1);
  overflow: hidden;
}

.lm-MenuBar:hover {
  overflow-x: auto;
}

.lm-MenuBar-menu.jp-ThemedContainer {
  top: calc(-2 * var(--jp-border-width));
  scrollbar-width: none;
  -ms-overflow-style: none;
  overflow: auto;
  background:
    linear-gradient(var(--jp-layout-color0) 30%, rgba(0, 0, 0, 0)) center top,
    linear-gradient(rgba(0, 0, 0, 0), var(--jp-layout-color0) 70%) center bottom,
    radial-gradient(
        farthest-side at 50% 0,
        color-mix(
          in hsl,
          var(--jp-layout-color0) 50%,
          var(--jp-inverse-layout-color0) 30%
        ),
        rgba(0, 0, 0, 0)
      )
      center top,
    radial-gradient(
        farthest-side at 50% 100%,
        color-mix(
          in hsl,
          var(--jp-layout-color0) 50%,
          var(--jp-inverse-layout-color0) 30%
        ),
        rgba(0, 0, 0, 0)
      )
      center bottom;
  background-color: var(--jp-layout-color0);
  background-repeat: no-repeat;
  background-size:
    100% 40px,
    100% 40px,
    100% 14px,
    100% 14px;
  background-attachment: local, local, scroll, scroll;
}

.lm-MenuBar-menu.jp-ThemedContainer::-webkit-scrollbar {
  display: none;
}

.lm-MenuBar-item {
  padding: 0 8px;
  border-left: var(--jp-border-width) solid transparent;
  border-right: var(--jp-border-width) solid transparent;
  border-top: var(--jp-border-width) solid transparent;
  line-height: calc(
    var(--jp-private-menubar-height) - var(--jp-border-width) * 2
  );
}

.lm-MenuBar-content:focus-visible {
  outline-offset: -3px; /* this value is a compromise between Firefox, Chrome,
    and Safari over this outline's visibility and discretion */
}

.lm-MenuBar:focus-visible {
  outline: 1px solid var(--jp-accept-color-active, var(--jp-brand-color1));
  outline-offset: -1px;
}

.lm-MenuBar-menu:focus-visible,
.lm-MenuBar-item:focus-visible,
.lm-Menu-item:focus-visible {
  outline: unset;
  outline-offset: unset;
  -moz-outline-radius: unset;
}

.lm-MenuBar-item.lm-mod-active {
  background: var(--jp-layout-color2);
}

.lm-MenuBar.lm-mod-active .lm-MenuBar-item.lm-mod-active {
  z-index: 10001;
  background: var(--jp-layout-color0);
  color: var(--jp-ui-font-color0);
  border-left: var(--jp-border-width) solid var(--jp-border-color1);
  border-right: var(--jp-border-width) solid var(--jp-border-color1);
  box-shadow: var(--jp-elevation-z6);
}

/* stylelint-disable-next-line selector-max-class */
.jp-LabShell[data-shell-mode='single-document']
  .lm-MenuBar.lm-mod-active
  .lm-MenuBar-item.lm-mod-active {
  border-top: var(--jp-border-width) solid var(--jp-border-color1);
}

.lm-MenuBar-item.lm-mod-disabled {
  color: var(--jp-ui-font-color3);
}

.lm-MenuBar-item.lm-type-separator {
  margin: 2px;
  padding: 0;
  border: none;
  border-left: var(--jp-border-width) solid var(--jp-border-color2);
}

.lm-MenuBar-itemMnemonic {
  text-decoration: underline;
}

/*-----------------------------------------------------------------------------
| Menu
|----------------------------------------------------------------------------*/

.lm-Menu {
  z-index: 10000;
  padding: 4px 0;
  background: var(--jp-layout-color0);
  color: var(--jp-ui-font-color0);
  border: var(--jp-border-width) solid var(--jp-border-color1);
  font-size: var(--jp-ui-font-size1);
  box-shadow: var(--jp-elevation-z6);
}

.lm-Menu-item {
  min-height: var(--jp-private-menu-item-height);
  max-height: var(--jp-private-menu-item-height);
  padding: 0;
  line-height: var(--jp-private-menu-item-height);
}

.lm-Menu-item.lm-mod-active {
  background: var(--jp-layout-color2);
}

.lm-Menu-item.lm-mod-disabled {
  color: var(--jp-ui-font-color3);
}

.lm-Menu-itemIcon {
  width: 21px;
  padding: 0 2px 0 4px;
  margin-top: -2px;
}

.lm-Menu-itemLabel {
  padding: 0 32px 0 2px;
}

.lm-Menu-itemMnemonic {
  text-decoration: underline;
}

.lm-Menu-itemShortcut {
  padding: 0;
}

.lm-Menu-itemSubmenuIcon {
  width: 18px;
  padding: 0 4px 0 0;
}

.lm-Menu-item[data-type='separator'] > div {
  padding: 0;
  height: 9px;
}

.lm-Menu-item[data-type='separator'] > div::after {
  content: '';
  display: block;
  position: relative;
  top: 4px;
  border-top: var(--jp-border-width) solid var(--jp-layout-color2);
  mix-blend-mode: multiply;
}

/* gray out icon/caret for disabled menu items */
.lm-Menu-item.lm-mod-disabled > .lm-Menu-itemIcon,
.lm-Menu-item[data-type='submenu'].lm-mod-disabled > .lm-Menu-itemSubmenuIcon {
  opacity: 0.4;
}
`, "",{"version":3,"sources":["webpack://./../node_modules/@jupyterlab/application/style/menus.css"],"names":[],"mappings":"AAAA;;;8EAG8E;;AAE9E;;8EAE8E;;AAE9E;EACE,iCAAiC;EACjC,mCAAmC;AACrC;;AAEA;;8EAE8E;;AAE9E;EACE,mCAAmC;EACnC,+BAA+B;EAC/B,kCAAkC;EAClC,gBAAgB;AAClB;;AAEA;EACE,gBAAgB;AAClB;;AAEA;EACE,sCAAsC;EACtC,qBAAqB;EACrB,wBAAwB;EACxB,cAAc;EACd;;;;;;;;;;;;;;;;;;;;;;mBAsBiB;EACjB,yCAAyC;EACzC,4BAA4B;EAC5B;;;;aAIW;EACX,mDAAmD;AACrD;;AAEA;EACE,aAAa;AACf;;AAEA;EACE,cAAc;EACd,qDAAqD;EACrD,sDAAsD;EACtD,oDAAoD;EACpD;;GAEC;AACH;;AAEA;EACE,oBAAoB,EAAE;8DACsC;AAC9D;;AAEA;EACE,wEAAwE;EACxE,oBAAoB;AACtB;;AAEA;;;EAGE,cAAc;EACd,qBAAqB;EACrB,0BAA0B;AAC5B;;AAEA;EACE,mCAAmC;AACrC;;AAEA;EACE,cAAc;EACd,mCAAmC;EACnC,+BAA+B;EAC/B,iEAAiE;EACjE,kEAAkE;EAClE,kCAAkC;AACpC;;AAEA,mDAAmD;AACnD;;;EAGE,gEAAgE;AAClE;;AAEA;EACE,+BAA+B;AACjC;;AAEA;EACE,WAAW;EACX,UAAU;EACV,YAAY;EACZ,iEAAiE;AACnE;;AAEA;EACE,0BAA0B;AAC5B;;AAEA;;8EAE8E;;AAE9E;EACE,cAAc;EACd,cAAc;EACd,mCAAmC;EACnC,+BAA+B;EAC/B,4DAA4D;EAC5D,kCAAkC;EAClC,kCAAkC;AACpC;;AAEA;EACE,8CAA8C;EAC9C,8CAA8C;EAC9C,UAAU;EACV,+CAA+C;AACjD;;AAEA;EACE,mCAAmC;AACrC;;AAEA;EACE,+BAA+B;AACjC;;AAEA;EACE,WAAW;EACX,oBAAoB;EACpB,gBAAgB;AAClB;;AAEA;EACE,qBAAqB;AACvB;;AAEA;EACE,0BAA0B;AAC5B;;AAEA;EACE,UAAU;AACZ;;AAEA;EACE,WAAW;EACX,kBAAkB;AACpB;;AAEA;EACE,UAAU;EACV,WAAW;AACb;;AAEA;EACE,WAAW;EACX,cAAc;EACd,kBAAkB;EAClB,QAAQ;EACR,gEAAgE;EAChE,wBAAwB;AAC1B;;AAEA,gDAAgD;AAChD;;EAEE,YAAY;AACd","sourcesContent":["/*-----------------------------------------------------------------------------\n| Copyright (c) Jupyter Development Team.\n| Distributed under the terms of the Modified BSD License.\n|----------------------------------------------------------------------------*/\n\n/*-----------------------------------------------------------------------------\n| Variables\n|----------------------------------------------------------------------------*/\n\n:root {\n  --jp-private-menubar-height: 28px;\n  --jp-private-menu-item-height: 24px;\n}\n\n/*-----------------------------------------------------------------------------\n| MenuBar\n|----------------------------------------------------------------------------*/\n\n.lm-MenuBar {\n  background: var(--jp-layout-color1);\n  color: var(--jp-ui-font-color1);\n  font-size: var(--jp-ui-font-size1);\n  overflow: hidden;\n}\n\n.lm-MenuBar:hover {\n  overflow-x: auto;\n}\n\n.lm-MenuBar-menu.jp-ThemedContainer {\n  top: calc(-2 * var(--jp-border-width));\n  scrollbar-width: none;\n  -ms-overflow-style: none;\n  overflow: auto;\n  background:\n    linear-gradient(var(--jp-layout-color0) 30%, rgba(0, 0, 0, 0)) center top,\n    linear-gradient(rgba(0, 0, 0, 0), var(--jp-layout-color0) 70%) center bottom,\n    radial-gradient(\n        farthest-side at 50% 0,\n        color-mix(\n          in hsl,\n          var(--jp-layout-color0) 50%,\n          var(--jp-inverse-layout-color0) 30%\n        ),\n        rgba(0, 0, 0, 0)\n      )\n      center top,\n    radial-gradient(\n        farthest-side at 50% 100%,\n        color-mix(\n          in hsl,\n          var(--jp-layout-color0) 50%,\n          var(--jp-inverse-layout-color0) 30%\n        ),\n        rgba(0, 0, 0, 0)\n      )\n      center bottom;\n  background-color: var(--jp-layout-color0);\n  background-repeat: no-repeat;\n  background-size:\n    100% 40px,\n    100% 40px,\n    100% 14px,\n    100% 14px;\n  background-attachment: local, local, scroll, scroll;\n}\n\n.lm-MenuBar-menu.jp-ThemedContainer::-webkit-scrollbar {\n  display: none;\n}\n\n.lm-MenuBar-item {\n  padding: 0 8px;\n  border-left: var(--jp-border-width) solid transparent;\n  border-right: var(--jp-border-width) solid transparent;\n  border-top: var(--jp-border-width) solid transparent;\n  line-height: calc(\n    var(--jp-private-menubar-height) - var(--jp-border-width) * 2\n  );\n}\n\n.lm-MenuBar-content:focus-visible {\n  outline-offset: -3px; /* this value is a compromise between Firefox, Chrome,\n    and Safari over this outline's visibility and discretion */\n}\n\n.lm-MenuBar:focus-visible {\n  outline: 1px solid var(--jp-accept-color-active, var(--jp-brand-color1));\n  outline-offset: -1px;\n}\n\n.lm-MenuBar-menu:focus-visible,\n.lm-MenuBar-item:focus-visible,\n.lm-Menu-item:focus-visible {\n  outline: unset;\n  outline-offset: unset;\n  -moz-outline-radius: unset;\n}\n\n.lm-MenuBar-item.lm-mod-active {\n  background: var(--jp-layout-color2);\n}\n\n.lm-MenuBar.lm-mod-active .lm-MenuBar-item.lm-mod-active {\n  z-index: 10001;\n  background: var(--jp-layout-color0);\n  color: var(--jp-ui-font-color0);\n  border-left: var(--jp-border-width) solid var(--jp-border-color1);\n  border-right: var(--jp-border-width) solid var(--jp-border-color1);\n  box-shadow: var(--jp-elevation-z6);\n}\n\n/* stylelint-disable-next-line selector-max-class */\n.jp-LabShell[data-shell-mode='single-document']\n  .lm-MenuBar.lm-mod-active\n  .lm-MenuBar-item.lm-mod-active {\n  border-top: var(--jp-border-width) solid var(--jp-border-color1);\n}\n\n.lm-MenuBar-item.lm-mod-disabled {\n  color: var(--jp-ui-font-color3);\n}\n\n.lm-MenuBar-item.lm-type-separator {\n  margin: 2px;\n  padding: 0;\n  border: none;\n  border-left: var(--jp-border-width) solid var(--jp-border-color2);\n}\n\n.lm-MenuBar-itemMnemonic {\n  text-decoration: underline;\n}\n\n/*-----------------------------------------------------------------------------\n| Menu\n|----------------------------------------------------------------------------*/\n\n.lm-Menu {\n  z-index: 10000;\n  padding: 4px 0;\n  background: var(--jp-layout-color0);\n  color: var(--jp-ui-font-color0);\n  border: var(--jp-border-width) solid var(--jp-border-color1);\n  font-size: var(--jp-ui-font-size1);\n  box-shadow: var(--jp-elevation-z6);\n}\n\n.lm-Menu-item {\n  min-height: var(--jp-private-menu-item-height);\n  max-height: var(--jp-private-menu-item-height);\n  padding: 0;\n  line-height: var(--jp-private-menu-item-height);\n}\n\n.lm-Menu-item.lm-mod-active {\n  background: var(--jp-layout-color2);\n}\n\n.lm-Menu-item.lm-mod-disabled {\n  color: var(--jp-ui-font-color3);\n}\n\n.lm-Menu-itemIcon {\n  width: 21px;\n  padding: 0 2px 0 4px;\n  margin-top: -2px;\n}\n\n.lm-Menu-itemLabel {\n  padding: 0 32px 0 2px;\n}\n\n.lm-Menu-itemMnemonic {\n  text-decoration: underline;\n}\n\n.lm-Menu-itemShortcut {\n  padding: 0;\n}\n\n.lm-Menu-itemSubmenuIcon {\n  width: 18px;\n  padding: 0 4px 0 0;\n}\n\n.lm-Menu-item[data-type='separator'] > div {\n  padding: 0;\n  height: 9px;\n}\n\n.lm-Menu-item[data-type='separator'] > div::after {\n  content: '';\n  display: block;\n  position: relative;\n  top: 4px;\n  border-top: var(--jp-border-width) solid var(--jp-layout-color2);\n  mix-blend-mode: multiply;\n}\n\n/* gray out icon/caret for disabled menu items */\n.lm-Menu-item.lm-mod-disabled > .lm-Menu-itemIcon,\n.lm-Menu-item[data-type='submenu'].lm-mod-disabled > .lm-Menu-itemSubmenuIcon {\n  opacity: 0.4;\n}\n"],"sourceRoot":""}]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ 2452:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Z: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(82971);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(11368);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
// Imports


var ___CSS_LOADER_EXPORT___ = _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default()));
// Module
___CSS_LOADER_EXPORT___.push([module.id, `/*-----------------------------------------------------------------------------
| Copyright (c) Jupyter Development Team.
| Distributed under the terms of the Modified BSD License.
|----------------------------------------------------------------------------*/

/*
 * Mozilla scrollbar styling
 */

/* use standard opaque scrollbars for most nodes */
[data-jp-theme-scrollbars='true'] {
  scrollbar-color: rgb(var(--jp-scrollbar-thumb-color))
    var(--jp-scrollbar-background-color);
}

/* for code nodes, use a transparent style of scrollbar. These selectors
 * will match lower in the tree, and so will override the above */
[data-jp-theme-scrollbars='true'] .CodeMirror-hscrollbar,
[data-jp-theme-scrollbars='true'] .CodeMirror-vscrollbar {
  scrollbar-color: rgba(var(--jp-scrollbar-thumb-color), 0.5) transparent;
}

/* tiny scrollbar */

.jp-scrollbar-tiny {
  scrollbar-color: rgba(var(--jp-scrollbar-thumb-color), 0.5) transparent;
  scrollbar-width: thin;
}

/* tiny scrollbar */

.jp-scrollbar-tiny::-webkit-scrollbar,
.jp-scrollbar-tiny::-webkit-scrollbar-corner {
  background-color: transparent;
  height: 4px;
  width: 4px;
}

.jp-scrollbar-tiny::-webkit-scrollbar-thumb {
  background: rgba(var(--jp-scrollbar-thumb-color), 0.5);
}

.jp-scrollbar-tiny::-webkit-scrollbar-track:horizontal {
  border-left: 0 solid transparent;
  border-right: 0 solid transparent;
}

.jp-scrollbar-tiny::-webkit-scrollbar-track:vertical {
  border-top: 0 solid transparent;
  border-bottom: 0 solid transparent;
}

/*
 * Lumino
 */

.lm-ScrollBar[data-orientation='horizontal'] {
  min-height: 16px;
  max-height: 16px;
  min-width: 45px;
  border-top: 1px solid #a0a0a0;
}

.lm-ScrollBar[data-orientation='vertical'] {
  min-width: 16px;
  max-width: 16px;
  min-height: 45px;
  border-left: 1px solid #a0a0a0;
}

.lm-ScrollBar-button {
  background-color: #f0f0f0;
  background-position: center center;
  min-height: 15px;
  max-height: 15px;
  min-width: 15px;
  max-width: 15px;
}

.lm-ScrollBar-button:hover {
  background-color: #dadada;
}

.lm-ScrollBar-button.lm-mod-active {
  background-color: #cdcdcd;
}

.lm-ScrollBar-track {
  background: #f0f0f0;
}

.lm-ScrollBar-thumb {
  background: #cdcdcd;
}

.lm-ScrollBar-thumb:hover {
  background: #bababa;
}

.lm-ScrollBar-thumb.lm-mod-active {
  background: #a0a0a0;
}

.lm-ScrollBar[data-orientation='horizontal'] .lm-ScrollBar-thumb {
  height: 100%;
  min-width: 15px;
  border-left: 1px solid #a0a0a0;
  border-right: 1px solid #a0a0a0;
}

.lm-ScrollBar[data-orientation='vertical'] .lm-ScrollBar-thumb {
  width: 100%;
  min-height: 15px;
  border-top: 1px solid #a0a0a0;
  border-bottom: 1px solid #a0a0a0;
}

.lm-ScrollBar[data-orientation='horizontal']
  .lm-ScrollBar-button[data-action='decrement'] {
  background-image: var(--jp-icon-caret-left);
  background-size: 17px;
}

.lm-ScrollBar[data-orientation='horizontal']
  .lm-ScrollBar-button[data-action='increment'] {
  background-image: var(--jp-icon-caret-right);
  background-size: 17px;
}

.lm-ScrollBar[data-orientation='vertical']
  .lm-ScrollBar-button[data-action='decrement'] {
  background-image: var(--jp-icon-caret-up);
  background-size: 17px;
}

.lm-ScrollBar[data-orientation='vertical']
  .lm-ScrollBar-button[data-action='increment'] {
  background-image: var(--jp-icon-caret-down);
  background-size: 17px;
}
`, "",{"version":3,"sources":["webpack://./../node_modules/@jupyterlab/application/style/scrollbar.css"],"names":[],"mappings":"AAAA;;;8EAG8E;;AAE9E;;EAEE;;AAEF,kDAAkD;AAClD;EACE;wCACsC;AACxC;;AAEA;iEACiE;AACjE;;EAEE,uEAAuE;AACzE;;AAEA,mBAAmB;;AAEnB;EACE,uEAAuE;EACvE,qBAAqB;AACvB;;AAEA,mBAAmB;;AAEnB;;EAEE,6BAA6B;EAC7B,WAAW;EACX,UAAU;AACZ;;AAEA;EACE,sDAAsD;AACxD;;AAEA;EACE,gCAAgC;EAChC,iCAAiC;AACnC;;AAEA;EACE,+BAA+B;EAC/B,kCAAkC;AACpC;;AAEA;;EAEE;;AAEF;EACE,gBAAgB;EAChB,gBAAgB;EAChB,eAAe;EACf,6BAA6B;AAC/B;;AAEA;EACE,eAAe;EACf,eAAe;EACf,gBAAgB;EAChB,8BAA8B;AAChC;;AAEA;EACE,yBAAyB;EACzB,kCAAkC;EAClC,gBAAgB;EAChB,gBAAgB;EAChB,eAAe;EACf,eAAe;AACjB;;AAEA;EACE,yBAAyB;AAC3B;;AAEA;EACE,yBAAyB;AAC3B;;AAEA;EACE,mBAAmB;AACrB;;AAEA;EACE,mBAAmB;AACrB;;AAEA;EACE,mBAAmB;AACrB;;AAEA;EACE,mBAAmB;AACrB;;AAEA;EACE,YAAY;EACZ,eAAe;EACf,8BAA8B;EAC9B,+BAA+B;AACjC;;AAEA;EACE,WAAW;EACX,gBAAgB;EAChB,6BAA6B;EAC7B,gCAAgC;AAClC;;AAEA;;EAEE,2CAA2C;EAC3C,qBAAqB;AACvB;;AAEA;;EAEE,4CAA4C;EAC5C,qBAAqB;AACvB;;AAEA;;EAEE,yCAAyC;EACzC,qBAAqB;AACvB;;AAEA;;EAEE,2CAA2C;EAC3C,qBAAqB;AACvB","sourcesContent":["/*-----------------------------------------------------------------------------\n| Copyright (c) Jupyter Development Team.\n| Distributed under the terms of the Modified BSD License.\n|----------------------------------------------------------------------------*/\n\n/*\n * Mozilla scrollbar styling\n */\n\n/* use standard opaque scrollbars for most nodes */\n[data-jp-theme-scrollbars='true'] {\n  scrollbar-color: rgb(var(--jp-scrollbar-thumb-color))\n    var(--jp-scrollbar-background-color);\n}\n\n/* for code nodes, use a transparent style of scrollbar. These selectors\n * will match lower in the tree, and so will override the above */\n[data-jp-theme-scrollbars='true'] .CodeMirror-hscrollbar,\n[data-jp-theme-scrollbars='true'] .CodeMirror-vscrollbar {\n  scrollbar-color: rgba(var(--jp-scrollbar-thumb-color), 0.5) transparent;\n}\n\n/* tiny scrollbar */\n\n.jp-scrollbar-tiny {\n  scrollbar-color: rgba(var(--jp-scrollbar-thumb-color), 0.5) transparent;\n  scrollbar-width: thin;\n}\n\n/* tiny scrollbar */\n\n.jp-scrollbar-tiny::-webkit-scrollbar,\n.jp-scrollbar-tiny::-webkit-scrollbar-corner {\n  background-color: transparent;\n  height: 4px;\n  width: 4px;\n}\n\n.jp-scrollbar-tiny::-webkit-scrollbar-thumb {\n  background: rgba(var(--jp-scrollbar-thumb-color), 0.5);\n}\n\n.jp-scrollbar-tiny::-webkit-scrollbar-track:horizontal {\n  border-left: 0 solid transparent;\n  border-right: 0 solid transparent;\n}\n\n.jp-scrollbar-tiny::-webkit-scrollbar-track:vertical {\n  border-top: 0 solid transparent;\n  border-bottom: 0 solid transparent;\n}\n\n/*\n * Lumino\n */\n\n.lm-ScrollBar[data-orientation='horizontal'] {\n  min-height: 16px;\n  max-height: 16px;\n  min-width: 45px;\n  border-top: 1px solid #a0a0a0;\n}\n\n.lm-ScrollBar[data-orientation='vertical'] {\n  min-width: 16px;\n  max-width: 16px;\n  min-height: 45px;\n  border-left: 1px solid #a0a0a0;\n}\n\n.lm-ScrollBar-button {\n  background-color: #f0f0f0;\n  background-position: center center;\n  min-height: 15px;\n  max-height: 15px;\n  min-width: 15px;\n  max-width: 15px;\n}\n\n.lm-ScrollBar-button:hover {\n  background-color: #dadada;\n}\n\n.lm-ScrollBar-button.lm-mod-active {\n  background-color: #cdcdcd;\n}\n\n.lm-ScrollBar-track {\n  background: #f0f0f0;\n}\n\n.lm-ScrollBar-thumb {\n  background: #cdcdcd;\n}\n\n.lm-ScrollBar-thumb:hover {\n  background: #bababa;\n}\n\n.lm-ScrollBar-thumb.lm-mod-active {\n  background: #a0a0a0;\n}\n\n.lm-ScrollBar[data-orientation='horizontal'] .lm-ScrollBar-thumb {\n  height: 100%;\n  min-width: 15px;\n  border-left: 1px solid #a0a0a0;\n  border-right: 1px solid #a0a0a0;\n}\n\n.lm-ScrollBar[data-orientation='vertical'] .lm-ScrollBar-thumb {\n  width: 100%;\n  min-height: 15px;\n  border-top: 1px solid #a0a0a0;\n  border-bottom: 1px solid #a0a0a0;\n}\n\n.lm-ScrollBar[data-orientation='horizontal']\n  .lm-ScrollBar-button[data-action='decrement'] {\n  background-image: var(--jp-icon-caret-left);\n  background-size: 17px;\n}\n\n.lm-ScrollBar[data-orientation='horizontal']\n  .lm-ScrollBar-button[data-action='increment'] {\n  background-image: var(--jp-icon-caret-right);\n  background-size: 17px;\n}\n\n.lm-ScrollBar[data-orientation='vertical']\n  .lm-ScrollBar-button[data-action='decrement'] {\n  background-image: var(--jp-icon-caret-up);\n  background-size: 17px;\n}\n\n.lm-ScrollBar[data-orientation='vertical']\n  .lm-ScrollBar-button[data-action='increment'] {\n  background-image: var(--jp-icon-caret-down);\n  background-size: 17px;\n}\n"],"sourceRoot":""}]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ 71728:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Z: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(82971);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(11368);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
// Imports


var ___CSS_LOADER_EXPORT___ = _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default()));
// Module
___CSS_LOADER_EXPORT___.push([module.id, `/*-----------------------------------------------------------------------------
| Copyright (c) Jupyter Development Team.
| Distributed under the terms of the Modified BSD License.
|----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------
| Variables
|----------------------------------------------------------------------------*/

:root {
  --jp-private-sidebar-tab-width: 32px;
}

/*-----------------------------------------------------------------------------
| SideBar
|----------------------------------------------------------------------------*/

.jp-SideBar {
  /* This is needed so that all font sizing of children done in ems is
   * relative to this base size */
  font-size: var(--jp-ui-font-size1);
}

.jp-SideBar.lm-TabBar,
#jp-down-stack .lm-TabBar {
  color: var(--jp-ui-font-color2);
  background: var(--jp-layout-color2);
  font-size: var(--jp-ui-font-size1);
  overflow: visible;
}

.jp-SideBar.lm-TabBar {
  min-width: calc(var(--jp-private-sidebar-tab-width) + var(--jp-border-width));
  max-width: calc(var(--jp-private-sidebar-tab-width) + var(--jp-border-width));
  display: block;
}

.jp-SideBar .lm-TabBar-content {
  margin: 0;
  padding: 0;
  display: flex;
  align-items: stretch;
  list-style-type: none;
  height: var(--jp-private-sidebar-tab-width);
}

.jp-SideBar .lm-TabBar-tab {
  padding: 16px 0;
  border: none;
  overflow: visible;
  flex-direction: column;
  position: relative;
}

.jp-SideBar .lm-TabBar-tab:focus-visible {
  /* --accent-fill-focus is computed by the jp toolkit to ensure accessibility */
  outline: 2px solid var(--accent-fill-focus, var(--jp-brand-color1));
  outline-offset: -3px;
}

.jp-SideBar .lm-TabBar-tab.lm-mod-current::after {
  /* Internal border override pseudo-element */
  position: absolute;
  content: '';
  bottom: 0;
  right: 0;
  top: 0;
  left: 0;
  border: var(--jp-border-width) solid var(--jp-layout-color1);
}

.jp-SideBar .lm-TabBar-tab:not(.lm-mod-current),
#jp-down-stack .lm-TabBar-tab:not(.lm-mod-current) {
  background: var(--jp-layout-color2);
}

.jp-SideBar .lm-TabBar-tabIcon.jp-SideBar-tabIcon {
  min-width: 20px;
  min-height: 20px;
  background-size: 20px;
  display: inline-block;
  vertical-align: middle;
  background-repeat: no-repeat;
  background-position: center;
}

.jp-SideBar .lm-TabBar-tabLabel {
  line-height: var(--jp-private-sidebar-tab-width);
}

.jp-SideBar .lm-TabBar-tab:hover:not(.lm-mod-current),
#jp-down-stack .lm-TabBar-tab:hover:not(.lm-mod-current) {
  background: var(--jp-layout-color1);
}

.jp-SideBar.lm-TabBar::after {
  /* Internal border pseudo-element */
  position: absolute;
  content: '';
  bottom: 0;
  right: 0;
  top: 0;
  left: 0;
  pointer-events: none;
}

/* Borders */

/* stylelint-disable selector-max-class */

.jp-SideBar.lm-TabBar .lm-TabBar-tab + .lm-TabBar-tab {
  border-top: var(--jp-border-width) solid var(--jp-layout-color2);
}

.jp-SideBar.lm-TabBar .lm-TabBar-tab.lm-mod-current + .lm-TabBar-tab {
  border-top: var(--jp-border-width) solid var(--jp-border-color0);
}

.jp-SideBar.lm-TabBar .lm-TabBar-tab + .lm-TabBar-tab.lm-mod-current {
  border-top: var(--jp-border-width) solid var(--jp-border-color0);
}

.jp-SideBar.lm-TabBar .lm-TabBar-tab.lm-mod-current:last-child {
  border-bottom: var(--jp-border-width) solid var(--jp-border-color0);
}

.jp-SideBar.lm-TabBar .lm-TabBar-tabLabel {
  writing-mode: vertical-rl;
}

/* Left */

/* Borders */

.jp-SideBar.lm-TabBar.jp-mod-left .lm-TabBar-content {
  /* Internal border spacing */
  margin-right: var(--jp-border-width);
}

.jp-SideBar.lm-TabBar.jp-mod-left .lm-TabBar-tab.lm-mod-current::after {
  /* Internal border override */
  right: calc(-1 * var(--jp-border-width));
}

.jp-SideBar.lm-TabBar.jp-mod-left::after {
  /* Internal border */
  border-right: var(--jp-border-width) solid var(--jp-border-color0);
}

/* Transforms */

.jp-SideBar.lm-TabBar.jp-mod-left .lm-TabBar-tabLabel {
  transform: rotate(180deg);
}

/* Right */

/* Borders */

.jp-SideBar.lm-TabBar.jp-mod-right .lm-TabBar-content {
  /* Internal border spacing */
  margin-left: var(--jp-border-width);
}

.jp-SideBar.lm-TabBar.jp-mod-right .lm-TabBar-tab.lm-mod-current::after {
  /* Internal border override */
  left: calc(-1 * var(--jp-border-width));
}

.jp-SideBar.lm-TabBar.jp-mod-right::after {
  /* Internal border */
  border-left: var(--jp-border-width) solid var(--jp-border-color0);
}

/* Down */

/* Borders */

#jp-down-stack > .lm-TabBar {
  border-top: var(--jp-border-width) solid var(--jp-border-color0);
  border-bottom: var(--jp-border-width) solid var(--jp-border-color0);
}

#jp-down-stack > .lm-TabBar .lm-TabBar-tab {
  border-left: none;
  border-right: none;
}

#jp-down-stack > .lm-TabBar .lm-TabBar-tab.lm-mod-current {
  border: var(--jp-border-width) solid var(--jp-border-color1);
  border-bottom: none;
  transform: translateY(var(--jp-border-width));
}

#jp-down-stack > .lm-TabBar .lm-TabBar-tab.lm-mod-current:first-child {
  border: none;
  border-right: var(--jp-border-width) solid var(--jp-border-color1);
}

/* stylelint-enable selector-max-class */

/* Stack panels */

#jp-left-stack > .lm-Widget,
#jp-right-stack > .lm-Widget {
  min-width: var(--jp-sidebar-min-width);
  background-color: var(--jp-layout-color1);
}

#jp-right-stack {
  border-left: var(--jp-border-width) solid var(--jp-border-color1);
}

#jp-left-stack {
  border-right: var(--jp-border-width) solid var(--jp-border-color1);
}

#jp-down-stack > .lm-TabPanel-stackedPanel {
  border: none;
}
`, "",{"version":3,"sources":["webpack://./../node_modules/@jupyterlab/application/style/sidepanel.css"],"names":[],"mappings":"AAAA;;;8EAG8E;;AAE9E;;8EAE8E;;AAE9E;EACE,oCAAoC;AACtC;;AAEA;;8EAE8E;;AAE9E;EACE;iCAC+B;EAC/B,kCAAkC;AACpC;;AAEA;;EAEE,+BAA+B;EAC/B,mCAAmC;EACnC,kCAAkC;EAClC,iBAAiB;AACnB;;AAEA;EACE,6EAA6E;EAC7E,6EAA6E;EAC7E,cAAc;AAChB;;AAEA;EACE,SAAS;EACT,UAAU;EACV,aAAa;EACb,oBAAoB;EACpB,qBAAqB;EACrB,2CAA2C;AAC7C;;AAEA;EACE,eAAe;EACf,YAAY;EACZ,iBAAiB;EACjB,sBAAsB;EACtB,kBAAkB;AACpB;;AAEA;EACE,8EAA8E;EAC9E,mEAAmE;EACnE,oBAAoB;AACtB;;AAEA;EACE,4CAA4C;EAC5C,kBAAkB;EAClB,WAAW;EACX,SAAS;EACT,QAAQ;EACR,MAAM;EACN,OAAO;EACP,4DAA4D;AAC9D;;AAEA;;EAEE,mCAAmC;AACrC;;AAEA;EACE,eAAe;EACf,gBAAgB;EAChB,qBAAqB;EACrB,qBAAqB;EACrB,sBAAsB;EACtB,4BAA4B;EAC5B,2BAA2B;AAC7B;;AAEA;EACE,gDAAgD;AAClD;;AAEA;;EAEE,mCAAmC;AACrC;;AAEA;EACE,mCAAmC;EACnC,kBAAkB;EAClB,WAAW;EACX,SAAS;EACT,QAAQ;EACR,MAAM;EACN,OAAO;EACP,oBAAoB;AACtB;;AAEA,YAAY;;AAEZ,yCAAyC;;AAEzC;EACE,gEAAgE;AAClE;;AAEA;EACE,gEAAgE;AAClE;;AAEA;EACE,gEAAgE;AAClE;;AAEA;EACE,mEAAmE;AACrE;;AAEA;EACE,yBAAyB;AAC3B;;AAEA,SAAS;;AAET,YAAY;;AAEZ;EACE,4BAA4B;EAC5B,oCAAoC;AACtC;;AAEA;EACE,6BAA6B;EAC7B,wCAAwC;AAC1C;;AAEA;EACE,oBAAoB;EACpB,kEAAkE;AACpE;;AAEA,eAAe;;AAEf;EACE,yBAAyB;AAC3B;;AAEA,UAAU;;AAEV,YAAY;;AAEZ;EACE,4BAA4B;EAC5B,mCAAmC;AACrC;;AAEA;EACE,6BAA6B;EAC7B,uCAAuC;AACzC;;AAEA;EACE,oBAAoB;EACpB,iEAAiE;AACnE;;AAEA,SAAS;;AAET,YAAY;;AAEZ;EACE,gEAAgE;EAChE,mEAAmE;AACrE;;AAEA;EACE,iBAAiB;EACjB,kBAAkB;AACpB;;AAEA;EACE,4DAA4D;EAC5D,mBAAmB;EACnB,6CAA6C;AAC/C;;AAEA;EACE,YAAY;EACZ,kEAAkE;AACpE;;AAEA,wCAAwC;;AAExC,iBAAiB;;AAEjB;;EAEE,sCAAsC;EACtC,yCAAyC;AAC3C;;AAEA;EACE,iEAAiE;AACnE;;AAEA;EACE,kEAAkE;AACpE;;AAEA;EACE,YAAY;AACd","sourcesContent":["/*-----------------------------------------------------------------------------\n| Copyright (c) Jupyter Development Team.\n| Distributed under the terms of the Modified BSD License.\n|----------------------------------------------------------------------------*/\n\n/*-----------------------------------------------------------------------------\n| Variables\n|----------------------------------------------------------------------------*/\n\n:root {\n  --jp-private-sidebar-tab-width: 32px;\n}\n\n/*-----------------------------------------------------------------------------\n| SideBar\n|----------------------------------------------------------------------------*/\n\n.jp-SideBar {\n  /* This is needed so that all font sizing of children done in ems is\n   * relative to this base size */\n  font-size: var(--jp-ui-font-size1);\n}\n\n.jp-SideBar.lm-TabBar,\n#jp-down-stack .lm-TabBar {\n  color: var(--jp-ui-font-color2);\n  background: var(--jp-layout-color2);\n  font-size: var(--jp-ui-font-size1);\n  overflow: visible;\n}\n\n.jp-SideBar.lm-TabBar {\n  min-width: calc(var(--jp-private-sidebar-tab-width) + var(--jp-border-width));\n  max-width: calc(var(--jp-private-sidebar-tab-width) + var(--jp-border-width));\n  display: block;\n}\n\n.jp-SideBar .lm-TabBar-content {\n  margin: 0;\n  padding: 0;\n  display: flex;\n  align-items: stretch;\n  list-style-type: none;\n  height: var(--jp-private-sidebar-tab-width);\n}\n\n.jp-SideBar .lm-TabBar-tab {\n  padding: 16px 0;\n  border: none;\n  overflow: visible;\n  flex-direction: column;\n  position: relative;\n}\n\n.jp-SideBar .lm-TabBar-tab:focus-visible {\n  /* --accent-fill-focus is computed by the jp toolkit to ensure accessibility */\n  outline: 2px solid var(--accent-fill-focus, var(--jp-brand-color1));\n  outline-offset: -3px;\n}\n\n.jp-SideBar .lm-TabBar-tab.lm-mod-current::after {\n  /* Internal border override pseudo-element */\n  position: absolute;\n  content: '';\n  bottom: 0;\n  right: 0;\n  top: 0;\n  left: 0;\n  border: var(--jp-border-width) solid var(--jp-layout-color1);\n}\n\n.jp-SideBar .lm-TabBar-tab:not(.lm-mod-current),\n#jp-down-stack .lm-TabBar-tab:not(.lm-mod-current) {\n  background: var(--jp-layout-color2);\n}\n\n.jp-SideBar .lm-TabBar-tabIcon.jp-SideBar-tabIcon {\n  min-width: 20px;\n  min-height: 20px;\n  background-size: 20px;\n  display: inline-block;\n  vertical-align: middle;\n  background-repeat: no-repeat;\n  background-position: center;\n}\n\n.jp-SideBar .lm-TabBar-tabLabel {\n  line-height: var(--jp-private-sidebar-tab-width);\n}\n\n.jp-SideBar .lm-TabBar-tab:hover:not(.lm-mod-current),\n#jp-down-stack .lm-TabBar-tab:hover:not(.lm-mod-current) {\n  background: var(--jp-layout-color1);\n}\n\n.jp-SideBar.lm-TabBar::after {\n  /* Internal border pseudo-element */\n  position: absolute;\n  content: '';\n  bottom: 0;\n  right: 0;\n  top: 0;\n  left: 0;\n  pointer-events: none;\n}\n\n/* Borders */\n\n/* stylelint-disable selector-max-class */\n\n.jp-SideBar.lm-TabBar .lm-TabBar-tab + .lm-TabBar-tab {\n  border-top: var(--jp-border-width) solid var(--jp-layout-color2);\n}\n\n.jp-SideBar.lm-TabBar .lm-TabBar-tab.lm-mod-current + .lm-TabBar-tab {\n  border-top: var(--jp-border-width) solid var(--jp-border-color0);\n}\n\n.jp-SideBar.lm-TabBar .lm-TabBar-tab + .lm-TabBar-tab.lm-mod-current {\n  border-top: var(--jp-border-width) solid var(--jp-border-color0);\n}\n\n.jp-SideBar.lm-TabBar .lm-TabBar-tab.lm-mod-current:last-child {\n  border-bottom: var(--jp-border-width) solid var(--jp-border-color0);\n}\n\n.jp-SideBar.lm-TabBar .lm-TabBar-tabLabel {\n  writing-mode: vertical-rl;\n}\n\n/* Left */\n\n/* Borders */\n\n.jp-SideBar.lm-TabBar.jp-mod-left .lm-TabBar-content {\n  /* Internal border spacing */\n  margin-right: var(--jp-border-width);\n}\n\n.jp-SideBar.lm-TabBar.jp-mod-left .lm-TabBar-tab.lm-mod-current::after {\n  /* Internal border override */\n  right: calc(-1 * var(--jp-border-width));\n}\n\n.jp-SideBar.lm-TabBar.jp-mod-left::after {\n  /* Internal border */\n  border-right: var(--jp-border-width) solid var(--jp-border-color0);\n}\n\n/* Transforms */\n\n.jp-SideBar.lm-TabBar.jp-mod-left .lm-TabBar-tabLabel {\n  transform: rotate(180deg);\n}\n\n/* Right */\n\n/* Borders */\n\n.jp-SideBar.lm-TabBar.jp-mod-right .lm-TabBar-content {\n  /* Internal border spacing */\n  margin-left: var(--jp-border-width);\n}\n\n.jp-SideBar.lm-TabBar.jp-mod-right .lm-TabBar-tab.lm-mod-current::after {\n  /* Internal border override */\n  left: calc(-1 * var(--jp-border-width));\n}\n\n.jp-SideBar.lm-TabBar.jp-mod-right::after {\n  /* Internal border */\n  border-left: var(--jp-border-width) solid var(--jp-border-color0);\n}\n\n/* Down */\n\n/* Borders */\n\n#jp-down-stack > .lm-TabBar {\n  border-top: var(--jp-border-width) solid var(--jp-border-color0);\n  border-bottom: var(--jp-border-width) solid var(--jp-border-color0);\n}\n\n#jp-down-stack > .lm-TabBar .lm-TabBar-tab {\n  border-left: none;\n  border-right: none;\n}\n\n#jp-down-stack > .lm-TabBar .lm-TabBar-tab.lm-mod-current {\n  border: var(--jp-border-width) solid var(--jp-border-color1);\n  border-bottom: none;\n  transform: translateY(var(--jp-border-width));\n}\n\n#jp-down-stack > .lm-TabBar .lm-TabBar-tab.lm-mod-current:first-child {\n  border: none;\n  border-right: var(--jp-border-width) solid var(--jp-border-color1);\n}\n\n/* stylelint-enable selector-max-class */\n\n/* Stack panels */\n\n#jp-left-stack > .lm-Widget,\n#jp-right-stack > .lm-Widget {\n  min-width: var(--jp-sidebar-min-width);\n  background-color: var(--jp-layout-color1);\n}\n\n#jp-right-stack {\n  border-left: var(--jp-border-width) solid var(--jp-border-color1);\n}\n\n#jp-left-stack {\n  border-right: var(--jp-border-width) solid var(--jp-border-color1);\n}\n\n#jp-down-stack > .lm-TabPanel-stackedPanel {\n  border: none;\n}\n"],"sourceRoot":""}]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ 17285:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Z: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(82971);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(11368);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
// Imports


var ___CSS_LOADER_EXPORT___ = _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default()));
// Module
___CSS_LOADER_EXPORT___.push([module.id, `/*-----------------------------------------------------------------------------
| Copyright (c) Jupyter Development Team.
|
| Distributed under the terms of the Modified BSD License.
|----------------------------------------------------------------------------*/

.jp-skiplink-wrapper {
  overflow: visible;

  /* override strict containment added via Lumino PR
   [#506](https://github.com/jupyterlab/lumino/pull/506) */
  contain: size style !important;
}

.jp-skiplink {
  position: absolute;
  top: -100em;
}

.jp-skiplink:focus-within {
  position: absolute;
  z-index: 10000;
  top: 0;
  left: 46%;
  margin: 0 auto;
  padding: 1em;
  width: 15%;
  box-shadow: var(--jp-elevation-z4);
  border-radius: 4px;
  background: var(--jp-layout-color0);
  text-align: center;
}

.jp-skiplink:focus-within a {
  text-decoration: underline;
  color: var(--jp-content-link-color);
}
`, "",{"version":3,"sources":["webpack://./../node_modules/@jupyterlab/application/style/skiplink.css"],"names":[],"mappings":"AAAA;;;;8EAI8E;;AAE9E;EACE,iBAAiB;;EAEjB;0DACwD;EACxD,8BAA8B;AAChC;;AAEA;EACE,kBAAkB;EAClB,WAAW;AACb;;AAEA;EACE,kBAAkB;EAClB,cAAc;EACd,MAAM;EACN,SAAS;EACT,cAAc;EACd,YAAY;EACZ,UAAU;EACV,kCAAkC;EAClC,kBAAkB;EAClB,mCAAmC;EACnC,kBAAkB;AACpB;;AAEA;EACE,0BAA0B;EAC1B,mCAAmC;AACrC","sourcesContent":["/*-----------------------------------------------------------------------------\n| Copyright (c) Jupyter Development Team.\n|\n| Distributed under the terms of the Modified BSD License.\n|----------------------------------------------------------------------------*/\n\n.jp-skiplink-wrapper {\n  overflow: visible;\n\n  /* override strict containment added via Lumino PR\n   [#506](https://github.com/jupyterlab/lumino/pull/506) */\n  contain: size style !important;\n}\n\n.jp-skiplink {\n  position: absolute;\n  top: -100em;\n}\n\n.jp-skiplink:focus-within {\n  position: absolute;\n  z-index: 10000;\n  top: 0;\n  left: 46%;\n  margin: 0 auto;\n  padding: 1em;\n  width: 15%;\n  box-shadow: var(--jp-elevation-z4);\n  border-radius: 4px;\n  background: var(--jp-layout-color0);\n  text-align: center;\n}\n\n.jp-skiplink:focus-within a {\n  text-decoration: underline;\n  color: var(--jp-content-link-color);\n}\n"],"sourceRoot":""}]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ 21171:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Z: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(82971);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(11368);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
// Imports


var ___CSS_LOADER_EXPORT___ = _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default()));
// Module
___CSS_LOADER_EXPORT___.push([module.id, `/*-----------------------------------------------------------------------------
| Copyright (c) Jupyter Development Team.
| Distributed under the terms of the Modified BSD License.
|----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------
| Variables
|----------------------------------------------------------------------------*/

:root {
  /* These need to be root because tabs get attached to the body during dragging. */
  --jp-private-horizontal-tab-height: 24px;
  --jp-private-horizontal-tab-width: 216px;
  --jp-private-horizontal-tab-active-top-border: 2px;
}

/*-----------------------------------------------------------------------------
| Tabs in the dock panel
|----------------------------------------------------------------------------*/

.lm-DockPanel-tabBar,
.lm-TabPanel-tabBar {
  overflow: visible;
  color: var(--jp-ui-font-color1);
  font-size: var(--jp-ui-font-size1);
}

.lm-DockPanel-tabBar[data-orientation='horizontal'],
.lm-TabPanel-tabBar[data-orientation='horizontal'] {
  min-height: calc(
    var(--jp-private-horizontal-tab-height) + 2 * var(--jp-border-width)
  );
}

.lm-DockPanel-tabBar[data-orientation='vertical'] {
  min-width: 80px;
}

.lm-DockPanel-tabBar > .lm-TabBar-content,
.lm-TabPanel-tabBar > .lm-TabBar-content {
  align-items: flex-end;
  min-width: 0;
  min-height: 0;
}

.lm-DockPanel-tabBar .lm-TabBar-tab,
.lm-TabPanel-tabBar .lm-TabBar-tab {
  flex: 0 1 var(--jp-private-horizontal-tab-width);
  align-items: center;
  min-height: calc(
    var(--jp-private-horizontal-tab-height) + 2 * var(--jp-border-width)
  );
  min-width: 0;
  margin-left: calc(-1 * var(--jp-border-width));
  line-height: var(--jp-private-horizontal-tab-height);
  padding: 0 8px;
  background: var(--jp-layout-color2);
  border: var(--jp-border-width) solid var(--jp-border-color1);
  border-bottom: none;
  position: relative;
}

.lm-DockPanel-tabBar .lm-TabBar-tab:focus-visible,
.lm-DockPanel-tabBar .lm-TabBar-addButton:focus-visible,
.lm-TabPanel-tabBar .lm-TabBar-tab:focus-visible {
  border: 1px solid var(--accent-fill-focus);
  border-bottom: none;

  /* Thicken the border by 1px within the element border */
  box-shadow: 0 0 0 1px inset var(--accent-fill-focus);
  outline: none;
}

.lm-DockPanel-tabBar .lm-TabBar-tab:not(.lm-mod-current):focus-visible::after,
.lm-TabPanel-tabBar .lm-TabBar-tab:not(.lm-mod-current):focus-visible::after {
  border-bottom-color: var(--accent-fill-focus);
}

.lm-DockPanel-tabBar .lm-TabBar-tab:hover:not(.lm-mod-current),
.lm-TabPanel-tabBar .lm-TabBar-tab:hover:not(.lm-mod-current) {
  background: var(--jp-layout-color1);
  color: var(--jp-ui-font-color1);
}

.lm-DockPanel-tabBar .lm-TabBar-tab:not(.lm-mod-current)::after,
.lm-DockPanel-tabBar .lm-TabBar-addButton::after {
  position: absolute;
  content: '';
  bottom: 0;
  left: calc(-1 * var(--jp-border-width));
  width: calc(100% + 2 * var(--jp-border-width));
  border-bottom: var(--jp-border-width) solid var(--jp-border-color1);
}

.lm-DockPanel-tabBar .lm-TabBar-tab:first-child,
.lm-TabPanel-tabBar .lm-TabBar-tab:first-child {
  margin-left: 0;
}

/* This is a current tab of a tab bar in the dock panel: each tab bar has 1. */
.lm-DockPanel-tabBar .lm-TabBar-tab.lm-mod-current {
  background: var(--jp-layout-color1);
  color: var(--jp-ui-font-color1);
}

.lm-TabPanel-tabBar .lm-TabBar-tab.lm-mod-current {
  background: var(--jp-layout-color1);
  color: var(--jp-ui-font-color1);
}

/* This is the main application level current tab: only 1 exists. */
.lm-DockPanel-tabBar .lm-TabBar-tab.jp-mod-current::before {
  position: absolute;
  top: calc(-1 * var(--jp-border-width) + 1px);
  left: calc(-1 * var(--jp-border-width));
  content: '';
  height: var(--jp-private-horizontal-tab-active-top-border);
  width: calc(100% + 2 * var(--jp-border-width));
  background: var(--jp-brand-color1);
}

/* This is the left tab bar current tab: only 1 exists. */
.lm-TabBar-tab.lm-mod-current {
  background: var(--jp-layout-color1);
  color: var(--jp-ui-font-color1);
}

.lm-DockPanel-tabBar .lm-TabBar.lm-mod-left .lm-TabBar-tab,
.lm-DockPanel-tabBar .lm-TabBar.lm-mod-right .lm-TabBar-tab {
  flex: 0 1 40px;
  margin-top: -1px;
  line-height: 40px;
}

.lm-DockPanel-tabBar .lm-TabBar.lm-mod-left .lm-TabBar-tab {
  border-right: none;
}

.lm-DockPanel-tabBar .lm-TabBar.lm-mod-right .lm-TabBar-tab {
  border-left: none;
}

.lm-DockPanel-tabBar .lm-TabBar.lm-mod-left .lm-TabBar-tab:first-child,
.lm-DockPanel-tabBar .lm-TabBar.lm-mod-right .lm-TabBar-tab:first-child {
  margin-top: 0;
}

/* stylelint-disable selector-max-class */

.lm-DockPanel-tabBar .lm-TabBar.lm-mod-left .lm-TabBar-tab.lm-mod-current,
.lm-DockPanel-tabBar .lm-TabBar.lm-mod-right .lm-TabBar-tab.lm-mod-current {
  min-width: 80px;
  max-width: 80px;
}

.lm-DockPanel-tabBar .lm-TabBar.lm-mod-right .lm-TabBar-tab.lm-mod-current {
  transform: translateX(-1px);
}

.lm-DockPanel-tabBar .lm-TabBar-tab .lm-TabBar-tabIcon,
.lm-TabBar-tab.lm-mod-drag-image .lm-TabBar-tabIcon,
.lm-TabPanel-tabBar .lm-TabBar-tab .lm-TabBar-tabIcon {
  width: 14px;
  background-position: left center;
  background-repeat: no-repeat;
  background-size: 14px;
  margin-right: 4px;
}

/* stylelint-enable selector-max-class */

.lm-TabBar-tab.lm-mod-drag-image {
  background: var(--jp-layout-color1);
  color: var(--jp-ui-font-color1);
  border: var(--jp-border-width) solid var(--jp-border-color1);
  border-top: var(--jp-border-width) solid var(--jp-brand-color1);
  box-shadow: var(--jp-elevation-z4);
  font-size: var(--jp-ui-font-size1);
  line-height: var(--jp-private-horizontal-tab-height);
  min-height: var(--jp-private-horizontal-tab-height);
  min-width: var(--jp-private-horizontal-tab-width);
  padding: 0 10px;
  transform: translateX(-40%) translateY(-58%);
}
`, "",{"version":3,"sources":["webpack://./../node_modules/@jupyterlab/application/style/tabs.css"],"names":[],"mappings":"AAAA;;;8EAG8E;;AAE9E;;8EAE8E;;AAE9E;EACE,iFAAiF;EACjF,wCAAwC;EACxC,wCAAwC;EACxC,kDAAkD;AACpD;;AAEA;;8EAE8E;;AAE9E;;EAEE,iBAAiB;EACjB,+BAA+B;EAC/B,kCAAkC;AACpC;;AAEA;;EAEE;;GAEC;AACH;;AAEA;EACE,eAAe;AACjB;;AAEA;;EAEE,qBAAqB;EACrB,YAAY;EACZ,aAAa;AACf;;AAEA;;EAEE,gDAAgD;EAChD,mBAAmB;EACnB;;GAEC;EACD,YAAY;EACZ,8CAA8C;EAC9C,oDAAoD;EACpD,cAAc;EACd,mCAAmC;EACnC,4DAA4D;EAC5D,mBAAmB;EACnB,kBAAkB;AACpB;;AAEA;;;EAGE,0CAA0C;EAC1C,mBAAmB;;EAEnB,wDAAwD;EACxD,oDAAoD;EACpD,aAAa;AACf;;AAEA;;EAEE,6CAA6C;AAC/C;;AAEA;;EAEE,mCAAmC;EACnC,+BAA+B;AACjC;;AAEA;;EAEE,kBAAkB;EAClB,WAAW;EACX,SAAS;EACT,uCAAuC;EACvC,8CAA8C;EAC9C,mEAAmE;AACrE;;AAEA;;EAEE,cAAc;AAChB;;AAEA,8EAA8E;AAC9E;EACE,mCAAmC;EACnC,+BAA+B;AACjC;;AAEA;EACE,mCAAmC;EACnC,+BAA+B;AACjC;;AAEA,mEAAmE;AACnE;EACE,kBAAkB;EAClB,4CAA4C;EAC5C,uCAAuC;EACvC,WAAW;EACX,0DAA0D;EAC1D,8CAA8C;EAC9C,kCAAkC;AACpC;;AAEA,yDAAyD;AACzD;EACE,mCAAmC;EACnC,+BAA+B;AACjC;;AAEA;;EAEE,cAAc;EACd,gBAAgB;EAChB,iBAAiB;AACnB;;AAEA;EACE,kBAAkB;AACpB;;AAEA;EACE,iBAAiB;AACnB;;AAEA;;EAEE,aAAa;AACf;;AAEA,yCAAyC;;AAEzC;;EAEE,eAAe;EACf,eAAe;AACjB;;AAEA;EACE,2BAA2B;AAC7B;;AAEA;;;EAGE,WAAW;EACX,gCAAgC;EAChC,4BAA4B;EAC5B,qBAAqB;EACrB,iBAAiB;AACnB;;AAEA,wCAAwC;;AAExC;EACE,mCAAmC;EACnC,+BAA+B;EAC/B,4DAA4D;EAC5D,+DAA+D;EAC/D,kCAAkC;EAClC,kCAAkC;EAClC,oDAAoD;EACpD,mDAAmD;EACnD,iDAAiD;EACjD,eAAe;EACf,4CAA4C;AAC9C","sourcesContent":["/*-----------------------------------------------------------------------------\n| Copyright (c) Jupyter Development Team.\n| Distributed under the terms of the Modified BSD License.\n|----------------------------------------------------------------------------*/\n\n/*-----------------------------------------------------------------------------\n| Variables\n|----------------------------------------------------------------------------*/\n\n:root {\n  /* These need to be root because tabs get attached to the body during dragging. */\n  --jp-private-horizontal-tab-height: 24px;\n  --jp-private-horizontal-tab-width: 216px;\n  --jp-private-horizontal-tab-active-top-border: 2px;\n}\n\n/*-----------------------------------------------------------------------------\n| Tabs in the dock panel\n|----------------------------------------------------------------------------*/\n\n.lm-DockPanel-tabBar,\n.lm-TabPanel-tabBar {\n  overflow: visible;\n  color: var(--jp-ui-font-color1);\n  font-size: var(--jp-ui-font-size1);\n}\n\n.lm-DockPanel-tabBar[data-orientation='horizontal'],\n.lm-TabPanel-tabBar[data-orientation='horizontal'] {\n  min-height: calc(\n    var(--jp-private-horizontal-tab-height) + 2 * var(--jp-border-width)\n  );\n}\n\n.lm-DockPanel-tabBar[data-orientation='vertical'] {\n  min-width: 80px;\n}\n\n.lm-DockPanel-tabBar > .lm-TabBar-content,\n.lm-TabPanel-tabBar > .lm-TabBar-content {\n  align-items: flex-end;\n  min-width: 0;\n  min-height: 0;\n}\n\n.lm-DockPanel-tabBar .lm-TabBar-tab,\n.lm-TabPanel-tabBar .lm-TabBar-tab {\n  flex: 0 1 var(--jp-private-horizontal-tab-width);\n  align-items: center;\n  min-height: calc(\n    var(--jp-private-horizontal-tab-height) + 2 * var(--jp-border-width)\n  );\n  min-width: 0;\n  margin-left: calc(-1 * var(--jp-border-width));\n  line-height: var(--jp-private-horizontal-tab-height);\n  padding: 0 8px;\n  background: var(--jp-layout-color2);\n  border: var(--jp-border-width) solid var(--jp-border-color1);\n  border-bottom: none;\n  position: relative;\n}\n\n.lm-DockPanel-tabBar .lm-TabBar-tab:focus-visible,\n.lm-DockPanel-tabBar .lm-TabBar-addButton:focus-visible,\n.lm-TabPanel-tabBar .lm-TabBar-tab:focus-visible {\n  border: 1px solid var(--accent-fill-focus);\n  border-bottom: none;\n\n  /* Thicken the border by 1px within the element border */\n  box-shadow: 0 0 0 1px inset var(--accent-fill-focus);\n  outline: none;\n}\n\n.lm-DockPanel-tabBar .lm-TabBar-tab:not(.lm-mod-current):focus-visible::after,\n.lm-TabPanel-tabBar .lm-TabBar-tab:not(.lm-mod-current):focus-visible::after {\n  border-bottom-color: var(--accent-fill-focus);\n}\n\n.lm-DockPanel-tabBar .lm-TabBar-tab:hover:not(.lm-mod-current),\n.lm-TabPanel-tabBar .lm-TabBar-tab:hover:not(.lm-mod-current) {\n  background: var(--jp-layout-color1);\n  color: var(--jp-ui-font-color1);\n}\n\n.lm-DockPanel-tabBar .lm-TabBar-tab:not(.lm-mod-current)::after,\n.lm-DockPanel-tabBar .lm-TabBar-addButton::after {\n  position: absolute;\n  content: '';\n  bottom: 0;\n  left: calc(-1 * var(--jp-border-width));\n  width: calc(100% + 2 * var(--jp-border-width));\n  border-bottom: var(--jp-border-width) solid var(--jp-border-color1);\n}\n\n.lm-DockPanel-tabBar .lm-TabBar-tab:first-child,\n.lm-TabPanel-tabBar .lm-TabBar-tab:first-child {\n  margin-left: 0;\n}\n\n/* This is a current tab of a tab bar in the dock panel: each tab bar has 1. */\n.lm-DockPanel-tabBar .lm-TabBar-tab.lm-mod-current {\n  background: var(--jp-layout-color1);\n  color: var(--jp-ui-font-color1);\n}\n\n.lm-TabPanel-tabBar .lm-TabBar-tab.lm-mod-current {\n  background: var(--jp-layout-color1);\n  color: var(--jp-ui-font-color1);\n}\n\n/* This is the main application level current tab: only 1 exists. */\n.lm-DockPanel-tabBar .lm-TabBar-tab.jp-mod-current::before {\n  position: absolute;\n  top: calc(-1 * var(--jp-border-width) + 1px);\n  left: calc(-1 * var(--jp-border-width));\n  content: '';\n  height: var(--jp-private-horizontal-tab-active-top-border);\n  width: calc(100% + 2 * var(--jp-border-width));\n  background: var(--jp-brand-color1);\n}\n\n/* This is the left tab bar current tab: only 1 exists. */\n.lm-TabBar-tab.lm-mod-current {\n  background: var(--jp-layout-color1);\n  color: var(--jp-ui-font-color1);\n}\n\n.lm-DockPanel-tabBar .lm-TabBar.lm-mod-left .lm-TabBar-tab,\n.lm-DockPanel-tabBar .lm-TabBar.lm-mod-right .lm-TabBar-tab {\n  flex: 0 1 40px;\n  margin-top: -1px;\n  line-height: 40px;\n}\n\n.lm-DockPanel-tabBar .lm-TabBar.lm-mod-left .lm-TabBar-tab {\n  border-right: none;\n}\n\n.lm-DockPanel-tabBar .lm-TabBar.lm-mod-right .lm-TabBar-tab {\n  border-left: none;\n}\n\n.lm-DockPanel-tabBar .lm-TabBar.lm-mod-left .lm-TabBar-tab:first-child,\n.lm-DockPanel-tabBar .lm-TabBar.lm-mod-right .lm-TabBar-tab:first-child {\n  margin-top: 0;\n}\n\n/* stylelint-disable selector-max-class */\n\n.lm-DockPanel-tabBar .lm-TabBar.lm-mod-left .lm-TabBar-tab.lm-mod-current,\n.lm-DockPanel-tabBar .lm-TabBar.lm-mod-right .lm-TabBar-tab.lm-mod-current {\n  min-width: 80px;\n  max-width: 80px;\n}\n\n.lm-DockPanel-tabBar .lm-TabBar.lm-mod-right .lm-TabBar-tab.lm-mod-current {\n  transform: translateX(-1px);\n}\n\n.lm-DockPanel-tabBar .lm-TabBar-tab .lm-TabBar-tabIcon,\n.lm-TabBar-tab.lm-mod-drag-image .lm-TabBar-tabIcon,\n.lm-TabPanel-tabBar .lm-TabBar-tab .lm-TabBar-tabIcon {\n  width: 14px;\n  background-position: left center;\n  background-repeat: no-repeat;\n  background-size: 14px;\n  margin-right: 4px;\n}\n\n/* stylelint-enable selector-max-class */\n\n.lm-TabBar-tab.lm-mod-drag-image {\n  background: var(--jp-layout-color1);\n  color: var(--jp-ui-font-color1);\n  border: var(--jp-border-width) solid var(--jp-border-color1);\n  border-top: var(--jp-border-width) solid var(--jp-brand-color1);\n  box-shadow: var(--jp-elevation-z4);\n  font-size: var(--jp-ui-font-size1);\n  line-height: var(--jp-private-horizontal-tab-height);\n  min-height: var(--jp-private-horizontal-tab-height);\n  min-width: var(--jp-private-horizontal-tab-width);\n  padding: 0 10px;\n  transform: translateX(-40%) translateY(-58%);\n}\n"],"sourceRoot":""}]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ 61059:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Z: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(82971);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(11368);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
// Imports


var ___CSS_LOADER_EXPORT___ = _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default()));
// Module
___CSS_LOADER_EXPORT___.push([module.id, `/*-----------------------------------------------------------------------------
| Copyright (c) Jupyter Development Team.
| Distributed under the terms of the Modified BSD License.
|----------------------------------------------------------------------------*/

:root {
  --jp-private-title-panel-height: 28px;
}

#jp-title-panel {
  min-height: var(--jp-private-title-panel-height);
  width: 100%;
  display: flex;
  background: var(--jp-layout-color1);
}

#jp-title-panel-title {
  flex: 1 1 auto;
  margin-left: 8px;
}

#jp-title-panel-title input {
  background: transparent;
  margin: 0;
  height: 28px;
  width: 100%;
  box-sizing: border-box;
  border: none;
  font-size: 18px;
  font-weight: normal;
  font-family: var(--jp-ui-font-family);
  line-height: var(--jp-private-title-panel-height);
  color: var(--jp-ui-font-color0);
  outline: none;
  appearance: none;
  -webkit-appearance: none;
  -moz-appearance: none;
}
`, "",{"version":3,"sources":["webpack://./../node_modules/@jupyterlab/application/style/titlepanel.css"],"names":[],"mappings":"AAAA;;;8EAG8E;;AAE9E;EACE,qCAAqC;AACvC;;AAEA;EACE,gDAAgD;EAChD,WAAW;EACX,aAAa;EACb,mCAAmC;AACrC;;AAEA;EACE,cAAc;EACd,gBAAgB;AAClB;;AAEA;EACE,uBAAuB;EACvB,SAAS;EACT,YAAY;EACZ,WAAW;EACX,sBAAsB;EACtB,YAAY;EACZ,eAAe;EACf,mBAAmB;EACnB,qCAAqC;EACrC,iDAAiD;EACjD,+BAA+B;EAC/B,aAAa;EACb,gBAAgB;EAChB,wBAAwB;EACxB,qBAAqB;AACvB","sourcesContent":["/*-----------------------------------------------------------------------------\n| Copyright (c) Jupyter Development Team.\n| Distributed under the terms of the Modified BSD License.\n|----------------------------------------------------------------------------*/\n\n:root {\n  --jp-private-title-panel-height: 28px;\n}\n\n#jp-title-panel {\n  min-height: var(--jp-private-title-panel-height);\n  width: 100%;\n  display: flex;\n  background: var(--jp-layout-color1);\n}\n\n#jp-title-panel-title {\n  flex: 1 1 auto;\n  margin-left: 8px;\n}\n\n#jp-title-panel-title input {\n  background: transparent;\n  margin: 0;\n  height: 28px;\n  width: 100%;\n  box-sizing: border-box;\n  border: none;\n  font-size: 18px;\n  font-weight: normal;\n  font-family: var(--jp-ui-font-family);\n  line-height: var(--jp-private-title-panel-height);\n  color: var(--jp-ui-font-color0);\n  outline: none;\n  appearance: none;\n  -webkit-appearance: none;\n  -moz-appearance: none;\n}\n"],"sourceRoot":""}]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ 92606:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Z: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(82971);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(11368);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _builder_node_modules_css_loader_dist_cjs_js_notification_css__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(64758);
/* harmony import */ var _builder_node_modules_css_loader_dist_cjs_js_splash_css__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(92027);
/* harmony import */ var _builder_node_modules_css_loader_dist_cjs_js_contextualhelp_css__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(59177);
// Imports





var ___CSS_LOADER_EXPORT___ = _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default()));
___CSS_LOADER_EXPORT___.i(_builder_node_modules_css_loader_dist_cjs_js_notification_css__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z);
___CSS_LOADER_EXPORT___.i(_builder_node_modules_css_loader_dist_cjs_js_splash_css__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z);
___CSS_LOADER_EXPORT___.i(_builder_node_modules_css_loader_dist_cjs_js_contextualhelp_css__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z);
// Module
___CSS_LOADER_EXPORT___.push([module.id, `/*-----------------------------------------------------------------------------
| Copyright (c) Jupyter Development Team.
| Distributed under the terms of the Modified BSD License.
|----------------------------------------------------------------------------*/
`, "",{"version":3,"sources":["webpack://./../node_modules/@jupyterlab/apputils-extension/style/base.css"],"names":[],"mappings":"AAAA;;;8EAG8E","sourcesContent":["/*-----------------------------------------------------------------------------\n| Copyright (c) Jupyter Development Team.\n| Distributed under the terms of the Modified BSD License.\n|----------------------------------------------------------------------------*/\n\n@import './notification.css';\n@import './splash.css';\n@import './contextualhelp.css';\n"],"sourceRoot":""}]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ 59177:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Z: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(82971);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(11368);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
// Imports


var ___CSS_LOADER_EXPORT___ = _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default()));
// Module
___CSS_LOADER_EXPORT___.push([module.id, `/*
 * Copyright (c) Jupyter Development Team.
 * Distributed under the terms of the Modified BSD License.
 */

:root {
  --jp-private-shortcuts-key-padding-horizontal: 0.47em;
  --jp-private-shortcuts-key-padding-vertical: 0.28em;
  --jp-private-shortcuts-label-padding-horizontal: 0.47em;
}

.jp-ContextualShortcut-TableRow {
  font-size: var(--jp-ui-font-size1);
  font-family: var(--jp-ui-font-family);
}

.jp-ContextualShortcut-TableItem {
  margin-left: auto;
  margin-right: auto;
  color: var(--jp-inverse-layout-color0);
  font-size: var(--jp-ui-font-size1);
  line-height: 2em;
  padding-right: var(--jp-private-shortcuts-label-padding-horizontal);
}

.jp-ContextualShortcut-TableLastRow {
  height: 2em;
}

.jp-ContextualShortcut-Key {
  font-family: var(--jp-code-font-family);
  border-width: var(--jp-border-width);
  border-radius: var(--jp-border-radius);
  border-style: solid;
  border-color: var(--jp-border-color1);
  color: var(--jp-ui-font-color1);
  background: var(--jp-layout-color1);
  padding-left: var(--jp-private-shortcuts-key-padding-horizontal);
  padding-right: var(--jp-private-shortcuts-key-padding-horizontal);
  padding-top: var(--jp-private-shortcuts-key-padding-vertical);
  padding-bottom: var(--jp-private-shortcuts-key-padding-vertical);
}
`, "",{"version":3,"sources":["webpack://./../node_modules/@jupyterlab/apputils-extension/style/contextualhelp.css"],"names":[],"mappings":"AAAA;;;EAGE;;AAEF;EACE,qDAAqD;EACrD,mDAAmD;EACnD,uDAAuD;AACzD;;AAEA;EACE,kCAAkC;EAClC,qCAAqC;AACvC;;AAEA;EACE,iBAAiB;EACjB,kBAAkB;EAClB,sCAAsC;EACtC,kCAAkC;EAClC,gBAAgB;EAChB,mEAAmE;AACrE;;AAEA;EACE,WAAW;AACb;;AAEA;EACE,uCAAuC;EACvC,oCAAoC;EACpC,sCAAsC;EACtC,mBAAmB;EACnB,qCAAqC;EACrC,+BAA+B;EAC/B,mCAAmC;EACnC,gEAAgE;EAChE,iEAAiE;EACjE,6DAA6D;EAC7D,gEAAgE;AAClE","sourcesContent":["/*\n * Copyright (c) Jupyter Development Team.\n * Distributed under the terms of the Modified BSD License.\n */\n\n:root {\n  --jp-private-shortcuts-key-padding-horizontal: 0.47em;\n  --jp-private-shortcuts-key-padding-vertical: 0.28em;\n  --jp-private-shortcuts-label-padding-horizontal: 0.47em;\n}\n\n.jp-ContextualShortcut-TableRow {\n  font-size: var(--jp-ui-font-size1);\n  font-family: var(--jp-ui-font-family);\n}\n\n.jp-ContextualShortcut-TableItem {\n  margin-left: auto;\n  margin-right: auto;\n  color: var(--jp-inverse-layout-color0);\n  font-size: var(--jp-ui-font-size1);\n  line-height: 2em;\n  padding-right: var(--jp-private-shortcuts-label-padding-horizontal);\n}\n\n.jp-ContextualShortcut-TableLastRow {\n  height: 2em;\n}\n\n.jp-ContextualShortcut-Key {\n  font-family: var(--jp-code-font-family);\n  border-width: var(--jp-border-width);\n  border-radius: var(--jp-border-radius);\n  border-style: solid;\n  border-color: var(--jp-border-color1);\n  color: var(--jp-ui-font-color1);\n  background: var(--jp-layout-color1);\n  padding-left: var(--jp-private-shortcuts-key-padding-horizontal);\n  padding-right: var(--jp-private-shortcuts-key-padding-horizontal);\n  padding-top: var(--jp-private-shortcuts-key-padding-vertical);\n  padding-bottom: var(--jp-private-shortcuts-key-padding-vertical);\n}\n"],"sourceRoot":""}]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ 64758:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Z: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(82971);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(11368);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _builder_node_modules_css_loader_dist_cjs_js_react_toastify_dist_ReactToastify_min_css__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(96715);
// Imports



var ___CSS_LOADER_EXPORT___ = _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default()));
___CSS_LOADER_EXPORT___.i(_builder_node_modules_css_loader_dist_cjs_js_react_toastify_dist_ReactToastify_min_css__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z);
// Module
___CSS_LOADER_EXPORT___.push([module.id, `/*
 * Copyright (c) Jupyter Development Team.
 * Distributed under the terms of the Modified BSD License.
 */

:root {
  --toastify-color-light: var(--jp-layout-color1);
  --toastify-color-dark: var(--jp-layout-color1);
  --toastify-color-info: var(--jp-info-color1);
  --toastify-color-success: var(--jp-success-color1);
  --toastify-color-warning: var(--jp-warn-color1);
  --toastify-color-error: var(--jp-error-color1);
  --toastify-color-transparent: rgba(255, 255, 255, 0.7);
  --toastify-icon-color-info: var(--toastify-color-info);
  --toastify-icon-color-success: var(--toastify-color-success);
  --toastify-icon-color-warning: var(--toastify-color-warning);
  --toastify-icon-color-error: var(--toastify-color-error);
  --toastify-toast-width: 25em;
  --toastify-toast-background: var(--jp-layout-color1);
  --toastify-toast-min-height: 64px;
  --toastify-toast-max-height: 800px;
  --toastify-font-family: var(--jp-ui-font-family);
  --toastify-z-index: 9999;
  --toastify-text-color-light: var(--jp-ui-font-color1);
  --toastify-text-color-dark: var(--jp-ui-font-color1);
  --toastify-text-color-info: var(--jp-ui-font-color1);
  --toastify-text-color-success: var(--jp-ui-font-color1);
  --toastify-text-color-warning: var(--jp-ui-font-color1);
  --toastify-text-color-error: var(--jp-ui-font-color1);
  --toastify-spinner-color: #616161;
  --toastify-spinner-color-empty-area: #e0e0e0;
  --toastify-color-progress-light: linear-gradient(
    to right,
    #4cd964,
    #5ac8fa,
    #007aff,
    #34aadc,
    #5856d6,
    #ff2d55
  );
  --toastify-color-progress-dark: #bb86fc;
  --toastify-color-progress-info: var(--toastify-color-info);
  --toastify-color-progress-success: var(--toastify-color-success);
  --toastify-color-progress-warning: var(--toastify-color-warning);
  --toastify-color-progress-error: var(--toastify-color-error);
}

.jp-Notification-List {
  list-style: none;
  margin: 0;
  padding: 4px;
  width: var(--toastify-toast-width);
  overflow-y: auto;
  max-height: 55vh;
  box-sizing: border-box;
  background-color: var(--jp-layout-color2);
}

.jp-Notification-Header {
  display: flex;
  font-size: var(--jp-ui-font-size1);
  padding-left: 8px;
  padding-right: 4px;
  margin: 0;
  align-items: center;
  user-select: none;
}

.jp-Notification-List-Item {
  padding: 2px 0;
}

.jp-Notification-List .Toastify__toast {
  margin: 0;
}

.jp-Notification-Status.jp-mod-selected {
  background-color: var(--jp-brand-color1);
}

.jp-Notification-Status.jp-mod-selected .jp-Notification-Status-Text {
  color: var(--jp-ui-inverse-font-color1);
}

.Toastify__toast {
  min-height: unset;
  padding: 4px;
  font-size: var(--jp-ui-font-size1);
  border-width: var(--jp-border-width);
  border-radius: var(--jp-border-radius);
  border-color: var(--jp-border-color1);
  box-shadow: var(--jp-elevation-z4);
  cursor: default;
}

.Toastify__toast-body {
  display: flex;
  flex-grow: 1;
}

.jp-Notification-Toast-Close {
  padding: 0;
  position: absolute;
  right: 0.1px;
  cursor: pointer;
}

.jp-Notification-Toast-Close-Margin {
  margin-right: 4px;
}

.jp-toastContainer .jp-Notification-Toast-Close:hover {
  /* The close button has its own hover style */
  background: none;
}

.Toastify__toast.jp-Notification-Toast-error {
  border-top: 5px solid var(--jp-error-color1);
}

.Toastify__toast.jp-Notification-Toast-warning {
  border-top: 5px solid var(--jp-warn-color1);
}

.Toastify__toast.jp-Notification-Toast-info {
  border-top: 5px solid var(--jp-info-color1);
}

.Toastify__toast.jp-Notification-Toast-success {
  border-top: 5px solid var(--jp-success-color1);
}

.Toastify__toast.jp-Notification-Toast-in-progress {
  border-top: 5px solid var(--jp-layout-color1);
}

.Toastify__toast-body a {
  color: var(--jp-content-link-color);
}

.Toastify__toast-body a:hover {
  color: var(--jp-content-link-color);
  text-decoration: underline;
}

.jp-toast-message {
  padding-inline-end: 16px;
}

/* p elements are added by the markdown rendering.
 * Removing its default margin allows to reduce toast size.
 */
.Toastify__toast-body p:first-child,
.Toastify__toast-body h1:first-child,
.Toastify__toast-body h2:first-child,
.Toastify__toast-body h3:first-child,
.Toastify__toast-body h4:first-child,
.Toastify__toast-body h5:first-child,
.Toastify__toast-body h6:first-child,
.Toastify__toast-body ol:first-child,
.Toastify__toast-body ul:first-child {
  margin-top: 0;
}

.Toastify__toast-body p:last-child,
.Toastify__toast-body h1:last-child,
.Toastify__toast-body h2:last-child,
.Toastify__toast-body h3:last-child,
.Toastify__toast-body h4:last-child,
.Toastify__toast-body h5:last-child,
.Toastify__toast-body h6:last-child,
.Toastify__toast-body ol:last-child,
.Toastify__toast-body ul:last-child {
  margin-bottom: 0;
}

.jp-toast-buttonBar {
  display: flex;
  flex-direction: row;
  flex-wrap: nowrap;
  flex: 0 0 auto;
  padding-block-start: 8px;
}

.jp-toast-spacer {
  flex-grow: 1;
  flex-shrink: 1;
}

.jp-toast-button {
  margin-top: 1px;
  margin-bottom: 1px;
  margin-right: 0;
  margin-left: 3px;
  color: var(--jp-ui-font-color1);
  background-color: var(--jp-layout-color2);
  border: none;
}

.jp-toast-button:focus {
  outline: 1px solid var(--jp-reject-color-normal, var(--jp-layout-color2));
  outline-offset: 1px;
  -moz-outline-radius: 0;
}

.jp-toast-button:focus-visible {
  border: none;
}

.jp-toast-button:hover {
  background-color: var(--jp-layout-color3);
}

.jp-toast-button.jp-mod-accept {
  background: var(--jp-accept-color-normal, var(--jp-brand-color1));
  color: var(--jp-ui-inverse-font-color1);
}

.jp-toast-button.jp-mod-accept:focus {
  outline-color: var(--jp-accept-color-normal, var(--jp-brand-color1));
}

.jp-toast-button.jp-mod-accept:hover {
  background: var(--jp-accept-color-hover, var(--jp-brand-color0));
}

.jp-toast-button.jp-mod-warn {
  background: var(--jp-warn-color-normal, var(--jp-warn-color1));
  color: var(--jp-ui-inverse-font-color1);
}

.jp-toast-button.jp-mod-warn:focus {
  outline-color: var(--jp-warn-color-normal, var(--jp-warn-color1));
}

.jp-toast-button.jp-mod-warn:hover {
  background: var(--jp-warn-color-hover, var(--jp-warn-color0));
}

.jp-toast-button.jp-mod-link {
  color: var(--jp-content-link-color);
  text-decoration: underline;
  text-decoration-color: var(--jp-content-link-color);
}
`, "",{"version":3,"sources":["webpack://./../node_modules/@jupyterlab/apputils-extension/style/notification.css"],"names":[],"mappings":"AAAA;;;EAGE;;AAIF;EACE,+CAA+C;EAC/C,8CAA8C;EAC9C,4CAA4C;EAC5C,kDAAkD;EAClD,+CAA+C;EAC/C,8CAA8C;EAC9C,sDAAsD;EACtD,sDAAsD;EACtD,4DAA4D;EAC5D,4DAA4D;EAC5D,wDAAwD;EACxD,4BAA4B;EAC5B,oDAAoD;EACpD,iCAAiC;EACjC,kCAAkC;EAClC,gDAAgD;EAChD,wBAAwB;EACxB,qDAAqD;EACrD,oDAAoD;EACpD,oDAAoD;EACpD,uDAAuD;EACvD,uDAAuD;EACvD,qDAAqD;EACrD,iCAAiC;EACjC,4CAA4C;EAC5C;;;;;;;;GAQC;EACD,uCAAuC;EACvC,0DAA0D;EAC1D,gEAAgE;EAChE,gEAAgE;EAChE,4DAA4D;AAC9D;;AAEA;EACE,gBAAgB;EAChB,SAAS;EACT,YAAY;EACZ,kCAAkC;EAClC,gBAAgB;EAChB,gBAAgB;EAChB,sBAAsB;EACtB,yCAAyC;AAC3C;;AAEA;EACE,aAAa;EACb,kCAAkC;EAClC,iBAAiB;EACjB,kBAAkB;EAClB,SAAS;EACT,mBAAmB;EACnB,iBAAiB;AACnB;;AAEA;EACE,cAAc;AAChB;;AAEA;EACE,SAAS;AACX;;AAEA;EACE,wCAAwC;AAC1C;;AAEA;EACE,uCAAuC;AACzC;;AAEA;EACE,iBAAiB;EACjB,YAAY;EACZ,kCAAkC;EAClC,oCAAoC;EACpC,sCAAsC;EACtC,qCAAqC;EACrC,kCAAkC;EAClC,eAAe;AACjB;;AAEA;EACE,aAAa;EACb,YAAY;AACd;;AAEA;EACE,UAAU;EACV,kBAAkB;EAClB,YAAY;EACZ,eAAe;AACjB;;AAEA;EACE,iBAAiB;AACnB;;AAEA;EACE,6CAA6C;EAC7C,gBAAgB;AAClB;;AAEA;EACE,4CAA4C;AAC9C;;AAEA;EACE,2CAA2C;AAC7C;;AAEA;EACE,2CAA2C;AAC7C;;AAEA;EACE,8CAA8C;AAChD;;AAEA;EACE,6CAA6C;AAC/C;;AAEA;EACE,mCAAmC;AACrC;;AAEA;EACE,mCAAmC;EACnC,0BAA0B;AAC5B;;AAEA;EACE,wBAAwB;AAC1B;;AAEA;;EAEE;AACF;;;;;;;;;EASE,aAAa;AACf;;AAEA;;;;;;;;;EASE,gBAAgB;AAClB;;AAEA;EACE,aAAa;EACb,mBAAmB;EACnB,iBAAiB;EACjB,cAAc;EACd,wBAAwB;AAC1B;;AAEA;EACE,YAAY;EACZ,cAAc;AAChB;;AAEA;EACE,eAAe;EACf,kBAAkB;EAClB,eAAe;EACf,gBAAgB;EAChB,+BAA+B;EAC/B,yCAAyC;EACzC,YAAY;AACd;;AAEA;EACE,yEAAyE;EACzE,mBAAmB;EACnB,sBAAsB;AACxB;;AAEA;EACE,YAAY;AACd;;AAEA;EACE,yCAAyC;AAC3C;;AAEA;EACE,iEAAiE;EACjE,uCAAuC;AACzC;;AAEA;EACE,oEAAoE;AACtE;;AAEA;EACE,gEAAgE;AAClE;;AAEA;EACE,8DAA8D;EAC9D,uCAAuC;AACzC;;AAEA;EACE,iEAAiE;AACnE;;AAEA;EACE,6DAA6D;AAC/D;;AAEA;EACE,mCAAmC;EACnC,0BAA0B;EAC1B,mDAAmD;AACrD","sourcesContent":["/*\n * Copyright (c) Jupyter Development Team.\n * Distributed under the terms of the Modified BSD License.\n */\n\n@import '~react-toastify/dist/ReactToastify.min.css';\n\n:root {\n  --toastify-color-light: var(--jp-layout-color1);\n  --toastify-color-dark: var(--jp-layout-color1);\n  --toastify-color-info: var(--jp-info-color1);\n  --toastify-color-success: var(--jp-success-color1);\n  --toastify-color-warning: var(--jp-warn-color1);\n  --toastify-color-error: var(--jp-error-color1);\n  --toastify-color-transparent: rgba(255, 255, 255, 0.7);\n  --toastify-icon-color-info: var(--toastify-color-info);\n  --toastify-icon-color-success: var(--toastify-color-success);\n  --toastify-icon-color-warning: var(--toastify-color-warning);\n  --toastify-icon-color-error: var(--toastify-color-error);\n  --toastify-toast-width: 25em;\n  --toastify-toast-background: var(--jp-layout-color1);\n  --toastify-toast-min-height: 64px;\n  --toastify-toast-max-height: 800px;\n  --toastify-font-family: var(--jp-ui-font-family);\n  --toastify-z-index: 9999;\n  --toastify-text-color-light: var(--jp-ui-font-color1);\n  --toastify-text-color-dark: var(--jp-ui-font-color1);\n  --toastify-text-color-info: var(--jp-ui-font-color1);\n  --toastify-text-color-success: var(--jp-ui-font-color1);\n  --toastify-text-color-warning: var(--jp-ui-font-color1);\n  --toastify-text-color-error: var(--jp-ui-font-color1);\n  --toastify-spinner-color: #616161;\n  --toastify-spinner-color-empty-area: #e0e0e0;\n  --toastify-color-progress-light: linear-gradient(\n    to right,\n    #4cd964,\n    #5ac8fa,\n    #007aff,\n    #34aadc,\n    #5856d6,\n    #ff2d55\n  );\n  --toastify-color-progress-dark: #bb86fc;\n  --toastify-color-progress-info: var(--toastify-color-info);\n  --toastify-color-progress-success: var(--toastify-color-success);\n  --toastify-color-progress-warning: var(--toastify-color-warning);\n  --toastify-color-progress-error: var(--toastify-color-error);\n}\n\n.jp-Notification-List {\n  list-style: none;\n  margin: 0;\n  padding: 4px;\n  width: var(--toastify-toast-width);\n  overflow-y: auto;\n  max-height: 55vh;\n  box-sizing: border-box;\n  background-color: var(--jp-layout-color2);\n}\n\n.jp-Notification-Header {\n  display: flex;\n  font-size: var(--jp-ui-font-size1);\n  padding-left: 8px;\n  padding-right: 4px;\n  margin: 0;\n  align-items: center;\n  user-select: none;\n}\n\n.jp-Notification-List-Item {\n  padding: 2px 0;\n}\n\n.jp-Notification-List .Toastify__toast {\n  margin: 0;\n}\n\n.jp-Notification-Status.jp-mod-selected {\n  background-color: var(--jp-brand-color1);\n}\n\n.jp-Notification-Status.jp-mod-selected .jp-Notification-Status-Text {\n  color: var(--jp-ui-inverse-font-color1);\n}\n\n.Toastify__toast {\n  min-height: unset;\n  padding: 4px;\n  font-size: var(--jp-ui-font-size1);\n  border-width: var(--jp-border-width);\n  border-radius: var(--jp-border-radius);\n  border-color: var(--jp-border-color1);\n  box-shadow: var(--jp-elevation-z4);\n  cursor: default;\n}\n\n.Toastify__toast-body {\n  display: flex;\n  flex-grow: 1;\n}\n\n.jp-Notification-Toast-Close {\n  padding: 0;\n  position: absolute;\n  right: 0.1px;\n  cursor: pointer;\n}\n\n.jp-Notification-Toast-Close-Margin {\n  margin-right: 4px;\n}\n\n.jp-toastContainer .jp-Notification-Toast-Close:hover {\n  /* The close button has its own hover style */\n  background: none;\n}\n\n.Toastify__toast.jp-Notification-Toast-error {\n  border-top: 5px solid var(--jp-error-color1);\n}\n\n.Toastify__toast.jp-Notification-Toast-warning {\n  border-top: 5px solid var(--jp-warn-color1);\n}\n\n.Toastify__toast.jp-Notification-Toast-info {\n  border-top: 5px solid var(--jp-info-color1);\n}\n\n.Toastify__toast.jp-Notification-Toast-success {\n  border-top: 5px solid var(--jp-success-color1);\n}\n\n.Toastify__toast.jp-Notification-Toast-in-progress {\n  border-top: 5px solid var(--jp-layout-color1);\n}\n\n.Toastify__toast-body a {\n  color: var(--jp-content-link-color);\n}\n\n.Toastify__toast-body a:hover {\n  color: var(--jp-content-link-color);\n  text-decoration: underline;\n}\n\n.jp-toast-message {\n  padding-inline-end: 16px;\n}\n\n/* p elements are added by the markdown rendering.\n * Removing its default margin allows to reduce toast size.\n */\n.Toastify__toast-body p:first-child,\n.Toastify__toast-body h1:first-child,\n.Toastify__toast-body h2:first-child,\n.Toastify__toast-body h3:first-child,\n.Toastify__toast-body h4:first-child,\n.Toastify__toast-body h5:first-child,\n.Toastify__toast-body h6:first-child,\n.Toastify__toast-body ol:first-child,\n.Toastify__toast-body ul:first-child {\n  margin-top: 0;\n}\n\n.Toastify__toast-body p:last-child,\n.Toastify__toast-body h1:last-child,\n.Toastify__toast-body h2:last-child,\n.Toastify__toast-body h3:last-child,\n.Toastify__toast-body h4:last-child,\n.Toastify__toast-body h5:last-child,\n.Toastify__toast-body h6:last-child,\n.Toastify__toast-body ol:last-child,\n.Toastify__toast-body ul:last-child {\n  margin-bottom: 0;\n}\n\n.jp-toast-buttonBar {\n  display: flex;\n  flex-direction: row;\n  flex-wrap: nowrap;\n  flex: 0 0 auto;\n  padding-block-start: 8px;\n}\n\n.jp-toast-spacer {\n  flex-grow: 1;\n  flex-shrink: 1;\n}\n\n.jp-toast-button {\n  margin-top: 1px;\n  margin-bottom: 1px;\n  margin-right: 0;\n  margin-left: 3px;\n  color: var(--jp-ui-font-color1);\n  background-color: var(--jp-layout-color2);\n  border: none;\n}\n\n.jp-toast-button:focus {\n  outline: 1px solid var(--jp-reject-color-normal, var(--jp-layout-color2));\n  outline-offset: 1px;\n  -moz-outline-radius: 0;\n}\n\n.jp-toast-button:focus-visible {\n  border: none;\n}\n\n.jp-toast-button:hover {\n  background-color: var(--jp-layout-color3);\n}\n\n.jp-toast-button.jp-mod-accept {\n  background: var(--jp-accept-color-normal, var(--jp-brand-color1));\n  color: var(--jp-ui-inverse-font-color1);\n}\n\n.jp-toast-button.jp-mod-accept:focus {\n  outline-color: var(--jp-accept-color-normal, var(--jp-brand-color1));\n}\n\n.jp-toast-button.jp-mod-accept:hover {\n  background: var(--jp-accept-color-hover, var(--jp-brand-color0));\n}\n\n.jp-toast-button.jp-mod-warn {\n  background: var(--jp-warn-color-normal, var(--jp-warn-color1));\n  color: var(--jp-ui-inverse-font-color1);\n}\n\n.jp-toast-button.jp-mod-warn:focus {\n  outline-color: var(--jp-warn-color-normal, var(--jp-warn-color1));\n}\n\n.jp-toast-button.jp-mod-warn:hover {\n  background: var(--jp-warn-color-hover, var(--jp-warn-color0));\n}\n\n.jp-toast-button.jp-mod-link {\n  color: var(--jp-content-link-color);\n  text-decoration: underline;\n  text-decoration-color: var(--jp-content-link-color);\n}\n"],"sourceRoot":""}]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ 92027:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Z: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(82971);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(11368);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
// Imports


var ___CSS_LOADER_EXPORT___ = _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default()));
// Module
___CSS_LOADER_EXPORT___.push([module.id, `/*-----------------------------------------------------------------------------
| Copyright (c) Jupyter Development Team.
| Distributed under the terms of the Modified BSD License.
|----------------------------------------------------------------------------*/

#jupyterlab-splash {
  z-index: 10;
  position: absolute;
  overflow: hidden;
  width: 100%;
  height: 100%;
  background-position: center 40%;
  background-repeat: no-repeat;
  background-size: cover;
}

#jupyterlab-splash.light {
  background-color: white;
}

#jupyterlab-splash.dark {
  background-color: var(--md-grey-900, #212121);
}

.splash-fade {
  animation: 0.5s fade-out forwards;
}

#galaxy {
  position: relative;
  width: 100%;
  height: 100%;
}

.planet {
  background-repeat: no-repeat;
  background-size: cover;
  animation-iteration-count: infinite;
  animation-name: orbit;
}

#moon1.orbit {
  opacity: 1;
  animation: orbit 2s ease;
  width: 200px;
  height: 140px;
  margin-top: -53px;
  margin-left: -54px;
}

#moon2.orbit {
  opacity: 1;
  animation: orbit 2s ease;
  width: 132px;
  height: 180px;
  margin-top: -66px;
  margin-left: -85px;
}

#moon3.orbit {
  opacity: 1;
  display: flex;
  align-items: flex-end;
  animation: orbit 2s ease;
  width: 220px;
  height: 166px;
  margin-top: -96px;
  margin-left: -50px;
}

#moon1 .planet {
  height: 12px;
  width: 12px;
  border-radius: 50%;
}

#moon2 .planet {
  height: 16px;
  width: 16px;
  border-radius: 50%;
  float: right;
}

#moon3 .planet {
  height: 20px;
  width: 20px;
  border-radius: 50%;
}

#jupyterlab-splash.light #moon1 .planet {
  background-color: #6f7070;
}

#jupyterlab-splash.light #moon2 .planet {
  background-color: #767677;
}

#jupyterlab-splash.light #moon3 .planet {
  background-color: #989798;
}

#jupyterlab-splash.dark #moon1 .planet,
#jupyterlab-splash.dark #moon2 .planet,
#jupyterlab-splash.dark #moon3 .planet {
  background-color: white;
}

.orbit {
  animation-iteration-count: 1;
  position: absolute;
  top: 50%;
  left: 50%;
  border-radius: 50%;
}

@keyframes orbit {
  0% {
    transform: rotateZ(0deg);
  }

  100% {
    transform: rotateZ(-720deg);
  }
}

@keyframes orbit2 {
  0% {
    transform: rotateZ(0deg);
  }

  100% {
    transform: rotateZ(720deg);
  }
}

@keyframes fade-in {
  0% {
    opacity: 0;
  }

  100% {
    opacity: 1;
  }
}

@keyframes fade-out {
  0% {
    opacity: 1;
  }

  100% {
    opacity: 0;
  }
}
`, "",{"version":3,"sources":["webpack://./../node_modules/@jupyterlab/apputils-extension/style/splash.css"],"names":[],"mappings":"AAAA;;;8EAG8E;;AAE9E;EACE,WAAW;EACX,kBAAkB;EAClB,gBAAgB;EAChB,WAAW;EACX,YAAY;EACZ,+BAA+B;EAC/B,4BAA4B;EAC5B,sBAAsB;AACxB;;AAEA;EACE,uBAAuB;AACzB;;AAEA;EACE,6CAA6C;AAC/C;;AAEA;EACE,iCAAiC;AACnC;;AAEA;EACE,kBAAkB;EAClB,WAAW;EACX,YAAY;AACd;;AAEA;EACE,4BAA4B;EAC5B,sBAAsB;EACtB,mCAAmC;EACnC,qBAAqB;AACvB;;AAEA;EACE,UAAU;EACV,wBAAwB;EACxB,YAAY;EACZ,aAAa;EACb,iBAAiB;EACjB,kBAAkB;AACpB;;AAEA;EACE,UAAU;EACV,wBAAwB;EACxB,YAAY;EACZ,aAAa;EACb,iBAAiB;EACjB,kBAAkB;AACpB;;AAEA;EACE,UAAU;EACV,aAAa;EACb,qBAAqB;EACrB,wBAAwB;EACxB,YAAY;EACZ,aAAa;EACb,iBAAiB;EACjB,kBAAkB;AACpB;;AAEA;EACE,YAAY;EACZ,WAAW;EACX,kBAAkB;AACpB;;AAEA;EACE,YAAY;EACZ,WAAW;EACX,kBAAkB;EAClB,YAAY;AACd;;AAEA;EACE,YAAY;EACZ,WAAW;EACX,kBAAkB;AACpB;;AAEA;EACE,yBAAyB;AAC3B;;AAEA;EACE,yBAAyB;AAC3B;;AAEA;EACE,yBAAyB;AAC3B;;AAEA;;;EAGE,uBAAuB;AACzB;;AAEA;EACE,4BAA4B;EAC5B,kBAAkB;EAClB,QAAQ;EACR,SAAS;EACT,kBAAkB;AACpB;;AAEA;EACE;IACE,wBAAwB;EAC1B;;EAEA;IACE,2BAA2B;EAC7B;AACF;;AAEA;EACE;IACE,wBAAwB;EAC1B;;EAEA;IACE,0BAA0B;EAC5B;AACF;;AAEA;EACE;IACE,UAAU;EACZ;;EAEA;IACE,UAAU;EACZ;AACF;;AAEA;EACE;IACE,UAAU;EACZ;;EAEA;IACE,UAAU;EACZ;AACF","sourcesContent":["/*-----------------------------------------------------------------------------\n| Copyright (c) Jupyter Development Team.\n| Distributed under the terms of the Modified BSD License.\n|----------------------------------------------------------------------------*/\n\n#jupyterlab-splash {\n  z-index: 10;\n  position: absolute;\n  overflow: hidden;\n  width: 100%;\n  height: 100%;\n  background-position: center 40%;\n  background-repeat: no-repeat;\n  background-size: cover;\n}\n\n#jupyterlab-splash.light {\n  background-color: white;\n}\n\n#jupyterlab-splash.dark {\n  background-color: var(--md-grey-900, #212121);\n}\n\n.splash-fade {\n  animation: 0.5s fade-out forwards;\n}\n\n#galaxy {\n  position: relative;\n  width: 100%;\n  height: 100%;\n}\n\n.planet {\n  background-repeat: no-repeat;\n  background-size: cover;\n  animation-iteration-count: infinite;\n  animation-name: orbit;\n}\n\n#moon1.orbit {\n  opacity: 1;\n  animation: orbit 2s ease;\n  width: 200px;\n  height: 140px;\n  margin-top: -53px;\n  margin-left: -54px;\n}\n\n#moon2.orbit {\n  opacity: 1;\n  animation: orbit 2s ease;\n  width: 132px;\n  height: 180px;\n  margin-top: -66px;\n  margin-left: -85px;\n}\n\n#moon3.orbit {\n  opacity: 1;\n  display: flex;\n  align-items: flex-end;\n  animation: orbit 2s ease;\n  width: 220px;\n  height: 166px;\n  margin-top: -96px;\n  margin-left: -50px;\n}\n\n#moon1 .planet {\n  height: 12px;\n  width: 12px;\n  border-radius: 50%;\n}\n\n#moon2 .planet {\n  height: 16px;\n  width: 16px;\n  border-radius: 50%;\n  float: right;\n}\n\n#moon3 .planet {\n  height: 20px;\n  width: 20px;\n  border-radius: 50%;\n}\n\n#jupyterlab-splash.light #moon1 .planet {\n  background-color: #6f7070;\n}\n\n#jupyterlab-splash.light #moon2 .planet {\n  background-color: #767677;\n}\n\n#jupyterlab-splash.light #moon3 .planet {\n  background-color: #989798;\n}\n\n#jupyterlab-splash.dark #moon1 .planet,\n#jupyterlab-splash.dark #moon2 .planet,\n#jupyterlab-splash.dark #moon3 .planet {\n  background-color: white;\n}\n\n.orbit {\n  animation-iteration-count: 1;\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  border-radius: 50%;\n}\n\n@keyframes orbit {\n  0% {\n    transform: rotateZ(0deg);\n  }\n\n  100% {\n    transform: rotateZ(-720deg);\n  }\n}\n\n@keyframes orbit2 {\n  0% {\n    transform: rotateZ(0deg);\n  }\n\n  100% {\n    transform: rotateZ(720deg);\n  }\n}\n\n@keyframes fade-in {\n  0% {\n    opacity: 0;\n  }\n\n  100% {\n    opacity: 1;\n  }\n}\n\n@keyframes fade-out {\n  0% {\n    opacity: 1;\n  }\n\n  100% {\n    opacity: 0;\n  }\n}\n"],"sourceRoot":""}]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ 11997:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Z: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(82971);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(11368);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _builder_node_modules_css_loader_dist_cjs_js_commandpalette_css__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(23396);
/* harmony import */ var _builder_node_modules_css_loader_dist_cjs_js_dialog_css__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(97465);
/* harmony import */ var _builder_node_modules_css_loader_dist_cjs_js_inputdialog_css__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(57035);
/* harmony import */ var _builder_node_modules_css_loader_dist_cjs_js_licenses_css__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(87134);
/* harmony import */ var _builder_node_modules_css_loader_dist_cjs_js_mainareawidget_css__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(117);
/* harmony import */ var _builder_node_modules_css_loader_dist_cjs_js_materialcolors_css__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(95714);
/* harmony import */ var _builder_node_modules_css_loader_dist_cjs_js_toolbar_css__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(36972);
// Imports









var ___CSS_LOADER_EXPORT___ = _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default()));
___CSS_LOADER_EXPORT___.i(_builder_node_modules_css_loader_dist_cjs_js_commandpalette_css__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z);
___CSS_LOADER_EXPORT___.i(_builder_node_modules_css_loader_dist_cjs_js_dialog_css__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z);
___CSS_LOADER_EXPORT___.i(_builder_node_modules_css_loader_dist_cjs_js_inputdialog_css__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z);
___CSS_LOADER_EXPORT___.i(_builder_node_modules_css_loader_dist_cjs_js_licenses_css__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z);
___CSS_LOADER_EXPORT___.i(_builder_node_modules_css_loader_dist_cjs_js_mainareawidget_css__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .Z);
___CSS_LOADER_EXPORT___.i(_builder_node_modules_css_loader_dist_cjs_js_materialcolors_css__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .Z);
___CSS_LOADER_EXPORT___.i(_builder_node_modules_css_loader_dist_cjs_js_toolbar_css__WEBPACK_IMPORTED_MODULE_8__/* ["default"] */ .Z);
// Module
___CSS_LOADER_EXPORT___.push([module.id, `/*-----------------------------------------------------------------------------
| Copyright (c) Jupyter Development Team.
| Distributed under the terms of the Modified BSD License.
|----------------------------------------------------------------------------*/
`, "",{"version":3,"sources":["webpack://./../node_modules/@jupyterlab/apputils/style/base.css"],"names":[],"mappings":"AAAA;;;8EAG8E","sourcesContent":["/*-----------------------------------------------------------------------------\n| Copyright (c) Jupyter Development Team.\n| Distributed under the terms of the Modified BSD License.\n|----------------------------------------------------------------------------*/\n\n@import './commandpalette.css';\n@import './dialog.css';\n@import './inputdialog.css';\n@import './licenses.css';\n@import './mainareawidget.css';\n@import './materialcolors.css';\n@import './toolbar.css';\n"],"sourceRoot":""}]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ 23396:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Z: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(82971);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(11368);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
// Imports


var ___CSS_LOADER_EXPORT___ = _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default()));
// Module
___CSS_LOADER_EXPORT___.push([module.id, `/*-----------------------------------------------------------------------------
| Copyright (c) Jupyter Development Team.
| Distributed under the terms of the Modified BSD License.
|----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------
| Variables
|----------------------------------------------------------------------------*/

:root {
  --jp-private-commandpalette-search-height: 28px;
}

/*-----------------------------------------------------------------------------
| Overall styles
|----------------------------------------------------------------------------*/

.lm-CommandPalette {
  padding-bottom: 0;
  color: var(--jp-ui-font-color1);
  background: var(--jp-layout-color1);

  /* This is needed so that all font sizing of children done in ems is
   * relative to this base size */
  font-size: var(--jp-ui-font-size1);
}

/*-----------------------------------------------------------------------------
| Modal variant
|----------------------------------------------------------------------------*/

.jp-ModalCommandPalette.jp-ThemedContainer {
  position: absolute;
  z-index: 10000;
  top: 38px;
  left: 30%;
  margin: 0;
  padding: 4px;
  width: 40%;
  box-shadow: var(--jp-elevation-z4);
  border-radius: 4px;
  background: var(--jp-layout-color0);
}

.jp-ModalCommandPalette .lm-CommandPalette {
  max-height: 40vh;
}

.jp-ModalCommandPalette .lm-CommandPalette .lm-close-icon::after {
  display: none;
}

.jp-ModalCommandPalette .lm-CommandPalette .lm-CommandPalette-header {
  display: none;
}

.jp-ModalCommandPalette .lm-CommandPalette .lm-CommandPalette-item {
  margin-left: 4px;
  margin-right: 4px;
}

.jp-ModalCommandPalette
  .lm-CommandPalette
  .lm-CommandPalette-item.lm-mod-disabled {
  display: none;
}

/*-----------------------------------------------------------------------------
| Search
|----------------------------------------------------------------------------*/

.lm-CommandPalette-search {
  padding: 4px;
  background-color: var(--jp-layout-color1);
  z-index: 2;
}

.lm-CommandPalette-wrapper {
  /* stylelint-disable-next-line csstree/validator */
  overflow: overlay;
  padding: 0 9px;
  background-color: var(--jp-input-active-background);
  height: 30px;
  box-shadow: inset 0 0 0 var(--jp-border-width) var(--jp-input-border-color);
}

.lm-CommandPalette.lm-mod-focused .lm-CommandPalette-wrapper {
  box-shadow:
    inset 0 0 0 1px var(--jp-input-active-box-shadow-color),
    inset 0 0 0 3px var(--jp-input-active-box-shadow-color);
}

.jp-SearchIconGroup {
  color: white;
  background-color: var(--jp-brand-color1);
  position: absolute;
  top: 4px;
  right: 4px;
  padding: 5px 5px 1px;
}

.jp-SearchIconGroup svg {
  height: 20px;
  width: 20px;
}

.jp-SearchIconGroup .jp-icon3[fill] {
  fill: var(--jp-layout-color0);
}

.lm-CommandPalette-input {
  background: transparent;
  width: calc(100% - 18px);
  float: left;
  border: none;
  outline: none;
  font-size: var(--jp-ui-font-size1);
  color: var(--jp-ui-font-color0);
  line-height: var(--jp-private-commandpalette-search-height);
}

.lm-CommandPalette-input::-webkit-input-placeholder,
.lm-CommandPalette-input::-moz-placeholder,
.lm-CommandPalette-input:-ms-input-placeholder {
  color: var(--jp-ui-font-color2);
  font-size: var(--jp-ui-font-size1);
}

/*-----------------------------------------------------------------------------
| Results
|----------------------------------------------------------------------------*/

.lm-CommandPalette-header:first-child {
  margin-top: 0;
}

.lm-CommandPalette-header {
  border-bottom: solid var(--jp-border-width) var(--jp-border-color2);
  color: var(--jp-ui-font-color1);
  cursor: pointer;
  display: flex;
  font-size: var(--jp-ui-font-size0);
  font-weight: 600;
  letter-spacing: 1px;
  margin-top: 8px;
  padding: 8px 0 8px 12px;
  text-transform: uppercase;
}

.lm-CommandPalette-header.lm-mod-active {
  background: var(--jp-layout-color2);
}

.lm-CommandPalette-header > mark {
  background-color: transparent;
  font-weight: bold;
  color: var(--jp-ui-font-color1);
}

.lm-CommandPalette-item {
  padding: 4px 12px 4px 4px;
  color: var(--jp-ui-font-color1);
  font-size: var(--jp-ui-font-size1);
  font-weight: 400;
  display: flex;
}

.lm-CommandPalette-item.lm-mod-disabled {
  color: var(--jp-ui-font-color2);
}

.lm-CommandPalette-item.lm-mod-active {
  color: var(--jp-ui-inverse-font-color1);
  background: var(--jp-brand-color1);
}

.lm-CommandPalette-item.lm-mod-active .lm-CommandPalette-itemLabel > mark {
  color: var(--jp-ui-inverse-font-color0);
}

.lm-CommandPalette-item.lm-mod-active .jp-icon-selectable[fill] {
  fill: var(--jp-layout-color0);
}

.lm-CommandPalette-item.lm-mod-active:hover:not(.lm-mod-disabled) {
  color: var(--jp-ui-inverse-font-color1);
  background: var(--jp-brand-color1);
}

.lm-CommandPalette-item:hover:not(.lm-mod-active):not(.lm-mod-disabled) {
  background: var(--jp-layout-color2);
}

.lm-CommandPalette-itemContent {
  overflow: hidden;
}

.lm-CommandPalette-itemLabel > mark {
  color: var(--jp-ui-font-color0);
  background-color: transparent;
  font-weight: bold;
}

.lm-CommandPalette-item.lm-mod-disabled mark {
  color: var(--jp-ui-font-color2);
}

.lm-CommandPalette-item .lm-CommandPalette-itemIcon {
  margin: 0 4px 0 0;
  position: relative;
  width: 16px;
  top: 2px;
  flex: 0 0 auto;
}

.lm-CommandPalette-item.lm-mod-disabled .lm-CommandPalette-itemIcon {
  opacity: 0.6;
}

.lm-CommandPalette-item .lm-CommandPalette-itemShortcut {
  flex: 0 0 auto;
}

.lm-CommandPalette-itemCaption {
  display: none;
}

.lm-CommandPalette-content {
  background-color: var(--jp-layout-color1);
}

.lm-CommandPalette-content:empty::after {
  content: 'No results';
  margin: auto;
  margin-top: 20px;
  width: 100px;
  display: block;
  font-size: var(--jp-ui-font-size2);
  font-family: var(--jp-ui-font-family);
  font-weight: lighter;
}

.lm-CommandPalette-emptyMessage {
  text-align: center;
  margin-top: 24px;
  line-height: 1.32;
  padding: 0 8px;
  color: var(--jp-content-font-color3);
}
`, "",{"version":3,"sources":["webpack://./../node_modules/@jupyterlab/apputils/style/commandpalette.css"],"names":[],"mappings":"AAAA;;;8EAG8E;;AAE9E;;8EAE8E;;AAE9E;EACE,+CAA+C;AACjD;;AAEA;;8EAE8E;;AAE9E;EACE,iBAAiB;EACjB,+BAA+B;EAC/B,mCAAmC;;EAEnC;iCAC+B;EAC/B,kCAAkC;AACpC;;AAEA;;8EAE8E;;AAE9E;EACE,kBAAkB;EAClB,cAAc;EACd,SAAS;EACT,SAAS;EACT,SAAS;EACT,YAAY;EACZ,UAAU;EACV,kCAAkC;EAClC,kBAAkB;EAClB,mCAAmC;AACrC;;AAEA;EACE,gBAAgB;AAClB;;AAEA;EACE,aAAa;AACf;;AAEA;EACE,aAAa;AACf;;AAEA;EACE,gBAAgB;EAChB,iBAAiB;AACnB;;AAEA;;;EAGE,aAAa;AACf;;AAEA;;8EAE8E;;AAE9E;EACE,YAAY;EACZ,yCAAyC;EACzC,UAAU;AACZ;;AAEA;EACE,kDAAkD;EAClD,iBAAiB;EACjB,cAAc;EACd,mDAAmD;EACnD,YAAY;EACZ,2EAA2E;AAC7E;;AAEA;EACE;;2DAEyD;AAC3D;;AAEA;EACE,YAAY;EACZ,wCAAwC;EACxC,kBAAkB;EAClB,QAAQ;EACR,UAAU;EACV,oBAAoB;AACtB;;AAEA;EACE,YAAY;EACZ,WAAW;AACb;;AAEA;EACE,6BAA6B;AAC/B;;AAEA;EACE,uBAAuB;EACvB,wBAAwB;EACxB,WAAW;EACX,YAAY;EACZ,aAAa;EACb,kCAAkC;EAClC,+BAA+B;EAC/B,2DAA2D;AAC7D;;AAEA;;;EAGE,+BAA+B;EAC/B,kCAAkC;AACpC;;AAEA;;8EAE8E;;AAE9E;EACE,aAAa;AACf;;AAEA;EACE,mEAAmE;EACnE,+BAA+B;EAC/B,eAAe;EACf,aAAa;EACb,kCAAkC;EAClC,gBAAgB;EAChB,mBAAmB;EACnB,eAAe;EACf,uBAAuB;EACvB,yBAAyB;AAC3B;;AAEA;EACE,mCAAmC;AACrC;;AAEA;EACE,6BAA6B;EAC7B,iBAAiB;EACjB,+BAA+B;AACjC;;AAEA;EACE,yBAAyB;EACzB,+BAA+B;EAC/B,kCAAkC;EAClC,gBAAgB;EAChB,aAAa;AACf;;AAEA;EACE,+BAA+B;AACjC;;AAEA;EACE,uCAAuC;EACvC,kCAAkC;AACpC;;AAEA;EACE,uCAAuC;AACzC;;AAEA;EACE,6BAA6B;AAC/B;;AAEA;EACE,uCAAuC;EACvC,kCAAkC;AACpC;;AAEA;EACE,mCAAmC;AACrC;;AAEA;EACE,gBAAgB;AAClB;;AAEA;EACE,+BAA+B;EAC/B,6BAA6B;EAC7B,iBAAiB;AACnB;;AAEA;EACE,+BAA+B;AACjC;;AAEA;EACE,iBAAiB;EACjB,kBAAkB;EAClB,WAAW;EACX,QAAQ;EACR,cAAc;AAChB;;AAEA;EACE,YAAY;AACd;;AAEA;EACE,cAAc;AAChB;;AAEA;EACE,aAAa;AACf;;AAEA;EACE,yCAAyC;AAC3C;;AAEA;EACE,qBAAqB;EACrB,YAAY;EACZ,gBAAgB;EAChB,YAAY;EACZ,cAAc;EACd,kCAAkC;EAClC,qCAAqC;EACrC,oBAAoB;AACtB;;AAEA;EACE,kBAAkB;EAClB,gBAAgB;EAChB,iBAAiB;EACjB,cAAc;EACd,oCAAoC;AACtC","sourcesContent":["/*-----------------------------------------------------------------------------\n| Copyright (c) Jupyter Development Team.\n| Distributed under the terms of the Modified BSD License.\n|----------------------------------------------------------------------------*/\n\n/*-----------------------------------------------------------------------------\n| Variables\n|----------------------------------------------------------------------------*/\n\n:root {\n  --jp-private-commandpalette-search-height: 28px;\n}\n\n/*-----------------------------------------------------------------------------\n| Overall styles\n|----------------------------------------------------------------------------*/\n\n.lm-CommandPalette {\n  padding-bottom: 0;\n  color: var(--jp-ui-font-color1);\n  background: var(--jp-layout-color1);\n\n  /* This is needed so that all font sizing of children done in ems is\n   * relative to this base size */\n  font-size: var(--jp-ui-font-size1);\n}\n\n/*-----------------------------------------------------------------------------\n| Modal variant\n|----------------------------------------------------------------------------*/\n\n.jp-ModalCommandPalette.jp-ThemedContainer {\n  position: absolute;\n  z-index: 10000;\n  top: 38px;\n  left: 30%;\n  margin: 0;\n  padding: 4px;\n  width: 40%;\n  box-shadow: var(--jp-elevation-z4);\n  border-radius: 4px;\n  background: var(--jp-layout-color0);\n}\n\n.jp-ModalCommandPalette .lm-CommandPalette {\n  max-height: 40vh;\n}\n\n.jp-ModalCommandPalette .lm-CommandPalette .lm-close-icon::after {\n  display: none;\n}\n\n.jp-ModalCommandPalette .lm-CommandPalette .lm-CommandPalette-header {\n  display: none;\n}\n\n.jp-ModalCommandPalette .lm-CommandPalette .lm-CommandPalette-item {\n  margin-left: 4px;\n  margin-right: 4px;\n}\n\n.jp-ModalCommandPalette\n  .lm-CommandPalette\n  .lm-CommandPalette-item.lm-mod-disabled {\n  display: none;\n}\n\n/*-----------------------------------------------------------------------------\n| Search\n|----------------------------------------------------------------------------*/\n\n.lm-CommandPalette-search {\n  padding: 4px;\n  background-color: var(--jp-layout-color1);\n  z-index: 2;\n}\n\n.lm-CommandPalette-wrapper {\n  /* stylelint-disable-next-line csstree/validator */\n  overflow: overlay;\n  padding: 0 9px;\n  background-color: var(--jp-input-active-background);\n  height: 30px;\n  box-shadow: inset 0 0 0 var(--jp-border-width) var(--jp-input-border-color);\n}\n\n.lm-CommandPalette.lm-mod-focused .lm-CommandPalette-wrapper {\n  box-shadow:\n    inset 0 0 0 1px var(--jp-input-active-box-shadow-color),\n    inset 0 0 0 3px var(--jp-input-active-box-shadow-color);\n}\n\n.jp-SearchIconGroup {\n  color: white;\n  background-color: var(--jp-brand-color1);\n  position: absolute;\n  top: 4px;\n  right: 4px;\n  padding: 5px 5px 1px;\n}\n\n.jp-SearchIconGroup svg {\n  height: 20px;\n  width: 20px;\n}\n\n.jp-SearchIconGroup .jp-icon3[fill] {\n  fill: var(--jp-layout-color0);\n}\n\n.lm-CommandPalette-input {\n  background: transparent;\n  width: calc(100% - 18px);\n  float: left;\n  border: none;\n  outline: none;\n  font-size: var(--jp-ui-font-size1);\n  color: var(--jp-ui-font-color0);\n  line-height: var(--jp-private-commandpalette-search-height);\n}\n\n.lm-CommandPalette-input::-webkit-input-placeholder,\n.lm-CommandPalette-input::-moz-placeholder,\n.lm-CommandPalette-input:-ms-input-placeholder {\n  color: var(--jp-ui-font-color2);\n  font-size: var(--jp-ui-font-size1);\n}\n\n/*-----------------------------------------------------------------------------\n| Results\n|----------------------------------------------------------------------------*/\n\n.lm-CommandPalette-header:first-child {\n  margin-top: 0;\n}\n\n.lm-CommandPalette-header {\n  border-bottom: solid var(--jp-border-width) var(--jp-border-color2);\n  color: var(--jp-ui-font-color1);\n  cursor: pointer;\n  display: flex;\n  font-size: var(--jp-ui-font-size0);\n  font-weight: 600;\n  letter-spacing: 1px;\n  margin-top: 8px;\n  padding: 8px 0 8px 12px;\n  text-transform: uppercase;\n}\n\n.lm-CommandPalette-header.lm-mod-active {\n  background: var(--jp-layout-color2);\n}\n\n.lm-CommandPalette-header > mark {\n  background-color: transparent;\n  font-weight: bold;\n  color: var(--jp-ui-font-color1);\n}\n\n.lm-CommandPalette-item {\n  padding: 4px 12px 4px 4px;\n  color: var(--jp-ui-font-color1);\n  font-size: var(--jp-ui-font-size1);\n  font-weight: 400;\n  display: flex;\n}\n\n.lm-CommandPalette-item.lm-mod-disabled {\n  color: var(--jp-ui-font-color2);\n}\n\n.lm-CommandPalette-item.lm-mod-active {\n  color: var(--jp-ui-inverse-font-color1);\n  background: var(--jp-brand-color1);\n}\n\n.lm-CommandPalette-item.lm-mod-active .lm-CommandPalette-itemLabel > mark {\n  color: var(--jp-ui-inverse-font-color0);\n}\n\n.lm-CommandPalette-item.lm-mod-active .jp-icon-selectable[fill] {\n  fill: var(--jp-layout-color0);\n}\n\n.lm-CommandPalette-item.lm-mod-active:hover:not(.lm-mod-disabled) {\n  color: var(--jp-ui-inverse-font-color1);\n  background: var(--jp-brand-color1);\n}\n\n.lm-CommandPalette-item:hover:not(.lm-mod-active):not(.lm-mod-disabled) {\n  background: var(--jp-layout-color2);\n}\n\n.lm-CommandPalette-itemContent {\n  overflow: hidden;\n}\n\n.lm-CommandPalette-itemLabel > mark {\n  color: var(--jp-ui-font-color0);\n  background-color: transparent;\n  font-weight: bold;\n}\n\n.lm-CommandPalette-item.lm-mod-disabled mark {\n  color: var(--jp-ui-font-color2);\n}\n\n.lm-CommandPalette-item .lm-CommandPalette-itemIcon {\n  margin: 0 4px 0 0;\n  position: relative;\n  width: 16px;\n  top: 2px;\n  flex: 0 0 auto;\n}\n\n.lm-CommandPalette-item.lm-mod-disabled .lm-CommandPalette-itemIcon {\n  opacity: 0.6;\n}\n\n.lm-CommandPalette-item .lm-CommandPalette-itemShortcut {\n  flex: 0 0 auto;\n}\n\n.lm-CommandPalette-itemCaption {\n  display: none;\n}\n\n.lm-CommandPalette-content {\n  background-color: var(--jp-layout-color1);\n}\n\n.lm-CommandPalette-content:empty::after {\n  content: 'No results';\n  margin: auto;\n  margin-top: 20px;\n  width: 100px;\n  display: block;\n  font-size: var(--jp-ui-font-size2);\n  font-family: var(--jp-ui-font-family);\n  font-weight: lighter;\n}\n\n.lm-CommandPalette-emptyMessage {\n  text-align: center;\n  margin-top: 24px;\n  line-height: 1.32;\n  padding: 0 8px;\n  color: var(--jp-content-font-color3);\n}\n"],"sourceRoot":""}]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ 97465:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Z: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(82971);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(11368);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
// Imports


var ___CSS_LOADER_EXPORT___ = _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default()));
// Module
___CSS_LOADER_EXPORT___.push([module.id, `/*-----------------------------------------------------------------------------
| Copyright (c) Jupyter Development Team.
| Distributed under the terms of the Modified BSD License.
|----------------------------------------------------------------------------*/

.jp-Dialog.jp-ThemedContainer {
  position: absolute;
  z-index: 10000;
  display: flex;
  flex-direction: column;
  align-items: center;
  justify-content: center;
  top: 0;
  left: 0;
  margin: 0;
  padding: 0;
  width: 100%;
  height: 100%;
  background: var(--jp-dialog-background);
  /* stylelint-disable */
  container-type: inline-size;
  /* stylelint-enable */
}

.jp-Dialog-content {
  display: flex;
  flex-direction: column;
  margin-left: auto;
  margin-right: auto;
  background: var(--jp-layout-color1);
  padding: 24px 24px 12px;
  min-width: 300px;
  min-height: 150px;
  max-width: 1000px;
  max-height: 500px;
  box-sizing: border-box;
  box-shadow: var(--jp-elevation-z20);
  word-wrap: break-word;
  border-radius: var(--jp-border-radius);

  /* This is needed so that all font sizing of children done in ems is
   * relative to this base size */
  font-size: var(--jp-ui-font-size1);
  color: var(--jp-ui-font-color1);
  resize: both;
  overflow: hidden;
}

.jp-Dialog-content.jp-Dialog-content-small {
  max-width: 500px;
}

.jp-Dialog-button {
  overflow: visible;
}

button.jp-Dialog-button:disabled {
  opacity: 0.6;
}

button.jp-Dialog-button:focus {
  outline: 1px solid var(--jp-brand-color1);
  outline-offset: 4px;
  -moz-outline-radius: 0;
}

button.jp-Dialog-button:focus::-moz-focus-inner {
  border: 0;
}

button.jp-Dialog-button.jp-mod-styled.jp-mod-accept:focus,
button.jp-Dialog-button.jp-mod-styled.jp-mod-warn:focus,
button.jp-Dialog-button.jp-mod-styled.jp-mod-reject:focus {
  outline-offset: 4px;
  -moz-outline-radius: 0;
}

button.jp-Dialog-button.jp-mod-styled.jp-mod-accept:focus {
  outline: 1px solid var(--jp-accept-color-normal, var(--jp-brand-color1));
}

button.jp-Dialog-button.jp-mod-styled.jp-mod-warn:focus {
  outline: 1px solid var(--jp-warn-color-normal, var(--jp-error-color1));
}

button.jp-Dialog-button.jp-mod-styled.jp-mod-reject:focus {
  outline: 1px solid var(--jp-reject-color-normal, var(--md-grey-600, #757575));
}

button.jp-Dialog-close-button {
  padding: 0;
  height: 100%;
  min-width: unset;
  min-height: unset;
}

.jp-Dialog-header {
  display: flex;
  justify-content: space-between;
  flex: 0 0 auto;
  padding-bottom: 12px;
  font-size: var(--jp-ui-font-size3);
  font-weight: 400;
  color: var(--jp-ui-font-color1);
}

.jp-Dialog-body {
  display: flex;
  flex-direction: column;
  flex: 1 1 auto;
  font-size: var(--jp-ui-font-size1);
  background: var(--jp-layout-color1);
  color: var(--jp-ui-font-color1);
  overflow: auto;
}

.jp-Dialog-footer {
  display: flex;
  flex-direction: row;
  justify-content: flex-end;
  align-items: center;
  flex: 0 0 auto;
  margin-left: -12px;
  margin-right: -12px;
  padding: 12px;
}

.jp-Dialog-checkbox {
  padding-right: 5px;
  display: flex;
  align-items: center;
}

.jp-Dialog-spacer {
  flex: 1 1 auto;
}

.jp-Dialog-title {
  overflow: hidden;
  white-space: nowrap;
  text-overflow: ellipsis;
}

.jp-Dialog-body > .jp-select-wrapper {
  width: 100%;
}

.jp-Dialog-body > button {
  padding: 0 16px;
}

.jp-Dialog-body > label {
  line-height: 1.4;
  color: var(--jp-ui-font-color0);
}

.jp-Dialog-button.jp-mod-styled:not(:last-child) {
  margin-right: 12px;
}

/* stylelint-disable */
@container (max-width: 560px) {
  /* stylelint-enable */
  .jp-Dialog-footer {
    flex-direction: column;
    align-items: center;
    gap: 7px;
  }
}
`, "",{"version":3,"sources":["webpack://./../node_modules/@jupyterlab/apputils/style/dialog.css"],"names":[],"mappings":"AAAA;;;8EAG8E;;AAE9E;EACE,kBAAkB;EAClB,cAAc;EACd,aAAa;EACb,sBAAsB;EACtB,mBAAmB;EACnB,uBAAuB;EACvB,MAAM;EACN,OAAO;EACP,SAAS;EACT,UAAU;EACV,WAAW;EACX,YAAY;EACZ,uCAAuC;EACvC,sBAAsB;EACtB,2BAA2B;EAC3B,qBAAqB;AACvB;;AAEA;EACE,aAAa;EACb,sBAAsB;EACtB,iBAAiB;EACjB,kBAAkB;EAClB,mCAAmC;EACnC,uBAAuB;EACvB,gBAAgB;EAChB,iBAAiB;EACjB,iBAAiB;EACjB,iBAAiB;EACjB,sBAAsB;EACtB,mCAAmC;EACnC,qBAAqB;EACrB,sCAAsC;;EAEtC;iCAC+B;EAC/B,kCAAkC;EAClC,+BAA+B;EAC/B,YAAY;EACZ,gBAAgB;AAClB;;AAEA;EACE,gBAAgB;AAClB;;AAEA;EACE,iBAAiB;AACnB;;AAEA;EACE,YAAY;AACd;;AAEA;EACE,yCAAyC;EACzC,mBAAmB;EACnB,sBAAsB;AACxB;;AAEA;EACE,SAAS;AACX;;AAEA;;;EAGE,mBAAmB;EACnB,sBAAsB;AACxB;;AAEA;EACE,wEAAwE;AAC1E;;AAEA;EACE,sEAAsE;AACxE;;AAEA;EACE,6EAA6E;AAC/E;;AAEA;EACE,UAAU;EACV,YAAY;EACZ,gBAAgB;EAChB,iBAAiB;AACnB;;AAEA;EACE,aAAa;EACb,8BAA8B;EAC9B,cAAc;EACd,oBAAoB;EACpB,kCAAkC;EAClC,gBAAgB;EAChB,+BAA+B;AACjC;;AAEA;EACE,aAAa;EACb,sBAAsB;EACtB,cAAc;EACd,kCAAkC;EAClC,mCAAmC;EACnC,+BAA+B;EAC/B,cAAc;AAChB;;AAEA;EACE,aAAa;EACb,mBAAmB;EACnB,yBAAyB;EACzB,mBAAmB;EACnB,cAAc;EACd,kBAAkB;EAClB,mBAAmB;EACnB,aAAa;AACf;;AAEA;EACE,kBAAkB;EAClB,aAAa;EACb,mBAAmB;AACrB;;AAEA;EACE,cAAc;AAChB;;AAEA;EACE,gBAAgB;EAChB,mBAAmB;EACnB,uBAAuB;AACzB;;AAEA;EACE,WAAW;AACb;;AAEA;EACE,eAAe;AACjB;;AAEA;EACE,gBAAgB;EAChB,+BAA+B;AACjC;;AAEA;EACE,kBAAkB;AACpB;;AAEA,sBAAsB;AACtB;EACE,qBAAqB;EACrB;IACE,sBAAsB;IACtB,mBAAmB;IACnB,QAAQ;EACV;AACF","sourcesContent":["/*-----------------------------------------------------------------------------\n| Copyright (c) Jupyter Development Team.\n| Distributed under the terms of the Modified BSD License.\n|----------------------------------------------------------------------------*/\n\n.jp-Dialog.jp-ThemedContainer {\n  position: absolute;\n  z-index: 10000;\n  display: flex;\n  flex-direction: column;\n  align-items: center;\n  justify-content: center;\n  top: 0;\n  left: 0;\n  margin: 0;\n  padding: 0;\n  width: 100%;\n  height: 100%;\n  background: var(--jp-dialog-background);\n  /* stylelint-disable */\n  container-type: inline-size;\n  /* stylelint-enable */\n}\n\n.jp-Dialog-content {\n  display: flex;\n  flex-direction: column;\n  margin-left: auto;\n  margin-right: auto;\n  background: var(--jp-layout-color1);\n  padding: 24px 24px 12px;\n  min-width: 300px;\n  min-height: 150px;\n  max-width: 1000px;\n  max-height: 500px;\n  box-sizing: border-box;\n  box-shadow: var(--jp-elevation-z20);\n  word-wrap: break-word;\n  border-radius: var(--jp-border-radius);\n\n  /* This is needed so that all font sizing of children done in ems is\n   * relative to this base size */\n  font-size: var(--jp-ui-font-size1);\n  color: var(--jp-ui-font-color1);\n  resize: both;\n  overflow: hidden;\n}\n\n.jp-Dialog-content.jp-Dialog-content-small {\n  max-width: 500px;\n}\n\n.jp-Dialog-button {\n  overflow: visible;\n}\n\nbutton.jp-Dialog-button:disabled {\n  opacity: 0.6;\n}\n\nbutton.jp-Dialog-button:focus {\n  outline: 1px solid var(--jp-brand-color1);\n  outline-offset: 4px;\n  -moz-outline-radius: 0;\n}\n\nbutton.jp-Dialog-button:focus::-moz-focus-inner {\n  border: 0;\n}\n\nbutton.jp-Dialog-button.jp-mod-styled.jp-mod-accept:focus,\nbutton.jp-Dialog-button.jp-mod-styled.jp-mod-warn:focus,\nbutton.jp-Dialog-button.jp-mod-styled.jp-mod-reject:focus {\n  outline-offset: 4px;\n  -moz-outline-radius: 0;\n}\n\nbutton.jp-Dialog-button.jp-mod-styled.jp-mod-accept:focus {\n  outline: 1px solid var(--jp-accept-color-normal, var(--jp-brand-color1));\n}\n\nbutton.jp-Dialog-button.jp-mod-styled.jp-mod-warn:focus {\n  outline: 1px solid var(--jp-warn-color-normal, var(--jp-error-color1));\n}\n\nbutton.jp-Dialog-button.jp-mod-styled.jp-mod-reject:focus {\n  outline: 1px solid var(--jp-reject-color-normal, var(--md-grey-600, #757575));\n}\n\nbutton.jp-Dialog-close-button {\n  padding: 0;\n  height: 100%;\n  min-width: unset;\n  min-height: unset;\n}\n\n.jp-Dialog-header {\n  display: flex;\n  justify-content: space-between;\n  flex: 0 0 auto;\n  padding-bottom: 12px;\n  font-size: var(--jp-ui-font-size3);\n  font-weight: 400;\n  color: var(--jp-ui-font-color1);\n}\n\n.jp-Dialog-body {\n  display: flex;\n  flex-direction: column;\n  flex: 1 1 auto;\n  font-size: var(--jp-ui-font-size1);\n  background: var(--jp-layout-color1);\n  color: var(--jp-ui-font-color1);\n  overflow: auto;\n}\n\n.jp-Dialog-footer {\n  display: flex;\n  flex-direction: row;\n  justify-content: flex-end;\n  align-items: center;\n  flex: 0 0 auto;\n  margin-left: -12px;\n  margin-right: -12px;\n  padding: 12px;\n}\n\n.jp-Dialog-checkbox {\n  padding-right: 5px;\n  display: flex;\n  align-items: center;\n}\n\n.jp-Dialog-spacer {\n  flex: 1 1 auto;\n}\n\n.jp-Dialog-title {\n  overflow: hidden;\n  white-space: nowrap;\n  text-overflow: ellipsis;\n}\n\n.jp-Dialog-body > .jp-select-wrapper {\n  width: 100%;\n}\n\n.jp-Dialog-body > button {\n  padding: 0 16px;\n}\n\n.jp-Dialog-body > label {\n  line-height: 1.4;\n  color: var(--jp-ui-font-color0);\n}\n\n.jp-Dialog-button.jp-mod-styled:not(:last-child) {\n  margin-right: 12px;\n}\n\n/* stylelint-disable */\n@container (max-width: 560px) {\n  /* stylelint-enable */\n  .jp-Dialog-footer {\n    flex-direction: column;\n    align-items: center;\n    gap: 7px;\n  }\n}\n"],"sourceRoot":""}]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ 57035:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Z: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(82971);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(11368);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
// Imports


var ___CSS_LOADER_EXPORT___ = _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default()));
// Module
___CSS_LOADER_EXPORT___.push([module.id, `/*
 * Copyright (c) Jupyter Development Team.
 * Distributed under the terms of the Modified BSD License.
 */

.jp-Input-Boolean-Dialog {
  flex-direction: row-reverse;
  align-items: end;
  width: 100%;
}

.jp-Input-Boolean-Dialog > label {
  flex: 1 1 auto;
}

.jp-InputDialog-inputWrapper {
  display: flex;
  align-items: baseline;
}

.jp-InputDialog-inputWrapper > input.jp-mod-styled:invalid {
  border-color: var(--jp-error-color0);
  background: var(--jp-error-color3);
}

.jp-InputDialog-inputWrapper
  > input[required].jp-mod-styled:invalid:placeholder-shown {
  /* Do not show invalid style when placeholder is shown */
  border-color: unset;
  background: unset;
}
`, "",{"version":3,"sources":["webpack://./../node_modules/@jupyterlab/apputils/style/inputdialog.css"],"names":[],"mappings":"AAAA;;;EAGE;;AAEF;EACE,2BAA2B;EAC3B,gBAAgB;EAChB,WAAW;AACb;;AAEA;EACE,cAAc;AAChB;;AAEA;EACE,aAAa;EACb,qBAAqB;AACvB;;AAEA;EACE,oCAAoC;EACpC,kCAAkC;AACpC;;AAEA;;EAEE,wDAAwD;EACxD,mBAAmB;EACnB,iBAAiB;AACnB","sourcesContent":["/*\n * Copyright (c) Jupyter Development Team.\n * Distributed under the terms of the Modified BSD License.\n */\n\n.jp-Input-Boolean-Dialog {\n  flex-direction: row-reverse;\n  align-items: end;\n  width: 100%;\n}\n\n.jp-Input-Boolean-Dialog > label {\n  flex: 1 1 auto;\n}\n\n.jp-InputDialog-inputWrapper {\n  display: flex;\n  align-items: baseline;\n}\n\n.jp-InputDialog-inputWrapper > input.jp-mod-styled:invalid {\n  border-color: var(--jp-error-color0);\n  background: var(--jp-error-color3);\n}\n\n.jp-InputDialog-inputWrapper\n  > input[required].jp-mod-styled:invalid:placeholder-shown {\n  /* Do not show invalid style when placeholder is shown */\n  border-color: unset;\n  background: unset;\n}\n"],"sourceRoot":""}]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ 87134:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Z: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(82971);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(11368);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
// Imports


var ___CSS_LOADER_EXPORT___ = _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default()));
// Module
___CSS_LOADER_EXPORT___.push([module.id, `/*-----------------------------------------------------------------------------
| Copyright (c) Jupyter Development Team.
| Distributed under the terms of the Modified BSD License.
|----------------------------------------------------------------------------*/

/* licenses */
.jp-Licenses {
  display: flex;
  flex-direction: row;
  align-items: stretch;
  background-color: var(--jp-layout-color0);
}

.jp-Licenses-FormArea {
  display: flex;
  flex-direction: column;
  min-width: calc(10 * var(--jp-ui-font-size1));
  width: calc(18 * var(--jp-ui-font-size1));
}

.jp-Licenses .lm-SplitPanel-handle:hover {
  background-color: var(--jp-brand-color2);
}

/* filters */
.jp-Licenses-Filters {
  padding: var(--jp-ui-font-size1) calc(var(--jp-ui-font-size1) / 2) 0
    var(--jp-ui-font-size1);
}

.jp-Licenses-Filters label {
  display: block;
}

.jp-Licenses-Filters-title {
  font-weight: 600;
  text-transform: uppercase;
  letter-spacing: 1px;
  font-size: var(--jp-ui-font-size0);
  color: var(--jp-ui-font-color0);
}

.jp-RenderedHTMLCommon.jp-Licenses-Filters ul,
.jp-RenderedHTMLCommon.jp-Licenses-Filters li {
  list-style: none;
  color: var(--jp-ui-font-color0);
}

.jp-Licenses-Filters input {
  width: 100%;
}

.jp-RenderedHTMLCommon.jp-Licenses-Filters ul {
  padding: 0 0 var(--jp-ui-font-size1) 0;
  margin: 0;
  padding-bottom: var(--jp-ui-font-size1);
}

/* bundles */
.jp-Licenses-Bundles {
  background-color: var(--jp-layout-color2);
  overflow-y: auto;
  flex: 1;
}

.jp-Licenses-Bundles .lm-TabBar-content {
  width: 100%;
}

.jp-Licenses-Bundles .lm-TabBar-tab {
  padding: calc(var(--jp-ui-font-size1) / 2);
  background-color: var(--jp-layout-color1);
  color: var(--jp-ui-font-color1);
}

.jp-Licenses-Bundles .lm-TabBar-tabLabel {
  text-overflow: ellipsis;
}

.jp-Licenses-Bundles .lm-TabBar-tab label {
  background-color: var(--jp-layout-color2);
  border-radius: var(--jp-ui-font-size1);
  width: calc(2.5 * var(--jp-ui-font-size1));
  padding: 0 calc(var(--jp-ui-font-size1) / 2);
  text-align: center;
  margin-left: calc(var(--jp-ui-font-size1) / 2);
}

.jp-Licenses-Bundles .lm-TabBar-tab.lm-mod-current {
  background-color: var(--jp-brand-color1);
  color: #fff;
}

.jp-Licenses-Bundles .lm-TabBar-tab.lm-mod-current label {
  background-color: #fff;
  color: var(--jp-brand-color1);
}

/* license grid */
.jp-Licenses-Grid.jp-RenderedHTMLCommon {
  min-width: calc(var(--jp-ui-font-size1) * 10);
  display: flex;
  flex-direction: column;
  padding: 0;
}

.jp-Licenses-Grid.jp-RenderedHTMLCommon form {
  flex: 1;
  display: flex;
  flex-direction: column;
  overflow-y: scroll;
  margin: 0;
  padding: 0;
}

.jp-RenderedHTMLCommon.jp-Licenses-Grid table {
  flex: 1;
  max-width: 100%;
  border: solid var(--jp-border-width) var(--jp-border-color2);
  border-top: 0;
  border-bottom: 0;
  margin: 0;
}

.jp-Licenses-Grid.jp-RenderedHTMLCommon td,
.jp-Licenses-Grid.jp-RenderedHTMLCommon th {
  text-align: left;
}

.jp-Licenses-Grid td:nth-child(1) {
  max-width: calc(2 * var(--jp-ui-font-size1));
}

.jp-Licenses-Grid label {
  width: 100%;
}

.jp-Licenses .jp-Licenses-Grid.jp-RenderedHTMLCommon code {
  background-color: transparent;
  padding: 0;
}

.jp-Licenses-Grid.jp-RenderedHTMLCommon tr.jp-mod-selected {
  background-color: var(--jp-brand-color1);
  color: #fff;
}

.jp-Licenses-Grid.jp-RenderedHTMLCommon .jp-mod-selected code {
  color: #fff;
}

/* license text */
.jp-Licenses-Text {
  min-width: calc(10 * var(--jp-ui-font-size1));
  padding: 0 0 0 var(--jp-ui-font-size1);
  display: flex;
  flex-direction: column;
}

.jp-Licenses-Text h1 {
  flex: initial;
  margin-bottom: 0;
}

.jp-Licenses-Text h1:empty {
  display: none;
}

.jp-Licenses-Text blockquote {
  flex: initial;
}

.jp-Licenses-Text.jp-RenderedHTMLCommon code {
  overflow-wrap: anywhere;
  overflow-y: auto;
  flex: 1;
  padding-right: var(--jp-ui-font-size1);
  margin-bottom: 0;
  padding-bottom: var(--jp-ui-font-size1);
}

.jp-Licenses-Text code:empty {
  display: none;
}
`, "",{"version":3,"sources":["webpack://./../node_modules/@jupyterlab/apputils/style/licenses.css"],"names":[],"mappings":"AAAA;;;8EAG8E;;AAE9E,aAAa;AACb;EACE,aAAa;EACb,mBAAmB;EACnB,oBAAoB;EACpB,yCAAyC;AAC3C;;AAEA;EACE,aAAa;EACb,sBAAsB;EACtB,6CAA6C;EAC7C,yCAAyC;AAC3C;;AAEA;EACE,wCAAwC;AAC1C;;AAEA,YAAY;AACZ;EACE;2BACyB;AAC3B;;AAEA;EACE,cAAc;AAChB;;AAEA;EACE,gBAAgB;EAChB,yBAAyB;EACzB,mBAAmB;EACnB,kCAAkC;EAClC,+BAA+B;AACjC;;AAEA;;EAEE,gBAAgB;EAChB,+BAA+B;AACjC;;AAEA;EACE,WAAW;AACb;;AAEA;EACE,sCAAsC;EACtC,SAAS;EACT,uCAAuC;AACzC;;AAEA,YAAY;AACZ;EACE,yCAAyC;EACzC,gBAAgB;EAChB,OAAO;AACT;;AAEA;EACE,WAAW;AACb;;AAEA;EACE,0CAA0C;EAC1C,yCAAyC;EACzC,+BAA+B;AACjC;;AAEA;EACE,uBAAuB;AACzB;;AAEA;EACE,yCAAyC;EACzC,sCAAsC;EACtC,0CAA0C;EAC1C,4CAA4C;EAC5C,kBAAkB;EAClB,8CAA8C;AAChD;;AAEA;EACE,wCAAwC;EACxC,WAAW;AACb;;AAEA;EACE,sBAAsB;EACtB,6BAA6B;AAC/B;;AAEA,iBAAiB;AACjB;EACE,6CAA6C;EAC7C,aAAa;EACb,sBAAsB;EACtB,UAAU;AACZ;;AAEA;EACE,OAAO;EACP,aAAa;EACb,sBAAsB;EACtB,kBAAkB;EAClB,SAAS;EACT,UAAU;AACZ;;AAEA;EACE,OAAO;EACP,eAAe;EACf,4DAA4D;EAC5D,aAAa;EACb,gBAAgB;EAChB,SAAS;AACX;;AAEA;;EAEE,gBAAgB;AAClB;;AAEA;EACE,4CAA4C;AAC9C;;AAEA;EACE,WAAW;AACb;;AAEA;EACE,6BAA6B;EAC7B,UAAU;AACZ;;AAEA;EACE,wCAAwC;EACxC,WAAW;AACb;;AAEA;EACE,WAAW;AACb;;AAEA,iBAAiB;AACjB;EACE,6CAA6C;EAC7C,sCAAsC;EACtC,aAAa;EACb,sBAAsB;AACxB;;AAEA;EACE,aAAa;EACb,gBAAgB;AAClB;;AAEA;EACE,aAAa;AACf;;AAEA;EACE,aAAa;AACf;;AAEA;EACE,uBAAuB;EACvB,gBAAgB;EAChB,OAAO;EACP,sCAAsC;EACtC,gBAAgB;EAChB,uCAAuC;AACzC;;AAEA;EACE,aAAa;AACf","sourcesContent":["/*-----------------------------------------------------------------------------\n| Copyright (c) Jupyter Development Team.\n| Distributed under the terms of the Modified BSD License.\n|----------------------------------------------------------------------------*/\n\n/* licenses */\n.jp-Licenses {\n  display: flex;\n  flex-direction: row;\n  align-items: stretch;\n  background-color: var(--jp-layout-color0);\n}\n\n.jp-Licenses-FormArea {\n  display: flex;\n  flex-direction: column;\n  min-width: calc(10 * var(--jp-ui-font-size1));\n  width: calc(18 * var(--jp-ui-font-size1));\n}\n\n.jp-Licenses .lm-SplitPanel-handle:hover {\n  background-color: var(--jp-brand-color2);\n}\n\n/* filters */\n.jp-Licenses-Filters {\n  padding: var(--jp-ui-font-size1) calc(var(--jp-ui-font-size1) / 2) 0\n    var(--jp-ui-font-size1);\n}\n\n.jp-Licenses-Filters label {\n  display: block;\n}\n\n.jp-Licenses-Filters-title {\n  font-weight: 600;\n  text-transform: uppercase;\n  letter-spacing: 1px;\n  font-size: var(--jp-ui-font-size0);\n  color: var(--jp-ui-font-color0);\n}\n\n.jp-RenderedHTMLCommon.jp-Licenses-Filters ul,\n.jp-RenderedHTMLCommon.jp-Licenses-Filters li {\n  list-style: none;\n  color: var(--jp-ui-font-color0);\n}\n\n.jp-Licenses-Filters input {\n  width: 100%;\n}\n\n.jp-RenderedHTMLCommon.jp-Licenses-Filters ul {\n  padding: 0 0 var(--jp-ui-font-size1) 0;\n  margin: 0;\n  padding-bottom: var(--jp-ui-font-size1);\n}\n\n/* bundles */\n.jp-Licenses-Bundles {\n  background-color: var(--jp-layout-color2);\n  overflow-y: auto;\n  flex: 1;\n}\n\n.jp-Licenses-Bundles .lm-TabBar-content {\n  width: 100%;\n}\n\n.jp-Licenses-Bundles .lm-TabBar-tab {\n  padding: calc(var(--jp-ui-font-size1) / 2);\n  background-color: var(--jp-layout-color1);\n  color: var(--jp-ui-font-color1);\n}\n\n.jp-Licenses-Bundles .lm-TabBar-tabLabel {\n  text-overflow: ellipsis;\n}\n\n.jp-Licenses-Bundles .lm-TabBar-tab label {\n  background-color: var(--jp-layout-color2);\n  border-radius: var(--jp-ui-font-size1);\n  width: calc(2.5 * var(--jp-ui-font-size1));\n  padding: 0 calc(var(--jp-ui-font-size1) / 2);\n  text-align: center;\n  margin-left: calc(var(--jp-ui-font-size1) / 2);\n}\n\n.jp-Licenses-Bundles .lm-TabBar-tab.lm-mod-current {\n  background-color: var(--jp-brand-color1);\n  color: #fff;\n}\n\n.jp-Licenses-Bundles .lm-TabBar-tab.lm-mod-current label {\n  background-color: #fff;\n  color: var(--jp-brand-color1);\n}\n\n/* license grid */\n.jp-Licenses-Grid.jp-RenderedHTMLCommon {\n  min-width: calc(var(--jp-ui-font-size1) * 10);\n  display: flex;\n  flex-direction: column;\n  padding: 0;\n}\n\n.jp-Licenses-Grid.jp-RenderedHTMLCommon form {\n  flex: 1;\n  display: flex;\n  flex-direction: column;\n  overflow-y: scroll;\n  margin: 0;\n  padding: 0;\n}\n\n.jp-RenderedHTMLCommon.jp-Licenses-Grid table {\n  flex: 1;\n  max-width: 100%;\n  border: solid var(--jp-border-width) var(--jp-border-color2);\n  border-top: 0;\n  border-bottom: 0;\n  margin: 0;\n}\n\n.jp-Licenses-Grid.jp-RenderedHTMLCommon td,\n.jp-Licenses-Grid.jp-RenderedHTMLCommon th {\n  text-align: left;\n}\n\n.jp-Licenses-Grid td:nth-child(1) {\n  max-width: calc(2 * var(--jp-ui-font-size1));\n}\n\n.jp-Licenses-Grid label {\n  width: 100%;\n}\n\n.jp-Licenses .jp-Licenses-Grid.jp-RenderedHTMLCommon code {\n  background-color: transparent;\n  padding: 0;\n}\n\n.jp-Licenses-Grid.jp-RenderedHTMLCommon tr.jp-mod-selected {\n  background-color: var(--jp-brand-color1);\n  color: #fff;\n}\n\n.jp-Licenses-Grid.jp-RenderedHTMLCommon .jp-mod-selected code {\n  color: #fff;\n}\n\n/* license text */\n.jp-Licenses-Text {\n  min-width: calc(10 * var(--jp-ui-font-size1));\n  padding: 0 0 0 var(--jp-ui-font-size1);\n  display: flex;\n  flex-direction: column;\n}\n\n.jp-Licenses-Text h1 {\n  flex: initial;\n  margin-bottom: 0;\n}\n\n.jp-Licenses-Text h1:empty {\n  display: none;\n}\n\n.jp-Licenses-Text blockquote {\n  flex: initial;\n}\n\n.jp-Licenses-Text.jp-RenderedHTMLCommon code {\n  overflow-wrap: anywhere;\n  overflow-y: auto;\n  flex: 1;\n  padding-right: var(--jp-ui-font-size1);\n  margin-bottom: 0;\n  padding-bottom: var(--jp-ui-font-size1);\n}\n\n.jp-Licenses-Text code:empty {\n  display: none;\n}\n"],"sourceRoot":""}]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ 117:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Z: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(82971);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(11368);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
// Imports


var ___CSS_LOADER_EXPORT___ = _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default()));
// Module
___CSS_LOADER_EXPORT___.push([module.id, `/*-----------------------------------------------------------------------------
| Copyright (c) Jupyter Development Team.
| Distributed under the terms of the Modified BSD License.
|----------------------------------------------------------------------------*/

.jp-MainAreaWidget > :focus {
  outline: none;
}

.jp-MainAreaWidget .jp-MainAreaWidget-error {
  padding: 6px;
}

.jp-MainAreaWidget .jp-MainAreaWidget-error > pre {
  width: auto;
  padding: 10px;
  background: var(--jp-error-color3);
  border: var(--jp-border-width) solid var(--jp-error-color1);
  border-radius: var(--jp-border-radius);
  color: var(--jp-ui-font-color1);
  font-size: var(--jp-ui-font-size1);
  white-space: pre-wrap;
  word-wrap: break-word;
}
`, "",{"version":3,"sources":["webpack://./../node_modules/@jupyterlab/apputils/style/mainareawidget.css"],"names":[],"mappings":"AAAA;;;8EAG8E;;AAE9E;EACE,aAAa;AACf;;AAEA;EACE,YAAY;AACd;;AAEA;EACE,WAAW;EACX,aAAa;EACb,kCAAkC;EAClC,2DAA2D;EAC3D,sCAAsC;EACtC,+BAA+B;EAC/B,kCAAkC;EAClC,qBAAqB;EACrB,qBAAqB;AACvB","sourcesContent":["/*-----------------------------------------------------------------------------\n| Copyright (c) Jupyter Development Team.\n| Distributed under the terms of the Modified BSD License.\n|----------------------------------------------------------------------------*/\n\n.jp-MainAreaWidget > :focus {\n  outline: none;\n}\n\n.jp-MainAreaWidget .jp-MainAreaWidget-error {\n  padding: 6px;\n}\n\n.jp-MainAreaWidget .jp-MainAreaWidget-error > pre {\n  width: auto;\n  padding: 10px;\n  background: var(--jp-error-color3);\n  border: var(--jp-border-width) solid var(--jp-error-color1);\n  border-radius: var(--jp-border-radius);\n  color: var(--jp-ui-font-color1);\n  font-size: var(--jp-ui-font-size1);\n  white-space: pre-wrap;\n  word-wrap: break-word;\n}\n"],"sourceRoot":""}]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ 95714:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Z: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(82971);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(11368);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
// Imports


var ___CSS_LOADER_EXPORT___ = _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default()));
// Module
___CSS_LOADER_EXPORT___.push([module.id, `/*
 * Copyright (c) Jupyter Development Team.
 * Distributed under the terms of the Modified BSD License.
 */

/**
 * google-material-color v1.2.6
 * https://github.com/danlevan/google-material-color
 */
:root {
  --md-red-50: #ffebee;
  --md-red-100: #ffcdd2;
  --md-red-200: #ef9a9a;
  --md-red-300: #e57373;
  --md-red-400: #ef5350;
  --md-red-500: #f44336;
  --md-red-600: #e53935;
  --md-red-700: #d32f2f;
  --md-red-800: #c62828;
  --md-red-900: #b71c1c;
  --md-red-A100: #ff8a80;
  --md-red-A200: #ff5252;
  --md-red-A400: #ff1744;
  --md-red-A700: #d50000;
  --md-pink-50: #fce4ec;
  --md-pink-100: #f8bbd0;
  --md-pink-200: #f48fb1;
  --md-pink-300: #f06292;
  --md-pink-400: #ec407a;
  --md-pink-500: #e91e63;
  --md-pink-600: #d81b60;
  --md-pink-700: #c2185b;
  --md-pink-800: #ad1457;
  --md-pink-900: #880e4f;
  --md-pink-A100: #ff80ab;
  --md-pink-A200: #ff4081;
  --md-pink-A400: #f50057;
  --md-pink-A700: #c51162;
  --md-purple-50: #f3e5f5;
  --md-purple-100: #e1bee7;
  --md-purple-200: #ce93d8;
  --md-purple-300: #ba68c8;
  --md-purple-400: #ab47bc;
  --md-purple-500: #9c27b0;
  --md-purple-600: #8e24aa;
  --md-purple-700: #7b1fa2;
  --md-purple-800: #6a1b9a;
  --md-purple-900: #4a148c;
  --md-purple-A100: #ea80fc;
  --md-purple-A200: #e040fb;
  --md-purple-A400: #d500f9;
  --md-purple-A700: #a0f;
  --md-deep-purple-50: #ede7f6;
  --md-deep-purple-100: #d1c4e9;
  --md-deep-purple-200: #b39ddb;
  --md-deep-purple-300: #9575cd;
  --md-deep-purple-400: #7e57c2;
  --md-deep-purple-500: #673ab7;
  --md-deep-purple-600: #5e35b1;
  --md-deep-purple-700: #512da8;
  --md-deep-purple-800: #4527a0;
  --md-deep-purple-900: #311b92;
  --md-deep-purple-A100: #b388ff;
  --md-deep-purple-A200: #7c4dff;
  --md-deep-purple-A400: #651fff;
  --md-deep-purple-A700: #6200ea;
  --md-indigo-50: #e8eaf6;
  --md-indigo-100: #c5cae9;
  --md-indigo-200: #9fa8da;
  --md-indigo-300: #7986cb;
  --md-indigo-400: #5c6bc0;
  --md-indigo-500: #3f51b5;
  --md-indigo-600: #3949ab;
  --md-indigo-700: #303f9f;
  --md-indigo-800: #283593;
  --md-indigo-900: #1a237e;
  --md-indigo-A100: #8c9eff;
  --md-indigo-A200: #536dfe;
  --md-indigo-A400: #3d5afe;
  --md-indigo-A700: #304ffe;
  --md-blue-50: #e3f2fd;
  --md-blue-100: #bbdefb;
  --md-blue-200: #90caf9;
  --md-blue-300: #64b5f6;
  --md-blue-400: #42a5f5;
  --md-blue-500: #2196f3;
  --md-blue-600: #1e88e5;
  --md-blue-700: #1976d2;
  --md-blue-800: #1565c0;
  --md-blue-900: #0d47a1;
  --md-blue-A100: #82b1ff;
  --md-blue-A200: #448aff;
  --md-blue-A400: #2979ff;
  --md-blue-A700: #2962ff;
  --md-light-blue-50: #e1f5fe;
  --md-light-blue-100: #b3e5fc;
  --md-light-blue-200: #81d4fa;
  --md-light-blue-300: #4fc3f7;
  --md-light-blue-400: #29b6f6;
  --md-light-blue-500: #03a9f4;
  --md-light-blue-600: #039be5;
  --md-light-blue-700: #0288d1;
  --md-light-blue-800: #0277bd;
  --md-light-blue-900: #01579b;
  --md-light-blue-A100: #80d8ff;
  --md-light-blue-A200: #40c4ff;
  --md-light-blue-A400: #00b0ff;
  --md-light-blue-A700: #0091ea;
  --md-cyan-50: #e0f7fa;
  --md-cyan-100: #b2ebf2;
  --md-cyan-200: #80deea;
  --md-cyan-300: #4dd0e1;
  --md-cyan-400: #26c6da;
  --md-cyan-500: #00bcd4;
  --md-cyan-600: #00acc1;
  --md-cyan-700: #0097a7;
  --md-cyan-800: #00838f;
  --md-cyan-900: #006064;
  --md-cyan-A100: #84ffff;
  --md-cyan-A200: #18ffff;
  --md-cyan-A400: #00e5ff;
  --md-cyan-A700: #00b8d4;
  --md-teal-50: #e0f2f1;
  --md-teal-100: #b2dfdb;
  --md-teal-200: #80cbc4;
  --md-teal-300: #4db6ac;
  --md-teal-400: #26a69a;
  --md-teal-500: #009688;
  --md-teal-600: #00897b;
  --md-teal-700: #00796b;
  --md-teal-800: #00695c;
  --md-teal-900: #004d40;
  --md-teal-A100: #a7ffeb;
  --md-teal-A200: #64ffda;
  --md-teal-A400: #1de9b6;
  --md-teal-A700: #00bfa5;
  --md-green-50: #e8f5e9;
  --md-green-100: #c8e6c9;
  --md-green-200: #a5d6a7;
  --md-green-300: #81c784;
  --md-green-400: #66bb6a;
  --md-green-500: #4caf50;
  --md-green-600: #43a047;
  --md-green-700: #388e3c;
  --md-green-800: #2e7d32;
  --md-green-900: #1b5e20;
  --md-green-A100: #b9f6ca;
  --md-green-A200: #69f0ae;
  --md-green-A400: #00e676;
  --md-green-A700: #00c853;
  --md-light-green-50: #f1f8e9;
  --md-light-green-100: #dcedc8;
  --md-light-green-200: #c5e1a5;
  --md-light-green-300: #aed581;
  --md-light-green-400: #9ccc65;
  --md-light-green-500: #8bc34a;
  --md-light-green-600: #7cb342;
  --md-light-green-700: #689f38;
  --md-light-green-800: #558b2f;
  --md-light-green-900: #33691e;
  --md-light-green-A100: #ccff90;
  --md-light-green-A200: #b2ff59;
  --md-light-green-A400: #76ff03;
  --md-light-green-A700: #64dd17;
  --md-lime-50: #f9fbe7;
  --md-lime-100: #f0f4c3;
  --md-lime-200: #e6ee9c;
  --md-lime-300: #dce775;
  --md-lime-400: #d4e157;
  --md-lime-500: #cddc39;
  --md-lime-600: #c0ca33;
  --md-lime-700: #afb42b;
  --md-lime-800: #9e9d24;
  --md-lime-900: #827717;
  --md-lime-A100: #f4ff81;
  --md-lime-A200: #eeff41;
  --md-lime-A400: #c6ff00;
  --md-lime-A700: #aeea00;
  --md-yellow-50: #fffde7;
  --md-yellow-100: #fff9c4;
  --md-yellow-200: #fff59d;
  --md-yellow-300: #fff176;
  --md-yellow-400: #ffee58;
  --md-yellow-500: #ffeb3b;
  --md-yellow-600: #fdd835;
  --md-yellow-700: #fbc02d;
  --md-yellow-800: #f9a825;
  --md-yellow-900: #f57f17;
  --md-yellow-A100: #ffff8d;
  --md-yellow-A200: #ff0;
  --md-yellow-A400: #ffea00;
  --md-yellow-A700: #ffd600;
  --md-amber-50: #fff8e1;
  --md-amber-100: #ffecb3;
  --md-amber-200: #ffe082;
  --md-amber-300: #ffd54f;
  --md-amber-400: #ffca28;
  --md-amber-500: #ffc107;
  --md-amber-600: #ffb300;
  --md-amber-700: #ffa000;
  --md-amber-800: #ff8f00;
  --md-amber-900: #ff6f00;
  --md-amber-A100: #ffe57f;
  --md-amber-A200: #ffd740;
  --md-amber-A400: #ffc400;
  --md-amber-A700: #ffab00;
  --md-orange-50: #fff3e0;
  --md-orange-100: #ffe0b2;
  --md-orange-200: #ffcc80;
  --md-orange-300: #ffb74d;
  --md-orange-400: #ffa726;
  --md-orange-500: #ff9800;
  --md-orange-600: #fb8c00;
  --md-orange-700: #f57c00;
  --md-orange-800: #ef6c00;
  --md-orange-900: #e65100;
  --md-orange-A100: #ffd180;
  --md-orange-A200: #ffab40;
  --md-orange-A400: #ff9100;
  --md-orange-A700: #ff6d00;
  --md-deep-orange-50: #fbe9e7;
  --md-deep-orange-100: #ffccbc;
  --md-deep-orange-200: #ffab91;
  --md-deep-orange-300: #ff8a65;
  --md-deep-orange-400: #ff7043;
  --md-deep-orange-500: #ff5722;
  --md-deep-orange-600: #f4511e;
  --md-deep-orange-700: #e64a19;
  --md-deep-orange-800: #d84315;
  --md-deep-orange-900: #bf360c;
  --md-deep-orange-A100: #ff9e80;
  --md-deep-orange-A200: #ff6e40;
  --md-deep-orange-A400: #ff3d00;
  --md-deep-orange-A700: #dd2c00;
  --md-brown-50: #efebe9;
  --md-brown-100: #d7ccc8;
  --md-brown-200: #bcaaa4;
  --md-brown-300: #a1887f;
  --md-brown-400: #8d6e63;
  --md-brown-500: #795548;
  --md-brown-600: #6d4c41;
  --md-brown-700: #5d4037;
  --md-brown-800: #4e342e;
  --md-brown-900: #3e2723;
  --md-grey-50: #fafafa;
  --md-grey-100: #f5f5f5;
  --md-grey-200: #eee;
  --md-grey-300: #e0e0e0;
  --md-grey-400: #bdbdbd;
  --md-grey-500: #9e9e9e;
  --md-grey-600: #757575;
  --md-grey-700: #616161;
  --md-grey-800: #424242;
  --md-grey-900: #212121;
  --md-blue-grey-50: #eceff1;
  --md-blue-grey-100: #cfd8dc;
  --md-blue-grey-200: #b0bec5;
  --md-blue-grey-300: #90a4ae;
  --md-blue-grey-400: #78909c;
  --md-blue-grey-500: #607d8b;
  --md-blue-grey-600: #546e7a;
  --md-blue-grey-700: #455a64;
  --md-blue-grey-800: #37474f;
  --md-blue-grey-900: #263238;
}
`, "",{"version":3,"sources":["webpack://./../node_modules/@jupyterlab/apputils/style/materialcolors.css"],"names":[],"mappings":"AAAA;;;EAGE;;AAEF;;;EAGE;AACF;EACE,oBAAoB;EACpB,qBAAqB;EACrB,qBAAqB;EACrB,qBAAqB;EACrB,qBAAqB;EACrB,qBAAqB;EACrB,qBAAqB;EACrB,qBAAqB;EACrB,qBAAqB;EACrB,qBAAqB;EACrB,sBAAsB;EACtB,sBAAsB;EACtB,sBAAsB;EACtB,sBAAsB;EACtB,qBAAqB;EACrB,sBAAsB;EACtB,sBAAsB;EACtB,sBAAsB;EACtB,sBAAsB;EACtB,sBAAsB;EACtB,sBAAsB;EACtB,sBAAsB;EACtB,sBAAsB;EACtB,sBAAsB;EACtB,uBAAuB;EACvB,uBAAuB;EACvB,uBAAuB;EACvB,uBAAuB;EACvB,uBAAuB;EACvB,wBAAwB;EACxB,wBAAwB;EACxB,wBAAwB;EACxB,wBAAwB;EACxB,wBAAwB;EACxB,wBAAwB;EACxB,wBAAwB;EACxB,wBAAwB;EACxB,wBAAwB;EACxB,yBAAyB;EACzB,yBAAyB;EACzB,yBAAyB;EACzB,sBAAsB;EACtB,4BAA4B;EAC5B,6BAA6B;EAC7B,6BAA6B;EAC7B,6BAA6B;EAC7B,6BAA6B;EAC7B,6BAA6B;EAC7B,6BAA6B;EAC7B,6BAA6B;EAC7B,6BAA6B;EAC7B,6BAA6B;EAC7B,8BAA8B;EAC9B,8BAA8B;EAC9B,8BAA8B;EAC9B,8BAA8B;EAC9B,uBAAuB;EACvB,wBAAwB;EACxB,wBAAwB;EACxB,wBAAwB;EACxB,wBAAwB;EACxB,wBAAwB;EACxB,wBAAwB;EACxB,wBAAwB;EACxB,wBAAwB;EACxB,wBAAwB;EACxB,yBAAyB;EACzB,yBAAyB;EACzB,yBAAyB;EACzB,yBAAyB;EACzB,qBAAqB;EACrB,sBAAsB;EACtB,sBAAsB;EACtB,sBAAsB;EACtB,sBAAsB;EACtB,sBAAsB;EACtB,sBAAsB;EACtB,sBAAsB;EACtB,sBAAsB;EACtB,sBAAsB;EACtB,uBAAuB;EACvB,uBAAuB;EACvB,uBAAuB;EACvB,uBAAuB;EACvB,2BAA2B;EAC3B,4BAA4B;EAC5B,4BAA4B;EAC5B,4BAA4B;EAC5B,4BAA4B;EAC5B,4BAA4B;EAC5B,4BAA4B;EAC5B,4BAA4B;EAC5B,4BAA4B;EAC5B,4BAA4B;EAC5B,6BAA6B;EAC7B,6BAA6B;EAC7B,6BAA6B;EAC7B,6BAA6B;EAC7B,qBAAqB;EACrB,sBAAsB;EACtB,sBAAsB;EACtB,sBAAsB;EACtB,sBAAsB;EACtB,sBAAsB;EACtB,sBAAsB;EACtB,sBAAsB;EACtB,sBAAsB;EACtB,sBAAsB;EACtB,uBAAuB;EACvB,uBAAuB;EACvB,uBAAuB;EACvB,uBAAuB;EACvB,qBAAqB;EACrB,sBAAsB;EACtB,sBAAsB;EACtB,sBAAsB;EACtB,sBAAsB;EACtB,sBAAsB;EACtB,sBAAsB;EACtB,sBAAsB;EACtB,sBAAsB;EACtB,sBAAsB;EACtB,uBAAuB;EACvB,uBAAuB;EACvB,uBAAuB;EACvB,uBAAuB;EACvB,sBAAsB;EACtB,uBAAuB;EACvB,uBAAuB;EACvB,uBAAuB;EACvB,uBAAuB;EACvB,uBAAuB;EACvB,uBAAuB;EACvB,uBAAuB;EACvB,uBAAuB;EACvB,uBAAuB;EACvB,wBAAwB;EACxB,wBAAwB;EACxB,wBAAwB;EACxB,wBAAwB;EACxB,4BAA4B;EAC5B,6BAA6B;EAC7B,6BAA6B;EAC7B,6BAA6B;EAC7B,6BAA6B;EAC7B,6BAA6B;EAC7B,6BAA6B;EAC7B,6BAA6B;EAC7B,6BAA6B;EAC7B,6BAA6B;EAC7B,8BAA8B;EAC9B,8BAA8B;EAC9B,8BAA8B;EAC9B,8BAA8B;EAC9B,qBAAqB;EACrB,sBAAsB;EACtB,sBAAsB;EACtB,sBAAsB;EACtB,sBAAsB;EACtB,sBAAsB;EACtB,sBAAsB;EACtB,sBAAsB;EACtB,sBAAsB;EACtB,sBAAsB;EACtB,uBAAuB;EACvB,uBAAuB;EACvB,uBAAuB;EACvB,uBAAuB;EACvB,uBAAuB;EACvB,wBAAwB;EACxB,wBAAwB;EACxB,wBAAwB;EACxB,wBAAwB;EACxB,wBAAwB;EACxB,wBAAwB;EACxB,wBAAwB;EACxB,wBAAwB;EACxB,wBAAwB;EACxB,yBAAyB;EACzB,sBAAsB;EACtB,yBAAyB;EACzB,yBAAyB;EACzB,sBAAsB;EACtB,uBAAuB;EACvB,uBAAuB;EACvB,uBAAuB;EACvB,uBAAuB;EACvB,uBAAuB;EACvB,uBAAuB;EACvB,uBAAuB;EACvB,uBAAuB;EACvB,uBAAuB;EACvB,wBAAwB;EACxB,wBAAwB;EACxB,wBAAwB;EACxB,wBAAwB;EACxB,uBAAuB;EACvB,wBAAwB;EACxB,wBAAwB;EACxB,wBAAwB;EACxB,wBAAwB;EACxB,wBAAwB;EACxB,wBAAwB;EACxB,wBAAwB;EACxB,wBAAwB;EACxB,wBAAwB;EACxB,yBAAyB;EACzB,yBAAyB;EACzB,yBAAyB;EACzB,yBAAyB;EACzB,4BAA4B;EAC5B,6BAA6B;EAC7B,6BAA6B;EAC7B,6BAA6B;EAC7B,6BAA6B;EAC7B,6BAA6B;EAC7B,6BAA6B;EAC7B,6BAA6B;EAC7B,6BAA6B;EAC7B,6BAA6B;EAC7B,8BAA8B;EAC9B,8BAA8B;EAC9B,8BAA8B;EAC9B,8BAA8B;EAC9B,sBAAsB;EACtB,uBAAuB;EACvB,uBAAuB;EACvB,uBAAuB;EACvB,uBAAuB;EACvB,uBAAuB;EACvB,uBAAuB;EACvB,uBAAuB;EACvB,uBAAuB;EACvB,uBAAuB;EACvB,qBAAqB;EACrB,sBAAsB;EACtB,mBAAmB;EACnB,sBAAsB;EACtB,sBAAsB;EACtB,sBAAsB;EACtB,sBAAsB;EACtB,sBAAsB;EACtB,sBAAsB;EACtB,sBAAsB;EACtB,0BAA0B;EAC1B,2BAA2B;EAC3B,2BAA2B;EAC3B,2BAA2B;EAC3B,2BAA2B;EAC3B,2BAA2B;EAC3B,2BAA2B;EAC3B,2BAA2B;EAC3B,2BAA2B;EAC3B,2BAA2B;AAC7B","sourcesContent":["/*\n * Copyright (c) Jupyter Development Team.\n * Distributed under the terms of the Modified BSD License.\n */\n\n/**\n * google-material-color v1.2.6\n * https://github.com/danlevan/google-material-color\n */\n:root {\n  --md-red-50: #ffebee;\n  --md-red-100: #ffcdd2;\n  --md-red-200: #ef9a9a;\n  --md-red-300: #e57373;\n  --md-red-400: #ef5350;\n  --md-red-500: #f44336;\n  --md-red-600: #e53935;\n  --md-red-700: #d32f2f;\n  --md-red-800: #c62828;\n  --md-red-900: #b71c1c;\n  --md-red-A100: #ff8a80;\n  --md-red-A200: #ff5252;\n  --md-red-A400: #ff1744;\n  --md-red-A700: #d50000;\n  --md-pink-50: #fce4ec;\n  --md-pink-100: #f8bbd0;\n  --md-pink-200: #f48fb1;\n  --md-pink-300: #f06292;\n  --md-pink-400: #ec407a;\n  --md-pink-500: #e91e63;\n  --md-pink-600: #d81b60;\n  --md-pink-700: #c2185b;\n  --md-pink-800: #ad1457;\n  --md-pink-900: #880e4f;\n  --md-pink-A100: #ff80ab;\n  --md-pink-A200: #ff4081;\n  --md-pink-A400: #f50057;\n  --md-pink-A700: #c51162;\n  --md-purple-50: #f3e5f5;\n  --md-purple-100: #e1bee7;\n  --md-purple-200: #ce93d8;\n  --md-purple-300: #ba68c8;\n  --md-purple-400: #ab47bc;\n  --md-purple-500: #9c27b0;\n  --md-purple-600: #8e24aa;\n  --md-purple-700: #7b1fa2;\n  --md-purple-800: #6a1b9a;\n  --md-purple-900: #4a148c;\n  --md-purple-A100: #ea80fc;\n  --md-purple-A200: #e040fb;\n  --md-purple-A400: #d500f9;\n  --md-purple-A700: #a0f;\n  --md-deep-purple-50: #ede7f6;\n  --md-deep-purple-100: #d1c4e9;\n  --md-deep-purple-200: #b39ddb;\n  --md-deep-purple-300: #9575cd;\n  --md-deep-purple-400: #7e57c2;\n  --md-deep-purple-500: #673ab7;\n  --md-deep-purple-600: #5e35b1;\n  --md-deep-purple-700: #512da8;\n  --md-deep-purple-800: #4527a0;\n  --md-deep-purple-900: #311b92;\n  --md-deep-purple-A100: #b388ff;\n  --md-deep-purple-A200: #7c4dff;\n  --md-deep-purple-A400: #651fff;\n  --md-deep-purple-A700: #6200ea;\n  --md-indigo-50: #e8eaf6;\n  --md-indigo-100: #c5cae9;\n  --md-indigo-200: #9fa8da;\n  --md-indigo-300: #7986cb;\n  --md-indigo-400: #5c6bc0;\n  --md-indigo-500: #3f51b5;\n  --md-indigo-600: #3949ab;\n  --md-indigo-700: #303f9f;\n  --md-indigo-800: #283593;\n  --md-indigo-900: #1a237e;\n  --md-indigo-A100: #8c9eff;\n  --md-indigo-A200: #536dfe;\n  --md-indigo-A400: #3d5afe;\n  --md-indigo-A700: #304ffe;\n  --md-blue-50: #e3f2fd;\n  --md-blue-100: #bbdefb;\n  --md-blue-200: #90caf9;\n  --md-blue-300: #64b5f6;\n  --md-blue-400: #42a5f5;\n  --md-blue-500: #2196f3;\n  --md-blue-600: #1e88e5;\n  --md-blue-700: #1976d2;\n  --md-blue-800: #1565c0;\n  --md-blue-900: #0d47a1;\n  --md-blue-A100: #82b1ff;\n  --md-blue-A200: #448aff;\n  --md-blue-A400: #2979ff;\n  --md-blue-A700: #2962ff;\n  --md-light-blue-50: #e1f5fe;\n  --md-light-blue-100: #b3e5fc;\n  --md-light-blue-200: #81d4fa;\n  --md-light-blue-300: #4fc3f7;\n  --md-light-blue-400: #29b6f6;\n  --md-light-blue-500: #03a9f4;\n  --md-light-blue-600: #039be5;\n  --md-light-blue-700: #0288d1;\n  --md-light-blue-800: #0277bd;\n  --md-light-blue-900: #01579b;\n  --md-light-blue-A100: #80d8ff;\n  --md-light-blue-A200: #40c4ff;\n  --md-light-blue-A400: #00b0ff;\n  --md-light-blue-A700: #0091ea;\n  --md-cyan-50: #e0f7fa;\n  --md-cyan-100: #b2ebf2;\n  --md-cyan-200: #80deea;\n  --md-cyan-300: #4dd0e1;\n  --md-cyan-400: #26c6da;\n  --md-cyan-500: #00bcd4;\n  --md-cyan-600: #00acc1;\n  --md-cyan-700: #0097a7;\n  --md-cyan-800: #00838f;\n  --md-cyan-900: #006064;\n  --md-cyan-A100: #84ffff;\n  --md-cyan-A200: #18ffff;\n  --md-cyan-A400: #00e5ff;\n  --md-cyan-A700: #00b8d4;\n  --md-teal-50: #e0f2f1;\n  --md-teal-100: #b2dfdb;\n  --md-teal-200: #80cbc4;\n  --md-teal-300: #4db6ac;\n  --md-teal-400: #26a69a;\n  --md-teal-500: #009688;\n  --md-teal-600: #00897b;\n  --md-teal-700: #00796b;\n  --md-teal-800: #00695c;\n  --md-teal-900: #004d40;\n  --md-teal-A100: #a7ffeb;\n  --md-teal-A200: #64ffda;\n  --md-teal-A400: #1de9b6;\n  --md-teal-A700: #00bfa5;\n  --md-green-50: #e8f5e9;\n  --md-green-100: #c8e6c9;\n  --md-green-200: #a5d6a7;\n  --md-green-300: #81c784;\n  --md-green-400: #66bb6a;\n  --md-green-500: #4caf50;\n  --md-green-600: #43a047;\n  --md-green-700: #388e3c;\n  --md-green-800: #2e7d32;\n  --md-green-900: #1b5e20;\n  --md-green-A100: #b9f6ca;\n  --md-green-A200: #69f0ae;\n  --md-green-A400: #00e676;\n  --md-green-A700: #00c853;\n  --md-light-green-50: #f1f8e9;\n  --md-light-green-100: #dcedc8;\n  --md-light-green-200: #c5e1a5;\n  --md-light-green-300: #aed581;\n  --md-light-green-400: #9ccc65;\n  --md-light-green-500: #8bc34a;\n  --md-light-green-600: #7cb342;\n  --md-light-green-700: #689f38;\n  --md-light-green-800: #558b2f;\n  --md-light-green-900: #33691e;\n  --md-light-green-A100: #ccff90;\n  --md-light-green-A200: #b2ff59;\n  --md-light-green-A400: #76ff03;\n  --md-light-green-A700: #64dd17;\n  --md-lime-50: #f9fbe7;\n  --md-lime-100: #f0f4c3;\n  --md-lime-200: #e6ee9c;\n  --md-lime-300: #dce775;\n  --md-lime-400: #d4e157;\n  --md-lime-500: #cddc39;\n  --md-lime-600: #c0ca33;\n  --md-lime-700: #afb42b;\n  --md-lime-800: #9e9d24;\n  --md-lime-900: #827717;\n  --md-lime-A100: #f4ff81;\n  --md-lime-A200: #eeff41;\n  --md-lime-A400: #c6ff00;\n  --md-lime-A700: #aeea00;\n  --md-yellow-50: #fffde7;\n  --md-yellow-100: #fff9c4;\n  --md-yellow-200: #fff59d;\n  --md-yellow-300: #fff176;\n  --md-yellow-400: #ffee58;\n  --md-yellow-500: #ffeb3b;\n  --md-yellow-600: #fdd835;\n  --md-yellow-700: #fbc02d;\n  --md-yellow-800: #f9a825;\n  --md-yellow-900: #f57f17;\n  --md-yellow-A100: #ffff8d;\n  --md-yellow-A200: #ff0;\n  --md-yellow-A400: #ffea00;\n  --md-yellow-A700: #ffd600;\n  --md-amber-50: #fff8e1;\n  --md-amber-100: #ffecb3;\n  --md-amber-200: #ffe082;\n  --md-amber-300: #ffd54f;\n  --md-amber-400: #ffca28;\n  --md-amber-500: #ffc107;\n  --md-amber-600: #ffb300;\n  --md-amber-700: #ffa000;\n  --md-amber-800: #ff8f00;\n  --md-amber-900: #ff6f00;\n  --md-amber-A100: #ffe57f;\n  --md-amber-A200: #ffd740;\n  --md-amber-A400: #ffc400;\n  --md-amber-A700: #ffab00;\n  --md-orange-50: #fff3e0;\n  --md-orange-100: #ffe0b2;\n  --md-orange-200: #ffcc80;\n  --md-orange-300: #ffb74d;\n  --md-orange-400: #ffa726;\n  --md-orange-500: #ff9800;\n  --md-orange-600: #fb8c00;\n  --md-orange-700: #f57c00;\n  --md-orange-800: #ef6c00;\n  --md-orange-900: #e65100;\n  --md-orange-A100: #ffd180;\n  --md-orange-A200: #ffab40;\n  --md-orange-A400: #ff9100;\n  --md-orange-A700: #ff6d00;\n  --md-deep-orange-50: #fbe9e7;\n  --md-deep-orange-100: #ffccbc;\n  --md-deep-orange-200: #ffab91;\n  --md-deep-orange-300: #ff8a65;\n  --md-deep-orange-400: #ff7043;\n  --md-deep-orange-500: #ff5722;\n  --md-deep-orange-600: #f4511e;\n  --md-deep-orange-700: #e64a19;\n  --md-deep-orange-800: #d84315;\n  --md-deep-orange-900: #bf360c;\n  --md-deep-orange-A100: #ff9e80;\n  --md-deep-orange-A200: #ff6e40;\n  --md-deep-orange-A400: #ff3d00;\n  --md-deep-orange-A700: #dd2c00;\n  --md-brown-50: #efebe9;\n  --md-brown-100: #d7ccc8;\n  --md-brown-200: #bcaaa4;\n  --md-brown-300: #a1887f;\n  --md-brown-400: #8d6e63;\n  --md-brown-500: #795548;\n  --md-brown-600: #6d4c41;\n  --md-brown-700: #5d4037;\n  --md-brown-800: #4e342e;\n  --md-brown-900: #3e2723;\n  --md-grey-50: #fafafa;\n  --md-grey-100: #f5f5f5;\n  --md-grey-200: #eee;\n  --md-grey-300: #e0e0e0;\n  --md-grey-400: #bdbdbd;\n  --md-grey-500: #9e9e9e;\n  --md-grey-600: #757575;\n  --md-grey-700: #616161;\n  --md-grey-800: #424242;\n  --md-grey-900: #212121;\n  --md-blue-grey-50: #eceff1;\n  --md-blue-grey-100: #cfd8dc;\n  --md-blue-grey-200: #b0bec5;\n  --md-blue-grey-300: #90a4ae;\n  --md-blue-grey-400: #78909c;\n  --md-blue-grey-500: #607d8b;\n  --md-blue-grey-600: #546e7a;\n  --md-blue-grey-700: #455a64;\n  --md-blue-grey-800: #37474f;\n  --md-blue-grey-900: #263238;\n}\n"],"sourceRoot":""}]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ 36972:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Z: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(82971);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(11368);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
// Imports


var ___CSS_LOADER_EXPORT___ = _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default()));
// Module
___CSS_LOADER_EXPORT___.push([module.id, `/*
 * Copyright (c) Jupyter Development Team.
 * Distributed under the terms of the Modified BSD License.
 */

/* @deprecated dead code to be removed in JupyterLab 5 */
.jp-Toolbar-item.jp-Toolbar-kernelStatus {
  display: inline-block;
  width: 32px;
  background-repeat: no-repeat;
  background-position: center;
  background-size: 16px;
}
`, "",{"version":3,"sources":["webpack://./../node_modules/@jupyterlab/apputils/style/toolbar.css"],"names":[],"mappings":"AAAA;;;EAGE;;AAEF,wDAAwD;AACxD;EACE,qBAAqB;EACrB,WAAW;EACX,4BAA4B;EAC5B,2BAA2B;EAC3B,qBAAqB;AACvB","sourcesContent":["/*\n * Copyright (c) Jupyter Development Team.\n * Distributed under the terms of the Modified BSD License.\n */\n\n/* @deprecated dead code to be removed in JupyterLab 5 */\n.jp-Toolbar-item.jp-Toolbar-kernelStatus {\n  display: inline-block;\n  width: 32px;\n  background-repeat: no-repeat;\n  background-position: center;\n  background-size: 16px;\n}\n"],"sourceRoot":""}]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ 73197:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Z: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(82971);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(11368);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
// Imports


var ___CSS_LOADER_EXPORT___ = _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default()));
// Module
___CSS_LOADER_EXPORT___.push([module.id, `/*
 * Copyright (c) Jupyter Development Team.
 * Distributed under the terms of the Modified BSD License.
 */

.jp-cell-button .jp-icon3[fill] {
  fill: var(--jp-inverse-layout-color4);
}

.jp-cell-button:hover .jp-icon3[fill] {
  fill: var(--jp-inverse-layout-color2);
}

.jp-toolbar-overlap .jp-cell-toolbar {
  display: none;
}

.jp-cell-toolbar {
  display: flex;
  flex-direction: row;
  padding: 0;
  min-height: 25px;
  z-index: 6;
  position: absolute;
  right: 3px;

  /* Override .jp-Toolbar */
  background-color: transparent;
  border-bottom: inherit;
  box-shadow: none;
}

/* Overrides for mobile view hiding cell toolbar */
@media only screen and (width <= 760px) {
  .jp-cell-toolbar {
    display: none;
  }
}

.jp-cell-toolbar button.jp-ToolbarButtonComponent {
  cursor: pointer;
}

.jp-cell-toolbar .jp-ToolbarButton button {
  display: none;
}

.jp-cell-toolbar .jp-ToolbarButton .jp-cell-all,
.jp-CodeCell .jp-ToolbarButton .jp-cell-code,
.jp-MarkdownCell .jp-ToolbarButton .jp-cell-markdown,
.jp-RawCell .jp-ToolbarButton .jp-cell-raw {
  display: block;
}

.jp-cell-toolbar .jp-Toolbar-spacer {
  flex: 1 1 auto;
}

.jp-cell-mod-click {
  cursor: pointer;
}

/* Custom styling for rendered markdown cells so that cell toolbar is visible */
.jp-MarkdownOutput {
  border-width: var(--jp-border-width);
  border-color: transparent;
  border-style: solid;
}

.jp-mod-active .jp-MarkdownOutput {
  border-color: var(--jp-cell-editor-border-color);
}
`, "",{"version":3,"sources":["webpack://./../node_modules/@jupyterlab/cell-toolbar/style/base.css"],"names":[],"mappings":"AAAA;;;EAGE;;AAEF;EACE,qCAAqC;AACvC;;AAEA;EACE,qCAAqC;AACvC;;AAEA;EACE,aAAa;AACf;;AAEA;EACE,aAAa;EACb,mBAAmB;EACnB,UAAU;EACV,gBAAgB;EAChB,UAAU;EACV,kBAAkB;EAClB,UAAU;;EAEV,yBAAyB;EACzB,6BAA6B;EAC7B,sBAAsB;EACtB,gBAAgB;AAClB;;AAEA,kDAAkD;AAClD;EACE;IACE,aAAa;EACf;AACF;;AAEA;EACE,eAAe;AACjB;;AAEA;EACE,aAAa;AACf;;AAEA;;;;EAIE,cAAc;AAChB;;AAEA;EACE,cAAc;AAChB;;AAEA;EACE,eAAe;AACjB;;AAEA,+EAA+E;AAC/E;EACE,oCAAoC;EACpC,yBAAyB;EACzB,mBAAmB;AACrB;;AAEA;EACE,gDAAgD;AAClD","sourcesContent":["/*\n * Copyright (c) Jupyter Development Team.\n * Distributed under the terms of the Modified BSD License.\n */\n\n.jp-cell-button .jp-icon3[fill] {\n  fill: var(--jp-inverse-layout-color4);\n}\n\n.jp-cell-button:hover .jp-icon3[fill] {\n  fill: var(--jp-inverse-layout-color2);\n}\n\n.jp-toolbar-overlap .jp-cell-toolbar {\n  display: none;\n}\n\n.jp-cell-toolbar {\n  display: flex;\n  flex-direction: row;\n  padding: 0;\n  min-height: 25px;\n  z-index: 6;\n  position: absolute;\n  right: 3px;\n\n  /* Override .jp-Toolbar */\n  background-color: transparent;\n  border-bottom: inherit;\n  box-shadow: none;\n}\n\n/* Overrides for mobile view hiding cell toolbar */\n@media only screen and (width <= 760px) {\n  .jp-cell-toolbar {\n    display: none;\n  }\n}\n\n.jp-cell-toolbar button.jp-ToolbarButtonComponent {\n  cursor: pointer;\n}\n\n.jp-cell-toolbar .jp-ToolbarButton button {\n  display: none;\n}\n\n.jp-cell-toolbar .jp-ToolbarButton .jp-cell-all,\n.jp-CodeCell .jp-ToolbarButton .jp-cell-code,\n.jp-MarkdownCell .jp-ToolbarButton .jp-cell-markdown,\n.jp-RawCell .jp-ToolbarButton .jp-cell-raw {\n  display: block;\n}\n\n.jp-cell-toolbar .jp-Toolbar-spacer {\n  flex: 1 1 auto;\n}\n\n.jp-cell-mod-click {\n  cursor: pointer;\n}\n\n/* Custom styling for rendered markdown cells so that cell toolbar is visible */\n.jp-MarkdownOutput {\n  border-width: var(--jp-border-width);\n  border-color: transparent;\n  border-style: solid;\n}\n\n.jp-mod-active .jp-MarkdownOutput {\n  border-color: var(--jp-cell-editor-border-color);\n}\n"],"sourceRoot":""}]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ 81550:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Z: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(82971);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(11368);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _builder_node_modules_css_loader_dist_cjs_js_collapser_css__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(99315);
/* harmony import */ var _builder_node_modules_css_loader_dist_cjs_js_headerfooter_css__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(58776);
/* harmony import */ var _builder_node_modules_css_loader_dist_cjs_js_inputarea_css__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(99608);
/* harmony import */ var _builder_node_modules_css_loader_dist_cjs_js_placeholder_css__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(42665);
/* harmony import */ var _builder_node_modules_css_loader_dist_cjs_js_widget_css__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(63324);
// Imports







var ___CSS_LOADER_EXPORT___ = _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default()));
___CSS_LOADER_EXPORT___.i(_builder_node_modules_css_loader_dist_cjs_js_collapser_css__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z);
___CSS_LOADER_EXPORT___.i(_builder_node_modules_css_loader_dist_cjs_js_headerfooter_css__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z);
___CSS_LOADER_EXPORT___.i(_builder_node_modules_css_loader_dist_cjs_js_inputarea_css__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z);
___CSS_LOADER_EXPORT___.i(_builder_node_modules_css_loader_dist_cjs_js_placeholder_css__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z);
___CSS_LOADER_EXPORT___.i(_builder_node_modules_css_loader_dist_cjs_js_widget_css__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .Z);
// Module
___CSS_LOADER_EXPORT___.push([module.id, `/*-----------------------------------------------------------------------------
| Copyright (c) Jupyter Development Team.
| Distributed under the terms of the Modified BSD License.
|----------------------------------------------------------------------------*/
`, "",{"version":3,"sources":["webpack://./../node_modules/@jupyterlab/cells/style/base.css"],"names":[],"mappings":"AAAA;;;8EAG8E","sourcesContent":["/*-----------------------------------------------------------------------------\n| Copyright (c) Jupyter Development Team.\n| Distributed under the terms of the Modified BSD License.\n|----------------------------------------------------------------------------*/\n\n@import './collapser.css';\n@import './headerfooter.css';\n@import './inputarea.css';\n@import './placeholder.css';\n@import './widget.css';\n"],"sourceRoot":""}]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ 99315:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Z: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(82971);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(11368);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
// Imports


var ___CSS_LOADER_EXPORT___ = _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default()));
// Module
___CSS_LOADER_EXPORT___.push([module.id, `/*-----------------------------------------------------------------------------
| Copyright (c) Jupyter Development Team.
| Distributed under the terms of the Modified BSD License.
|----------------------------------------------------------------------------*/

.jp-Collapser {
  flex: 0 0 var(--jp-cell-collapser-width);
  padding: 0;
  margin: 0;
  border: none;
  outline: none;
  background: transparent;
  border-radius: var(--jp-border-radius);
  opacity: 1;
}

.jp-Collapser-child {
  display: block;
  width: 100%;
  box-sizing: border-box;

  /* height: 100% doesn't work because the height of its parent is computed from content */
  position: absolute;
  top: 0;
  bottom: 0;
}

/*-----------------------------------------------------------------------------
| Printing
|----------------------------------------------------------------------------*/

/*
Hiding collapsers in print mode.

Note: input and output wrappers have "display: block" property in print mode.
*/

@media print {
  .jp-Collapser {
    display: none;
  }
}
`, "",{"version":3,"sources":["webpack://./../node_modules/@jupyterlab/cells/style/collapser.css"],"names":[],"mappings":"AAAA;;;8EAG8E;;AAE9E;EACE,wCAAwC;EACxC,UAAU;EACV,SAAS;EACT,YAAY;EACZ,aAAa;EACb,uBAAuB;EACvB,sCAAsC;EACtC,UAAU;AACZ;;AAEA;EACE,cAAc;EACd,WAAW;EACX,sBAAsB;;EAEtB,wFAAwF;EACxF,kBAAkB;EAClB,MAAM;EACN,SAAS;AACX;;AAEA;;8EAE8E;;AAE9E;;;;CAIC;;AAED;EACE;IACE,aAAa;EACf;AACF","sourcesContent":["/*-----------------------------------------------------------------------------\n| Copyright (c) Jupyter Development Team.\n| Distributed under the terms of the Modified BSD License.\n|----------------------------------------------------------------------------*/\n\n.jp-Collapser {\n  flex: 0 0 var(--jp-cell-collapser-width);\n  padding: 0;\n  margin: 0;\n  border: none;\n  outline: none;\n  background: transparent;\n  border-radius: var(--jp-border-radius);\n  opacity: 1;\n}\n\n.jp-Collapser-child {\n  display: block;\n  width: 100%;\n  box-sizing: border-box;\n\n  /* height: 100% doesn't work because the height of its parent is computed from content */\n  position: absolute;\n  top: 0;\n  bottom: 0;\n}\n\n/*-----------------------------------------------------------------------------\n| Printing\n|----------------------------------------------------------------------------*/\n\n/*\nHiding collapsers in print mode.\n\nNote: input and output wrappers have \"display: block\" property in print mode.\n*/\n\n@media print {\n  .jp-Collapser {\n    display: none;\n  }\n}\n"],"sourceRoot":""}]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ 58776:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Z: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(82971);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(11368);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
// Imports


var ___CSS_LOADER_EXPORT___ = _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default()));
// Module
___CSS_LOADER_EXPORT___.push([module.id, `/*-----------------------------------------------------------------------------
| Copyright (c) Jupyter Development Team.
| Distributed under the terms of the Modified BSD License.
|----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------
| Header/Footer
|----------------------------------------------------------------------------*/

/* Hidden by zero height by default */
.jp-CellHeader,
.jp-CellFooter {
  height: 0;
  width: 100%;
  padding: 0;
  margin: 0;
  border: none;
  outline: none;
  background: transparent;
}
`, "",{"version":3,"sources":["webpack://./../node_modules/@jupyterlab/cells/style/headerfooter.css"],"names":[],"mappings":"AAAA;;;8EAG8E;;AAE9E;;8EAE8E;;AAE9E,qCAAqC;AACrC;;EAEE,SAAS;EACT,WAAW;EACX,UAAU;EACV,SAAS;EACT,YAAY;EACZ,aAAa;EACb,uBAAuB;AACzB","sourcesContent":["/*-----------------------------------------------------------------------------\n| Copyright (c) Jupyter Development Team.\n| Distributed under the terms of the Modified BSD License.\n|----------------------------------------------------------------------------*/\n\n/*-----------------------------------------------------------------------------\n| Header/Footer\n|----------------------------------------------------------------------------*/\n\n/* Hidden by zero height by default */\n.jp-CellHeader,\n.jp-CellFooter {\n  height: 0;\n  width: 100%;\n  padding: 0;\n  margin: 0;\n  border: none;\n  outline: none;\n  background: transparent;\n}\n"],"sourceRoot":""}]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ 99608:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Z: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(82971);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(11368);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
// Imports


var ___CSS_LOADER_EXPORT___ = _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default()));
// Module
___CSS_LOADER_EXPORT___.push([module.id, `/*-----------------------------------------------------------------------------
| Copyright (c) Jupyter Development Team.
| Distributed under the terms of the Modified BSD License.
|----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------
| Input
|----------------------------------------------------------------------------*/

/* All input areas */
.jp-InputArea {
  display: flex;
  flex-direction: row;
  width: 100%;
  overflow: hidden;
}

.jp-InputArea-editor {
  flex: 1 1 auto;
  overflow: hidden;

  /* This is the non-active, default styling */
  border: var(--jp-border-width) solid var(--jp-cell-editor-border-color);
  border-radius: 0;
  background: var(--jp-cell-editor-background);
}

.jp-InputPrompt {
  flex: 0 0 var(--jp-cell-prompt-width);
  width: var(--jp-cell-prompt-width);
  color: var(--jp-cell-inprompt-font-color);
  font-family: var(--jp-cell-prompt-font-family);
  padding: var(--jp-code-padding);
  letter-spacing: var(--jp-cell-prompt-letter-spacing);
  opacity: var(--jp-cell-prompt-opacity);
  line-height: var(--jp-code-line-height);
  font-size: var(--jp-code-font-size);
  border: var(--jp-border-width) solid transparent;

  /* Right align prompt text, don't wrap to handle large prompt numbers */
  text-align: right;
  white-space: nowrap;
  overflow: hidden;
  text-overflow: ellipsis;

  /* Disable text selection */
  -webkit-user-select: none;
  -moz-user-select: none;
  -ms-user-select: none;
  user-select: none;
}

/*-----------------------------------------------------------------------------
| Print
|----------------------------------------------------------------------------*/
@media print {
  .jp-InputArea {
    display: table;
    table-layout: fixed;
  }

  .jp-InputArea-editor {
    display: table-cell;
    vertical-align: top;
  }

  .jp-InputPrompt {
    display: table-cell;
    vertical-align: top;
  }
}

/*-----------------------------------------------------------------------------
| Mobile
|----------------------------------------------------------------------------*/
@media only screen and (width <= 760px) {
  .jp-InputArea {
    flex-direction: column;
  }

  .jp-InputArea-editor {
    margin-left: var(--jp-code-padding);
  }

  .jp-InputPrompt {
    flex: 0 0 auto;
    text-align: left;
  }
}
`, "",{"version":3,"sources":["webpack://./../node_modules/@jupyterlab/cells/style/inputarea.css"],"names":[],"mappings":"AAAA;;;8EAG8E;;AAE9E;;8EAE8E;;AAE9E,oBAAoB;AACpB;EACE,aAAa;EACb,mBAAmB;EACnB,WAAW;EACX,gBAAgB;AAClB;;AAEA;EACE,cAAc;EACd,gBAAgB;;EAEhB,4CAA4C;EAC5C,uEAAuE;EACvE,gBAAgB;EAChB,4CAA4C;AAC9C;;AAEA;EACE,qCAAqC;EACrC,kCAAkC;EAClC,yCAAyC;EACzC,8CAA8C;EAC9C,+BAA+B;EAC/B,oDAAoD;EACpD,sCAAsC;EACtC,uCAAuC;EACvC,mCAAmC;EACnC,gDAAgD;;EAEhD,uEAAuE;EACvE,iBAAiB;EACjB,mBAAmB;EACnB,gBAAgB;EAChB,uBAAuB;;EAEvB,2BAA2B;EAC3B,yBAAyB;EACzB,sBAAsB;EACtB,qBAAqB;EACrB,iBAAiB;AACnB;;AAEA;;8EAE8E;AAC9E;EACE;IACE,cAAc;IACd,mBAAmB;EACrB;;EAEA;IACE,mBAAmB;IACnB,mBAAmB;EACrB;;EAEA;IACE,mBAAmB;IACnB,mBAAmB;EACrB;AACF;;AAEA;;8EAE8E;AAC9E;EACE;IACE,sBAAsB;EACxB;;EAEA;IACE,mCAAmC;EACrC;;EAEA;IACE,cAAc;IACd,gBAAgB;EAClB;AACF","sourcesContent":["/*-----------------------------------------------------------------------------\n| Copyright (c) Jupyter Development Team.\n| Distributed under the terms of the Modified BSD License.\n|----------------------------------------------------------------------------*/\n\n/*-----------------------------------------------------------------------------\n| Input\n|----------------------------------------------------------------------------*/\n\n/* All input areas */\n.jp-InputArea {\n  display: flex;\n  flex-direction: row;\n  width: 100%;\n  overflow: hidden;\n}\n\n.jp-InputArea-editor {\n  flex: 1 1 auto;\n  overflow: hidden;\n\n  /* This is the non-active, default styling */\n  border: var(--jp-border-width) solid var(--jp-cell-editor-border-color);\n  border-radius: 0;\n  background: var(--jp-cell-editor-background);\n}\n\n.jp-InputPrompt {\n  flex: 0 0 var(--jp-cell-prompt-width);\n  width: var(--jp-cell-prompt-width);\n  color: var(--jp-cell-inprompt-font-color);\n  font-family: var(--jp-cell-prompt-font-family);\n  padding: var(--jp-code-padding);\n  letter-spacing: var(--jp-cell-prompt-letter-spacing);\n  opacity: var(--jp-cell-prompt-opacity);\n  line-height: var(--jp-code-line-height);\n  font-size: var(--jp-code-font-size);\n  border: var(--jp-border-width) solid transparent;\n\n  /* Right align prompt text, don't wrap to handle large prompt numbers */\n  text-align: right;\n  white-space: nowrap;\n  overflow: hidden;\n  text-overflow: ellipsis;\n\n  /* Disable text selection */\n  -webkit-user-select: none;\n  -moz-user-select: none;\n  -ms-user-select: none;\n  user-select: none;\n}\n\n/*-----------------------------------------------------------------------------\n| Print\n|----------------------------------------------------------------------------*/\n@media print {\n  .jp-InputArea {\n    display: table;\n    table-layout: fixed;\n  }\n\n  .jp-InputArea-editor {\n    display: table-cell;\n    vertical-align: top;\n  }\n\n  .jp-InputPrompt {\n    display: table-cell;\n    vertical-align: top;\n  }\n}\n\n/*-----------------------------------------------------------------------------\n| Mobile\n|----------------------------------------------------------------------------*/\n@media only screen and (width <= 760px) {\n  .jp-InputArea {\n    flex-direction: column;\n  }\n\n  .jp-InputArea-editor {\n    margin-left: var(--jp-code-padding);\n  }\n\n  .jp-InputPrompt {\n    flex: 0 0 auto;\n    text-align: left;\n  }\n}\n"],"sourceRoot":""}]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ 42665:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Z: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(82971);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(11368);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
// Imports


var ___CSS_LOADER_EXPORT___ = _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default()));
// Module
___CSS_LOADER_EXPORT___.push([module.id, `/*-----------------------------------------------------------------------------
| Copyright (c) Jupyter Development Team.
| Distributed under the terms of the Modified BSD License.
|----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------
| Placeholder
|----------------------------------------------------------------------------*/

.jp-Placeholder {
  display: flex;
  flex-direction: row;
  width: 100%;
}

.jp-Placeholder-prompt {
  flex: 0 0 var(--jp-cell-prompt-width);
  box-sizing: border-box;
}

.jp-Placeholder-content {
  flex: 1 1 auto;
  padding: 4px 6px;
  border: 1px solid transparent;
  border-radius: 0;
  background: none;
  box-sizing: border-box;
  cursor: pointer;
}

.jp-Placeholder-contentContainer {
  display: flex;
}

.jp-Placeholder-content:hover,
.jp-InputPlaceholder > .jp-Placeholder-content:hover {
  border-color: var(--jp-layout-color3);
}

.jp-Placeholder-content .jp-MoreHorizIcon {
  width: 32px;
  height: 16px;
  border: 1px solid transparent;
  border-radius: var(--jp-border-radius);
}

.jp-Placeholder-content .jp-MoreHorizIcon:hover {
  border: 1px solid var(--jp-border-color1);
  box-shadow: var(--jp-toolbar-box-shadow);
  background-color: var(--jp-layout-color0);
}

.jp-PlaceholderText {
  white-space: nowrap;
  overflow-x: hidden;
  color: var(--jp-inverse-layout-color3);
  font-family: var(--jp-code-font-family);
}

.jp-InputPlaceholder > .jp-Placeholder-content {
  border-color: var(--jp-cell-editor-border-color);
  background: var(--jp-cell-editor-background);
}

/*-----------------------------------------------------------------------------
| Print
|----------------------------------------------------------------------------*/
@media print {
  .jp-Placeholder {
    display: table;
    table-layout: fixed;
  }

  .jp-Placeholder-content {
    display: table-cell;
  }

  .jp-Placeholder-prompt {
    display: table-cell;
  }
}
`, "",{"version":3,"sources":["webpack://./../node_modules/@jupyterlab/cells/style/placeholder.css"],"names":[],"mappings":"AAAA;;;8EAG8E;;AAE9E;;8EAE8E;;AAE9E;EACE,aAAa;EACb,mBAAmB;EACnB,WAAW;AACb;;AAEA;EACE,qCAAqC;EACrC,sBAAsB;AACxB;;AAEA;EACE,cAAc;EACd,gBAAgB;EAChB,6BAA6B;EAC7B,gBAAgB;EAChB,gBAAgB;EAChB,sBAAsB;EACtB,eAAe;AACjB;;AAEA;EACE,aAAa;AACf;;AAEA;;EAEE,qCAAqC;AACvC;;AAEA;EACE,WAAW;EACX,YAAY;EACZ,6BAA6B;EAC7B,sCAAsC;AACxC;;AAEA;EACE,yCAAyC;EACzC,wCAAwC;EACxC,yCAAyC;AAC3C;;AAEA;EACE,mBAAmB;EACnB,kBAAkB;EAClB,sCAAsC;EACtC,uCAAuC;AACzC;;AAEA;EACE,gDAAgD;EAChD,4CAA4C;AAC9C;;AAEA;;8EAE8E;AAC9E;EACE;IACE,cAAc;IACd,mBAAmB;EACrB;;EAEA;IACE,mBAAmB;EACrB;;EAEA;IACE,mBAAmB;EACrB;AACF","sourcesContent":["/*-----------------------------------------------------------------------------\n| Copyright (c) Jupyter Development Team.\n| Distributed under the terms of the Modified BSD License.\n|----------------------------------------------------------------------------*/\n\n/*-----------------------------------------------------------------------------\n| Placeholder\n|----------------------------------------------------------------------------*/\n\n.jp-Placeholder {\n  display: flex;\n  flex-direction: row;\n  width: 100%;\n}\n\n.jp-Placeholder-prompt {\n  flex: 0 0 var(--jp-cell-prompt-width);\n  box-sizing: border-box;\n}\n\n.jp-Placeholder-content {\n  flex: 1 1 auto;\n  padding: 4px 6px;\n  border: 1px solid transparent;\n  border-radius: 0;\n  background: none;\n  box-sizing: border-box;\n  cursor: pointer;\n}\n\n.jp-Placeholder-contentContainer {\n  display: flex;\n}\n\n.jp-Placeholder-content:hover,\n.jp-InputPlaceholder > .jp-Placeholder-content:hover {\n  border-color: var(--jp-layout-color3);\n}\n\n.jp-Placeholder-content .jp-MoreHorizIcon {\n  width: 32px;\n  height: 16px;\n  border: 1px solid transparent;\n  border-radius: var(--jp-border-radius);\n}\n\n.jp-Placeholder-content .jp-MoreHorizIcon:hover {\n  border: 1px solid var(--jp-border-color1);\n  box-shadow: var(--jp-toolbar-box-shadow);\n  background-color: var(--jp-layout-color0);\n}\n\n.jp-PlaceholderText {\n  white-space: nowrap;\n  overflow-x: hidden;\n  color: var(--jp-inverse-layout-color3);\n  font-family: var(--jp-code-font-family);\n}\n\n.jp-InputPlaceholder > .jp-Placeholder-content {\n  border-color: var(--jp-cell-editor-border-color);\n  background: var(--jp-cell-editor-background);\n}\n\n/*-----------------------------------------------------------------------------\n| Print\n|----------------------------------------------------------------------------*/\n@media print {\n  .jp-Placeholder {\n    display: table;\n    table-layout: fixed;\n  }\n\n  .jp-Placeholder-content {\n    display: table-cell;\n  }\n\n  .jp-Placeholder-prompt {\n    display: table-cell;\n  }\n}\n"],"sourceRoot":""}]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ 63324:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Z: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(82971);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(11368);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
// Imports


var ___CSS_LOADER_EXPORT___ = _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default()));
// Module
___CSS_LOADER_EXPORT___.push([module.id, `/*-----------------------------------------------------------------------------
| Copyright (c) Jupyter Development Team.
| Distributed under the terms of the Modified BSD License.
|----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------
| Private CSS variables
|----------------------------------------------------------------------------*/

:root {
  --jp-private-cell-scrolling-output-offset: 5px;
}

/*-----------------------------------------------------------------------------
| Cell
|----------------------------------------------------------------------------*/

.jp-Cell {
  padding: var(--jp-cell-padding);
  margin: 0;
  border: none;
  outline: none;
  background: transparent;
}

/*-----------------------------------------------------------------------------
| Common input/output
|----------------------------------------------------------------------------*/

.jp-Cell-inputWrapper,
.jp-Cell-outputWrapper {
  display: flex;
  flex-direction: row;
  padding: 0;
  margin: 0;

  /* Added to reveal the box-shadow on the input and output collapsers. */
  overflow: visible;
}

/* Only input/output areas inside cells */
.jp-Cell-inputArea,
.jp-Cell-outputArea {
  flex: 1 1 auto;
}

/*-----------------------------------------------------------------------------
| Collapser
|----------------------------------------------------------------------------*/

/* Make the output collapser disappear when there is not output, but do so
 * in a manner that leaves it in the layout and preserves its width.
 */
.jp-Cell.jp-mod-noOutputs .jp-Cell-outputCollapser {
  border: none !important;
  background: transparent !important;
}

.jp-Cell:not(.jp-mod-noOutputs) .jp-Cell-outputCollapser {
  min-height: var(--jp-cell-collapser-min-height);
}

/*-----------------------------------------------------------------------------
| Output
|----------------------------------------------------------------------------*/

/* Put a space between input and output when there IS output */
.jp-Cell:not(.jp-mod-noOutputs) .jp-Cell-outputWrapper {
  margin-top: 5px;
}

.jp-CodeCell.jp-mod-outputsScrolled .jp-Cell-outputArea {
  overflow-y: auto;
  max-height: 24em;
  margin-left: var(--jp-private-cell-scrolling-output-offset);
  resize: vertical;
}

.jp-CodeCell.jp-mod-outputsScrolled .jp-Cell-outputArea[style*='height'] {
  max-height: unset;
}

.jp-CodeCell.jp-mod-outputsScrolled .jp-Cell-outputArea::after {
  content: ' ';
  box-shadow: inset 0 0 6px 2px rgb(0 0 0 / 30%);
  width: 100%;
  height: 100%;
  position: sticky;
  bottom: 0;
  top: 0;
  margin-top: -50%;
  float: left;
  display: block;
  pointer-events: none;
}

.jp-CodeCell.jp-mod-outputsScrolled .jp-OutputArea-child {
  padding-top: 6px;
}

.jp-CodeCell.jp-mod-outputsScrolled .jp-OutputArea-prompt {
  width: calc(
    var(--jp-cell-prompt-width) - var(--jp-private-cell-scrolling-output-offset)
  );
  flex: 0 0
    calc(
      var(--jp-cell-prompt-width) -
        var(--jp-private-cell-scrolling-output-offset)
    );
}

.jp-CodeCell.jp-mod-outputsScrolled .jp-OutputArea-promptOverlay {
  left: calc(-1 * var(--jp-private-cell-scrolling-output-offset));
}

/*-----------------------------------------------------------------------------
| CodeCell
|----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------
| MarkdownCell
|----------------------------------------------------------------------------*/

.jp-MarkdownOutput {
  flex: 1 1 auto;
  width: 100%;
  margin-top: 0;
  margin-bottom: 0;
  padding-left: var(--jp-code-padding);
}

.jp-MarkdownOutput.jp-RenderedHTMLCommon {
  overflow: auto;
}

/* collapseHeadingButton (show always if hiddenCellsButton is _not_ shown) */
.jp-collapseHeadingButton {
  display: flex;
  min-height: var(--jp-cell-collapser-min-height);
  font-size: var(--jp-code-font-size);
  position: absolute;
  background-color: transparent;
  background-size: 25px;
  background-repeat: no-repeat;
  background-position-x: center;
  background-position-y: top;
  background-image: var(--jp-icon-caret-down);
  right: 0;
  top: 0;
  bottom: 0;
}

.jp-collapseHeadingButton.jp-mod-collapsed {
  background-image: var(--jp-icon-caret-right);
}

/*
 set the container font size to match that of content
 so that the nested collapse buttons have the right size
*/
.jp-MarkdownCell .jp-InputPrompt {
  font-size: var(--jp-content-font-size1);
}

/*
  Align collapseHeadingButton with cell top header
  The font sizes are identical to the ones in packages/rendermime/style/base.css
*/
.jp-mod-rendered .jp-collapseHeadingButton[data-heading-level='1'] {
  font-size: var(--jp-content-font-size5);
  background-position-y: calc(0.3 * var(--jp-content-font-size5));
}

.jp-mod-rendered .jp-collapseHeadingButton[data-heading-level='2'] {
  font-size: var(--jp-content-font-size4);
  background-position-y: calc(0.3 * var(--jp-content-font-size4));
}

.jp-mod-rendered .jp-collapseHeadingButton[data-heading-level='3'] {
  font-size: var(--jp-content-font-size3);
  background-position-y: calc(0.3 * var(--jp-content-font-size3));
}

.jp-mod-rendered .jp-collapseHeadingButton[data-heading-level='4'] {
  font-size: var(--jp-content-font-size2);
  background-position-y: calc(0.3 * var(--jp-content-font-size2));
}

.jp-mod-rendered .jp-collapseHeadingButton[data-heading-level='5'] {
  font-size: var(--jp-content-font-size1);
  background-position-y: top;
}

.jp-mod-rendered .jp-collapseHeadingButton[data-heading-level='6'] {
  font-size: var(--jp-content-font-size0);
  background-position-y: top;
}

/* collapseHeadingButton (show only on (hover,active) if hiddenCellsButton is shown) */
.jp-Notebook.jp-mod-showHiddenCellsButton .jp-collapseHeadingButton {
  display: none;
}

.jp-Notebook.jp-mod-showHiddenCellsButton
  :is(.jp-MarkdownCell:hover, .jp-mod-active)
  .jp-collapseHeadingButton {
  display: flex;
}

/* showHiddenCellsButton (only show if jp-mod-showHiddenCellsButton is set, which
is a consequence of the showHiddenCellsButton option in Notebook Settings)*/
.jp-Notebook.jp-mod-showHiddenCellsButton .jp-showHiddenCellsButton {
  margin-left: calc(var(--jp-cell-prompt-width) + 2 * var(--jp-code-padding));
  margin-top: var(--jp-code-padding);
  border: 1px solid var(--jp-border-color2);
  background-color: var(--jp-border-color3) !important;
  color: var(--jp-content-font-color0) !important;
  display: flex;
}

.jp-Notebook.jp-mod-showHiddenCellsButton .jp-showHiddenCellsButton:hover {
  background-color: var(--jp-border-color2) !important;
}

.jp-showHiddenCellsButton {
  display: none;
}

/*-----------------------------------------------------------------------------
| Printing
|----------------------------------------------------------------------------*/

/*
Using block instead of flex to allow the use of the break-inside CSS property for
cell outputs.
*/

@media print {
  .jp-Cell-inputWrapper,
  .jp-Cell-outputWrapper {
    display: block;
  }

  .jp-MarkdownOutput {
    display: table-cell;
  }
}
`, "",{"version":3,"sources":["webpack://./../node_modules/@jupyterlab/cells/style/widget.css"],"names":[],"mappings":"AAAA;;;8EAG8E;;AAE9E;;8EAE8E;;AAE9E;EACE,8CAA8C;AAChD;;AAEA;;8EAE8E;;AAE9E;EACE,+BAA+B;EAC/B,SAAS;EACT,YAAY;EACZ,aAAa;EACb,uBAAuB;AACzB;;AAEA;;8EAE8E;;AAE9E;;EAEE,aAAa;EACb,mBAAmB;EACnB,UAAU;EACV,SAAS;;EAET,uEAAuE;EACvE,iBAAiB;AACnB;;AAEA,yCAAyC;AACzC;;EAEE,cAAc;AAChB;;AAEA;;8EAE8E;;AAE9E;;EAEE;AACF;EACE,uBAAuB;EACvB,kCAAkC;AACpC;;AAEA;EACE,+CAA+C;AACjD;;AAEA;;8EAE8E;;AAE9E,8DAA8D;AAC9D;EACE,eAAe;AACjB;;AAEA;EACE,gBAAgB;EAChB,gBAAgB;EAChB,2DAA2D;EAC3D,gBAAgB;AAClB;;AAEA;EACE,iBAAiB;AACnB;;AAEA;EACE,YAAY;EACZ,8CAA8C;EAC9C,WAAW;EACX,YAAY;EACZ,gBAAgB;EAChB,SAAS;EACT,MAAM;EACN,gBAAgB;EAChB,WAAW;EACX,cAAc;EACd,oBAAoB;AACtB;;AAEA;EACE,gBAAgB;AAClB;;AAEA;EACE;;GAEC;EACD;;;;KAIG;AACL;;AAEA;EACE,+DAA+D;AACjE;;AAEA;;8EAE8E;;AAE9E;;8EAE8E;;AAE9E;EACE,cAAc;EACd,WAAW;EACX,aAAa;EACb,gBAAgB;EAChB,oCAAoC;AACtC;;AAEA;EACE,cAAc;AAChB;;AAEA,4EAA4E;AAC5E;EACE,aAAa;EACb,+CAA+C;EAC/C,mCAAmC;EACnC,kBAAkB;EAClB,6BAA6B;EAC7B,qBAAqB;EACrB,4BAA4B;EAC5B,6BAA6B;EAC7B,0BAA0B;EAC1B,2CAA2C;EAC3C,QAAQ;EACR,MAAM;EACN,SAAS;AACX;;AAEA;EACE,4CAA4C;AAC9C;;AAEA;;;CAGC;AACD;EACE,uCAAuC;AACzC;;AAEA;;;CAGC;AACD;EACE,uCAAuC;EACvC,+DAA+D;AACjE;;AAEA;EACE,uCAAuC;EACvC,+DAA+D;AACjE;;AAEA;EACE,uCAAuC;EACvC,+DAA+D;AACjE;;AAEA;EACE,uCAAuC;EACvC,+DAA+D;AACjE;;AAEA;EACE,uCAAuC;EACvC,0BAA0B;AAC5B;;AAEA;EACE,uCAAuC;EACvC,0BAA0B;AAC5B;;AAEA,sFAAsF;AACtF;EACE,aAAa;AACf;;AAEA;;;EAGE,aAAa;AACf;;AAEA;2EAC2E;AAC3E;EACE,2EAA2E;EAC3E,kCAAkC;EAClC,yCAAyC;EACzC,oDAAoD;EACpD,+CAA+C;EAC/C,aAAa;AACf;;AAEA;EACE,oDAAoD;AACtD;;AAEA;EACE,aAAa;AACf;;AAEA;;8EAE8E;;AAE9E;;;CAGC;;AAED;EACE;;IAEE,cAAc;EAChB;;EAEA;IACE,mBAAmB;EACrB;AACF","sourcesContent":["/*-----------------------------------------------------------------------------\n| Copyright (c) Jupyter Development Team.\n| Distributed under the terms of the Modified BSD License.\n|----------------------------------------------------------------------------*/\n\n/*-----------------------------------------------------------------------------\n| Private CSS variables\n|----------------------------------------------------------------------------*/\n\n:root {\n  --jp-private-cell-scrolling-output-offset: 5px;\n}\n\n/*-----------------------------------------------------------------------------\n| Cell\n|----------------------------------------------------------------------------*/\n\n.jp-Cell {\n  padding: var(--jp-cell-padding);\n  margin: 0;\n  border: none;\n  outline: none;\n  background: transparent;\n}\n\n/*-----------------------------------------------------------------------------\n| Common input/output\n|----------------------------------------------------------------------------*/\n\n.jp-Cell-inputWrapper,\n.jp-Cell-outputWrapper {\n  display: flex;\n  flex-direction: row;\n  padding: 0;\n  margin: 0;\n\n  /* Added to reveal the box-shadow on the input and output collapsers. */\n  overflow: visible;\n}\n\n/* Only input/output areas inside cells */\n.jp-Cell-inputArea,\n.jp-Cell-outputArea {\n  flex: 1 1 auto;\n}\n\n/*-----------------------------------------------------------------------------\n| Collapser\n|----------------------------------------------------------------------------*/\n\n/* Make the output collapser disappear when there is not output, but do so\n * in a manner that leaves it in the layout and preserves its width.\n */\n.jp-Cell.jp-mod-noOutputs .jp-Cell-outputCollapser {\n  border: none !important;\n  background: transparent !important;\n}\n\n.jp-Cell:not(.jp-mod-noOutputs) .jp-Cell-outputCollapser {\n  min-height: var(--jp-cell-collapser-min-height);\n}\n\n/*-----------------------------------------------------------------------------\n| Output\n|----------------------------------------------------------------------------*/\n\n/* Put a space between input and output when there IS output */\n.jp-Cell:not(.jp-mod-noOutputs) .jp-Cell-outputWrapper {\n  margin-top: 5px;\n}\n\n.jp-CodeCell.jp-mod-outputsScrolled .jp-Cell-outputArea {\n  overflow-y: auto;\n  max-height: 24em;\n  margin-left: var(--jp-private-cell-scrolling-output-offset);\n  resize: vertical;\n}\n\n.jp-CodeCell.jp-mod-outputsScrolled .jp-Cell-outputArea[style*='height'] {\n  max-height: unset;\n}\n\n.jp-CodeCell.jp-mod-outputsScrolled .jp-Cell-outputArea::after {\n  content: ' ';\n  box-shadow: inset 0 0 6px 2px rgb(0 0 0 / 30%);\n  width: 100%;\n  height: 100%;\n  position: sticky;\n  bottom: 0;\n  top: 0;\n  margin-top: -50%;\n  float: left;\n  display: block;\n  pointer-events: none;\n}\n\n.jp-CodeCell.jp-mod-outputsScrolled .jp-OutputArea-child {\n  padding-top: 6px;\n}\n\n.jp-CodeCell.jp-mod-outputsScrolled .jp-OutputArea-prompt {\n  width: calc(\n    var(--jp-cell-prompt-width) - var(--jp-private-cell-scrolling-output-offset)\n  );\n  flex: 0 0\n    calc(\n      var(--jp-cell-prompt-width) -\n        var(--jp-private-cell-scrolling-output-offset)\n    );\n}\n\n.jp-CodeCell.jp-mod-outputsScrolled .jp-OutputArea-promptOverlay {\n  left: calc(-1 * var(--jp-private-cell-scrolling-output-offset));\n}\n\n/*-----------------------------------------------------------------------------\n| CodeCell\n|----------------------------------------------------------------------------*/\n\n/*-----------------------------------------------------------------------------\n| MarkdownCell\n|----------------------------------------------------------------------------*/\n\n.jp-MarkdownOutput {\n  flex: 1 1 auto;\n  width: 100%;\n  margin-top: 0;\n  margin-bottom: 0;\n  padding-left: var(--jp-code-padding);\n}\n\n.jp-MarkdownOutput.jp-RenderedHTMLCommon {\n  overflow: auto;\n}\n\n/* collapseHeadingButton (show always if hiddenCellsButton is _not_ shown) */\n.jp-collapseHeadingButton {\n  display: flex;\n  min-height: var(--jp-cell-collapser-min-height);\n  font-size: var(--jp-code-font-size);\n  position: absolute;\n  background-color: transparent;\n  background-size: 25px;\n  background-repeat: no-repeat;\n  background-position-x: center;\n  background-position-y: top;\n  background-image: var(--jp-icon-caret-down);\n  right: 0;\n  top: 0;\n  bottom: 0;\n}\n\n.jp-collapseHeadingButton.jp-mod-collapsed {\n  background-image: var(--jp-icon-caret-right);\n}\n\n/*\n set the container font size to match that of content\n so that the nested collapse buttons have the right size\n*/\n.jp-MarkdownCell .jp-InputPrompt {\n  font-size: var(--jp-content-font-size1);\n}\n\n/*\n  Align collapseHeadingButton with cell top header\n  The font sizes are identical to the ones in packages/rendermime/style/base.css\n*/\n.jp-mod-rendered .jp-collapseHeadingButton[data-heading-level='1'] {\n  font-size: var(--jp-content-font-size5);\n  background-position-y: calc(0.3 * var(--jp-content-font-size5));\n}\n\n.jp-mod-rendered .jp-collapseHeadingButton[data-heading-level='2'] {\n  font-size: var(--jp-content-font-size4);\n  background-position-y: calc(0.3 * var(--jp-content-font-size4));\n}\n\n.jp-mod-rendered .jp-collapseHeadingButton[data-heading-level='3'] {\n  font-size: var(--jp-content-font-size3);\n  background-position-y: calc(0.3 * var(--jp-content-font-size3));\n}\n\n.jp-mod-rendered .jp-collapseHeadingButton[data-heading-level='4'] {\n  font-size: var(--jp-content-font-size2);\n  background-position-y: calc(0.3 * var(--jp-content-font-size2));\n}\n\n.jp-mod-rendered .jp-collapseHeadingButton[data-heading-level='5'] {\n  font-size: var(--jp-content-font-size1);\n  background-position-y: top;\n}\n\n.jp-mod-rendered .jp-collapseHeadingButton[data-heading-level='6'] {\n  font-size: var(--jp-content-font-size0);\n  background-position-y: top;\n}\n\n/* collapseHeadingButton (show only on (hover,active) if hiddenCellsButton is shown) */\n.jp-Notebook.jp-mod-showHiddenCellsButton .jp-collapseHeadingButton {\n  display: none;\n}\n\n.jp-Notebook.jp-mod-showHiddenCellsButton\n  :is(.jp-MarkdownCell:hover, .jp-mod-active)\n  .jp-collapseHeadingButton {\n  display: flex;\n}\n\n/* showHiddenCellsButton (only show if jp-mod-showHiddenCellsButton is set, which\nis a consequence of the showHiddenCellsButton option in Notebook Settings)*/\n.jp-Notebook.jp-mod-showHiddenCellsButton .jp-showHiddenCellsButton {\n  margin-left: calc(var(--jp-cell-prompt-width) + 2 * var(--jp-code-padding));\n  margin-top: var(--jp-code-padding);\n  border: 1px solid var(--jp-border-color2);\n  background-color: var(--jp-border-color3) !important;\n  color: var(--jp-content-font-color0) !important;\n  display: flex;\n}\n\n.jp-Notebook.jp-mod-showHiddenCellsButton .jp-showHiddenCellsButton:hover {\n  background-color: var(--jp-border-color2) !important;\n}\n\n.jp-showHiddenCellsButton {\n  display: none;\n}\n\n/*-----------------------------------------------------------------------------\n| Printing\n|----------------------------------------------------------------------------*/\n\n/*\nUsing block instead of flex to allow the use of the break-inside CSS property for\ncell outputs.\n*/\n\n@media print {\n  .jp-Cell-inputWrapper,\n  .jp-Cell-outputWrapper {\n    display: block;\n  }\n\n  .jp-MarkdownOutput {\n    display: table-cell;\n  }\n}\n"],"sourceRoot":""}]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ 34188:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Z: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(82971);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(11368);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
// Imports


var ___CSS_LOADER_EXPORT___ = _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default()));
// Module
___CSS_LOADER_EXPORT___.push([module.id, `/*
 * Copyright (c) Jupyter Development Team.
 * Distributed under the terms of the Modified BSD License.
 */

:root {
  --jp-add-tag-extra-width: 8px;
}

.jp-CellTags-Tag {
  height: 20px;
  border-radius: 10px;
  margin-right: 5px;
  margin-bottom: 10px;
  padding: 0 8px;
  font-size: var(--jp-ui-font-size1);
  display: inline-flex;
  justify-content: center;
  align-items: center;
  max-width: calc(100% - 25px);
  border: 1px solid var(--jp-border-color1);
  color: var(--jp-ui-font-color1);
  -webkit-touch-callout: none;
  -webkit-user-select: none;
  -khtml-user-select: none;
  -moz-user-select: none;
  -ms-user-select: none;
  user-select: none;
}

.jp-CellTags-Unapplied {
  background-color: var(--jp-layout-color2);
}

.jp-CellTags-Applied {
  background-color: var(--jp-layout-color3);
}

.jp-CellTags-Add {
  white-space: nowrap;
  overflow: hidden;
  border: none;
  outline: none;
  resize: horizontal;
  font-size: var(--jp-ui-font-size1);
  color: var(--jp-ui-font-color1);
  background: var(--jp-layout-color2);
}

.jp-CellTags-Holder {
  display: flex;
  justify-content: center;
  align-items: center;
}

.jp-CellTags-Empty {
  width: 4em;
}
`, "",{"version":3,"sources":["webpack://./../node_modules/@jupyterlab/celltags-extension/style/base.css"],"names":[],"mappings":"AAAA;;;EAGE;;AAEF;EACE,6BAA6B;AAC/B;;AAEA;EACE,YAAY;EACZ,mBAAmB;EACnB,iBAAiB;EACjB,mBAAmB;EACnB,cAAc;EACd,kCAAkC;EAClC,oBAAoB;EACpB,uBAAuB;EACvB,mBAAmB;EACnB,4BAA4B;EAC5B,yCAAyC;EACzC,+BAA+B;EAC/B,2BAA2B;EAC3B,yBAAyB;EACzB,wBAAwB;EACxB,sBAAsB;EACtB,qBAAqB;EACrB,iBAAiB;AACnB;;AAEA;EACE,yCAAyC;AAC3C;;AAEA;EACE,yCAAyC;AAC3C;;AAEA;EACE,mBAAmB;EACnB,gBAAgB;EAChB,YAAY;EACZ,aAAa;EACb,kBAAkB;EAClB,kCAAkC;EAClC,+BAA+B;EAC/B,mCAAmC;AACrC;;AAEA;EACE,aAAa;EACb,uBAAuB;EACvB,mBAAmB;AACrB;;AAEA;EACE,UAAU;AACZ","sourcesContent":["/*\n * Copyright (c) Jupyter Development Team.\n * Distributed under the terms of the Modified BSD License.\n */\n\n:root {\n  --jp-add-tag-extra-width: 8px;\n}\n\n.jp-CellTags-Tag {\n  height: 20px;\n  border-radius: 10px;\n  margin-right: 5px;\n  margin-bottom: 10px;\n  padding: 0 8px;\n  font-size: var(--jp-ui-font-size1);\n  display: inline-flex;\n  justify-content: center;\n  align-items: center;\n  max-width: calc(100% - 25px);\n  border: 1px solid var(--jp-border-color1);\n  color: var(--jp-ui-font-color1);\n  -webkit-touch-callout: none;\n  -webkit-user-select: none;\n  -khtml-user-select: none;\n  -moz-user-select: none;\n  -ms-user-select: none;\n  user-select: none;\n}\n\n.jp-CellTags-Unapplied {\n  background-color: var(--jp-layout-color2);\n}\n\n.jp-CellTags-Applied {\n  background-color: var(--jp-layout-color3);\n}\n\n.jp-CellTags-Add {\n  white-space: nowrap;\n  overflow: hidden;\n  border: none;\n  outline: none;\n  resize: horizontal;\n  font-size: var(--jp-ui-font-size1);\n  color: var(--jp-ui-font-color1);\n  background: var(--jp-layout-color2);\n}\n\n.jp-CellTags-Holder {\n  display: flex;\n  justify-content: center;\n  align-items: center;\n}\n\n.jp-CellTags-Empty {\n  width: 4em;\n}\n"],"sourceRoot":""}]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ 63988:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Z: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(82971);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(11368);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _builder_node_modules_css_loader_dist_cjs_js_linecol_css__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(70139);
// Imports



var ___CSS_LOADER_EXPORT___ = _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default()));
___CSS_LOADER_EXPORT___.i(_builder_node_modules_css_loader_dist_cjs_js_linecol_css__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z);
// Module
___CSS_LOADER_EXPORT___.push([module.id, `/*-----------------------------------------------------------------------------
| Copyright (c) Jupyter Development Team.
| Distributed under the terms of the Modified BSD License.
|----------------------------------------------------------------------------*/

.jp-JSONEditor {
  display: flex;
  flex-direction: column;
  width: 100%;
}

.jp-JSONEditor-host {
  flex: 1 1 auto;
  border: var(--jp-border-width) solid var(--jp-input-border-color);
  border-radius: 0;
  background: var(--jp-layout-color0);
  min-height: 50px;
  padding: 1px;
}

.jp-JSONEditor.jp-mod-error .jp-JSONEditor-host {
  border-color: red;
  outline-color: red;
}

.jp-JSONEditor-header {
  display: flex;
  flex: 1 0 auto;
  padding: 0 0 0 12px;
}

.jp-JSONEditor-header label {
  flex: 0 0 auto;
}

.jp-JSONEditor-commitButton {
  height: 16px;
  width: 16px;
  background-size: 18px;
  background-repeat: no-repeat;
  background-position: center;
}

.jp-JSONEditor-host.jp-mod-focused {
  background-color: var(--jp-input-active-background);
  border: 1px solid var(--jp-input-active-border-color);
  box-shadow: var(--jp-input-box-shadow);
}

.jp-Editor.jp-mod-dropTarget {
  border: var(--jp-border-width) solid var(--jp-input-active-border-color);
  box-shadow: var(--jp-input-box-shadow);
}
`, "",{"version":3,"sources":["webpack://./../node_modules/@jupyterlab/codeeditor/style/base.css"],"names":[],"mappings":"AAAA;;;8EAG8E;;AAG9E;EACE,aAAa;EACb,sBAAsB;EACtB,WAAW;AACb;;AAEA;EACE,cAAc;EACd,iEAAiE;EACjE,gBAAgB;EAChB,mCAAmC;EACnC,gBAAgB;EAChB,YAAY;AACd;;AAEA;EACE,iBAAiB;EACjB,kBAAkB;AACpB;;AAEA;EACE,aAAa;EACb,cAAc;EACd,mBAAmB;AACrB;;AAEA;EACE,cAAc;AAChB;;AAEA;EACE,YAAY;EACZ,WAAW;EACX,qBAAqB;EACrB,4BAA4B;EAC5B,2BAA2B;AAC7B;;AAEA;EACE,mDAAmD;EACnD,qDAAqD;EACrD,sCAAsC;AACxC;;AAEA;EACE,wEAAwE;EACxE,sCAAsC;AACxC","sourcesContent":["/*-----------------------------------------------------------------------------\n| Copyright (c) Jupyter Development Team.\n| Distributed under the terms of the Modified BSD License.\n|----------------------------------------------------------------------------*/\n@import url('./linecol.css');\n\n.jp-JSONEditor {\n  display: flex;\n  flex-direction: column;\n  width: 100%;\n}\n\n.jp-JSONEditor-host {\n  flex: 1 1 auto;\n  border: var(--jp-border-width) solid var(--jp-input-border-color);\n  border-radius: 0;\n  background: var(--jp-layout-color0);\n  min-height: 50px;\n  padding: 1px;\n}\n\n.jp-JSONEditor.jp-mod-error .jp-JSONEditor-host {\n  border-color: red;\n  outline-color: red;\n}\n\n.jp-JSONEditor-header {\n  display: flex;\n  flex: 1 0 auto;\n  padding: 0 0 0 12px;\n}\n\n.jp-JSONEditor-header label {\n  flex: 0 0 auto;\n}\n\n.jp-JSONEditor-commitButton {\n  height: 16px;\n  width: 16px;\n  background-size: 18px;\n  background-repeat: no-repeat;\n  background-position: center;\n}\n\n.jp-JSONEditor-host.jp-mod-focused {\n  background-color: var(--jp-input-active-background);\n  border: 1px solid var(--jp-input-active-border-color);\n  box-shadow: var(--jp-input-box-shadow);\n}\n\n.jp-Editor.jp-mod-dropTarget {\n  border: var(--jp-border-width) solid var(--jp-input-active-border-color);\n  box-shadow: var(--jp-input-box-shadow);\n}\n"],"sourceRoot":""}]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ 70139:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Z: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(82971);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(11368);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
// Imports


var ___CSS_LOADER_EXPORT___ = _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default()));
// Module
___CSS_LOADER_EXPORT___.push([module.id, `/*
 * Copyright (c) Jupyter Development Team.
 * Distributed under the terms of the Modified BSD License.
 */

.jp-lineFormSearch {
  padding: 4px 12px;
  background-color: var(--jp-layout-color2);
  box-shadow: var(--jp-toolbar-box-shadow);
  z-index: 2;
  font-size: var(--jp-ui-font-size1);
}

.jp-lineFormCaption {
  font-size: var(--jp-ui-font-size0);
  line-height: var(--jp-ui-font-size1);
  margin-top: 4px;
  color: var(--jp-ui-font-color0);
}

.jp-baseLineForm {
  border: none;
  border-top-right-radius: var(--jp-border-radius);
  border-bottom-right-radius: var(--jp-border-radius);
  position: absolute;
  background-size: 16px;
  background-repeat: no-repeat;
  background-position: center;
  outline: none;
}

.jp-lineFormButtonContainer {
  top: 4px;
  right: 8px;
  height: 24px;
  padding: 0 12px;
  width: 12px;
}

.jp-lineFormButtonIcon {
  top: 0;
  right: 0;
  background-color: var(--jp-brand-color1);
  height: 100%;
  width: 100%;
  box-sizing: border-box;
  padding: 4px 6px;
}

.jp-lineFormButton {
  top: 0;
  right: 0;
  background-color: transparent;
  height: 100%;
  width: 100%;
  box-sizing: border-box;
}

.jp-lineFormWrapper {
  overflow: hidden;
  padding: 0 8px;
  border: 1px solid var(--jp-border-color0);
  border-top-left-radius: var(--jp-border-radius);
  border-bottom-left-radius: var(--jp-border-radius);
  background-color: var(--jp-input-active-background);
  height: 22px;
}

.jp-lineFormWrapperFocusWithin {
  border: var(--jp-border-width) solid var(--jp-input-active-border-color);
  box-shadow: var(--jp-input-box-shadow);
}

.jp-lineFormInput {
  background: transparent;
  width: 200px;
  height: 100%;
  border: none;
  outline: none;
  color: var(--jp-ui-font-color0);
  padding: 0;
}
`, "",{"version":3,"sources":["webpack://./../node_modules/@jupyterlab/codeeditor/style/linecol.css"],"names":[],"mappings":"AAAA;;;EAGE;;AAEF;EACE,iBAAiB;EACjB,yCAAyC;EACzC,wCAAwC;EACxC,UAAU;EACV,kCAAkC;AACpC;;AAEA;EACE,kCAAkC;EAClC,oCAAoC;EACpC,eAAe;EACf,+BAA+B;AACjC;;AAEA;EACE,YAAY;EACZ,gDAAgD;EAChD,mDAAmD;EACnD,kBAAkB;EAClB,qBAAqB;EACrB,4BAA4B;EAC5B,2BAA2B;EAC3B,aAAa;AACf;;AAEA;EACE,QAAQ;EACR,UAAU;EACV,YAAY;EACZ,eAAe;EACf,WAAW;AACb;;AAEA;EACE,MAAM;EACN,QAAQ;EACR,wCAAwC;EACxC,YAAY;EACZ,WAAW;EACX,sBAAsB;EACtB,gBAAgB;AAClB;;AAEA;EACE,MAAM;EACN,QAAQ;EACR,6BAA6B;EAC7B,YAAY;EACZ,WAAW;EACX,sBAAsB;AACxB;;AAEA;EACE,gBAAgB;EAChB,cAAc;EACd,yCAAyC;EACzC,+CAA+C;EAC/C,kDAAkD;EAClD,mDAAmD;EACnD,YAAY;AACd;;AAEA;EACE,wEAAwE;EACxE,sCAAsC;AACxC;;AAEA;EACE,uBAAuB;EACvB,YAAY;EACZ,YAAY;EACZ,YAAY;EACZ,aAAa;EACb,+BAA+B;EAC/B,UAAU;AACZ","sourcesContent":["/*\n * Copyright (c) Jupyter Development Team.\n * Distributed under the terms of the Modified BSD License.\n */\n\n.jp-lineFormSearch {\n  padding: 4px 12px;\n  background-color: var(--jp-layout-color2);\n  box-shadow: var(--jp-toolbar-box-shadow);\n  z-index: 2;\n  font-size: var(--jp-ui-font-size1);\n}\n\n.jp-lineFormCaption {\n  font-size: var(--jp-ui-font-size0);\n  line-height: var(--jp-ui-font-size1);\n  margin-top: 4px;\n  color: var(--jp-ui-font-color0);\n}\n\n.jp-baseLineForm {\n  border: none;\n  border-top-right-radius: var(--jp-border-radius);\n  border-bottom-right-radius: var(--jp-border-radius);\n  position: absolute;\n  background-size: 16px;\n  background-repeat: no-repeat;\n  background-position: center;\n  outline: none;\n}\n\n.jp-lineFormButtonContainer {\n  top: 4px;\n  right: 8px;\n  height: 24px;\n  padding: 0 12px;\n  width: 12px;\n}\n\n.jp-lineFormButtonIcon {\n  top: 0;\n  right: 0;\n  background-color: var(--jp-brand-color1);\n  height: 100%;\n  width: 100%;\n  box-sizing: border-box;\n  padding: 4px 6px;\n}\n\n.jp-lineFormButton {\n  top: 0;\n  right: 0;\n  background-color: transparent;\n  height: 100%;\n  width: 100%;\n  box-sizing: border-box;\n}\n\n.jp-lineFormWrapper {\n  overflow: hidden;\n  padding: 0 8px;\n  border: 1px solid var(--jp-border-color0);\n  border-top-left-radius: var(--jp-border-radius);\n  border-bottom-left-radius: var(--jp-border-radius);\n  background-color: var(--jp-input-active-background);\n  height: 22px;\n}\n\n.jp-lineFormWrapperFocusWithin {\n  border: var(--jp-border-width) solid var(--jp-input-active-border-color);\n  box-shadow: var(--jp-input-box-shadow);\n}\n\n.jp-lineFormInput {\n  background: transparent;\n  width: 200px;\n  height: 100%;\n  border: none;\n  outline: none;\n  color: var(--jp-ui-font-color0);\n  padding: 0;\n}\n"],"sourceRoot":""}]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ 3492:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Z: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(82971);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(11368);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_getUrl_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(878);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_getUrl_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_builder_node_modules_css_loader_dist_runtime_getUrl_js__WEBPACK_IMPORTED_MODULE_2__);
// Imports



var ___CSS_LOADER_URL_IMPORT_0___ = new URL(/* asset import */ __webpack_require__(7413), __webpack_require__.b);
var ___CSS_LOADER_EXPORT___ = _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default()));
var ___CSS_LOADER_URL_REPLACEMENT_0___ = _builder_node_modules_css_loader_dist_runtime_getUrl_js__WEBPACK_IMPORTED_MODULE_2___default()(___CSS_LOADER_URL_IMPORT_0___);
// Module
___CSS_LOADER_EXPORT___.push([module.id, `/*-----------------------------------------------------------------------------
| Copyright (c) Jupyter Development Team.
| Distributed under the terms of the Modified BSD License.
|----------------------------------------------------------------------------*/

.cm-editor {
  line-height: var(--jp-code-line-height);
  font-size: var(--jp-code-font-size);
  font-family: var(--jp-code-font-family);
  border: 0;
  border-radius: 0;
  height: auto;

  /* Changed to auto to autogrow */
}

/* Suppress automatic focus indicator outline */
.cm-editor.cm-focused {
  outline: unset;
}

.cm-editor pre {
  padding: 0 var(--jp-code-padding);
}

.jp-CodeMirrorEditor[data-type='inline'] .cm-dialog {
  background-color: var(--jp-layout-color0);
  color: var(--jp-content-font-color1);
}

.jp-CodeMirrorEditor {
  cursor: text;
}

/* When zoomed out 67% and 33% on a screen of 1440 width x 900 height */
@media screen and (width >= 2138px) and (width <= 4319px) {
  .jp-CodeMirrorEditor[data-type='inline'] .cm-cursor {
    border-left: var(--jp-code-cursor-width1) solid
      var(--jp-editor-cursor-color);
  }
}

/* When zoomed out less than 33% */
@media screen and (width >= 4320px) {
  .jp-CodeMirrorEditor[data-type='inline'] .cm-cursor {
    border-left: var(--jp-code-cursor-width2) solid
      var(--jp-editor-cursor-color);
  }
}

/* stylelint-disable selector-max-class */

/* We need all this classes for higher specificity to override CodeMirror's rule */
.cm-editor.jp-mod-readOnly > .cm-scroller > .cm-cursorLayer .cm-cursor {
  display: none;
}

/* stylelint-enable selector-max-class */

.jp-CollaboratorCursor {
  border-left: 5px solid transparent;
  border-right: 5px solid transparent;
  border-top: none;
  border-bottom: 3px solid;
  background-clip: content-box;
  margin-left: -5px;
  margin-right: -5px;
}

.cm-builtin {
  color: var(--jp-mirror-editor-builtin-color);
}

.cm-searching,
.cm-searching span {
  /* \`.cm-searching span\`: we need to override syntax highlighting */
  background-color: var(--jp-search-unselected-match-background-color);
  color: var(--jp-search-unselected-match-color);
}

.cm-searching::selection,
.cm-searching span::selection {
  background-color: var(--jp-search-unselected-match-background-color);
  color: var(--jp-search-unselected-match-color);
}

.jp-current-match > .cm-searching,
.jp-current-match > .cm-searching span,
.cm-searching > .jp-current-match,
.cm-searching > .jp-current-match span {
  background-color: var(--jp-search-selected-match-background-color);
  color: var(--jp-search-selected-match-color);
}

.jp-current-match > .cm-searching::selection,
.jp-current-match > .cm-searching span::selection,
.cm-searching > .jp-current-match::selection,
.cm-searching > .jp-current-match span::selection {
  background-color: var(--jp-search-selected-match-background-color);
  color: var(--jp-search-selected-match-color);
}

.cm-trailingspace {
  background-image: url(${___CSS_LOADER_URL_REPLACEMENT_0___});
  background-position: center left;
  background-repeat: repeat-x;
}

.jp-CollaboratorCursor-hover {
  position: absolute;
  z-index: 1;
  transform: translateX(-50%);
  color: white;
  border-radius: 3px;
  padding-left: 4px;
  padding-right: 4px;
  padding-top: 1px;
  padding-bottom: 1px;
  text-align: center;
  font-size: var(--jp-ui-font-size1);
  white-space: nowrap;
}

.jp-CodeMirror-ruler {
  border-left: 1px dashed var(--jp-border-color2);
}

/* Styles for shared cursors (remote cursor locations and selected ranges) */
.jp-CodeMirrorEditor .cm-ySelectionCaret {
  position: relative;
  border-left: 1px solid black;
  margin-left: -1px;
  margin-right: -1px;
  box-sizing: border-box;
}

.jp-CodeMirrorEditor .cm-ySelectionCaret > .cm-ySelectionInfo {
  white-space: nowrap;
  position: absolute;
  top: -1.15em;
  padding-bottom: 0.05em;
  left: -1px;
  font-size: 0.95em;
  font-family: var(--jp-ui-font-family);
  font-weight: bold;
  line-height: normal;
  user-select: none;
  color: white;
  padding-left: 2px;
  padding-right: 2px;
  z-index: 101;
  transition: opacity 0.3s ease-in-out;
}

.jp-CodeMirrorEditor .cm-ySelectionInfo {
  transition-delay: 0.7s;
  opacity: 0;
}

.jp-CodeMirrorEditor .cm-ySelectionCaret:hover > .cm-ySelectionInfo {
  opacity: 1;
  transition-delay: 0s;
}
`, "",{"version":3,"sources":["webpack://./../node_modules/@jupyterlab/codemirror/style/base.css"],"names":[],"mappings":"AAAA;;;8EAG8E;;AAE9E;EACE,uCAAuC;EACvC,mCAAmC;EACnC,uCAAuC;EACvC,SAAS;EACT,gBAAgB;EAChB,YAAY;;EAEZ,gCAAgC;AAClC;;AAEA,+CAA+C;AAC/C;EACE,cAAc;AAChB;;AAEA;EACE,iCAAiC;AACnC;;AAEA;EACE,yCAAyC;EACzC,oCAAoC;AACtC;;AAEA;EACE,YAAY;AACd;;AAEA,uEAAuE;AACvE;EACE;IACE;mCAC+B;EACjC;AACF;;AAEA,kCAAkC;AAClC;EACE;IACE;mCAC+B;EACjC;AACF;;AAEA,yCAAyC;;AAEzC,kFAAkF;AAClF;EACE,aAAa;AACf;;AAEA,wCAAwC;;AAExC;EACE,kCAAkC;EAClC,mCAAmC;EACnC,gBAAgB;EAChB,wBAAwB;EACxB,4BAA4B;EAC5B,iBAAiB;EACjB,kBAAkB;AACpB;;AAEA;EACE,4CAA4C;AAC9C;;AAEA;;EAEE,kEAAkE;EAClE,oEAAoE;EACpE,8CAA8C;AAChD;;AAEA;;EAEE,oEAAoE;EACpE,8CAA8C;AAChD;;AAEA;;;;EAIE,kEAAkE;EAClE,4CAA4C;AAC9C;;AAEA;;;;EAIE,kEAAkE;EAClE,4CAA4C;AAC9C;;AAEA;EACE,yDAAqW;EACrW,gCAAgC;EAChC,2BAA2B;AAC7B;;AAEA;EACE,kBAAkB;EAClB,UAAU;EACV,2BAA2B;EAC3B,YAAY;EACZ,kBAAkB;EAClB,iBAAiB;EACjB,kBAAkB;EAClB,gBAAgB;EAChB,mBAAmB;EACnB,kBAAkB;EAClB,kCAAkC;EAClC,mBAAmB;AACrB;;AAEA;EACE,+CAA+C;AACjD;;AAEA,4EAA4E;AAC5E;EACE,kBAAkB;EAClB,4BAA4B;EAC5B,iBAAiB;EACjB,kBAAkB;EAClB,sBAAsB;AACxB;;AAEA;EACE,mBAAmB;EACnB,kBAAkB;EAClB,YAAY;EACZ,sBAAsB;EACtB,UAAU;EACV,iBAAiB;EACjB,qCAAqC;EACrC,iBAAiB;EACjB,mBAAmB;EACnB,iBAAiB;EACjB,YAAY;EACZ,iBAAiB;EACjB,kBAAkB;EAClB,YAAY;EACZ,oCAAoC;AACtC;;AAEA;EACE,sBAAsB;EACtB,UAAU;AACZ;;AAEA;EACE,UAAU;EACV,oBAAoB;AACtB","sourcesContent":["/*-----------------------------------------------------------------------------\n| Copyright (c) Jupyter Development Team.\n| Distributed under the terms of the Modified BSD License.\n|----------------------------------------------------------------------------*/\n\n.cm-editor {\n  line-height: var(--jp-code-line-height);\n  font-size: var(--jp-code-font-size);\n  font-family: var(--jp-code-font-family);\n  border: 0;\n  border-radius: 0;\n  height: auto;\n\n  /* Changed to auto to autogrow */\n}\n\n/* Suppress automatic focus indicator outline */\n.cm-editor.cm-focused {\n  outline: unset;\n}\n\n.cm-editor pre {\n  padding: 0 var(--jp-code-padding);\n}\n\n.jp-CodeMirrorEditor[data-type='inline'] .cm-dialog {\n  background-color: var(--jp-layout-color0);\n  color: var(--jp-content-font-color1);\n}\n\n.jp-CodeMirrorEditor {\n  cursor: text;\n}\n\n/* When zoomed out 67% and 33% on a screen of 1440 width x 900 height */\n@media screen and (width >= 2138px) and (width <= 4319px) {\n  .jp-CodeMirrorEditor[data-type='inline'] .cm-cursor {\n    border-left: var(--jp-code-cursor-width1) solid\n      var(--jp-editor-cursor-color);\n  }\n}\n\n/* When zoomed out less than 33% */\n@media screen and (width >= 4320px) {\n  .jp-CodeMirrorEditor[data-type='inline'] .cm-cursor {\n    border-left: var(--jp-code-cursor-width2) solid\n      var(--jp-editor-cursor-color);\n  }\n}\n\n/* stylelint-disable selector-max-class */\n\n/* We need all this classes for higher specificity to override CodeMirror's rule */\n.cm-editor.jp-mod-readOnly > .cm-scroller > .cm-cursorLayer .cm-cursor {\n  display: none;\n}\n\n/* stylelint-enable selector-max-class */\n\n.jp-CollaboratorCursor {\n  border-left: 5px solid transparent;\n  border-right: 5px solid transparent;\n  border-top: none;\n  border-bottom: 3px solid;\n  background-clip: content-box;\n  margin-left: -5px;\n  margin-right: -5px;\n}\n\n.cm-builtin {\n  color: var(--jp-mirror-editor-builtin-color);\n}\n\n.cm-searching,\n.cm-searching span {\n  /* `.cm-searching span`: we need to override syntax highlighting */\n  background-color: var(--jp-search-unselected-match-background-color);\n  color: var(--jp-search-unselected-match-color);\n}\n\n.cm-searching::selection,\n.cm-searching span::selection {\n  background-color: var(--jp-search-unselected-match-background-color);\n  color: var(--jp-search-unselected-match-color);\n}\n\n.jp-current-match > .cm-searching,\n.jp-current-match > .cm-searching span,\n.cm-searching > .jp-current-match,\n.cm-searching > .jp-current-match span {\n  background-color: var(--jp-search-selected-match-background-color);\n  color: var(--jp-search-selected-match-color);\n}\n\n.jp-current-match > .cm-searching::selection,\n.jp-current-match > .cm-searching span::selection,\n.cm-searching > .jp-current-match::selection,\n.cm-searching > .jp-current-match span::selection {\n  background-color: var(--jp-search-selected-match-background-color);\n  color: var(--jp-search-selected-match-color);\n}\n\n.cm-trailingspace {\n  background-image: url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAgAAAAFCAYAAAB4ka1VAAAAsElEQVQIHQGlAFr/AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA7+r3zKmT0/+pk9P/7+r3zAAAAAAAAAAABAAAAAAAAAAA6OPzM+/q9wAAAAAA6OPzMwAAAAAAAAAAAgAAAAAAAAAAGR8NiRQaCgAZIA0AGR8NiQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAQyoYJ/SY80UAAAAASUVORK5CYII=);\n  background-position: center left;\n  background-repeat: repeat-x;\n}\n\n.jp-CollaboratorCursor-hover {\n  position: absolute;\n  z-index: 1;\n  transform: translateX(-50%);\n  color: white;\n  border-radius: 3px;\n  padding-left: 4px;\n  padding-right: 4px;\n  padding-top: 1px;\n  padding-bottom: 1px;\n  text-align: center;\n  font-size: var(--jp-ui-font-size1);\n  white-space: nowrap;\n}\n\n.jp-CodeMirror-ruler {\n  border-left: 1px dashed var(--jp-border-color2);\n}\n\n/* Styles for shared cursors (remote cursor locations and selected ranges) */\n.jp-CodeMirrorEditor .cm-ySelectionCaret {\n  position: relative;\n  border-left: 1px solid black;\n  margin-left: -1px;\n  margin-right: -1px;\n  box-sizing: border-box;\n}\n\n.jp-CodeMirrorEditor .cm-ySelectionCaret > .cm-ySelectionInfo {\n  white-space: nowrap;\n  position: absolute;\n  top: -1.15em;\n  padding-bottom: 0.05em;\n  left: -1px;\n  font-size: 0.95em;\n  font-family: var(--jp-ui-font-family);\n  font-weight: bold;\n  line-height: normal;\n  user-select: none;\n  color: white;\n  padding-left: 2px;\n  padding-right: 2px;\n  z-index: 101;\n  transition: opacity 0.3s ease-in-out;\n}\n\n.jp-CodeMirrorEditor .cm-ySelectionInfo {\n  transition-delay: 0.7s;\n  opacity: 0;\n}\n\n.jp-CodeMirrorEditor .cm-ySelectionCaret:hover > .cm-ySelectionInfo {\n  opacity: 1;\n  transition-delay: 0s;\n}\n"],"sourceRoot":""}]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ 60533:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Z: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(82971);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(11368);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
// Imports


var ___CSS_LOADER_EXPORT___ = _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default()));
// Module
___CSS_LOADER_EXPORT___.push([module.id, `/*-----------------------------------------------------------------------------
| Copyright (c) Jupyter Development Team.
| Distributed under the terms of the Modified BSD License.
|----------------------------------------------------------------------------*/

:root {
  --jp-private-completer-item-height: 24px;

  /* Shift the baseline of the type character to align with the match text */
  --jp-private-completer-type-offset: 2px;
}

.jp-Completer {
  box-shadow: var(--jp-elevation-z6);
  background: var(--jp-layout-color1);
  color: var(--jp-content-font-color1);
  border: var(--jp-border-width) solid var(--jp-border-color1);
  padding: 0;
  display: flex;
  flex-direction: row;

  /* Needed to avoid scrollbar issues when using cached width. */
  box-sizing: content-box;

  /* Position the completer relative to the text editor, align the '.' */
  margin: 4px 0 0 -30px;
  z-index: 10001;
}

.jp-Completer-docpanel {
  border-left: var(--jp-border-width) solid var(--jp-border-color1);
  width: 400px;
  flex-shrink: 0;
  overflow-y: scroll;
  overflow-x: auto;
  padding: 8px;
  max-height: calc((10 * var(--jp-private-completer-item-height)) - 16px);
}

.jp-Completer-docpanel pre {
  border: none;
  margin: 0;
  padding: 0;
  white-space: pre-wrap;
}

.jp-Completer-list {
  margin: 0;
  padding: 0;
  list-style-type: none;
  overflow-y: scroll;
  overflow-x: hidden;
  max-height: calc((10 * var(--jp-private-completer-item-height)));
  min-height: calc(var(--jp-private-completer-item-height));
  width: 100%;
}

.jp-Completer-item {
  box-sizing: border-box;
  margin: 0;
  padding: 0;
  height: var(--jp-private-completer-item-height);
  min-width: 150px;
  display: grid;
  grid-template-columns: min-content 1fr min-content;
  position: relative;
}

.jp-Completer-item .jp-Completer-match {
  box-sizing: border-box;
  margin: 0;
  padding: 0 8px 0 6px;
  height: var(--jp-private-completer-item-height);
  font-family: var(--jp-code-font-family);
  font-size: var(--jp-code-font-size);
  line-height: var(--jp-private-completer-item-height);
  white-space: nowrap;
}

.jp-Completer-deprecated .jp-Completer-match {
  text-decoration: line-through;
  color: var(--jp-content-font-color2);
}

.jp-Completer-item .jp-Completer-type {
  box-sizing: border-box;
  height: var(--jp-private-completer-item-height);
  background: transparent;
  width: var(--jp-private-completer-item-height);
}

.jp-Completer-item .jp-Completer-icon {
  /* Normal element size from LabIconStyle.ISheetOptions */
  height: 16px;
  width: 16px;
}

.jp-Completer-item .jp-Completer-monogram {
  text-align: center;
  color: white;
  width: var(--jp-private-completer-item-height);
  font-family: var(--jp-ui-font-family);
  font-size: var(--jp-ui-font-size1);
  line-height: calc(
    var(--jp-private-completer-item-height) -
      var(--jp-private-completer-type-offset)
  );
  padding-bottom: var(--jp-private-completer-type-offset);
}

.jp-Completer-item .jp-Completer-typeExtended {
  box-sizing: border-box;
  height: var(--jp-private-completer-item-height);
  text-align: right;
  background: transparent;
  color: var(--jp-ui-font-color2);
  font-family: var(--jp-code-font-family);
  font-size: var(--jp-code-font-size);
  line-height: var(--jp-private-completer-item-height);
  padding-right: 8px;
}

.jp-Completer-item:hover {
  background: var(--jp-layout-color2);
  opacity: 0.8;
}

.jp-Completer-item.jp-mod-active {
  background: var(--jp-brand-color1);
  color: white;
}

.jp-Completer-item .jp-Completer-match mark {
  font-weight: bold;
  background: inherit;
  color: inherit;
}

.jp-Completer-type[data-color-index='0'] {
  background: var(--jp-completer-type-background0, transparent);
}

.jp-Completer-type[data-color-index='1'] {
  background: var(--jp-completer-type-background1, #1f77b4);
}

.jp-Completer-type[data-color-index='2'] {
  background: var(--jp-completer-type-background2, #ff7f0e);
}

.jp-Completer-type[data-color-index='3'] {
  background: var(--jp-completer-type-background3, #2ca02c);
}

.jp-Completer-type[data-color-index='4'] {
  background: var(--jp-completer-type-background4, #d62728);
}

.jp-Completer-type[data-color-index='5'] {
  background: var(--jp-completer-type-background5, #9467bd);
}

.jp-Completer-type[data-color-index='6'] {
  background: var(--jp-completer-type-background6, #8c564b);
}

.jp-Completer-type[data-color-index='7'] {
  background: var(--jp-completer-type-background7, #e377c2);
}

.jp-Completer-type[data-color-index='8'] {
  background: var(--jp-completer-type-background8, #7f7f7f);
}

.jp-Completer-type[data-color-index='9'] {
  background: var(--jp-completer-type-background9, #bcbd22);
}

.jp-Completer-type[data-color-index='10'] {
  background: var(--jp-completer-type-background10, #17becf);
}

.jp-Completer-loading-bar-container {
  height: 2px;
  width: calc(100% - var(--jp-private-completer-item-height));
  left: var(--jp-private-completer-item-height);
  position: absolute;
  overflow: hidden;
  top: 0;
}

.jp-Completer-loading-bar {
  height: 100%;
  width: 50%;
  background-color: var(--jp-accent-color2);
  position: absolute;
  left: -50%;
  animation: jp-Completer-loading 2s ease-in 0.5s infinite;
}

@keyframes jp-Completer-loading {
  0% {
    transform: translateX(0);
  }

  100% {
    transform: translateX(400%);
  }
}

.jp-GhostText {
  color: var(--jp-ui-font-color3);
  white-space: pre-wrap;
}

.jp-GhostText-lineSpacer,
.jp-GhostText-letterSpacer {
  opacity: 0;
  display: inline-block;
  vertical-align: top;
  /* stylelint-disable-next-line csstree/validator */
  text-wrap: none;
}

.jp-GhostText-letterSpacer {
  max-width: 0;
}

.jp-GhostText-lineSpacer {
  /* duration and delay are overwritten by inline styles */
  animation: jp-GhostText-hide 300ms 700ms ease-out forwards;
}

@keyframes jp-GhostText-hide {
  0% {
    font-size: unset;
  }

  100% {
    font-size: 0;
  }
}

.jp-GhostText-expandHidden {
  border: 1px solid var(--jp-border-color0);
  border-radius: var(--jp-border-radius);
  background: var(--jp-layout-color0);
  color: var(--jp-content-font-color3);
  padding: 0 4px;
  margin: 0 4px;
  cursor: default;
}

.jp-GhostText-hiddenWrapper:hover > .jp-GhostText-hiddenLines {
  display: inline;
}

.jp-GhostText-hiddenLines {
  display: none;
}

.jp-GhostText[data-animation='uncover'] {
  position: relative;
}

.jp-GhostText-streamedToken {
  white-space: pre;
}

.jp-GhostText[data-animation='uncover'] > .jp-GhostText-streamedToken {
  animation: jp-GhostText-typing 2s forwards;
  display: inline-flex;
  overflow: hidden;
}

@keyframes jp-GhostText-typing {
  from {
    max-width: 0;
  }

  to {
    max-width: 100%;
  }
}

.jp-GhostText-streamingIndicator::after {
  animation: jp-GhostText-streaming 2s infinite;
  animation-delay: 400ms;
  content: ' ';
  background: var(--jp-layout-color4);
  opacity: 0.2;
}

@keyframes jp-GhostText-streaming {
  0% {
    opacity: 0.2;
  }

  20% {
    opacity: 0.4;
  }

  40% {
    opacity: 0.2;
  }
}

.jp-GhostText-errorIndicator::after {
  animation: jp-GhostText-error 500ms 1;
  animation-delay: 3500ms;
  color: var(--jp-error-color1);
  font-size: 150%;
  line-height: 10px;
  margin-left: 2px;
  padding: 0 4px;
  content: '⚠';
  cursor: help;
  position: relative;
  top: 2px;
}

@keyframes jp-GhostText-error {
  0% {
    opacity: 1;
  }

  100% {
    opacity: 0;
  }
}

.jp-InlineCompleter {
  box-shadow: var(--jp-elevation-z2);
  background: var(--jp-layout-color1);
  color: var(--jp-content-font-color1);
  border: var(--jp-border-width) solid var(--jp-border-color1);
  display: flex;
  flex-direction: row;
  align-items: center;
  padding: 0 8px;
}

.jp-InlineCompleter-progressBar {
  height: 2px;
  position: absolute;
  top: 0;
  left: 0;
  background-color: var(--jp-accent-color2);
}

.jp-InlineCompleter[data-display='onHover'] {
  opacity: 0;
  transition:
    visibility 0s linear 0.1s,
    opacity 0.1s linear;
  visibility: hidden;
}

.jp-InlineCompleter[data-display='onHover']:hover,
.jp-InlineCompleter-hover[data-display='onHover'] {
  opacity: 1;
  visibility: visible;
  transition-delay: 0s;
}

.jp-InlineCompleter[data-display='never'] {
  display: none;
}

.jp-InlineCompleter > .jp-Toolbar {
  box-shadow: none;
  border-bottom: none;
  background: none;
}

.jp-InlineCompleter[data-show-shortcuts='false']
  .jp-ToolbarButtonComponent-label {
  display: none;
}

.jp-InlineCompleter [data-command='inline-completer:next'] > svg,
.jp-InlineCompleter [data-command='inline-completer:previous'] > svg {
  scale: 1.5;
}
`, "",{"version":3,"sources":["webpack://./../node_modules/@jupyterlab/completer/style/base.css"],"names":[],"mappings":"AAAA;;;8EAG8E;;AAE9E;EACE,wCAAwC;;EAExC,0EAA0E;EAC1E,uCAAuC;AACzC;;AAEA;EACE,kCAAkC;EAClC,mCAAmC;EACnC,oCAAoC;EACpC,4DAA4D;EAC5D,UAAU;EACV,aAAa;EACb,mBAAmB;;EAEnB,8DAA8D;EAC9D,uBAAuB;;EAEvB,sEAAsE;EACtE,qBAAqB;EACrB,cAAc;AAChB;;AAEA;EACE,iEAAiE;EACjE,YAAY;EACZ,cAAc;EACd,kBAAkB;EAClB,gBAAgB;EAChB,YAAY;EACZ,uEAAuE;AACzE;;AAEA;EACE,YAAY;EACZ,SAAS;EACT,UAAU;EACV,qBAAqB;AACvB;;AAEA;EACE,SAAS;EACT,UAAU;EACV,qBAAqB;EACrB,kBAAkB;EAClB,kBAAkB;EAClB,gEAAgE;EAChE,yDAAyD;EACzD,WAAW;AACb;;AAEA;EACE,sBAAsB;EACtB,SAAS;EACT,UAAU;EACV,+CAA+C;EAC/C,gBAAgB;EAChB,aAAa;EACb,kDAAkD;EAClD,kBAAkB;AACpB;;AAEA;EACE,sBAAsB;EACtB,SAAS;EACT,oBAAoB;EACpB,+CAA+C;EAC/C,uCAAuC;EACvC,mCAAmC;EACnC,oDAAoD;EACpD,mBAAmB;AACrB;;AAEA;EACE,6BAA6B;EAC7B,oCAAoC;AACtC;;AAEA;EACE,sBAAsB;EACtB,+CAA+C;EAC/C,uBAAuB;EACvB,8CAA8C;AAChD;;AAEA;EACE,wDAAwD;EACxD,YAAY;EACZ,WAAW;AACb;;AAEA;EACE,kBAAkB;EAClB,YAAY;EACZ,8CAA8C;EAC9C,qCAAqC;EACrC,kCAAkC;EAClC;;;GAGC;EACD,uDAAuD;AACzD;;AAEA;EACE,sBAAsB;EACtB,+CAA+C;EAC/C,iBAAiB;EACjB,uBAAuB;EACvB,+BAA+B;EAC/B,uCAAuC;EACvC,mCAAmC;EACnC,oDAAoD;EACpD,kBAAkB;AACpB;;AAEA;EACE,mCAAmC;EACnC,YAAY;AACd;;AAEA;EACE,kCAAkC;EAClC,YAAY;AACd;;AAEA;EACE,iBAAiB;EACjB,mBAAmB;EACnB,cAAc;AAChB;;AAEA;EACE,6DAA6D;AAC/D;;AAEA;EACE,yDAAyD;AAC3D;;AAEA;EACE,yDAAyD;AAC3D;;AAEA;EACE,yDAAyD;AAC3D;;AAEA;EACE,yDAAyD;AAC3D;;AAEA;EACE,yDAAyD;AAC3D;;AAEA;EACE,yDAAyD;AAC3D;;AAEA;EACE,yDAAyD;AAC3D;;AAEA;EACE,yDAAyD;AAC3D;;AAEA;EACE,yDAAyD;AAC3D;;AAEA;EACE,0DAA0D;AAC5D;;AAEA;EACE,WAAW;EACX,2DAA2D;EAC3D,6CAA6C;EAC7C,kBAAkB;EAClB,gBAAgB;EAChB,MAAM;AACR;;AAEA;EACE,YAAY;EACZ,UAAU;EACV,yCAAyC;EACzC,kBAAkB;EAClB,UAAU;EACV,wDAAwD;AAC1D;;AAEA;EACE;IACE,wBAAwB;EAC1B;;EAEA;IACE,2BAA2B;EAC7B;AACF;;AAEA;EACE,+BAA+B;EAC/B,qBAAqB;AACvB;;AAEA;;EAEE,UAAU;EACV,qBAAqB;EACrB,mBAAmB;EACnB,kDAAkD;EAClD,eAAe;AACjB;;AAEA;EACE,YAAY;AACd;;AAEA;EACE,wDAAwD;EACxD,0DAA0D;AAC5D;;AAEA;EACE;IACE,gBAAgB;EAClB;;EAEA;IACE,YAAY;EACd;AACF;;AAEA;EACE,yCAAyC;EACzC,sCAAsC;EACtC,mCAAmC;EACnC,oCAAoC;EACpC,cAAc;EACd,aAAa;EACb,eAAe;AACjB;;AAEA;EACE,eAAe;AACjB;;AAEA;EACE,aAAa;AACf;;AAEA;EACE,kBAAkB;AACpB;;AAEA;EACE,gBAAgB;AAClB;;AAEA;EACE,0CAA0C;EAC1C,oBAAoB;EACpB,gBAAgB;AAClB;;AAEA;EACE;IACE,YAAY;EACd;;EAEA;IACE,eAAe;EACjB;AACF;;AAEA;EACE,6CAA6C;EAC7C,sBAAsB;EACtB,YAAY;EACZ,mCAAmC;EACnC,YAAY;AACd;;AAEA;EACE;IACE,YAAY;EACd;;EAEA;IACE,YAAY;EACd;;EAEA;IACE,YAAY;EACd;AACF;;AAEA;EACE,qCAAqC;EACrC,uBAAuB;EACvB,6BAA6B;EAC7B,eAAe;EACf,iBAAiB;EACjB,gBAAgB;EAChB,cAAc;EACd,YAAY;EACZ,YAAY;EACZ,kBAAkB;EAClB,QAAQ;AACV;;AAEA;EACE;IACE,UAAU;EACZ;;EAEA;IACE,UAAU;EACZ;AACF;;AAEA;EACE,kCAAkC;EAClC,mCAAmC;EACnC,oCAAoC;EACpC,4DAA4D;EAC5D,aAAa;EACb,mBAAmB;EACnB,mBAAmB;EACnB,cAAc;AAChB;;AAEA;EACE,WAAW;EACX,kBAAkB;EAClB,MAAM;EACN,OAAO;EACP,yCAAyC;AAC3C;;AAEA;EACE,UAAU;EACV;;uBAEqB;EACrB,kBAAkB;AACpB;;AAEA;;EAEE,UAAU;EACV,mBAAmB;EACnB,oBAAoB;AACtB;;AAEA;EACE,aAAa;AACf;;AAEA;EACE,gBAAgB;EAChB,mBAAmB;EACnB,gBAAgB;AAClB;;AAEA;;EAEE,aAAa;AACf;;AAEA;;EAEE,UAAU;AACZ","sourcesContent":["/*-----------------------------------------------------------------------------\n| Copyright (c) Jupyter Development Team.\n| Distributed under the terms of the Modified BSD License.\n|----------------------------------------------------------------------------*/\n\n:root {\n  --jp-private-completer-item-height: 24px;\n\n  /* Shift the baseline of the type character to align with the match text */\n  --jp-private-completer-type-offset: 2px;\n}\n\n.jp-Completer {\n  box-shadow: var(--jp-elevation-z6);\n  background: var(--jp-layout-color1);\n  color: var(--jp-content-font-color1);\n  border: var(--jp-border-width) solid var(--jp-border-color1);\n  padding: 0;\n  display: flex;\n  flex-direction: row;\n\n  /* Needed to avoid scrollbar issues when using cached width. */\n  box-sizing: content-box;\n\n  /* Position the completer relative to the text editor, align the '.' */\n  margin: 4px 0 0 -30px;\n  z-index: 10001;\n}\n\n.jp-Completer-docpanel {\n  border-left: var(--jp-border-width) solid var(--jp-border-color1);\n  width: 400px;\n  flex-shrink: 0;\n  overflow-y: scroll;\n  overflow-x: auto;\n  padding: 8px;\n  max-height: calc((10 * var(--jp-private-completer-item-height)) - 16px);\n}\n\n.jp-Completer-docpanel pre {\n  border: none;\n  margin: 0;\n  padding: 0;\n  white-space: pre-wrap;\n}\n\n.jp-Completer-list {\n  margin: 0;\n  padding: 0;\n  list-style-type: none;\n  overflow-y: scroll;\n  overflow-x: hidden;\n  max-height: calc((10 * var(--jp-private-completer-item-height)));\n  min-height: calc(var(--jp-private-completer-item-height));\n  width: 100%;\n}\n\n.jp-Completer-item {\n  box-sizing: border-box;\n  margin: 0;\n  padding: 0;\n  height: var(--jp-private-completer-item-height);\n  min-width: 150px;\n  display: grid;\n  grid-template-columns: min-content 1fr min-content;\n  position: relative;\n}\n\n.jp-Completer-item .jp-Completer-match {\n  box-sizing: border-box;\n  margin: 0;\n  padding: 0 8px 0 6px;\n  height: var(--jp-private-completer-item-height);\n  font-family: var(--jp-code-font-family);\n  font-size: var(--jp-code-font-size);\n  line-height: var(--jp-private-completer-item-height);\n  white-space: nowrap;\n}\n\n.jp-Completer-deprecated .jp-Completer-match {\n  text-decoration: line-through;\n  color: var(--jp-content-font-color2);\n}\n\n.jp-Completer-item .jp-Completer-type {\n  box-sizing: border-box;\n  height: var(--jp-private-completer-item-height);\n  background: transparent;\n  width: var(--jp-private-completer-item-height);\n}\n\n.jp-Completer-item .jp-Completer-icon {\n  /* Normal element size from LabIconStyle.ISheetOptions */\n  height: 16px;\n  width: 16px;\n}\n\n.jp-Completer-item .jp-Completer-monogram {\n  text-align: center;\n  color: white;\n  width: var(--jp-private-completer-item-height);\n  font-family: var(--jp-ui-font-family);\n  font-size: var(--jp-ui-font-size1);\n  line-height: calc(\n    var(--jp-private-completer-item-height) -\n      var(--jp-private-completer-type-offset)\n  );\n  padding-bottom: var(--jp-private-completer-type-offset);\n}\n\n.jp-Completer-item .jp-Completer-typeExtended {\n  box-sizing: border-box;\n  height: var(--jp-private-completer-item-height);\n  text-align: right;\n  background: transparent;\n  color: var(--jp-ui-font-color2);\n  font-family: var(--jp-code-font-family);\n  font-size: var(--jp-code-font-size);\n  line-height: var(--jp-private-completer-item-height);\n  padding-right: 8px;\n}\n\n.jp-Completer-item:hover {\n  background: var(--jp-layout-color2);\n  opacity: 0.8;\n}\n\n.jp-Completer-item.jp-mod-active {\n  background: var(--jp-brand-color1);\n  color: white;\n}\n\n.jp-Completer-item .jp-Completer-match mark {\n  font-weight: bold;\n  background: inherit;\n  color: inherit;\n}\n\n.jp-Completer-type[data-color-index='0'] {\n  background: var(--jp-completer-type-background0, transparent);\n}\n\n.jp-Completer-type[data-color-index='1'] {\n  background: var(--jp-completer-type-background1, #1f77b4);\n}\n\n.jp-Completer-type[data-color-index='2'] {\n  background: var(--jp-completer-type-background2, #ff7f0e);\n}\n\n.jp-Completer-type[data-color-index='3'] {\n  background: var(--jp-completer-type-background3, #2ca02c);\n}\n\n.jp-Completer-type[data-color-index='4'] {\n  background: var(--jp-completer-type-background4, #d62728);\n}\n\n.jp-Completer-type[data-color-index='5'] {\n  background: var(--jp-completer-type-background5, #9467bd);\n}\n\n.jp-Completer-type[data-color-index='6'] {\n  background: var(--jp-completer-type-background6, #8c564b);\n}\n\n.jp-Completer-type[data-color-index='7'] {\n  background: var(--jp-completer-type-background7, #e377c2);\n}\n\n.jp-Completer-type[data-color-index='8'] {\n  background: var(--jp-completer-type-background8, #7f7f7f);\n}\n\n.jp-Completer-type[data-color-index='9'] {\n  background: var(--jp-completer-type-background9, #bcbd22);\n}\n\n.jp-Completer-type[data-color-index='10'] {\n  background: var(--jp-completer-type-background10, #17becf);\n}\n\n.jp-Completer-loading-bar-container {\n  height: 2px;\n  width: calc(100% - var(--jp-private-completer-item-height));\n  left: var(--jp-private-completer-item-height);\n  position: absolute;\n  overflow: hidden;\n  top: 0;\n}\n\n.jp-Completer-loading-bar {\n  height: 100%;\n  width: 50%;\n  background-color: var(--jp-accent-color2);\n  position: absolute;\n  left: -50%;\n  animation: jp-Completer-loading 2s ease-in 0.5s infinite;\n}\n\n@keyframes jp-Completer-loading {\n  0% {\n    transform: translateX(0);\n  }\n\n  100% {\n    transform: translateX(400%);\n  }\n}\n\n.jp-GhostText {\n  color: var(--jp-ui-font-color3);\n  white-space: pre-wrap;\n}\n\n.jp-GhostText-lineSpacer,\n.jp-GhostText-letterSpacer {\n  opacity: 0;\n  display: inline-block;\n  vertical-align: top;\n  /* stylelint-disable-next-line csstree/validator */\n  text-wrap: none;\n}\n\n.jp-GhostText-letterSpacer {\n  max-width: 0;\n}\n\n.jp-GhostText-lineSpacer {\n  /* duration and delay are overwritten by inline styles */\n  animation: jp-GhostText-hide 300ms 700ms ease-out forwards;\n}\n\n@keyframes jp-GhostText-hide {\n  0% {\n    font-size: unset;\n  }\n\n  100% {\n    font-size: 0;\n  }\n}\n\n.jp-GhostText-expandHidden {\n  border: 1px solid var(--jp-border-color0);\n  border-radius: var(--jp-border-radius);\n  background: var(--jp-layout-color0);\n  color: var(--jp-content-font-color3);\n  padding: 0 4px;\n  margin: 0 4px;\n  cursor: default;\n}\n\n.jp-GhostText-hiddenWrapper:hover > .jp-GhostText-hiddenLines {\n  display: inline;\n}\n\n.jp-GhostText-hiddenLines {\n  display: none;\n}\n\n.jp-GhostText[data-animation='uncover'] {\n  position: relative;\n}\n\n.jp-GhostText-streamedToken {\n  white-space: pre;\n}\n\n.jp-GhostText[data-animation='uncover'] > .jp-GhostText-streamedToken {\n  animation: jp-GhostText-typing 2s forwards;\n  display: inline-flex;\n  overflow: hidden;\n}\n\n@keyframes jp-GhostText-typing {\n  from {\n    max-width: 0;\n  }\n\n  to {\n    max-width: 100%;\n  }\n}\n\n.jp-GhostText-streamingIndicator::after {\n  animation: jp-GhostText-streaming 2s infinite;\n  animation-delay: 400ms;\n  content: ' ';\n  background: var(--jp-layout-color4);\n  opacity: 0.2;\n}\n\n@keyframes jp-GhostText-streaming {\n  0% {\n    opacity: 0.2;\n  }\n\n  20% {\n    opacity: 0.4;\n  }\n\n  40% {\n    opacity: 0.2;\n  }\n}\n\n.jp-GhostText-errorIndicator::after {\n  animation: jp-GhostText-error 500ms 1;\n  animation-delay: 3500ms;\n  color: var(--jp-error-color1);\n  font-size: 150%;\n  line-height: 10px;\n  margin-left: 2px;\n  padding: 0 4px;\n  content: '⚠';\n  cursor: help;\n  position: relative;\n  top: 2px;\n}\n\n@keyframes jp-GhostText-error {\n  0% {\n    opacity: 1;\n  }\n\n  100% {\n    opacity: 0;\n  }\n}\n\n.jp-InlineCompleter {\n  box-shadow: var(--jp-elevation-z2);\n  background: var(--jp-layout-color1);\n  color: var(--jp-content-font-color1);\n  border: var(--jp-border-width) solid var(--jp-border-color1);\n  display: flex;\n  flex-direction: row;\n  align-items: center;\n  padding: 0 8px;\n}\n\n.jp-InlineCompleter-progressBar {\n  height: 2px;\n  position: absolute;\n  top: 0;\n  left: 0;\n  background-color: var(--jp-accent-color2);\n}\n\n.jp-InlineCompleter[data-display='onHover'] {\n  opacity: 0;\n  transition:\n    visibility 0s linear 0.1s,\n    opacity 0.1s linear;\n  visibility: hidden;\n}\n\n.jp-InlineCompleter[data-display='onHover']:hover,\n.jp-InlineCompleter-hover[data-display='onHover'] {\n  opacity: 1;\n  visibility: visible;\n  transition-delay: 0s;\n}\n\n.jp-InlineCompleter[data-display='never'] {\n  display: none;\n}\n\n.jp-InlineCompleter > .jp-Toolbar {\n  box-shadow: none;\n  border-bottom: none;\n  background: none;\n}\n\n.jp-InlineCompleter[data-show-shortcuts='false']\n  .jp-ToolbarButtonComponent-label {\n  display: none;\n}\n\n.jp-InlineCompleter [data-command='inline-completer:next'] > svg,\n.jp-InlineCompleter [data-command='inline-completer:previous'] > svg {\n  scale: 1.5;\n}\n"],"sourceRoot":""}]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ 61923:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Z: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(82971);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(11368);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
// Imports


var ___CSS_LOADER_EXPORT___ = _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default()));
// Module
___CSS_LOADER_EXPORT___.push([module.id, `/*-----------------------------------------------------------------------------
| Copyright (c) Jupyter Development Team.
| Distributed under the terms of the Modified BSD License.
|----------------------------------------------------------------------------*/

/* Toolbar menu to select the prompt cell position */
.jp-CodeConsolePromptMenu {
  display: flex;
  flex-direction: column;
  align-items: center;
  justify-content: center;
}

.jp-CodeConsolePromptMenu .lm-Menu-itemIcon > svg {
  vertical-align: sub;
}
`, "",{"version":3,"sources":["webpack://./../node_modules/@jupyterlab/console-extension/style/base.css"],"names":[],"mappings":"AAAA;;;8EAG8E;;AAE9E,oDAAoD;AACpD;EACE,aAAa;EACb,sBAAsB;EACtB,mBAAmB;EACnB,uBAAuB;AACzB;;AAEA;EACE,mBAAmB;AACrB","sourcesContent":["/*-----------------------------------------------------------------------------\n| Copyright (c) Jupyter Development Team.\n| Distributed under the terms of the Modified BSD License.\n|----------------------------------------------------------------------------*/\n\n/* Toolbar menu to select the prompt cell position */\n.jp-CodeConsolePromptMenu {\n  display: flex;\n  flex-direction: column;\n  align-items: center;\n  justify-content: center;\n}\n\n.jp-CodeConsolePromptMenu .lm-Menu-itemIcon > svg {\n  vertical-align: sub;\n}\n"],"sourceRoot":""}]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ 43313:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Z: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(82971);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(11368);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
// Imports


var ___CSS_LOADER_EXPORT___ = _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default()));
// Module
___CSS_LOADER_EXPORT___.push([module.id, `/*-----------------------------------------------------------------------------
| Copyright (c) Jupyter Development Team.
| Distributed under the terms of the Modified BSD License.
|----------------------------------------------------------------------------*/

.jp-ConsolePanel {
  display: flex;
  margin-top: -1px;
  min-width: 240px;
  min-height: 120px;
}

.jp-CodeConsole {
  height: 100%;
  padding: 0;
  display: flex;
}

.jp-CodeConsole .jp-Cell {
  padding: var(--jp-cell-padding);
}

/*-----------------------------------------------------------------------------
| Content (already run cells)
|----------------------------------------------------------------------------*/

.jp-CodeConsole-content {
  background: var(--jp-layout-color0);
  overflow: auto;
  padding: 0 var(--jp-console-padding);
  min-width: calc(10 * var(--jp-ui-font-size1));
  min-height: calc(5 * var(--jp-ui-font-size1));
}

.jp-CodeConsole-content .jp-Cell:not(.jp-mod-active) .jp-InputPrompt {
  opacity: var(--jp-cell-prompt-not-active-opacity);
  color: var(--jp-cell-inprompt-font-color);
  cursor: move;
}

.jp-CodeConsole-content .jp-Cell:not(.jp-mod-active) .jp-OutputPrompt {
  opacity: var(--jp-cell-prompt-not-active-opacity);
  color: var(--jp-cell-outprompt-font-color);
}

/* This rule is for styling cell run by another activity in this console */

/* .jp-CodeConsole-content .jp-Cell.jp-CodeConsole-foreignCell {
} */

.jp-CodeConsole-content .jp-InputArea-editor.jp-InputArea-editor {
  background: transparent;
  border: 1px solid transparent;
}

.jp-CodeConsole-content .jp-CodeConsole-banner .jp-InputPrompt {
  display: none;
}

/* collapser is hovered */
.jp-CodeConsole-content .jp-Cell .jp-Collapser:hover {
  box-shadow: var(--jp-elevation-z2);
  background: var(--jp-brand-color1);
  opacity: var(--jp-cell-collapser-not-active-hover-opacity);
}

/*-----------------------------------------------------------------------------
| Input/prompt cell
|----------------------------------------------------------------------------*/

.jp-CodeConsole-input {
  overflow: auto;
  padding: var(--jp-cell-padding) var(--jp-console-padding);

  /* This matches the box shadow on the notebook toolbar, eventually we should create
   * CSS variables for this */
  box-shadow: 0 0.4px 6px 0 rgba(0, 0, 0, 0.1);
  background: var(--jp-layout-color0);
  min-width: calc(10 * var(--jp-ui-font-size1));
  min-height: calc(4 * var(--jp-ui-font-size1));
}

.jp-CodeConsole-input .jp-CodeConsole-prompt .jp-InputArea {
  height: 100%;
  min-height: 100%;
}

.jp-CodeConsole-promptCell .jp-InputArea-editor.jp-mod-focused {
  border: var(--jp-border-width) solid var(--jp-cell-editor-active-border-color);
  box-shadow: var(--jp-input-box-shadow);
  background-color: var(--jp-cell-editor-active-background);
}

/*-----------------------------------------------------------------------------
| Presentation Mode (.jp-mod-presentationMode)
|----------------------------------------------------------------------------*/

.jp-mod-presentationMode .jp-CodeConsole {
  --jp-content-font-size1: var(--jp-content-presentation-font-size1);
  --jp-code-font-size: var(--jp-code-presentation-font-size);
}

.jp-mod-presentationMode .jp-CodeConsole .jp-Cell .jp-InputPrompt,
.jp-mod-presentationMode .jp-CodeConsole .jp-Cell .jp-OutputPrompt {
  flex: 0 0 110px;
}

/*-----------------------------------------------------------------------------
| Split Panel Container
|----------------------------------------------------------------------------*/
.jp-CodeConsole-split {
  display: flex;
  height: 100%;
  width: 100%;
  overflow: hidden;
}

.jp-CodeConsole-split.lm-SplitPanel .lm-SplitPanel-handle::after {
  background-color: var(--jp-border-color2);
  min-height: calc(2 * var(--jp-border-width));
  min-width: calc(2 * var(--jp-border-width));
}

/*-----------------------------------------------------------------------------
| Mobile
|----------------------------------------------------------------------------*/
@media only screen and (width <= 760px) {
  .jp-CodeConsole-input {
    min-height: calc(6 * var(--jp-ui-font-size1));
  }
}
`, "",{"version":3,"sources":["webpack://./../node_modules/@jupyterlab/console/style/base.css"],"names":[],"mappings":"AAAA;;;8EAG8E;;AAE9E;EACE,aAAa;EACb,gBAAgB;EAChB,gBAAgB;EAChB,iBAAiB;AACnB;;AAEA;EACE,YAAY;EACZ,UAAU;EACV,aAAa;AACf;;AAEA;EACE,+BAA+B;AACjC;;AAEA;;8EAE8E;;AAE9E;EACE,mCAAmC;EACnC,cAAc;EACd,oCAAoC;EACpC,6CAA6C;EAC7C,6CAA6C;AAC/C;;AAEA;EACE,iDAAiD;EACjD,yCAAyC;EACzC,YAAY;AACd;;AAEA;EACE,iDAAiD;EACjD,0CAA0C;AAC5C;;AAEA,0EAA0E;;AAE1E;GACG;;AAEH;EACE,uBAAuB;EACvB,6BAA6B;AAC/B;;AAEA;EACE,aAAa;AACf;;AAEA,yBAAyB;AACzB;EACE,kCAAkC;EAClC,kCAAkC;EAClC,0DAA0D;AAC5D;;AAEA;;8EAE8E;;AAE9E;EACE,cAAc;EACd,yDAAyD;;EAEzD;6BAC2B;EAC3B,4CAA4C;EAC5C,mCAAmC;EACnC,6CAA6C;EAC7C,6CAA6C;AAC/C;;AAEA;EACE,YAAY;EACZ,gBAAgB;AAClB;;AAEA;EACE,8EAA8E;EAC9E,sCAAsC;EACtC,yDAAyD;AAC3D;;AAEA;;8EAE8E;;AAE9E;EACE,kEAAkE;EAClE,0DAA0D;AAC5D;;AAEA;;EAEE,eAAe;AACjB;;AAEA;;8EAE8E;AAC9E;EACE,aAAa;EACb,YAAY;EACZ,WAAW;EACX,gBAAgB;AAClB;;AAEA;EACE,yCAAyC;EACzC,4CAA4C;EAC5C,2CAA2C;AAC7C;;AAEA;;8EAE8E;AAC9E;EACE;IACE,6CAA6C;EAC/C;AACF","sourcesContent":["/*-----------------------------------------------------------------------------\n| Copyright (c) Jupyter Development Team.\n| Distributed under the terms of the Modified BSD License.\n|----------------------------------------------------------------------------*/\n\n.jp-ConsolePanel {\n  display: flex;\n  margin-top: -1px;\n  min-width: 240px;\n  min-height: 120px;\n}\n\n.jp-CodeConsole {\n  height: 100%;\n  padding: 0;\n  display: flex;\n}\n\n.jp-CodeConsole .jp-Cell {\n  padding: var(--jp-cell-padding);\n}\n\n/*-----------------------------------------------------------------------------\n| Content (already run cells)\n|----------------------------------------------------------------------------*/\n\n.jp-CodeConsole-content {\n  background: var(--jp-layout-color0);\n  overflow: auto;\n  padding: 0 var(--jp-console-padding);\n  min-width: calc(10 * var(--jp-ui-font-size1));\n  min-height: calc(5 * var(--jp-ui-font-size1));\n}\n\n.jp-CodeConsole-content .jp-Cell:not(.jp-mod-active) .jp-InputPrompt {\n  opacity: var(--jp-cell-prompt-not-active-opacity);\n  color: var(--jp-cell-inprompt-font-color);\n  cursor: move;\n}\n\n.jp-CodeConsole-content .jp-Cell:not(.jp-mod-active) .jp-OutputPrompt {\n  opacity: var(--jp-cell-prompt-not-active-opacity);\n  color: var(--jp-cell-outprompt-font-color);\n}\n\n/* This rule is for styling cell run by another activity in this console */\n\n/* .jp-CodeConsole-content .jp-Cell.jp-CodeConsole-foreignCell {\n} */\n\n.jp-CodeConsole-content .jp-InputArea-editor.jp-InputArea-editor {\n  background: transparent;\n  border: 1px solid transparent;\n}\n\n.jp-CodeConsole-content .jp-CodeConsole-banner .jp-InputPrompt {\n  display: none;\n}\n\n/* collapser is hovered */\n.jp-CodeConsole-content .jp-Cell .jp-Collapser:hover {\n  box-shadow: var(--jp-elevation-z2);\n  background: var(--jp-brand-color1);\n  opacity: var(--jp-cell-collapser-not-active-hover-opacity);\n}\n\n/*-----------------------------------------------------------------------------\n| Input/prompt cell\n|----------------------------------------------------------------------------*/\n\n.jp-CodeConsole-input {\n  overflow: auto;\n  padding: var(--jp-cell-padding) var(--jp-console-padding);\n\n  /* This matches the box shadow on the notebook toolbar, eventually we should create\n   * CSS variables for this */\n  box-shadow: 0 0.4px 6px 0 rgba(0, 0, 0, 0.1);\n  background: var(--jp-layout-color0);\n  min-width: calc(10 * var(--jp-ui-font-size1));\n  min-height: calc(4 * var(--jp-ui-font-size1));\n}\n\n.jp-CodeConsole-input .jp-CodeConsole-prompt .jp-InputArea {\n  height: 100%;\n  min-height: 100%;\n}\n\n.jp-CodeConsole-promptCell .jp-InputArea-editor.jp-mod-focused {\n  border: var(--jp-border-width) solid var(--jp-cell-editor-active-border-color);\n  box-shadow: var(--jp-input-box-shadow);\n  background-color: var(--jp-cell-editor-active-background);\n}\n\n/*-----------------------------------------------------------------------------\n| Presentation Mode (.jp-mod-presentationMode)\n|----------------------------------------------------------------------------*/\n\n.jp-mod-presentationMode .jp-CodeConsole {\n  --jp-content-font-size1: var(--jp-content-presentation-font-size1);\n  --jp-code-font-size: var(--jp-code-presentation-font-size);\n}\n\n.jp-mod-presentationMode .jp-CodeConsole .jp-Cell .jp-InputPrompt,\n.jp-mod-presentationMode .jp-CodeConsole .jp-Cell .jp-OutputPrompt {\n  flex: 0 0 110px;\n}\n\n/*-----------------------------------------------------------------------------\n| Split Panel Container\n|----------------------------------------------------------------------------*/\n.jp-CodeConsole-split {\n  display: flex;\n  height: 100%;\n  width: 100%;\n  overflow: hidden;\n}\n\n.jp-CodeConsole-split.lm-SplitPanel .lm-SplitPanel-handle::after {\n  background-color: var(--jp-border-color2);\n  min-height: calc(2 * var(--jp-border-width));\n  min-width: calc(2 * var(--jp-border-width));\n}\n\n/*-----------------------------------------------------------------------------\n| Mobile\n|----------------------------------------------------------------------------*/\n@media only screen and (width <= 760px) {\n  .jp-CodeConsole-input {\n    min-height: calc(6 * var(--jp-ui-font-size1));\n  }\n}\n"],"sourceRoot":""}]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ 11959:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Z: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(82971);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(11368);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
// Imports


var ___CSS_LOADER_EXPORT___ = _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default()));
// Module
___CSS_LOADER_EXPORT___.push([module.id, `/*-----------------------------------------------------------------------------
| Copyright (c) Jupyter Development Team.
| Distributed under the terms of the Modified BSD License.
|----------------------------------------------------------------------------*/

.jp-CSVViewer {
  display: flex;
  flex-direction: column;
  outline: none;

  /* This is needed so that all font sizing of children done in ems is
   * relative to this base size */
  font-size: var(--jp-ui-font-size1);
}

.jp-CSVDelimiter {
  display: flex;
  flex: 0 0 auto;
  flex-direction: row;
  border: none;
  min-height: 24px;
  background: var(--jp-toolbar-background);
  z-index: 1;
}

.jp-CSVDelimiter .jp-CSVDelimiter-label {
  color: var(--jp-ui-font-color1);
  font-size: var(--jp-ui-font-size1);
  padding-left: 8px;
  padding-right: 8px;
}

.jp-CSVDelimiter .jp-CSVDelimiter-dropdown {
  flex: 0 0 auto;
  vertical-align: middle;
  border-radius: 0;
  outline: none;
  height: 20px;
  margin-top: 2px;
  margin-bottom: 2px;
}

.jp-CSVDelimiter .jp-CSVDelimiter-dropdown select.jp-mod-styled {
  color: var(--jp-ui-font-color1);
  background: var(--jp-layout-color1);
  font-size: var(--jp-ui-font-size1);
  height: 20px;
  padding-right: 20px;
}

.jp-CSVViewer-grid {
  flex: 1 1 auto;
}
`, "",{"version":3,"sources":["webpack://./../node_modules/@jupyterlab/csvviewer/style/base.css"],"names":[],"mappings":"AAAA;;;8EAG8E;;AAE9E;EACE,aAAa;EACb,sBAAsB;EACtB,aAAa;;EAEb;iCAC+B;EAC/B,kCAAkC;AACpC;;AAEA;EACE,aAAa;EACb,cAAc;EACd,mBAAmB;EACnB,YAAY;EACZ,gBAAgB;EAChB,wCAAwC;EACxC,UAAU;AACZ;;AAEA;EACE,+BAA+B;EAC/B,kCAAkC;EAClC,iBAAiB;EACjB,kBAAkB;AACpB;;AAEA;EACE,cAAc;EACd,sBAAsB;EACtB,gBAAgB;EAChB,aAAa;EACb,YAAY;EACZ,eAAe;EACf,kBAAkB;AACpB;;AAEA;EACE,+BAA+B;EAC/B,mCAAmC;EACnC,kCAAkC;EAClC,YAAY;EACZ,mBAAmB;AACrB;;AAEA;EACE,cAAc;AAChB","sourcesContent":["/*-----------------------------------------------------------------------------\n| Copyright (c) Jupyter Development Team.\n| Distributed under the terms of the Modified BSD License.\n|----------------------------------------------------------------------------*/\n\n.jp-CSVViewer {\n  display: flex;\n  flex-direction: column;\n  outline: none;\n\n  /* This is needed so that all font sizing of children done in ems is\n   * relative to this base size */\n  font-size: var(--jp-ui-font-size1);\n}\n\n.jp-CSVDelimiter {\n  display: flex;\n  flex: 0 0 auto;\n  flex-direction: row;\n  border: none;\n  min-height: 24px;\n  background: var(--jp-toolbar-background);\n  z-index: 1;\n}\n\n.jp-CSVDelimiter .jp-CSVDelimiter-label {\n  color: var(--jp-ui-font-color1);\n  font-size: var(--jp-ui-font-size1);\n  padding-left: 8px;\n  padding-right: 8px;\n}\n\n.jp-CSVDelimiter .jp-CSVDelimiter-dropdown {\n  flex: 0 0 auto;\n  vertical-align: middle;\n  border-radius: 0;\n  outline: none;\n  height: 20px;\n  margin-top: 2px;\n  margin-bottom: 2px;\n}\n\n.jp-CSVDelimiter .jp-CSVDelimiter-dropdown select.jp-mod-styled {\n  color: var(--jp-ui-font-color1);\n  background: var(--jp-layout-color1);\n  font-size: var(--jp-ui-font-size1);\n  height: 20px;\n  padding-right: 20px;\n}\n\n.jp-CSVViewer-grid {\n  flex: 1 1 auto;\n}\n"],"sourceRoot":""}]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ 34114:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Z: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(82971);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(11368);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _builder_node_modules_css_loader_dist_cjs_js_breakpoints_css__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(75551);
/* harmony import */ var _builder_node_modules_css_loader_dist_cjs_js_callstack_css__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(47507);
/* harmony import */ var _builder_node_modules_css_loader_dist_cjs_js_editor_css__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(14131);
/* harmony import */ var _builder_node_modules_css_loader_dist_cjs_js_kernelSources_css__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(77173);
/* harmony import */ var _builder_node_modules_css_loader_dist_cjs_js_sidebar_css__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(3742);
/* harmony import */ var _builder_node_modules_css_loader_dist_cjs_js_sources_css__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(87383);
/* harmony import */ var _builder_node_modules_css_loader_dist_cjs_js_variables_css__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(74328);
// Imports









var ___CSS_LOADER_EXPORT___ = _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default()));
___CSS_LOADER_EXPORT___.i(_builder_node_modules_css_loader_dist_cjs_js_breakpoints_css__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z);
___CSS_LOADER_EXPORT___.i(_builder_node_modules_css_loader_dist_cjs_js_callstack_css__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z);
___CSS_LOADER_EXPORT___.i(_builder_node_modules_css_loader_dist_cjs_js_editor_css__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z);
___CSS_LOADER_EXPORT___.i(_builder_node_modules_css_loader_dist_cjs_js_kernelSources_css__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z);
___CSS_LOADER_EXPORT___.i(_builder_node_modules_css_loader_dist_cjs_js_sidebar_css__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .Z);
___CSS_LOADER_EXPORT___.i(_builder_node_modules_css_loader_dist_cjs_js_sources_css__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .Z);
___CSS_LOADER_EXPORT___.i(_builder_node_modules_css_loader_dist_cjs_js_variables_css__WEBPACK_IMPORTED_MODULE_8__/* ["default"] */ .Z);
// Module
___CSS_LOADER_EXPORT___.push([module.id, `/*-----------------------------------------------------------------------------
| Copyright (c) Jupyter Development Team.
| Distributed under the terms of the Modified BSD License.
|----------------------------------------------------------------------------*/

.jp-left-truncated {
  overflow: hidden;
  text-overflow: ellipsis;
  direction: rtl;
}

#jp-debugger .jp-switch-label {
  margin-right: 0;
}

.jp-DebuggerBugButton[aria-pressed='true'] {
  /* Undo default toolkit style */
  box-shadow: none;
}

.jp-DebuggerBugButton[aria-pressed='true'] path {
  fill: var(--jp-warn-color0);
}
`, "",{"version":3,"sources":["webpack://./../node_modules/@jupyterlab/debugger/style/base.css"],"names":[],"mappings":"AAAA;;;8EAG8E;;AAU9E;EACE,gBAAgB;EAChB,uBAAuB;EACvB,cAAc;AAChB;;AAEA;EACE,eAAe;AACjB;;AAEA;EACE,+BAA+B;EAC/B,gBAAgB;AAClB;;AAEA;EACE,2BAA2B;AAC7B","sourcesContent":["/*-----------------------------------------------------------------------------\n| Copyright (c) Jupyter Development Team.\n| Distributed under the terms of the Modified BSD License.\n|----------------------------------------------------------------------------*/\n\n@import './breakpoints.css';\n@import './callstack.css';\n@import './editor.css';\n@import './kernelSources.css';\n@import './sidebar.css';\n@import './sources.css';\n@import './variables.css';\n\n.jp-left-truncated {\n  overflow: hidden;\n  text-overflow: ellipsis;\n  direction: rtl;\n}\n\n#jp-debugger .jp-switch-label {\n  margin-right: 0;\n}\n\n.jp-DebuggerBugButton[aria-pressed='true'] {\n  /* Undo default toolkit style */\n  box-shadow: none;\n}\n\n.jp-DebuggerBugButton[aria-pressed='true'] path {\n  fill: var(--jp-warn-color0);\n}\n"],"sourceRoot":""}]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ 75551:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Z: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(82971);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(11368);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
// Imports


var ___CSS_LOADER_EXPORT___ = _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default()));
// Module
___CSS_LOADER_EXPORT___.push([module.id, `/*-----------------------------------------------------------------------------
| Copyright (c) Jupyter Development Team.
| Distributed under the terms of the Modified BSD License.
|----------------------------------------------------------------------------*/

.jp-DebuggerBreakpoints {
  display: flex;
  flex-direction: column;
  min-height: 50px;
  padding-top: 3px;
}

.jp-DebuggerBreakpoints-body {
  padding: 10px;
  overflow: auto;
}

.jp-DebuggerBreakpoint {
  display: flex;
  align-items: center;
}

.jp-DebuggerBreakpoint:hover {
  background: var(--jp-layout-color2);
  cursor: pointer;
}

.jp-DebuggerBreakpoint-marker {
  font-size: 20px;
  padding-right: 5px;
  content: '●';
  color: var(--jp-error-color1);
}

.jp-DebuggerBreakpoint-source {
  white-space: nowrap;
  margin-right: 5px;
}

.jp-DebuggerBreakpoint-line {
  margin-left: auto;
}

.jp-DebuggerCallstackFrame {
  display: flex;
  align-items: center;
}

.jp-DebuggerCallstackFrame-name {
  white-space: nowrap;
  margin-right: 5px;
}

.jp-DebuggerCallstackFrame-location {
  margin-left: auto;
}

[data-jp-debugger='true'] .cm-breakpoint-gutter .cm-gutterElement:empty::after {
  content: '●';
  color: var(--jp-error-color1);
  opacity: 0;
}

.cm-gutter {
  cursor: default;
}

.cm-breakpoint-gutter .cm-gutterElement {
  color: var(--jp-error-color1);
  padding-left: 5px;
  font-size: 20px;
  position: relative;
  top: -5px;
}

[data-jp-debugger='true'].jp-Editor
  .cm-breakpoint-gutter
  .cm-gutterElement:empty:hover::after,
[data-jp-debugger='true']
  .jp-Notebook
  .jp-CodeCell.jp-mod-selected
  .cm-breakpoint-gutter:empty:hover::after,
[data-jp-debugger='true']
  .jp-Editor
  .cm-breakpoint-gutter
  .cm-gutterElement:empty:hover::after {
  opacity: 0.5;
}
`, "",{"version":3,"sources":["webpack://./../node_modules/@jupyterlab/debugger/style/breakpoints.css"],"names":[],"mappings":"AAAA;;;8EAG8E;;AAE9E;EACE,aAAa;EACb,sBAAsB;EACtB,gBAAgB;EAChB,gBAAgB;AAClB;;AAEA;EACE,aAAa;EACb,cAAc;AAChB;;AAEA;EACE,aAAa;EACb,mBAAmB;AACrB;;AAEA;EACE,mCAAmC;EACnC,eAAe;AACjB;;AAEA;EACE,eAAe;EACf,kBAAkB;EAClB,YAAY;EACZ,6BAA6B;AAC/B;;AAEA;EACE,mBAAmB;EACnB,iBAAiB;AACnB;;AAEA;EACE,iBAAiB;AACnB;;AAEA;EACE,aAAa;EACb,mBAAmB;AACrB;;AAEA;EACE,mBAAmB;EACnB,iBAAiB;AACnB;;AAEA;EACE,iBAAiB;AACnB;;AAEA;EACE,YAAY;EACZ,6BAA6B;EAC7B,UAAU;AACZ;;AAEA;EACE,eAAe;AACjB;;AAEA;EACE,6BAA6B;EAC7B,iBAAiB;EACjB,eAAe;EACf,kBAAkB;EAClB,SAAS;AACX;;AAEA;;;;;;;;;;;EAWE,YAAY;AACd","sourcesContent":["/*-----------------------------------------------------------------------------\n| Copyright (c) Jupyter Development Team.\n| Distributed under the terms of the Modified BSD License.\n|----------------------------------------------------------------------------*/\n\n.jp-DebuggerBreakpoints {\n  display: flex;\n  flex-direction: column;\n  min-height: 50px;\n  padding-top: 3px;\n}\n\n.jp-DebuggerBreakpoints-body {\n  padding: 10px;\n  overflow: auto;\n}\n\n.jp-DebuggerBreakpoint {\n  display: flex;\n  align-items: center;\n}\n\n.jp-DebuggerBreakpoint:hover {\n  background: var(--jp-layout-color2);\n  cursor: pointer;\n}\n\n.jp-DebuggerBreakpoint-marker {\n  font-size: 20px;\n  padding-right: 5px;\n  content: '●';\n  color: var(--jp-error-color1);\n}\n\n.jp-DebuggerBreakpoint-source {\n  white-space: nowrap;\n  margin-right: 5px;\n}\n\n.jp-DebuggerBreakpoint-line {\n  margin-left: auto;\n}\n\n.jp-DebuggerCallstackFrame {\n  display: flex;\n  align-items: center;\n}\n\n.jp-DebuggerCallstackFrame-name {\n  white-space: nowrap;\n  margin-right: 5px;\n}\n\n.jp-DebuggerCallstackFrame-location {\n  margin-left: auto;\n}\n\n[data-jp-debugger='true'] .cm-breakpoint-gutter .cm-gutterElement:empty::after {\n  content: '●';\n  color: var(--jp-error-color1);\n  opacity: 0;\n}\n\n.cm-gutter {\n  cursor: default;\n}\n\n.cm-breakpoint-gutter .cm-gutterElement {\n  color: var(--jp-error-color1);\n  padding-left: 5px;\n  font-size: 20px;\n  position: relative;\n  top: -5px;\n}\n\n[data-jp-debugger='true'].jp-Editor\n  .cm-breakpoint-gutter\n  .cm-gutterElement:empty:hover::after,\n[data-jp-debugger='true']\n  .jp-Notebook\n  .jp-CodeCell.jp-mod-selected\n  .cm-breakpoint-gutter:empty:hover::after,\n[data-jp-debugger='true']\n  .jp-Editor\n  .cm-breakpoint-gutter\n  .cm-gutterElement:empty:hover::after {\n  opacity: 0.5;\n}\n"],"sourceRoot":""}]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ 47507:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Z: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(82971);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(11368);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
// Imports


var ___CSS_LOADER_EXPORT___ = _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default()));
// Module
___CSS_LOADER_EXPORT___.push([module.id, `/*-----------------------------------------------------------------------------
| Copyright (c) Jupyter Development Team.
| Distributed under the terms of the Modified BSD License.
|----------------------------------------------------------------------------*/

.jp-DebuggerCallstack {
  display: flex;
  flex-direction: column;
  min-height: 50px;
  padding-top: 3px;
}

.jp-DebuggerCallstack-body {
  overflow: auto;
}

.jp-DebuggerCallstack-body ul {
  list-style: none;
  margin: 0;
  padding: 0;
  background: var(--jp-layout-color1);
  color: var(--jp-ui-font-color1);
  font-size: var(--jp-ui-font-size1);
}

.jp-DebuggerCallstack-body li {
  padding: 5px;
  padding-left: 8px;
}

.jp-DebuggerCallstack-body li.selected {
  color: white;
  background: var(--jp-brand-color1);
}

.jp-DebuggerCallstack .jp-ToolbarButtonComponent-label {
  display: none;
}
`, "",{"version":3,"sources":["webpack://./../node_modules/@jupyterlab/debugger/style/callstack.css"],"names":[],"mappings":"AAAA;;;8EAG8E;;AAE9E;EACE,aAAa;EACb,sBAAsB;EACtB,gBAAgB;EAChB,gBAAgB;AAClB;;AAEA;EACE,cAAc;AAChB;;AAEA;EACE,gBAAgB;EAChB,SAAS;EACT,UAAU;EACV,mCAAmC;EACnC,+BAA+B;EAC/B,kCAAkC;AACpC;;AAEA;EACE,YAAY;EACZ,iBAAiB;AACnB;;AAEA;EACE,YAAY;EACZ,kCAAkC;AACpC;;AAEA;EACE,aAAa;AACf","sourcesContent":["/*-----------------------------------------------------------------------------\n| Copyright (c) Jupyter Development Team.\n| Distributed under the terms of the Modified BSD License.\n|----------------------------------------------------------------------------*/\n\n.jp-DebuggerCallstack {\n  display: flex;\n  flex-direction: column;\n  min-height: 50px;\n  padding-top: 3px;\n}\n\n.jp-DebuggerCallstack-body {\n  overflow: auto;\n}\n\n.jp-DebuggerCallstack-body ul {\n  list-style: none;\n  margin: 0;\n  padding: 0;\n  background: var(--jp-layout-color1);\n  color: var(--jp-ui-font-color1);\n  font-size: var(--jp-ui-font-size1);\n}\n\n.jp-DebuggerCallstack-body li {\n  padding: 5px;\n  padding-left: 8px;\n}\n\n.jp-DebuggerCallstack-body li.selected {\n  color: white;\n  background: var(--jp-brand-color1);\n}\n\n.jp-DebuggerCallstack .jp-ToolbarButtonComponent-label {\n  display: none;\n}\n"],"sourceRoot":""}]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ 14131:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Z: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(82971);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(11368);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
// Imports


var ___CSS_LOADER_EXPORT___ = _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default()));
// Module
___CSS_LOADER_EXPORT___.push([module.id, `/*-----------------------------------------------------------------------------
| Copyright (c) Jupyter Development Team.
| Distributed under the terms of the Modified BSD License.
|----------------------------------------------------------------------------*/

.jp-DebuggerEditor-highlight {
  text-shadow: 0 0 1px var(--jp-layout-color0);
  outline: 1px solid;
}

body[data-jp-theme-light='false'] .jp-DebuggerEditor-highlight {
  background-color: var(--md-brown-800, #4e342e);
  outline-color: var(--md-brown-600, #6d4c41);
}

body[data-jp-theme-light='true'] .jp-DebuggerEditor-highlight {
  background-color: var(--md-brown-100, #d7ccc8);
  outline-color: var(--md-brown-300, #a1887f);
}

.jp-DebuggerEditor-marker {
  position: absolute;
  left: -34px;
  top: -1px;
  color: var(--jp-error-color1);
}
`, "",{"version":3,"sources":["webpack://./../node_modules/@jupyterlab/debugger/style/editor.css"],"names":[],"mappings":"AAAA;;;8EAG8E;;AAE9E;EACE,4CAA4C;EAC5C,kBAAkB;AACpB;;AAEA;EACE,8CAA8C;EAC9C,2CAA2C;AAC7C;;AAEA;EACE,8CAA8C;EAC9C,2CAA2C;AAC7C;;AAEA;EACE,kBAAkB;EAClB,WAAW;EACX,SAAS;EACT,6BAA6B;AAC/B","sourcesContent":["/*-----------------------------------------------------------------------------\n| Copyright (c) Jupyter Development Team.\n| Distributed under the terms of the Modified BSD License.\n|----------------------------------------------------------------------------*/\n\n.jp-DebuggerEditor-highlight {\n  text-shadow: 0 0 1px var(--jp-layout-color0);\n  outline: 1px solid;\n}\n\nbody[data-jp-theme-light='false'] .jp-DebuggerEditor-highlight {\n  background-color: var(--md-brown-800, #4e342e);\n  outline-color: var(--md-brown-600, #6d4c41);\n}\n\nbody[data-jp-theme-light='true'] .jp-DebuggerEditor-highlight {\n  background-color: var(--md-brown-100, #d7ccc8);\n  outline-color: var(--md-brown-300, #a1887f);\n}\n\n.jp-DebuggerEditor-marker {\n  position: absolute;\n  left: -34px;\n  top: -1px;\n  color: var(--jp-error-color1);\n}\n"],"sourceRoot":""}]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ 77173:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Z: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(82971);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(11368);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
// Imports


var ___CSS_LOADER_EXPORT___ = _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default()));
// Module
___CSS_LOADER_EXPORT___.push([module.id, `/*-----------------------------------------------------------------------------
| Copyright (c) Jupyter Development Team.
| Distributed under the terms of the Modified BSD License.
|----------------------------------------------------------------------------*/

.jp-DebuggerKernelSources {
  min-height: 50px;
  margin-top: 3px;
}

[data-jp-debugger='true'].jp-Editor .jp-mod-readOnly {
  background: var(--jp-layout-color2);
  height: 100%;
}

.jp-DebuggerKernelSources-body [data-jp-debugger='true'].jp-Editor {
  height: 100%;
}

.jp-DebuggerKernelSources-body {
  height: 100%;
  overflow-y: auto;
}

.jp-DebuggerKernelSource-filterBox {
  padding: 0;
  flex: 0 0 auto;
  margin: 0;
  position: sticky;
  top: 0;
  background-color: var(--jp-layout-color1);
}

.jp-DebuggerKernelSource-filterBox-hidden {
  display: none;
}

.jp-DebuggerKernelSource-source {
  display: flex;
  align-items: center;
  padding: 4px;
  cursor: pointer;
}

.jp-DebuggerKernelSource-source:hover {
  background-color: var(--jp-layout-color2);
}

.jp-DebuggerKernelSource-source > svg {
  height: 16px;
  width: 16px;
}
`, "",{"version":3,"sources":["webpack://./../node_modules/@jupyterlab/debugger/style/kernelSources.css"],"names":[],"mappings":"AAAA;;;8EAG8E;;AAE9E;EACE,gBAAgB;EAChB,eAAe;AACjB;;AAEA;EACE,mCAAmC;EACnC,YAAY;AACd;;AAEA;EACE,YAAY;AACd;;AAEA;EACE,YAAY;EACZ,gBAAgB;AAClB;;AAEA;EACE,UAAU;EACV,cAAc;EACd,SAAS;EACT,gBAAgB;EAChB,MAAM;EACN,yCAAyC;AAC3C;;AAEA;EACE,aAAa;AACf;;AAEA;EACE,aAAa;EACb,mBAAmB;EACnB,YAAY;EACZ,eAAe;AACjB;;AAEA;EACE,yCAAyC;AAC3C;;AAEA;EACE,YAAY;EACZ,WAAW;AACb","sourcesContent":["/*-----------------------------------------------------------------------------\n| Copyright (c) Jupyter Development Team.\n| Distributed under the terms of the Modified BSD License.\n|----------------------------------------------------------------------------*/\n\n.jp-DebuggerKernelSources {\n  min-height: 50px;\n  margin-top: 3px;\n}\n\n[data-jp-debugger='true'].jp-Editor .jp-mod-readOnly {\n  background: var(--jp-layout-color2);\n  height: 100%;\n}\n\n.jp-DebuggerKernelSources-body [data-jp-debugger='true'].jp-Editor {\n  height: 100%;\n}\n\n.jp-DebuggerKernelSources-body {\n  height: 100%;\n  overflow-y: auto;\n}\n\n.jp-DebuggerKernelSource-filterBox {\n  padding: 0;\n  flex: 0 0 auto;\n  margin: 0;\n  position: sticky;\n  top: 0;\n  background-color: var(--jp-layout-color1);\n}\n\n.jp-DebuggerKernelSource-filterBox-hidden {\n  display: none;\n}\n\n.jp-DebuggerKernelSource-source {\n  display: flex;\n  align-items: center;\n  padding: 4px;\n  cursor: pointer;\n}\n\n.jp-DebuggerKernelSource-source:hover {\n  background-color: var(--jp-layout-color2);\n}\n\n.jp-DebuggerKernelSource-source > svg {\n  height: 16px;\n  width: 16px;\n}\n"],"sourceRoot":""}]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ 3742:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Z: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(82971);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(11368);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
// Imports


var ___CSS_LOADER_EXPORT___ = _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default()));
// Module
___CSS_LOADER_EXPORT___.push([module.id, `/*-----------------------------------------------------------------------------
| Copyright (c) Jupyter Development Team.
| Distributed under the terms of the Modified BSD License.
|----------------------------------------------------------------------------*/

.jp-SidePanel-header > h2 {
  /* Set font-size to override default h2 sizing but keeping default --jp-ui-font-size0 */
  font-size: 100%;
  font-weight: 600;
  margin: 0 auto 0 0;
  padding: 4px 10px;
}

.jp-DebuggerSidebar-body
  .jp-AccordionPanel-title
  jp-toolbar::part(positioning-region) {
  flex-wrap: nowrap;
}
`, "",{"version":3,"sources":["webpack://./../node_modules/@jupyterlab/debugger/style/sidebar.css"],"names":[],"mappings":"AAAA;;;8EAG8E;;AAE9E;EACE,uFAAuF;EACvF,eAAe;EACf,gBAAgB;EAChB,kBAAkB;EAClB,iBAAiB;AACnB;;AAEA;;;EAGE,iBAAiB;AACnB","sourcesContent":["/*-----------------------------------------------------------------------------\n| Copyright (c) Jupyter Development Team.\n| Distributed under the terms of the Modified BSD License.\n|----------------------------------------------------------------------------*/\n\n.jp-SidePanel-header > h2 {\n  /* Set font-size to override default h2 sizing but keeping default --jp-ui-font-size0 */\n  font-size: 100%;\n  font-weight: 600;\n  margin: 0 auto 0 0;\n  padding: 4px 10px;\n}\n\n.jp-DebuggerSidebar-body\n  .jp-AccordionPanel-title\n  jp-toolbar::part(positioning-region) {\n  flex-wrap: nowrap;\n}\n"],"sourceRoot":""}]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ 87383:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Z: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(82971);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(11368);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
// Imports


var ___CSS_LOADER_EXPORT___ = _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default()));
// Module
___CSS_LOADER_EXPORT___.push([module.id, `/*-----------------------------------------------------------------------------
| Copyright (c) Jupyter Development Team.
| Distributed under the terms of the Modified BSD License.
|----------------------------------------------------------------------------*/

.jp-DebuggerSources {
  min-height: 50px;
  margin-top: 3px;
}

[data-jp-debugger='true'].jp-Editor .jp-mod-readOnly {
  background: var(--jp-layout-color2);
  height: 100%;
}

.jp-DebuggerSources-body [data-jp-debugger='true'].jp-Editor {
  height: 100%;
}

.jp-DebuggerSources-body {
  height: 100%;
}

.jp-DebuggerSources-header-path {
  overflow: hidden;
  cursor: pointer;
  text-overflow: ellipsis;
  white-space: nowrap;
  font-size: var(--jp-ui-font-size0);
  color: var(--jp-ui-font-color1);
  user-select: text;
}
`, "",{"version":3,"sources":["webpack://./../node_modules/@jupyterlab/debugger/style/sources.css"],"names":[],"mappings":"AAAA;;;8EAG8E;;AAE9E;EACE,gBAAgB;EAChB,eAAe;AACjB;;AAEA;EACE,mCAAmC;EACnC,YAAY;AACd;;AAEA;EACE,YAAY;AACd;;AAEA;EACE,YAAY;AACd;;AAEA;EACE,gBAAgB;EAChB,eAAe;EACf,uBAAuB;EACvB,mBAAmB;EACnB,kCAAkC;EAClC,+BAA+B;EAC/B,iBAAiB;AACnB","sourcesContent":["/*-----------------------------------------------------------------------------\n| Copyright (c) Jupyter Development Team.\n| Distributed under the terms of the Modified BSD License.\n|----------------------------------------------------------------------------*/\n\n.jp-DebuggerSources {\n  min-height: 50px;\n  margin-top: 3px;\n}\n\n[data-jp-debugger='true'].jp-Editor .jp-mod-readOnly {\n  background: var(--jp-layout-color2);\n  height: 100%;\n}\n\n.jp-DebuggerSources-body [data-jp-debugger='true'].jp-Editor {\n  height: 100%;\n}\n\n.jp-DebuggerSources-body {\n  height: 100%;\n}\n\n.jp-DebuggerSources-header-path {\n  overflow: hidden;\n  cursor: pointer;\n  text-overflow: ellipsis;\n  white-space: nowrap;\n  font-size: var(--jp-ui-font-size0);\n  color: var(--jp-ui-font-color1);\n  user-select: text;\n}\n"],"sourceRoot":""}]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ 74328:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Z: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(82971);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(11368);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
// Imports


var ___CSS_LOADER_EXPORT___ = _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default()));
// Module
___CSS_LOADER_EXPORT___.push([module.id, `/*-----------------------------------------------------------------------------
| Copyright (c) Jupyter Development Team.
| Distributed under the terms of the Modified BSD License.
|----------------------------------------------------------------------------*/

.jp-DebuggerVariables {
  display: flex;
  flex-direction: column;
  min-height: 50px;
  padding-top: 3px;
}

.jp-DebuggerVariables-body {
  display: flex;
  flex-direction: column;
  flex: 1 1 auto;
  min-height: 24px;
  overflow: auto;

  /* For absolute positioning of jp-DebuggerVariables-buttons. */
  position: relative;
}

.jp-DebuggerVariables-name {
  color: var(--jp-mirror-editor-attribute-color);
  grid-area: name;
}

.jp-DebuggerVariables-name:last-of-type {
  flex: 1 1 auto;
}

.jp-DebuggerVariables-name::after {
  content: ':';
  margin-right: 5px;
}

.jp-DebuggerVariables-detail {
  /* detail contains value for primitive types or name of the type otherwise */
  color: var(--jp-mirror-editor-string-color);
  flex: 1 1 auto;
  overflow: hidden;
  white-space: nowrap;
  text-overflow: ellipsis;
}

.jp-DebuggerVariables-grid {
  flex: 1 1 auto;
}

.jp-DebuggerVariables-grid .lm-DataGrid {
  border: none;
}

.jp-DebuggerVariables-colorPalette {
  visibility: hidden;
  z-index: -999;
  position: absolute;
  left: -999px;
  top: -999px;
}

.jp-DebuggerVariables-colorPalette .jp-mod-void {
  color: var(--jp-layout-color1);
}

.jp-DebuggerVariables-colorPalette .jp-mod-background {
  color: var(--jp-rendermime-table-row-background);
}

.jp-DebuggerVariables-colorPalette .jp-mod-header-background {
  color: var(--jp-layout-color2);
}

.jp-DebuggerVariables-colorPalette .jp-mod-grid-line {
  color: var(--jp-border-color3);
}

.jp-DebuggerVariables-colorPalette .jp-mod-header-grid-line {
  color: var(--jp-border-color3);
}

.jp-DebuggerVariables-colorPalette .jp-mod-selection {
  /* TODO: Fix JupyterLab light theme (alpha) so this can be a variable. */
  color: rgba(3, 169, 244, 0.2);
}

.jp-DebuggerVariables-colorPalette .jp-mod-text {
  color: var(--jp-content-font-color0);
}

.jp-VariableRendererPanel {
  overflow: auto;
}

.jp-VariableRendererPanel-renderer {
  overflow: auto;
  height: 100%;
}

.jp-VariableRenderer-TrustButton[aria-pressed='true'] {
  box-shadow: inset 0 var(--jp-border-width) 4px
    rgba(
      var(--jp-shadow-base-lightness),
      var(--jp-shadow-base-lightness),
      var(--jp-shadow-base-lightness),
      0.6
    );
}

.jp-DebuggerRichVariable div[data-mime-type='text/plain'] > pre {
  white-space: normal;
}
`, "",{"version":3,"sources":["webpack://./../node_modules/@jupyterlab/debugger/style/variables.css"],"names":[],"mappings":"AAAA;;;8EAG8E;;AAE9E;EACE,aAAa;EACb,sBAAsB;EACtB,gBAAgB;EAChB,gBAAgB;AAClB;;AAEA;EACE,aAAa;EACb,sBAAsB;EACtB,cAAc;EACd,gBAAgB;EAChB,cAAc;;EAEd,8DAA8D;EAC9D,kBAAkB;AACpB;;AAEA;EACE,8CAA8C;EAC9C,eAAe;AACjB;;AAEA;EACE,cAAc;AAChB;;AAEA;EACE,YAAY;EACZ,iBAAiB;AACnB;;AAEA;EACE,4EAA4E;EAC5E,2CAA2C;EAC3C,cAAc;EACd,gBAAgB;EAChB,mBAAmB;EACnB,uBAAuB;AACzB;;AAEA;EACE,cAAc;AAChB;;AAEA;EACE,YAAY;AACd;;AAEA;EACE,kBAAkB;EAClB,aAAa;EACb,kBAAkB;EAClB,YAAY;EACZ,WAAW;AACb;;AAEA;EACE,8BAA8B;AAChC;;AAEA;EACE,gDAAgD;AAClD;;AAEA;EACE,8BAA8B;AAChC;;AAEA;EACE,8BAA8B;AAChC;;AAEA;EACE,8BAA8B;AAChC;;AAEA;EACE,wEAAwE;EACxE,6BAA6B;AAC/B;;AAEA;EACE,oCAAoC;AACtC;;AAEA;EACE,cAAc;AAChB;;AAEA;EACE,cAAc;EACd,YAAY;AACd;;AAEA;EACE;;;;;;KAMG;AACL;;AAEA;EACE,mBAAmB;AACrB","sourcesContent":["/*-----------------------------------------------------------------------------\n| Copyright (c) Jupyter Development Team.\n| Distributed under the terms of the Modified BSD License.\n|----------------------------------------------------------------------------*/\n\n.jp-DebuggerVariables {\n  display: flex;\n  flex-direction: column;\n  min-height: 50px;\n  padding-top: 3px;\n}\n\n.jp-DebuggerVariables-body {\n  display: flex;\n  flex-direction: column;\n  flex: 1 1 auto;\n  min-height: 24px;\n  overflow: auto;\n\n  /* For absolute positioning of jp-DebuggerVariables-buttons. */\n  position: relative;\n}\n\n.jp-DebuggerVariables-name {\n  color: var(--jp-mirror-editor-attribute-color);\n  grid-area: name;\n}\n\n.jp-DebuggerVariables-name:last-of-type {\n  flex: 1 1 auto;\n}\n\n.jp-DebuggerVariables-name::after {\n  content: ':';\n  margin-right: 5px;\n}\n\n.jp-DebuggerVariables-detail {\n  /* detail contains value for primitive types or name of the type otherwise */\n  color: var(--jp-mirror-editor-string-color);\n  flex: 1 1 auto;\n  overflow: hidden;\n  white-space: nowrap;\n  text-overflow: ellipsis;\n}\n\n.jp-DebuggerVariables-grid {\n  flex: 1 1 auto;\n}\n\n.jp-DebuggerVariables-grid .lm-DataGrid {\n  border: none;\n}\n\n.jp-DebuggerVariables-colorPalette {\n  visibility: hidden;\n  z-index: -999;\n  position: absolute;\n  left: -999px;\n  top: -999px;\n}\n\n.jp-DebuggerVariables-colorPalette .jp-mod-void {\n  color: var(--jp-layout-color1);\n}\n\n.jp-DebuggerVariables-colorPalette .jp-mod-background {\n  color: var(--jp-rendermime-table-row-background);\n}\n\n.jp-DebuggerVariables-colorPalette .jp-mod-header-background {\n  color: var(--jp-layout-color2);\n}\n\n.jp-DebuggerVariables-colorPalette .jp-mod-grid-line {\n  color: var(--jp-border-color3);\n}\n\n.jp-DebuggerVariables-colorPalette .jp-mod-header-grid-line {\n  color: var(--jp-border-color3);\n}\n\n.jp-DebuggerVariables-colorPalette .jp-mod-selection {\n  /* TODO: Fix JupyterLab light theme (alpha) so this can be a variable. */\n  color: rgba(3, 169, 244, 0.2);\n}\n\n.jp-DebuggerVariables-colorPalette .jp-mod-text {\n  color: var(--jp-content-font-color0);\n}\n\n.jp-VariableRendererPanel {\n  overflow: auto;\n}\n\n.jp-VariableRendererPanel-renderer {\n  overflow: auto;\n  height: 100%;\n}\n\n.jp-VariableRenderer-TrustButton[aria-pressed='true'] {\n  box-shadow: inset 0 var(--jp-border-width) 4px\n    rgba(\n      var(--jp-shadow-base-lightness),\n      var(--jp-shadow-base-lightness),\n      var(--jp-shadow-base-lightness),\n      0.6\n    );\n}\n\n.jp-DebuggerRichVariable div[data-mime-type='text/plain'] > pre {\n  white-space: normal;\n}\n"],"sourceRoot":""}]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ 52847:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Z: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(82971);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(11368);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
// Imports


var ___CSS_LOADER_EXPORT___ = _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default()));
// Module
___CSS_LOADER_EXPORT___.push([module.id, `/*-----------------------------------------------------------------------------
| Copyright (c) Jupyter Development Team.
| Distributed under the terms of the Modified BSD License.
|----------------------------------------------------------------------------*/

.jp-MimeDocument {
  outline: none;
}
`, "",{"version":3,"sources":["webpack://./../node_modules/@jupyterlab/docregistry/style/base.css"],"names":[],"mappings":"AAAA;;;8EAG8E;;AAE9E;EACE,aAAa;AACf","sourcesContent":["/*-----------------------------------------------------------------------------\n| Copyright (c) Jupyter Development Team.\n| Distributed under the terms of the Modified BSD License.\n|----------------------------------------------------------------------------*/\n\n.jp-MimeDocument {\n  outline: none;\n}\n"],"sourceRoot":""}]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ 13994:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Z: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(82971);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(11368);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
// Imports


var ___CSS_LOADER_EXPORT___ = _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default()));
// Module
___CSS_LOADER_EXPORT___.push([module.id, `/*-----------------------------------------------------------------------------
| Copyright (c) Jupyter Development Team.
| Distributed under the terms of the Modified BSD License.
|----------------------------------------------------------------------------*/
.jp-DocumentSearch-input {
  border: none;
  outline: none;
  color: var(--jp-ui-font-color0);
  font-size: var(--jp-ui-font-size1);
  background-color: var(--jp-layout-color0);
  font-family: var(--jp-ui-font-family);
  padding: 2px 1px;
  resize: none;
  white-space: pre;
}

.jp-DocumentSearch-overlay {
  position: absolute;
  background-color: var(--jp-toolbar-background);
  border-bottom: var(--jp-border-width) solid var(--jp-toolbar-border-color);
  border-left: var(--jp-border-width) solid var(--jp-toolbar-border-color);
  top: 0;
  right: 0;
  z-index: 7;
  min-width: 405px;
  padding: 2px;
  font-size: var(--jp-ui-font-size1);

  --jp-private-document-search-button-height: 20px;
}

.jp-DocumentSearch-overlay button {
  background-color: var(--jp-toolbar-background);
  outline: 0;
}

.jp-DocumentSearch-button-wrapper:disabled > .jp-DocumentSearch-button-content {
  opacity: 0.6;
  cursor: not-allowed;
}

.jp-DocumentSearch-overlay button:not(:disabled):hover {
  background-color: var(--jp-layout-color2);
}

.jp-DocumentSearch-overlay button:not(:disabled):active {
  background-color: var(--jp-layout-color3);
}

.jp-DocumentSearch-overlay-row {
  display: flex;
  align-items: center;
  margin-bottom: 2px;
}

.jp-DocumentSearch-button-content {
  display: inline-block;
  cursor: pointer;
  box-sizing: border-box;
  width: 100%;
  height: 100%;
}

.jp-DocumentSearch-button-content svg {
  width: 100%;
  height: 100%;
}

.jp-DocumentSearch-input-wrapper {
  border: var(--jp-border-width) solid var(--jp-border-color0);
  display: flex;
  background-color: var(--jp-layout-color0);
  margin: 2px;
}

.jp-DocumentSearch-input-wrapper:focus-within {
  border-color: var(--jp-cell-editor-active-border-color);
}

.jp-DocumentSearch-toggle-wrapper,
.jp-DocumentSearch-button-wrapper {
  all: initial;
  overflow: hidden;
  display: inline-block;
  border: none;
  box-sizing: border-box;
}

.jp-DocumentSearch-toggle-wrapper {
  flex-shrink: 0;
  width: 14px;
  height: 14px;
}

.jp-DocumentSearch-button-wrapper {
  flex-shrink: 0;
  width: var(--jp-private-document-search-button-height);
  height: var(--jp-private-document-search-button-height);
}

.jp-DocumentSearch-toggle-wrapper:focus,
.jp-DocumentSearch-button-wrapper:focus {
  outline: var(--jp-border-width) solid
    var(--jp-cell-editor-active-border-color);
  outline-offset: -1px;
}

.jp-DocumentSearch-toggle-wrapper,
.jp-DocumentSearch-button-wrapper,
.jp-DocumentSearch-button-content:focus {
  outline: none;
}

.jp-DocumentSearch-toggle-placeholder {
  width: 5px;
}

.jp-DocumentSearch-input-button::before {
  display: block;
  padding-top: 100%;
}

.jp-DocumentSearch-input-button-off {
  opacity: var(--jp-search-toggle-off-opacity);
}

.jp-DocumentSearch-input-button-off:hover {
  opacity: var(--jp-search-toggle-hover-opacity);
}

.jp-DocumentSearch-input-button-on {
  opacity: var(--jp-search-toggle-on-opacity);
}

.jp-DocumentSearch-index-counter {
  padding-left: 10px;
  padding-right: 10px;
  user-select: none;
  min-width: 35px;
  display: inline-block;
}

.jp-DocumentSearch-up-down-wrapper {
  display: inline-block;
  padding-right: 2px;
  margin-left: auto;
  white-space: nowrap;
}

.jp-DocumentSearch-spacer {
  margin-left: auto;
}

.jp-DocumentSearch-up-down-wrapper button {
  outline: 0;
  border: none;
  width: var(--jp-private-document-search-button-height);
  height: var(--jp-private-document-search-button-height);
  vertical-align: middle;
  margin: 1px 5px 2px;
}

button:not(:disabled) > .jp-DocumentSearch-up-down-button:hover {
  background-color: var(--jp-layout-color2);
}

button:not(:disabled) > .jp-DocumentSearch-up-down-button:active {
  background-color: var(--jp-layout-color3);
}

.jp-DocumentSearch-filter-button {
  border-radius: var(--jp-border-radius);
}

.jp-DocumentSearch-filter-button:hover {
  background-color: var(--jp-layout-color2);
}

.jp-DocumentSearch-filter-button-enabled {
  background-color: var(--jp-layout-color2);
}

.jp-DocumentSearch-filter-button-enabled:hover {
  background-color: var(--jp-layout-color3);
}

.jp-DocumentSearch-search-options {
  padding: 0 8px;
  margin-left: 3px;
  width: 100%;
  display: grid;
  justify-content: start;
  grid-template-columns: 1fr 1fr;
  align-items: center;
  justify-items: stretch;
}

.jp-DocumentSearch-search-filter-disabled {
  color: var(--jp-ui-font-color2);
}

.jp-DocumentSearch-search-filter {
  display: flex;
  align-items: center;
  user-select: none;
}

.jp-DocumentSearch-regex-error {
  color: var(--jp-error-color0);
}

.jp-DocumentSearch-replace-button-wrapper {
  overflow: hidden;
  display: inline-block;
  box-sizing: border-box;
  border: var(--jp-border-width) solid var(--jp-border-color0);
  margin: auto 2px;
  padding: 1px 4px;
  height: calc(var(--jp-private-document-search-button-height) + 2px);
  flex-shrink: 0;
}

.jp-DocumentSearch-replace-button-wrapper:focus {
  border: var(--jp-border-width) solid var(--jp-cell-editor-active-border-color);
}

.jp-DocumentSearch-replace-button {
  display: inline-block;
  text-align: center;
  cursor: pointer;
  box-sizing: border-box;
  color: var(--jp-ui-font-color1);

  /* height - 2 * (padding of wrapper) */
  line-height: calc(var(--jp-private-document-search-button-height) - 2px);
  width: 100%;
  height: 100%;
}

.jp-DocumentSearch-replace-button:focus {
  outline: none;
}

.jp-DocumentSearch-replace-wrapper-class {
  margin-left: 14px;
  display: flex;
}

.jp-DocumentSearch-replace-toggle {
  border: none;
  background-color: var(--jp-toolbar-background);
  border-radius: var(--jp-border-radius);
}

.jp-DocumentSearch-replace-toggle:hover {
  background-color: var(--jp-layout-color2);
}

/*
  The following few rules allow the search box to expand horizontally,
  as the text within it grows. This is done by using putting
  the text within a wrapper element and using that wrapper for sizing,
  as <textarea> and <input> tags do not grow automatically.
  This is the underlying technique:
  https://til.simonwillison.net/css/resizing-textarea
*/
.jp-DocumentSearch-input-label::after {
  content: attr(data-value) ' ';
  visibility: hidden;
  white-space: pre;
}

.jp-DocumentSearch-input-label {
  display: inline-grid;
  align-items: stretch;
}

.jp-DocumentSearch-input-label::after,
.jp-DocumentSearch-input-label > .jp-DocumentSearch-input {
  width: auto;
  min-width: 1em;
  grid-area: 1/2;
  font: inherit;
  padding: 2px 3px;
  margin: 0;
  resize: none;
  background: none;
  appearance: none;
  border: none;
  overflow: hidden;
}
`, "",{"version":3,"sources":["webpack://./../node_modules/@jupyterlab/documentsearch/style/base.css"],"names":[],"mappings":"AAAA;;;8EAG8E;AAC9E;EACE,YAAY;EACZ,aAAa;EACb,+BAA+B;EAC/B,kCAAkC;EAClC,yCAAyC;EACzC,qCAAqC;EACrC,gBAAgB;EAChB,YAAY;EACZ,gBAAgB;AAClB;;AAEA;EACE,kBAAkB;EAClB,8CAA8C;EAC9C,0EAA0E;EAC1E,wEAAwE;EACxE,MAAM;EACN,QAAQ;EACR,UAAU;EACV,gBAAgB;EAChB,YAAY;EACZ,kCAAkC;;EAElC,gDAAgD;AAClD;;AAEA;EACE,8CAA8C;EAC9C,UAAU;AACZ;;AAEA;EACE,YAAY;EACZ,mBAAmB;AACrB;;AAEA;EACE,yCAAyC;AAC3C;;AAEA;EACE,yCAAyC;AAC3C;;AAEA;EACE,aAAa;EACb,mBAAmB;EACnB,kBAAkB;AACpB;;AAEA;EACE,qBAAqB;EACrB,eAAe;EACf,sBAAsB;EACtB,WAAW;EACX,YAAY;AACd;;AAEA;EACE,WAAW;EACX,YAAY;AACd;;AAEA;EACE,4DAA4D;EAC5D,aAAa;EACb,yCAAyC;EACzC,WAAW;AACb;;AAEA;EACE,uDAAuD;AACzD;;AAEA;;EAEE,YAAY;EACZ,gBAAgB;EAChB,qBAAqB;EACrB,YAAY;EACZ,sBAAsB;AACxB;;AAEA;EACE,cAAc;EACd,WAAW;EACX,YAAY;AACd;;AAEA;EACE,cAAc;EACd,sDAAsD;EACtD,uDAAuD;AACzD;;AAEA;;EAEE;6CAC2C;EAC3C,oBAAoB;AACtB;;AAEA;;;EAGE,aAAa;AACf;;AAEA;EACE,UAAU;AACZ;;AAEA;EACE,cAAc;EACd,iBAAiB;AACnB;;AAEA;EACE,4CAA4C;AAC9C;;AAEA;EACE,8CAA8C;AAChD;;AAEA;EACE,2CAA2C;AAC7C;;AAEA;EACE,kBAAkB;EAClB,mBAAmB;EACnB,iBAAiB;EACjB,eAAe;EACf,qBAAqB;AACvB;;AAEA;EACE,qBAAqB;EACrB,kBAAkB;EAClB,iBAAiB;EACjB,mBAAmB;AACrB;;AAEA;EACE,iBAAiB;AACnB;;AAEA;EACE,UAAU;EACV,YAAY;EACZ,sDAAsD;EACtD,uDAAuD;EACvD,sBAAsB;EACtB,mBAAmB;AACrB;;AAEA;EACE,yCAAyC;AAC3C;;AAEA;EACE,yCAAyC;AAC3C;;AAEA;EACE,sCAAsC;AACxC;;AAEA;EACE,yCAAyC;AAC3C;;AAEA;EACE,yCAAyC;AAC3C;;AAEA;EACE,yCAAyC;AAC3C;;AAEA;EACE,cAAc;EACd,gBAAgB;EAChB,WAAW;EACX,aAAa;EACb,sBAAsB;EACtB,8BAA8B;EAC9B,mBAAmB;EACnB,sBAAsB;AACxB;;AAEA;EACE,+BAA+B;AACjC;;AAEA;EACE,aAAa;EACb,mBAAmB;EACnB,iBAAiB;AACnB;;AAEA;EACE,6BAA6B;AAC/B;;AAEA;EACE,gBAAgB;EAChB,qBAAqB;EACrB,sBAAsB;EACtB,4DAA4D;EAC5D,gBAAgB;EAChB,gBAAgB;EAChB,mEAAmE;EACnE,cAAc;AAChB;;AAEA;EACE,8EAA8E;AAChF;;AAEA;EACE,qBAAqB;EACrB,kBAAkB;EAClB,eAAe;EACf,sBAAsB;EACtB,+BAA+B;;EAE/B,sCAAsC;EACtC,wEAAwE;EACxE,WAAW;EACX,YAAY;AACd;;AAEA;EACE,aAAa;AACf;;AAEA;EACE,iBAAiB;EACjB,aAAa;AACf;;AAEA;EACE,YAAY;EACZ,8CAA8C;EAC9C,sCAAsC;AACxC;;AAEA;EACE,yCAAyC;AAC3C;;AAEA;;;;;;;CAOC;AACD;EACE,6BAA6B;EAC7B,kBAAkB;EAClB,gBAAgB;AAClB;;AAEA;EACE,oBAAoB;EACpB,oBAAoB;AACtB;;AAEA;;EAEE,WAAW;EACX,cAAc;EACd,cAAc;EACd,aAAa;EACb,gBAAgB;EAChB,SAAS;EACT,YAAY;EACZ,gBAAgB;EAChB,gBAAgB;EAChB,YAAY;EACZ,gBAAgB;AAClB","sourcesContent":["/*-----------------------------------------------------------------------------\n| Copyright (c) Jupyter Development Team.\n| Distributed under the terms of the Modified BSD License.\n|----------------------------------------------------------------------------*/\n.jp-DocumentSearch-input {\n  border: none;\n  outline: none;\n  color: var(--jp-ui-font-color0);\n  font-size: var(--jp-ui-font-size1);\n  background-color: var(--jp-layout-color0);\n  font-family: var(--jp-ui-font-family);\n  padding: 2px 1px;\n  resize: none;\n  white-space: pre;\n}\n\n.jp-DocumentSearch-overlay {\n  position: absolute;\n  background-color: var(--jp-toolbar-background);\n  border-bottom: var(--jp-border-width) solid var(--jp-toolbar-border-color);\n  border-left: var(--jp-border-width) solid var(--jp-toolbar-border-color);\n  top: 0;\n  right: 0;\n  z-index: 7;\n  min-width: 405px;\n  padding: 2px;\n  font-size: var(--jp-ui-font-size1);\n\n  --jp-private-document-search-button-height: 20px;\n}\n\n.jp-DocumentSearch-overlay button {\n  background-color: var(--jp-toolbar-background);\n  outline: 0;\n}\n\n.jp-DocumentSearch-button-wrapper:disabled > .jp-DocumentSearch-button-content {\n  opacity: 0.6;\n  cursor: not-allowed;\n}\n\n.jp-DocumentSearch-overlay button:not(:disabled):hover {\n  background-color: var(--jp-layout-color2);\n}\n\n.jp-DocumentSearch-overlay button:not(:disabled):active {\n  background-color: var(--jp-layout-color3);\n}\n\n.jp-DocumentSearch-overlay-row {\n  display: flex;\n  align-items: center;\n  margin-bottom: 2px;\n}\n\n.jp-DocumentSearch-button-content {\n  display: inline-block;\n  cursor: pointer;\n  box-sizing: border-box;\n  width: 100%;\n  height: 100%;\n}\n\n.jp-DocumentSearch-button-content svg {\n  width: 100%;\n  height: 100%;\n}\n\n.jp-DocumentSearch-input-wrapper {\n  border: var(--jp-border-width) solid var(--jp-border-color0);\n  display: flex;\n  background-color: var(--jp-layout-color0);\n  margin: 2px;\n}\n\n.jp-DocumentSearch-input-wrapper:focus-within {\n  border-color: var(--jp-cell-editor-active-border-color);\n}\n\n.jp-DocumentSearch-toggle-wrapper,\n.jp-DocumentSearch-button-wrapper {\n  all: initial;\n  overflow: hidden;\n  display: inline-block;\n  border: none;\n  box-sizing: border-box;\n}\n\n.jp-DocumentSearch-toggle-wrapper {\n  flex-shrink: 0;\n  width: 14px;\n  height: 14px;\n}\n\n.jp-DocumentSearch-button-wrapper {\n  flex-shrink: 0;\n  width: var(--jp-private-document-search-button-height);\n  height: var(--jp-private-document-search-button-height);\n}\n\n.jp-DocumentSearch-toggle-wrapper:focus,\n.jp-DocumentSearch-button-wrapper:focus {\n  outline: var(--jp-border-width) solid\n    var(--jp-cell-editor-active-border-color);\n  outline-offset: -1px;\n}\n\n.jp-DocumentSearch-toggle-wrapper,\n.jp-DocumentSearch-button-wrapper,\n.jp-DocumentSearch-button-content:focus {\n  outline: none;\n}\n\n.jp-DocumentSearch-toggle-placeholder {\n  width: 5px;\n}\n\n.jp-DocumentSearch-input-button::before {\n  display: block;\n  padding-top: 100%;\n}\n\n.jp-DocumentSearch-input-button-off {\n  opacity: var(--jp-search-toggle-off-opacity);\n}\n\n.jp-DocumentSearch-input-button-off:hover {\n  opacity: var(--jp-search-toggle-hover-opacity);\n}\n\n.jp-DocumentSearch-input-button-on {\n  opacity: var(--jp-search-toggle-on-opacity);\n}\n\n.jp-DocumentSearch-index-counter {\n  padding-left: 10px;\n  padding-right: 10px;\n  user-select: none;\n  min-width: 35px;\n  display: inline-block;\n}\n\n.jp-DocumentSearch-up-down-wrapper {\n  display: inline-block;\n  padding-right: 2px;\n  margin-left: auto;\n  white-space: nowrap;\n}\n\n.jp-DocumentSearch-spacer {\n  margin-left: auto;\n}\n\n.jp-DocumentSearch-up-down-wrapper button {\n  outline: 0;\n  border: none;\n  width: var(--jp-private-document-search-button-height);\n  height: var(--jp-private-document-search-button-height);\n  vertical-align: middle;\n  margin: 1px 5px 2px;\n}\n\nbutton:not(:disabled) > .jp-DocumentSearch-up-down-button:hover {\n  background-color: var(--jp-layout-color2);\n}\n\nbutton:not(:disabled) > .jp-DocumentSearch-up-down-button:active {\n  background-color: var(--jp-layout-color3);\n}\n\n.jp-DocumentSearch-filter-button {\n  border-radius: var(--jp-border-radius);\n}\n\n.jp-DocumentSearch-filter-button:hover {\n  background-color: var(--jp-layout-color2);\n}\n\n.jp-DocumentSearch-filter-button-enabled {\n  background-color: var(--jp-layout-color2);\n}\n\n.jp-DocumentSearch-filter-button-enabled:hover {\n  background-color: var(--jp-layout-color3);\n}\n\n.jp-DocumentSearch-search-options {\n  padding: 0 8px;\n  margin-left: 3px;\n  width: 100%;\n  display: grid;\n  justify-content: start;\n  grid-template-columns: 1fr 1fr;\n  align-items: center;\n  justify-items: stretch;\n}\n\n.jp-DocumentSearch-search-filter-disabled {\n  color: var(--jp-ui-font-color2);\n}\n\n.jp-DocumentSearch-search-filter {\n  display: flex;\n  align-items: center;\n  user-select: none;\n}\n\n.jp-DocumentSearch-regex-error {\n  color: var(--jp-error-color0);\n}\n\n.jp-DocumentSearch-replace-button-wrapper {\n  overflow: hidden;\n  display: inline-block;\n  box-sizing: border-box;\n  border: var(--jp-border-width) solid var(--jp-border-color0);\n  margin: auto 2px;\n  padding: 1px 4px;\n  height: calc(var(--jp-private-document-search-button-height) + 2px);\n  flex-shrink: 0;\n}\n\n.jp-DocumentSearch-replace-button-wrapper:focus {\n  border: var(--jp-border-width) solid var(--jp-cell-editor-active-border-color);\n}\n\n.jp-DocumentSearch-replace-button {\n  display: inline-block;\n  text-align: center;\n  cursor: pointer;\n  box-sizing: border-box;\n  color: var(--jp-ui-font-color1);\n\n  /* height - 2 * (padding of wrapper) */\n  line-height: calc(var(--jp-private-document-search-button-height) - 2px);\n  width: 100%;\n  height: 100%;\n}\n\n.jp-DocumentSearch-replace-button:focus {\n  outline: none;\n}\n\n.jp-DocumentSearch-replace-wrapper-class {\n  margin-left: 14px;\n  display: flex;\n}\n\n.jp-DocumentSearch-replace-toggle {\n  border: none;\n  background-color: var(--jp-toolbar-background);\n  border-radius: var(--jp-border-radius);\n}\n\n.jp-DocumentSearch-replace-toggle:hover {\n  background-color: var(--jp-layout-color2);\n}\n\n/*\n  The following few rules allow the search box to expand horizontally,\n  as the text within it grows. This is done by using putting\n  the text within a wrapper element and using that wrapper for sizing,\n  as <textarea> and <input> tags do not grow automatically.\n  This is the underlying technique:\n  https://til.simonwillison.net/css/resizing-textarea\n*/\n.jp-DocumentSearch-input-label::after {\n  content: attr(data-value) ' ';\n  visibility: hidden;\n  white-space: pre;\n}\n\n.jp-DocumentSearch-input-label {\n  display: inline-grid;\n  align-items: stretch;\n}\n\n.jp-DocumentSearch-input-label::after,\n.jp-DocumentSearch-input-label > .jp-DocumentSearch-input {\n  width: auto;\n  min-width: 1em;\n  grid-area: 1/2;\n  font: inherit;\n  padding: 2px 3px;\n  margin: 0;\n  resize: none;\n  background: none;\n  appearance: none;\n  border: none;\n  overflow: hidden;\n}\n"],"sourceRoot":""}]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ 36559:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Z: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(82971);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(11368);
/* harmony import */ var _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
// Imports


var ___CSS_LOADER_EXPORT___ = _builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default()));
// Module
___CSS_LOADER_EXPORT___.push([module.id, `/*
 * Copyright (c) Jupyter Development Team.
 * Distributed under the terms of the Modified BSD License.
 */

/*
  Main widget layout and styling
*/

.jp-extensionmanager-view .lm-SplitPanel-child {
  overflow-y: auto;
}

.jp-extensionmanager-header {
  width: 100%;
}

.jp-extensionmanager-title {
  display: flex;
  margin: 4px 10px 0;
}

.jp-extensionmanager-title svg {
  width: 14px;
}

.jp-extensionmanager-title .jp-icon3[fill] {
  fill: currentcolor;
}

.jp-extensionmanager-path {
  display: inline flex;
  padding-left: 4px;
}

.jp-extensionmanager-header .jp-FilterBox {
  margin: 4px 10px 0;
  width: calc(100% - 20px);
  font-weight: normal;
}

.jp-extensionmanager-disclaimer {
  padding: 0 8px;
  min-height: 160px;
}

.jp-extensionmanager-disclaimer a {
  color: var(--jp-content-link-color);
  text-decoration: none;
}

.jp-extensionmanager-disclaimer a:hover {
  color: var(--jp-content-link-hover-color, var(--jp-content-link-color));
  text-decoration: underline;
}

.jp-extensionmanager-disclaimer .jp-Button {
  margin: 0 5px;
}

/*
  List view layout and styling
*/

.jp-extensionmanager-listview-wrapper {
  margin: 0;
  padding: 0;
  display: flex;
  flex-direction: column;
  height: 100%;
}

.jp-extensionmanager-listview {
  list-style-type: none;
  margin: 0;
  padding: 0;
  min-height: 0;
  flex: 1 1 auto;
  overflow: auto;
}

/*
  Section headers
*/

.jp-extensionmanager-view .jp-SidePanel-header .jp-extensionmanager-error {
  text-transform: none;
  font-size: var(--jp-ui-font-size1);
  font-weight: 400;
}

/*
  Error messages
*/

.jp-extensionmanager-view .jp-extensionmanager-error pre {
  white-space: pre-wrap;
}

/*
  List view pagination styling
*/

.jp-extensionmanager-view ul.pagination {
  display: flex;
  justify-content: center;
  padding-left: 0;
  padding-right: 0;
}

.jp-extensionmanager-pagination li {
  display: inline-block;
}

/* stylelint-disable selector-max-type */
.jp-extensionmanager-pagination li > a {
  padding: 0 5px;
  cursor: pointer;
}
/* stylelint-enable selector-max-type */

.jp-extensionmanager-pagination li.active > a {
  background: var(--jp-brand-color1);
  color: var(--jp-layout-color1);
}

.jp-extensionmanager-pagination li > a:hover {
  