/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.util;

import com.install4j.api.Util;
import com.install4j.api.beans.ExternalFile;
import com.install4j.api.context.Context;
import com.install4j.runtime.beans.applications.Application;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.frontend.GUIHelper;
import com.install4j.runtime.installer.helper.Install4jClassLoader;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.comm.HelperCommunication;
import com.install4j.runtime.util.MultiIcon;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IconHelper {
    public static final Icon DEFAULT_ICON_FRAME_16 = IconHelper.loadIcon("install4j_icon_16.png");
    public static final Icon DEFAULT_ICON_FRAME_32 = IconHelper.loadIcon("install4j_icon_32.png");
    public static final Icon ICON_FOLDER_OPEN = IconHelper.loadIcon("folder_open_16.png");
    public static final Icon ICON_FOLDER_CLOSED = IconHelper.loadIcon("folder_closed_16.png");
    private static final String ICONS_DIRECTORY = "icons/";
    private static Map<File, Icon> iconCache = new HashMap<File, Icon>();

    public static URL getIconUrl(String fileName) {
        if (fileName.startsWith("icon:")) {
            fileName = fileName.substring("icon:".length());
        }
        String fileNameWithDirectory = ICONS_DIRECTORY + fileName;
        Class<GUIHelper> builtinClass = GUIHelper.class;
        String resourcePath = builtinClass.getPackage().getName().replace('.', '/') + "/" + fileNameWithDirectory;
        URL resource = Install4jClassLoader.getInstance().getResourceWithoutParent(resourcePath);
        if (resource != null) {
            return resource;
        }
        return builtinClass.getResource(fileNameWithDirectory);
    }

    @NotNull
    public static ImageIcon coalesce(@Nullable ImageIcon icon1, @NotNull ImageIcon icon2) {
        if (icon1 != null) {
            return icon1;
        }
        return icon2;
    }

    @NotNull
    public static ImageIcon coalesce(@Nullable ImageIcon icon1, @Nullable ImageIcon icon2, @Nullable ImageIcon icon3, @NotNull ImageIcon icon4) {
        if (icon1 != null) {
            return icon1;
        }
        if (icon2 != null) {
            return icon2;
        }
        if (icon3 != null) {
            return icon3;
        }
        return icon4;
    }

    @NotNull
    public static String toHighResFileName(String fileName) {
        return IconHelper.substringBeforeLastDot(fileName) + "@2x" + IconHelper.substringFromLastDot(fileName);
    }

    @NotNull
    public static String toDarkFileName(String fileName) {
        return IconHelper.substringBeforeLastDot(fileName) + "_dark" + IconHelper.substringFromLastDot(fileName);
    }

    @NotNull
    private static String substringBeforeLastDot(@NotNull String fileName) {
        int index = fileName.lastIndexOf(46);
        if (index > -1) {
            return fileName.substring(0, index);
        }
        return fileName;
    }

    @NotNull
    private static String substringFromLastDot(@NotNull String fileName) {
        int index = fileName.lastIndexOf(46);
        if (index > -1) {
            return fileName.substring(index);
        }
        return "";
    }

    public static Image getImage(@NotNull Icon icon) {
        if (icon instanceof MultiIcon) {
            return ((MultiIcon)icon).getImage();
        }
        if (icon instanceof ImageIcon) {
            return ((ImageIcon)icon).getImage();
        }
        throw new IllegalArgumentException("Cannot get image of icon class " + icon.getClass());
    }

    @NotNull
    public static Icon loadIcon(String fileName) {
        HelperCommunication.helperUnsupported();
        return new MultiIcon(fileName);
    }

    public static void withIcon(ExternalFile file, Context context, IconConsumer<?> iconConsumer) {
        IconHelper.withIcon(file, null, context, iconConsumer);
    }

    public static <T> T withIcon(ExternalFile file, T defaultReturnValue, Context context, IconConsumer<T> iconConsumer) {
        Icon imageIcon;
        File actualFile = context.getExternalFile(file, false);
        Icon icon = imageIcon = actualFile != null ? IconHelper.loadIcon(actualFile) : null;
        if (imageIcon != null) {
            return iconConsumer.call(imageIcon);
        }
        return defaultReturnValue;
    }

    @Nullable
    public static Icon loadIcon(@NotNull File file) {
        HelperCommunication.helperUnsupported();
        Icon icon = iconCache.get(file);
        if (icon == null) {
            try {
                icon = new MultiIcon(file);
            }
            catch (Exception e) {
                Util.printAnnotatedStackTrace(e);
                Logger.getInstance().log(e);
            }
            iconCache.put(file, icon);
        }
        return icon;
    }

    public static List<Image> getFrameIconImages() {
        HelperCommunication.helperUnsupported();
        ArrayList<Image> icons = new ArrayList<Image>();
        Application currentApplication = InstallerConfig.getCurrentApplication();
        if (currentApplication != null && currentApplication.isUseCustomIcon()) {
            try {
                for (ExternalFile iconFile : currentApplication.getCustomIconImageFiles()) {
                    Icon icon = IconHelper.loadIcon(InstallerUtil.getInstallerFile(iconFile.getPath()));
                    if (icon == null || icon.getIconWidth() <= 0) continue;
                    icons.add(IconHelper.getImage(icon));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (icons.size() == 0) {
            icons.add(IconHelper.getImage(DEFAULT_ICON_FRAME_16));
            icons.add(IconHelper.getImage(IconHelper.loadIcon("install4j_icon_24@n.png")));
            icons.add(IconHelper.getImage(DEFAULT_ICON_FRAME_32));
            icons.add(IconHelper.getImage(IconHelper.loadIcon("install4j_icon_48@n.png")));
            icons.add(IconHelper.getImage(IconHelper.loadIcon("install4j_icon_64@n.png")));
            icons.add(IconHelper.getImage(IconHelper.loadIcon("install4j_icon_128@n.png")));
        }
        return icons;
    }

    public static void setIconImages(Window window) {
        HelperCommunication.helperUnsupported();
        window.setIconImages(IconHelper.getFrameIconImages());
    }

    public static int getIconSize(File file) throws IOException {
        int height;
        BufferedImage image = ImageIO.read(file);
        int width = image.getWidth();
        if (width != (height = image.getHeight())) {
            throw new IOException(file + " is not square: " + width + " != " + height);
        }
        return width;
    }

    @NotNull
    public static ImageIcon darkenIcon(@NotNull ImageIcon icon) {
        return new ImageIcon(IconHelper.darkenImage(icon.getImage(), 0.8f));
    }

    @NotNull
    private static BufferedImage darkenImage(@NotNull Image image, float scaleFactor) {
        BufferedImage bufferedImage = IconHelper.toBufferedImage(image);
        WritableRaster wr = bufferedImage.getRaster();
        int[] pixel = new int[4];
        for (int i = 0; i < wr.getWidth(); ++i) {
            for (int j = 0; j < wr.getHeight(); ++j) {
                wr.getPixel(i, j, pixel);
                pixel[0] = (int)((float)pixel[0] * scaleFactor);
                pixel[1] = (int)((float)pixel[1] * scaleFactor);
                pixel[2] = (int)((float)pixel[2] * scaleFactor);
                wr.setPixel(i, j, pixel);
            }
        }
        return bufferedImage;
    }

    private static BufferedImage toBufferedImage(@NotNull Image image) {
        BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
        Graphics2D g2 = bufferedImage.createGraphics();
        g2.drawImage(image, 0, 0, null);
        g2.dispose();
        return bufferedImage;
    }

    public static interface IconConsumer<T> {
        public T call(@NotNull Icon var1);
    }
}

