/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.uritemplate.vars.values;

import com.github.fge.uritemplate.vars.values.ValueType;
import com.github.fge.uritemplate.vars.values.VariableValue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@Immutable
public final class ListValue
extends VariableValue {
    private final List<String> list;

    private ListValue(Builder builder) {
        super(ValueType.ARRAY);
        this.list = ImmutableList.copyOf(builder.list);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static <T> VariableValue copyOf(Iterable<T> iterable) {
        return new Builder().addAll(iterable).build();
    }

    public static VariableValue of(Object first, Object ... other) {
        return new Builder().add(first, other).build();
    }

    @Override
    public List<String> getListValue() {
        return this.list;
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @NotThreadSafe
    public static final class Builder {
        private final List<String> list = Lists.newArrayList();

        private Builder() {
        }

        public Builder add(Object first, Object ... other) {
            VariableValue.BUNDLE.checkNotNull(first, "listValue.nullElement");
            this.list.add(first.toString());
            for (Object o : other) {
                VariableValue.BUNDLE.checkNotNull(o, "listValue.nullElement");
                this.list.add(o.toString());
            }
            return this;
        }

        public <T> Builder addAll(Iterable<T> iterable) {
            VariableValue.BUNDLE.checkNotNull(iterable, "listValue.nullIterable");
            for (T element : iterable) {
                VariableValue.BUNDLE.checkNotNull(element, "listValue.nullElement");
                this.list.add(element.toString());
            }
            return this;
        }

        public VariableValue build() {
            return new ListValue(this);
        }
    }
}

