/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.ext;

import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonParser;
import tools.jackson.core.JsonToken;
import tools.jackson.databind.DatabindException;
import tools.jackson.databind.DeserializationConfig;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.ValueDeserializer;
import tools.jackson.databind.deser.std.FromStringDeserializer;

public class CoreXMLDeserializers {
    protected static final QName EMPTY_QNAME = QName.valueOf("");
    static final DatatypeFactory _dataTypeFactory;
    protected static final int TYPE_DURATION = 1;
    protected static final int TYPE_G_CALENDAR = 2;
    protected static final int TYPE_QNAME = 3;

    public static ValueDeserializer<?> findBeanDeserializer(DeserializationConfig config, JavaType type) {
        Class<?> raw = type.getRawClass();
        if (raw == QName.class) {
            return new Std(raw, 3);
        }
        if (raw == XMLGregorianCalendar.class) {
            return new Std(raw, 2);
        }
        if (raw == Duration.class) {
            return new Std(raw, 1);
        }
        return null;
    }

    public static boolean hasDeserializerFor(Class<?> valueType) {
        return valueType == QName.class || valueType == XMLGregorianCalendar.class || valueType == Duration.class;
    }

    static {
        try {
            _dataTypeFactory = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    public static class Std
    extends FromStringDeserializer<Object> {
        protected final int _kind;

        public Std(Class<?> raw, int kind) {
            super(raw);
            this._kind = kind;
        }

        @Override
        public Object deserialize(JsonParser p, DeserializationContext ctxt) throws JacksonException {
            if (this._kind == 2 && p.hasToken(JsonToken.VALUE_NUMBER_INT)) {
                return this._gregorianFromDate(ctxt, this._parseDate(p, ctxt));
            }
            if (this._kind == 3 && p.hasToken(JsonToken.START_OBJECT)) {
                return this._parseQNameObject(p, ctxt);
            }
            return super.deserialize(p, ctxt);
        }

        private QName _parseQNameObject(JsonParser p, DeserializationContext ctxt) throws JacksonException {
            JsonNode namespaceURI;
            JsonNode tree = ctxt.readTree(p);
            JsonNode localPart = tree.get("localPart");
            if (localPart == null) {
                ctxt.reportInputMismatch(this, "Object value for `QName` is missing required property 'localPart'", new Object[0]);
            }
            if (!localPart.isString()) {
                ctxt.reportInputMismatch(this, "Object value property 'localPart' for `QName` must be of type STRING, not %s", new Object[]{localPart.getNodeType()});
            }
            if ((namespaceURI = tree.get("namespaceURI")) != null) {
                if (tree.has("prefix")) {
                    JsonNode prefix = tree.get("prefix");
                    return new QName(namespaceURI.asString(), localPart.asString(), prefix.asString());
                }
                return new QName(namespaceURI.asString(), localPart.asString());
            }
            return new QName(localPart.asString());
        }

        @Override
        protected Object _deserialize(String value, DeserializationContext ctxt) throws JacksonException {
            switch (this._kind) {
                case 1: {
                    return _dataTypeFactory.newDuration(value);
                }
                case 3: {
                    return QName.valueOf(value);
                }
                case 2: {
                    Date d;
                    try {
                        d = this._parseDate(value, ctxt);
                    }
                    catch (DatabindException e) {
                        return _dataTypeFactory.newXMLGregorianCalendar(value);
                    }
                    return this._gregorianFromDate(ctxt, d);
                }
            }
            throw new IllegalStateException();
        }

        @Override
        protected Object _deserializeFromEmptyString(DeserializationContext ctxt) {
            if (this._kind == 3) {
                return EMPTY_QNAME;
            }
            return super._deserializeFromEmptyString(ctxt);
        }

        protected XMLGregorianCalendar _gregorianFromDate(DeserializationContext ctxt, Date d) {
            if (d == null) {
                return null;
            }
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(d);
            TimeZone tz = ctxt.getTimeZone();
            if (tz != null) {
                calendar.setTimeZone(tz);
            }
            return _dataTypeFactory.newXMLGregorianCalendar(calendar);
        }
    }
}

