/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.server.oracle;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.schemacrawler.InformationSchemaViewsBuilder;
import schemacrawler.server.oracle.OracleDatabaseConnector;
import us.fatehi.utility.database.DatabaseUtility;
import us.fatehi.utility.string.StringFormat;

class OracleInformationSchemaViewsBuilder
implements BiConsumer<InformationSchemaViewsBuilder, Connection> {
    private static final Logger LOGGER = Logger.getLogger(OracleDatabaseConnector.class.getName());

    OracleInformationSchemaViewsBuilder() {
    }

    private static String getCatalogScope(Connection connection) {
        String catalogScope;
        String sql = "SELECT TABLE_NAME FROM DBA_TABLES WHERE ROWNUM = 1";
        try (Statement statement = DatabaseUtility.createStatement((Connection)connection);){
            statement.execute("SELECT TABLE_NAME FROM DBA_TABLES WHERE ROWNUM = 1");
            catalogScope = "DBA";
        }
        catch (SQLException e) {
            LOGGER.log(Level.FINE, "Could not access DBA tables", e);
            catalogScope = "ALL";
        }
        LOGGER.log(Level.INFO, (Supplier<String>)new StringFormat("Using Oracle data dictionary catalog scope <%s>", new Object[]{catalogScope}));
        return catalogScope;
    }

    @Override
    public void accept(InformationSchemaViewsBuilder informationSchemaViewsBuilder, Connection connection) {
        if (informationSchemaViewsBuilder == null) {
            LOGGER.log(Level.FINE, "No information schema views builder provided");
            return;
        }
        informationSchemaViewsBuilder.fromResourceFolder("/oracle.information_schema");
        String catalogScope = OracleInformationSchemaViewsBuilder.getCatalogScope(connection);
        informationSchemaViewsBuilder.substituteAll("catalogscope", catalogScope);
    }
}

