/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.zlib;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.modules.zlib.JavaZlibCompObject;
import com.oracle.graal.python.builtins.modules.zlib.ZLibModuleBuiltins;
import com.oracle.graal.python.builtins.objects.bytes.BytesNodes;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.Shape;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.DataFormatException;
import java.util.zip.GZIPInputStream;
import java.util.zip.Inflater;
import java.util.zip.ZipException;

public class JavaDecompress
extends JavaZlibCompObject {
    private static final int HEADER_TRAILER_SIZE = 10;
    private final DecompressStream stream;

    @CompilerDirectives.TruffleBoundary
    private static DecompressStream createStream(int wbits) {
        if (wbits > 24 && wbits <= 31) {
            return new DecompressStream(null);
        }
        Inflater inf = new Inflater(wbits < 0);
        return new DecompressStream(inf);
    }

    public JavaDecompress(Object cls, Shape instanceShape, int wbits, byte[] zdict) {
        super(cls, instanceShape, wbits, zdict);
        this.stream = JavaDecompress.createStream(wbits);
    }

    private static boolean isGZIPStreamReady(DecompressStream stream, byte[] data, int length, boolean force, Node node) {
        assert (!JavaDecompress.isReady(stream));
        stream.in.append(data, 0, length);
        try {
            if (stream.in.length() > 10 || force) {
                stream.stream = new GZIPDecompressStream(stream.in);
                stream.inflater = stream.stream.getInflater();
                stream.stream.fillInput();
                return true;
            }
        }
        catch (ZipException ze) {
            throw PRaiseNode.raiseStatic(node, PythonErrorType.ZLibError, ze);
        }
        catch (IOException e) {
            throw CompilerDirectives.shouldNotReachHere((Throwable)e);
        }
        return false;
    }

    private static boolean isGZIPStreamFinishing(DecompressStream stream, byte[] data, int length, Node node) {
        if (stream.stream != null && stream.inflater.finished()) {
            stream.in.append(data, 0, length);
            try {
                if (stream.in.length() >= 10) {
                    stream.stream.fillInput();
                    stream.stream.read();
                    stream.stream = null;
                }
                return true;
            }
            catch (ZipException ze) {
                throw PRaiseNode.raiseStatic(node, PythonErrorType.ZLibError, ze);
            }
            catch (IOException e) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e);
            }
        }
        return false;
    }

    @CompilerDirectives.TruffleBoundary
    private boolean setInflaterInput(byte[] data, int length, Node node) {
        this.canCopy = this.inputData == null;
        this.inputData = data;
        this.inputLen = length;
        if (!this.isReady()) {
            return JavaDecompress.isGZIPStreamReady(this.stream, data, length, false, node);
        }
        if (JavaDecompress.isGZIPStreamFinishing(this.stream, data, length, node)) {
            return false;
        }
        this.stream.inflater.setInput(data, 0, length);
        return true;
    }

    @CompilerDirectives.TruffleBoundary
    protected JavaDecompress copy(Node node) {
        assert (this.canCopy());
        boolean isRAW = this.wbits < 0;
        JavaDecompress obj = PFactory.createJavaZLibCompObjectDecompress(PythonLanguage.get(node), this.wbits, this.zdict);
        if (isRAW) {
            obj.setDictionary();
        }
        if (this.inputData != null) {
            try {
                if (!obj.setInflaterInput(this.inputData, this.inputLen, node)) {
                    return obj;
                }
                int n = obj.stream.inflater.inflate(new byte[16384]);
                if (!isRAW && n == 0 && obj.stream.inflater.needsDictionary() && this.getZdict().length > 0) {
                    obj.setDictionary();
                    obj.stream.inflater.inflate(new byte[16384]);
                }
            }
            catch (DataFormatException dataFormatException) {
                // empty catch block
            }
        }
        obj.setUnconsumedTail(this.getUnconsumedTail());
        obj.setUnusedData(this.getUnusedData());
        return obj;
    }

    @CompilerDirectives.TruffleBoundary
    private byte[] createByteArray(byte[] bytes, int length, int maxLength, int bufSize, Node nodeForRaise) {
        if (!this.setInflaterInput(bytes, length, nodeForRaise)) {
            return ZLibModuleBuiltins.EMPTY_BYTE_ARRAY;
        }
        int maxLen = maxLength <= 0 ? Integer.MAX_VALUE : maxLength;
        byte[] result = new byte[Math.min(maxLen, bufSize)];
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        boolean zdictIsSet = false;
        while (baos.size() < maxLen && !this.stream.inflater.finished()) {
            int bytesWritten;
            if (this.stream.inflater.needsInput()) {
                if (this.stream.stream == null) break;
                try {
                    this.stream.stream.fillInput();
                }
                catch (EOFException e) {
                    break;
                }
                catch (IOException e) {
                    throw CompilerDirectives.shouldNotReachHere((Throwable)e);
                }
            }
            try {
                int len = Math.min(maxLen - baos.size(), result.length);
                bytesWritten = this.stream.inflater.inflate(result, 0, len);
                if (bytesWritten == 0 && !zdictIsSet && this.stream.inflater.needsDictionary()) {
                    if (this.getZdict().length > 0) {
                        this.setDictionary();
                        zdictIsSet = true;
                        continue;
                    }
                    throw PRaiseNode.raiseStatic(nodeForRaise, PythonErrorType.ZLibError, ErrorMessages.WHILE_SETTING_ZDICT);
                }
            }
            catch (DataFormatException e) {
                throw PRaiseNode.raiseStatic(nodeForRaise, PythonErrorType.ZLibError, e);
            }
            baos.write(result, 0, bytesWritten);
        }
        return baos.toByteArray();
    }

    protected byte[] decompress(VirtualFrame frame, byte[] bytes, int length, int maxLength, int bufSize, Node inliningTarget, BytesNodes.ToBytesNode toBytesNode) {
        byte[] result = this.createByteArray(bytes, length, maxLength, bufSize, inliningTarget);
        if (!this.isReady()) {
            return result;
        }
        this.setEof(this.isFinished());
        byte[] unusedDataBytes = toBytesNode.execute(frame, this.getUnusedData());
        int unconsumedTailLen = this.getUnconsumedTail().getSequenceStorage().length();
        this.saveUnconsumedInput(bytes, length, unusedDataBytes, unconsumedTailLen, inliningTarget);
        return result;
    }

    protected static byte[] decompress(byte[] bytes, int length, int wbits, int bufsize, Node node) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] resultArray = new byte[bufsize];
        DecompressStream stream = JavaDecompress.createStream(wbits);
        try {
            if (!JavaDecompress.isReady(stream)) {
                JavaDecompress.isGZIPStreamReady(stream, bytes, length, true, node);
                while (stream.stream.available() > 0) {
                    int howmany = stream.stream.read(resultArray);
                    baos.write(resultArray, 0, howmany);
                }
            } else {
                stream.inflater.setInput(bytes, 0, length);
                while (!stream.inflater.finished()) {
                    int howmany = stream.inflater.inflate(resultArray);
                    if (howmany == 0 && stream.inflater.needsInput()) {
                        throw PRaiseNode.raiseStatic(node, PythonErrorType.ZLibError, ErrorMessages.ERROR_5_WHILE_DECOMPRESSING);
                    }
                    baos.write(resultArray, 0, howmany);
                }
                stream.inflater.end();
            }
        }
        catch (ZipException ze) {
            throw PRaiseNode.raiseStatic(node, PythonErrorType.ZLibError, ze);
        }
        catch (DataFormatException e) {
            throw PRaiseNode.raiseStatic(node, PythonErrorType.ZLibError, ErrorMessages.WHILE_PREPARING_TO_S_DATA, "decompress");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return baos.toByteArray();
    }

    private void saveUnconsumedInput(byte[] data, int length, byte[] unusedDataBytes, int unconsumedTailLen, Node inliningTarget) {
        int unusedLen = this.getRemaining();
        byte[] tail = PythonUtils.arrayCopyOfRange(data, Math.max(0, length - unusedLen), length);
        PythonLanguage language = PythonLanguage.get(inliningTarget);
        if (this.isEof()) {
            if (unconsumedTailLen > 0) {
                this.setUnconsumedTail(PFactory.createEmptyBytes(language));
            }
            if (unusedDataBytes.length > 0 && tail.length > 0) {
                byte[] newUnusedData = PythonUtils.arrayCopyOf(unusedDataBytes, unusedDataBytes.length + tail.length);
                PythonUtils.arraycopy(tail, 0, newUnusedData, unusedDataBytes.length, tail.length);
                this.setUnusedData(PFactory.createBytes(language, newUnusedData));
            } else if (tail.length > 0) {
                this.setUnusedData(PFactory.createBytes(language, tail));
            }
        } else {
            this.setUnconsumedTail(PFactory.createBytes(language, tail));
        }
    }

    private static boolean isReady(DecompressStream stream) {
        return stream.inflater != null;
    }

    private boolean isReady() {
        return JavaDecompress.isReady(this.stream);
    }

    @CompilerDirectives.TruffleBoundary
    protected void setDictionary() {
        if (this.isReady() && this.getZdict().length > 0) {
            this.stream.inflater.setDictionary(this.getZdict());
        }
    }

    @CompilerDirectives.TruffleBoundary
    private int getRemaining() {
        if (!this.isReady()) {
            return 0;
        }
        return this.stream.inflater.getRemaining();
    }

    @CompilerDirectives.TruffleBoundary
    private boolean isFinished() {
        if (!this.isReady()) {
            return false;
        }
        return this.stream.inflater.finished();
    }

    private static class DecompressStream {
        Inflater inflater;
        GZIPDecompressStream stream;
        protected final ZLibByteInputStream in;

        DecompressStream(Inflater inflater) {
            this.inflater = inflater;
            this.stream = null;
            this.in = inflater == null ? new ZLibByteInputStream(new byte[11], 0, 0) : null;
        }
    }

    private static class ZLibByteInputStream
    extends ByteArrayInputStream {
        public ZLibByteInputStream(byte[] buf, int offset, int length) {
            super(buf, offset, length);
        }

        public void setBuffer(byte[] bytes, int off, int length) {
            this.buf = bytes;
            this.pos = off;
            this.mark = off;
            this.count = length;
        }

        public void append(byte[] bytes, int off, int length) {
            if (this.buf.length == 0) {
                this.setBuffer(bytes, off, length);
                return;
            }
            if (this.buf.length - this.count < length) {
                this.buf = PythonUtils.arrayCopyOf(this.buf, this.buf.length + length);
            }
            if (length >= 0) {
                PythonUtils.arraycopy(bytes, off, this.buf, this.count, length);
            }
            this.count += length;
        }

        public int length() {
            return this.count - this.pos;
        }
    }

    private static class GZIPDecompressStream
    extends GZIPInputStream {
        public GZIPDecompressStream(InputStream in) throws IOException {
            super(in);
        }

        public Inflater getInflater() {
            return this.inf;
        }

        public void fillInput() throws IOException {
            this.fill();
        }
    }
}

