/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import tools.jackson.core.JacksonException;
import tools.jackson.core.util.Snapshottable;
import tools.jackson.databind.BeanProperty;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.DeserializationFeature;
import tools.jackson.databind.util.ClassUtil;

public abstract class InjectableValues
implements Snapshottable<InjectableValues> {
    public static InjectableValues empty() {
        return Empty.INSTANCE;
    }

    public abstract Object findInjectableValue(DeserializationContext var1, Object var2, BeanProperty var3, Object var4, Boolean var5, Boolean var6) throws JacksonException;

    private static final class Empty
    extends Base
    implements Serializable {
        private static final long serialVersionUID = 1L;
        static final Empty INSTANCE = new Empty();

        private Empty() {
        }

        public Empty snapshot() {
            return this;
        }

        @Override
        public Object findInjectableValue(DeserializationContext ctxt, Object valueId, BeanProperty forProperty, Object beanInstance, Boolean optional, Boolean useInput) throws JacksonException {
            String key = this._validateKey(ctxt, valueId, forProperty, beanInstance);
            return this._handleMissingValue(ctxt, key, forProperty, beanInstance, optional, useInput);
        }
    }

    public static class Std
    extends Base
    implements Serializable {
        private static final long serialVersionUID = 1L;
        protected final Map<String, Object> _values;

        public Std() {
            this(new HashMap<String, Object>());
        }

        public Std(Map<String, Object> values) {
            this._values = values;
        }

        public Std addValue(String key, Object value) {
            this._values.put(key, value);
            return this;
        }

        public Std addValue(Class<?> classKey, Object value) {
            this._values.put(classKey.getName(), value);
            return this;
        }

        public Std snapshot() {
            if (this._values.isEmpty()) {
                return new Std();
            }
            return new Std(new HashMap<String, Object>(this._values));
        }

        @Override
        public Object findInjectableValue(DeserializationContext ctxt, Object valueId, BeanProperty forProperty, Object beanInstance, Boolean optional, Boolean useInput) {
            String key = this._validateKey(ctxt, valueId, forProperty, beanInstance);
            Object ob = this._values.get(key);
            if (ob == null && !this._values.containsKey(key)) {
                return this._handleMissingValue(ctxt, key, forProperty, beanInstance, optional, useInput);
            }
            return ob;
        }
    }

    public static abstract class Base
    extends InjectableValues
    implements Serializable {
        private static final long serialVersionUID = 1L;

        protected String _validateKey(DeserializationContext ctxt, Object valueId, BeanProperty forProperty, Object beanInstance) throws JacksonException {
            if (!(valueId instanceof String)) {
                throw ctxt.missingInjectableValueException(String.format("Unsupported injectable value id type (%s), expecting String", ClassUtil.classNameOf(valueId)), valueId, forProperty, beanInstance);
            }
            return (String)valueId;
        }

        protected Object _handleMissingValue(DeserializationContext ctxt, String key, BeanProperty forProperty, Object beanInstance, Boolean optionalConfig, Boolean useInputConfig) throws JacksonException {
            boolean optional = Boolean.TRUE.equals(optionalConfig);
            boolean useInput = Boolean.TRUE.equals(useInputConfig);
            if (optional || !ctxt.isEnabled(DeserializationFeature.FAIL_ON_UNKNOWN_INJECT_VALUE) || useInput && beanInstance != null) {
                return null;
            }
            throw ctxt.missingInjectableValueException(String.format("No injectable value with id '%s' found (for property '%s')", key, forProperty.getName()), key, forProperty, beanInstance);
        }
    }
}

