/*
 * Decompiled with CFR 0.152.
 */
package com.tigervnc.rfb;

import com.tigervnc.network.SSLEngineManager;
import com.tigervnc.rdr.FdInStream;
import com.tigervnc.rdr.FdOutStream;
import com.tigervnc.rdr.SystemException;
import com.tigervnc.rdr.TLSInStream;
import com.tigervnc.rdr.TLSOutStream;
import com.tigervnc.rdr.WarningException;
import com.tigervnc.rfb.AuthFailureException;
import com.tigervnc.rfb.CConnection;
import com.tigervnc.rfb.CSecurity;
import com.tigervnc.rfb.Configuration;
import com.tigervnc.rfb.Exception;
import com.tigervnc.rfb.LogWriter;
import com.tigervnc.rfb.StringParameter;
import com.tigervnc.vncviewer.CConn;
import com.tigervnc.vncviewer.FileUtils;
import com.tigervnc.vncviewer.UserPreferences;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CRL;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CertificateParsingException;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.net.ssl.CertPathTrustManagerParameters;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import javax.swing.JOptionPane;

public class CSecurityTLS
extends CSecurity {
    public static StringParameter X509CA = new StringParameter("X509CA", "X509 CA certificate", "", Configuration.ConfigurationObject.ConfViewer);
    public static StringParameter X509CRL = new StringParameter("X509CRL", "X509 CRL file", "", Configuration.ConfigurationObject.ConfViewer);
    protected CConnection client;
    private SSLContext ctx;
    private SSLEngine engine;
    private SSLEngineManager manager;
    private boolean anon;
    private String cafile;
    private String crlfile;
    private FdInStream is;
    private FdOutStream os;
    static LogWriter vlog = new LogWriter("CSecurityTLS");

    private void initGlobal() {
        try {
            this.ctx = SSLContext.getInstance("TLS");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new Exception(noSuchAlgorithmException.toString());
        }
    }

    public CSecurityTLS(boolean bl) {
        this.anon = bl;
        this.manager = null;
        CSecurityTLS.setDefaults();
        this.cafile = X509CA.getData();
        this.crlfile = X509CRL.getData();
    }

    public static String getDefaultCA() {
        if (UserPreferences.get("viewer", "x509ca") != null) {
            return UserPreferences.get("viewer", "x509ca");
        }
        return FileUtils.getVncConfigDir() + "x509_ca.pem";
    }

    public static String getDefaultCRL() {
        if (UserPreferences.get("viewer", "x509crl") != null) {
            return UserPreferences.get("viewer", "x509crl");
        }
        return FileUtils.getVncConfigDir() + "x509_crl.pem";
    }

    public static void setDefaults() {
        if (new File(CSecurityTLS.getDefaultCA()).exists()) {
            X509CA.setDefaultStr(CSecurityTLS.getDefaultCA());
        }
        if (new File(CSecurityTLS.getDefaultCRL()).exists()) {
            X509CRL.setDefaultStr(CSecurityTLS.getDefaultCRL());
        }
    }

    @Override
    public boolean processMsg(CConnection cConnection) {
        this.is = (FdInStream)cConnection.getInStream();
        this.os = (FdOutStream)cConnection.getOutStream();
        this.client = cConnection;
        this.initGlobal();
        if (this.manager == null) {
            if (!this.is.checkNoWait(1)) {
                return false;
            }
            if (this.is.readU8() == 0) {
                int n = this.is.readU32();
                String string = n == 1 || n == 2 ? this.is.readString() : new String("Authentication failure (protocol error)");
                throw new AuthFailureException(string);
            }
            this.setParam();
        }
        try {
            this.manager = new SSLEngineManager(this.engine, this.is, this.os);
            this.manager.doHandshake();
        }
        catch (java.lang.Exception exception) {
            throw new SystemException(exception.toString());
        }
        cConnection.setStreams(new TLSInStream(this.is, this.manager), new TLSOutStream(this.os, this.manager));
        return true;
    }

    private void setParam() {
        int n;
        TrustManager[] trustManagerArray;
        if (this.anon) {
            try {
                this.ctx.init(null, null, null);
            }
            catch (KeyManagementException keyManagementException) {
                throw new AuthFailureException(keyManagementException.toString());
            }
        }
        try {
            trustManagerArray = new TrustManager[]{new MyX509TrustManager()};
            this.ctx.init(null, trustManagerArray, null);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new AuthFailureException(generalSecurityException.toString());
        }
        trustManagerArray = this.ctx.getSocketFactory();
        this.engine = this.ctx.createSSLEngine(this.client.getServerName(), this.client.getServerPort());
        this.engine.setUseClientMode(true);
        String[] stringArray = this.engine.getSupportedProtocols();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (n = 0; n < stringArray.length; ++n) {
            if (!stringArray[n].matches("TLS.*")) continue;
            arrayList.add(stringArray[n]);
        }
        this.engine.setEnabledProtocols(arrayList.toArray(new String[0]));
        if (this.anon) {
            stringArray = this.engine.getSupportedCipherSuites();
            arrayList = new ArrayList();
            for (n = 0; n < stringArray.length; ++n) {
                if (!stringArray[n].matches("TLS_ECDH_anon.*")) continue;
                arrayList.add(stringArray[n]);
            }
            for (n = 0; n < stringArray.length; ++n) {
                if (!stringArray[n].matches("TLS_DH_anon.*")) continue;
                arrayList.add(stringArray[n]);
            }
            this.engine.setEnabledCipherSuites(arrayList.toArray(new String[0]));
        } else {
            this.engine.setEnabledCipherSuites(this.engine.getSupportedCipherSuites());
        }
    }

    @Override
    public final int getType() {
        return this.anon ? 257 : 260;
    }

    @Override
    public final String description() {
        return this.anon ? "TLS Encryption without VncAuth" : "X509 Encryption without VncAuth";
    }

    @Override
    public boolean isSecure() {
        return !this.anon;
    }

    class MyX509TrustManager
    implements X509TrustManager {
        X509TrustManager tm;
        private final char[] hexCode = "0123456789ABCDEF".toCharArray();

        MyX509TrustManager() throws GeneralSecurityException {
            KeyStore keyStore = KeyStore.getInstance("JKS");
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            try {
                keyStore.load(null, null);
                String string = TrustManagerFactory.getDefaultAlgorithm();
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(string);
                trustManagerFactory.init((KeyStore)null);
                for (TrustManager object2 : trustManagerFactory.getTrustManagers()) {
                    if (!(object2 instanceof X509TrustManager)) continue;
                    for (X509Certificate x509Certificate : ((X509TrustManager)object2).getAcceptedIssuers()) {
                        keyStore.setCertificateEntry(this.getThumbprint(x509Certificate), x509Certificate);
                    }
                }
                File file = new File(CSecurityTLS.this.cafile);
                if (file.exists() && file.canRead()) {
                    MyFileInputStream myFileInputStream = new MyFileInputStream(file);
                    Collection<? extends Certificate> collection = certificateFactory.generateCertificates(myFileInputStream);
                    for (Certificate certificate : collection) {
                        String string2 = this.getThumbprint((X509Certificate)certificate);
                        keyStore.setCertificateEntry(string2, (X509Certificate)certificate);
                    }
                }
                PKIXBuilderParameters pKIXBuilderParameters = new PKIXBuilderParameters(keyStore, (CertSelector)new X509CertSelector());
                File file2 = new File(CSecurityTLS.this.crlfile);
                if (!file2.exists() || !file2.canRead()) {
                    pKIXBuilderParameters.setRevocationEnabled(false);
                } else {
                    FileInputStream fileInputStream = new FileInputStream(CSecurityTLS.this.crlfile);
                    Collection<? extends CRL> collection = certificateFactory.generateCRLs(fileInputStream);
                    CollectionCertStoreParameters collectionCertStoreParameters = new CollectionCertStoreParameters(collection);
                    CertStore certStore = CertStore.getInstance("Collection", collectionCertStoreParameters);
                    pKIXBuilderParameters.addCertStore(certStore);
                    pKIXBuilderParameters.setRevocationEnabled(true);
                }
                trustManagerFactory = TrustManagerFactory.getInstance("PKIX");
                trustManagerFactory.init(new CertPathTrustManagerParameters(pKIXBuilderParameters));
                this.tm = (X509TrustManager)trustManagerFactory.getTrustManagers()[0];
            }
            catch (java.lang.Exception exception) {
                throw new Exception(exception.getMessage());
            }
        }

        @Override
        public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
            this.tm.checkClientTrusted(x509CertificateArray, string);
        }

        private String printHexBinary(byte[] byArray) {
            StringBuilder stringBuilder = new StringBuilder(byArray.length * 2);
            for (byte by : byArray) {
                stringBuilder.append(this.hexCode[by >> 4 & 0xF]);
                stringBuilder.append(this.hexCode[by & 0xF]);
            }
            return stringBuilder.toString();
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
            String string2;
            X509Certificate x509Certificate;
            block17: {
                Object var3_3 = null;
                x509Certificate = x509CertificateArray[0];
                string2 = Base64.getEncoder().encodeToString(x509Certificate.getPublicKey().getEncoded());
                try {
                    x509Certificate.checkValidity();
                    this.verifyHostname(x509Certificate);
                }
                catch (CertificateParsingException certificateParsingException) {
                    throw new SystemException(certificateParsingException.getMessage());
                }
                catch (CertificateNotYetValidException certificateNotYetValidException) {
                    throw new AuthFailureException("server certificate has not been activated");
                }
                catch (CertificateExpiredException certificateExpiredException) {
                    if (CSecurity.msg.showMsgBox(0, "certificate has expired", "The certificate of the server has expired, do you want to continue?")) break block17;
                    throw new AuthFailureException("server certificate has expired");
                }
            }
            File file = new File(FileUtils.getVncStateDir());
            if (!file.exists()) {
                try {
                    file.mkdir();
                }
                catch (SecurityException securityException) {
                    throw new AuthFailureException("Could not obtain VNC state directory path for known hosts storage");
                }
            }
            File file2 = new File(file, "x509_known_hosts");
            String string3 = "  Subject: " + x509Certificate.getSubjectX500Principal().getName() + "\n  Issuer: " + x509Certificate.getIssuerX500Principal().getName() + "\n  Serial Number: " + x509Certificate.getSerialNumber() + "\n  Version: " + x509Certificate.getVersion() + "\n  Signature Algorithm: " + x509Certificate.getPublicKey().getAlgorithm() + "\n  Not Valid Before: " + x509Certificate.getNotBefore() + "\n  Not Valid After: " + x509Certificate.getNotAfter() + "\n  SHA-1 Fingerprint: " + this.getThumbprint(x509Certificate) + "\n";
            try {
                if (file2.exists()) {
                    String string4;
                    FileReader fileReader = new FileReader(file2);
                    BufferedReader bufferedReader = new BufferedReader(fileReader);
                    String string5 = CSecurityTLS.this.client.getServerName().toLowerCase();
                    while ((string4 = bufferedReader.readLine()) != null) {
                        String[] stringArray = string4.split("\\|");
                        if (stringArray.length != 6) continue;
                        if (string5.equals(stringArray[2]) && string2.equals(stringArray[5])) {
                            vlog.debug("Server certificate found in known hosts file", new Object[0]);
                            bufferedReader.close();
                            return;
                        }
                        if ((!string5.equals(stringArray[2]) || string2.equals(stringArray[5])) && (string5.equals(stringArray[2]) || !string2.equals(stringArray[5]))) continue;
                        throw new CertStoreException();
                    }
                    bufferedReader.close();
                }
                this.tm.checkServerTrusted(x509CertificateArray, string);
            }
            catch (IOException iOException) {
                throw new AuthFailureException("Could not load known hosts database");
            }
            catch (CertStoreException certStoreException) {
                vlog.debug("Server host key mismatch", new Object[0]);
                vlog.debug(string3, new Object[0]);
                String string6 = "This host is previously known with a different certificate, and the new certificate has been signed by an unknown authority\n\n" + string3 + "\nSomeone could be trying to impersonate the site and you should not continue.\n\nDo you want to make an exception for this server?";
                if (!CSecurity.msg.showMsgBox(0, "Unexpected certificate issuer", string6)) {
                    throw new AuthFailureException("Unexpected certificate issuer");
                }
                this.store_pubkey(file2, CSecurityTLS.this.client.getServerName().toLowerCase(), string2);
            }
            catch (java.lang.Exception exception) {
                if (exception.getCause() instanceof CertPathBuilderException) {
                    vlog.debug("Server host not previously known", new Object[0]);
                    vlog.debug(string3, new Object[0]);
                    String string7 = "This certificate has been signed by an unknown authority\n\n" + string3 + "\nSomeone could be trying to impersonate the site and you should not continue.\n\nDo you want to make an exception for this server?";
                    if (!CSecurity.msg.showMsgBox(0, "Unknown certificate issuer", string7)) {
                        throw new AuthFailureException("Unknown certificate issuer");
                    }
                    this.store_pubkey(file2, CSecurityTLS.this.client.getServerName().toLowerCase(), string2);
                }
                throw new SystemException(exception.getMessage());
            }
        }

        private void store_pubkey(File file, String string, String string2) {
            Object object;
            Closeable closeable;
            ArrayList<String> arrayList = new ArrayList<String>();
            try {
                if (file.exists()) {
                    String string3;
                    closeable = new FileReader(file);
                    object = new BufferedReader((Reader)closeable);
                    while ((string3 = ((BufferedReader)object).readLine()) != null) {
                        String[] stringArray = string3.split("\\|");
                        if (stringArray.length != 6 || string.equals(stringArray[2]) || string2.equals(stringArray[5])) continue;
                        arrayList.add(string3);
                    }
                    ((BufferedReader)object).close();
                }
            }
            catch (IOException iOException) {
                throw new AuthFailureException("Could not load known hosts database");
            }
            try {
                if (!file.exists()) {
                    file.createNewFile();
                }
                closeable = new FileWriter(file.getAbsolutePath(), false);
                object = arrayList.iterator();
                while (object.hasNext()) {
                    ((Writer)closeable).write((String)object.next() + "\n");
                }
                ((Writer)closeable).write("|g0|" + string + "|*|0|" + string2 + "\n");
                ((OutputStreamWriter)closeable).close();
            }
            catch (IOException iOException) {
                vlog.error("Failed to store server certificate to known hosts database", new Object[0]);
            }
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return this.tm.getAcceptedIssuers();
        }

        private String getThumbprint(X509Certificate x509Certificate) {
            String string = null;
            try {
                MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
                messageDigest.update(x509Certificate.getEncoded());
                string = this.printHexBinary(messageDigest.digest());
                string = string.replaceAll("..(?!$)", "$0 ");
            }
            catch (CertificateEncodingException certificateEncodingException) {
                throw new SystemException(certificateEncodingException.getMessage());
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new SystemException(noSuchAlgorithmException.getMessage());
            }
            return string;
        }

        private void verifyHostname(X509Certificate x509Certificate) throws CertificateParsingException {
            try {
                Object[] objectArray;
                Collection<List<?>> collection = x509Certificate.getSubjectAlternativeNames();
                if (collection == null) {
                    objectArray = x509Certificate.getSubjectX500Principal().getName();
                    LdapName object = new LdapName((String)objectArray);
                    for (Rdn rdn : object.getRdns()) {
                        String string;
                        if (!rdn.getType().equalsIgnoreCase("CN") || !(string = CSecurityTLS.this.client.getServerName().toLowerCase()).equals(((String)rdn.getValue()).toLowerCase())) continue;
                        return;
                    }
                } else {
                    for (List n : collection) {
                        String string;
                        if (!((Integer)n.get(0) == 2 ? (string = CSecurityTLS.this.client.getServerName().toLowerCase()).equals(((String)n.get(1)).toLowerCase()) : (Integer)n.get(0) == 7 && (string = ((CConn)CSecurityTLS.this.client).getSocket().getPeerAddress()).equals(((String)n.get(1)).toLowerCase()))) continue;
                        return;
                    }
                }
                objectArray = new Object[]{"YES", "NO"};
                int n = JOptionPane.showOptionDialog(null, "Hostname (" + CSecurityTLS.this.client.getServerName() + ") does not match the server certificate, do you want to continue?", "Certificate hostname mismatch", 0, 2, null, objectArray, objectArray[0]);
                if (n != 0) {
                    throw new WarningException("Certificate hostname mismatch.");
                }
            }
            catch (CertificateParsingException certificateParsingException) {
                throw new SystemException(certificateParsingException.getMessage());
            }
            catch (InvalidNameException invalidNameException) {
                throw new SystemException(invalidNameException.getMessage());
            }
        }

        private class MyFileInputStream
        extends InputStream {
            ByteBuffer buf;

            public MyFileInputStream(String string) {
                this(new File(string));
            }

            public MyFileInputStream(File file) {
                Object object;
                StringBuffer stringBuffer = new StringBuffer();
                BufferedReader bufferedReader = null;
                try {
                    bufferedReader = new BufferedReader(new FileReader(file));
                    while ((object = bufferedReader.readLine()) != null) {
                        if (((String)object).trim().length() <= 0) continue;
                        stringBuffer.append((String)object + "\n");
                    }
                }
                catch (java.lang.Exception exception) {
                    throw new Exception(exception.toString());
                }
                finally {
                    try {
                        if (bufferedReader != null) {
                            bufferedReader.close();
                        }
                    }
                    catch (IOException iOException) {
                        throw new Exception(iOException.getMessage());
                    }
                }
                object = Charset.forName("UTF-8");
                this.buf = ByteBuffer.wrap(stringBuffer.toString().getBytes((Charset)object));
                this.buf.limit(this.buf.capacity());
            }

            @Override
            public int read(byte[] byArray) throws IOException {
                return this.read(byArray, 0, byArray.length);
            }

            @Override
            public int read(byte[] byArray, int n, int n2) throws IOException {
                if (!this.buf.hasRemaining()) {
                    return -1;
                }
                n2 = Math.min(n2, this.buf.remaining());
                this.buf.get(byArray, n, n2);
                return n2;
            }

            @Override
            public int read() throws IOException {
                if (!this.buf.hasRemaining()) {
                    return -1;
                }
                return this.buf.get() & 0xFF;
            }
        }
    }
}

