# --------------------------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
#
# Code generated by aaz-dev-tools
# --------------------------------------------------------------------------------------------

# pylint: skip-file
# flake8: noqa

from azure.cli.core.aaz import *


@register_command(
    "eventhubs namespace application-group create",
)
class Create(AAZCommand):
    """Create an ApplicationGroup for a Namespace.
    """

    _aaz_info = {
        "version": "2023-01-01-preview",
        "resources": [
            ["mgmt-plane", "/subscriptions/{}/resourcegroups/{}/providers/microsoft.eventhub/namespaces/{}/applicationgroups/{}", "2023-01-01-preview"],
        ]
    }

    def _handler(self, command_args):
        super()._handler(command_args)
        self._execute_operations()
        return self._output()

    _args_schema = None

    @classmethod
    def _build_arguments_schema(cls, *args, **kwargs):
        if cls._args_schema is not None:
            return cls._args_schema
        cls._args_schema = super()._build_arguments_schema(*args, **kwargs)

        # define Arg Group ""

        _args_schema = cls._args_schema
        _args_schema.application_group_name = AAZStrArg(
            options=["-n", "--name", "--application-group-name"],
            help="The Application Group name ",
            required=True,
            fmt=AAZStrArgFormat(
                max_length=256,
                min_length=1,
            ),
        )
        _args_schema.namespace_name = AAZStrArg(
            options=["--namespace-name"],
            help="The Namespace name",
            required=True,
            fmt=AAZStrArgFormat(
                max_length=50,
                min_length=6,
            ),
        )
        _args_schema.resource_group = AAZResourceGroupNameArg(
            required=True,
        )

        # define Arg Group "Properties"

        _args_schema = cls._args_schema
        _args_schema.client_app_group_identifier = AAZStrArg(
            options=["--client-app-group-id", "--client-app-group-identifier"],
            arg_group="Properties",
            help="The Unique identifier for application group.Supports SAS(SASKeyName=KeyName) or AAD(AADAppID=Guid)",
        )
        _args_schema.is_enabled = AAZBoolArg(
            options=["--is-enabled"],
            arg_group="Properties",
            help="Determines if Application Group is allowed to create connection with namespace or not. Once the isEnabled is set to false, all the existing connections of application group gets dropped and no new connections will be allowed",
        )
        _args_schema.policies = AAZListArg(
            options=["--policies"],
            arg_group="Properties",
            help="List of group policies that define the behavior of application group. The policies can support resource governance scenarios such as limiting ingress or egress traffic.",
        )

        policies = cls._args_schema.policies
        policies.Element = AAZObjectArg()

        _element = cls._args_schema.policies.Element
        _element.throttling_policy = AAZObjectArg(
            options=["throttling-policy"],
        )
        _element.name = AAZStrArg(
            options=["name"],
            help="The Name of this policy",
            required=True,
        )

        throttling_policy = cls._args_schema.policies.Element.throttling_policy
        throttling_policy.metric_id = AAZStrArg(
            options=["metric-id"],
            help="Metric Id on which the throttle limit should be set, MetricId can be discovered by hovering over Metric in the Metrics section of Event Hub Namespace inside Azure Portal",
            required=True,
            enum={"IncomingBytes": "IncomingBytes", "IncomingMessages": "IncomingMessages", "OutgoingBytes": "OutgoingBytes", "OutgoingMessages": "OutgoingMessages"},
        )
        throttling_policy.rate_limit_threshold = AAZIntArg(
            options=["rate-limit-threshold"],
            help="The Threshold limit above which the application group will be throttled.Rate limit is always per second.",
            required=True,
        )
        return cls._args_schema

    def _execute_operations(self):
        self.pre_operations()
        self.ApplicationGroupCreateOrUpdateApplicationGroup(ctx=self.ctx)()
        self.post_operations()

    @register_callback
    def pre_operations(self):
        pass

    @register_callback
    def post_operations(self):
        pass

    def _output(self, *args, **kwargs):
        result = self.deserialize_output(self.ctx.vars.instance, client_flatten=True)
        return result

    class ApplicationGroupCreateOrUpdateApplicationGroup(AAZHttpOperation):
        CLIENT_TYPE = "MgmtClient"

        def __call__(self, *args, **kwargs):
            request = self.make_request()
            session = self.client.send_request(request=request, stream=False, **kwargs)
            if session.http_response.status_code in [200]:
                return self.on_200(session)

            return self.on_error(session.http_response)

        @property
        def url(self):
            return self.client.format_url(
                "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventHub/namespaces/{namespaceName}/applicationGroups/{applicationGroupName}",
                **self.url_parameters
            )

        @property
        def method(self):
            return "PUT"

        @property
        def error_format(self):
            return "MgmtErrorFormat"

        @property
        def url_parameters(self):
            parameters = {
                **self.serialize_url_param(
                    "applicationGroupName", self.ctx.args.application_group_name,
                    required=True,
                ),
                **self.serialize_url_param(
                    "namespaceName", self.ctx.args.namespace_name,
                    required=True,
                ),
                **self.serialize_url_param(
                    "resourceGroupName", self.ctx.args.resource_group,
                    required=True,
                ),
                **self.serialize_url_param(
                    "subscriptionId", self.ctx.subscription_id,
                    required=True,
                ),
            }
            return parameters

        @property
        def query_parameters(self):
            parameters = {
                **self.serialize_query_param(
                    "api-version", "2023-01-01-preview",
                    required=True,
                ),
            }
            return parameters

        @property
        def header_parameters(self):
            parameters = {
                **self.serialize_header_param(
                    "Content-Type", "application/json",
                ),
                **self.serialize_header_param(
                    "Accept", "application/json",
                ),
            }
            return parameters

        @property
        def content(self):
            _content_value, _builder = self.new_content_builder(
                self.ctx.args,
                typ=AAZObjectType,
                typ_kwargs={"flags": {"required": True, "client_flatten": True}}
            )
            _builder.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})

            properties = _builder.get(".properties")
            if properties is not None:
                properties.set_prop("clientAppGroupIdentifier", AAZStrType, ".client_app_group_identifier", typ_kwargs={"flags": {"required": True}})
                properties.set_prop("isEnabled", AAZBoolType, ".is_enabled")
                properties.set_prop("policies", AAZListType, ".policies")

            policies = _builder.get(".properties.policies")
            if policies is not None:
                policies.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".properties.policies[]")
            if _elements is not None:
                _elements.set_prop("name", AAZStrType, ".name", typ_kwargs={"flags": {"required": True}})
                _elements.set_const("type", "ThrottlingPolicy", AAZStrType, ".throttling_policy", typ_kwargs={"flags": {"required": True}})
                _elements.discriminate_by("type", "ThrottlingPolicy")

            disc_throttling_policy = _builder.get(".properties.policies[]{type:ThrottlingPolicy}")
            if disc_throttling_policy is not None:
                disc_throttling_policy.set_prop("metricId", AAZStrType, ".throttling_policy.metric_id", typ_kwargs={"flags": {"required": True}})
                disc_throttling_policy.set_prop("rateLimitThreshold", AAZIntType, ".throttling_policy.rate_limit_threshold", typ_kwargs={"flags": {"required": True}})

            return self.serialize_content(_content_value)

        def on_200(self, session):
            data = self.deserialize_http_content(session)
            self.ctx.set_var(
                "instance",
                data,
                schema_builder=self._build_schema_on_200
            )

        _schema_on_200 = None

        @classmethod
        def _build_schema_on_200(cls):
            if cls._schema_on_200 is not None:
                return cls._schema_on_200

            cls._schema_on_200 = AAZObjectType()

            _schema_on_200 = cls._schema_on_200
            _schema_on_200.id = AAZStrType(
                flags={"read_only": True},
            )
            _schema_on_200.location = AAZStrType(
                flags={"read_only": True},
            )
            _schema_on_200.name = AAZStrType(
                flags={"read_only": True},
            )
            _schema_on_200.properties = AAZObjectType(
                flags={"client_flatten": True},
            )
            _schema_on_200.system_data = AAZObjectType(
                serialized_name="systemData",
                flags={"read_only": True},
            )
            _schema_on_200.type = AAZStrType(
                flags={"read_only": True},
            )

            properties = cls._schema_on_200.properties
            properties.client_app_group_identifier = AAZStrType(
                serialized_name="clientAppGroupIdentifier",
                flags={"required": True},
            )
            properties.is_enabled = AAZBoolType(
                serialized_name="isEnabled",
            )
            properties.policies = AAZListType()

            policies = cls._schema_on_200.properties.policies
            policies.Element = AAZObjectType()

            _element = cls._schema_on_200.properties.policies.Element
            _element.name = AAZStrType(
                flags={"required": True},
            )
            _element.type = AAZStrType(
                flags={"required": True},
            )

            disc_throttling_policy = cls._schema_on_200.properties.policies.Element.discriminate_by("type", "ThrottlingPolicy")
            disc_throttling_policy.metric_id = AAZStrType(
                serialized_name="metricId",
                flags={"required": True},
            )
            disc_throttling_policy.rate_limit_threshold = AAZIntType(
                serialized_name="rateLimitThreshold",
                flags={"required": True},
            )

            system_data = cls._schema_on_200.system_data
            system_data.created_at = AAZStrType(
                serialized_name="createdAt",
            )
            system_data.created_by = AAZStrType(
                serialized_name="createdBy",
            )
            system_data.created_by_type = AAZStrType(
                serialized_name="createdByType",
            )
            system_data.last_modified_at = AAZStrType(
                serialized_name="lastModifiedAt",
            )
            system_data.last_modified_by = AAZStrType(
                serialized_name="lastModifiedBy",
            )
            system_data.last_modified_by_type = AAZStrType(
                serialized_name="lastModifiedByType",
            )

            return cls._schema_on_200


class _CreateHelper:
    """Helper class for Create"""


__all__ = ["Create"]
