.\" shorthand for double quote that works everywhere.
.ds q \N'34'
.TH MODESETTING @drivermansuffix@ @vendorversion@
.SH NAME
modesetting \- video driver for framebuffer device
.SH SYNOPSIS
.nf
.B "Section \*qDevice\*q"
.BI "  Identifier \*q"  devname \*q
.B  "  Driver \*qmodesetting\*q"
.BI "  BusID  \*qpci:" bus : dev : func \*q
\ \ ...
.B EndSection
.fi
.SH DESCRIPTION
.B modesetting
is an @xservername@ driver for KMS devices.  This driver supports
TrueColor visuals at framebuffer depths of 15, 16, 24, and 30. RandR
1.2 is supported for multi-head configurations. Acceleration is available
through glamor for devices supporting at least OpenGL ES 2.0 or OpenGL 2.1.
If glamor is not enabled, a shadow framebuffer is configured based on the
KMS drivers' preference (unless the framebuffer is 24 bits per pixel, in
which case the shadow framebuffer is always used).
.SH SUPPORTED HARDWARE
The
.B modesetting
driver supports all hardware where a KMS driver is available.
modesetting uses the Linux DRM KMS ioctls and dumb object create/map.
.SH CONFIGURATION DETAILS
Please refer to
.BR @xconfigfile@ (@filemansuffix@)
for general configuration details.
This section only covers configuration details specific to this driver.
.PP
For this driver it is not required to specify modes in the screen
section of the config file.  The
.B modesetting
driver can pick up the currently used video mode from the kernel
driver and will use it if there are no video modes configured.
.PP
For PCI boards you might have to add a BusID line to the Device
section.  See above for a sample line.
.PP
The following driver
.B Options
are supported:
.TP
.BI "Option \*qSWcursor\*q \*q" boolean \*q
Selects software cursor.  The default is
.B off.
.TP
.BI "Option \*qCursorSize\*q \*q" string \*q
The size of the cursor.
By default we use various probes to determine what cursor size to use.
If for some reason these probes don't work, or you just want to use
a different size, use this option.
The value is passed as either "<width>x<height>", or "<one number for square size>"

Note: On failure (for example the hardware doesn't support the chosen size)
the X server silently falls back to software cursor.
.TP
.BI "Option \*qkmsdev\*q \*q" string \*q
The framebuffer device to use. Default: /dev/dri/card0.
.TP
.BI "Option \*qShadowFB\*q \*q" boolean \*q
Enable or disable use of the shadow framebuffer layer.  Default: on.
.TP
.BI "Option \*qDoubleShadow\*q \*q" boolean \*q
Double-buffer shadow updates. When enabled, the driver will keep two copies of
the shadow framebuffer. When the shadow framebuffer is flushed, the old and new
versions of the shadow are compared, and only tiles that have actually changed
are uploaded to the device. This is an optimization for server-class GPUs with
a remote display function (typically VNC), where remote updates are triggered
by any framebuffer write, so minimizing the amount of data uploaded is crucial.
This defaults to enabled for ASPEED and Matrox G200 devices, and disabled
otherwise.
.TP
.BI "Option \*qAccelMethod\*q \*q" string \*q
One of \*qglamor\*q or \*qnone\*q.  Default: glamor.
.TP
.BI "Option \*qPageFlip\*q \*q" boolean \*q
Enable DRI3 page flipping.  The default is
.B on.
.TP
.BI "Option \*qVariableRefresh\*q \*q" boolean \*q
Enables support for enabling variable refresh on the Screen's CRTCs
when an suitable application is flipping via the Present extension.
.br
The default is
.B off.
.TP
.BI "Option \*qAsyncFlipSecondaries\*q \*q" boolean \*q
Use async flips for secondary video outputs on multi-display setups. If a screen
has multiple displays attached and DRI3 page flipping is used, then only one of
the displays will have its page flip synchronized to vblank for tear-free
presentation. This is the display that is used for presentation timing and
timestamping, usually the one covering the biggest pixel area of the screen.
All other displays ("Secondaries") will not synchronize their flips. This may
cause some tearing on these displays, but it prevents a permanent or periodic
slowdown or irritating judder of animations if not all video outputs are running
synchronized with each other and with the same refresh rate. There is no perfect
solution apart from perfectly synchronized outputs, but this option may give
preferrable results if the displays in a multi-display setup mirror or clone
each other.  The default is
.B off.
.TP
.BI "Option \*qZaphodHeads\*q \*q" string \*q
Specify the RandR output(s) to use with zaphod mode for a particular driver
instance.  If you use this option you must use this option for all instances
of the driver.
.br
For example:
.B
Option \*qZaphodHeads\*q \*qLVDS,VGA-0\*q
will assign xrandr outputs LVDS and VGA-0 to this instance of the driver.
.TP
.BI "Option \*qUseGammaLUT\*q \*q" boolean \*q
Enable or disable use of the GAMMA_LUT property, when available.
When enabled, this option allows the driver to use gamma ramps with more
entries, if supported by the kernel. By default, GAMMA_LUT will be used for
kms drivers which are known to be safe for use of GAMMA_LUT.
.TP
.BI "Option \*qTearFree\*q \*q" boolean \*q
Enable tearing prevention using the hardware page flipping mechanism.
It allocates two extra scanout buffers for each CRTC and utilizes damage
tracking to minimize buffer copying and skip unnecessary flips when the
screen's contents have not changed. It works on transformed screens too, such
as rotated and scaled CRTCs. When PageFlip is enabled, fullscreen DRI
applications will still have the discretion to not use tearing prevention.
.br
The default is
.B on.
.TP
.BI "Option \*qAtomic\*q \*q" boolean \*q
Enable atomic modesetting when supported.  The default is
.B off.
.TP
.SH "SEE ALSO"
.BR @xservername@ (@appmansuffix@),
.BR @xconfigfile@ (@filemansuffix@),
.BR Xserver (@appmansuffix@),
.BR X (@miscmansuffix@)
.SH AUTHORS
Authors include: Dave Airlie
