import type { ArtixRepo } from 'artix-checkupdates';
import type { ArtoolsConf } from './artoolsconf.mts';
export interface PusherConfig {
    gpgpass?: string;
}
export type ArtixpkgRepo = ArtixRepo | 'stable' | 'gremlins' | 'goblins';
export interface Job extends Partial<ArtoolsConf> {
    source?: ArtixpkgRepo;
    repo: ArtixpkgRepo;
    increment: boolean;
    nocheck: boolean;
    rebuild: boolean;
    packages: string[];
    nextTag: boolean;
}
export declare class Pusher {
    private _gitea;
    private _gitlab;
    private _config;
    private _artools;
    private _createdSignfile;
    constructor(config?: PusherConfig, artoolsConf?: ArtoolsConf);
    refreshGpg(): Promise<void>;
    increment(pkg: string): Promise<void>;
    isNewPackage(pkg: string): Promise<boolean>;
    createRepoImportArgs(job: Job, packageName: string): Promise<string[]>;
    runJob(job: Job): Promise<void>;
}
export default Pusher;
