/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model.impls;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.ext.postgresql.model.impls.PostgreServerExtensionBase;
import org.jkiss.utils.CommonUtils;
import org.osgi.framework.Version;

public class PostgreServerYugabyteDB
extends PostgreServerExtensionBase {
    private static final Log log = Log.getLog(PostgreServerYugabyteDB.class);
    private Version yugabyteVersion;

    public PostgreServerYugabyteDB(PostgreDataSource dataSource) {
        super(dataSource);
    }

    @Override
    public String getServerTypeName() {
        return "YugabyteDB";
    }

    private boolean isYugabyteVersionAtLeast(int major, int minor) {
        String serverVersion;
        if (this.yugabyteVersion == null && !CommonUtils.isEmpty((String)(serverVersion = this.dataSource.getServerVersion()))) {
            try {
                String versionStr;
                Matcher matcher = Pattern.compile(".*-YB-([0-9]*\\.[0-9]*).*").matcher(serverVersion);
                if (matcher.find() && !CommonUtils.isEmpty((String)(versionStr = matcher.group(1)))) {
                    this.yugabyteVersion = new Version(versionStr);
                }
            }
            catch (Exception e) {
                log.debug((Object)"Error reading YugabyteDB version", (Throwable)e);
                this.yugabyteVersion = new Version(2, 0, 0);
            }
        }
        if (this.yugabyteVersion != null) {
            if (this.yugabyteVersion.getMajor() > major) {
                return true;
            }
            if (this.yugabyteVersion.getMajor() == major && this.yugabyteVersion.getMinor() >= minor) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean supportsOids() {
        return true;
    }

    @Override
    public boolean supportsIndexes() {
        return true;
    }

    @Override
    public boolean supportsMaterializedViews() {
        return this.isYugabyteVersionAtLeast(2, 13);
    }

    @Override
    public boolean supportsPartitions() {
        return this.isYugabyteVersionAtLeast(2, 4);
    }

    @Override
    public boolean supportsInheritance() {
        return this.isYugabyteVersionAtLeast(2, 4);
    }

    @Override
    public boolean supportsTriggers() {
        return true;
    }

    @Override
    public boolean supportsFunctionCreate() {
        return true;
    }

    @Override
    public boolean supportsRules() {
        return true;
    }

    @Override
    public boolean supportsRowLevelSecurity() {
        return true;
    }

    @Override
    public boolean supportsExtensions() {
        return true;
    }

    @Override
    public boolean supportsEncodings() {
        return true;
    }

    @Override
    public boolean supportsTablespaces() {
        return this.isYugabyteVersionAtLeast(2, 12);
    }

    @Override
    public boolean supportsSequences() {
        return true;
    }

    @Override
    public boolean supportsRoles() {
        return true;
    }

    @Override
    public boolean supportsSessionActivity() {
        return true;
    }

    @Override
    public boolean supportsLocks() {
        return true;
    }

    @Override
    public boolean supportsForeignServers() {
        return false;
    }

    @Override
    public boolean supportsAggregates() {
        return true;
    }

    @Override
    public boolean supportsRelationSizeCalc() {
        return false;
    }

    @Override
    public boolean supportsFunctionDefRead() {
        return true;
    }

    @Override
    public boolean supportsExplainPlan() {
        return true;
    }

    @Override
    public boolean supportsExplainPlanVerbose() {
        return true;
    }

    @Override
    public boolean supportsTablespaceLocation() {
        return false;
    }

    @Override
    public boolean supportsExplainPlanXML() {
        return true;
    }
}

