/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project;

import net.sourceforge.plantuml.project.LoadPlanable;
import net.sourceforge.plantuml.project.time.Day;

public class PlanUtils {
    private PlanUtils() {
    }

    public static LoadPlanable minOf(final LoadPlanable p1, final LoadPlanable p2) {
        return new LoadPlanable(){

            @Override
            public int getLoadAt(Day instant) {
                return Math.min(p1.getLoadAt(instant), p2.getLoadAt(instant));
            }

            @Override
            public Day getLastDayIfAny() {
                return PlanUtils.lastOf(p1.getLastDayIfAny(), p2.getLastDayIfAny());
            }
        };
    }

    public static LoadPlanable multiply(final LoadPlanable p1, final LoadPlanable p2) {
        return new LoadPlanable(){

            @Override
            public int getLoadAt(Day instant) {
                return p1.getLoadAt(instant) * p2.getLoadAt(instant) / 100;
            }

            @Override
            public Day getLastDayIfAny() {
                return PlanUtils.lastOf(p1.getLastDayIfAny(), p2.getLastDayIfAny());
            }
        };
    }

    private static Day lastOf(Day day1, Day day2) {
        if (day1 == null) {
            return day2;
        }
        if (day2 == null) {
            return day1;
        }
        if (day1.compareTo(day2) > 0) {
            return day1;
        }
        return day2;
    }
}

