/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.request;

import java.util.HashSet;
import java.util.Set;
import org.apache.solr.client.api.model.CreateCoreBackupRequestBody;
import org.apache.solr.client.api.model.SolrJerseyResponse;
import org.apache.solr.client.solrj.JacksonContentWriter;
import org.apache.solr.client.solrj.JacksonParsingResponse;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.impl.InputStreamResponseParser;
import org.apache.solr.client.solrj.request.RequestWriter;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;

public class CoreBackupsApi {

    public static class CreateBackup
    extends SolrRequest<CreateBackupResponse> {
        private final CreateCoreBackupRequestBody requestBody;
        private final String coreName;

        public CreateBackup(String coreName) {
            super(SolrRequest.METHOD.valueOf("POST"), "/cores/{coreName}/backups".replace("{coreName}", coreName));
            this.coreName = coreName;
            this.requestBody = new CreateCoreBackupRequestBody();
        }

        public void setRepository(String repository) {
            this.requestBody.repository = repository;
        }

        public void setLocation(String location) {
            this.requestBody.location = location;
        }

        public void setShardBackupId(String shardBackupId) {
            this.requestBody.shardBackupId = shardBackupId;
        }

        public void setPrevShardBackupId(String prevShardBackupId) {
            this.requestBody.prevShardBackupId = prevShardBackupId;
        }

        public void setCommitName(String commitName) {
            this.requestBody.commitName = commitName;
        }

        public void setIncremental(Boolean incremental) {
            this.requestBody.incremental = incremental;
        }

        public void setAsync(String async) {
            this.requestBody.async = async;
        }

        public void setBackupName(String backupName) {
            this.requestBody.backupName = backupName;
        }

        @Override
        public RequestWriter.ContentWriter getContentWriter(String _expectedTypeIGNORE) {
            return new JacksonContentWriter(this.requestBody);
        }

        @Override
        public String getRequestType() {
            return SolrRequest.SolrRequestType.ADMIN.toString();
        }

        @Override
        public SolrRequest.ApiVersion getApiVersion() {
            return SolrRequest.ApiVersion.V2;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams();
            return params;
        }

        @Override
        public Set<String> getQueryParams() {
            HashSet<String> queryParams = new HashSet<String>();
            return queryParams;
        }

        @Override
        protected CreateBackupResponse createResponse(SolrClient client) {
            return new CreateBackupResponse();
        }

        @Override
        public ResponseParser getResponseParser() {
            return new InputStreamResponseParser("json");
        }
    }

    public static class CreateBackupResponse
    extends JacksonParsingResponse<SolrJerseyResponse> {
        public CreateBackupResponse() {
            super(SolrJerseyResponse.class);
        }
    }
}

