/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update.processor;

import java.util.Collection;
import java.util.Collections;
import org.apache.solr.common.SolrException;
import org.apache.solr.core.SolrCore;
import org.apache.solr.update.processor.FieldMutatingUpdateProcessor;
import org.apache.solr.update.processor.FieldValueSubsetUpdateProcessorFactory;

public final class MinFieldValueUpdateProcessorFactory
extends FieldValueSubsetUpdateProcessorFactory {
    @Override
    public <T> Collection<T> pickSubset(Collection<T> values) {
        try {
            return Collections.singletonList(Collections.min(values, null));
        }
        catch (ClassCastException e) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Field values are not mutually comparable: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public FieldMutatingUpdateProcessor.FieldNameSelector getDefaultSelector(SolrCore core) {
        return FieldMutatingUpdateProcessor.SELECT_NO_FIELDS;
    }
}

